#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_PreParser_cc__
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinIfExists__
#define __WinIfExists__

/********************************************************/
/* Win __if_exists and __if_not_exists support aspect   */
/********************************************************/

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __stack_h__
#define __stack_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __array_h__
#define __array_h__

#include <assert.h>

namespace Puma {

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class Item>
class Array {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

   protected:
      static const long default_init_size = 5;
      static const long default_increment = 5;

   public:
      Array (long is = default_init_size, long incr = default_increment);
      Array (const Array<Item>& array);
      Array<Item>& operator =(const Array<Item>&);
      ~Array ();
      void append (const Item& item);
      void insert (long index, const Item& item);
      void prepend (const Item& item);
      void remove (long index);
      void reset ();
      Item& get (long index);
      Item& operator[] (long index);
      Item fetch (long index) const;
      Item& lookup (long index) const;
      long length () const;

   private:
      Item* data;
      long size;
      long count;
      long increment;
      
      void check (long wanted);
 };

template <class Item>
inline Array<Item>::Array (long is, long incr)
 {
   count     = 0; 
   size      = is;
   increment = incr;
   data      = new Item[size];
 }

template <class Item>
Array<Item>::Array (const Array<Item>& array)
 {
   count = 0;
   size  = array.size;
   data  = new Item[size];
   increment = array.increment;

   for (int pos = 0; pos < array.length (); pos++)
      append (array.lookup (pos));
 }

template <class Item>
Array<Item>& Array<Item>::operator =(const Array<Item>& array)
 {
   if (data)
      delete[] data;
   count = 0;
   size  = array.size;
   data  = new Item[size];
   increment = array.increment;

   for (int pos = 0; pos < array.length (); pos++)
      append (array.lookup (pos));
   return *this;
 }

template <class Item>
Array<Item>::~Array ()
 {
   if (data)
      delete[] data;
 }

template <class Item>
inline void Array<Item>::check (long wanted)
 {
   if (wanted >= size)
    {
      Item* new_data;

      while (wanted >= size)
      {
         size += increment;
         increment*=2;
      }
      new_data = new Item[size];
      for (int pos = 0; pos < count; pos++)
         new_data[pos] = data[pos];
      delete[] data;
      data = new_data;
    }
 }
   
template <class Item>
inline void Array<Item>::append (const Item& item)
 {
   check (count);
   data[count++] = item;
 }

template <class Item>
void Array<Item>::prepend (const Item& item)
 {
   insert (0, item);
 }

template <class Item>
void Array<Item>::insert (long index, const Item& item)
 {
   check (count);
   for (int pos = count; pos > index; pos--)
      data[pos] = data[pos - 1];
   data[index] = item;
   count++;
 }

template <class Item>
inline Item& Array<Item>::get (long index)
 {
   check (index);
   if (index >= count)
      count = index + 1;
   return data[index];
 }

template <class Item>
inline Item& Array<Item>::operator[] (long index)
 {
   return get (index);
 }

template <class Item>
inline Item Array<Item>::fetch (long index) const
 {
   assert(index < count);
   return data[index];
 }

template <class Item>
inline long Array<Item>::length () const
 {
   return count;
 }

template <class Item>
inline void Array<Item>::remove (long index)
 {
   if (index < count && count > 0)
    {
      for (int pos = index; pos < count - 1; pos++)
         data[pos] = data[pos + 1];
      count--;
    }
 }

#ifndef __puma
template <>
inline void Array<int>::reset () {
   count = 0; 
}
#endif

template <class Item>
void Array<Item>::reset ()
 {
   if (data)
      delete[] data;
   count     = 0; 
   size      = default_init_size;
   increment = default_increment;
   data      = new Item[size];
 }

template <class Item>
inline Item& Array<Item>::lookup (long index) const
 {
   assert(index >= 0 && index < count);
//   if (index >= count) index = count - 1; 
//   if (index < 0)      index = 0;
   return data[index];
 }


} // namespace Puma

// Array specialization for pointer types sharing method definitions

#ifndef __puma

#include "Puma/VoidPtrArray.h"

namespace Puma {


template <class Item>
class Array<Item*> : private VoidPtrArray {
  typedef VoidPtrArray Base;

public:
  Array (long is = default_init_size, long incr = default_increment) :
    Base (is, incr) {}
  Array (const Array<Item*> &array) : 
    Base (array) {}
  Array<Item*> &operator= (const Array<Item*> &array) 
   { return (Array<Item*>&)Base::operator= (array); }

  ~Array () {}

  void append (const Item *item)           { Base::append ((void*)item); }
  void insert (long idx, const Item *item) { Base::insert (idx, (void*)item); }
  void prepend (const Item *item)          { Base::prepend ((void*)item); }
  void remove (long idx)                   { Base::remove (idx); }
  void reset ()                            { Base::reset (); }

  Item *&get (long idx)          { return (Item*&)Base::get (idx); }
  Item *&operator[] (long idx)   { return (Item*&)Base::operator[] (idx); }
  Item *fetch (long idx) const   { return (Item*)Base::fetch (idx); }
  Item *&lookup (long idx) const { return (Item*&)Base::lookup (idx); }
  long length () const           { return Base::length (); }
};


} // namespace Puma

#endif /* __puma */

#endif /* __array_h__ */
namespace Puma {

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class Item>
class Stack : private Array<Item> {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  Stack (long is = 8192, long incr = 8192) :
    Array<Item> (is, incr) {}
  void push (Item f) { Array<Item>::append (f); }
  Item &top () const { long len = Array<Item>::length ()-1; 
                       return Array<Item>::lookup (len >= 0 ? len : 0); }
  void pop () { Array<Item>::remove (Array<Item>::length () - 1); }
  long length () const { return Array<Item>::length (); }
  void reset () { Array<Item>::reset (); }
};

} // namespace Puma

#endif /* __stack_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __C_TOKENS__
#define __C_TOKENS__

namespace Puma {

enum CTokens {

  // core tokens, i.e. numbers, operator symbols, brackets, etc.
  TOK_AT = 100,
  TOK_ZERO_VAL,
  TOK_INT_VAL,
  TOK_FLT_VAL,
  TOK_COMMA,
  TOK_ASSIGN,
  TOK_QUESTION,
  TOK_OR,
  TOK_ROOF,
  TOK_AND,
  TOK_PLUS,
  TOK_MINUS,
  TOK_MUL,
  TOK_DIV,
  TOK_MODULO,
  TOK_LESS,
  TOK_GREATER,
  TOK_OPEN_ROUND,
  TOK_CLOSE_ROUND,
  TOK_OPEN_SQUARE,
  TOK_CLOSE_SQUARE,
  TOK_OPEN_CURLY,
  TOK_CLOSE_CURLY,
  TOK_SEMI_COLON,
  TOK_COLON,
  TOK_NOT,
  TOK_TILDE,
  TOK_DOT,
  TOK_MUL_EQ,
  TOK_DIV_EQ,
  TOK_MOD_EQ,
  TOK_ADD_EQ,
  TOK_SUB_EQ,
  TOK_LSH_EQ,
  TOK_RSH_EQ,
  TOK_AND_EQ,
  TOK_XOR_EQ,
  TOK_IOR_EQ,
  TOK_OR_OR,
  TOK_AND_AND,
  TOK_EQL,
  TOK_NEQ,
  TOK_LEQ,
  TOK_GEQ,
  TOK_LSH,
  TOK_RSH,
  TOK_DOT_STAR,
  TOK_PTS_STAR,
  TOK_INCR,
  TOK_DECR,
  TOK_PTS,
  TOK_COLON_COLON,
  TOK_ELLIPSIS,
  TOK_LAST_CORE = TOK_ELLIPSIS, // this is a group separator for the scanner!
  
  // C keywords:
  TOK_ASM,
  TOK_AUTO,
  TOK_BREAK,
  TOK_CASE,
  TOK_CHAR,
  TOK_CONST,
  TOK_CONTINUE,
  TOK_DEFAULT,
  TOK_DO,
  TOK_DOUBLE,
  TOK_ELSE,
  TOK_ENUM,
  TOK_EXTERN,
  TOK_FLOAT,
  TOK_FOR,
  TOK_GOTO,
  TOK_IF,
  TOK_INLINE,
  TOK_INT,
  TOK_LONG,
  TOK_REGISTER,
  TOK_RESTRICT,
  TOK_RETURN,
  TOK_SHORT,
  TOK_SIGNED,
  TOK_SIZEOF,
  TOK_STATIC,
  TOK_STRUCT,
  TOK_SWITCH,
  TOK_TYPEDEF,
  TOK_UNION,
  TOK_UNSIGNED,
  TOK_VOID,
  TOK_VOLATILE,
  TOK_WCHAR_T,
  TOK_WHILE,

  // C compatibility keywords

  TOK_ASM_2,
  TOK_ASM_3,
  TOK_BOOL_2,
  TOK_CONST_2,
  TOK_CONST_3,
  TOK_INLINE_2,
  TOK_INLINE_3,
  TOK_RESTRICT_2,
  TOK_RESTRICT_3,
  TOK_SIGNED_2,
  TOK_SIGNED_3,
  TOK_VOLATILE_2,
  TOK_VOLATILE_3,
  TOK_WCHAR_T_2,
  TOK_TYPEOF,
  TOK_TYPEOF_2,
  TOK_TYPEOF_3,

  // C win specific keywords

  TOK_INT64,
  TOK_CDECL,
  TOK_CDECL_2,
  TOK_STDCALL,
  TOK_STDCALL_2,
  TOK_FASTCALL,
  TOK_FASTCALL_2,
  TOK_IF_EXISTS,
  TOK_IF_NOT_EXISTS,

  TOK_LAST_C = TOK_IF_NOT_EXISTS,
  
  // a boolean constant:
  TOK_BOOL_VAL,

  // C++ keywords:

  TOK_BOOL,
  TOK_CATCH,
  TOK_CLASS,
  TOK_CONST_CAST,
  TOK_DELETE,
  TOK_DYN_CAST,
  TOK_EXPLICIT,
  TOK_EXPORT,
  TOK_FRIEND,
  TOK_MUTABLE,
  TOK_NAMESPACE,
  TOK_NEW,
  TOK_OPERATOR,
  TOK_PRIVATE,
  TOK_PROTECTED,
  TOK_PUBLIC,
  TOK_REINT_CAST,
  TOK_STAT_CAST,
  TOK_TEMPLATE,
  TOK_THIS,
  TOK_THROW,
  TOK_TRY,
  TOK_TYPEID,
  TOK_TYPENAME,
  TOK_USING,
  TOK_VIRTUAL,

  // C++ alternative representation of operators (ISO 646):

  TOK_AND_AND_ISO_646,
  TOK_AND_EQ_ISO_646,
  TOK_AND_ISO_646,
  TOK_OR_ISO_646,
  TOK_TILDE_ISO_646,
  TOK_NOT_ISO_646,
  TOK_NEQ_ISO_646,
  TOK_OR_OR_ISO_646,
  TOK_IOR_EQ_ISO_646,
  TOK_ROOF_ISO_646,
  TOK_XOR_EQ_ISO_646,

  TOK_LAST_CC = TOK_XOR_EQ_ISO_646,
  
  // AspectC++ keywords:

  TOK_POINTCUT,
  TOK_ASPECT,
  TOK_ADVICE,
  TOK_SLICE,
  TOK_UNKNOWN_T,

  TOK_LAST_AC = TOK_UNKNOWN_T,
  
  // further [A](C|C++) token
  TOK_STRING_VAL,
  TOK_CHAR_VAL,
  TOK_ID,

  // These two always have to be the ** last ** token listed here!!!
  TOK_EPSILON,
  TOK_NO
  
};

} // namespace Puma

#endif /* __C_TOKENS__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Token_h__
#define __Token_h__

// Abstract interface of a language token. A token is created by an
// invocation of a scanner's 'scan' method. The token encapsulates a
// lexical unit of the scanned text.

#include <stdlib.h>
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __language_id_h__
#define __language_id_h__

// A language ID is a unique identifier for a language

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class LanguageID {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_id;

public:
  LanguageID () : _id ((const char*)0) {}
  LanguageID (const char *id) : _id (id) {}
  operator const char *() const { return _id; }
  bool operator == (const LanguageID &id) const
   { return _id == (const char*)id; }
};


} // namespace Puma

#endif /* __language_id_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_h__
#define __location_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __smart_ptr_h__
#define __smart_ptr_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ref_cnt_h__
#define __ref_cnt_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _counter;

public:
  RefCnt () : _counter (0) {}
  virtual ~RefCnt () {}
  
  void ref () { _counter++; }
  void deref () { _counter--; }
  int counter () { return _counter; }
};


} // namespace Puma

#endif /* __ref_cnt_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SmartPtr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  RefCnt *_data;

public:
  SmartPtr () : _data ((RefCnt*)0) {}
  ~SmartPtr () { clear (); }
  SmartPtr (const SmartPtr &copy);
  SmartPtr (RefCnt *rc) : _data (rc) {}
  SmartPtr &operator = (const SmartPtr &copy);

  void data (RefCnt *d);
  void clear ();
  RefCnt *data () const { return _data; }
  bool is_defined () const { return _data != (RefCnt*)0; }
};


} // namespace Puma

#endif /* __smart_ptr_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __printable_h__
#define __printable_h__

#include <iostream>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~Printable () {}
  virtual void print (ostream &os) const = 0;
};


inline ostream &operator << (ostream &os, const Printable &object) {
  object.print (os);
  return os;
}


} // namespace Puma

#endif /* __printable_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __location_info_h__
#define __location_info_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_h__
#define __filename_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_info_h__
#define __filename_info_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __DString_h__
#define __DString_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashTable_h__
#define __StrHashTable_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __StrHashKey_h__
#define __StrHashKey_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __str_col__
#define __str_col__

// Collection of functions handling strings.

namespace Puma {


class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrCol {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  StrCol () {}
        
public:
  // Return true if c is a white space character.
  static bool isSpace (const char c);

  // Return true if the string consists only of spaces.
  static bool onlySpaces (const char *);

  // Return true if the two strings differ not only in spaces.
  static bool effectivelyDifferent (const char *, const char *);

  // Build a string from a unit.
  static char *buildString (Unit *);
        
  // Duplicate a string
  static char *dup (const char *);
  static char *dup (const char *, int);
};


} // namespace Puma

#endif /* __str_col__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Chain_h__
#define __Chain_h__

//
// implements a simple chain
// 

#ifndef __puma
#include <iostream>
using namespace std;
#endif 

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Chain *next;

public:
  Chain () { next = 0; }
   
  void select (Chain *c) { next = c; }
  Chain *select () const { return next; }

  Chain *unlink () {
    Chain *res = next;
    if (next) {
      next = next->select ();
    }
    return res;
  }

  void insert (Chain *c) {
    c->select (next);
    next = c;
  }
};

#ifndef __puma


//
// Chain with useage/max counter
// 

class ChainCnt : public Chain {
  const char* name;

public:
  long long max, use;
  
  ChainCnt (const char *n) : name (n) { max = use = 0; }
  ~ChainCnt () {
    cout << "max list " << name << ": " << max << endl;
  }

  Chain *unlink () {
    Chain *c = Chain::unlink ();
    if (c) 
      use--;
    return c;
  }
  
  void insert (Chain *c) {
    use++;
    if(use > max) 
      max = use;
    Chain::insert (c);
  }
};

#endif /* __puma */


} // namespace Puma

#endif /* __Chain_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrHashKey : public Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  unsigned int m_Magic;
  unsigned int m_Len;
  const char  *m_Str;

  StrHashKey () : m_Len (0), m_Str (0) {}

public:
  StrHashKey (int m, const char *s, int l) : 
    m_Magic (m), m_Len (l), m_Str (StrCol::dup (s, l)) {}

  unsigned int getMagic () const { return m_Magic; }
  unsigned int length () const { return m_Len; }
  const char  *c_str () const { return m_Str; }
};


} // namespace Puma

#endif /* __StrHashKey_h__ */
#include <assert.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class StrHashTable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  StrHashKey *_emptyKey;

public:
  StrHashTable () {
    _emptyKey = insert ("");
    assert (_emptyKey);
  }

  StrHashKey *empty () const { assert (_emptyKey); return _emptyKey; }
  StrHashKey *insert (const char *);
  void remove (StrHashKey *);

  enum { STRHASHTABLE_SIZE=0xffff };
  
private:
  Chain m_Table[STRHASHTABLE_SIZE];

  StrHashKey *find (unsigned int, const char *, unsigned int);
  unsigned int hash (const char *, unsigned int);
};


} // namespace Puma

#endif /* __StrHashTable_h__ */
#include <assert.h>

namespace Puma {


extern StrHashTable ___str_dict;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class DString {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  StrHashKey *m_Key;

public:
  DString () {
    m_Key = ___str_dict.empty ();
    assert (m_Key);
  }
  DString (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
  }
  DString (const DString &s) : m_Key (s.m_Key) {
    assert (s.m_Key);
  }
  
  DString &operator = (const DString &s) {
    assert (s.m_Key);
    m_Key = s.m_Key;
    return *this;
  }
  
  DString &operator = (const char *s) {
    if(s == 0) {
      m_Key = ___str_dict.empty ();
    } else {
      m_Key = ___str_dict.insert (s);
    }
    assert (m_Key);
    return *this;
  }

  bool operator == (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key == s.m_Key; 
  }
  bool operator != (const DString &s) const { 
    assert (m_Key && s.m_Key);
    return m_Key != s.m_Key; 
  }

  const char *c_str() const { 
    assert (m_Key);
    return m_Key->c_str (); 
  }
  unsigned int length () const { 
    assert (m_Key);
    return m_Key->length (); 
  }
  bool empty () const {
    assert (m_Key);
    return m_Key->length () == 0;
  }
  unsigned int magic () const { 
    assert (m_Key);
    return m_Key->getMagic (); 
  }

  operator const char *() const {
    assert (m_Key);
    return c_str ();
  }
};


} // namespace Puma

#endif /* __DString_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FilenameInfo : public RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  DString _name;
  const char *_path;
  const char *_root;

public:
  FilenameInfo () : _path ((const char*)0), _root ((const char*)0) {}
  ~FilenameInfo ();
  void name (const char *n);
  void name (const DString &dsn) { _name = dsn; }
  const char *name () const { return _name.c_str (); }
  const char *path ();
  const char *root ();
  bool is_absolute () const;
  bool operator == (const FilenameInfo &rc) const {
    return _name == rc._name;
  }
};


} // namespace Puma

#endif /* __filename_info_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Filename : public SmartPtr, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  FilenameInfo *info () const { return (FilenameInfo*)data (); }

public:
  Filename () {}
  Filename (const char *n) { name (n); }
  Filename &operator = (const char *n) { name (n); return *this; }
  void name (const char *n);
  const char *name () const;
  const char *path () const;
  const char *root () const;
  bool is_absolute () const;
  bool operator == (const Filename &f) const;
  bool operator != (const Filename &f) const { return !(*this == f); }
  virtual void print (ostream &os) const { if (info ()) os << name (); }
};


} // namespace Puma

#endif /* __filename_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class LocationInfo : public RefCnt {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Filename _filename;
  int _line;

public:
  LocationInfo () : _filename (), _line (0) {}
  void setup (Filename f, int l);
  const Filename &filename () const { return _filename; }
  int line () const { return _line; }
  bool operator < (const LocationInfo &l) const;
  bool operator == (const LocationInfo &l) const;
};


} // namespace Puma

#endif /* __location_info_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Location : public SmartPtr, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  LocationInfo *info () const { return (LocationInfo*)data (); }

public:
  Location () {}
  Location (Filename f, int l) { setup (f, l); }
  Location (LocationInfo *lptr) : SmartPtr (lptr) {}
  LocationInfo *operator ~ () { if (info ()) info ()->ref (); return info (); }
  void setup (Filename f, int l);
  const Filename &filename () const   { return info ()->filename (); }
  int line () const;
  bool operator == (const Location &l) const;
  bool operator != (const Location &l) const { return ! (*this == l); }
  bool operator < (const Location &l) const;

  virtual void print (ostream &os) const {
    if (info ())
#ifdef VISUAL_STUDIO
      os << filename () << "(" << line () << ")";
#else
      os << filename () << ":" << line ();
#endif
  }
};


} // namespace Puma

#endif /* __location_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_element_h__
#define __list_element_h__

// Base class for objects that may be inserted into a List. Lists
// autonomously delete or copy list element. So it's necessary to
// define a destructor and a duplicate method in the derived
// classes.

#include <assert.h>

namespace Puma {


class List;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ListElement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  friend class List;

  List        *_belonging_to;
  ListElement *_next;
  ListElement *_prev;

public:
  ListElement () : _belonging_to ((List*)0) {}
  virtual ~ListElement () { assert (! _belonging_to); };

  virtual ListElement *duplicate () = 0;
  List *belonging_to () const { return _belonging_to; }
};


} // namespace Puma

#endif /* __list_element_h__ */
#include <assert.h>
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Token : public ListElement {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int _type, _real_type;

  Location _location;
  LanguageID _language;
  DString _text;

  Array<int> *_cont_lines;
   
  enum TK_Flags {
          TK_COMMENT = (0x01 << 0),
          TK_CORE = (0x01 << 1),
          TK_MACRO_CALL = (0x01 << 2),
          TK_MACRO_GENERATED = (0x01 << 3)
  };
  unsigned short _flags;

public:
  enum {
    ID_END_OF_FILE = -1,
    ID_UNKNOWN = -2,
    ID_ERROR = -3,
    ID_WARNING = -4
  };

  static LanguageID comment_id, pre_id, dir_id, cpp_id, white_id, 
                    wildcard_id, keyword_id, open_id, macro_op_id,
                    identifier_id, comma_id, close_id;

public:
  Token (int = 0, LanguageID lang = LanguageID(0), const char * = "");
  Token (const Token &);
  virtual ~Token ();

//  virtual void print (ostream &) const;
  void print (ostream &) const;
  virtual ListElement *duplicate () { return new Token (*this); }

  void reset (int = 0, const char * = 0, LanguageID = LanguageID(0));
  
  void location (const Location &loc)      { _location = loc; }
  void cont_lines (Array<int> *cl)  { _cont_lines = cl; }
  int line_breaks () const;
  void macro_generated ()           { _flags |= TK_MACRO_GENERATED; }
  void macro_call ()                { _flags |= TK_MACRO_CALL; }
  
  const DString &text () const     { return _text; }
  char *get_static_text () const;
  int type () const                 { return _type; }
  const Location &location () const { return _location; }
   
  // functions to query token flags
  bool is_macro_generated () const  { return (_flags & TK_MACRO_GENERATED) != 0; }
  bool is_macro_call () const       { return (_flags & TK_MACRO_CALL) != 0; }
  bool is_core () const;
  bool is_identifier () const;    // subset of core
  bool is_keyword () const;       // subset of identifier
  bool is_wildcard () const;      // subset of core
  bool is_preprocessor () const;  // a preprocessor directive (include, etc.)
  bool is_directive () const;     // a compiler directive (pragma, line, etc.)
  bool is_whitespace () const;
  bool is_comment () const;
  bool is_macro_op () const;
  bool is_open () const;          // subset of core
  bool is_comma () const;         // subset of core
  bool is_close () const;         // subset of core

  void *operator new (size_t);
  void  operator delete (void *);

private:
  int get_general_type () const;
  LanguageID language () const { return _language; }
  void is_comment_internal ();
  void is_core_internal ();
};


inline void Token::is_core_internal () {
  if (_language == cpp_id || _language == wildcard_id || 
      _language == open_id || _language == comma_id || 
      _language == close_id || is_identifier ())
    _flags |= TK_CORE;
}
inline void Token::is_comment_internal () { 
  if (_language == comment_id) 
    _flags |= TK_COMMENT;
}

inline bool Token::is_core () const 
 { return (_flags & TK_CORE) != 0; }
inline bool Token::is_identifier () const 
 { return _language == identifier_id || is_keyword ();}
inline bool Token::is_keyword () const 
 { return _language == keyword_id; }
inline bool Token::is_wildcard () const 
 { return _language == wildcard_id; }
inline bool Token::is_preprocessor () const 
 { return _language == pre_id; }
inline bool Token::is_directive () const 
 { return _language == dir_id; }
inline bool Token::is_whitespace () const 
 { return _language == white_id; }
inline bool Token::is_comment () const 
 { return (_flags & TK_COMMENT) != 0; }
inline bool Token::is_macro_op () const 
 { return _language == macro_op_id; }
inline bool Token::is_open () const 
 { return _language == open_id; }
inline bool Token::is_comma () const 
 { return _language == comma_id; }
inline bool Token::is_close () const 
 { return _language == close_id; }

inline ostream &operator << (ostream &os, const Token &object) {
  object.print (os);
  return os;
}

} // namespace Puma

#endif /* __Token_h__ */
using namespace Puma;

namespace Puma {
  
}

class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinIfExists {
public:
  static WinIfExists *aspectof () {
    static WinIfExists __instance;
    return &__instance;
  }
  static WinIfExists *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win __if_exists and __if_not_exists                  */
  /********************************************************/

  // pointcut definitions
  

  // structural extensions
  

  // preprocess __if_exists and __if_not_exists statements
  
public: template<class JoinPoint> void __a0_around (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    Token *token;
    int type;
    __JP_That *preparser;
  
  	preparser = tjp->that ();
    tjp->proceed (); // get the next token
    token = *tjp->result ();
    if (token) {
      type = token->type ();
      // __if_exists (...) { ... }
      if (type == TOK_IF_EXISTS) {
        preparser->skip_up_to (TOK_CLOSE_CURLY);
		    *(Token**)thisJoinPoint->result () = preparser->next ();
		    return;
        // __if_not_exists (...) { ... }
      } else if (type == TOK_IF_NOT_EXISTS) {
        preparser->skip_up_to (TOK_OPEN_CURLY);
        preparser->_depth.push (1);
		    *(Token**)thisJoinPoint->result () = preparser->next ();
		    return;
      }
      // skip closing `}' of __if_not_exists
      if (preparser->_depth.length ()) {
        if (type == TOK_OPEN_CURLY) 
          preparser->_depth.top () = preparser->_depth.top () + 1;
        else if (type == TOK_CLOSE_CURLY) { 
          preparser->_depth.top () = preparser->_depth.top () - 1;
	  	    if (preparser->_depth.top () == 0) {
	          preparser->_depth.pop ();
  	    	  *(Token**)thisJoinPoint->result () = preparser->next ();
	       	  return;
	  	    }
        }
      }
    }
  }
private:


protected:
  WinIfExists () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinIfExists_WinIfExists_a0_around (JoinPoint *tjp) {
    ::WinIfExists::aspectof()->__a0_around (tjp);
  }
} 


namespace Puma {
  
    
  // skip __if_exists resp. __if_not_exists statement
  
}

#endif /* __WinIfExists__ */

#ifndef __ac_fwd_PragmaOnce__
#define __ac_fwd_PragmaOnce__
class PragmaOnce;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif
/* Driver template for the LEMON parser generator.
** Copyright 1991-1995 by D. Richard Hipp.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
** 
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
** Modified 1997 to make it suitable for use with makeheaders.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 27 "cpp/PreParser.lem"

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __list_h__
#define __list_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ListElement *_first;
  ListElement *_last;

public:
  List () : _first ((ListElement*)0), _last ((ListElement*)0) {}
  List (const List &);
  ~List();

  List &operator = (const List &);
  List &operator += (const List &);
  List operator + (const List &);

  void clear ();

  void append (ListElement &);
  void prepend (ListElement &);
  void insert (ListElement *at, ListElement &element);
  void remove (ListElement *element);
  void kill (ListElement *from, ListElement *to = (ListElement*)0)
   { List discard; cut (discard, from, to); }

  void cut (List &out, ListElement *from, ListElement *to = (ListElement*)0);
  //List *cut (ListElement *from, ListElement *to = (ListElement*)0);
  List *copy (ListElement *from = (ListElement*)0, 
              ListElement *to = (ListElement*)0);
  void paste (ListElement *at, const List &l);
  void paste_before (ListElement *at, const List &l);
  void move (ListElement *at, List &l);
  void move_before (ListElement *at, List &l);

  bool empty () const { return _first == (ListElement*)0; }
  const ListElement *first () const { return _first; }
  const ListElement *last () const { return _last; }
  const ListElement *next (const ListElement *element) const
   { return element->_next; }
  const ListElement *prev (const ListElement *element) const 
   { return element->_prev; }
};


} // namespace Puma

#endif /* __list_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __unit_h__
#define __unit_h__


#ifndef __ac_fwd_PragmaOnceUnitState__
#define __ac_fwd_PragmaOnceUnitState__
class PragmaOnceUnitState;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __PragmaOnceUnitState__
#define __PragmaOnceUnitState__

using namespace Puma;

class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class PragmaOnceUnitState {
public:
  static PragmaOnceUnitState *aspectof () {
    static PragmaOnceUnitState __instance;
    return &__instance;
  }
  static PragmaOnceUnitState *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /******************************************************/
  /* specific #pragma once unit state                   */
  /******************************************************/

  // pointcut definitions
  

  
  
  // initialize new state flag
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    thisJoinPoint->that ()->_once = false;
  }
private:


protected:
  // this aspect should never be instantiated directly
  PragmaOnceUnitState () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after (JoinPoint *tjp) {
    ::PragmaOnceUnitState::aspectof()->__a0_after (tjp);
  }
} 



#endif /* __PragmaOnceUnitState__ */
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_UnitState_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_UnitState_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __UnitState__
#define __UnitState__

// The state of a unit: 
// 1. modified by manipulations and not updated at the class registry
// 2. modified by manipulations and updated at the class registry
// 3. unmodified by manipulations and not updated at the class registry
// 4. unmodified by manipulations and updated at the class registry

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class UnitState {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _modified;
  bool _updated;
  long _lastModified;
      
public:
  public: inline void __exec_old_C1();
UnitState ();
      
  bool isModified () const;
  bool isUpdated () const;
  long lastModified () const;

  // Is modified and has to be updated.
  void modified ();
  void lastModified (long);
  void unmodified ();
  void updated ();
   private:
 bool _once ;
public :

bool onlyOnce ( ) const { return _once ; }
void onlyOnce ( bool v ) { _once = v ; }
struct TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0 {
  typedef void Result;
  typedef ::Puma::UnitState That;
  typedef ::Puma::UnitState Target;
  static const int JPID = 5;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 1 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };
  template <int DUMMY> struct Arg<0, DUMMY> {
    typedef const ::Puma::UnitState & Type;
    typedef const ::Puma::UnitState ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};


public:
inline UnitState (const Puma::UnitState & arg0) : _modified (arg0._modified), _updated (arg0._updated), _lastModified (arg0._lastModified), _once (arg0._once) {
  TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0 tjp;
  tjp._that =  (TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0::That*)this;
  AC::invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after<TJP__ZN4Puma9UnitStateC1ERKN4PumaE9UnitState_0> (&tjp);

}
};



struct TJP__ZN4Puma9UnitStateC1Ev_0 {
  typedef void Result;
  typedef ::Puma::UnitState That;
  typedef ::Puma::UnitState Target;
  static const int JPID = 5;
  static const AC::JPType JPTYPE = (AC::JPType)16;
  struct Res {
    typedef void Type;
    typedef void ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  That *_that;

  inline That *that() {return (That*)_that;}

};

inline UnitState::UnitState ()
 {
  TJP__ZN4Puma9UnitStateC1Ev_0 tjp;
  tjp._that =  (TJP__ZN4Puma9UnitStateC1Ev_0::That*)this;
this->__exec_old_C1();
  AC::invoke_PragmaOnceUnitState_PragmaOnceUnitState_a0_after<TJP__ZN4Puma9UnitStateC1Ev_0> (&tjp);

}
inline void Puma::UnitState::__exec_old_C1(){ _modified = false; _updated = false; _lastModified = 0; }

inline bool UnitState::isModified () const 
 { return _modified; }
inline bool UnitState::isUpdated () const 
 { return _updated; }
inline long UnitState::lastModified () const
 { return _lastModified; }

inline void UnitState::modified () 
 { _modified = true; _updated = false; _lastModified = 0; }
inline void UnitState::unmodified () 
 { _modified = false; }
inline void UnitState::updated () 
 { _updated = true; }
inline void UnitState::lastModified (long when) 
 { _lastModified = when; }


} // namespace Puma

#endif /* __UnitState__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_UnitState_h__
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Unit : public List, public Printable {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_name;
  UnitState _state;

public:
  Unit () : List (), _name ((char*)0) {}
  Unit (const List &list) : List (list), _name ((char*)0) {}
  virtual ~Unit ();
  virtual void name (const char *);
  char *name () const { return _name; }
  virtual void print (ostream &os) const;
  virtual bool isFile () const { return false; }
  virtual bool isMacroExp () const { return false; }
  UnitState &state () { return _state; }
};


} // namespace Puma

#endif /* __unit_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_expr__
#define __pre_expr__

// Node class for the preprocessor expression parser. 

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __mapped_orange_recognizer_h__
#define __mapped_orange_recognizer_h__

// The token recognizer class, which uses scanner tables generated by the
// orange tool. Returned expressions mapped according to an orange
// generated mapping table

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __recognizer_h__
#define __recognizer_h__

// The token recognizer class, which uses scanner tables generated by the
// orange tool.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __scan_buffer_h__
#define __scan_buffer_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ScanBuffer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef enum { STATE_END, STATE_ERROR, STATE_OK } State;
  
  virtual ~ScanBuffer () {}

  virtual char next () = 0;
  virtual char *token () = 0;
  virtual int len () const = 0;
  virtual void reset () = 0;
  virtual void retry () = 0; 
  virtual void accept (int len) = 0;
  virtual void more (int len) = 0;
  virtual State state () const = 0;
};


} // namespace Puma

#endif /* __scan_buffer_h__ */
namespace Puma {


#ifndef __TTGEN__
#  define __TTGEN__
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
typedef struct
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;
 unsigned char Type;
   unsigned char LookAhead;
   int           Expression;
   int           Start;
 } States;                                                                   
#endif


// class declaration

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <typename TScanBuffer>
class OrangeRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // local structures generated by Orange

  char *_map;
  int _start;
  States *_state;
  int *_next;
  int *_control;
  int _tab_size;

public:
  OrangeRecognizer (char *map, int start, States *state, int *next,
                    int *control, int tab_size) : 
    _map (map), _start (start), _state (state), _next (next),
    _control (control), _tab_size (tab_size)
   {}

  // try to recognize the current token in the character buffer
  // returns 1 on success, 0 on eof, -1 on unknown token
  int recognize (TScanBuffer *scan_buffer, int &token, int &len); 
};

template <typename TScanBuffer>
int OrangeRecognizer<TScanBuffer>::recognize (TScanBuffer *scan_buffer,
                                              int &token, int &len) {
  int  NextState;
  char Character;
  char CharClass;
  int  NextStatePos;
  int  State;
  int  LookAheadLen;
  int  AcceptLen;
  int  AcceptState;
  ScanBuffer::State buffer_state = ScanBuffer::STATE_OK;

  State = _start;
  AcceptState = -1;
  LookAheadLen = 0;
  AcceptLen = 0;

  do { 
    Character = scan_buffer->next ();

    CharClass = _map[(unsigned char)Character];
    if (CharClass == -1)
      break;

    NextStatePos = _state[State].Start + CharClass;
    if (NextStatePos < 0 || NextStatePos >= _tab_size ||
        _control[NextStatePos] != State)
      break;

    if ((NextState = _next[NextStatePos]) == -1)
      break;

    State = NextState;

    if (_state[State].Type > 0) {
      AcceptState = State; // remember this (terminal) state
      AcceptLen = scan_buffer->len ();
    }

    if (_state[State].LookAhead)
      LookAheadLen = scan_buffer->len ();

    buffer_state = scan_buffer->state ();
  } while (NextState != -1 && buffer_state == ScanBuffer::STATE_OK);

  if (buffer_state == ScanBuffer::STATE_ERROR)
    return -1;

  if (AcceptState == -1)
    return 0;

  len   = (_state[AcceptState].Type == 2) ? LookAheadLen : AcceptLen;
  token = _state[AcceptState].Expression;

  return 1;
}

} // namespace Puma

#endif /* __orange_recognizer_h__ */
namespace Puma {


// class declaration

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
template <class ScanBuffer>
class MappedOrangeRecognizer : public OrangeRecognizer<ScanBuffer> {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int *_expr_map;

public:
  MappedOrangeRecognizer (char *map, int *expr_map, int start, 
                          States *state, int *next,
                          int *control, int tab_size) : 
    OrangeRecognizer<ScanBuffer> (map, start, state, next, control, tab_size),
    _expr_map (expr_map) 
   {}

  // try to recognize the current token in the character buffer
  // returns 1 on success, 0 on eof, -1 on unknown token
  int recognize (ScanBuffer *scan_buffer, int &token, int &len) {
    int result;

    if ((result = OrangeRecognizer<ScanBuffer>::recognize (scan_buffer, token, len)) == 1) {
      token = _expr_map[token];
    }
    return result;
  }
};


} // namespace Puma

#endif // __mapped_orange_recognizer_h__
namespace Puma {


class ErrorStream;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreExpr {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  bool _result;        

public:
  double val;
        
  // Public constructor.
  PreExpr (ErrorStream *, Location);

  // Do not use this contructors outside of the 
  // C preprocessor expression parser.
  PreExpr () {};        
  ~PreExpr () {};        
  PreExpr (unsigned long int value) : val ((double) value) {};        
  PreExpr (long int value) : val ((double) value) {};        
  PreExpr (double value) : val (value) {};        
        
  // Evaluate the given expression string.
  void evaluatePreExpr (char *expression_string);
        
  // Return value of evaluated expression.
  bool value () const { return _result; }
        
  // String conversion method.
  static long int convertChar (char *value);

private:
  static MappedOrangeRecognizer<ScanBuffer> token_recognizer;
};


} // namespace Puma

#endif /* __pre_expr__ */

#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_recognizer_h__
#define __c_recognizer_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CScanBuffer_h__
#define __CScanBuffer_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanBuffer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ScanBuffer *next_buffer;
  bool on_new_line;
  int nl_pos;

  void check ();

public:
  void decorate (ScanBuffer *nb) { next_buffer = nb; }
  inline char next ();
  inline void reset ();
  inline void accept (int len);
  inline void retry ();
  bool new_line () const { return on_new_line; }
  char *token () { return next_buffer->token (); }
  int len () const { return next_buffer->len (); }
  void more (int len) { next_buffer->more (len); }
  ScanBuffer::State state () const { return next_buffer->state (); }
};


inline char CScanBuffer::next () {
  char character = next_buffer->next ();
  if (character == '\n' && nl_pos == -1)
    nl_pos = len () - 1;
  check ();
  return character;
}

inline void CScanBuffer::reset () { 
  next_buffer->reset (); 
  on_new_line = true;
  nl_pos = -1;
  check ();
}


inline void CScanBuffer::retry () {
  nl_pos = -1;
  next_buffer->retry ();
}


inline void CScanBuffer::accept (int len) {
  on_new_line = (nl_pos >= 0 && nl_pos < len);
  nl_pos = -1;
  next_buffer->accept (len);
}

} // namespace Puma

#endif // __CScanBuffer_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_comment_recognizer_h__
#define __c_comment_recognizer_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CCommentRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef enum { NO_COMMENT, SL_COMMENT, ML_COMMENT } Mode;

private:
  static MappedOrangeRecognizer<CScanBuffer> comment_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> sl_comment_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> ml_comment_recognizer;   
  Mode comment_mode;

public:
  CCommentRecognizer () : comment_mode (NO_COMMENT) {}
  int recognize (CScanBuffer *scan_buffer, int &expr, int &len);
  void mode (Mode mode) { comment_mode = mode; }
  Mode mode () { return comment_mode; }
};


} // namespace Puma

#endif /* __c_comment_recognizer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __keyword_recognizer_h__
#define __keyword_recognizer_h__
 
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class KeywordRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  virtual MappedOrangeRecognizer<CScanBuffer> &recognizer() = 0;

public:
  virtual ~KeywordRecognizer () {}
  virtual int recognize (CScanBuffer *scan_buffer, int &expr, int &len);
};
 

} // namespace Puma

#endif /* __keyword_recognizer_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CRecognizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CScanBuffer scan_buffer;
  CCommentRecognizer comment_recognizer;
  Array<KeywordRecognizer*> additional_keyword_recognizers;

public:
  typedef enum { NORMAL, IN_COMP_DIR, IN_PRE_DIR } Mode;
  typedef enum { COMMENT, PRE_DIR, COMP_DIR, WHITE, PRE, STRING, CORE, 
                 KEYWORD, ID, WILDCARD, UNKNOWN } Lang;

  CRecognizer () : wildcards (false), aspectc (false), macro_ops (false),
    std_c (true), std_cplusplus (true) {}
  CRecognizer (ScanBuffer& buffer) : wildcards (false), aspectc (false),
    macro_ops (false) { setup (buffer); }
  void allow_wildcards (bool flag = true)     { wildcards = flag; }
  void allow_aspectc (bool flag = true)       { aspectc   = flag; } 
  void allow_macro_ops (bool flag = true)     { macro_ops = flag; }
  void allow_std_c (bool flag = true)         { std_c = flag; }
  void allow_std_cplusplus (bool flag = true) { std_cplusplus = flag; }
  void setup (ScanBuffer &buffer);
  int recognize (Lang &lang, int &expr, int &len);
  Mode mode () { return scan_mode; }
  bool new_line () const { return scan_buffer.new_line (); }
  CScanBuffer& buffer () { return scan_buffer; }
  void addRecognizer(KeywordRecognizer &recognizer) 
   { additional_keyword_recognizers.append(&recognizer); }

private:
  static MappedOrangeRecognizer<CScanBuffer> string_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> pre_dir_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> pre_token_recognizer;
  static OrangeRecognizer<CScanBuffer> dir_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> whitespace_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> wildcard_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> core_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> identifier_recognizer;

  Mode scan_mode;
  bool check_directive;
  bool wildcards;
  bool aspectc;
  bool macro_ops;
  bool std_c;
  bool std_cplusplus;
};


} // namespace Puma

#endif /* __c_recognizer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Tokenizer_h__
#define __Tokenizer_h__

// Tokenizer interface. Tokenizer read input from a "Source" and
// form tokens, which used to fill a "Unit".

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __source_h__
#define __source_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Source {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  Source () {}
  virtual ~Source () {}
  virtual int read (char *dest, int n) = 0;
  virtual int size () { return -1; }
};


} // namespace Puma

#endif /* __source_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~Tokenizer () {}
  virtual void fill_unit (Source &in, Unit &unit) = 0;
};


} // namespace Puma

#endif /* __Tokenizer_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_sink_h__
#define __error_sink_h__

// This is an interface for classes that may be used to consume error
// messages during a process where many errors can occur like parsing
// a program.
// The error information is handed over to the ErrorSink in stream-like
// style. Different severities of errors are predefined and can be used
// to classify error information that follows. Also a location can be
// handed over to the ErrorSink to specify where the error was found
// (filename, line, etc.). The error information itself can be of any
// standard data type or anything that is "Printable".
// Specializations of this class could either build and print error
// messages or collect them for a later processing.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_severity_h__
#define __error_severity_h__

// Severity of errors: represented by a short integer and a text

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorSeverity {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  unsigned short _severity;
  const char *_text;

public:
  ErrorSeverity (unsigned short s = 0, const char* t = (const char*)0) :
    _severity (s), _text (t) {}
  ErrorSeverity (const ErrorSeverity &s) :
    _severity (s._severity), _text (s._text) {}
  ErrorSeverity &operator =(const ErrorSeverity &s) 
    { _severity = s._severity; _text = s._text; return *this; }

  int operator < (const ErrorSeverity &s) const
   { return _severity < s._severity; }
  int operator > (const ErrorSeverity &s) const
   { return _severity > s._severity; }
  int operator <= (const ErrorSeverity &s) const
   { return _severity < s._severity || _severity == s._severity; }
  int operator >= (const ErrorSeverity &s) const
   { return _severity > s._severity || _severity == s._severity; }
  int operator == (const ErrorSeverity &s) const
   { return _severity == s._severity; }
  int operator != (const ErrorSeverity &s) const
   { return _severity != s._severity; }
  const char *text () const
   { return _text; }
};

extern const ErrorSeverity sev_none;
extern const ErrorSeverity sev_message;
extern const ErrorSeverity sev_warning;
extern const ErrorSeverity sev_error;
extern const ErrorSeverity sev_fatal;
      

} // namespace Puma

#endif /* __error_severity_h__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorSink {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  virtual ~ErrorSink () {}
  virtual ErrorSink &operator << (const char *) = 0;
  virtual ErrorSink &operator << (long) = 0;
  virtual ErrorSink &operator << (unsigned) = 0;
  virtual ErrorSink &operator << (int) = 0;
  virtual ErrorSink &operator << (short) = 0;
  virtual ErrorSink &operator << (char) = 0;
  virtual ErrorSink &operator << (double) = 0;
  virtual ErrorSink &operator << (const ErrorSeverity &) = 0;
  virtual ErrorSink &operator << (Location) = 0;
  virtual ErrorSink &operator << (const Printable &) = 0;
  virtual ErrorSink &operator << (void (*f)(ErrorSink &)) = 0;
  virtual void endMessage () = 0;
};

void endMessage (ErrorSink &);


} // namespace Puma

#endif /* __error_sink_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Config_h__
#define __Config_h__

// Class Config provides evaluation of configuration 
// information from file or command line.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Flags_h__
#define __Flags_h__

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Flags {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  enum Flag {
    NONE                       = 0x0,
    
    SKIP_FCT_BODY              = 0x1,
    SKIP_INITS                 = 0x2,
    
    // GNU extensions
    GNU_NESTED_FCT             = 0x4,
    GNU_CONDITION_SCOPE        = 0x8,
    GNU_PARAM_DECL             = 0x10,
    GNU_FCT_DECL               = 0x20,
    GNU_PARAM_SCOPE            = 0x40,
    GNU_DEFAULT_ARGS           = 0x80,
    GNU_EXTENDED_ASM           = 0x100,
    GNU_EXTENDED_EXPR          = 0x200,
    GNU_LONG_LONG              = 0x400,
    GNU_NAME_SCOPE             = 0x800, 
    GNU_IMPLICIT_INT           = 0x1000,
    GNU_FCT_ATTRIBUTE          = 0x2000,
    GNU_IF_THEN_EXPR           = 0x4000
  };
  
private:
  Flag _Flags;
  
public:
  Flags ();
  Flags (const Flags &);
  Flags &operator =(const Flags &);

  // add/remove flag
  Flags &operator +=(Flag);
  Flags &operator -=(Flag);
  
  // test for flag
  bool operator ==(Flag) const;
  bool operator !=(Flag) const;
};

inline Flags::Flags () : _Flags (NONE) 
 {}
inline Flags::Flags (const Flags &f)
 { _Flags = f._Flags; }
inline Flags &Flags::operator =(const Flags &f)
 { _Flags = f._Flags; return *(Flags*)this; }

inline Flags &Flags::operator +=(Flags::Flag f)
 { _Flags = (Flag)(_Flags | f); return *(Flags*)this; }
inline Flags &Flags::operator -=(Flags::Flag f)
 { _Flags = (Flag)(_Flags ^ (_Flags & f)); return *(Flags*)this; }

inline bool Flags::operator ==(Flags::Flag f) const
 { return _Flags & f; }
inline bool Flags::operator !=(Flags::Flag f) const
 { return ! (_Flags & f); }


} // namespace Puma

#endif /* __Flags_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ConfOption_h__
#define __ConfOption_h__

#include <stdlib.h>

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ConfOption {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_name;
  Array<const char *> _args;
  
public:
  ConfOption (const char *);
  ConfOption (const char *, const char *);
  ConfOption (const char *, const char *, const char *);
  ~ConfOption ();
  
  const char *Name () const;
  unsigned Arguments () const;
  const char *Argument (unsigned) const;
  
  void addArgument (const char *);
};

inline ConfOption::ConfOption (const char *n) : _args (1, 1) 
 { _name = StrCol::dup (n); }
inline ConfOption::ConfOption (const char *n, const char *a1) : _args (1, 1) 
 { _name = StrCol::dup (n); addArgument (a1); }
inline ConfOption::ConfOption (const char *n, const char *a1, const char *a2) : _args (2, 1) 
 { _name = StrCol::dup (n); addArgument (a1); addArgument (a2); }
 
inline ConfOption::~ConfOption ()
 { delete[] _name; 
   for (unsigned i = 0; i < Arguments (); i++) 
     delete[] Argument (i);
 }

inline const char *ConfOption::Name () const 
 { return _name; }
inline unsigned ConfOption::Arguments () const
 { return _args.length (); }
inline const char *ConfOption::Argument (unsigned i) const
 { return _args.lookup (i); }
  
inline void ConfOption::addArgument (const char *a) 
 { if (a) _args.append (StrCol::dup (a)); }


} // namespace Puma

#endif /* __ConfOption_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_stream_h__
#define __error_stream_h__

// An ErrorStream is a special ErrorSink that prints out an error message
// as soon as it complete. It also stores the maximum error severity.
// The ErrorStream can be reset to it's initial state.

#include <sstream>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ErrorStream : public ErrorSink {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  ostream *_ostream;
  ErrorSeverity _max_severity;
  ErrorSeverity _curr_severity;
  Location _location;
  bool _have_location;
  std::ostringstream *_msg;
  bool _silently;

  void output ();
  void clear ();

public:
  ErrorStream (std::ostream &s = cerr) : _ostream (&s), _msg ((std::ostringstream*)0)
   { reset (); _silently = false; }
  virtual ~ErrorStream () { delete _msg; }

  ErrorStream &operator << (const char *);
  ErrorStream &operator << (long);
  ErrorStream &operator << (unsigned);
  ErrorStream &operator << (int);
  ErrorStream &operator << (short);
  ErrorStream &operator << (char);
  ErrorStream &operator << (double);
  ErrorStream &operator << (const ErrorSeverity &);
  ErrorStream &operator << (Location);
  ErrorStream &operator << (const Printable &);
  ErrorStream &operator << (void (*f)(ErrorSink &));

  void endMessage ();
  void reset ();
  void silent ();
  void loud ();

  ErrorSeverity severity () const { return _max_severity; }
};


} // namespace Puma

#endif /* __error_stream_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OptsParser_h__
#define __OptsParser_h__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SimpleParser_h__
#define __SimpleParser_h__

#include <vector>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class SimpleParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  SimpleParser() {}
  ~SimpleParser() {}
   
  static int tokenize (const string &, vector<string> &, 
                       const string &delimiters = " ");
  static string strip (const string &);
};


} // namespace Puma

#endif /* __SimpleParser_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class OptsParser : public SimpleParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  vector<string> m_argv;
  unsigned int m_curarg;
  unsigned int m_tonext;
  int m_number;

  string m_arg;
  string m_opt;
   
public:
  
  enum {NOARG =-4, ERR = -3, NOOPTION = -2, UNKNOWN = -1, FINISH = 0 };
  
  enum ArgType { AT_NONE = 0, AT_MANDATORY = 1, AT_OPTIONAL = 2 };
  
  struct Option {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    int number;
    char key; 
    const char *name;
    const char *desc;
    ArgType args;
  };

private:
  const Option *m_opts;
   
public:
  OptsParser (int, char **, const Option *);
  OptsParser (const string &, const Option *);

  int getCurrentArgNum () const;
  int getNextArgNum () const;
  int getOption ();
  int getResult () const;
  
  const string &getArgument () const;
  const string &getOptionName () const;

  bool revokeArgument();
   
private:
  int  getShortOption (const string &);
  int  getLongOption  (const string &);
  bool processOption  (const string &, unsigned int,ArgType argtype);
};


} // namespace Puma

#endif /* __OptsParser_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Config {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Flags _flags;
  ErrorStream &_err;
  Array<const ConfOption *> _options;
  
public:
  enum OPTIONS {
    PRE_ASSERT = 1,
    PRE_DEFINE, 
    PRE_UNDEFINE, 
    PRE_LOCK_MACRO,
    PRE_INCLUDE,
    CFG_FILE, 
    PROJ_PATH, 
    PROJ_DESTINATION,
    SET_SUFFIX, 
    SET_EXTENSION, 
    SET_WRITE_PROTECTED,
    SET_OPTION, 
    SET_OPTION_ARG
  };
   
public:
  Config (ErrorStream &);
  Config (const Config &);
  ~Config ();
  
  // read config file
  Config (ErrorStream &, const char *);
  // read command line
  Config (ErrorStream &, int &, char **&);
  // read config file and command line
  Config (ErrorStream &, const char *, int &, char **&);
        
  // join with another configuration
  void Join (const Config &);

  // evaluate file, if file not given read from $PUMA_CONFIG
  // or /etc/puma.config
  void Read (const char * = (const char *)0);
  // evaluate command line
  void Read (int &, char **&);

  // add options to configuration
  void Add (const ConfOption *);
  void Add (const char *);
  void Add (const char *, const char *);
  void Add (const char *, const char *, const char *);

  // get options
  unsigned Options () const;
  const ConfOption *Option (unsigned) const;
  const ConfOption *Option (const char *) const;

  Flags FlagTable () const;
  
private:
  bool Valid (const char *, const char * = (const char *)0) const;

  bool Process (OptsParser&);
  bool ProcessAssert (const string&);
  bool ProcessDefine (const string&);
  bool ProcessLockMacro (const string&);
  bool ProcessUndefine (const string&);
  bool ProcessConfigFile (const string&,const string&);
  bool ProcessArgument (const string&,const string&);
  bool ProcessPathArgument (const string&,const string&);

};

inline Config::Config (ErrorStream &e) : _err (e)
 {}
inline Config::Config (const Config &c) : _err (c._err)
 { Join (c); }
  
inline Config::Config (ErrorStream &e, const char *file) : _err (e)
 { Read (file); }
inline Config::Config (ErrorStream &e, int &argc, char **&argv) : _err (e)
 { Read (argc, argv); }
inline Config::Config (ErrorStream &e, const char *file, int &argc, char **&argv) : _err (e)
 { Read (file); Read (argc, argv); }

inline Config::~Config  ()
 { for (unsigned i = 0; i < Options (); i++)
     delete (ConfOption *) Option (i);
 }

inline void Config::Add (const ConfOption *o) 
 { _options.append (o); }
inline void Config::Add (const char *n)
 { Add (new ConfOption (n)); }
inline void Config::Add (const char *n, const char *a1)
 { Add (new ConfOption (n, a1)); }
inline void Config::Add (const char *n, const char *a1, const char *a2)
 { Add (new ConfOption (n, a1, a2)); }

inline unsigned Config::Options () const
 { return _options.length (); }
inline const ConfOption *Config::Option (unsigned i) const
 { return _options.lookup (i); }

inline Flags Config::FlagTable () const
 { return _flags; }


} // namespace Puma

#endif /* __Config_h__ */
namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_macro__
#define __pre_macro__

// Preprocessor macro class. There are two types of macros. The first
// is called a simple macro or a symbolic constant macro. It consists
// only of a macro name and the macro body. The second type of macros
// is called a function-like macro. In addition it consists of a list 
// of arguments.

namespace Puma {


class PreTree;
class CScanner;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreMacro : public Chain {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef Array<const char *> MacroArgs;

  enum {
    FUNCTION_MACRO = 1,                // Function-like macro.
    VAR_ARG_MACRO  = 2,                // Variable number of arguments.
    LOCK_MACRO     = 4,                // Macro cannot be redefined or undefined.
    INHIBIT_MACRO  = 8                 // Macro cannot be defined.
  };

private:
  const char*   _body;                 // Macro body.
  DString       _name;
  short         _numArgs;              // Number of arguments.
  char          _flags;                // Macro flags.
  Location      _location;             // Location of the #define directive.
  MacroArgs    *_arguments;            // The arguments array.
  Unit          _body_unit;            // The unit represeantation of the body

public:
  // Constructors for function-like macros.
  PreMacro (const DString &, PreTree *, const char *, char = 0);
  PreMacro (const DString &, MacroArgs *, const char *, char = 0);
        
  // Constructor for simple macros (constants).
  PreMacro (const DString &, const char *, char = 0);
        
  PreMacro (const PreMacro &);
  virtual ~PreMacro ();

  // Get macro attributes.
  const DString &getName () const { return _name; }
  const char *getBody () const { return _body; }
  const Unit &getBodyUnit (CScanner &scanner) {
    if (_body_unit.empty ())
      buildUnit (scanner);
    return _body_unit;
  }
  short numArgs () const { return _numArgs; }
  MacroArgs *getArgs () const { return _arguments; }
  // add an argument: the string is still owned by the caller and not copied!
  void addArg (const char *arg_name);

  // Set macro attributes
  void setBody (const char *);
   
  // Query macro flags.
  bool varArgs () const     { return _flags & VAR_ARG_MACRO; }
  bool isFunction () const  { return _flags & FUNCTION_MACRO; }
  bool isInhibited () const { return _flags & INHIBIT_MACRO; }
  bool isLocked () const    { return _flags & LOCK_MACRO; }

  // Set/get #define location.
  Location location () const { return _location; }
  void location (Location l) { _location = l; }
  
private:
  // create the unit representation
  void buildUnit (CScanner &scanner);
};


} // namespace Puma

#endif /* __pre_macro__ */
#define TOK_PRE_ASSERT                  1
#define TOK_PRE_COMMA                   2
#define TOK_PRE_DEFINE                  3
#define TOK_PRE_DIRECTIVE_END           4
#define TOK_PRE_ELIF                    5
#define TOK_PRE_ELSE                    6
#define TOK_PRE_ENDIF                   7
#define TOK_PRE_ERROR                   8
#define TOK_PRE_ID                      9
#define TOK_PRE_IF                     10
#define TOK_PRE_IFDEF                  11
#define TOK_PRE_IFNDEF                 12
#define TOK_PRE_INCLUDE                13
#define TOK_PRE_INCLUDE_NEXT           14
#define TOK_PRE_LPAREN                 15
#define TOK_PRE_NEWLINE                16
#define TOK_PRE_REST                   17
#define TOK_PRE_RPAREN                 18
#define TOK_PRE_TOKEN_LIST             19
#define TOK_PRE_UNASSERT               20
#define TOK_PRE_UNDEF                  21
#define TOK_PRE_WARNING                22
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_syntax_tree__
#define __pre_syntax_tree__

// Syntax tree definition according to the composite pattern from [GoF].

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_visitor_h__
#define __pre_visitor_h__

// Visitor for the preprocessor syntax tree.

namespace Puma {


class PreTree;
class PreTreeToken;
class PreCondSemNode;
class PreInclSemNode;
class PreError;
class PreProgram;
class PreDirectiveGroups;
class PreConditionalGroup;
class PreElsePart;
class PreElifPart;
class PreIfDirective;
class PreIfdefDirective;
class PreIfndefDirective;
class PreElifDirective;
class PreElseDirective;
class PreEndifDirective;
class PreIncludeDirective;
class PreAssertDirective;
class PreUnassertDirective;
class PreDefineFunctionDirective;
class PreDefineConstantDirective;
class PreUndefDirective;
class PreWarningDirective;
class PreErrorDirective;
class PreIdentifierList;
class PreTokenList;
class PreTokenListPart;
class PreForcedInclude;


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreVisitor {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  PreVisitor () {};
  virtual ~PreVisitor () {}
    
public:
  virtual void iterateNodes (PreTree *) {};

public:
  virtual void visitPreTreeToken (PreTreeToken *) {};

  virtual void visitPreError (PreError *) {};

  virtual void visitPreCondSemNode (PreCondSemNode *) {};
  virtual void visitPreInclSemNode (PreInclSemNode *) {};

  virtual void visitPreProgram_Pre (PreProgram *) {};
  virtual void visitPreProgram_Post (PreProgram *) {};

  virtual void visitPreDirectiveGroups_Pre (PreDirectiveGroups *) {};
  virtual void visitPreDirectiveGroups_Post (PreDirectiveGroups *) {};
        
  virtual void visitPreConditionalGroup_Pre (PreConditionalGroup *) {};
  virtual void visitPreConditionalGroup_Post (PreConditionalGroup *) {};
        
  virtual void visitPreElsePart_Pre (PreElsePart *) {};
  virtual void visitPreElsePart_Post (PreElsePart *) {};
        
  virtual void visitPreElifPart_Pre (PreElifPart *) {};
  virtual void visitPreElifPart_Post (PreElifPart *) {};
        
  virtual void visitPreIfDirective_Pre (PreIfDirective *) {};
  virtual void visitPreIfDirective_Post (PreIfDirective *) {};
        
  virtual void visitPreIfdefDirective_Pre (PreIfdefDirective *) {};
  virtual void visitPreIfdefDirective_Post (PreIfdefDirective *) {};
        
  virtual void visitPreIfndefDirective_Pre (PreIfndefDirective *) {};
  virtual void visitPreIfndefDirective_Post (PreIfndefDirective *) {};
        
  virtual void visitPreElifDirective_Pre (PreElifDirective *) {};
  virtual void visitPreElifDirective_Post (PreElifDirective *) {};
        
  virtual void visitPreElseDirective_Pre (PreElseDirective *) {};
  virtual void visitPreElseDirective_Post (PreElseDirective *) {};
        
  virtual void visitPreEndifDirective_Pre (PreEndifDirective *) {};
  virtual void visitPreEndifDirective_Post (PreEndifDirective *) {};
        
  virtual void visitPreIncludeDirective_Pre (PreIncludeDirective *) {};
  virtual void visitPreIncludeDirective_Post (PreIncludeDirective *) {};
        
  virtual void visitPreAssertDirective_Pre (PreAssertDirective *) {};
  virtual void visitPreAssertDirective_Post (PreAssertDirective *) {};
        
  virtual void visitPreUnassertDirective_Pre (PreUnassertDirective *) {};
  virtual void visitPreUnassertDirective_Post (PreUnassertDirective *) {};
        
  virtual void visitPreDefineFunctionDirective_Pre (PreDefineFunctionDirective *) {};
  virtual void visitPreDefineFunctionDirective_Post (PreDefineFunctionDirective *) {};
        
  virtual void visitPreDefineConstantDirective_Pre (PreDefineConstantDirective *) {};
  virtual void visitPreDefineConstantDirective_Post (PreDefineConstantDirective *) {};
        
  virtual void visitPreUndefDirective_Pre (PreUndefDirective *) {};
  virtual void visitPreUndefDirective_Post (PreUndefDirective *) {};
        
  virtual void visitPreWarningDirective_Pre (PreWarningDirective *) {};
  virtual void visitPreWarningDirective_Post (PreWarningDirective *) {};
        
  virtual void visitPreErrorDirective_Pre (PreErrorDirective *) {};
  virtual void visitPreErrorDirective_Post (PreErrorDirective *) {};
        
  virtual void visitPreIdentifierList_Pre (PreIdentifierList *) {};
  virtual void visitPreIdentifierList_Post (PreIdentifierList *) {};

  virtual void visitPreTokenList_Pre (PreTokenList *) {};
  virtual void visitPreTokenList_Post (PreTokenList *) {};

  virtual void visitPreTokenListPart_Pre (PreTokenListPart *) {};
  virtual void visitPreTokenListPart_Post (PreTokenListPart *) {};
};              


} // namespace Puma

#endif /* __pre_visitor_h__ */
namespace Puma {


// Common node interface
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  PreTree () {};

public:
  virtual void add_son (PreTree *);
  virtual void replace_son (int, PreTree *);
  virtual PreTree *son (int) const;
  virtual int sons () const;

  virtual void add_daughter (PreTree *);
  virtual void replace_daughter (int, PreTree *);
  virtual PreTree *daughter (int) const;
  virtual int daughters () const;

  virtual ~PreTree() {}
  virtual bool isLeaf () const;
  virtual void accept (PreVisitor &) = 0;
        
  virtual Token *startToken () const;
  virtual Token *endToken () const;
};

 
} // namespace Puma

#endif /* __pre_syntax_tree__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __UnitManager__
#define __UnitManager__

// Class UnitManager helps you to have control of all units built.

#include <list>
#include <map>
using namespace std;
namespace Puma {


class Unit;
class Source;
class Tokenizer;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class UnitManager {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  typedef map<string, Unit*> UMap;
private:
  ErrorStream *_err;        // For error messages.
  list<Unit*> _nonames;     // Noname units list.
  mutable UMap _umap;       // Named units, map supports fast lookup by name
  typedef UMap::value_type UMapPair;
  Tokenizer *_tokenizer;    // File scanner.

public:
  UnitManager (ErrorStream &err) : _err (&err), _tokenizer (0) {}
        
  // Destructor: Delete all units.
  virtual ~UnitManager ();
        
  // Get the unit hash table.
  UMap &getTable () const { return _umap; }
  typedef UMap::iterator UMapIter;
        
  // Get/Set the file scanner that is used by newUnit
  Tokenizer *tokenizer () const { return _tokenizer; }
  void tokenizer (Tokenizer *t) { _tokenizer = t; }
 
  // Add a unit to manager.
  void addUnit (Unit *unit);
        
  // Remove (and destroy) a unit from hash table. If the name
  // is NULL remove all (but not the nonames).
  void removeUnit (const char *name = (const char*) 0, bool = false, 
                   bool destroy = true) const;

  // Empty a unit. Don't remove from hash table.
  // Preserve the last save location information.
  void closeUnit (const char *name = (const char*) 0, bool = false) const;

  // Build and add a new unit. 
  Unit *newUnit (const char *, Source *in = (Source*) 0, bool = false);
        
  // Get a unit by name. 
  Unit *getUnit (const char *name, bool = false) const;
                        
  // Print given unit to the given outstream. If no
  // name is given, print all units.
  void print (const char *name = (const char*) 0, bool = false, 
              ostream &out = cout) const;

  // Destroy all noname units.
  void removeNonames ();
      
  // Initialize the unit manager and the managed 
  // units for the next parse process.
  void init ();
};


} // namespace Puma

#endif /* __UnitManager__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __TokenStream__
#define __TokenStream__

// Class TokenStream is a unit stack providing a stream of 
// tokens corresponding to the #include hierarchy of the 
// input files. 

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Unit_Token_Src__
#define __Unit_Token_Src__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Token_Source__
#define __Token_Source__

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PumaTokenSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

protected:
  PumaTokenSource () {}

public:
  virtual ~PumaTokenSource () {}
  virtual Token *next () = 0;
};


} // namespace Puma

#endif /* __Token_Source__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class UnitTokenSrc : public PumaTokenSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Unit &_unit;
  Token *_curr;
  bool _first;

public:
  UnitTokenSrc (Unit &);
  Token *next ();
  
  Token *current () const { return _curr; }
  Unit *unit () const { return &_unit; }
};


inline UnitTokenSrc::UnitTokenSrc (Unit &u) : _unit (u) {
  _curr = (Token*) 0;  
  _first = true;
}

inline Token *UnitTokenSrc::next () {
  if (_curr)
    _curr = (Token*) _unit.next (_curr);
  else if (_first) {
    _curr = (Token*) _unit.first ();    
    _first = false;
  }
  return _curr;
}


} // namespace Puma

#endif /* __Unit_Token_Src__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class TokenStream : public PumaTokenSource, public Array<UnitTokenSrc*> {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  TokenStream () : Array<UnitTokenSrc*> (20) {}
  ~TokenStream () {}
        
  // Push a unit on stack (nested include).
  void push (Unit *);

  // Get the top unit on stack.
  Unit *top () const;
        
  // Get the next token of the top unit.
  Token *next ();
};


} // namespace Puma

#endif /* __TokenStream__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_predicate__
#define __pre_predicate__

// Preprocessor predicate class. A predicate has a set of answers. 
// Answers can be added to or remove from a predicate. You can
// assert an answer for a predicate within a conditional and it
// will be checked whether this is a right answer to the predicate.
// That makes predicates to an alternative for the use of macros
// within conditionals.

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PrePredicate : public List {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_name;                // The name of the predicate.
  int   _numAnswers;        // The number of arguments.
        
public:
  // Constructor for a new predicate.
  PrePredicate (const char *name, const char *answer);
  virtual ~PrePredicate ();
        
  // Add a new answer for the predicate.
  void addAnswer (const char *answer);
        
  // Remove an answer for the predicate.
  void removeAnswer (const char *answer);
        
  // Return if given answer is an answer for the predicate.
  bool isAnswer (const char *answer) const;

  // Get several informations of the predicate.
  char *getName () const    { return _name; }
  int   numAnswers () const { return _numAnswers; }
};


} // namespace Puma

#endif /* __pre_predicate__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ImportHandler__
#define __ImportHandler__

// #import directive handler

namespace Puma {


class PreprocessorParser;
class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ImportHandler {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  PreprocessorParser &parser;
  Unit *header;
  
public:
  ImportHandler (PreprocessorParser &, const char *);
  
  Unit *IncludeFile () const;

private:
  void callHandler (const char *, const char *);
};


} // namespace Puma

#endif /* __ImportHandler__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_level_state__
#define __pre_level_state__

// Store the current state of nested conditionals. A nested conditional
// is a conditional group within a conditional group, and such a state 
// consists of informations about the depth of nesting (the level) and 
// the current value of the conditional group at this level. It is used 
// to controll which source code will be ignored.

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreLevelState {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  long _level;
        
  // The state structure.
  struct _state {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    bool state;                // The level value.
    bool passOn;        // Decide whether code will be not ignored.
  };
        
  // Array to store the state information of every level.
  Array<_state> _levels;        

public:
  PreLevelState () { reset (); }
                
  // Return to level 0, that means no nesting.
  void reset () { _level = 0; _levels[0].state  = true; 
                  _levels[0].passOn = true; }
        
  // Return from a subconditional.
  void higher () { if (--_level < 0) _level = 0; }
        
  // Enter a subconditional.
  void deeper () { _levels[++_level].state = true; 
                   _levels[_level].passOn  = true; }
        
  // Set the state of the current level.
  void setState (bool state)  { _levels[_level].state  = state; }
  void setPassOn (bool state) { _levels[_level].passOn = state; }
        
  // Get the state of the current level.
  bool state ()  { return _levels[_level].state; }
  bool passOn () { return _levels[_level].passOn; }
};


} // namespace Puma

#endif /* __pre_level_state__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __C_COMMENT_TOKENS_H__
#define __C_COMMENT_TOKENS_H__

namespace Puma {


enum {
  TOK_CCSINGLE = 350,
  TOK_CCMULTIBEGIN,
  TOK_CCMULTIEND,
  TOK_CCOMMENT
};


} // namespace Puma

#endif /* __C_COMMENT_TOKENS_H__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_parser_state__
#define __pre_parser_state__

// The state of a preprocessor parser. It contains all variable 
// parts of the preprocessor parser belonging not to the generated 
// lemon parser.

#include <set>
using std::set;

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_macro_manager__
#define __pre_macro_manager__

// The macro manager manages all defined macros.

using namespace std;

#ifdef __puma
# define PUMA_HTSIZE 1
#else
# define PUMA_HTSIZE StrHashTable::STRHASHTABLE_SIZE
#endif

namespace Puma {


class ErrorStream;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreMacroManager {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  PreMacro *_Line;
  PreMacro *_Date;
  PreMacro *_Time;
  PreMacro *_IncLevel;
  PreMacro *_File;
  PreMacro *_BaseFile;

  Chain _tab[PUMA_HTSIZE];

  ErrorStream *_err;        // To report errors.

  void add (PreMacro *);
  void kill (const DString &);
  PreMacro *get (const DString &) const;
  void clear ();
        
public:
  PreMacroManager (ErrorStream *err, int size = 211) : _err (err) {}
        
  // Destroy the predicates too.
  ~PreMacroManager () { clear (); }
        
  // Initialize the macro manager.
  void init (const char *filename);
        
  // Add given macro to macro table.
  void addMacro (PreMacro *macro);
        
  // Remove macro `name' from macro table.
  void removeMacro (const DString &name);
        
  // Get macro `name' from macro table.
  PreMacro *getMacro (const DString &name) const;
        
  // Get pointers to some special macros
  PreMacro *getLineMacro () const { return _Line; }
  PreMacro *getDateMacro () const { return _Date; }
  PreMacro *getTimeMacro () const { return _Time; }
  PreMacro *getIncLevelMacro () const { return _IncLevel; }
  PreMacro *getFileMacro () const { return _File; }
  PreMacro *getBaseFileMacro () const { return _BaseFile; }
};


} // namespace Puma

#endif /* __pre_macro_manager__ */
namespace Puma {


class ErrorStream;
class PreTree;
class PreMacro;
class TokenStream;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreParserState {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // some constant strings
  DString _Line, _File, _Date, _Time, _IncLevel;
  DString _Defined, _Defined1;
        
  int _LastDay;
  Unit *_LastUnit;
        
public:
  PreParserState ();
  ~PreParserState () { delete newline; }

  // Check whether a macro name is valid.
  bool checkMacroName (PreMacro *);
        
  // Check whether macro is one of the special `predefined' macros.
  PreMacro *checkPredefined (PreMacro *, TokenStream *, PreMacroManager &);
        
  // Check whether macro is a `self-referential' macro.
  bool checkToExpand (Token *, PreMacro *, TokenStream *, Array<PreMacro*> &,
    set<Token*> &);

public:
  int errors;             // Count the parse errors.
  int number;             // Current include depth.
  int maxIncludeDepth;    // Maximal include depth.
  int stackPos;           // Needed for macro expansion.
        
  // Are true if the special macros FILE, LINE ... has been redefined.
  bool noFILE, noLINE, noDATE, noTIME, noINCLUDE_LEVEL;

  bool syntaxError;     // True if a syntax error occured.
  bool errorDirective;  // True if a #error directive has been parsed.
  bool passOnToken;     // If false, following C++ code will be ignored.
  bool forcedIncludes;  // True as long as we are parsing forced include files

  Token *sl_token;      // Single line comment start token.
  Token *currToken;     // The current token to parse.
  Token *lastToken;     // Last parsed token.
  int currType;         // The type of the current token to parse.
  int lastType;         // The type of the last parsed token.

  void *pParser;        // Pointer to the Lemon generated parser.
  ErrorStream *err;     // Error stream.
  PreTree *syntaxTree;  // Preprocessor syntax tree.
        
  Token *newline;       // Token to trick the parser.
};


} // namespace Puma

#endif /* __pre_parser_state__ */

#ifndef __ac_fwd_PragmaOnce__
#define __ac_fwd_PragmaOnce__
class PragmaOnce;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_file_includer__
#define __pre_file_includer__

// Preprocessor class to handle includes.


#ifndef __ac_fwd_WinIfExists__
#define __ac_fwd_WinIfExists__
class WinIfExists;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinIfExists_WinIfExists_a0_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#endif

#ifndef __ac_fwd_WinImportHandler__
#define __ac_fwd_WinImportHandler__
class WinImportHandler;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinImportHandler_WinImportHandler_a0_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#endif

#ifndef __ac_fwd_PragmaOnce__
#define __ac_fwd_PragmaOnce__
class PragmaOnce;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif

#ifndef __ac_fwd_WinMacros__
#define __ac_fwd_WinMacros__
class WinMacros;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinMacros_WinMacros_a0_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinImportHandler__
#define __WinImportHandler__

/********************************************************/
/* Win #import directive support                        */
/********************************************************/

using namespace Puma;


class WinIfExists;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinImportHandler {
public:
  static WinImportHandler *aspectof () {
    static WinImportHandler __instance;
    return &__instance;
  }
  static WinImportHandler *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win #import directive                                */
  /********************************************************/

  // pointcuts
  
  
  // add access method for _importHandler data member
  

  // handle --import-handler option
  
public: template<class JoinPoint> void __a0_before (JoinPoint *tjp, const Config &config, bool process_includes) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    const ConfOption *opt;
    char *tmp;
    
    if (process_includes) {
      opt = config.Option ("--import-handler");
      if (opt && opt->Arguments ()) {
        // delete old import handler
        if (thisJoinPoint->that ()->_importHandler)
          delete[] thisJoinPoint->that ()->_importHandler;
        
        // get new import handler
        tmp = new char[strlen (opt->Argument (0))+1];
        strcpy (tmp, opt->Argument (0));
        thisJoinPoint->that ()->_importHandler = tmp;
      }
    }
  }
private:


protected:
  WinImportHandler () {}
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinImportHandler_WinImportHandler_a0_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    typedef typename Binding::template Arg<1> Arg1;
    ::WinImportHandler::aspectof()->__a0_before (tjp, (const Puma::Config &)Arg0::val (tjp), (bool)Arg1::val (tjp));
  }
} 



#endif /* __WinImportHandler__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __PragmaOnce__
#define __PragmaOnce__

/********************************************************/
/* Win #pragma once support aspect                      */
/********************************************************/

using std::cout;
using std::endl;

using namespace Puma;


class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class CCExprResolve;
class CExprResolve;
class PragmaOnce {
public:
  static PragmaOnce *aspectof () {
    static PragmaOnce __instance;
    return &__instance;
  }
  static PragmaOnce *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /******************************************************/
  /* detect #pragma once in the token stream of cpp     */
  /******************************************************/

  // pointcut definitions
  
  
  
  // extend the preprocessor parser by the filter state
  

  // initialize the filter state
  
public: template<class JoinPoint> void __a0_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    // TODO: it would be better to have construction advice -> but in lem file
    tjp->that ()->_pragma_token = 0;
  }
private:

  
  // filter #pragma once
  
public: template<class JoinPoint> void __a1_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    Token *tok = *tjp->result ();
    __JP_That &that = *tjp->that ();
    if (!tok || !tok->is_directive ()) {
      that._pragma_token = 0;
      return;
    }
    if (strcmp ("#pragma", tok->text ()) == 0) {
      that._pragma_token = tok;
    }
    else if (that._pragma_token && strcmp ("once", tok->text ()) == 0) {
      Unit *unit = (Unit*)tok->belonging_to ();
      assert (unit);
      unit->state ().onlyOnce (true);
    }
  }
private:

  
  /********************************************************/
  /* block the handling of pragma once files              */
  /********************************************************/

  // don't let file includer include files twice
  // to be precise: the file is included again, but the inclusion produces
  // no tokens
  
public: template<class JoinPoint> void __a2_around (JoinPoint *tjp, Unit *unit) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (! unit || ! unit->state ().onlyOnce ())
      tjp->proceed ();
  }
private:


  // includeFile shall return 0 if the file was not included
  
public: template<class JoinPoint> void __a3_after (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    Unit *&unit = *tjp->result ();
    if (unit && unit->state ().onlyOnce ())
      unit = 0;
  }
private:

    
protected:
  // this aspect should never be instantiated directly
  PragmaOnce () {}
};
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp) {
    ::PragmaOnce::aspectof()->__a0_after (tjp);
  }
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp) {
    ::PragmaOnce::aspectof()->__a1_after (tjp);
  }
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::PragmaOnce::aspectof()->__a2_around (tjp, (Puma::Unit *)Arg0::val (tjp));
  }
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp) {
    ::PragmaOnce::aspectof()->__a3_after (tjp);
  }
} 



#endif /* __PragmaOnce__ */
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __preprocessor_parser__
#define __preprocessor_parser__

// Preprocessor parser class. !!! The preprocessor parser has to 
// be added last to the composite parser of a translation unit !!!


#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

#include "Puma/CRecognizer.h"
#include "Puma/Location.h"
#include "Puma/LanguageID.h"
#include "Puma/Tokenizer.h"
#include "Puma/Unit.h"
#include "Puma/ErrorSink.h"
#include "Puma/Config.h"
#include "Puma/Source.h"

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_unit_h__
#define __c_unit_h__


#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

#include "Puma/CRecognizer.h"
#include "Puma/Location.h"
#include "Puma/LanguageID.h"
#include "Puma/Tokenizer.h"
#include "Puma/Unit.h"
#include "Puma/ErrorSink.h"
#include "Puma/Config.h"
#include "Puma/Source.h"

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CUnit : public Unit, public std::ostringstream {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  CScanner _scanner;

public:
  CUnit (ErrorSink &err) : _scanner (err) {}
  virtual ~CUnit () {}
  
  CScanner &scanner () const { return (CScanner&)_scanner; }
  void scan ();
};

inline std::ostream &endu (std::ostream &outs) {
  ((CUnit&)outs).scan ();
  return outs;
}


} // namespace Puma

#endif /* __c_unit_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_macro_expander__
#define __pre_macro_expander__

// The macro expander provides methods to expand a single macro or
// all macros of a given string or unit.

using std::set;

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_arg_desc__
#define __pre_arg_desc__

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __MacroUnit__
#define __MacroUnit__

// Special unit for macro expansions

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class MacroUnit : public Unit {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Unit *_CallingUnit;
  Token *_StartToken;
  Token *_EndToken;

public:
  MacroUnit () : _CallingUnit (0) {}
  MacroUnit (const Unit &u) : 
    Unit (u), _CallingUnit (0), _StartToken (0), _EndToken (0) {}
  virtual ~MacroUnit () {}
  
  // unit is a macro expansion
  virtual bool isMacroExp () const { return true; }

  // unit wherein the macro was called
  void CallingUnit (Unit *u) { _CallingUnit = u; }
  Unit *CallingUnit () const { return (Unit*)_CallingUnit; }
  
  // begin and end token of the macro call
  void MacroBegin (Token *t) { _StartToken = t; }
  void MacroEnd (Token *t) { _EndToken = t; }
  Token *MacroBegin () const { return _StartToken; }
  Token *MacroEnd () const { return _EndToken; }
  
  // get the first/last token of the whole macro expansion 
  // if the given token is the first/last token of this 
  // (sub-)expansion
  Token *ExpansionBegin (Token *) const;
  Token *ExpansionEnd (Token *) const;
};


} // namespace Puma

#endif /* __MacroUnit__ */
namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreArgDesc {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  // Collected arguments of a function-like macro.
  Array<MacroUnit> m_Args;
  // Begin token of the macro call.
  Token *m_Begin;
  // End token of the macro call.
  Token *m_End;

public:
  // Constructor.
  PreArgDesc () : m_Begin (0), m_End (0) {}
        
  Token *beginToken () const { return m_Begin; }
  Token *endToken () const { return m_End; }
  void beginToken (Token *t) { m_Begin = t; }
  void endToken (Token *t) { m_End = t; }
  
  int numArgs () const { return m_Args.length (); }
  void newArg () { m_Args[numArgs ()]; }
  MacroUnit &currArg () const { return (MacroUnit&)m_Args.lookup (numArgs ()-1); }
  MacroUnit &getArg (int i) const { return (MacroUnit&)m_Args.lookup (i); }
};


} // namespace Puma

#endif /* __pre_arg_desc__ */
namespace Puma {


class PreprocessorParser;
class PreMacroExpander;
class PreMacroManager;
class UnitManager;
class TokenStream;
class ErrorStream;
class PreMacro;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreMacroExpander {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  TokenStream        *_scanner;
  PreMacroManager    *_macroManager;
  UnitManager        *_unitManager;
  ErrorStream        *_err;
  Array<PreMacro*>   *_macroStack;
  
  PreprocessorParser *_parser;
        
  PreMacroExpander   *_preexpander;
  
  bool               _in_include; // true if an include directive is scanned

  set<Token*> *_prescanned; // Needed for macro expansion to avoid multiple
                            // processing steps with prescanned argument tokens

  // Check whether there is really a macro.
  bool checkForGoOn (bool mode = true) const;
        
  // Process the macro operator `##'.
  void processConcatOp (Unit *) const;
        
  // Process the macro operator `#'.
  void processStringOp (PreMacro *, Unit *, PreArgDesc &) const;
        
  // Stringify and replace an argument.
  void replaceStringifiedArg (int, Unit *, PreArgDesc &) const;
        
  // Replace an argument unchanged.
  void replaceUnchangedArg (int, Unit *, PreArgDesc &, Unit *, Token *, bool) const;

  // Test whether a string is an argument of a macro.
  int isArg (const char *, PreMacro *) const;
        
  // Compare two macro argument identifier.
  bool equal (const char *, const char *) const;

  // Build an unit from a string.
  Unit *buildUnit (const char *) const;
        
  // Collect the arguments of a function-like macro.
  void collectArgs (PreMacro *, PreArgDesc &) const;
        
  // Expand a function-like macro.
  void substituteMacro (PreMacro *, PreArgDesc &) const;
        
  // Process the special keyword `defined'.
  void processDefined (PreMacro *, PreArgDesc &) const;
        
  // Prescan an argument of a macro call.
  Unit& prescanArgument (Unit *) const;

  // Expand the given macro. 
  bool expandMacro (Token *, PreMacro *) const;

  // Reset the expander to a special initial state.
  void reset (PreprocessorParser *, Array<PreMacro*> *, set<Token*> *);
        
  // Expand all macros of the given unit.
  Unit *expandMacros (Unit *, set<PreMacro*> * = 0);
        
  // Push unit on token stream.
  void pushUnit (TokenStream &, Unit *) const;

public:
  // Special constructor. Call reset() before using the expander.
  PreMacroExpander ();
        
  PreMacroExpander (PreprocessorParser *);
  ~PreMacroExpander () { if (_preexpander) delete _preexpander; }

  // Reset the expander to the initial state.
  void reset (PreprocessorParser *);
        
  // Set a flag that is used to check whether a macro is expanded in a
  // #include directive
  void inInclude (bool ii) { _in_include = ii; }
  
  // Expand the given macro. 
  bool expandMacro (PreMacro *, Token *);
        
  // Expand all macros of the given string.
  char *expandMacros (const char *);
};


} // namespace Puma

#endif /* __pre_macro_expander__ */
using namespace std;

namespace Puma {


class PreTree;
class ErrorStream;
class UnitManager;
class PrePredicate;
class PreLevelState;
class PreParserState;
class PreMacroManager;
class PreFileIncluder;
class PrePredicateManager;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreprocessorParser : public PumaTokenSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  // The current mode for token preprocessing
  typedef enum { 
    INITIAL, 
    DEFINING, 
    MAYBEMACRO, 
    ASSERT,
    TOKENLIST, 
    DIRECTIVE, 
    MACRO 
  } PreMode;

private:
  // Do not print the result of the parse process.
  bool _silentMode;

  // If the preprocessor parser is the last in chain,
  // the result of the parse process will be putted on 
  // the given stream.
  ostream *_out;

  // Stack for the macro expansion.
  Array<PreMacro*>    *_macroStack;
  set<Token*>         *_prescanned;

  PreLevelState       *_levelState;
  PreParserState      *_parserState;
  PreMacroManager     *_macroManager;
  PreFileIncluder     *_fileIncluder;
  PrePredicateManager *_predicateManager;
  UnitManager         *_unitManager;
  UnitManager         *_locals;

  PreMacroExpander     _expander;
  PreMacroExpander     _macroExpander;        
        
  PreMode              _pre_mode;
  bool                       _support_gnu;

  CScanner             _scanner;
  TokenStream         *_stream;
                
  const char          *_importHandler;

private:
  // Parse a single token.
  Token* parseToken ();

  // Free the preprocessor syntax tree.
  void freeSyntaxTree (PreTree*);

public:
  // Get several preprocessor informations.
  Array<PreMacro*>    *macroStack () const       { return _macroStack; }
  set<Token*>         *prescanned () const       { return _prescanned; }
  PreLevelState       *levelState () const       { return _levelState; }
  PreParserState      *parserState () const      { return _parserState; }
  PreMacroManager     *macroManager () const     { return _macroManager; }
  PreFileIncluder     *fileIncluder () const     { return _fileIncluder; }
  PrePredicateManager *predicateManager () const { return _predicateManager; }
  UnitManager         *unitManager () const      { return _unitManager; }
  UnitManager         *locals () const           { return _locals; }
  PreMode              pre_mode () const         { return _pre_mode; } 
  bool                 supportGNU () const       { return _support_gnu; }
  CScanner            &cscanner () const         { return (CScanner&) _scanner; }

  // Return the preprocessor syntax tree.
  PreTree *syntaxTree () const;

public:
  PreprocessorParser (ErrorStream *, UnitManager *, UnitManager *, 
                        ostream &out = cout, int max_depth = 400);
                           
  ~PreprocessorParser ();
        
  // Reset the preprocessor parser.
  void reset (ErrorStream *, UnitManager *, UnitManager *, 
              ostream &out = cout, int max_depth = 400);

  // Free the preprocessor syntax tree.
  void freeSyntaxTree ();
        
  // Configure the preprocessor.
  public: inline void __exec_old_configure(const ::Puma::Config & ,bool );
void configure (const Config &, bool = true);
        
  // Get the next token to parse.
  public: inline ::Puma::Token * __exec_old_next();
Token *next ();
        
  TokenStream *scanner () const { return _stream; }
  void stream (TokenStream *s) { _stream = s; }

  // Map scanner token types to parser token types
  int map_token (Token *token, bool &parse);

  // Invoke the parse process.
  void parse ();
        
  // Switch to silent mode.
  void silentMode (bool mode = true) { _silentMode = mode; }

  // Define a new macro.
  void defMacro (const char *, const char * = (const char*)0, char = 0) const;
        
  // Undefine a macro.
  void undefMacro (const char *) const;
        
  // Define a new predicate.
  void defPredicate (const char *, const char *) const;
        
  // Undefine a predicate.
  void undefPredicate (const char *) const;
        
  // Add a new include path.
  void addInclPath (const char *) const;

  void supportGNU (bool);
   private:
  typedef PreprocessorParser WinIfExistsCpp;
 public :

Stack < unsigned > _depth ;

void skip_up_to ( int ) ;  private:
 public :
const char * importHandler ( ) const { return _importHandler ; }  private:
 Token * _pragma_token ;};


} // namespace Puma

#endif /* __preprocessor_parser__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
using std::map;

namespace Puma {


class PreParserState;
class TokenStream;
class UnitManager;
class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreFileIncluder {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int                       _next;
  PreParserState     *_state;
  ErrorStream        *_err;
  UnitManager        *_unitManager;
  PreprocessorParser *_parser;
  
  PreMacroExpander _expander;

  // List of include paths.
  Array<char*> _includeDirs;
  
  // true if the last included file was protected by an active include guard
  bool _guarded;

  // the set of included units, the Token is 0 or the name of an include guard
  map<Unit*, Token*> _includedUnits;
  
  // Builds a macro expanded unit from a string.
  Unit *buildUnit (const char *);
        
  // Prepare to include a file from current working directory.
  Unit *includeFromCwd (Unit *);
        
  // Prepare to include a file from system include directories.
  Unit *includeFromSystem (Unit *);
        
  // Try to locate the include file.
  Unit *searchFile (const char *, bool);
        
  // Include the file.
  Unit *doInclude (const char *, const char *, bool);

  // check if this file has an include guard that is already active
  bool hasActiveIncludeGuard (Unit *unit);

  // check if this file has an include guard
  static Token *hasIncludeGuard (Unit *unit);

  // Return true if string is not of format "..." or <...>.
  bool assumeMacroCalls (const char *) const;
        
public:
  PreFileIncluder (PreprocessorParser &);
  ~PreFileIncluder ();
                
  // Push unit on token stack.
  public: inline void __exec_old_pushOnStack(::Puma::Unit * );
void pushOnStack (Unit *);
        
  // Include a file.
  public: inline ::Puma::Unit * __exec_old_includeFile(const char * name);
Unit *includeFile (const char *name);
  Unit *handleIncludeOption (const char *name);
                          
  // Include the next file of the given name.
  Unit *includeNextFile (const char *name);

  // returns true if the last included file was protected by an active
  // include guard
  bool guarded () const { return _guarded; }

  // Add a new include path to list of include paths.
  void addIncludePath (const char *path);
        
  Array<char*> &getIncludePaths () { return (Array<char*> &)_includeDirs; }
};


} // namespace Puma

#endif /* __pre_file_includer__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __syntax_tree_token__
#define __syntax_tree_token__

// Class PreTreeToken makes it possible to let tokens be
// a part of a syntax tree.

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreTreeToken : public PreTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Token *_token;
        
public:
  PreTreeToken (Token *token) : _token (token) {}

  // Accept() is part of the visitor concept to put class
  // functionallity into another class.
  void accept (PreVisitor &v)
    { v.visitPreTreeToken (this); }            
        
  // Return the start or end token.
  Token *startToken () const { return _token; }
  Token *endToken () const   { return _token; }
        
  // Return the token.
  Token *token () const      { return _token; }
};


} // namespace Puma

#endif /*__syntax_tree_token__ */

#ifndef __ac_fwd_WinIfExists__
#define __ac_fwd_WinIfExists__
class WinIfExists;
namespace AC {
  template <class JoinPoint>
  inline void invoke_WinIfExists_WinIfExists_a0_around (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#endif

#ifndef __ac_fwd_WinImportHandler__
#define __ac_fwd_WinImportHandler__
class WinImportHandler;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinImportHandler_WinImportHandler_a0_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#endif

#ifndef __ac_fwd_PragmaOnce__
#define __ac_fwd_PragmaOnce__
class PragmaOnce;
namespace AC {
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a0_after (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a1_after (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_PragmaOnce_PragmaOnce_a2_around (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_PragmaOnce_PragmaOnce_a3_after (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif

#ifndef __ac_fwd_WinMacros__
#define __ac_fwd_WinMacros__
class WinMacros;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinMacros_WinMacros_a0_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#endif
#ifndef __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
#define __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __preprocessor_parser__
#define __preprocessor_parser__

// Preprocessor parser class. !!! The preprocessor parser has to 
// be added last to the composite parser of a translation unit !!!

#include "Puma/Stack.h"
#include "Puma/Config.h"
#include "Puma/CScanner.h"
#include "Puma/CUnit.h"
#include "Puma/TokenSource.h"
#include "Puma/PreMacroExpander.h"
#include <iostream>
#include <set>
using namespace std;

namespace Puma {


class PreTree;
class ErrorStream;
class UnitManager;
class PrePredicate;
class PreLevelState;
class PreParserState;
class PreMacroManager;
class PreFileIncluder;
class PrePredicateManager;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreprocessorParser : public PumaTokenSource {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  // The current mode for token preprocessing
  typedef enum { 
    INITIAL, 
    DEFINING, 
    MAYBEMACRO, 
    ASSERT,
    TOKENLIST, 
    DIRECTIVE, 
    MACRO 
  } PreMode;

private:
  // Do not print the result of the parse process.
  bool _silentMode;

  // If the preprocessor parser is the last in chain,
  // the result of the parse process will be putted on 
  // the given stream.
  ostream *_out;

  // Stack for the macro expansion.
  Array<PreMacro*>    *_macroStack;
  set<Token*>         *_prescanned;

  PreLevelState       *_levelState;
  PreParserState      *_parserState;
  PreMacroManager     *_macroManager;
  PreFileIncluder     *_fileIncluder;
  PrePredicateManager *_predicateManager;
  UnitManager         *_unitManager;
  UnitManager         *_locals;

  PreMacroExpander     _expander;
  PreMacroExpander     _macroExpander;        
        
  PreMode              _pre_mode;
  bool                       _support_gnu;

  CScanner             _scanner;
  TokenStream         *_stream;
                
  const char          *_importHandler;

private:
  // Parse a single token.
  Token* parseToken ();

  // Free the preprocessor syntax tree.
  void freeSyntaxTree (PreTree*);

public:
  // Get several preprocessor informations.
  Array<PreMacro*>    *macroStack () const       { return _macroStack; }
  set<Token*>         *prescanned () const       { return _prescanned; }
  PreLevelState       *levelState () const       { return _levelState; }
  PreParserState      *parserState () const      { return _parserState; }
  PreMacroManager     *macroManager () const     { return _macroManager; }
  PreFileIncluder     *fileIncluder () const     { return _fileIncluder; }
  PrePredicateManager *predicateManager () const { return _predicateManager; }
  UnitManager         *unitManager () const      { return _unitManager; }
  UnitManager         *locals () const           { return _locals; }
  PreMode              pre_mode () const         { return _pre_mode; } 
  bool                 supportGNU () const       { return _support_gnu; }
  CScanner            &cscanner () const         { return (CScanner&) _scanner; }

  // Return the preprocessor syntax tree.
  PreTree *syntaxTree () const;

public:
  PreprocessorParser (ErrorStream *, UnitManager *, UnitManager *, 
                        ostream &out = cout, int max_depth = 400);
                           
  ~PreprocessorParser ();
        
  // Reset the preprocessor parser.
  void reset (ErrorStream *, UnitManager *, UnitManager *, 
              ostream &out = cout, int max_depth = 400);

  // Free the preprocessor syntax tree.
  void freeSyntaxTree ();
        
  // Configure the preprocessor.
  public: inline void __exec_old_configure(const ::Puma::Config & ,bool );
void configure (const Config &, bool = true);
        
  // Get the next token to parse.
  public: inline ::Puma::Token * __exec_old_next();
Token *next ();
        
  TokenStream *scanner () const { return _stream; }
  void stream (TokenStream *s) { _stream = s; }

  // Map scanner token types to parser token types
  int map_token (Token *token, bool &parse);

  // Invoke the parse process.
  void parse ();
        
  // Switch to silent mode.
  void silentMode (bool mode = true) { _silentMode = mode; }

  // Define a new macro.
  void defMacro (const char *, const char * = (const char*)0, char = 0) const;
        
  // Undefine a macro.
  void undefMacro (const char *) const;
        
  // Define a new predicate.
  void defPredicate (const char *, const char *) const;
        
  // Undefine a predicate.
  void undefPredicate (const char *) const;
        
  // Add a new include path.
  void addInclPath (const char *) const;

  void supportGNU (bool);
   private:
  typedef PreprocessorParser WinIfExistsCpp;
 public :

Stack < unsigned > _depth ;

void skip_up_to ( int ) ;  private:
 public :
const char * importHandler ( ) const { return _importHandler ; }  private:
 Token * _pragma_token ;};


} // namespace Puma

#endif /* __preprocessor_parser__ */
#endif // __ac_guard__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_PreprocessorParser_h__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_syntax_tree_nodes__
#define __pre_syntax_tree_nodes__

// Contains all node classes for the preprocessor syntax tree.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __syntax_tree_composite__
#define __syntax_tree_composite__

namespace Puma {


// Generic composite nodes:
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreTreeComposite : public PreTree {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

private:
  Array<PreTree*> *son_array;
  Array<PreTree*> *daughter_array;
  int                    max_sons;
  int                    max_daughters;

protected:
  PreTreeComposite (int s, int d);
    
public:
  static const int DYNAMIC = -1;

  virtual ~PreTreeComposite ();
        
  virtual void accept (PreVisitor &) = 0;

  virtual void add_son (PreTree *);
  virtual void replace_son (int, PreTree *);
  virtual PreTree *son (int) const;
  virtual int sons () const;

  virtual void add_daughter (PreTree *);
  virtual void replace_daughter (int, PreTree *);
  virtual PreTree *daughter (int) const;
  virtual int daughters () const;
        
  virtual Token *startToken () const;
  virtual Token *endToken () const;
};


} // namespace Puma

#endif /* __syntax_tree_composite__ */
namespace Puma {


// The root node of the preprocessor syntax tree.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreProgram : public PreTreeComposite {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  PreProgram (PreTree* a) : PreTreeComposite (1, 0) 
    { add_son (a); };

  void accept (PreVisitor &v) {
    v.visitPreProgram_Pre (this);
    v.iterateNodes (this);
    v.visitPreProgram_Post (this);
  }            
};      


// Assemble groups of directive groups to a `super' group => the program.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreDirectiveGroups : public PreTreeComposite {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  PreDirectiveGroups () : PreTreeComposite (-1, 0) {};

  void accept (PreVisitor& v) {
    v.visitPreDirectiveGroups_Pre (this);
    v.iterateNodes (this);
    v.visitPreDirectiveGroups_Post (this);
  }            
};      


// Assemble conditional directives to a logical group.
// Like: #if ... #elif ... #else ... #endif.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreConditionalGroup : public PreTreeComposite {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  PreConditionalGroup (PreTree* a, PreTree* b, PreTree* c) : 
    PreTreeComposite (3, 0) // 3 sons, no daughters.
    { add_son (a); add_son (b); add_son (c); };
        
  PreConditionalGroup (PreTree* a, PreTree* b, PreTree* c, PreTree* d) : 
    PreTreeComposite (4, 0) // 4 sons, no daughters.
    { add_son (a); add_son (b); add_son (c); add_son (d); };

  void accept (PreVisitor& v) {
    v.visitPreConditionalGroup_Pre (this);
    v.iterateNodes (this);
    v.visitPreConditionalGroup_Post (this);
  }
};      


// Assemble conditional directives within the else part of a 
// conditional group to a logical group.
// Like: ... #elif ... #elif ... #elif ... #else.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreElsePart : public PreTreeComposite {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

public:
  PreElsePart (PreTree* a, PreTree* b) : 
    PreTreeComposite (2, 0) // 2 sons, no daughters.
    { add_son (a); add_son (b); };
                                        
  PreElsePart (PreTree* a, PreTree* b, PreTree* c) : 
    PreTreeComposite (3, 0) // 3 sons, no daughters.
    { add_son (a); add_son (b); add_son (c); };

  void accept (PreVisitor& v) {
    v.visitPreElsePart_Pre (this);
    v.iterateNodes (this);
    v.visitPreElsePart_Post (this);
  }
};      


// Assemble conditional directives in the elif part of a conditional 
// group to a logical group.
// Like: ... #elif ... #elif ... #elif.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreElifPart : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                // Dynamic sons, no daughters.
        PreElifPart () : PreTreeComposite (-1, 0) {};
        
        // Add two sons.
        void addSons (PreTree* a, PreTree* b)
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreElifPart_Pre (this);
            v.iterateNodes (this);
            v.visitPreElifPart_Post (this);
        }
 };      


// The #if directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreIfDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreIfDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 1) // 2 sons, 1 daughter.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreIfDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreIfDirective_Post (this);
        }
 };      


// The #ifdef directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreIfdefDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreIfdefDirective (PreTree* a, PreTree* b, PreTree* c) 
                        : PreTreeComposite (3, 1) // 3 sons, 1 daughter.
            { add_son (a); add_son (b); add_son (c); };
        PreIfdefDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughter.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreIfdefDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreIfdefDirective_Post (this);
        }
 };      


// The #ifndef directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreIfndefDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreIfndefDirective (PreTree* a, PreTree* b, PreTree* c) 
                        : PreTreeComposite (3, 1) // 3 sons, 1 daughter.
            { add_son (a); add_son (b); add_son (c); };
        PreIfndefDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughter.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreIfndefDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreIfndefDirective_Post (this);
        }
 };      


// The #elif directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreElifDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreElifDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 1) // 2 sons, 1 daughter.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreElifDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreElifDirective_Post (this);
        }
 };      


// The #else directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreElseDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreElseDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreElseDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreElseDirective_Post (this);
        }
 };      


// The #endif directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreEndifDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreEndifDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreEndifDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreEndifDirective_Post (this);
        }
 };      


// The #include and #include_next directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreIncludeDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

        int _depth;

    public:
                                        
        PreIncludeDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 1) // 2 sons, 1 daughter.
            { add_son (a); add_son (b); _depth = -1; };

        void accept (PreVisitor& v)
        {
            v.visitPreIncludeDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreIncludeDirective_Post (this);
        }
        
        int depth () const 
        {
            return _depth;
        }

        void depth (int d)
        {
            _depth = d;
        }
        
        bool is_forced () const {
          return !((Unit*)startToken ()->belonging_to ())->isFile ();
        }
 };      


// The #assert directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreAssertDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreAssertDirective (PreTree* a, PreTree* b, PreTree* c) 
                        : PreTreeComposite (3, 0) // 3 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); };
        PreAssertDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreAssertDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreAssertDirective_Post (this);
        }
 };      


// The #unassert directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreUnassertDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreUnassertDirective (PreTree* a, PreTree* b, PreTree* c) 
                        : PreTreeComposite (3, 0) // 3 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); };
        PreUnassertDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreUnassertDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreUnassertDirective_Post (this);
        }
 };      


// The #define directive that defines function-like macros.
// Like: #define FUNCTION (id,...,id) ... ... ...
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreDefineFunctionDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreDefineFunctionDirective (PreTree* a, PreTree* b, 
                                    PreTree* c, PreTree* d, 
                                    PreTree* e, PreTree* f, 
                                    PreTree* g, PreTree* h) 
                        : PreTreeComposite (8, 0) // 8 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); add_son (d);
              add_son (e); add_son (f); add_son (g); add_son (h); }

        PreDefineFunctionDirective (PreTree* a, PreTree* b, 
                                    PreTree* c, PreTree* d, 
                                    PreTree* e, PreTree* f, 
                                    PreTree* g) 
                        : PreTreeComposite (7, 0) // 7 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); add_son (d);
              add_son (e); add_son (f); add_son (g); }

        PreDefineFunctionDirective (PreTree* a, PreTree* b, 
                                    PreTree* c, PreTree* d, 
                                    PreTree* e, PreTree* f) 
                        : PreTreeComposite (6, 0) // 6 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); add_son (d);
              add_son (e); add_son (f); }
        
        PreDefineFunctionDirective (PreTree* a, PreTree* b, PreTree* c, 
                                   PreTree* d, PreTree* e) 
                        : PreTreeComposite (5, 0) // 5 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); add_son (d); add_son (e); }

        void accept (PreVisitor& v)
        {
            v.visitPreDefineFunctionDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreDefineFunctionDirective_Post (this);
        }
 };              


// The #define directive that defines symbolic constants macros.
// Like: #define CONSTANT ... ... ...
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreDefineConstantDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreDefineConstantDirective (PreTree* a, PreTree* b, PreTree* c) 
                        : PreTreeComposite (3, 0) // 3 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); };
        PreDefineConstantDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreDefineConstantDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreDefineConstantDirective_Post (this);
        }
 };      


// The #undef directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreUndefDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreUndefDirective (PreTree* a, PreTree* b, PreTree* c) 
                        : PreTreeComposite (3, 0) // 3 sons, no daughters.
            { add_son (a); add_son (b); add_son (c); };
        PreUndefDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreUndefDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreUndefDirective_Post (this);
        }
 };      


// The #warning directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreWarningDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreWarningDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreWarningDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreWarningDirective_Post (this);
        }
 };      


// The #error directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreErrorDirective : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreErrorDirective (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreErrorDirective_Pre (this);
            v.iterateNodes (this);
            v.visitPreErrorDirective_Post (this);
        }
 };      


// Collects comma separated argument identifiers for a function-like macro.
// Like: id, id, ..., id.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreIdentifierList : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        // Dynamic sons, no daughters. 
        PreIdentifierList (PreTree* a) : PreTreeComposite (-1, 0)
            { add_son (a); };
        
        // Add two sons.
        void addSons (PreTree* a, PreTree* b)
            { add_son (a); add_son (b); };

        void accept (PreVisitor& v)
        {
            v.visitPreIdentifierList_Pre (this);
            v.iterateNodes (this);
            v.visitPreIdentifierList_Post (this);
        }
 };      


// Collects every kind of token  (except comments) for the macro body.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreTokenList : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        
        PreTokenList (PreTree* a, PreTree* b) 
                        : PreTreeComposite (2, 0) // 2 sons, no daughters.
            { add_son (a); add_son (b); };
        PreTokenList (PreTree* a) 
                        : PreTreeComposite (1, 0) // 1 son, no daughters.
            { add_son (a); };
        PreTokenList () : PreTreeComposite (0, 0) // no sons, no daughters.
            { };
        
        void accept (PreVisitor& v)
        {
            v.visitPreTokenList_Pre (this);
            v.iterateNodes (this);
            v.visitPreTokenList_Post (this);
        }
 };      


// Contains every kind of token  (except comments) for the macro body.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreTokenListPart : public PreTreeComposite
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:
                                        // Dynamic sons, no daughters.
        PreTokenListPart (PreTree* a) : PreTreeComposite (-1, 0)
            { add_son (a); };
        
        void accept (PreVisitor& v)
        {
            v.visitPreTokenListPart_Pre (this);
            v.iterateNodes (this);
            v.visitPreTokenListPart_Post (this);
        }
 };      


// Semantic node for conditionals.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreCondSemNode : public PreTree
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

        // Boolean value of the condition of a conditional.
        bool _value;

    public:

        PreCondSemNode (bool value) : _value (value) {};
        
        void accept (PreVisitor& v)
        {
            v.visitPreCondSemNode (this);
        }
        
        // Get the value of the conditional.
        bool value () const { return _value; }
 };      


// Semantic node for the #include directive.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreInclSemNode : public PreTree
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

        // Pointer of the included file unit.
        Unit* _unit;
        
        // true if the inclusion was not done, because of an active include
        // guard
        bool _guarded;

    public:

        PreInclSemNode (Unit* unit, bool guarded) :
          _unit (unit), _guarded (guarded) {};
        
        void accept (PreVisitor& v)
        {
            v.visitPreInclSemNode (this);
        }
        
        // Get the included file unit.
        Unit* unit () const { return _unit; }
        
        // Check if the inclusion was not done, because of an include guard
        bool guarded () const { return _guarded; }
 };      


// Special parse error node to show the location of an error in the
// preprocessor syntax tree.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PreError : public PreTree
 {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

    public:

        PreError () {};
        
        void accept (PreVisitor& v)
        {
            v.visitPreError (this);
        }
 };      


} // namespace Puma

#endif /* __pre_syntax_tree_nodes__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __pre_predicate_manager__
#define __pre_predicate_manager__

// The predicate manager manages all preprocessor predicates defined
// through the `#assert' directive in the source code.

using std::map;
using std::string;

namespace Puma {


class PrePredicate;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PrePredicateManager : private map<string, PrePredicate*> {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  typedef map<string, PrePredicate*> PMap;
  
public:

  // Destroy the predicates too.
  ~PrePredicateManager ();

  // Add given predicate to predicate table.
  void addPredicate (PrePredicate *);
        
  // Remove predicate `name' from predicate table.
  void removePredicate (const char *name);
        
  // Get predicate `name'.
  PrePredicate *getPredicate (const char *) const;
};


} // namespace Puma

#endif /* __pre_predicate_manager__ */
#include <stdlib.h>
using namespace std;


using namespace Puma;

// Definition of the Lemon generated parser interface.
void *PreParserAlloc (void *(*mallocProc)(...));
void PreParser       (void *pParser, int TokenID, PreTree *TokenValue);
void PreParserFree   (void *pParser, void (*freeProc)(...));
void PreParserTrace  (FILE *TraceFILE, char *zTracePrompt);

namespace Puma {


static PreprocessorParser*  parser;           // Current preprocessor parser.
static PreParserState*      state;            // Current parser.
static PreLevelState*       level;            // Current level state.
static ErrorStream*         err;              // Current error stream.

// Build a string from a subtree of the preprocessor syntax tree.
char* buildString (const PreTree* node)
 {
    if (! node) return (char*) 0;

    char *result, *ptr;
    string str;

    // If subtree isn't empty concatenate all tokens to a single string.
    if (node->sons ()) {
        PreTokenListPart* list = (PreTokenListPart*) node->son (0);
        
        // Fill the buffer.
        for (unsigned int i = 0; i < (unsigned int) list->sons (); i++) {
            str += ((PreTreeToken*) list->son (i))->token ()->text ();
        }
    } 
    
    // Create the return string buffer.
    ptr = result = new char[str.size() + 5];

    // Copy the buffer into the return buffer but skip newlines.
    for (unsigned int i = 0; i < str.size(); i++)
        if (str[i] != '\n') 
            *ptr++ = str[i];
        else
          cout << "newline " << i << endl;
            
    // Finish return buffer.
    *ptr = '\0';

    return result;
 }


// Evaluate a special answer string.
char* evalAnswerString (char* string, bool mode, PreParserState& state)
 {
    if (! string) return (char*) 0;

    // Scan the token string and build an unit.
    Unit *unit = new Unit ();
    parser->cscanner ().allow_macro_ops ();
    parser->cscanner ().fill_unit (string, *unit);
    parser->cscanner ().allow_macro_ops (false);
    
    // The call to an #assert (#unassert) directive expects the 
    // form: #assert PREDICATENAME (ANSWERTEXT). This function 
    // evaluates the answer token text to get the real answer text.
    
    Token* token;
    
    // Search the right parenthesis.
    for (token = (Token*) unit->first (); token;
         token = (Token*) unit->next (token))
        if (token->is_core () && token->type () == TOK_OPEN_ROUND)
            break;
    
    // No right parenthesis found -> parse error.
    if (! token) {
        if (mode) {
            *(state.err) << state.currToken->location () << sev_error
                << "Missing token list in `#assert'" 
                << endMessage; 
            return (char*) 0;
        } else { 
            string = new char[1]; 
            *string = '\0'; 
            return string; 
        }
    }
    
    // Delete all tokens before the right parenthesis.
    unit->kill ((Token*) unit->first (), token);
    
    // Search the left parenthesis.
    for (token = (Token*) unit->first (); token;
         token = (Token*) unit->next (token))
        if (token->is_core () && token->type () == TOK_CLOSE_ROUND)
            break;
    
    // No left parenthesis found -> parse error.
    if (! token) {
        *(state.err) << state.currToken->location ()
                     << sev_error << "Unterminated token list in ";
        if (mode) *(state.err) << "`#assert'";
        else      *(state.err) << "`#unassert'";
        *(state.err) << endMessage; 
        return (char*)0;
    }
    
    // Delete all tokens after the left parenthesis.
    unit->kill (token, (Token*) unit->last ());

    // Get the text between the parenthesis.
    char* answer = StrCol::buildString (unit);
    delete unit;
    
    // An empty answer causes a parse error.
    if (StrCol::onlySpaces (answer)) {
        *(state.err) << state.currToken->location () 
                     << sev_error << "Empty token list in ";
        if (mode) *(state.err) << "`#assert'";
        else      *(state.err) << "`#unassert'";
        *(state.err) << endMessage; 
        delete[] answer;
        return (char*) 0;
    }
    
    // Return the real answer text.
    return answer;
 }


// Update the bodies of some predefined macros.
void updatePredefined ()
 {
    TokenStream*     scanner = parser->scanner ();
    PreMacroManager* mm      = parser->macroManager ();
    
    if (scanner->length ()) {
        state->checkPredefined (mm->getIncLevelMacro (), scanner, *mm);
        state->checkPredefined (mm->getLineMacro (), scanner, *mm);
        state->checkPredefined (mm->getDateMacro (), scanner, *mm);
        state->checkPredefined (mm->getTimeMacro (), scanner, *mm);
        state->checkPredefined (mm->getFileMacro (), scanner, *mm);
    }
 }


// Send a newline token to the parser.
void sendNLToken ()
 {
    Token* token = state->newline;
    token->location (state->lastToken->location ());
    state->lastType = TOK_PRE_NEWLINE;
    PreTreeToken* synToken = new PreTreeToken (token);
    PreParser (state->pParser, state->lastType, synToken);
    PreParser (state->pParser, TOK_PRE_DIRECTIVE_END, (PreTree*) 0);
 }


// Return true if we are at the end of a directive.
bool atEndOfDirective (PreprocessorParser::PreMode mode)
 {
    int type = state->lastType;
    if (mode != PreprocessorParser::DEFINING &&
        mode != PreprocessorParser::ASSERT &&
        mode != PreprocessorParser::DIRECTIVE &&
        mode != PreprocessorParser::MACRO)
      if (type == TOK_PRE_ELSE    || type == TOK_PRE_ENDIF   || 
          type == TOK_PRE_ERROR   || type == TOK_PRE_WARNING || 
          type == TOK_PRE_TOKEN_LIST || type == TOK_PRE_RPAREN     || 
          type == TOK_PRE_ID) 
          return true;
    return false;
 }


// Prevent a special kind of parse error.
void preventEOFError (PreprocessorParser::PreMode mode)
 {
    // If the parser is parsing a directive and the next token
    // isn't a preprocessor token like expected there may be an
    // EOF at end of the directive. But the parser can't recognize
    // EOFs within directives, it would cause a parse error. But
    // it should be allowed to finish a directive with an EOF too
    // and not only with a newline. So it will be send a newline
    // to the parser if such an EOF is suspected.
    if (! state->currToken->is_comment () && state->lastToken) 
        if (atEndOfDirective (mode)) 
            sendNLToken ();
 }


// Prevent a special kind of parse error.
void preventInclEOFError (PreprocessorParser::PreMode mode)
 {
    // If an included file ends with a preprocessor directive the parser 
    // would expect that after the #include (that has included the file) 
    // is a newline. But if there is no newline but a new preprocessor 
    // directive a parse error would occure. In such a case we simply give 
    // the parser the expected newline token to prevent the error.
    if (state->lastToken)
        if (atEndOfDirective (mode)) 
        {
            int type = state->currType;
            if (type == TOK_PRE_DEFINE  || type == TOK_PRE_UNDEF    ||
                type == TOK_PRE_ASSERT  || type == TOK_PRE_UNASSERT ||
                type == TOK_PRE_WARNING || type == TOK_PRE_ERROR    ||
                type == TOK_PRE_IFDEF   || type == TOK_PRE_IFNDEF   ||
                type == TOK_PRE_IF      || type == TOK_PRE_ELIF     ||
                type == TOK_PRE_ELSE    || type == TOK_PRE_ENDIF    ||
                type == TOK_PRE_INCLUDE || type == TOK_PRE_INCLUDE_NEXT)
                sendNLToken ();
        }
 }


// Prevent a special kind of parse error.
bool directiveAtEOF ()
 {
    // An EOF within a directive is suspected. It's the same problem
    // like above.
    if (state->lastToken)
        if (parser->pre_mode () != PreprocessorParser::INITIAL) 
        {
            state->currToken = state->lastToken;
            state->currType = state->lastType;
            sendNLToken ();
            if (((TokenStream*) parser->scanner ())->length ()) 
            {
                // The last token of the main input file belongs to an
                // `#include' directive and nothing but EOF is following.
                // And now it is one more file to parse so the parser has
                // to be called again.
                state->lastToken = state->newline;
                state->lastToken->location (state->currToken->location ());
                state->lastType = TOK_PRE_NEWLINE;
                return true;
            }
        }
    return false;
 }


// Constructor of the preprocessor parser class.
PreprocessorParser::PreprocessorParser (ErrorStream* err, UnitManager* unitManager,
    UnitManager* locals, ostream& out, int max_depth) : _scanner (*err)
 {
    //PreParserTrace(stdout,"PRE_TRACE: ");
    _parserState                  = new PreParserState ();
    _parserState->maxIncludeDepth = max_depth;
    _parserState->err             = err;
    _parserState->pParser         = PreParserAlloc ((void* (*)(...))malloc);
    _silentMode                   = false;
    _out                          = &out;
    _unitManager                  = unitManager;
    _locals                       = locals;
    _levelState                   = new PreLevelState ();
    _macroStack                   = new Array<PreMacro*> ();
    _prescanned                   = new set<Token*>;
    _predicateManager             = new PrePredicateManager ();
    _macroManager                 = new PreMacroManager (err);
    _fileIncluder                 = new PreFileIncluder (*this);
    _pre_mode                     = INITIAL;    
    _support_gnu                  = true;
    _importHandler                = 0;
 }


PreprocessorParser::~PreprocessorParser ()
 {
    // Free the lemon generated parser.
    PreParserFree (_parserState->pParser, (void (*)(...))::free);
    delete _macroManager;
    delete _fileIncluder;
    delete _levelState;
    delete _parserState;
    delete _predicateManager;
    delete _macroStack;
    delete _prescanned;
    if (_importHandler)
      delete[] _importHandler;
 }

 
// Constructor of the preprocessor parser class.
void PreprocessorParser::reset (ErrorStream* err, UnitManager* unitManager,
                        UnitManager* locals, ostream& out, int max_depth)
 {
    delete _macroManager;
    delete _fileIncluder;
    delete _levelState;
    delete _parserState;
    delete _predicateManager;
    delete _macroStack;
    delete _prescanned;
    if (_importHandler)
      delete[] _importHandler;

    _parserState                  = new PreParserState ();
    _silentMode                   = false;
    _out                          = &out;
    _unitManager                  = unitManager;
    _locals                          = locals;
    _parserState->maxIncludeDepth = max_depth;
    _parserState->err             = err;
    _parserState->pParser         = PreParserAlloc ((void* (*)(...))malloc);
    _macroManager                 = new PreMacroManager (err);
    _fileIncluder                 = new PreFileIncluder (*this);
    _levelState                   = new PreLevelState ();
    _macroStack                   = new Array<PreMacro*> ();
    _prescanned                   = new set<Token*>;
    _predicateManager             = new PrePredicateManager ();
    _pre_mode                     = INITIAL;    
    _support_gnu                  = true;
    _importHandler                = 0;
 }


// Map scanner token types to parser token types
int PreprocessorParser::map_token (Token *token, bool &parse) {
  // default:
  int type = token->type ();
  parse = true;

  if (token->is_comment ()) {
    parse = false;
    return type;
  }

  // If the scope changes to another file, the mapping mode
  // must be reset due to a missing NEWLINE at end of the
  // previous file (In this case the mapping mode wouldn't
  // change correctly).
  if (state->lastToken)
    if (token->location ().filename ().name () !=
        state->lastToken->location ().filename ().name ())
      _pre_mode = INITIAL;

  if (_pre_mode == INITIAL) {
    if (token->is_preprocessor ()) {
      switch (type) {
        case TOK_PRE_DEFINE: 
          _pre_mode = DEFINING; 
          break;
        case TOK_PRE_ASSERT:
        case TOK_PRE_UNASSERT: 
          _pre_mode = ASSERT; 
          break;
        case TOK_PRE_IF:
        case TOK_PRE_ELIF:
        case TOK_PRE_WARNING:
        case TOK_PRE_ERROR:
        case TOK_PRE_INCLUDE:
        case TOK_PRE_INCLUDE_NEXT:
        case TOK_ELSE:
        case TOK_PRE_ENDIF:
          _pre_mode = TOKENLIST;
          break;
        case TOK_PRE_IFDEF:
        case TOK_PRE_IFNDEF:
        case TOK_PRE_UNDEF:
          _pre_mode = DIRECTIVE;
          break;
      }
    } else {
      parse = false;
    }
  } else {
    if (token->is_whitespace ()) {
      const char *c = token->text ();
      for (; *c && *c != '\n'; c++);

      if (*c == '\n') {
        type = TOK_PRE_NEWLINE;
        _pre_mode = INITIAL;
      } else if (_pre_mode == TOKENLIST) {
        type = TOK_PRE_TOKEN_LIST;
      } else if (_pre_mode == MAYBEMACRO) {
        type = TOK_PRE_TOKEN_LIST;
        _pre_mode = TOKENLIST;
      } else {
        parse = false;
      }
    } else {
      bool is_id = token->is_identifier ();

      type = Token::ID_UNKNOWN;
      switch (_pre_mode) {
        case TOKENLIST:
          type = TOK_PRE_TOKEN_LIST;
            break;
        case ASSERT:
        case DIRECTIVE:
          if (! state->passOnToken) {
            type = TOK_PRE_TOKEN_LIST;
            _pre_mode = TOKENLIST;
          } else if (is_id) {
            type = TOK_PRE_ID;
            _pre_mode = TOKENLIST;
          }
          break;
        case DEFINING:
          if (! state->passOnToken) {
            type = TOK_PRE_TOKEN_LIST;
            _pre_mode = TOKENLIST;
          } else if (is_id) {
            type = TOK_PRE_ID;
            _pre_mode = MAYBEMACRO;
          }
          break;
        case MAYBEMACRO:
          if (token->is_open ()) {
            type = TOK_PRE_LPAREN;
            _pre_mode = MACRO;
          }
          break;
        case MACRO:
          if (is_id) {
              type = TOK_PRE_ID;
          } else if (token->is_comma ()) {
            type = TOK_PRE_COMMA;
          } else if (token->is_close ()) {
            type = TOK_PRE_RPAREN;
            _pre_mode = TOKENLIST;
          } else if (token->type () == TOK_ELLIPSIS) {
            if (supportGNU ()) {
              type = TOK_PRE_REST;
            }
          } 
          break;
        case INITIAL: // to avoid compiler warnings
          break;
      }
      if (type == Token::ID_UNKNOWN) {
        _pre_mode = INITIAL;
      }
    }
  }
  return type;
}
    

// Parse a single token.
Token* PreprocessorParser::parseToken () {
  // Set the parser as the current parser.
  parser = this;
  state  = _parserState;
  level  = _levelState;
  err    = state->err;

  PreMacro*        macro;
  PreTreeToken* synToken;
  PreMode mode;

  // Create the macro expander.
  PreMacroExpander expander (parser);

  Unit *comment_unit = 0;
  Token *result = 0, *sl_comment = 0;
  bool done = false;
  
  while (! done) {
    done = true; // default: run once

    // Scan the input files. Get the next token.
    while ((state->currToken = scanner ()->next ())) {
      int type = state->currToken->type ();
      bool parse;

      // Finish a macro expansion.
      if (((TokenStream*) scanner ())->length () < state->number) {
        state->number = 0;
        
        // handle generated single line comments
        if (! sl_comment && state->sl_token && 
            (state->sl_token->type () == TOK_CCOMMENT ||
             state->sl_token->type () == TOK_CCSINGLE)) {
          sl_comment = state->sl_token;
          comment_unit = new Unit;
        }
      }
          
      // handle generated single line comments
      if (sl_comment) {
        Token *token;
        
        // single line comment finished
        if (state->currToken->location ().line () > 
            sl_comment->location ().line ()) {
          // Append the current token.
          token = (Token*)state->currToken->duplicate ();
          token->macro_generated ();
          comment_unit->append (*token);
          sl_comment = 0;

          // Push the unit containing the comment tokens on token stack. 
          ((TokenStream*)scanner ())->push (comment_unit);
          // Add the unit to the unit manager.
          _unitManager->addUnit (comment_unit);
          // Remember how many included headers lay on the stack.
          if (! state->number)
            state->number = ((TokenStream*) scanner ())->length ();
        // copy current token and mark it as comment token
        } else {
          token = state->currToken;
          token = new Token (TOK_CCOMMENT, Token::comment_id, token->text ());
          token->location (sl_comment->location ());
          token->macro_generated ();
          comment_unit->append (*token);
        }
        
        // scan next token
        continue;
      }
      
      mode = parser->pre_mode ();

      // recognize preprocessor state
      if (! sl_comment)
        type = map_token (state->currToken, parse);

      state->sl_token = state->currToken;
      state->currType = type;

      // If the scanned token isn't a preprocessor token, or a macro
      // is getting expanded and therefore preprocessor tokens have to
      // be ignored, do not parse the token.
      if (! parse || state->number) {
        preventEOFError (mode);
        break;
      }

      // Allow an included file to end with a preprocessor directive
      // and not only with a newline.
      preventInclEOFError (mode);

      // Remember the current token.
      state->lastToken = state->currToken;
      state->lastType = state->currType;

      // Encapsulate the current token so it can be part of the
      // preprocessor syntax tree.
      synToken = new PreTreeToken (state->currToken);

      // Give it to the parser.
      PreParser (state->pParser, type, synToken);

      // After a newline was parsed the parser has to wait until the
      // next token was parsed to be able to decide whether the end
      // of a directive really is reached (to be able to reduce the
      // current rule). But we have to do our work now, for example
      // after an #include directive we can't wait for the next
      // directive to include the file, we have to include it now.
      // Therefore a very special token will be send to the parser
      // after parsing a newline token. The parser recognizes this
      // very special token and the body of the #include-rule will
      // be executed right now.
      if (type == TOK_PRE_NEWLINE)
        PreParser (state->pParser, TOK_PRE_DIRECTIVE_END, (PreTree*) 0);
    }

    // If the current token isn't NULL process it.
    if (state->currToken) {
      // Go on only if we aren't within a `false' conditional branch and
      // no #error directive was parsed.
      if (state->passOnToken && ! state->errorDirective) {
        // Check every C++ identifier for macro calls.
        if (state->currToken->is_identifier ()) 
          if ((macro = _macroManager->getMacro (state->currToken->text ()))) {
            
            // Check whether a special predefined macro was called
            // and update it if necessary.
            macro = state->checkPredefined (macro, scanner (), *_macroManager);

            // Now it must be checked whether the macro is allowed
            // to be expanded. If it is a `self-referential' macro
            // call it will stay untouched.
            if (state->checkToExpand (state->currToken,
              macro, scanner (), *_macroStack, *_prescanned))
              // Try to expand the macro. It also could be that
              // this isn't a macro call at all, if so ignore it.
              if (expander.expandMacro (macro, state->currToken)) { 
                // After expansion the expanded text is pushed
                // on the input stream. Now we must be sure to
                // not expand again this macro inside of the
                // expanded text (self-referential macro call!).

                // Remember the number of real input files on
                // stack (the input stream) to be able to know
                // when the expansion text is scanned and removed
                // from input stream.
                if (! state->number) {
                  state->number = ((TokenStream*) scanner ())->length ();
                  state->stackPos = 0;
//                  _prescanned->clear ();
                } else
                  state->stackPos = ((TokenStream*) scanner ())->
                                    length () - state->number;

                // Put expanded macro on macro stack to prevent
                // it for be expanded again. The macro stack will
                // be cleared after expansion text is scanned.
                _macroStack->get (state->stackPos) = macro;

                // Call this function recursively again to skip
                // the macro call and parse the expanded text.
                done = false; 
              }        
          } 
          // If no macro call return the token unchanged.
          result = state->currToken;
            
      // The current token has to be ignored, so call this function
      // recursively again to skip the current token.
      } else
        done = false;
    }

    // The current token is NULL. That means all input files were parsed.
    else {      
      // Ensure that this is the last call to the parser.
      done = true;
      
      // Handle directive at EOF (missing newline). Same problem as above.
      directiveAtEOF ();

      // Create an EOF token needed if the EOF is within a directive
      // and caused a parse error. So the parser can print a error
      // message that report this error.
      state->currToken = new Token (Token::ID_END_OF_FILE);

      // Send the Lemon generated parser the signal to finish the
      // parse process.
      PreParser (state->pParser, 0, (PreTree*) 0);

      delete state->currToken;

      // Return NULL to signal all other parsers to finish their
      // parse processes.
      result = (Token*) 0; // return (Token*) 0;
    }
  }
  
  // remove the current token from the black list of self-referential macros
  // in prescanned macro argument lists
  if (result && result->is_identifier ())
    _prescanned->erase (result);

  return result;
}


} // namespace Puma

#line 711 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    PreParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is PreParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    PreParserARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    PreParserKRARGDECL     A version of PreParserARGDECL for K&R C.
**    PreParserANSIARGDECL   A version of PreParserARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 51
#define YYACTIONTYPE unsigned char
#define PreParserTOKENTYPE PreTree*
typedef union {
  PreParserTOKENTYPE yy0;
  int yy101;
} YYMINORTYPE;
#define YYSTACKDEPTH 1000
#define PreParserARGDECL
#define PreParserXARGDECL
#define PreParserANSIARGDECL
#define YYNSTATE 110
#define YYNRULE 56
#define YYERRORSYMBOL 35
#define YYERRSYMDT yy101
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
struct yyActionEntry {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  44, 167, &yyActionTable[   1] }, /*   preprocessor_program accept */
  {  28,   1, 0                    }, /*       directive_groups shift  1 */
/* State 1 */
  {   0, 110, 0                    }, /*                      $ reduce 0 */
  {   1,  62, 0                    }, /*         TOK_PRE_ASSERT shift  62 */
  {   3,  70, 0                    }, /*         TOK_PRE_DEFINE shift  70 */
  {  35,   3, &yyActionTable[   4] }, /*                  error shift  3 */
  {  36,  56, 0                    }, /*             error_line shift  56 */
  {   8,  98, 0                    }, /*          TOK_PRE_ERROR shift  98 */
  {  38,   9, 0                    }, /*                if_line shift  9 */
  {  39,   6, 0                    }, /*                if_part shift  6 */
  {  40,  11, &yyActionTable[   7] }, /*             ifdef_line shift  11 */
  {  41,  13, 0                    }, /*            ifndef_line shift  13 */
  {  42,  42, &yyActionTable[  20] }, /*           include_line shift  42 */
  {  43,  44, &yyActionTable[  21] }, /*      include_next_line shift  44 */
  {  12,  32, 0                    }, /*         TOK_PRE_IFNDEF shift  32 */
  {  13,  58, 0                    }, /*        TOK_PRE_INCLUDE shift  58 */
  {  14,  60, 0                    }, /*   TOK_PRE_INCLUDE_NEXT shift  60 */
  {  47,  48, 0                    }, /*          unassert_line shift  48 */
  {  48,  52, 0                    }, /*             undef_line shift  52 */
  {  49,  54, 0                    }, /*           warning_line shift  54 */
  {  10,  21, 0                    }, /*             TOK_PRE_IF shift  21 */
  {  11,  28, 0                    }, /*          TOK_PRE_IFDEF shift  28 */
  {  20,  66, 0                    }, /*       TOK_PRE_UNASSERT shift  66 */
  {  21,  92, 0                    }, /*          TOK_PRE_UNDEF shift  92 */
  {  22,  96, 0                    }, /*        TOK_PRE_WARNING shift  96 */
  {  23,  46, 0                    }, /*            assert_line shift  46 */
  {  24,   5, 0                    }, /*      conditional_group shift  5 */
  {  25,   4, 0                    }, /*           control_line shift  4 */
  {  26,  50, 0                    }, /*            define_line shift  50 */
  {  27,   2, 0                    }, /*        directive_group shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 2 */
  {YYNOCODE,0,0}, /* Unused */
/* State 3 */
  {YYNOCODE,0,0}, /* Unused */
/* State 4 */
  {YYNOCODE,0,0}, /* Unused */
/* State 5 */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {  32, 107, &yyActionTable[  39] }, /*              else_part shift  107 */
  {  28,   7, 0                    }, /*       directive_groups shift  7 */
  {  30, 100, 0                    }, /*              elif_part shift  100 */
  {YYNOCODE,0,0}, /* Unused */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
  {   1,  62, 0                    }, /*         TOK_PRE_ASSERT shift  62 */
  {YYNOCODE,0,0}, /* Unused */
  {   3,  70, 0                    }, /*         TOK_PRE_DEFINE shift  70 */
  {YYNOCODE,0,0}, /* Unused */
  {   5,  36, 0                    }, /*           TOK_PRE_ELIF shift  36 */
  {   6,  38, 0                    }, /*           TOK_PRE_ELSE shift  38 */
  {   7,  40, 0                    }, /*          TOK_PRE_ENDIF shift  40 */
  {   8,  98, 0                    }, /*          TOK_PRE_ERROR shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  10,  21, 0                    }, /*             TOK_PRE_IF shift  21 */
  {  11,  28, 0                    }, /*          TOK_PRE_IFDEF shift  28 */
  {  12,  32, 0                    }, /*         TOK_PRE_IFNDEF shift  32 */
  {  13,  58, 0                    }, /*        TOK_PRE_INCLUDE shift  58 */
  {  14,  60, 0                    }, /*   TOK_PRE_INCLUDE_NEXT shift  60 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  20,  66, 0                    }, /*       TOK_PRE_UNASSERT shift  66 */
  {  21,  92, 0                    }, /*          TOK_PRE_UNDEF shift  92 */
  {  22,  96, 0                    }, /*        TOK_PRE_WARNING shift  96 */
  {  23,  46, 0                    }, /*            assert_line shift  46 */
  {  24,   5, 0                    }, /*      conditional_group shift  5 */
  {  25,   4, 0                    }, /*           control_line shift  4 */
  {  26,  50, 0                    }, /*            define_line shift  50 */
  {  27,   2, 0                    }, /*        directive_group shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {  29,  17, 0                    }, /*              elif_line shift  17 */
  {YYNOCODE,0,0}, /* Unused */
  {  31,  15, 0                    }, /*              else_line shift  15 */
  {YYNOCODE,0,0}, /* Unused */
  {  33,  19, 0                    }, /*             endif_line shift  19 */
  {  34,   8, 0                    }, /*             endif_part shift  8 */
  {  35,   3, 0                    }, /*                  error shift  3 */
  {  36,  56, 0                    }, /*             error_line shift  56 */
  {YYNOCODE,0,0}, /* Unused */
  {  38,   9, 0                    }, /*                if_line shift  9 */
  {  39,   6, 0                    }, /*                if_part shift  6 */
  {  40,  11, 0                    }, /*             ifdef_line shift  11 */
  {  41,  13, 0                    }, /*            ifndef_line shift  13 */
  {  42,  42, 0                    }, /*           include_line shift  42 */
  {  43,  44, 0                    }, /*      include_next_line shift  44 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47,  48, 0                    }, /*          unassert_line shift  48 */
  {  48,  52, 0                    }, /*             undef_line shift  52 */
  {  49,  54, 0                    }, /*           warning_line shift  54 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {YYNOCODE,0,0}, /* Unused */
/* State 9 */
  {   4,  10, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  10 */
/* State 10 */
  {YYNOCODE,0,0}, /* Unused */
/* State 11 */
  {   4,  12, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  12 */
/* State 12 */
  {YYNOCODE,0,0}, /* Unused */
/* State 13 */
  {   4,  14, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  14 */
/* State 14 */
  {YYNOCODE,0,0}, /* Unused */
/* State 15 */
  {   4,  16, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  16 */
/* State 16 */
  {YYNOCODE,0,0}, /* Unused */
/* State 17 */
  {   4,  18, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  18 */
/* State 18 */
  {YYNOCODE,0,0}, /* Unused */
/* State 19 */
  {   4,  20, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  20 */
/* State 20 */
  {YYNOCODE,0,0}, /* Unused */
/* State 21 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  22, 0                    }, /*             token_list shift  22 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 22 */
  {   4, 127, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 17 */
/* State 23 */
  {   4, 162, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 52 */
/* State 24 */
  {  16,  25, 0                    }, /*        TOK_PRE_NEWLINE shift  25 */
  {  19,  26, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  26 */
/* State 25 */
  {   4, 163, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 53 */
/* State 26 */
  {YYNOCODE,0,0}, /* Unused */
/* State 27 */
  {YYNOCODE,0,0}, /* Unused */
/* State 28 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {   9,  30, 0                    }, /*             TOK_PRE_ID shift  30 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  29, 0                    }, /*             token_list shift  29 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 29 */
  {   4, 128, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 18 */
/* State 30 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  31, 0                    }, /*             token_list shift  31 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 31 */
  {   4, 129, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 19 */
/* State 32 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {   9,  34, 0                    }, /*             TOK_PRE_ID shift  34 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  33, 0                    }, /*             token_list shift  33 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 33 */
  {   4, 130, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 20 */
/* State 34 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  35, 0                    }, /*             token_list shift  35 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 35 */
  {   4, 131, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 21 */
/* State 36 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  37, 0                    }, /*             token_list shift  37 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 37 */
  {   4, 132, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 22 */
/* State 38 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  39, 0                    }, /*             token_list shift  39 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 39 */
  {   4, 133, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 23 */
/* State 40 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  41, 0                    }, /*             token_list shift  41 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 41 */
  {   4, 134, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 24 */
/* State 42 */
  {   4,  43, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  43 */
/* State 43 */
  {YYNOCODE,0,0}, /* Unused */
/* State 44 */
  {   4,  45, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  45 */
/* State 45 */
  {YYNOCODE,0,0}, /* Unused */
/* State 46 */
  {   4,  47, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  47 */
/* State 47 */
  {YYNOCODE,0,0}, /* Unused */
/* State 48 */
  {   4,  49, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  49 */
/* State 49 */
  {YYNOCODE,0,0}, /* Unused */
/* State 50 */
  {   4,  51, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  51 */
/* State 51 */
  {YYNOCODE,0,0}, /* Unused */
/* State 52 */
  {   4,  53, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  53 */
/* State 53 */
  {YYNOCODE,0,0}, /* Unused */
/* State 54 */
  {   4,  55, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  55 */
/* State 55 */
  {YYNOCODE,0,0}, /* Unused */
/* State 56 */
  {   4,  57, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  57 */
/* State 57 */
  {YYNOCODE,0,0}, /* Unused */
/* State 58 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  59, 0                    }, /*             token_list shift  59 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 59 */
  {   4, 143, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 33 */
/* State 60 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  61, 0                    }, /*             token_list shift  61 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 61 */
  {   4, 144, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 34 */
/* State 62 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {   9,  64, 0                    }, /*             TOK_PRE_ID shift  64 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  63, 0                    }, /*             token_list shift  63 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 63 */
  {   4, 145, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 35 */
/* State 64 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  65, 0                    }, /*             token_list shift  65 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 65 */
  {   4, 146, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 36 */
/* State 66 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {   9,  68, 0                    }, /*             TOK_PRE_ID shift  68 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  67, 0                    }, /*             token_list shift  67 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 67 */
  {   4, 147, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 37 */
/* State 68 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  69, 0                    }, /*             token_list shift  69 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 69 */
  {   4, 148, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 38 */
/* State 70 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {   9,  72, 0                    }, /*             TOK_PRE_ID shift  72 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  71, 0                    }, /*             token_list shift  71 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 71 */
  {   4, 149, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 39 */
/* State 72 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  91, 0                    }, /*             token_list shift  91 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  15,  73, 0                    }, /*         TOK_PRE_LPAREN shift  73 */
/* State 73 */
  {  17,  76, &yyActionTable[ 247] }, /*           TOK_PRE_REST shift  76 */
  {  37,  79, &yyActionTable[ 244] }, /*        identifier_list shift  79 */
  {  18,  74, 0                    }, /*         TOK_PRE_RPAREN shift  74 */
  {   9,  90, 0                    }, /*             TOK_PRE_ID shift  90 */
/* State 74 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  75, 0                    }, /*             token_list shift  75 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 75 */
  {   4, 150, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 40 */
/* State 76 */
  {  18,  77, 0                    }, /*         TOK_PRE_RPAREN shift  77 */
/* State 77 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  78, 0                    }, /*             token_list shift  78 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 78 */
  {   4, 151, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 41 */
/* State 79 */
  {   2,  85, 0                    }, /*          TOK_PRE_COMMA shift  85 */
  {  17,  82, 0                    }, /*           TOK_PRE_REST shift  82 */
  {  18,  80, &yyActionTable[ 259] }, /*         TOK_PRE_RPAREN shift  80 */
  {YYNOCODE,0,0}, /* Unused */
/* State 80 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  81, 0                    }, /*             token_list shift  81 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 81 */
  {   4, 152, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 42 */
/* State 82 */
  {  18,  83, 0                    }, /*         TOK_PRE_RPAREN shift  83 */
/* State 83 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  84, 0                    }, /*             token_list shift  84 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 84 */
  {   4, 153, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 43 */
/* State 85 */
  {   9,  89, 0                    }, /*             TOK_PRE_ID shift  89 */
  {  17,  86, &yyActionTable[ 274] }, /*           TOK_PRE_REST shift  86 */
/* State 86 */
  {  18,  87, 0                    }, /*         TOK_PRE_RPAREN shift  87 */
/* State 87 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  88, 0                    }, /*             token_list shift  88 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 88 */
  {   4, 154, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 44 */
/* State 89 */
  {YYNOCODE,0,0}, /* Unused */
/* State 90 */
  {YYNOCODE,0,0}, /* Unused */
/* State 91 */
  {   4, 155, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 45 */
/* State 92 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {   9,  94, 0                    }, /*             TOK_PRE_ID shift  94 */
  {YYNOCODE,0,0}, /* Unused */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
  {YYNOCODE,0,0}, /* Unused */
  {  45,  93, 0                    }, /*             token_list shift  93 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 93 */
  {   4, 156, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 46 */
/* State 94 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  95, 0                    }, /*             token_list shift  95 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 95 */
  {   4, 157, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 47 */
/* State 96 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  97, 0                    }, /*             token_list shift  97 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 97 */
  {   4, 158, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 48 */
/* State 98 */
  {  16,  23, 0                    }, /*        TOK_PRE_NEWLINE shift  23 */
  {  45,  99, 0                    }, /*             token_list shift  99 */
  {  46,  24, 0                    }, /*        token_list_part shift  24 */
  {  19,  27, 0                    }, /*     TOK_PRE_TOKEN_LIST shift  27 */
/* State 99 */
  {   4, 159, 0                    }, /*  TOK_PRE_DIRECTIVE_END reduce 49 */
/* State 100 */
  {  28, 101, 0                    }, /*       directive_groups shift  101 */
/* State 101 */
  {YYNOCODE,0,0}, /* Unused */
  {   1,  62, 0                    }, /*         TOK_PRE_ASSERT shift  62 */
  {YYNOCODE,0,0}, /* Unused */
  {   3,  70, 0                    }, /*         TOK_PRE_DEFINE shift  70 */
  {YYNOCODE,0,0}, /* Unused */
  {   5,  36, 0                    }, /*           TOK_PRE_ELIF shift  36 */
  {   6,  38, 0                    }, /*           TOK_PRE_ELSE shift  38 */
  {   7,  40, 0                    }, /*          TOK_PRE_ENDIF shift  40 */
  {   8,  98, 0                    }, /*          TOK_PRE_ERROR shift  98 */
  {YYNOCODE,0,0}, /* Unused */
  {  10,  21, 0                    }, /*             TOK_PRE_IF shift  21 */
  {  11,  28, 0                    }, /*          TOK_PRE_IFDEF shift  28 */
  {  12,  32, 0                    }, /*         TOK_PRE_IFNDEF shift  32 */
  {  13,  58, 0                    }, /*        TOK_PRE_INCLUDE shift  58 */
  {  14,  60, 0                    }, /*   TOK_PRE_INCLUDE_NEXT shift  60 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  20,  66, 0                    }, /*       TOK_PRE_UNASSERT shift  66 */
  {  21,  92, 0                    }, /*          TOK_PRE_UNDEF shift  92 */
  {  22,  96, 0                    }, /*        TOK_PRE_WARNING shift  96 */
  {  23,  46, 0                    }, /*            assert_line shift  46 */
  {  24,   5, 0                    }, /*      conditional_group shift  5 */
  {  25,   4, 0                    }, /*           control_line shift  4 */
  {  26,  50, 0                    }, /*            define_line shift  50 */
  {  27,   2, 0                    }, /*        directive_group shift  2 */
  {YYNOCODE,0,0}, /* Unused */
  {  29, 105, 0                    }, /*              elif_line shift  105 */
  {YYNOCODE,0,0}, /* Unused */
  {  31, 103, 0                    }, /*              else_line shift  103 */
  {YYNOCODE,0,0}, /* Unused */
  {  33,  19, 0                    }, /*             endif_line shift  19 */
  {  34, 102, 0                    }, /*             endif_part shift  102 */
  {  35,   3, 0                    }, /*                  error shift  3 */
  {  36,  56, 0                    }, /*             error_line shift  56 */
  {YYNOCODE,0,0}, /* Unused */
  {  38,   9, 0                    }, /*                if_line shift  9 */
  {  39,   6, 0                    }, /*                if_part shift  6 */
  {  40,  11, 0                    }, /*             ifdef_line shift  11 */
  {  41,  13, 0                    }, /*            ifndef_line shift  13 */
  {  42,  42, 0                    }, /*           include_line shift  42 */
  {  43,  44, 0                    }, /*      include_next_line shift  44 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  47,  48, 0                    }, /*          unassert_line shift  48 */
  {  48,  52, 0                    }, /*             undef_line shift  52 */
  {  49,  54, 0                    }, /*           warning_line shift  54 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 102 */
  {YYNOCODE,0,0}, /* Unused */
/* State 103 */
  {   4, 104, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  104 */
/* State 104 */
  {YYNOCODE,0,0}, /* Unused */
/* State 105 */
  {   4, 106, 0                    }, /*  TOK_PRE_DIRECTIVE_END shift  106 */
/* State 106 */
  {YYNOCODE,0,0}, /* Unused */
/* State 107 */
  {  28, 108, 0                    }, /*       directive_groups shift  108 */
/* State 108 */
  {   1,  62, 0                    }, /*         TOK_PRE_ASSERT shift  62 */
  {  33,  19, &yyActionTable[ 380] }, /*             endif_line shift  19 */
  {  34, 109, 0                    }, /*             endif_part shift  109 */
  {  35,   3, &yyActionTable[ 385] }, /*                  error shift  3 */
  {  36,  56, 0                    }, /*             error_line shift  56 */
  {   3,  70, 0                    }, /*         TOK_PRE_DEFINE shift  70 */
  {  38,   9, 0                    }, /*                if_line shift  9 */
  {  39,   6, &yyActionTable[ 398] }, /*                if_part shift  6 */
  {  40,  11, &yyActionTable[ 399] }, /*             ifdef_line shift  11 */
  {  41,  13, 0                    }, /*            ifndef_line shift  13 */
  {  42,  42, &yyActionTable[ 408] }, /*           include_line shift  42 */
  {  43,  44, &yyActionTable[ 409] }, /*      include_next_line shift  44 */
  {  12,  32, 0                    }, /*         TOK_PRE_IFNDEF shift  32 */
  {  13,  58, 0                    }, /*        TOK_PRE_INCLUDE shift  58 */
  {  14,  60, 0                    }, /*   TOK_PRE_INCLUDE_NEXT shift  60 */
  {  47,  48, 0                    }, /*          unassert_line shift  48 */
  {  48,  52, 0                    }, /*             undef_line shift  52 */
  {  49,  54, 0                    }, /*           warning_line shift  54 */
  {   7,  40, 0                    }, /*          TOK_PRE_ENDIF shift  40 */
  {   8,  98, 0                    }, /*          TOK_PRE_ERROR shift  98 */
  {  20,  66, 0                    }, /*       TOK_PRE_UNASSERT shift  66 */
  {  21,  92, 0                    }, /*          TOK_PRE_UNDEF shift  92 */
  {  22,  96, 0                    }, /*        TOK_PRE_WARNING shift  96 */
  {  23,  46, 0                    }, /*            assert_line shift  46 */
  {  24,   5, 0                    }, /*      conditional_group shift  5 */
  {  25,   4, 0                    }, /*           control_line shift  4 */
  {  26,  50, 0                    }, /*            define_line shift  50 */
  {  27,   2, 0                    }, /*        directive_group shift  2 */
  {  10,  21, 0                    }, /*             TOK_PRE_IF shift  21 */
  {  11,  28, 0                    }, /*          TOK_PRE_IFDEF shift  28 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
/* State 109 */
  {YYNOCODE,0,0}, /* Unused */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.  
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
struct yyStateEntry {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 1, 111},
  { &yyActionTable[2], 31, 166},
  { &yyActionTable[34], 0, 112},
  { &yyActionTable[35], 0, 113},
  { &yyActionTable[36], 0, 114},
  { &yyActionTable[37], 0, 115},
  { &yyActionTable[38], 3, 111},
  { &yyActionTable[42], 63, 166},
  { &yyActionTable[106], 0, 116},
  { &yyActionTable[107], 0, 166},
  { &yyActionTable[108], 0, 119},
  { &yyActionTable[109], 0, 166},
  { &yyActionTable[110], 0, 120},
  { &yyActionTable[111], 0, 166},
  { &yyActionTable[112], 0, 121},
  { &yyActionTable[113], 0, 166},
  { &yyActionTable[114], 0, 122},
  { &yyActionTable[115], 0, 166},
  { &yyActionTable[116], 0, 124},
  { &yyActionTable[117], 0, 166},
  { &yyActionTable[118], 0, 126},
  { &yyActionTable[119], 3, 166},
  { &yyActionTable[123], 0, 166},
  { &yyActionTable[124], 0, 166},
  { &yyActionTable[125], 1, 166},
  { &yyActionTable[127], 0, 166},
  { &yyActionTable[128], 0, 165},
  { &yyActionTable[129], 0, 164},
  { &yyActionTable[130], 7, 166},
  { &yyActionTable[138], 0, 166},
  { &yyActionTable[139], 3, 166},
  { &yyActionTable[143], 0, 166},
  { &yyActionTable[144], 7, 166},
  { &yyActionTable[152], 0, 166},
  { &yyActionTable[153], 3, 166},
  { &yyActionTable[157], 0, 166},
  { &yyActionTable[158], 3, 166},
  { &yyActionTable[162], 0, 166},
  { &yyActionTable[163], 3, 166},
  { &yyActionTable[167], 0, 166},
  { &yyActionTable[168], 3, 166},
  { &yyActionTable[172], 0, 166},
  { &yyActionTable[173], 0, 166},
  { &yyActionTable[174], 0, 135},
  { &yyActionTable[175], 0, 166},
  { &yyActionTable[176], 0, 136},
  { &yyActionTable[177], 0, 166},
  { &yyActionTable[178], 0, 137},
  { &yyActionTable[179], 0, 166},
  { &yyActionTable[180], 0, 138},
  { &yyActionTable[181], 0, 166},
  { &yyActionTable[182], 0, 139},
  { &yyActionTable[183], 0, 166},
  { &yyActionTable[184], 0, 140},
  { &yyActionTable[185], 0, 166},
  { &yyActionTable[186], 0, 141},
  { &yyActionTable[187], 0, 166},
  { &yyActionTable[188], 0, 142},
  { &yyActionTable[189], 3, 166},
  { &yyActionTable[193], 0, 166},
  { &yyActionTable[194], 3, 166},
  { &yyActionTable[198], 0, 166},
  { &yyActionTable[199], 7, 166},
  { &yyActionTable[207], 0, 166},
  { &yyActionTable[208], 3, 166},
  { &yyActionTable[212], 0, 166},
  { &yyActionTable[213], 7, 166},
  { &yyActionTable[221], 0, 166},
  { &yyActionTable[222], 3, 166},
  { &yyActionTable[226], 0, 166},
  { &yyActionTable[227], 7, 166},
  { &yyActionTable[235], 0, 166},
  { &yyActionTable[236], 7, 166},
  { &yyActionTable[244], 3, 166},
  { &yyActionTable[248], 3, 166},
  { &yyActionTable[252], 0, 166},
  { &yyActionTable[253], 0, 166},
  { &yyActionTable[254], 3, 166},
  { &yyActionTable[258], 0, 166},
  { &yyActionTable[259], 3, 166},
  { &yyActionTable[263], 3, 166},
  { &yyActionTable[267], 0, 166},
  { &yyActionTable[268], 0, 166},
  { &yyActionTable[269], 3, 166},
  { &yyActionTable[273], 0, 166},
  { &yyActionTable[274], 1, 166},
  { &yyActionTable[276], 0, 166},
  { &yyActionTable[277], 3, 166},
  { &yyActionTable[281], 0, 166},
  { &yyActionTable[282], 0, 161},
  { &yyActionTable[283], 0, 160},
  { &yyActionTable[284], 0, 166},
  { &yyActionTable[285], 7, 166},
  { &yyActionTable[293], 0, 166},
  { &yyActionTable[294], 3, 166},
  { &yyActionTable[298], 0, 166},
  { &yyActionTable[299], 3, 166},
  { &yyActionTable[303], 0, 166},
  { &yyActionTable[304], 3, 166},
  { &yyActionTable[308], 0, 166},
  { &yyActionTable[309], 0, 111},
  { &yyActionTable[310], 63, 166},
  { &yyActionTable[374], 0, 117},
  { &yyActionTable[375], 0, 166},
  { &yyActionTable[376], 0, 123},
  { &yyActionTable[377], 0, 166},
  { &yyActionTable[378], 0, 125},
  { &yyActionTable[379], 0, 111},
  { &yyActionTable[380], 31, 166},
  { &yyActionTable[412], 0, 118},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
struct yyStackEntry {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
struct yyParser {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void PreParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = { 
  "$",             "TOK_PRE_ASSERT",  "TOK_PRE_COMMA",  "TOK_PRE_DEFINE",
  "TOK_PRE_DIRECTIVE_END",  "TOK_PRE_ELIF",  "TOK_PRE_ELSE",  "TOK_PRE_ENDIF",
  "TOK_PRE_ERROR",  "TOK_PRE_ID",    "TOK_PRE_IF",    "TOK_PRE_IFDEF",
  "TOK_PRE_IFNDEF",  "TOK_PRE_INCLUDE",  "TOK_PRE_INCLUDE_NEXT",  "TOK_PRE_LPAREN",
  "TOK_PRE_NEWLINE",  "TOK_PRE_REST",  "TOK_PRE_RPAREN",  "TOK_PRE_TOKEN_LIST",
  "TOK_PRE_UNASSERT",  "TOK_PRE_UNDEF",  "TOK_PRE_WARNING",  "assert_line", 
  "conditional_group",  "control_line",  "define_line",   "directive_group",
  "directive_groups",  "elif_line",     "elif_part",     "else_line",   
  "else_part",     "endif_line",    "endif_part",    "error",       
  "error_line",    "identifier_list",  "if_line",       "if_part",     
  "ifdef_line",    "ifndef_line",   "include_line",  "include_next_line",
  "preprocessor_program",  "token_list",    "token_list_part",  "unassert_line",
  "undef_line",    "warning_line",
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to PreParser and PreParserFree.
*/
void *PreParserAlloc(void *(*mallocProc)(...)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( sizeof(yyParser), __FILE__, __LINE__ );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from PreParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void PreParserFree(
  void *p,               /* The parser to be deleted */
  void (*freeProc)(...)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)(pParser, __FILE__, __LINE__);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */
 
  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 715 "cpp/PreParser.lem"

  state->syntaxError = true;
  *err << state->lastToken->location () << sev_fatal 
       << "Giving up. Preprocessor stack overflow (>1000)" << endMessage;

#line 1683 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
static struct {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 44, 1 },
  { 28, 0 },
  { 28, 2 },
  { 28, 2 },
  { 27, 1 },
  { 27, 1 },
  { 24, 3 },
  { 24, 4 },
  { 24, 4 },
  { 39, 2 },
  { 39, 2 },
  { 39, 2 },
  { 32, 3 },
  { 32, 4 },
  { 30, 3 },
  { 30, 4 },
  { 34, 2 },
  { 38, 2 },
  { 40, 2 },
  { 40, 3 },
  { 41, 2 },
  { 41, 3 },
  { 29, 2 },
  { 31, 2 },
  { 33, 2 },
  { 25, 2 },
  { 25, 2 },
  { 25, 2 },
  { 25, 2 },
  { 25, 2 },
  { 25, 2 },
  { 25, 2 },
  { 25, 2 },
  { 42, 2 },
  { 43, 2 },
  { 23, 2 },
  { 23, 3 },
  { 47, 2 },
  { 47, 3 },
  { 26, 2 },
  { 26, 5 },
  { 26, 6 },
  { 26, 6 },
  { 26, 7 },
  { 26, 8 },
  { 26, 3 },
  { 48, 2 },
  { 48, 3 },
  { 49, 2 },
  { 36, 2 },
  { 37, 1 },
  { 37, 3 },
  { 45, 1 },
  { 45, 2 },
  { 46, 1 },
  { 46, 2 },
};

static void yy_accept(
  yyParser *yypParser           /* The parser */
  PreParserANSIARGDECL              /* Extra arguments (if any) */
);  /* Forward declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  PreParserANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("preprocessor_program ::= directive_groups")
#line 756 "cpp/PreParser.lem"
{
        state->syntaxTree = new PreProgram (yymsp[0].minor.yy0);
    }
#line 1802 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 1:
        YYTRACE("directive_groups ::=")
#line 765 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDirectiveGroups ();
    }
#line 1810 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 2:
        YYTRACE("directive_groups ::= directive_groups directive_group")
#line 769 "cpp/PreParser.lem"
{
        yymsp[-1].minor.yy0->add_son (yymsp[0].minor.yy0);
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 1819 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 3:
        YYTRACE("directive_groups ::= directive_groups error")
#line 774 "cpp/PreParser.lem"
{
        yymsp[-1].minor.yy0->add_son (new PreError ());
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 1828 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for error */
        break;
      case 4:
        YYTRACE("directive_group ::= control_line")
#line 784 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[0].minor.yy0;
    }
#line 1837 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 5:
        YYTRACE("directive_group ::= conditional_group")
#line 788 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[0].minor.yy0;
    }
#line 1845 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 6:
        YYTRACE("conditional_group ::= if_part directive_groups endif_part")
#line 797 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreConditionalGroup (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 1853 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 7:
        YYTRACE("conditional_group ::= if_part elif_part directive_groups endif_part")
#line 802 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreConditionalGroup (yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 1861 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 8:
        YYTRACE("conditional_group ::= if_part else_part directive_groups endif_part")
#line 807 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreConditionalGroup (yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 1869 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 9:
        YYTRACE("if_part ::= if_line TOK_PRE_DIRECTIVE_END")
#line 816 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 1877 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 10:
        YYTRACE("if_part ::= ifdef_line TOK_PRE_DIRECTIVE_END")
#line 820 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 1886 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 11:
        YYTRACE("if_part ::= ifndef_line TOK_PRE_DIRECTIVE_END")
#line 824 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 1895 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 12:
        YYTRACE("else_part ::= directive_groups else_line TOK_PRE_DIRECTIVE_END")
#line 833 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreElsePart (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0);
    }
#line 1904 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 13:
        YYTRACE("else_part ::= elif_part directive_groups else_line TOK_PRE_DIRECTIVE_END")
#line 838 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreElsePart (yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0);
    }
#line 1913 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 14:
        YYTRACE("elif_part ::= directive_groups elif_line TOK_PRE_DIRECTIVE_END")
#line 847 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreElifPart ();
        ((PreElifPart*) (yygotominor.yy0))->addSons (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0);
    }
#line 1923 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 15:
        YYTRACE("elif_part ::= elif_part directive_groups elif_line TOK_PRE_DIRECTIVE_END")
#line 853 "cpp/PreParser.lem"
{
        ((PreElifPart*) (yymsp[-3].minor.yy0))->addSons (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0);
        yygotominor.yy0 = yymsp[-3].minor.yy0;
    }
#line 1933 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 16:
        YYTRACE("endif_part ::= endif_line TOK_PRE_DIRECTIVE_END")
#line 863 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 1942 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 17:
        YYTRACE("if_line ::= TOK_PRE_IF token_list")
#line 872 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIfDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // A new conditional group starts, so go one level deeper.
        level->deeper ();

        if (! state->errorDirective)
            if (state->passOnToken) 
                {
                // Create a new macro expander to expand the macros that could
                // be part of the expression. 
                PreMacroExpander expander (parser);

                Location location = ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->location ();

                // Create a new expression evaluator.
                PreExpr expr (err, location);

                // Now add the special macro `defined' to the macro manager.
                PreTree* idl   = new PreIdentifierList (yymsp[-1].minor.yy0);
                PreMacro*   macro = new PreMacro ("defined", idl, "\n");
                delete idl;
                macro->location (location);
                parser->macroManager ()->addMacro (macro);
        
                // Update the predefined macros.
                updatePredefined ();
        
                // Build the expression string and then expand all macros within it.
                // Then we should have a string consisting only of 0s, 1s and some
                // operators like || or &&. Evaluate the string.
                char* str = buildString (yymsp[0].minor.yy0);
                char* exprstr = expander.expandMacros (str);
                expr.evaluatePreExpr (exprstr);
                    delete[] exprstr;
                delete[] str;

                // Remove the special macro `defined' from macro manager.
                parser->macroManager ()->removeMacro ("defined");

                // Add a daughter node containing the value of the expression.
                yygotominor.yy0->add_daughter (new PreCondSemNode (expr.value ()));

                // Now decide whether to go on or to ignore following C++ code.
                if (expr.value ()) level->setState (false);
                else state->passOnToken = false;
            } 
            else // Ignore further tokens.
            {
                    level->setPassOn (false);
                level->setState (false);
            } 
    }
#line 2001 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 18:
        YYTRACE("ifdef_line ::= TOK_PRE_IFDEF token_list")
#line 931 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIfdefDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // A new conditional group starts, so go one level deeper.
        level->deeper ();

        // Ignore further tokens.
        if (! state->errorDirective)
        {
          level->setPassOn (false);
          level->setState (false);
        }
    }
#line 2019 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 19:
        YYTRACE("ifdef_line ::= TOK_PRE_IFDEF TOK_PRE_ID token_list")
#line 945 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIfdefDirective (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // A new conditional group starts, so go one level deeper.
        level->deeper ();
        
        if (! state->errorDirective)
            if (state->passOnToken) 
                {
                const char* name  = ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->text ();
                PreMacro*   macro = parser->macroManager ()->getMacro (name);
        
                // Search the given macro name. If found the value of the 
                // conditional is true else it's false. Add a daughter node 
                // containing the value of the conditonal.
                if (macro)
                    yygotominor.yy0->add_daughter (new PreCondSemNode (true));
                else
                    yygotominor.yy0->add_daughter (new PreCondSemNode (false));
            
                // Now decide whether to go on or to ignore following C++ code.
                if (macro) level->setState (false);
                else state->passOnToken = false;
            } 
            else // Ignore further tokens.
            {
                    level->setPassOn (false);
                level->setState (false);
            } 
    }
#line 2054 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 20:
        YYTRACE("ifndef_line ::= TOK_PRE_IFNDEF token_list")
#line 981 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIfndefDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // A new conditional group starts, so go one level deeper.
        level->deeper ();

        // Ignore further tokens.
        if (! state->errorDirective)
        {
          level->setPassOn (false);
          level->setState (false);
        }
    }
#line 2072 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 21:
        YYTRACE("ifndef_line ::= TOK_PRE_IFNDEF TOK_PRE_ID token_list")
#line 995 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIfndefDirective (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // A new conditional group starts, so go one level deeper.
        level->deeper ();
        
        if (! state->errorDirective)
            if (state->passOnToken) 
                {
                const char* name  = ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->text ();
                PreMacro* macro = parser->macroManager ()->getMacro (name);
        
                // Search the given macro name. If found the value of the 
                // conditional is false else it's true. Add a daughter node 
                // containing the value of the conditonal.
                if (! macro)
                    yygotominor.yy0->add_daughter (new PreCondSemNode (true));
                else
                    yygotominor.yy0->add_daughter (new PreCondSemNode (false));
            
                // Now decide whether to go on or to ignore following C++ code.
                if (! macro) level->setState (false);
                else state->passOnToken = false;
            } 
            else // Ignore further tokens.
            {
                    level->setPassOn (false);
                level->setState (false);
            } 
    }
#line 2107 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 22:
        YYTRACE("elif_line ::= TOK_PRE_ELIF token_list")
#line 1031 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreElifDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective)
            if (state->passOnToken && ! level->state ())
                state->passOnToken = false;
            else if (! state->passOnToken && level->state ())
            {
                // Create a new macro expander to expand the macros that could
                // be part of the expression. 
                PreMacroExpander expander (parser);
        
                Location location = ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->location ();
        
                // Create a new expression evaluator.
                PreExpr expr (err, location);
        
                // Now add the special macro `defined' to the macro manager.
                PreTree* idl   = new PreIdentifierList (yymsp[-1].minor.yy0);
                PreMacro*   macro = new PreMacro ("defined", idl, "\n");
                delete idl;
                macro->location (location);
                parser->macroManager ()->addMacro (macro);
        
                // Update the predefined macros.
                updatePredefined ();
        
                // Build the expression string and then expand all macros within it.
                // Then we should have a string consisting only of 0s, 1s and some
                // operators like || or &&. Evaluate the string.
                char* str = buildString (yymsp[0].minor.yy0);
                char* exprstr = expander.expandMacros (str);
                expr.evaluatePreExpr (exprstr);
                    delete[] exprstr;
                delete[] str;
        
                // Remove the special macro `defined' from macro manager.
                parser->macroManager ()->removeMacro ("defined");
        
                // Add a daughter node containing the value of the expression.
                yygotominor.yy0->add_daughter (new PreCondSemNode (expr.value ()));
                
                // Now decide whether to go on or to ignore following C++ code.
                if (expr.value ()) 
                {
                    state->passOnToken = true;
                    level->setState (false);
                    } 
            }
    }
#line 2162 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 23:
        YYTRACE("else_line ::= TOK_PRE_ELSE token_list")
#line 1087 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreElseDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // Decide whether to go on or to ignore following C++ code.
        if (! state->errorDirective)
            if (state->passOnToken && ! level->state ()) 
                state->passOnToken = false;
            else if (! state->passOnToken && level->state ()) {
                state->passOnToken = true;
                level->setState (false);
            } 
    }
#line 2179 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 24:
        YYTRACE("endif_line ::= TOK_PRE_ENDIF token_list")
#line 1105 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreEndifDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // A conditional group ends. If no #error was parsed befor
        // go one level higher.
        
        // Decide whether to go on or to ignore following C++ code.
        if (! state->errorDirective) {
            if (level->passOn ())
                state->passOnToken = true;
            level->higher ();
        }
    }
#line 2197 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 25:
        YYTRACE("control_line ::= include_line TOK_PRE_DIRECTIVE_END")
#line 1124 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2205 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 26:
        YYTRACE("control_line ::= include_next_line TOK_PRE_DIRECTIVE_END")
#line 1128 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2214 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 27:
        YYTRACE("control_line ::= assert_line TOK_PRE_DIRECTIVE_END")
#line 1132 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2223 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 28:
        YYTRACE("control_line ::= unassert_line TOK_PRE_DIRECTIVE_END")
#line 1136 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2232 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 29:
        YYTRACE("control_line ::= define_line TOK_PRE_DIRECTIVE_END")
#line 1140 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2241 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 30:
        YYTRACE("control_line ::= undef_line TOK_PRE_DIRECTIVE_END")
#line 1144 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2250 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 31:
        YYTRACE("control_line ::= warning_line TOK_PRE_DIRECTIVE_END")
#line 1148 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2259 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 32:
        YYTRACE("control_line ::= error_line TOK_PRE_DIRECTIVE_END")
#line 1152 "cpp/PreParser.lem"
{
        yygotominor.yy0 = yymsp[-1].minor.yy0;
    }
#line 2268 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        /* No destructor defined for TOK_PRE_DIRECTIVE_END */
        break;
      case 33:
        YYTRACE("include_line ::= TOK_PRE_INCLUDE token_list")
#line 1161 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIncludeDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);

        if (! state->errorDirective && state->passOnToken) 
        { 
            // Calculate the number of files included.
            int num = state->number ? state->number - 2 : ((TokenStream*)
                      (parser->scanner ()))->length () - 1;

            if (((PreIncludeDirective*)yygotominor.yy0)->is_forced ())
            	state->forcedIncludes = true;
            else if (!((PreIncludeDirective*)yygotominor.yy0)->is_forced () && num == 0)
            	state->forcedIncludes = false;
            
            if (state->forcedIncludes)
            	num--;
            
            // Save current include depth.
            ((PreIncludeDirective*)yygotominor.yy0)->depth (num);

            // If the number of files included is higher than a maximal
            // count of maxIncludeDepth we should report an error and 
            // ignore the file to include.
            if (num >= state->maxIncludeDepth) {
                *err << ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->location ()
                     << sev_error << "Include recursion too deep ("
                     << num << ")" << endMessage; 
            } 
            
            // Include the given file.
            else 
            {        // Update the predefined macros.
                updatePredefined ();
        
                // Include the file and add a daughter node with a 
                // reference to that file to the syntax tree.
                char* str = buildString (yymsp[0].minor.yy0);
                Unit* unit = 0;
                bool guarded = false;
                
                const char *txt = ((PreTreeToken*)yymsp[-1].minor.yy0)->token ()->text ();
                
                // compare last character of directive token to decide
                // whether this is an #include or #import directive
                if (txt && txt[strlen (txt)-1] == 't') {
                  // call the import handler with the arguments
                  // given at the #import line
                  ImportHandler ih (*parser, str);
                  unit = ih.IncludeFile ();
                // do an ordinary #include
                } else {
                  unit = parser->fileIncluder ()->includeFile (str);
                  guarded = parser->fileIncluder ()->guarded ();
                }
                
                yygotominor.yy0->add_daughter (new PreInclSemNode (unit, guarded));
                delete[] str;
            }
        }
    }
#line 2334 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 34:
        YYTRACE("include_next_line ::= TOK_PRE_INCLUDE_NEXT token_list")
#line 1227 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreIncludeDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);

        if (! state->errorDirective && state->passOnToken) 
        { 
            // Calculate the number of files included.
            int num = state->number ? state->number - 2 : ((TokenStream*)
                      (parser->scanner ()))->length () - 1;
            
            // If the number of files included is higher than a maximal
            // count of maxIncludeDepth we should report an error and 
            // ignore the file to include.
            if (num >= state->maxIncludeDepth) {
                *err << ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->location ()
                     << sev_error << "Include recursion too deep ("
                     << num << ")" << endMessage; 
            } 
            
            // Include the next file with the given filename.
            else 
            {        // Update the predefined macros.
                updatePredefined ();
        
                // Include the next file and add a daughter node with
                // a reference to that file to the syntax tree.
                char* str = buildString (yymsp[0].minor.yy0);
                Unit *unit = parser->fileIncluder ()->includeNextFile (str);
                bool guarded = parser->fileIncluder ()->guarded ();
                yygotominor.yy0->add_daughter (new PreInclSemNode (unit, guarded));
                delete[] str;
            }
        }
    }
#line 2372 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 35:
        YYTRACE("assert_line ::= TOK_PRE_ASSERT token_list")
#line 1266 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreAssertDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 2380 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 36:
        YYTRACE("assert_line ::= TOK_PRE_ASSERT TOK_PRE_ID token_list")
#line 1270 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreAssertDirective (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Get the answer text.
            char* str    = buildString (yymsp[0].minor.yy0);
            char* answer = evalAnswerString (str, true, *state);
            delete[] str;

            // If the answer isn't NULL get the name of the predicate.
            // If the predicate already exists add yymsp[-2].minor.yy0 new answer to that
            // predicate otherwise create yymsp[-2].minor.yy0 new predicate.
            if (answer) {
                const char* name = ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->text ();
                if (PrePredicate* predicate = parser->predicateManager ()->
                                              getPredicate (name))
                    predicate->addAnswer (answer);
                else
                    parser->predicateManager ()->addPredicate (
                            new PrePredicate (name, answer));
                delete[] answer;
            }
        }
    }
#line 2410 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 37:
        YYTRACE("unassert_line ::= TOK_PRE_UNASSERT token_list")
#line 1301 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreUnassertDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 2418 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 38:
        YYTRACE("unassert_line ::= TOK_PRE_UNASSERT TOK_PRE_ID token_list")
#line 1305 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreUnassertDirective (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);

        if (! state->errorDirective && state->passOnToken) 
        {
            // Get the answer text.
            char* str    = buildString (yymsp[0].minor.yy0);
            char* answer = evalAnswerString (str, false, *state);
            delete[] str;

            // If the answer string is empty remove the whole predicate.
            // Otherwise remove the answer for the predicate.
            if (answer) {
                const char* name = ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->text ();
                PrePredicate* predicate = parser->predicateManager ()->
                                          getPredicate (name);
                                          
                if (! strlen (answer)) 
                    parser->predicateManager ()->removePredicate (name);
                else if (predicate)
                    predicate->removeAnswer (answer);
                    
                delete[] answer;
            }
        }
    }
#line 2449 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 39:
        YYTRACE("define_line ::= TOK_PRE_DEFINE token_list")
#line 1337 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineConstantDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 2457 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 40:
        YYTRACE("define_line ::= TOK_PRE_DEFINE TOK_PRE_ID TOK_PRE_LPAREN TOK_PRE_RPAREN token_list")
#line 1342 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineFunctionDirective (yymsp[-4].minor.yy0, yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Build a new function-like macro without arguments.
            char*     str   = buildString (yymsp[0].minor.yy0);
            PreMacro* macro = new PreMacro (((PreTreeToken*) yymsp[-3].minor.yy0)->
                              token ()->text (), (PreTree*) 0, str);
            delete[] str;
            macro->location (((PreTreeToken*) yymsp[-4].minor.yy0)->token ()->location ());
            
            // Add the macro to the macro manager if its name is a valid
            // macro name.
            if (state->checkMacroName (macro)) 
                parser->macroManager ()->addMacro (macro);
            else
                delete macro;
        }
    }
#line 2482 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 41:
        YYTRACE("define_line ::= TOK_PRE_DEFINE TOK_PRE_ID TOK_PRE_LPAREN TOK_PRE_REST TOK_PRE_RPAREN token_list")
#line 1364 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineFunctionDirective (yymsp[-5].minor.yy0, yymsp[-4].minor.yy0, yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Build a new function-like macro with variable number 
            // of arguments.
            char*     str   = buildString (yymsp[0].minor.yy0);
            PreMacro* macro = new PreMacro (((PreTreeToken*) yymsp[-4].minor.yy0)->
                              token ()->text (), (PreTree*) 0, str, 
                              PreMacro::VAR_ARG_MACRO);
            delete[] str;
            macro->location (((PreTreeToken*) yymsp[-5].minor.yy0)->token ()->location ());
            
            // Add the macro to the macro manager if its name is a valid
            // macro name.
            if (state->checkMacroName (macro)) 
                parser->macroManager ()->addMacro (macro);
            else
                delete macro;
        }
    }
#line 2509 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 42:
        YYTRACE("define_line ::= TOK_PRE_DEFINE TOK_PRE_ID TOK_PRE_LPAREN identifier_list TOK_PRE_RPAREN token_list")
#line 1389 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineFunctionDirective (yymsp[-5].minor.yy0, yymsp[-4].minor.yy0, yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Build a new function-like macro with arguments.
            char*     str   = buildString (yymsp[0].minor.yy0);
            PreMacro* macro = new PreMacro (((PreTreeToken*) yymsp[-4].minor.yy0)->
                              token ()->text (), yymsp[-2].minor.yy0, str);
            delete[] str;
            macro->location (((PreTreeToken*) yymsp[-5].minor.yy0)->token ()->location ());
        
            // Add the macro to the macro manager if its name is a valid
            // macro name.
            if (state->checkMacroName (macro)) 
                parser->macroManager ()->addMacro (macro);
            else
                delete macro;
        }
    }
#line 2534 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 43:
        YYTRACE("define_line ::= TOK_PRE_DEFINE TOK_PRE_ID TOK_PRE_LPAREN identifier_list TOK_PRE_REST TOK_PRE_RPAREN token_list")
#line 1412 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineFunctionDirective (yymsp[-6].minor.yy0, yymsp[-5].minor.yy0, yymsp[-4].minor.yy0, yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Build a new function-like macro with arguments.
            char*     str   = buildString (yymsp[0].minor.yy0);
            PreMacro* macro = new PreMacro (((PreTreeToken*) yymsp[-5].minor.yy0)->
                              token ()->text (), yymsp[-3].minor.yy0, str, 
                              PreMacro::VAR_ARG_MACRO);
            delete[] str;
            macro->location (((PreTreeToken*) yymsp[-6].minor.yy0)->token ()->location ());
                    
            // Add the macro to the macro manager if its name is a valid
            // macro name.
            if (state->checkMacroName (macro)) 
                parser->macroManager ()->addMacro (macro);
            else
                delete macro;
        }
    }
#line 2560 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 44:
        YYTRACE("define_line ::= TOK_PRE_DEFINE TOK_PRE_ID TOK_PRE_LPAREN identifier_list TOK_PRE_COMMA TOK_PRE_REST TOK_PRE_RPAREN token_list")
#line 1436 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineFunctionDirective (yymsp[-7].minor.yy0, yymsp[-6].minor.yy0, yymsp[-5].minor.yy0, yymsp[-4].minor.yy0, yymsp[-3].minor.yy0, yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Build a new function-like macro with arguments.
            char*     str   = buildString (yymsp[0].minor.yy0);
            PreMacro* macro = new PreMacro (((PreTreeToken*) yymsp[-6].minor.yy0)->
                              token ()->text (), yymsp[-4].minor.yy0, str, 
                              PreMacro::VAR_ARG_MACRO);
            delete[] str;
            macro->addArg ("__VA_ARGS__");
            macro->location (((PreTreeToken*) yymsp[-7].minor.yy0)->token ()->location ());
                    
            // Add the macro to the macro manager if its name is a valid
            // macro name.
            if (state->checkMacroName (macro)) 
                parser->macroManager ()->addMacro (macro);
            else
                delete macro;
        }
    }
#line 2587 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 45:
        YYTRACE("define_line ::= TOK_PRE_DEFINE TOK_PRE_ID token_list")
#line 1459 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreDefineConstantDirective (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);

        if (! state->errorDirective && state->passOnToken) 
        {
            // Build a new simple macro.
            char*     str   = buildString (yymsp[0].minor.yy0);
            PreMacro* macro = new PreMacro (((PreTreeToken*) yymsp[-1].minor.yy0)->
                              token ()->text (), str);
            delete[] str;
            macro->location (((PreTreeToken*) yymsp[-2].minor.yy0)->token ()->location ());
            
            // Add the macro to the macro manager if its name is a valid
            // macro name.
            if (state->checkMacroName (macro)) 
                parser->macroManager ()->addMacro (macro);
            else
                delete macro;
        }
    }
#line 2612 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 46:
        YYTRACE("undef_line ::= TOK_PRE_UNDEF token_list")
#line 1485 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreUndefDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 2620 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 47:
        YYTRACE("undef_line ::= TOK_PRE_UNDEF TOK_PRE_ID token_list")
#line 1489 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreUndefDirective (yymsp[-2].minor.yy0, yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        // Remove the macro given by its name from macro manager.
        if (! state->errorDirective && state->passOnToken) 
            parser->macroManager ()->removeMacro (((PreTreeToken*) yymsp[-1].minor.yy0)->
                                                  token ()->text ());
    }
#line 2633 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 48:
        YYTRACE("warning_line ::= TOK_PRE_WARNING token_list")
#line 1503 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreWarningDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Print a warning message containing the text given as
            // argument of the #warning directive.
            char* message = buildString (yymsp[0].minor.yy0);
            *err << ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->location () 
                 << "warning," << message << endMessage; 
            delete[] message;
        }
    }
#line 2651 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 49:
        YYTRACE("error_line ::= TOK_PRE_ERROR token_list")
#line 1522 "cpp/PreParser.lem"
{
        yygotominor.yy0 = new PreErrorDirective (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        
        if (! state->errorDirective && state->passOnToken) 
        {
            // Tell the parser to hide all following tokens from
            // other parsers in chain.
            state->errorDirective = true;
            
            // Print the text given as argument of the #error
            // directive.
            char* message = buildString (yymsp[0].minor.yy0);
            *err << ((PreTreeToken*) yymsp[-1].minor.yy0)->token ()->location () 
                 << "error," << message << endMessage; 
            delete[] message;
        }
    }
#line 2673 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 50:
        YYTRACE("identifier_list ::= TOK_PRE_ID")
#line 1545 "cpp/PreParser.lem"
{ 
        yygotominor.yy0 = new PreIdentifierList (yymsp[0].minor.yy0);
    }
#line 2681 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 51:
        YYTRACE("identifier_list ::= identifier_list TOK_PRE_COMMA TOK_PRE_ID")
#line 1549 "cpp/PreParser.lem"
{
        ((PreIdentifierList*) (yymsp[-2].minor.yy0))->addSons (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
        yygotominor.yy0 = yymsp[-2].minor.yy0;
    }
#line 2690 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 52:
        YYTRACE("token_list ::= TOK_PRE_NEWLINE")
#line 1559 "cpp/PreParser.lem"
{ 
        if (yymsp[0].minor.yy0->startToken () == state->newline) 
        {
            delete yymsp[0].minor.yy0;
            yygotominor.yy0 = new PreTokenList ();
        } 
        else
            yygotominor.yy0 = yymsp[0].minor.yy0;  
    }
#line 2704 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 53:
        YYTRACE("token_list ::= token_list_part TOK_PRE_NEWLINE")
#line 1569 "cpp/PreParser.lem"
{ 
        if (yymsp[0].minor.yy0->startToken () == state->newline) 
        {
            delete yymsp[0].minor.yy0;
            yygotominor.yy0 = new PreTokenList (yymsp[-1].minor.yy0);
        }
        else
            yygotominor.yy0 = new PreTokenList (yymsp[-1].minor.yy0, yymsp[0].minor.yy0);
    }
#line 2718 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 54:
        YYTRACE("token_list_part ::= TOK_PRE_TOKEN_LIST")
#line 1584 "cpp/PreParser.lem"
{ 
        yygotominor.yy0 = new PreTokenListPart (yymsp[0].minor.yy0); 
    }
#line 2726 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
      case 55:
        YYTRACE("token_list_part ::= token_list_part TOK_PRE_TOKEN_LIST")
#line 1588 "cpp/PreParser.lem"
{ 
        yymsp[-1].minor.yy0->add_son (yymsp[0].minor.yy0);
        yygotominor.yy0 = yymsp[-1].minor.yy0; 
    }
#line 2735 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser PreParserARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  PreParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  PreParserANSIARGDECL               /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 721 "cpp/PreParser.lem"

    // Prevent the parser to report an error twice.
    if (state->syntaxError) {
        state->syntaxError = false;
    } 
    
    // Report the syntax error.
    else {
        Unit u;
        state->syntaxError = true;

        if (state->currType == Token::ID_END_OF_FILE) {
            *err << state->lastToken->location () << sev_error
                 << "End of file within directive" 
                 << endMessage; 
        } else if (state->lastType == TOK_PRE_NEWLINE) {
            Token* token = (Token*) (u.prev (state->lastToken));
            while (! token->is_preprocessor ())
                token = (Token*) (u.prev (token));
                *err << state->lastToken->location () << sev_error
                       << "Unterminated `" << token->text () 
                 << "' directive" << endMessage; 
        } else 
                *err << state->lastToken->location () << sev_error
                 << "Unexpected token `" 
                 << state->lastToken->text () << "'" << endMessage; 
    }

#line 2806 "/tmp/AOP_LIN/AOP/Puma/gen-release/step1/src/PreParser.cc"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  PreParserANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "PreParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void PreParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  PreParserTOKENTYPE yyminor       /* The value for the token */
  PreParserANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    /* Olaf: Empty files must be parse too!  if( yymajor==0 ) return; */
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE PreParserARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion PreParserARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser PreParserARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion PreParserARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser PreParserARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser PreParserARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}

struct TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0 {
  typedef ::Puma::Token * Result;
  typedef ::Puma::PreprocessorParser That;
  typedef ::Puma::PreprocessorParser Target;
  static const int JPID = 138;
  static const AC::JPType JPTYPE = (AC::JPType)4;
  struct Res {
    typedef ::Puma::Token * Type;
    typedef ::Puma::Token * ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  Result *_result;
  That *_that;

  inline Result *result() {return (Result*)_result;}
  inline That *that() {return (That*)_that;}

};


struct TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0 {
  typedef ::Puma::Token * Result;
  typedef ::Puma::PreprocessorParser That;
  typedef ::Puma::PreprocessorParser Target;
  static const int JPID = 139;
  static const AC::JPType JPTYPE = (AC::JPType)4;
  struct Res {
    typedef ::Puma::Token * Type;
    typedef ::Puma::Token * ReferredType;
  };
  enum { ARGS = 0 };
  template <int I, int DUMMY = 0> struct Arg {
    typedef void Type;
    typedef void ReferredType;
  };

  Result *_result;
  That *_that;

  inline Result *result() {return (Result*)_result;}
  inline That *that() {return (That*)_that;}

};

void Puma::PreprocessorParser ::skip_up_to (int end_token) {

struct __call__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0 {
static inline ::Puma::Token * invoke (::Puma::PreprocessorParser *srcthis, ::Puma::PreprocessorParser *dstthis){
  AC::ResultBuffer< ::Puma::Token *  > result;
  TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0 tjp;
  tjp._result = &(TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0::Result&)result;
  tjp._that =  (TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0::That*)srcthis;
  ::new (&result) ::Puma::Token *  (dstthis->parseToken());
  AC::invoke_PragmaOnce_PragmaOnce_a1_after<TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0> (&tjp);
  return (::Puma::Token * &)result;
 }
};


struct __call__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0 {
static inline ::Puma::Token * invoke (::Puma::PreprocessorParser *srcthis, ::Puma::PreprocessorParser *dstthis){
  AC::ResultBuffer< ::Puma::Token *  > result;
  TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0 tjp;
  tjp._result = &(TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0::Result&)result;
  tjp._that =  (TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0::That*)srcthis;
  ::new (&result) ::Puma::Token *  (dstthis->parseToken());
  AC::invoke_PragmaOnce_PragmaOnce_a1_after<TJP__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0> (&tjp);
  return (::Puma::Token * &)result;
 }
};

    unsigned parenthesis = 0, curlies = 0;
    Token *token;
    int type;
    
    // skip up to the first non-nested `{'
    while ((token = __call__ZN4Puma18PreprocessorParser10skip_up_toEi_0_0::invoke ((::Puma::PreprocessorParser*)this,(::Puma::PreprocessorParser*)this ))) {
      type = token->type ();
      if (type == TOK_OPEN_CURLY) {
        if (parenthesis == 0 && curlies == 0)
          break;
        curlies++;
      } else if (type == TOK_CLOSE_CURLY)
        curlies--;
      else if (type == TOK_OPEN_ROUND)
        parenthesis++;
      else if (type == TOK_CLOSE_ROUND)
        parenthesis--;
    }
    
    // skip up to the first non-nested `}'
    if (end_token == TOK_CLOSE_CURLY) {
      parenthesis = curlies = 0;
      while ((token = __call__ZN4Puma18PreprocessorParser10skip_up_toEi_2_0::invoke ((::Puma::PreprocessorParser*)this,(::Puma::PreprocessorParser*)this ))) {
        type = token->type ();
        if (type == TOK_OPEN_CURLY)
          curlies++;
        else if (type == TOK_CLOSE_CURLY) {
          if (parenthesis == 0 && curlies == 0)
            break;
          curlies--;
        } else if (type == TOK_OPEN_ROUND)
          parenthesis++;
        else if (type == TOK_CLOSE_ROUND)
          parenthesis--;
      }
    }
  }
#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_PreParser_cc__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __WinMacros__
#define __WinMacros__

/********************************************************/
/* Win predefined macros aspect                         */
/********************************************************/

using namespace Puma;


class WinIfExists;
class WinImportHandler;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class WinMacros {
public:
  static WinMacros *aspectof () {
    static WinMacros __instance;
    return &__instance;
  }
  static WinMacros *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  /********************************************************/
  /* Win specific predefined macros                       */
  /********************************************************/

  // predefine win specific macros
  
public: template<class JoinPoint> void __a0_before (JoinPoint *tjp, const Config &config) {
  JoinPoint *&thisJoinPoint = tjp;

  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (config.Option ("--vc")) {
      // constants
      thisJoinPoint->that ()->defMacro ("__w64", " ");
      thisJoinPoint->that ()->defMacro ("_inline", "inline");
      thisJoinPoint->that ()->defMacro ("__forceinline", "inline");
      thisJoinPoint->that ()->defMacro ("__interface", "class");
      thisJoinPoint->that ()->defMacro ("__try", "if(1)");
      thisJoinPoint->that ()->defMacro ("__except", "if");
      thisJoinPoint->that ()->defMacro ("__noop", " ");

      // function-like macros
      PreMacro::MacroArgs *args = new PreMacro::MacroArgs (1);
      args->append ("__arg0");
      thisJoinPoint->that ()->macroManager ()->addMacro (
        new PreMacro ("__declspec", args, " "));
    }
  }
private:


protected:
  WinMacros () {}
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_WinMacros_WinMacros_a0_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::WinMacros::aspectof()->__a0_before (tjp, (const Puma::Config &)Arg0::val (tjp));
  }
} 



#endif /* __WinMacros__ */
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ext_ac_keywords_ah__
#define __ext_ac_keywords_ah__


#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CProject_h__
#define __CProject_h__

// Special project derivation for C++ sources.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __project__
#define __project__

// The basic project is a set of source directories. It provides 
// methods for searching and writing files. 

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_manager__
#define __path_manager__

// Manages directories and methods to access the files in it.

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_info__
#define __path_info__

// A path information object consists of a source and optionally
// a destination path.

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PathInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  const char *_src;        // Source path.
  const char *_dest;        // Destination path.
        
public:
  PathInfo () : _src ((const char*) 0), _dest ((const char*) 0) {}
  PathInfo (const PathInfo &);
  ~PathInfo ();
        
  // Needed for class Array.
  PathInfo &operator =(const PathInfo &);

  // Set or get the source path.
  void src (const char *);
  const char *src () const { return _src; }
        
  // Set or get the destination path.
  void dest (const char *);
  const char *dest () const { return _dest; }
};


} // namespace Puma

#endif /* __path_info__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __path_iterator__
#define __path_iterator__

// A path iterator is used to iterate the contents of the paths
// a project is managing. But only files matching a given pattern 
// are iterated. 

// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __project_file__
#define __project_file__

using std::map;
using std::string;

namespace Puma {
 
// the project file abstraction is used to store all filenames relevant
// for a specific file that is managed by Puma.

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class ProjectFile {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Filename _nick_name;
  Filename _dest_path;
public:  
  ProjectFile (const Filename &nn) : _nick_name (nn) {}
  ProjectFile (const Filename &nn, const Filename &dp) :
    _nick_name (nn), _dest_path (dp) {}
  void dest (const Filename &dp) { _dest_path = dp; }
  Filename name () const { return _nick_name; }
  Filename dest () const {
    assert (_dest_path.is_defined ());
    return _dest_path;
  }
};

typedef map<string, ProjectFile> PFMap;
typedef PFMap::value_type PFMPair;
typedef PFMap::const_iterator PFMConstIter;

} // namespace Puma

#endif // __project_file__
namespace Puma {

class PathManager;
class RegComp;
 
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PathIterator : public PFMConstIter {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  friend class PathManager;

  RegComp *_regexp;  // Search pattern.
  bool _in_use;

public:
  PathIterator (const char *);     // Expects a regular expression.
  ~PathIterator ();                // for the files to match.

  void pattern (const char *);     // Set the search pattern.
  void init (const PFMConstIter &begin);
  bool in_use () const { return _in_use; }
  void done () { _in_use = false; }

  // retrieve information about the currently referenced ProjectFile
  const char *file () const;
  const char *dest () const;
};

} // namespace Puma

#endif /* __path_iterator__ */
namespace Puma {

class RegComp;
class Config;
class Unit;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class PathManager {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  ErrorStream     *_err;
  Array<PathInfo>  _paths;     // List of directories path.
  Array<RegComp*>  _protected; // List of regular patterns specifying 
                               // protected paths.
  PFMap _files;                // Maps the canonical filename of a project
                               // to its related information

  // find all files of a directory tree and add them to _files
  void traverse (const char *path);

  // find the canonical filename representation for a file
  bool canonFilename (Filename name, Filename &abs_name) const;
  
  // Add a new file to the project file list
  PFMConstIter addFile (const ProjectFile &file);

protected:
  // Get the destination directory for a given source directory.
  const char *getDestination (Filename file, ostream * = 0) const;
        
  // Called for every matched file.
  virtual void action (PathIterator &) {}
        
  // Add the separator '/' to the copy of the given string.
  char *addSeparator (const char *) const;

public:
  PathManager (ErrorStream &e) : _err (&e) {} 
  // Copy-constructor.
  PathManager (PathManager &pm) { _err = pm._err; join (pm); }
  virtual ~PathManager ();

  // Start the globbing. Let call action for every match.
  void glob (char *pattern = (char*) 0);

  // Iterate the contents of the paths.
  const char *iterate (PathIterator &) const;
        
  // Add a source and destination directories pair.
  virtual void addPath (const char *, const char * = (const char*) 0);

  // Add a new file to the project file list
  PFMConstIter addFile (Filename name);

  // Add a new file to the project file list with destination path
  PFMConstIter addFile (Filename name, Filename dest);

  // search an absolute file name in the project tree
  bool lookupFile (Filename abs_name, PFMConstIter &iter) const;

  // Set the destination directory of the given source directory.
  void setDest (const char *, const char *);

  // Add a protected-path pattern.
  void protect (const char *);

  // Get path information.
  long numPaths () const { return _paths.length (); }
  long numProts () const { return _protected.length (); }
  const char *src (long pos) const { return _paths.lookup (pos).src (); }
  const char *dest (long pos) const { return _paths.lookup (pos).dest (); }
  RegComp *prot (long pos) const { return _protected.lookup (pos); }

  // Return true if the given file or path is protected.
  bool isProtected (const char *file) const;

  // checks if a give file (by name) is a registered file of this path manager
  // In case of success (found!) the an iterator is returned, which can be
  // used to access more information about the file.
  bool isBelow (const char *file, PFMConstIter &iter) const;

  // Returns true if the given file is registered with this path manager
  virtual bool isBelow (const char *file) const;

  // Configure the project from the command line or a file.
  virtual void configure (const Config &);

  // Join the paths of the given manager with the paths 
  // of this path manager.
  virtual void join (PathManager &);
        
  // Get the error stream object.
  ErrorStream &err () const { return *_err; }

  // Get the path of a file in the destination directory.
  bool getDestinationPath (const char *filename, ostream &out) const;
        
};

inline bool PathManager::isBelow (const char *file) const { 
  PFMConstIter iter;
  return isBelow (file, iter);
}


} // namespace Puma

#endif /* __path_manager__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __SaveMode__
#define __SaveMode__

namespace Puma {


// Project file save mode.
} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
struct SaveMode {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  enum Mode { 
    OVERWRITE = 1, 
    RENAME_OLD, 
    NEW_SUFFIX 
  };
};
    

} // namespace Puma

#endif /* __SaveMode__ */
#include <fstream>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Project : public PathManager, public SaveMode {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  UnitManager  _unitManager; 
  const char  *_suffix;           // Current file name suffix.
  Mode         _mode;      // Current save mode.

  // Change to the directory, or create it if necessary.
  bool makeDir (const char *) const;
        
  // Create the directory hierarchy need for file 'path'.
  bool makeDirHierarchy (Filename path) const;

protected:
  // Write a unit on a file. Called by save().
  virtual void write (Unit *unit, ofstream &) const; 

  // Check/update the state of the given unit.
  bool checkState (const char *, Unit *) const;
  void updateState (const char *, Unit *) const;
        
public:
  Project (ErrorStream &);
  virtual ~Project ();

  // Set the mode for saving an unit.
  // OVERWRITE  -> Save the unit under its name and overwrite existing
  //                   files.
  // RENAME_OLD -> An existing file will be renamed. A suffix will be
  //                   added to the name of the file, like `main.cc.old'
  //                   for the file `main.cc' and the suffix `.old'.
  // NEW_SUFFIX -> The unit will be saved with a new suffix, like 
  //                   `main.cpp' for the unit `main.cc' and the suffix 
  //               `cpp'.
  void saveMode (Mode = OVERWRITE, const char *suffix = (const char*)0);

  // Save a unit using the name of the unit to get the full 
  // name of the file and path to save to. The save location
  // must not be protected by a protect pattern and the original
  // file must be located in one of the source directories.
  virtual void save (Unit *, bool = false) const;
        
  // Save a FileUnit (or all) to a file (or files).
  virtual void save (const char *file = (const char*)0,
                     bool only_modified = false, bool is_reg_ex = false) const;

  // Print an unit, regular expression for more units.
  // If no name is given print all units.
  void print (const char *name = (const char*)0, ostream &out = cout,
              bool is_reg_ex = false) const;
        
  // Close an unit, regular expression for more units.
  // If no name is given close all units. If destroy is true,
  // the unit(s) will be deleted. 
  void close (const char *name = (const char*)0, bool destroy = false,
              bool is_reg_ex = false) const;

  // Add a new file to the project.
  Unit *addFile (Filename);
  Unit *addFile (Filename, Filename);

  // Configure the project from the command line or a file.
  virtual void configure (const Config &);
        
  // Member access.
  UnitManager &unitManager ();
        
  // Return true if the given file in the source directory
  // (or at the unit manager) is newer than the corresponding
  // file in the destination directory.
  bool isNewer (const char *) const;

  // Returns true if the given file is in or below the project dirs
  virtual bool isBelow (const char *) const;
  virtual bool isBelow (Unit *) const;
};

inline UnitManager &Project::unitManager () 
 {  return _unitManager; }

inline bool Project::isBelow (const char *file) const
 { return PathManager::isBelow (file); }
 
 
} // namespace Puma

#endif /* __project__ */

#ifndef __ac_fwd_ExtACKeywords__
#define __ac_fwd_ExtACKeywords__
class ExtACKeywords;
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp);
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp);
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp);
}
#endif

#ifndef __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#define __ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#endif
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_scanner_h__
#define __c_scanner_h__

#include "Puma/CRecognizer.h"
#include "Puma/Location.h"
#include "Puma/LanguageID.h"
#include "Puma/Tokenizer.h"
#include "Puma/Unit.h"
#include "Puma/ErrorSink.h"
#include "Puma/Config.h"
#include "Puma/Source.h"

namespace Puma {


class Token;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScanner : public CRecognizer, public Tokenizer {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Location loc;
  ErrorSink &err;

  Token *make_token (CRecognizer::Lang lang, int expr, int len);
  LanguageID map_lang (CRecognizer::Lang lang);
  Token *scan ();
  void scan_all (Unit &unit);

public:
  CScanner (ErrorSink &error_stream) : err (error_stream) {}
  virtual ~CScanner () {}
  void configure (const Config &);
  public: inline void __exec_old_fill_unit(::Puma::Source & in,::Puma::Unit & unit);
void fill_unit (Source &in, Unit &unit);
  public: inline void __exec_old_fill_unit(const char * in,::Puma::Unit & unit);
void fill_unit (const char *in, Unit &unit);
};


} // namespace Puma

#endif /* __c_scanner_h__ */
namespace Puma {


class Source;
class CTypeInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CProject : public Project {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Config _config;
  CScanner _scanner;

public:
  CProject (ErrorStream &e);

  // Constructor: Add some source directories.
  CProject (ErrorStream &, const char *defs, 
               const char *decls = (const char*)0); 

  // Constructor: Setup preprocessor configuration according to
  // command line parameter and the global config file and
  // add some source directories.
  CProject (ErrorStream &, int &argc, char **&argv, 
            const char *defs = (const char*)0, 
            const char *decls = (const char*)0);

public: // Project configuration 
  // Get the preprocessor configuration.
  Config &config ();

  // Configure the project from the command line or a file.
  virtual void configure (Config &);

  // Add a new file to the project.
  Unit *addFile (Filename file);

public: // Scanner interface
  // Get the scanner.
  CScanner &scanner ();

  // Scan the file `file' or the source if given. When
  // scanning a source the resulting unit gets the name `file'.
  public: inline ::Puma::Unit * __exec_old_scanFile(const char * file,::Puma::Source * ,bool isFile);
virtual Unit *scanFile (const char *file, Source * = (Source*)0, 
                          bool isFile = true);
        
  // Scan a string. The resulting unit gets the name `name'.
  // (and will not be registered at the unit manager!)
  virtual Unit *scanString (const char *str, 
                            const char *name = (const char*)0);

public: // Miscellaneous Functions

  // Give the filename needed to include a particular header file
  Filename getInclString (Filename filename);

private:
  // Map the type string from --size-type and --ptrdiff-type
  // to real Puma type.
  CTypeInfo *mapType (const char *) const;
};

inline Config &CProject::config () 
 { return _config; }
inline CScanner &CProject::scanner () 
 { return _scanner; }


} // namespace Puma

#endif /* __CProject_h__ */
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __FileUnit__
#define __FileUnit__

// Special Unit for files. Knows its last save location and the
// absolute path of the corresponding file.

namespace Puma {


class Project;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class FileUnit : public Unit {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  char *_lastLocation; 
  char *_absolutePath;
  
  Project *_project;
  bool _isBelow;

public:
  FileUnit ();
  FileUnit (Unit &);
  FileUnit (const List &);
  virtual ~FileUnit ();
            
  virtual void name (const char *);        
  void setLocation (const char *);    
        
  char *lastLocation () const;
  char *absolutePath () const;
  bool isFile () const;
  
  // Generates the absolute pathname to the file.
  static char *absolutePath (const char *);
  static char *resolvePath (const char *);
  
  // File belongs to given project?
  bool belongsTo (Project &);
};

inline FileUnit::FileUnit () : 
  Unit (), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)
 {}
inline FileUnit::FileUnit (Unit &unit) : 
  Unit (unit), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)
 {}
inline FileUnit::FileUnit (const List &list) : 
  Unit (list), 
  _lastLocation ((char*)0), 
  _absolutePath ((char*)0),
  _project (0),
  _isBelow (false)  
 {}
inline FileUnit::~FileUnit () 
 { if (_lastLocation) delete[] _lastLocation; 
   if (_absolutePath) delete[] _absolutePath; }
            
inline char *FileUnit::lastLocation () const 
 { return _lastLocation; }
inline char *FileUnit::absolutePath () const 
 { return _absolutePath; }
inline bool FileUnit::isFile () const 
 { return true; }


} // namespace Puma

#endif /* __FileUnit__ */
using namespace Puma;

// *****************************************
// AspectC++ keyword handling in the scanner
// *****************************************
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
class ExtACKeywords {
public:
  static ExtACKeywords *aspectof () {
    static ExtACKeywords __instance;
    return &__instance;
  }
  static ExtACKeywords *aspectOf () {
    return aspectof ();
  }
private:
  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;


  bool _prj_keywords;
  CProject *_project; // active project
  
protected:
  ExtACKeywords () : _prj_keywords (false) {}
public:
  // allow/forbid AspectC++ keywords in normal project files
  void prj_keywords (bool kw) { _prj_keywords = kw; }
  
  
public: void __a0_before (CProject &project) {
    _project = &project;
  }
  
  
public: template<class JoinPoint> void __a1_before (JoinPoint *tjp, Unit &unit) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    if (!unit.isFile ())
      return;
      
    bool ac_kw = _prj_keywords;
    // in external files the AspectC++ keywords are always identifiers
    if (!((FileUnit*)&unit)->belongsTo (*_project)) {
      ac_kw = false;
    }
    // in aspect headers keywords are keywords
    else if (unit.name () &&
      strcmp (unit.name () + strlen (unit.name ()) - 3, ".ah") == 0) {
      ac_kw = true;
    }
    // finally the right flag
    tjp->that ()->allow_aspectc (ac_kw);
  }
  
  
public: template<class JoinPoint> void __a2_before (JoinPoint *tjp) {
  typedef typename JoinPoint::That __JP_That;
  typedef typename JoinPoint::Target __JP_Target;
  typedef typename JoinPoint::Result __JP_Result;

    _project = tjp->that ();
  }
};
namespace AC {
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a0_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtACKeywords::aspectof()->__a0_before ((Puma::CProject &)Arg0::val (tjp));
  }
  template <class JoinPoint, class Binding>
  inline void invoke_ExtACKeywords_ExtACKeywords_a1_before (JoinPoint *tjp) {
    typedef typename Binding::template Arg<0> Arg0;
    ::ExtACKeywords::aspectof()->__a1_before (tjp, (Puma::Unit &)Arg0::val (tjp));
  }
  template <class JoinPoint>
  inline void invoke_ExtACKeywords_ExtACKeywords_a2_before (JoinPoint *tjp) {
    ::ExtACKeywords::aspectof()->__a2_before (tjp);
  }
} 
  

#endif /* __ext_ac_keywords_ah__ */
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_PreParser_cc__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_src_PreParser_cc__
