// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __syntax_tree_composite__
#define __syntax_tree_composite__

#include "Puma/PreTree.h"
#include "Puma/Array.h"
#include "Puma/PreVisitor.h"

namespace Puma {


// Generic composite nodes:
class PreTreeComposite : public PreTree {
private:
  Array<PreTree*> *son_array;
  Array<PreTree*> *daughter_array;
  int                    max_sons;
  int                    max_daughters;

protected:
  PreTreeComposite (int s, int d);
    
public:
  static const int DYNAMIC = -1;

  virtual ~PreTreeComposite ();
        
  virtual void accept (PreVisitor &) = 0;

  virtual void add_son (PreTree *);
  virtual void replace_son (int, PreTree *);
  virtual PreTree *son (int) const;
  virtual int sons () const;

  virtual void add_daughter (PreTree *);
  virtual void replace_daughter (int, PreTree *);
  virtual PreTree *daughter (int) const;
  virtual int daughters () const;
        
  virtual Token *startToken () const;
  virtual Token *endToken () const;
};


} // namespace Puma

#endif /* __syntax_tree_composite__ */
