// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "NamespaceAC.h"
#include "CFlow.h"

// Puma includes
#include "Puma/CTypeInfo.h"
using namespace Puma;

// C++ includes
#include <sstream>
using std::ostringstream;
using std::endl;


string NamespaceAC::def (string size_type) {
  string acdef;
  
  acdef += 
    "\n"
    "#ifndef __ac_h_\n"
    "#define __ac_h_\n"
    "#ifdef __cplusplus\n"
    "namespace AC {\n"
    "  typedef const char* Type;\n"
    "  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, "
    "CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };\n"
    "  struct Action {\n"
    "    void **_args; void *_result; void *_target; void *_that; void *_fptr;\n"
    "    void (*_wrapper)(Action &);\n"
    "    inline void trigger () { _wrapper (*this); }\n"
    "  };\n"
    "  struct AnyResultBuffer {};\n"
    "  template <typename T> struct ResultBuffer : "
    "public AnyResultBuffer {\n"
    "    char _data[sizeof (T)];\n"
    "    ~ResultBuffer () { ((T*)_data)->T::~T(); }\n"
    "    operator T& () const { return *(T*)_data; }\n"
    "  };\n"
    "  template <typename T, typename N> struct TL {\n"
    "    typedef T type; typedef N next; enum { ARGS = next::ARGS + 1 };\n"
    "  };\n"
    "  struct TLE { enum { ARGS = 0 }; };\n"
    "  template <typename T> struct Referred { typedef T type; };\n"
    "  template <typename T> struct Referred<T &> { typedef T type; };\n"
    "  template <typename TL, int I> struct Arg {\n"
    "    typedef typename Arg<typename TL::next, I - 1>::Type Type;\n"
    "    typedef typename Referred<Type>::type ReferredType;\n"
    "  };\n"
    "  template <typename TL> struct Arg<TL, 0> {\n"
    "    typedef typename TL::type Type;\n"
    "    typedef typename Referred<Type>::type ReferredType;\n"
    "  };\n";

  // class(es) needed to implement CFlows
  acdef += CFlow::ac_namespace_contributions ();
  
  acdef +=
    "}\n"
    "inline void * operator new (";
    
  if (size_type == "") {
    ostringstream size_type_stream;
    size_type_stream << *CTypeInfo::CTYPE_SIZE_T;
    acdef += size_type_stream.str ();
  }
  else
    acdef += size_type;

  acdef +=
    ", AC::AnyResultBuffer *p) { return p; }\n"
    "inline void operator delete "
    "(void *, AC::AnyResultBuffer *) { } // for VC++\n"
    "#endif // __cplusplus\n"
    "#endif // __ac_h_\n";

  return acdef;
}
