// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __C_TOKENS__
#define __C_TOKENS__

namespace Puma {

enum CTokens {

  // core tokens, i.e. numbers, operator symbols, brackets, etc.
  TOK_AT = 100,
  TOK_ZERO_VAL,
  TOK_INT_VAL,
  TOK_FLT_VAL,
  TOK_STRING_VAL,
  TOK_CHAR_VAL,
  TOK_COMMA,
  TOK_ASSIGN,
  TOK_QUESTION,
  TOK_OR,
  TOK_ROOF,
  TOK_AND,
  TOK_PLUS,
  TOK_MINUS,
  TOK_MUL,
  TOK_DIV,
  TOK_MODULO,
  TOK_LESS,
  TOK_GREATER,
  TOK_OPEN_ROUND,
  TOK_CLOSE_ROUND,
  TOK_OPEN_SQUARE,
  TOK_CLOSE_SQUARE,
  TOK_OPEN_CURLY,
  TOK_CLOSE_CURLY,
  TOK_SEMI_COLON,
  TOK_COLON,
  TOK_NOT,
  TOK_TILDE,
  TOK_DOT,
  TOK_MUL_EQ,
  TOK_DIV_EQ,
  TOK_MOD_EQ,
  TOK_ADD_EQ,
  TOK_SUB_EQ,
  TOK_LSH_EQ,
  TOK_RSH_EQ,
  TOK_AND_EQ,
  TOK_XOR_EQ,
  TOK_IOR_EQ,
  TOK_OR_OR,
  TOK_AND_AND,
  TOK_EQL,
  TOK_NEQ,
  TOK_LEQ,
  TOK_GEQ,
  TOK_LSH,
  TOK_RSH,
  TOK_DOT_STAR,
  TOK_PTS_STAR,
  TOK_INCR,
  TOK_DECR,
  TOK_PTS,
  TOK_COLON_COLON,
  TOK_ELLIPSIS,
  TOK_LAST_CORE = TOK_ELLIPSIS, // this is a group separator for the scanner!
  
  // C keywords:
  TOK_ASM,
  TOK_AUTO,
  TOK_BREAK,
  TOK_CASE,
  TOK_CHAR,
  TOK_CONST,
  TOK_CONTINUE,
  TOK_DEFAULT,
  TOK_DO,
  TOK_DOUBLE,
  TOK_ELSE,
  TOK_ENUM,
  TOK_EXTERN,
  TOK_FLOAT,
  TOK_FOR,
  TOK_GOTO,
  TOK_IF,
  TOK_INLINE,
  TOK_INT,
  TOK_LONG,
  TOK_REGISTER,
  TOK_RESTRICT,
  TOK_RETURN,
  TOK_SHORT,
  TOK_SIGNED,
  TOK_SIZEOF,
  TOK_STATIC,
  TOK_STRUCT,
  TOK_SWITCH,
  TOK_TYPEDEF,
  TOK_UNION,
  TOK_UNSIGNED,
  TOK_VOID,
  TOK_VOLATILE,
  TOK_WCHAR_T,
  TOK_WHILE,

  // C compatibility keywords

  TOK_ASM_2,
  TOK_ASM_3,
  TOK_BOOL_2,
  TOK_CONST_2,
  TOK_CONST_3,
  TOK_INLINE_2,
  TOK_INLINE_3,
  TOK_RESTRICT_2,
  TOK_RESTRICT_3,
  TOK_SIGNED_2,
  TOK_SIGNED_3,
  TOK_VOLATILE_2,
  TOK_VOLATILE_3,
  TOK_WCHAR_T_2,
  TOK_TYPEOF,
  TOK_TYPEOF_2,
  TOK_TYPEOF_3,

  // C win specific keywords

  TOK_INT64,
  TOK_CDECL,
  TOK_CDECL_2,
  TOK_STDCALL,
  TOK_STDCALL_2,
  TOK_FASTCALL,
  TOK_FASTCALL_2,
  TOK_IF_EXISTS,
  TOK_IF_NOT_EXISTS,

  TOK_LAST_C = TOK_IF_NOT_EXISTS,
  
  // a boolean constant:
  TOK_BOOL_VAL,

  // C++ keywords:

  TOK_BOOL,
  TOK_CATCH,
  TOK_CLASS,
  TOK_CONST_CAST,
  TOK_DELETE,
  TOK_DYN_CAST,
  TOK_EXPLICIT,
  TOK_EXPORT,
  TOK_FRIEND,
  TOK_MUTABLE,
  TOK_NAMESPACE,
  TOK_NEW,
  TOK_OPERATOR,
  TOK_PRIVATE,
  TOK_PROTECTED,
  TOK_PUBLIC,
  TOK_REINT_CAST,
  TOK_STAT_CAST,
  TOK_TEMPLATE,
  TOK_THIS,
  TOK_THROW,
  TOK_TRY,
  TOK_TYPEID,
  TOK_TYPENAME,
  TOK_USING,
  TOK_VIRTUAL,

  // C++ alternative representation of operators (ISO 646):

  TOK_AND_AND_ISO_646,
  TOK_AND_EQ_ISO_646,
  TOK_AND_ISO_646,
  TOK_OR_ISO_646,
  TOK_TILDE_ISO_646,
  TOK_NOT_ISO_646,
  TOK_NEQ_ISO_646,
  TOK_OR_OR_ISO_646,
  TOK_IOR_EQ_ISO_646,
  TOK_ROOF_ISO_646,
  TOK_XOR_EQ_ISO_646,

  TOK_LAST_CC = TOK_XOR_EQ_ISO_646,
  
  // AspectC++ keywords:

  TOK_POINTCUT,
  TOK_ASPECT,
  TOK_ADVICE,
  TOK_SLICE,
  TOK_UNKNOWN_T,

  TOK_LAST_AC = TOK_UNKNOWN_T,
  
  // further [A](C|C++) token
  TOK_ID,

  // These two always have to be the ** last ** token listed here!!!
  TOK_EPSILON,
  TOK_NO
  
};

} // namespace Puma

#endif /* __C_TOKENS__ */
