// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __filename_h__
#define __filename_h__

#include "Puma/SmartPtr.h"
#include "Puma/Printable.h"
#include "Puma/FilenameInfo.h"

namespace Puma {


class Filename : public SmartPtr, public Printable {
  FilenameInfo *info () const { return (FilenameInfo*)data (); }

public:
  Filename () {}
  Filename (const char *n) { name (n); }
  Filename &operator = (const char *n) { name (n); return *this; }
  bool operator ~ () const { return info () != 0; }
  void name (const char *n);
  const char *name () const;
  const char *path () const;
  const char *root () const;
  bool is_absolute () const;
  bool operator == (const Filename &f) const;
  bool operator != (const Filename &f) const { return !(*this == f); }
  virtual void print (ostream &os) const { if (info ()) os << name (); }
};


} // namespace Puma

#endif /* __filename_h__ */
