/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation.
 * It is mirrored in org.aspectj.org.eclipse.jdt.core.compiler public package where it is API.
 * The mirror implementation is using the backward compatible ITerminalSymbols constant
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens
 * which constant values reflect the latest parser generation state.
 */
/**
 * Maps each terminal symbol in the java-grammar into a unique integer.
 * This integer is used to represent the terminal when computing a parsing action.
 *
 * Disclaimer : These constant values are generated automatically using a Java
 * grammar, therefore their actual values are subject to change if new keywords
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int TokenNameNotAToken = 0,
		TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;

	public final static int
	TokenNameIdentifier = 15,
    TokenNameabstract = 48,
    TokenNameassert = 78,
    TokenNameboolean = 112,
    TokenNamebreak = 79,
    TokenNamebyte = 113,
    TokenNamecase = 91,
    TokenNamecatch = 92,
    TokenNamechar = 114,
    TokenNameclass = 71,
    TokenNamecontinue = 80,
    TokenNameconst = 130,
    TokenNamedefault = 97,
    TokenNamedo = 81,
    TokenNamedouble = 115,
    TokenNameelse = 95,
    TokenNameenum = 88,
    TokenNameextends = 90,
    TokenNamefalse = 56,
    TokenNamefinal = 49,
    TokenNamefinally = 94,
    TokenNamefloat = 116,
    TokenNamefor = 82,
    TokenNamegoto = 131,
    TokenNameif = 83,
    TokenNameimplements = 111,
    TokenNameimport = 93,
    TokenNameinstanceof = 16,
    TokenNameint = 117,
    TokenNameinterface = 76,
    TokenNamelong = 118,
    TokenNamenative = 50,
    TokenNamenew = 42,
    TokenNamenull = 57,
    TokenNamepackage = 89,
    TokenNameprivate = 51,
    TokenNameprotected = 52,
    TokenNamepublic = 47,
    TokenNamereturn = 84,
    TokenNameshort = 119,
    TokenNamestatic = 45,
    TokenNamestrictfp = 53,
    TokenNamesuper = 43,
    TokenNameswitch = 85,
    TokenNamesynchronized = 46,
    TokenNamethis = 44,
    TokenNamethrow = 86,
    TokenNamethrows = 98,
    TokenNametransient = 54,
    TokenNametrue = 58,
    TokenNametry = 87,
    TokenNamevoid = 120,
    TokenNamevolatile = 55,
    TokenNamewhile = 77,
    TokenNamemodule = 122,
    TokenNamerequires = 123,
    TokenNameexports = 124,
    TokenNameto = 125,
    TokenNameuses = 126,
    TokenNameprovides = 127,
    TokenNamewith = 128,
    TokenNameaspect = 27,
    TokenNamepointcut = 30,
    TokenNamearound = 34,
    TokenNamebefore = 31,
    TokenNameafter = 32,
    TokenNamedeclare = 33,
    TokenNameprivileged = 28,
    TokenNameIntegerLiteral = 59,
    TokenNameLongLiteral = 60,
    TokenNameFloatingPointLiteral = 61,
    TokenNameDoubleLiteral = 62,
    TokenNameCharacterLiteral = 63,
    TokenNameStringLiteral = 64,
    TokenNamePLUS_PLUS = 3,
    TokenNameMINUS_MINUS = 4,
    TokenNameEQUAL_EQUAL = 23,
    TokenNameLESS_EQUAL = 17,
    TokenNameGREATER_EQUAL = 18,
    TokenNameNOT_EQUAL = 20,
    TokenNameLEFT_SHIFT = 21,
    TokenNameRIGHT_SHIFT = 12,
    TokenNameUNSIGNED_RIGHT_SHIFT = 14,
    TokenNamePLUS_EQUAL = 99,
    TokenNameMINUS_EQUAL = 100,
    TokenNameMULTIPLY_EQUAL = 101,
    TokenNameDIVIDE_EQUAL = 102,
    TokenNameAND_EQUAL = 103,
    TokenNameOR_EQUAL = 104,
    TokenNameXOR_EQUAL = 105,
    TokenNameREMAINDER_EQUAL = 106,
    TokenNameLEFT_SHIFT_EQUAL = 107,
    TokenNameRIGHT_SHIFT_EQUAL = 108,
    TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 109,
    TokenNameOR_OR = 38,
    TokenNameAND_AND = 37,
    TokenNamePLUS = 2,
    TokenNameMINUS = 5,
    TokenNameNOT = 69,
    TokenNameREMAINDER = 10,
    TokenNameXOR = 29,
    TokenNameAND = 22,
    TokenNameMULTIPLY = 7,
    TokenNameOR = 36,
    TokenNameTWIDDLE = 72,
    TokenNameDIVIDE = 11,
    TokenNameGREATER = 13,
    TokenNameLESS = 6,
    TokenNameLPAREN = 19,
    TokenNameRPAREN = 25,
    TokenNameLBRACE = 65,
    TokenNameRBRACE = 40,
    TokenNameLBRACKET = 8,
    TokenNameRBRACKET = 68,
    TokenNameSEMICOLON = 26,
    TokenNameQUESTION = 35,
    TokenNameCOLON = 66,
    TokenNameCOMMA = 39,
    TokenNameDOT = 1,
    TokenNameEQUAL = 73,
    TokenNameAT = 41,
    TokenNameELLIPSIS = 110,
    TokenNameARROW = 121,
    TokenNameCOLON_COLON = 9,
    TokenNameBeginLambda = 67,
    TokenNameBeginIntersectionCast = 74,
    TokenNameBeginTypeArguments = 96,
    TokenNameElidedSemicolonAndRightBrace = 75,
    TokenNameAT308 = 24,
    TokenNameAT308DOTDOTDOT = 129,
    TokenNameEOF = 70,
    TokenNameERROR = 132;
}
