/* Copyright (C) 2000, 2001, 2002 by SWsoft
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*  $Id: mod_aspseek.c,v 1.4 2002/03/10 11:46:23 kir Exp $
    Author : Ivan Gudym
*/

/* 
**  mod_aspseek.c -- Apache aspseek module
**  [Autogenerated via ``apxs -n aspseek -g'']
**		Uses parts of mod_example.c from Apache distribution
**		Uses parts of mod_rewite.c from Apache distribution
*/ 

#include "httpd.h"
#include "http_log.h"
#include "http_config.h"
#include "http_protocol.h"
#include "ap_config.h"
#include "aspseek.h"
/*
void log_error(aspseek_site *site, const char *fmt, ...){
va_list args;
char buf[256];
	va_start(args, fmt);
	vsnprintf(buf, 256, fmt, args);
	va_end(args);
	ap_log_error(APLOG_MARK, APLOG_ERR, (server_rec *)site->sitedata, buf);
}
*/

void amod_write(aspseek_request *request, char *buf, int size)
{
	ap_rwrite(buf, size, (request_rec *)request->requestdata);
	ap_reset_timeout((request_rec *)request->requestdata);
}

void amod_set_content_type(aspseek_request *request, char *content_type)
{
	((request_rec *)request->requestdata)->content_type =
		ap_pstrdup(((request_rec *)request->requestdata)->pool,
		content_type);
}

void amod_set_status(aspseek_request *request, int status)
{
	((request_rec *)request->requestdata)->status = status;
}

void amod_set_cach_ctrl(aspseek_request *request, int cache)
{
	((request_rec *)request->requestdata)->no_cache = cache;
}

void amod_add_header(aspseek_request *request, char *key, char *value)
{
	request_rec *r = (request_rec *)request->requestdata;
	ap_table_addn(r->headers_out, ap_pstrdup(r->pool, key), ap_pstrdup(r->pool, value));
}

void amod_send_headers(aspseek_request *request)
{
	ap_send_http_header( (request_rec *)request->requestdata );
}

char *amod_get_request_info(aspseek_request *request, request_info info)
{
	request_rec *r = (request_rec *)request->requestdata;
	char *buf;
	
	switch (info)
	{
		case RI_QUERY_STRING:
			return r->args;
			break;
		case RI_SCRIPT_NAME:
			buf = (char *)ap_palloc(r->pool, strlen(r->hostname)+strlen(r->uri)+8);
			strcpy(buf, "http://"); strcpy(buf+7, r->hostname); strcat(buf, r->uri);
			return buf;
			break;
		case RI_REQUEST_METHOD:
			return (char *)r->method;
			break;
		case RI_REMOTE_ADDR:
			return r->connection->remote_ip;
			break;
		default:
			return NULL;
	}
}

char *amod_get_request_header(aspseek_request *request, char *name)
{
	request_rec *r = (request_rec *)request->requestdata;
	array_header *hdrs_arr;
	table_entry *hdrs;
	int i;

	hdrs_arr = ap_table_elts(r->headers_in);
	hdrs = (table_entry *)hdrs_arr->elts;
	for (i = 0; i < hdrs_arr->nelts; ++i) 
	{
		if (hdrs[i].key == NULL)
		{
			continue;
        	}
		if (strcasecmp(hdrs[i].key, name) == 0)
		{
			return hdrs[i].val;
		}
	}
	return NULL;
}

static aspseek_client client =
{
	amod_write,
	amod_set_content_type,
	amod_set_status,
	amod_set_cach_ctrl,
	amod_add_header,
	amod_send_headers,
	amod_get_request_info,
	amod_get_request_header,
	0
};

module aspseek_module;

/*
static void amod_init(server_rec *s, pool *p){
	aspseek_init();
    ap_log_error(APLOG_MARK, APLOG_NOERRNO|LOG_NOTICE, s, "init was done");
}
*/

void initsite(aspseek_site *site, aspseek_client *cl)
{
	site->client = cl;
	site->template_name = "";
	site->templ = NULL;
	site->sitedata = NULL;
}

static void *amod_site_config(pool *p, char *foo)
{
	aspseek_site *site = (aspseek_site *) ap_pcalloc(p, sizeof(aspseek_site));
	initsite(site, &client);
	return (void *) site;
}

static void *amod_server_config(pool *p, server_rec *s)
{
	amod_site_config(p, NULL);
}

static const char *cmd_template(cmd_parms *cmd, void *mconfig, char *word1){
	if (aspseek_load_template((aspseek_site *)mconfig, word1))
	{
		ap_log_error(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, cmd->server,
			"Can't load template '%s'", word1);
	}
	return NULL;
}

//static void askseek_child_init(server_rec *s, pool *p)
//{
//    aspseekcfg *cfg = 
//	(aspseekcfg *)ap_get_module_config(s->module_config, &aspseek_module);
//    /* As for now template name hardcoded, all staff later */
//    ask_initprocess(&(cfg->data));
//}

/* The aspseek content handler */
static int aspseek_handler(request_rec *r)
{
	aspseek_request *req;
	aspseek_site *cfg;

	if (r->method_number == M_OPTIONS)
	{
		r->allowed |= (1 << M_GET);
		return DECLINED;
	}

	req = (aspseek_request *)ap_palloc(r->pool, sizeof(aspseek_request));
	req->requestdata = r;
	
	/* Get per dir config */
	cfg = (aspseek_site *)ap_get_module_config(r->per_dir_config, &aspseek_module);

	if (!cfg || !cfg->template_name)
	{
		/* If template is not specified, get per (virtual) server config */
		cfg = (aspseek_site *)ap_get_module_config(r->server->module_config, &aspseek_module);
		if (!cfg || !cfg->template_name )
		{
			return HTTP_NOT_IMPLEMENTED; // I like this message, fix me ;)
		}
	}

	if (!cfg->configured)
		return HTTP_SERVICE_UNAVAILABLE; // Fix this too

	req->site = cfg;

	ap_soft_timeout("aspseek search", r);
	
	aspseek_process_query(req);

	ap_rflush(r);

	ap_kill_timeout(r);

    return OK;
}

static const command_rec amod_cmds[] =
{
	{
		"ASPseekTemplate",      /* directive name */
		cmd_template,           /* config action routine */
		NULL,                   /* argument to include in call */
		RSRC_CONF | ACCESS_CONF,/* where available */
		TAKE1,                  /* arguments */
		"ASPseek template file name" /* directive description */
	},
	{NULL}
};


/* Dispatch list of content handlers */
static const handler_rec amod_handlers[] = {
	{ "aspseek", aspseek_handler },
	{ NULL, NULL }
};

/* Dispatch list for API hooks */
module MODULE_VAR_EXPORT aspseek_module = {
	STANDARD_MODULE_STUFF, 
	NULL,                  /* module initializer                  */
	amod_site_config,      /* create per-dir    config structures */
	NULL,                  /* merge  per-dir    config structures */
	amod_server_config,    /* server config creator        */
	NULL,                  /* merge  per-server config structures */
	amod_cmds,             /* table of config file commands       */
	amod_handlers,         /* [#8] MIME-typed-dispatched handlers */
	NULL,                  /* [#1] URI to filename translation    */
	NULL,                  /* [#4] validate user id from request  */
	NULL,                  /* [#5] check if the user is ok _here_ */
	NULL,                  /* [#3] check access by host address   */
	NULL,                  /* [#6] determine MIME type            */
	NULL,                  /* [#7] pre-run fixups                 */
	NULL,                  /* [#9] log a transaction              */
	NULL,                  /* [#2] header parser                  */
	NULL,                  /* process initializer */
	NULL,                  /* child_exit                          */
	NULL                   /* [#0] post read-request              */
#ifdef EAPI
	,NULL,                  /* EAPI: add_module                    */
	NULL,                  /* EAPI: remove_module                 */
	NULL,                  /* EAPI: rewrite_command               */
	NULL                   /* EAPI: new_connection                */
#endif
};
