/*
 * Chan_Misdn -- Channel Driver for Asterisk
 *
 * Interface to mISDN
 *
 * Copyright (C) 2004, Christian Richter
 *
 * Christian Richter <crich@beronet.com>
 *
 * This program is free software, distributed under the terms of
 * the GNU General Public License
 */


/*** INTERNALS ***/


int p_isdn_ntmode=0;
#define DEBG 0
#include "ie.c"


#include "isdn_msg_parser.c"

/** Msg Array **/

isdn_msg_t msgs_g[] = {
  {CC_PROCEEDING,L3,EVENT_PROCEEDING,
   parse_proceeding,build_proceeding,print_proceeding,
   "PROCEEDING"},
  {CC_ALERTING,L3,EVENT_ALERTING,
   parse_alerting,build_alerting,print_alerting,
   "ALERTING"},
  {CC_PROGRESS,L3,EVENT_PROGRESS,
   parse_progress,build_progress,print_progress,
   "PROGRESS"},
  {CC_SETUP,L3,EVENT_SETUP,
   parse_setup,build_setup,print_setup,
   "SETUP"},
  {CC_CONNECT,L3,EVENT_CONNECT,
   parse_connect,build_connect,print_connect,
   "CONNECT"},
  {CC_SETUP_ACKNOWLEDGE,L3,EVENT_SETUP_ACKNOWLEDGE,
   parse_setup_acknowledge,build_setup_acknowledge,print_setup_acknowledge,
   "SETUP_ACKNOWLEDGE"},
  {CC_CONNECT_ACKNOWLEDGE ,L3,EVENT_CONNECT_ACKNOWLEDGE ,
   parse_connect_acknowledge ,build_connect_acknowledge ,print_connect_acknowledge ,
   "CONNECT_ACKNOWLEDGE "},
  {CC_USER_INFORMATION,L3,EVENT_USER_INFORMATION,
   parse_user_information,build_user_information,print_user_information,
   "USER_INFORMATION"},
  {CC_SUSPEND_REJECT,L3,EVENT_SUSPEND_REJECT,
   parse_suspend_reject,build_suspend_reject,print_suspend_reject,
   "SUSPEND_REJECT"},
  {CC_RESUME_REJECT,L3,EVENT_RESUME_REJECT,
   parse_resume_reject,build_resume_reject,print_resume_reject,
   "RESUME_REJECT"},
  {CC_HOLD,L3,EVENT_HOLD,
   parse_hold,build_hold,print_hold,
   "HOLD"},
  {CC_SUSPEND,L3,EVENT_SUSPEND,
   parse_suspend,build_suspend,print_suspend,
   "SUSPEND"},
  {CC_RESUME,L3,EVENT_RESUME,
   parse_resume,build_resume,print_resume,
   "RESUME"},
  {CC_HOLD_ACKNOWLEDGE,L3,EVENT_HOLD_ACKNOWLEDGE,
   parse_hold_acknowledge,build_hold_acknowledge,print_hold_acknowledge,
   "HOLD_ACKNOWLEDGE"},
  {CC_SUSPEND_ACKNOWLEDGE,L3,EVENT_SUSPEND_ACKNOWLEDGE,
   parse_suspend_acknowledge,build_suspend_acknowledge,print_suspend_acknowledge,
   "SUSPEND_ACKNOWLEDGE"},
  {CC_RESUME_ACKNOWLEDGE,L3,EVENT_RESUME_ACKNOWLEDGE,
   parse_resume_acknowledge,build_resume_acknowledge,print_resume_acknowledge,
   "RESUME_ACKNOWLEDGE"},
  {CC_HOLD_REJECT,L3,EVENT_HOLD_REJECT,
   parse_hold_reject,build_hold_reject,print_hold_reject,
   "HOLD_REJECT"},
  {CC_RETRIEVE,L3,EVENT_RETRIEVE,
   parse_retrieve,build_retrieve,print_retrieve,
   "RETRIEVE"},
  {CC_RETRIEVE_ACKNOWLEDGE,L3,EVENT_RETRIEVE_ACKNOWLEDGE,
   parse_retrieve_acknowledge,build_retrieve_acknowledge,print_retrieve_acknowledge,
   "RETRIEVE_ACKNOWLEDGE"},
  {CC_RETRIEVE_REJECT,L3,EVENT_RETRIEVE_REJECT,
   parse_retrieve_reject,build_retrieve_reject,print_retrieve_reject,
   "RETRIEVE_REJECT"},
  {CC_DISCONNECT,L3,EVENT_DISCONNECT,
   parse_disconnect,build_disconnect,print_disconnect,
   "DISCONNECT"},
  {CC_RESTART,L3,EVENT_RESTART,
   parse_restart,build_restart,print_restart,
   "RESTART"},
  {CC_RELEASE,L3,EVENT_RELEASE,
   parse_release,build_release,print_release,
   "RELEASE"},
  {CC_RELEASE_COMPLETE,L3,EVENT_RELEASE_COMPLETE,
   parse_release_complete,build_release_complete,print_release_complete,
   "RELEASE_COMPLETE"},
  {CC_FACILITY,L3,EVENT_FACILITY,
   parse_facility,build_facility,print_facility,
   "FACILITY"},
  {CC_NOTIFY,L3,EVENT_NOTIFY,
   parse_notify,build_notify,print_notify,
   "NOTIFY"},
  {CC_STATUS_ENQUIRY,L3,EVENT_STATUS_ENQUIRY,
   parse_status_enquiry,build_status_enquiry,print_status_enquiry,
   "STATUS_ENQUIRY"},
  {CC_INFORMATION,L3,EVENT_INFORMATION,
   parse_information,build_information,print_information,
   "INFORMATION"},
  {CC_STATUS,L3,EVENT_STATUS,
   parse_status,build_status,print_status,
   "STATUS"},
  {CC_TIMEOUT,L3,EVENT_TIMEOUT,
   parse_timeout,build_timeout,print_timeout,
   "TIMEOUT"},
  {0,0,0,NULL,NULL,NULL,NULL}
};

#define msgs_max (sizeof(msgs_g)/sizeof(isdn_msg_t))

/** INTERFACE FCTS ***/
int isdn_msg_get_index(isdn_msg_t msgs[], msg_t *msg, int nt)
{
  int i;

  if (nt){
#ifdef MISDNUSER_JOLLY
    mISDNuser_head_t *hh = (mISDNuser_head_t*)msg->data;
#else
    mISDN_head_t *hh = (mISDN_head_t*)msg->data;
#endif
    
    for (i=0; i< msgs_max -1; i++) 
      if ( (hh->prim&COMMAND_MASK)==(msgs[i].misdn_msg&COMMAND_MASK)) return i;
    
  } else {
    iframe_t *frm = (iframe_t*)msg->data;
    
    for (i=0; i< msgs_max -1; i++) 
      if ( (frm->prim&COMMAND_MASK)==(msgs[i].misdn_msg&COMMAND_MASK)) return i;
  }

  return -1;
}

int isdn_msg_get_index_by_event(isdn_msg_t msgs[], enum te_event_e event, int nt)
{
  int i;
  for (i=0; i< msgs_max; i++) 
    if ( event ==msgs[i].event) return i;
  
  return -1;
}

enum te_event_e isdn_msg_get_event(isdn_msg_t msgs[], msg_t *msg, int nt)
{
  int i=isdn_msg_get_index(msgs, msg, nt);
  if(i>=0) return msgs[i].event;
  return EVENT_UNKNOWN;
}

char * isdn_msg_get_info(isdn_msg_t msgs[], msg_t *msg, int nt)
{
  int i=isdn_msg_get_index(msgs, msg, nt);
  if(i>=0) return msgs[i].info;
  return NULL;
}


char EVENT_CLEAN_INFO[] = "CLEAN_UP";
char EVENT_DTMF_TONE_INFO[] = "DTMF_TONE";
char EVENT_NEW_L3ID_INFO[] = "NEW_L3ID";

char * isdn_get_info(isdn_msg_t msgs[], enum te_event_e event, int nt)
{
  int i=isdn_msg_get_index_by_event(msgs, event, nt);
  if(i>=0) return msgs[i].info;

  if (event == EVENT_CLEANUP) return EVENT_CLEAN_INFO;
  if (event == EVENT_DTMF_TONE) return EVENT_DTMF_TONE_INFO;
  if (event == EVENT_NEW_L3ID) return EVENT_NEW_L3ID_INFO;
  
  return NULL;
}

int isdn_msg_parse_event(isdn_msg_t msgs[], msg_t *msg, bchannel_te_t *bc, int nt)
{
  int i=isdn_msg_get_index(msgs, msg, nt);
  if(i<0) return -1;

  //chan_misdn_log("Got Idx:%d, parsing ies\n",i);
  msgs[i].msg_parser(msgs, msg, bc, nt);
  return 0;
}

msg_t * isdn_msg_build_event(isdn_msg_t msgs[], bchannel_te_t *bc, enum te_event_e event, int nt)
{
  int i=isdn_msg_get_index_by_event(msgs, event, nt);
  if(i<0) return NULL;
  
  return  msgs[i].msg_builder(msgs, bc, nt);
}

