/*
 * wrapconnection.hxx
 *
 * OpenH323 Wrapper Library
 *
 * Copyright (c) 2002-2005 InAccess Networks
 * Michalis Manousos <manousos@inaccessnetworks.com>
 * Dimitris Economou <decon@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: wrapconnection.hxx,v 1.15.2.2 2005/01/17 18:11:50 manousos Exp $
 *
 */

//////////////////////////////////////////////////////////////////////////

#ifndef	_WRAPCONNECTION_HXX
#define	_WRAPCONNECTION_HXX

/**
 * The wrapper descentant of the H323Connection class
 */
class WrapH323Connection : public H323Connection {

	PCLASSINFO(WrapH323Connection, H323Connection);

	public:
	WrapH323Connection(WrapH323EndPoint &, unsigned);
	~WrapH323Connection();

	void SetLocalCapabilities(H323Capability *caps[]);
	void SetCallerID(char *callerID, char *callerIDname);

	H323Connection::AnswerCallResponse OnAnswerCall(const PString &, 
						const H323SignalPDU &, H323SignalPDU &);
	BOOL OnAlerting(const H323SignalPDU &, const PString &);
	BOOL OnReceivedSignalSetup(const H323SignalPDU &);
	void OnReceivedReleaseComplete(const H323SignalPDU &);
	BOOL OnSendSignalSetup(H323SignalPDU &);
	void OnEstablished();
	BOOL OnClosingLogicalChannel(H323Channel &);
	BOOL OnControlProtocolError(ControlProtocolErrors, const void *);
	BOOL OnReceivedFacility(const H323SignalPDU &);
	BOOL OnReceivedCapabilitySet(const H323Capabilities & remoteCaps,
						const H245_MultiplexCapability * muxCap,
						H245_TerminalCapabilitySetReject & reject);

	int ConnectionCleared;
	int ConnectionFastStart;

	PString sourceAliases;
	PString destAliases;
	PString sourceE164;
	PString destE164;
	PString rdnis;
	PString raddr;
	PString laddr;
	//H323Channel *pChannel;
};

#endif	// _WRAPCONNECTION_HXX
// End of file //////////////////////////////////////////////////////////////
