/***** Autogenerated from runtime.in; changes will be overwritten *****/

#line 1 "runtime.in"
/*****
 * runtime.in
 * Tom Prince 2005/4/15
 *
 * Generate the runtime functions used by the vm::stack machine.
 *
 *****/

/* Autogenerated routines are specified like this (separated by a formfeed):
   type asyname:cname(cparams)
   {
   C code
   }

*/

// Use Void f() instead of void f() to force an explicit Stack argument.


#line 63 "runtime.in"
#include <cfloat>
#include <iostream>
#include <fstream>
#include <time.h>
#include <sys/times.h>
#include <locale.h>
  
#include "angle.h"
#include "pair.h"
#include "triple.h"
#include "transform.h"
#include "path.h"
#include "path3.h"
#include "pen.h"
#include "guide.h"
#include "picture.h"
#include "drawpath.h"
#include "drawpath3.h"
#include "drawsurface.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawlabel.h"
#include "drawverbatim.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawgroup.h"
#include "fileio.h"
#include "genv.h"
#include "builtin.h"
#include "texfile.h"
#include "pipestream.h"
#include "parser.h"
#include "stack.h"
#include "util.h"
#include "locate.h"
#include "mathop.h"
#include "callable.h"
#include "stm.h"
#include "lexical.h"
#include "process.h"
#include "arrayop.h"
#include "predicates.h"
#include "Delaunay.h"
   
#ifdef HAVE_LIBFFTW3
#include "fftw++.h"
#endif
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
#include <readline/readline.h>
#include <readline/history.h>
#endif

#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
  extern "C" {
    void *GC_generate_random_valid_address(void);
    void GC_debug_print_heap_obj_proc(void *);
  }
#endif

using namespace vm;
using namespace camp;
using namespace settings;

namespace run {
using camp::pair;
using vm::array;
using vm::frame;
using vm::stack;
using camp::transform;
using absyntax::runnable;

typedef double real;

#define CURRENTPEN processData().currentpen

typedef array boolarray;
typedef array Intarray;
typedef array Intarray2;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array pairarray2;
typedef array triplearray;
typedef array triplearray2;
typedef array patharray;
typedef array patharray2;
typedef array guidearray;
typedef array transformarray;
typedef array penarray;
typedef array penarray2;
typedef array stringarray;
typedef array stringarray2;
  
typedef callable callableBp;
typedef callable callableReal;
typedef callable callableTransform;
}

using vm::array;
using types::function;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

using types::boolArray;
using types::IntArray;
using types::IntArray2;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::pairArray2;
using types::tripleArray;
using types::tripleArray2;
using types::pathArray;
using types::pathArray2;
using types::guideArray;
using types::transformArray;
using types::penArray;
using types::penArray2;
using types::stringArray;
using types::stringArray2;
using types::formal;

function *voidFunction()
{
  return new function(primVoid());
}

function *breakpointFunction()
{
  return new function(primString(),primString(),primInt(),primInt(),
                      primCode());
}

function *realRealFunction()
{
  return new function(primReal(),primReal());
}

function *transformFunction()
{
  return new function(primTransform());
}

function *realTripleFunction()
{
  return new function(primReal(),primTriple());
}

const size_t camp::ColorComponents[]={0,0,1,3,4,0};

namespace vm {
}

namespace run {
  
const char *invalidargument="invalid argument";
const char *arrayempty="cannot take min or max of empty array";

// Return the factorial of a non-negative integer using a lookup table.
Int factorial(Int n)
{
  static Int *table;
  static Int size=0;
  if(size == 0) {
    Int f=1;
    size=2;
    while(f <= Int_MAX/size)
      f *= (size++);
    table=new Int[size];
    table[0]=f=1;
    for(Int i=1; i < size; ++i) {
      f *= i;
      table[i]=f;
    }
  }
  if(n >= size) integeroverflow(0);
  return table[n];
}

static inline Int Round(double x) 
{
  return Int(x+((x >= 0) ? 0.5 : -0.5));
}

inline Int sgn(double x) 
{
  return (x > 0.0 ? 1 : (x < 0.0 ? -1 : 0));
}

void outOfBounds(const char *op, size_t len, Int n)
{
  ostringstream buf;
  buf << op << " array of length " << len << " with out-of-bounds index " << n;
  error(buf);
}

inline item& arrayRead(array *a, Int n)  
{
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else if(n < 0 || n >= (Int) len) outOfBounds("reading",len,n);
  return (*a)[(unsigned) n];
}

// Helper function to create deep arrays.
static array* deepArray(Int depth, Int *dims)
{
  assert(depth > 0);
  
  if (depth == 1) {
    return new array(dims[0]);
  } else {
    Int length = dims[0];
    depth--; dims++;

    array *a = new array(length);

    for (Int index = 0; index < length; index++) {
      (*a)[index] = deepArray(depth, dims);
    }
    return a;
  }
}
  
array *nop(array *a) 
{
  return a;
}
  
array *Identity(Int n)
{
  size_t N=(size_t) n;
  array *c=new array(N);
  for(size_t i=0; i < N; ++i) {
    array *ci=new array(N);
    (*c)[i]=ci;
    for(size_t j=0; j < N; ++j)
      (*ci)[j]=0.0;
    (*ci)[i]=1.0;
  }
  return c;
}

array *copyArray(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) 
    (*c)[i]=(*a)[i];
  return c;
}

inline size_t checkdimension(array *a, size_t dim)
{
  size_t size=checkArray(a);
  if(dim && size != dim) {
    ostringstream buf;
    buf << "array of length " << dim << " expected" << endl;
    error(buf);
  }
  return size;
}

double *copyArrayC(array *a, size_t dim=0)
{
  size_t size=checkdimension(a,dim);
  double *c=new double[size];
  for(size_t i=0; i < size; i++) 
    c[i]=read<double>(a,i);
  return c;
}

triple *copyTripleArrayC(array *a, size_t dim=0)
{
  size_t size=checkdimension(a,dim);
  triple *c=new triple[size];
  for(size_t i=0; i < size; i++) 
    c[i]=read<triple>(a,i);
  return c;
}

array *copyArray2(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) 
      (*ci)[j]=(*ai)[j];
  }
  return c;
}

array *copyArray3(array *a)
{
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    array *ci=new array(aisize);
    (*c)[i]=ci;
    for(size_t j=0; j < aisize; j++) {
      array *aij=read<array*>(ai,j);
      size_t aijsize=checkArray(aij);
      array *cij=new array(aijsize);
      (*ci)[j]=cij;
      for(size_t k=0; k < aijsize; k++) 
        (*cij)[k]=(*aij)[k];
    }
  }
  return c;
}

double *copyArray2C(array *a, bool square=true, size_t dim2=0)
{
  size_t n=checkArray(a);
  size_t m=(square || n == 0) ? n : checkArray(read<array*>(a,0));
  if(n > 0 && dim2 && m != dim2) {
    ostringstream buf;
    buf << "second matrix dimension must be " << dim2 << endl;
    error(buf);
  }
  
  double *c=new double[n*m];
  for(size_t i=0; i < n; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    if(aisize == m) {
      double *ci=c+i*m;
      for(size_t j=0; j < m; j++) 
        ci[j]=read<double>(ai,j);
    } else
      error(square ? "matrix must be square" : "matrix must be rectangular");
  }
  return c;
}

triple *copyTripleArray2C(array *a, bool square=true, size_t dim2=0)
{
  size_t n=checkArray(a);
  size_t m=(square || n == 0) ? n : checkArray(read<array*>(a,0));
  if(n > 0 && dim2 && m != dim2) {
    ostringstream buf;
    buf << "second matrix dimension must be " << dim2 << endl;
    error(buf);
  }
  
  triple *c=new triple[n*m];
  for(size_t i=0; i < n; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    if(aisize == m) {
      triple *ci=c+i*m;
      for(size_t j=0; j < m; j++) 
        ci[j]=read<triple>(ai,j);
    } else
      error(square ? "matrix must be square" : "matrix must be rectangular");
  }
  return c;
}

double *copyTripleArray2Components(array *a, bool square=true, size_t dim2=0)
{
  size_t n=checkArray(a);
  size_t m=(square || n == 0) ? n : checkArray(read<array*>(a,0));
  if(n > 0 && dim2 && m != dim2) {
    ostringstream buf;
    buf << "second matrix dimension must be " << dim2 << endl;
    error(buf);
  }
  
  size_t nm=n*m;
  double *cx=new double[3*nm];
  double *cy=cx+nm;
  double *cz=cx+2*nm;
  for(size_t i=0; i < n; i++) {
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    if(aisize == m) {
      double *xi=cx+i*m;
      double *yi=cy+i*m;
      double *zi=cz+i*m;
      for(size_t j=0; j < m; j++) {
        triple v=read<triple>(ai,j);
        xi[j]=v.getx();
        yi[j]=v.gety();
        zi[j]=v.getz();
      }
    } else
      error(square ? "matrix must be square" : "matrix must be rectangular");
  }
  return cx;
}

double norm(double *a, size_t n) 
{
  if(n == 0) return 0.0;
  double M=fabs(a[0]);
  for(size_t i=1; i < n; ++i)
    M=::max(M,fabs(a[i]));
  return M;
}

double norm(triple *a, size_t n) 
{
  if(n == 0) return 0.0;
  double M=a[0].abs2();
  for(size_t i=1; i < n; ++i)
    M=::max(M,a[i].abs2());
  return sqrt(M);
}

static const char *incommensurate="Incommensurate matrices";
static const char *singular="Singular matrix";
static size_t *pivot,*Row,*Col;

triple operator *(const array& t, const triple& v)
{
  size_t n=checkArray(&t);
  if(n != 4) error(incommensurate);
  array *t0=read<array*>(t,0);
  array *t1=read<array*>(t,1);
  array *t2=read<array*>(t,2);
  array *t3=read<array*>(t,3);
  
  if(checkArray(t0) != 4 || checkArray(t1) != 4 || 
     checkArray(t2) != 4 || checkArray(t3) != 4)
    error(incommensurate);

  double x=v.getx();
  double y=v.gety();
  double z=v.getz();
  
  double f=read<real>(t3,0)*x+read<real>(t3,1)*y+read<real>(t3,2)*z+
    read<real>(t3,3);
  if(f == 0.0) run::dividebyzero();
  f=1.0/f;
  
  return triple((read<real>(t0,0)*x+read<real>(t0,1)*y+read<real>(t0,2)*z+
                 read<real>(t0,3))*f,
                (read<real>(t1,0)*x+read<real>(t1,1)*y+read<real>(t1,2)*z+
                 read<real>(t1,3))*f,
                (read<real>(t2,0)*x+read<real>(t2,1)*y+read<real>(t2,2)*z+
                 read<real>(t2,3))*f);
}

triple multshiftless(const array& t, const triple& v)
{
  size_t n=checkArray(&t);
  if(n != 4) error(incommensurate);
  array *t0=read<array*>(t,0);
  array *t1=read<array*>(t,1);
  array *t2=read<array*>(t,2);
  array *t3=read<array*>(t,3);
  
  if(checkArray(t0) != 4 || checkArray(t1) != 4 || 
     checkArray(t2) != 4 || checkArray(t3) != 4)
    error(incommensurate);

  double x=v.getx();
  double y=v.gety();
  double z=v.getz();
  
  double f=read<real>(t3,0)*x+read<real>(t3,1)*y+read<real>(t3,2)*z+
    read<real>(t3,3);
  if(f == 0.0) run::dividebyzero();
  f=1.0/f;
  
  return triple((read<real>(t0,0)*x+read<real>(t0,1)*y+read<real>(t0,2)*z)*f,
                (read<real>(t1,0)*x+read<real>(t1,1)*y+read<real>(t1,2)*z)*f,
                (read<real>(t2,0)*x+read<real>(t2,1)*y+read<real>(t2,2)*z)*f);
}

static inline void inverseAllocate(size_t n)
{
  pivot=new size_t[n];
  Row=new size_t[n];
  Col=new size_t[n];
}

static inline void inverseDeallocate()
{
  delete[] pivot;
  delete[] Row;
  delete[] Col;
}

void writestring(stack *s)
{
  callable *suffix=pop<callable *>(s,NULL);
  string S=pop<string>(s);
  vm::item it=pop(s);
  bool defaultfile=isdefault(it);
  camp::file *f=defaultfile ? &camp::Stdout : vm::get<camp::file*>(it);
  if(!f->isOpen()) return;
  if(S != "") f->write(S);
  if(f->text()) {
    if(suffix) {
      s->push(f);
      suffix->call(s);
    } else if(defaultfile) f->writeline();
  }
}

void checkSquare(array *a) 
{
  size_t n=checkArray(a);
  for(size_t i=0; i < n; i++)
    if(checkArray(read<array*>(a,i)) != n)
      error("matrix a must be square");
}

// Crout's algorithm for computing the LU decomposition of a square matrix.
// cf. routine ludcmp (Press et al.,  Numerical Recipes, 1991).
Int LUdecompose(double *a, size_t n, size_t* index, bool warn=true)
{
  double *vv=new double[n];
  Int swap=1;
  for(size_t i=0; i < n; ++i) {
    double big=0.0;
    double *ai=a+i*n;
    for(size_t j=0; j < n; ++j) {
      double temp=fabs(ai[j]);
      if(temp > big) big=temp;
    }
    if(big == 0.0) {
      delete[] vv;
      if(warn) error(singular);
      else return 0;
    }
    vv[i]=1.0/big;
  }
  for(size_t j=0; j < n; ++j) {
    for(size_t i=0; i < j; ++i) {
      double *ai=a+i*n;
      double sum=ai[j];
      for(size_t k=0; k < i; ++k) {
        sum -= ai[k]*a[k*n+j];
      }
      ai[j]=sum;
    }
    double big=0.0;
    size_t imax=j;
    for(size_t i=j; i < n; ++i) {
      double *ai=a+i*n;
      double sum=ai[j];
      for(size_t k=0; k < j; ++k)
        sum -= ai[k]*a[k*n+j];
      ai[j]=sum;
      double temp=vv[i]*fabs(sum);
      if(temp >= big) {
        big=temp;
        imax=i;
      }
    }
    double *aj=a+j*n;
    double *aimax=a+imax*n;
    if(j != imax) {
      for(size_t k=0; k < n; ++k) {
        double temp=aimax[k];
        aimax[k]=aj[k];
        aj[k]=temp;
      }
      swap *= -1;
      vv[imax]=vv[j];
    }
    if(index) 
      index[j]=imax;
    if(j != n) {
      double denom=aj[j];
      if(denom == 0.0) {
        delete[] vv;
        if(warn) error(singular);
        else return 0;
      }
      for(size_t i=j+1; i < n; ++i)
        a[i*n+j] /= denom;
    }
  }
  delete[] vv;
  return swap;
}

void dividebyzero(size_t i)
{
  ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Divide by zero";
  error(buf);
}
  
void integeroverflow(size_t i)
{
  ostringstream buf;
  if(i > 0) buf << "array element " << i << ": ";
  buf << "Integer overflow";
  error(buf);
}
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
struct historyState {
  bool store;
  HISTORY_STATE state;
};
  
typedef mem::map<CONST string, historyState> historyMap_t;
historyMap_t historyMap;
static HISTORY_STATE history_save;

// Store a deep copy of the current readline history in dest.
void store_history(HISTORY_STATE *dest)
{
  HISTORY_STATE *src=history_get_history_state();
  if(src) {
    *dest=*src;
    for(Int i=0; i < src->length; ++i)
      dest->entries[i]=src->entries[i];
    free(src);
  }
}

stringarray* get_history(Int n) 
{
  int N=intcast(n);
  if(N <= 0) N=history_length;
  else N=Min(N,history_length);
  array *a=new array((size_t) N);
  int offset=history_length-N+1;
  for(int i=0; i < N; ++i) {
    HIST_ENTRY *last=history_get(offset+i);
    string s=last ? last->line : "";
    (*a)[i]=s;
  }     
  return a;
}

string historyfilename(const string &name) 
{
  return historyname+"_"+name;
}
#endif

#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
int readline_startup_hook()
{
#ifdef __CYGWIN__
  rl_set_key("\\M-[3~",rl_delete,rl_get_keymap());
  rl_set_key("\\M-[2~",rl_overwrite_mode,rl_get_keymap());
#endif    
  return 0;
}

void init_readline(bool tabcompletion=true) 
{
  static bool first=true;
  if(first) {
    first=false;
#ifdef __CYGWIN__
    rl_startup_hook=readline_startup_hook;
#endif    
  }
  rl_bind_key('\t',tabcompletion ? rl_complete : rl_insert);
}
#endif

void cleanup()
{
  processDataStruct &pd=processData();
  pd.atExitFunction=NULL;
  pd.atUpdateFunction=NULL;
  pd.atBreakpointFunction=NULL;
  
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  store_history(&history_save);
  int nlines=intcast(getSetting<Int>("historylines"));
  for(historyMap_t::iterator h=historyMap.begin(); h != historyMap.end(); 
      ++h) {
    history_set_history_state(&h->second.state);
    stifle_history(nlines);
    if(h->second.store) write_history(historyfilename(h->first).c_str());
  }
  history_set_history_state(&history_save);
#endif
}

void purge(Int divisor=0)
{
#ifdef USEGC
  if(divisor > 0) GC_set_free_space_divisor((GC_word) divisor);
  GC_gcollect();
#endif
}

void updateFunction(stack *Stack)
{
  callable *atUpdateFunction=processData().atUpdateFunction;
  if(atUpdateFunction && !nullfunc::instance()->compare(atUpdateFunction))
    atUpdateFunction->call(Stack);
}

void exitFunction(stack *Stack)
{
  callable *atExitFunction=processData().atExitFunction;
  if(atExitFunction && !nullfunc::instance()->compare(atExitFunction))
    atExitFunction->call(Stack);
  cleanup();
}

default_t def;
string emptystring;
array *emptyarray=new array(0);
string commentchar="#";
pair zero;

void breakpoint(stack *Stack, runnable *r)
{
  callable *atBreakpointFunction=processData().atBreakpointFunction;
  if(atBreakpointFunction &&
     !nullfunc::instance()->compare(atBreakpointFunction)) {
    position curPos=getPos();
    Stack->push<string>(curPos.filename());
    Stack->push<Int>((Int) curPos.Line());
    Stack->push<Int>((Int) curPos.Column());
    Stack->push(r ? r : item(def));
    atBreakpointFunction->call(Stack); // returns a string
  } else Stack->push<string>("");
}

}

namespace types {
extern const char *names[];
}

void checkformat(const char *ptr, bool intformat) 
{
  while(*ptr != '\0') {
    if(*ptr != '%') /* While we have regular characters, print them.  */
      ptr++;
    else { /* We've got a format specifier. */
      ptr++;
      
      while(*ptr && strchr ("-+ #0'I", *ptr)) /* Move past flags.  */
        *ptr++;

      if(*ptr == '*')
        ptr++;
      else while(isdigit(*ptr)) /* Handle explicit numeric value.  */
             ptr++;
          
      if(*ptr == '.') {
        *ptr++; /* Go past the period.  */
        if(*ptr == '*') {
          ptr++;
        } else
          while(isdigit(*ptr)) /* Handle explicit numeric value.  */
            *ptr++;
      }
      while(*ptr && strchr ("hlL", *ptr))
        *ptr++;
          
      if(*ptr == '%') ++ptr;
      else if(*ptr != '\0') {
        if(intformat) {
          switch(*ptr) {
            case 'd':
            case 'i':
            case 'o':
            case 'u':
            case 'x':
            case 'X':
            case 'c':
              break;
            default:
              ostringstream buf;
              buf << "Invalid format '" << *ptr << "' for type " 
                  << types::names[types::ty_Int];
              error(buf);
              break;
          }
        } else {
          switch(*ptr) {
            case 'f':
            case 'F':
            case 'e':
            case 'E':
            case 'g':
            case 'G':
              break;
            default:
              ostringstream buf;
              buf << "Invalid format '" << *ptr << "' for type "
                  << types::names[types::ty_real];
              error(buf);
              break;
          }
        }
      }
    } /* End of else statement */
  }
}
  
// Return an angle in the interval [0,360).
inline double principalBranch(double deg)
{
  if(deg < 0) deg += 360; 
  return deg;
}

static string defaulttransparency=string("Compatible");

static const string defaulttimeformat=string("%a %b %d %T %Z %Y");
#ifdef HAVE_STRFTIME
static const size_t nTime=256;
static char Time[nTime];
#endif  

void clear(string file, Int line, bool warn=false) 
{
  bpinfo bp(file,line);
  for(mem::list<bpinfo>::iterator p=bplist.begin(); p != bplist.end(); ++p) {
    if(*p == bp) {
      cout << "cleared breakpoint at " << file << ": " << line << endl;
      bplist.remove(bp);
      return;
    }
  }
  if(warn)
    cout << "No such breakpoint at "  << file << ": " << line << endl;
}

Int windingnumber(array *p, camp::pair z)
{
  size_t size=checkArray(p);
  Int count=0;
  for(size_t i=0; i < size; i++) 
    count += read<path *>(p,i)->windingnumber(z);
  return count;
}

string convertname(string name, const string& format, bool check=true)
{
  if(name.empty())
    return buildname(outname(),format,"");
  else
    if(check) checkLocal(name);
  return format.empty() ? name : format+":"+name;
}

callable *Func;
stack *FuncStack;
double wrapFunction(double x)
{
  FuncStack->push(x);
  Func->call(FuncStack);
  return pop<double>(FuncStack);
}

callable *compareFunc;
bool compareFunction(const vm::item& i, const vm::item& j)
{
  FuncStack->push(i);
  FuncStack->push(j);
  compareFunc->call(FuncStack);
  return pop<bool>(FuncStack);
}

void unused(void *)
{
}

static const double twelvepercent=0.12;
static const double tenpercent=0.1;

pair readpair(stringstream& s, double hscale=1.0, double vscale=1.0)
{
  double x,y;
  s >> y;
  s >> x;
  return pair(hscale*x,vscale*y);
}

// Ignore unclosed begingroups but not spurious endgroups.
const char *nobegin="endgroup without matching begingroup";
  
// Return the component of vector v perpendicular to a unit vector u.
inline triple perp(triple v, triple u)
{
  return v-dot(v,u)*u;
}

string ASYx="/ASYx {( ) print ASYX sub 12 string cvs print} bind def";
string ASYy="/ASYy {( ) print ASYY sub 12 string cvs print} bind def";
string pathforall="{(M) print ASYy ASYx} {(L) print ASYy ASYx} {(C) print ASYy ASYx ASYy ASYx ASYy ASYx} {(c) print} pathforall";
string currentpoint="print currentpoint ASYy ASYx ";
string ASYinit="/ASYX currentpoint pop def /ASYY currentpoint exch pop def ";
string ASY1="ASY1 {"+ASYinit+"/ASY1 false def} if ";

void showpath(std::ofstream& ps) 
{
  ps << ASYx << newl
     << ASYy << newl
     << "/ASY1 true def" << newl
     << "/fill {" << ASY1
     << pathforall << " (M) " << currentpoint
     << "currentpoint newpath moveto } bind def" << newl
     << "/stroke {" << ASY1 << "strokepath "
     << pathforall << " (M) " << currentpoint
     << "currentpoint newpath moveto } bind def" << endl;
}

array *readpath(const string& psname, bool keep,
                double hscale=1.0, double vscale=1.0)
{
  array *P=new array(0);
  ostringstream pipe;
  pipe << "'" << getSetting<string>("gs")
       << "' -q -dNOPAUSE -dBATCH";
  if(safe) pipe << " -dSAFER";
#ifdef __CYGWIN__
  const string null="NUL";
#else
  const string null="/dev/null";
#endif
  pipe << " -sDEVICE=epswrite -sOutputFile="+null+" '" << psname << "'";
  iopipestream gs(pipe.str().c_str(),"gs","Ghostscript");
  stringstream buf;
  while(true) {
    string out;
    gs >> out;
    if(out.empty() && !gs.running()) break;
    buf << out;
  }
  if(verbose > 2) cout << endl;
    
  mem::vector<solvedKnot> nodes;
  solvedKnot node;
  bool cyclic=false;
  bool active=false;
  
  while(!buf.eof()) {
    char c;
    buf >> c;
    switch(c) {
      case 'M':
      {
        if(active) {
          if(cyclic) {
            if(node.point == nodes[0].point)
              nodes[0].pre=node.pre;
            else {
              pair delta=(nodes[0].point-node.point)*third;
              node.post=node.point+delta;
              nodes[0].pre=nodes[0].point-delta;
              node.straight=true;
              nodes.push_back(node);
            }
          } else {
            node.post=node.point;
            node.straight=false;
            nodes.push_back(node);
          }
          P->push(path(nodes,nodes.size(),cyclic));
          nodes.clear();
        }
        active=false;
        cyclic=false;
        node.pre=node.point=readpair(buf,hscale,vscale);
        node.straight=false;
        break;
      }
      case 'L':
      {
        pair point=readpair(buf,hscale,vscale);
        pair delta=(point-node.point)*third;
        node.post=node.point+delta;
        node.straight=true;
        nodes.push_back(node);
        active=true;
        node.pre=point-delta;
        node.point=point;
        break;
      }
      case 'C':
      {
        pair point=readpair(buf,hscale,vscale);
        pair pre=readpair(buf,hscale,vscale);
        node.post=readpair(buf,hscale,vscale);
        node.straight=false;
        nodes.push_back(node);
        active=true;
        node.pre=pre;
        node.point=point;
        break;
      }
      case 'c':
      {
        cyclic=true;
        break;
      }
    }
  }
  
  if(!keep)
    unlink(psname.c_str());
  return P;
}

pair sin(pair z)
{
  return pair(sin(z.getx())*cosh(z.gety()),cos(z.getx())*sinh(z.gety())); 
}

pair exp(pair z) 
{ 
  return exp(z.getx())*expi(z.gety());
}

pair gamma(pair z)
{
  static double p[]={0.99999999999980993,676.5203681218851,-1259.1392167224028,
                     771.32342877765313,-176.61502916214059,12.507343278686905,
                     -0.13857109526572012,9.9843695780195716e-6,
                     1.5056327351493116e-7};
  static int n=sizeof(p)/sizeof(double);
  static double root2pi=sqrt(2*PI);
  if(z.getx() < 0.5)
    return PI/(sin(PI*z)*gamma(1.0-z));
  z -= 1.0;
  pair x=p[0];
  for(int i=1; i < n; ++i)
    x += p[i]/(z+i);
  pair t=n-1.5+z;
  return root2pi*pow(t,z+0.5)*exp(-t)*x;
}

void cannotread(const string& s) 
{
  ostringstream buf;
  buf << "Cannot read from " << s << endl;
  error(buf);
}

void cannotwrite(const string& s) 
{
  ostringstream buf;
  buf << "Cannot write to " << s << endl;
  error(buf);
}

// Autogenerated routines:



namespace run {

// Initializers
#line 1129 "runtime.in"
void IntZero(stack *Stack)
{
#line 1130 "runtime.in"
  {Stack->push<Int>(0); return;}
}

#line 1135 "runtime.in"
void realZero(stack *Stack)
{
#line 1136 "runtime.in"
  {Stack->push<real>(0.0); return;}
}

#line 1140 "runtime.in"
void boolFalse(stack *Stack)
{
#line 1141 "runtime.in"
  {Stack->push<bool>(false); return;}
}

#line 1145 "runtime.in"
void pushNullArray(stack *Stack)
{
#line 1146 "runtime.in"
  {Stack->push<array*>(0); return;}
}

#line 1150 "runtime.in"
void pushNullRecord(stack *Stack)
{
#line 1151 "runtime.in"
  {Stack->push<frame*>(0); return;}
}

#line 1155 "runtime.in"
void pushNullFunction(stack *Stack)
{
#line 1156 "runtime.in"
  {Stack->push(nullfunc::instance()); return;}
}


// Default operations

// Put the default value token on the stack (in place of an argument when
// making a function call).
#line 1165 "runtime.in"
void pushDefault(stack *Stack)
{
#line 1166 "runtime.in"
  {Stack->push(def); return;}
}


// Test if the value on the stack is the default value token.
#line 1172 "runtime.in"
void isDefault(stack *Stack)
{
  item i=vm::pop(Stack);
#line 1173 "runtime.in"
  {Stack->push<bool>(isdefault(i)); return;}
}


// Logical operations
#line 1179 "runtime.in"
// bool !(bool b);
void gen8(stack *Stack)
{
  bool b=vm::pop<bool>(Stack);
#line 1180 "runtime.in"
  {Stack->push<bool>(!b); return;}
}

#line 1185 "runtime.in"
void boolMemEq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 1186 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1190 "runtime.in"
void boolMemNeq(stack *Stack)
{
  frame * b=vm::pop<frame *>(Stack);
  frame * a=vm::pop<frame *>(Stack);
#line 1191 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 1195 "runtime.in"
void boolFuncEq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 1196 "runtime.in"
  {Stack->push<bool>(a->compare(b)); return;}
}

#line 1200 "runtime.in"
void boolFuncNeq(stack *Stack)
{
  callable * b=vm::pop<callable *>(Stack);
  callable * a=vm::pop<callable *>(Stack);
#line 1201 "runtime.in"
  {Stack->push<bool>(!(a->compare(b))); return;}
}


// Bit operations
#line 1207 "runtime.in"
// Int AND(Int a, Int b);
void gen13(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 1208 "runtime.in"
  {Stack->push<Int>(a & b); return;}
}

#line 1213 "runtime.in"
// Int OR(Int a, Int b);
void gen14(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 1214 "runtime.in"
  {Stack->push<Int>(a | b); return;}
}

#line 1218 "runtime.in"
// Int XOR(Int a, Int b);
void gen15(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
#line 1219 "runtime.in"
  {Stack->push<Int>(a ^ b); return;}
}

#line 1223 "runtime.in"
// Int NOT(Int a);
void gen16(stack *Stack)
{
  Int a=vm::pop<Int>(Stack);
#line 1224 "runtime.in"
  {Stack->push<Int>(~a); return;}
}


// Casts
#line 1230 "runtime.in"
void pairToGuide(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 1231 "runtime.in"
  {Stack->push<guide*>(new pairguide(z)); return;}
}

#line 1236 "runtime.in"
void pathToGuide(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 1237 "runtime.in"
  {Stack->push<guide*>(new pathguide(p)); return;}
}

#line 1241 "runtime.in"
void guideToPath(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 1242 "runtime.in"
  {Stack->push<path>(g->solve()); return;}
}


// Picture operations
#line 1248 "runtime.in"
void newPicture(stack *Stack)
{
#line 1249 "runtime.in"
  {Stack->push<picture*>(new picture()); return;}
}

#line 1254 "runtime.in"
// bool empty(picture *f);
void gen21(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1255 "runtime.in"
  {Stack->push<bool>(f->null()); return;}
}

#line 1259 "runtime.in"
// void erase(picture *f);
void gen22(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1260 "runtime.in"
  f->nodes.clear();
}

#line 1264 "runtime.in"
// pair min(picture *f);
void gen23(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1265 "runtime.in"
  {Stack->push<pair>(f->bounds().Min()); return;}
}

#line 1269 "runtime.in"
// pair max(picture *f);
void gen24(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1270 "runtime.in"
  {Stack->push<pair>(f->bounds().Max()); return;}
}

#line 1274 "runtime.in"
// void label(picture *f, string *s, string *size, transform t, pair position,           pair align, pen p);
void gen25(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  pair align=vm::pop<pair>(Stack);
  pair position=vm::pop<pair>(Stack);
  transform t=vm::pop<transform>(Stack);
  string * size=vm::pop<string *>(Stack);
  string * s=vm::pop<string *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1276 "runtime.in"
  f->append(new drawLabel(*s,*size,t,position,align,p));
}

#line 1280 "runtime.in"
// bool labels(picture *f);
void gen26(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1281 "runtime.in"
  {Stack->push<bool>(f->havelabels()); return;}
}

#line 1285 "runtime.in"
// realarray* texsize(string *s, pen p=CURRENTPEN);
void gen27(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  string * s=vm::pop<string *>(Stack);
#line 1286 "runtime.in"
  texinit();
  processDataStruct &pd=processData();
  
  string texengine=getSetting<string>("tex");
  const char **abort=texabort(texengine);
  setpen(pd.tex,texengine,p);
  
  double width,height,depth;
  if(!texbounds(width,height,depth,pd.tex,*s,abort,false,true))
     {Stack->push<realarray*>(new array(0)); return;}
  
  array *t=new array(3);
  (*t)[0]=width;
  (*t)[1]=height;
  (*t)[2]=depth;
  {Stack->push<realarray*>(t); return;}
}

#line 1305 "runtime.in"
// patharray* _texpath(string *s, pen p=CURRENTPEN);
void gen28(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  string * s=vm::pop<string *>(Stack);
#line 1306 "runtime.in"
  array *P=new array(0);
  if(s->empty()) {Stack->push<patharray*>(P); return;}
  
  string prefix=outname();
  spaceToUnderscore(prefix);
  string psname=auxname(prefix,"ps");
  string texname=auxname(prefix,"tex");
  string dviname=auxname(prefix,"dvi");
  bbox b;
  bool pdf=settings::pdf(getSetting<string>("tex"));
  texfile tex(texname,b,true);
  tex.miniprologue();
  tex.setfont(p);
  
  if(!pdf) {
    tex.verbatimline("\\special{ps:");
    tex.verbatimline(ASYx);
    tex.verbatimline(ASYy);
    tex.verbatimline("/ASY1 true def");
    tex.verbatimline("/v {neg exch 4 copy 4 2 roll 2 copy 6 2 roll 2 copy (M) print ASYy ASYx (L) print ASYy add ASYx (L) print add ASYy add ASYx (L) print add ASYy ASYx (c) print} bind def");
    tex.verbatimline("/show {"+ASY1+
                     "currentpoint newpath moveto false charpath "+
                     pathforall+"} bind def}");
  }
  tex.verbatimline(*s+"%");
  tex.epilogue(true);
  tex.close();
  
  // TODO: Put in common subproutine (cf. texprocess).
  string aux=auxname(prefix,"aux");
  unlink(aux.c_str());
  string program=texprogram();
  ostringstream cmd;
  bool context=settings::context(getSetting<string>("tex"));
  cmd << program << (context ? " --nonstopmode '" : 
                     " \\nonstopmode\\input '") << texname << "'";
  bool quiet=verbose <= 2;
  int status=System(cmd,quiet ? 1 : 0,true,"texpath",texpathmessage());
  if(!status && getSetting<bool>("twice"))
    status=System(cmd,quiet ? 1 : 0,true,"texpath",texpathmessage());
  if(status) {
    if(quiet) {
      ostringstream cmd;
      cmd << program << (context ? " --scrollmode '" : 
                         " \\scrollmode\\input '") << texname << "'";
      System(cmd,0);
    }
  }
    
  string pdfname;
  if(!status) {
    if(pdf) {
      pdfname=auxname(prefix,"pdf");
      std::ofstream ps(psname.c_str());
      if(!ps) cannotwrite(psname);
      
      showpath(ps);

      ostringstream cmd;
      cmd << "'" << getSetting<string>("gs")
          << "' -q -dNOCACHE -dNOPAUSE -dBATCH";
      if(safe) cmd << " -dSAFER";
      cmd << " -sDEVICE=epswrite -sOutputFile=- '" << pdfname << "'";
      iopipestream gs(cmd.str().c_str(),"gs","Ghostscript");
      
      gs.block(false);
      while(true) {
        string line;
        gs >> line;
        if(line.empty() && !gs.running()) break;
        ps << line;
      }
      ps.close();
    } else {
      ostringstream cmd;
      cmd << "'" << getSetting<string>("dvips") << "' -R -Pdownload35 -D600 "
          << getSetting<string>("dvipsOptions");
      if(verbose <= 2) cmd << " -q";
      cmd  << " -o '" << psname << "' '" << dviname << "'";
      status=System(cmd,0,true,"dvips");
    }
  }

  if(status != 0)
    error("texpath failed");
    
  bool keep=getSetting<bool>("keep");
  if(!keep) { // Delete temporary files.
    unlink(texname.c_str());
    if(!getSetting<bool>("keepaux"))
      unlink(aux.c_str());
    unlink(auxname(prefix,"log").c_str());
    if(pdf)
      unlink(pdfname.c_str());
    else
      unlink(dviname.c_str());
    if(context) {
      unlink(auxname(prefix,"top").c_str());
      unlink(auxname(prefix,"tua").c_str());
      unlink(auxname(prefix,"tui").c_str());
    }
  }
  {Stack->push<patharray*>(readpath(psname,keep,twelvepercent,
                  pdf ? twelvepercent : -twelvepercent)); return;}
}

#line 1413 "runtime.in"
// patharray* textpath(string *s, pen p=CURRENTPEN);
void gen29(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  string * s=vm::pop<string *>(Stack);
#line 1414 "runtime.in"
  array *P=new array(0);
  if(s->empty()) {Stack->push<patharray*>(P); return;}
  
  string prefix=outname();
  spaceToUnderscore(prefix);
  string outputname=auxname(prefix,getSetting<string>("textoutformat"));

  string textname=auxname(prefix,getSetting<string>("textextension"));
  std::ofstream text(textname.c_str());
  
  if(!text) cannotwrite(textname);

  text << getSetting<string>("textprologue") << newl
       << p.Font() << newl
       << *s << newl
       << getSetting<string>("textepilogue") << endl;
  text.close();
  
  string psname=auxname(prefix,"ps");
  std::ofstream ps(psname.c_str());
  if(!ps) cannotwrite(psname);

  showpath(ps);
  
  ostringstream pipe;
  pipe << getSetting<string>("textcommand") << " '" << textname << "'";
  iopipestream typesetter(pipe.str().c_str());
  
  ostringstream pipe2;
  pipe2 << "'" << getSetting<string>("gs")
       << "' -q -dNOCACHE -dNOPAUSE -dBATCH";
  if(safe) pipe2 << " -dSAFER";
  pipe2 << " -sDEVICE=epswrite -sOutputFile=- -";
  iopipestream gs(pipe2.str().c_str(),"gs","Ghostscript");
  gs.block(false);

  // TODO: Simplify by connecting the pipes directly.
  while(true) {
    string out;
    if(typesetter.isopen()) {
      typesetter >> out;
      if(!out.empty()) gs << out;
      else if(!typesetter.running()) {
        typesetter.pipeclose();
        gs.eof();
      }
    } 
    string out2;
    gs >> out2;
    if(out2.empty() && !gs.running()) break;
    ps << out2;
  }
  ps.close();
  
  if(verbose > 2) cout << endl;
  
  bool keep=getSetting<bool>("keep");
  if(!keep) // Delete temporary files.
    unlink(textname.c_str());
  {Stack->push<patharray*>(readpath(psname,keep,tenpercent,tenpercent)); return;}
}

#line 1477 "runtime.in"
// patharray* _strokepath(path g, pen p=CURRENTPEN);
void gen30(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  path g=vm::pop<path>(Stack);
#line 1478 "runtime.in"
  array *P=new array(0);
  if(g.size() == 0) {Stack->push<patharray*>(P); return;}
  
  string prefix=outname();
  spaceToUnderscore(prefix);
  string psname=auxname(prefix,"ps");
  bbox b;
  psfile ps(psname,false);
  ps.prologue(b);
  ps.verbatimline(ASYx);
  ps.verbatimline(ASYy);
  ps.verbatimline("/stroke {"+ASYinit+pathforall+"} bind def");
  ps.resetpen();
  ps.setpen(p);
  ps.write(g);
  ps.strokepath();
  ps.stroke();
  ps.verbatimline("(M) "+currentpoint);
  ps.epilogue();
  ps.close();
  {Stack->push<patharray*>(readpath(psname,getSetting<bool>("keep"))); return;}
}

#line 1502 "runtime.in"
// void _draw(picture *f, path g, pen p);
void gen31(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  path g=vm::pop<path>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1503 "runtime.in"
  f->append(new drawPath(g,p));
}

#line 1507 "runtime.in"
// void fill(picture *f, patharray *g, pen p=CURRENTPEN, bool copy=true);
void gen32(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1508 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawFill(*copyarray(g),false,p));
}

#line 1513 "runtime.in"
// void latticeshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray2 *p, bool copy=true);
void gen33(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1515 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawLatticeShade(*copyarray(g),stroke,fillrule,*copyarray(p)));
}

#line 1520 "runtime.in"
// void axialshade(picture *f, patharray *g, bool stroke=false, pen pena, pair a,                pen penb, pair b, bool copy=true);
void gen34(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1522 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawAxialShade(*copyarray(g),stroke,pena,a,penb,b));
}

#line 1527 "runtime.in"
// void radialshade(picture *f, patharray *g, bool stroke=false, pen pena,                 pair a, real ra, pen penb, pair b, real rb, bool copy=true);
void gen35(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  real rb=vm::pop<real>(Stack);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  real ra=vm::pop<real>(Stack);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1529 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawRadialShade(*copyarray(g),stroke,pena,a,ra,penb,b,rb));
}

#line 1534 "runtime.in"
// void gouraudshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray *p, pairarray *z,                  Intarray *edges, bool copy=true);
void gen36(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  pairarray * z=vm::pop<pairarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1537 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  checkArrays(p,z);
  checkArrays(z,edges);
  f->append(new drawGouraudShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 *copyarray(z),*copyarray(edges)));
}

#line 1545 "runtime.in"
// void gouraudshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray *p, Intarray *edges,                  bool copy=true);
void gen37(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1548 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  size_t n=checkArrays(p,edges);
  size_t m=checkArray(g);
  array *z=new array(n);
  Int k=0;
  Int in=(Int) n;
  for(size_t j=0; j < m; ++j) {
    path *P=read<path *>(g,j);
    assert(P);
    Int stop=Min(P->size(),in-k);
    mem::vector<solvedKnot>& nodes=P->Nodes();
    for(Int i=0; i < stop; ++i)
      (*z)[k++]=nodes[i].point;
  }
  checkArrays(p,z);
  
  f->append(new drawGouraudShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 *z,*copyarray(edges)));
}

#line 1569 "runtime.in"
// void tensorshade(picture *f, patharray *g, bool stroke=false,                 pen fillrule=CURRENTPEN, penarray2 *p, patharray *b=NULL,                 pairarray2 *z=emptyarray, bool copy=true);
void gen38(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pairarray2 * z=vm::pop<pairarray2 *>(Stack,emptyarray);
  patharray * b=vm::pop<patharray *>(Stack,NULL);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1572 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  if(b == NULL) b=g;
  size_t n=checkArrays(p,b);
  size_t nz=checkArray(z);
  if(nz != 0)
    checkEqual(nz,n);
  f->append(new drawTensorShade(*copyarray(g),stroke,fillrule,*copyarray2(p),
                                *copyarray(b),*copyarray2(z)));
}

#line 1584 "runtime.in"
// void functionshade(picture *f, patharray *g, bool stroke=false,                   pen fillrule=CURRENTPEN, string shader=emptystring,                   bool copy=true);
void gen39(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  string shader=vm::pop<string>(Stack,emptystring);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1587 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawFunctionShade(*copyarray(g),stroke,fillrule,shader));
}

// Clip a picture to a superpath using the given fill rule.
// Subsequent additions to the picture will not be affected by the clipping.
#line 1594 "runtime.in"
// void clip(picture *f, patharray *g, bool stroke=false,          pen fillrule=CURRENTPEN, bool copy=true);
void gen40(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1596 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  drawClipBegin *begin=new drawClipBegin(*copyarray(g),stroke,fillrule,true);
  f->enclose(begin,new drawClipEnd(true,begin));
}

#line 1602 "runtime.in"
// void beginclip(picture *f, patharray *g, bool stroke=false,               pen fillrule=CURRENTPEN, bool copy=true);
void gen41(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1604 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawClipBegin(*copyarray(g),stroke,fillrule,false));
}

#line 1609 "runtime.in"
// void endclip(picture *f);
void gen42(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1610 "runtime.in"
  f->append(new drawClipEnd(false));
}

#line 1614 "runtime.in"
// void gsave(picture *f);
void gen43(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1615 "runtime.in"
  f->append(new drawGsave());
}

#line 1619 "runtime.in"
// void grestore(picture *f);
void gen44(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1620 "runtime.in"
  f->append(new drawGrestore());
}

#line 1624 "runtime.in"
// void begingroup(picture *f);
void gen45(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1625 "runtime.in"
  f->append(new drawBegin());
}

#line 1629 "runtime.in"
// void endgroup(picture *f);
void gen46(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1630 "runtime.in"
  f->append(new drawEnd());
}

#line 1634 "runtime.in"
// void add(picture *dest, picture *src);
void gen47(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 1635 "runtime.in"
  dest->add(*src);
}

#line 1639 "runtime.in"
// void prepend(picture *dest, picture *src);
void gen48(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 1640 "runtime.in"
  dest->prepend(*src);
}

#line 1644 "runtime.in"
// void postscript(picture *f, string s);
void gen49(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1645 "runtime.in"
  f->append(new drawVerbatim(PostScript,s));
}

#line 1649 "runtime.in"
// void tex(picture *f, string s);
void gen50(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1650 "runtime.in"
  f->append(new drawVerbatim(TeX,s));
}

#line 1654 "runtime.in"
// void postscript(picture *f, string s, pair min, pair max);
void gen51(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1655 "runtime.in"
  f->append(new drawVerbatim(PostScript,s,min,max));
}

#line 1659 "runtime.in"
// void tex(picture *f, string s, pair min, pair max);
void gen52(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1660 "runtime.in"
  f->append(new drawVerbatim(TeX,s,min,max));
}

#line 1664 "runtime.in"
// void texpreamble(string s);
void gen53(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 1665 "runtime.in"
  string t=s+"\n";
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.push_back(t);
  pd.TeXpreamble.push_back(t);
}

#line 1672 "runtime.in"
// void deletepreamble();
void gen54(stack *)
{
#line 1673 "runtime.in"
  if(getSetting<bool>("inlinetex")) {
    unlink(auxname(outname(),"pre").c_str());
  }
}

#line 1679 "runtime.in"
// void _labelpath(picture *f, string s, string size, path g, string justify,                pair offset, pen p);
void gen55(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  pair offset=vm::pop<pair>(Stack);
  string justify=vm::pop<string>(Stack);
  path g=vm::pop<path>(Stack);
  string size=vm::pop<string>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1681 "runtime.in"
  f->append(new drawLabelPath(s,size,g,justify,offset,p));
}

#line 1685 "runtime.in"
// void texreset();
void gen56(stack *)
{
#line 1686 "runtime.in"
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.clear();
  pd.TeXpreamble.clear();
  pd.tex.pipeclose();
}

#line 1693 "runtime.in"
// void layer(picture *f);
void gen57(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1694 "runtime.in"
  f->append(new drawLayer());
}

#line 1698 "runtime.in"
// void newpage(picture *f);
void gen58(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 1699 "runtime.in"
  f->append(new drawNewPage());
}

#line 1703 "runtime.in"
// void _image(picture *f, realarray2 *data, pair initial, pair final,            penarray *palette=NULL, transform t=identity, bool copy=true,            bool antialias=false);
void gen59(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  penarray * palette=vm::pop<penarray *>(Stack,NULL);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  realarray2 * data=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1706 "runtime.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  f->append(new drawImage(*copyarray2(data),*copyarray(palette),
                          t*matrix(initial,final),antialias));
}

#line 1713 "runtime.in"
// void _image(picture *f, penarray2 *data, pair initial, pair final,            transform t=identity, bool copy=true, bool antialias=false);
void gen60(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  penarray2 * data=vm::pop<penarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 1715 "runtime.in"
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  f->append(new drawImage(*copyarray2(data),t*matrix(initial,final),antialias));
}

#line 1720 "runtime.in"
// string nativeformat();
void gen61(stack *Stack)
{
#line 1721 "runtime.in"
  {Stack->push<string>(nativeformat()); return;}
}

#line 1725 "runtime.in"
// bool latex();
void gen62(stack *Stack)
{
#line 1726 "runtime.in"
  {Stack->push<bool>(latex(getSetting<string>("tex"))); return;}
}

#line 1730 "runtime.in"
// bool pdf();
void gen63(stack *Stack)
{
#line 1731 "runtime.in"
  {Stack->push<bool>(pdf(getSetting<string>("tex"))); return;}
}

#line 1735 "runtime.in"
// void shipout(string prefix=emptystring, picture *f, picture *preamble=NULL,             string format=emptystring, bool wait=false, bool view=true,             callableTransform *xform);
void gen64(stack *Stack)
{
  callableTransform * xform=vm::pop<callableTransform *>(Stack);
  bool view=vm::pop<bool>(Stack,true);
  bool wait=vm::pop<bool>(Stack,false);
  string format=vm::pop<string>(Stack,emptystring);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack,emptystring);
#line 1738 "runtime.in"
  if(prefix.empty()) prefix=outname();

  picture *result=new picture;
  unsigned level=0;
  picture::nodelist::iterator p;
  for(p = f->nodes.begin(); p != f->nodes.end(); ++p) {
    xform->call(Stack);
    transform t=pop<transform>(Stack);
    static transform Zero=transform(0.0,0.0,0.0,0.0,0.0,0.0);
    bool Delete=(t == Zero);
    picture *group=new picture;
    assert(*p);
    if((*p)->endgroup()) error(nobegin);
    if((*p)->begingroup()) {
      ++level;
      while(p != f->nodes.end() && level) {
        if(!Delete) {
          drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
          group->append(e);
        }
        ++p;
        if(p == f->nodes.end()) break;
        assert(*p);
        if((*p)->begingroup()) ++level;
        if((*p)->endgroup()) {
          if(level) --level;
          else error(nobegin);
        }
      }
    }
    if(p == f->nodes.end()) break;
    assert(*p);
    if(!Delete) {
      drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
      group->append(e);
      result->add(*group);
    }
  }
    
  result->shipout(preamble,prefix,format,0.0,wait,view);
}

#line 1781 "runtime.in"
// void shipout3(string prefix, picture *f, string format=emptystring,              real width, real height, real angle, real zoom,              triple m, triple M, pair shift, realarray2 *t,              realarray *background, triplearray *lights, realarray2 *diffuse,              realarray2 *ambient, realarray2 *specular,              bool viewportlighting, bool view=true);
void gen65(stack *Stack)
{
  bool view=vm::pop<bool>(Stack,true);
  bool viewportlighting=vm::pop<bool>(Stack);
  realarray2 * specular=vm::pop<realarray2 *>(Stack);
  realarray2 * ambient=vm::pop<realarray2 *>(Stack);
  realarray2 * diffuse=vm::pop<realarray2 *>(Stack);
  triplearray * lights=vm::pop<triplearray *>(Stack);
  realarray * background=vm::pop<realarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  pair shift=vm::pop<pair>(Stack);
  triple M=vm::pop<triple>(Stack);
  triple m=vm::pop<triple>(Stack);
  real zoom=vm::pop<real>(Stack);
  real angle=vm::pop<real>(Stack);
  real height=vm::pop<real>(Stack);
  real width=vm::pop<real>(Stack);
  string format=vm::pop<string>(Stack,emptystring);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack);
#line 1787 "runtime.in"
  size_t n=checkArrays(lights,diffuse);
  checkEqual(n,checkArray(ambient));
  checkEqual(n,checkArray(specular));
  
  f->shipout3(prefix,format,width,height,angle,zoom,m,M,shift,
              copyArray2C(t,true,4),
              copyArrayC(background),n,copyTripleArrayC(lights),
              copyArray2C(diffuse,false,4),copyArray2C(ambient,false,4),
              copyArray2C(specular,false,4),viewportlighting,view);
}

#line 1799 "runtime.in"
// void shipout3(string prefix, picture *f);
void gen66(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack);
#line 1800 "runtime.in"
  f->shipout3(prefix);
}

#line 1804 "runtime.in"
// void deconstruct(picture *f, picture *preamble=NULL, real magnification=1,                  callableTransform *xform);
void gen67(stack *Stack)
{
  callableTransform * xform=vm::pop<callableTransform *>(Stack);
  real magnification=vm::pop<real>(Stack,1);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
#line 1806 "runtime.in"
  unsigned level=0;
  unsigned n=0;

  string prefix=outname();
  string xformat=getSetting<string>("xformat");

  static long arg_max=sysconf(_SC_ARG_MAX);
  const unsigned maxargs=::min(arg_max/(prefix.size()+xformat.size()+25ul),
                               256ul);
  
  cout << xformat << newl;
  cout << maxargs << newl;
  
  string preformat=nativeformat();
  const string Done="Done";
  const string Error="Error";
  
  ostringstream cmd;
  
  // Enforce ghostscript limitations.
  magnification=::max(magnification,0.0001);
  real res=::min(::max(magnification*72.0,2.0),8192.0);
  
  const char *converter=NULL, *hint=NULL;
  
  bool png=xformat == "png";
  
  if(magnification > 0.0) {
    mem::list<string> nameStack;
    string outname;
    unsigned arg=0;
    unsigned batch=0;
    for(picture::nodelist::iterator p=f->nodes.begin();;) {
      if(p == f->nodes.end()) break;
      if(arg == 0) {
        cmd.str("");
        ostringstream buf;
        buf << batch << "_";
        outname=buildname(prefix+buf.str()+"%d",xformat,"");
        if(png) {
          cmd << "'" << getSetting<string>("gs")
              << "' -q -dNOPAUSE -dBATCH -sDEVICE=pngalpha -dEPSCrop";
          if(safe)
            cmd << " -dSAFER";
          cmd << " -r" << res << "x" << res
              << " -sOutputFile='" << outname << "'";
          converter="gs";
          hint="Ghostscript";
        } else {
          cmd << "'" << getSetting<string>("convert") 
              << "' -density " << res << "x" << res
              << " -transparent white";
          hint=converter="convert";
        }
      }
      
      picture *group=new picture;
      xform->call(Stack);
      transform t=pop<transform>(Stack);
      assert(*p);
      if((*p)->endgroup()) {
        cout << Error << endl;
        error(nobegin);
      }
      if((*p)->begingroup()) {
        ++level;
        while(p != f->nodes.end() && level) {
          drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
          group->append(e);
          ++p;
          if(p == f->nodes.end()) break;
          assert(*p);
          if((*p)->begingroup()) ++level;
          if((*p)->endgroup()) {
            if(level) --level;
            else {
              cout << Error << endl;
              error(nobegin);
            }
          }
        }
      }
      if(p != f->nodes.end()) {
        assert(*p);
        drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
        group->append(e);
        bbox b;
        ostringstream buf;
        buf << prefix << "_" << n;
        group->shipout(preamble,buf.str(),preformat,magnification,false,false);
        string Preformat=png && group->Transparency() ? "pdf" : preformat;
        string name=buildname(buf.str(),Preformat);
        nameStack.push_back(name);
        cmd << " '";
        if(!png) cmd << preformat+":";
        cmd << name << "'";
        b=group->bounds();
        b *= magnification;
      
        cout << b << newl;
        ++n;
        ++p;
        ++arg;
      }
      
      if(p == f->nodes.end() || arg >= maxargs) {
        arg=0;
        ++batch;
        cout.flush();
        if(!png) 
          cmd << " -scene 1 '" << xformat << ":" << outname << "'";
    
        int status=System(cmd,0,true,converter,hint);
        if(status) {
          cout << Error << endl;
          error("deconstruct failed");
        }
      }
    }
    
    if(!getSetting<bool>("keep")) {
      for(mem::list<string>::iterator p=nameStack.begin();
          p != nameStack.end(); ++p)
        unlink(p->c_str());
    }
    
    cout << Done << endl;
  }
}

#line 1937 "runtime.in"
// void purge(Int divisor=0);
void gen68(stack *Stack)
{
  Int divisor=vm::pop<Int>(Stack,0);
#line 1938 "runtime.in"
  purge(divisor);
}


// Pen operations
#line 1944 "runtime.in"
void newPen(stack *Stack)
{
#line 1945 "runtime.in"
  {Stack->push<pen>(pen()); return;}
}

#line 1950 "runtime.in"
// bool ==(pen a, pen b);
void gen70(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1951 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 1955 "runtime.in"
// bool !=(pen a, pen b);
void gen71(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1956 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 1960 "runtime.in"
// pen +(pen a, pen b);
void gen72(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1961 "runtime.in"
  {Stack->push<pen>(a+b); return;}
}

#line 1965 "runtime.in"
// pen *(real a, pen b);
void gen73(stack *Stack)
{
  pen b=vm::pop<pen>(Stack);
  real a=vm::pop<real>(Stack);
#line 1966 "runtime.in"
  {Stack->push<pen>(a*b); return;}
}

#line 1970 "runtime.in"
// pen *(pen a, real b);
void gen74(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 1971 "runtime.in"
  {Stack->push<pen>(b*a); return;}
}

#line 1975 "runtime.in"
// pair max(pen p);
void gen75(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1976 "runtime.in"
  {Stack->push<pair>(p.bounds().Max()); return;}
}

#line 1980 "runtime.in"
// pair min(pen p);
void gen76(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1981 "runtime.in"
  {Stack->push<pair>(p.bounds().Min()); return;}
}

// Reset the meaning of pen default attributes.
#line 1986 "runtime.in"
// void resetdefaultpen();
void gen77(stack *)
{
#line 1987 "runtime.in"
  processData().defaultpen=camp::pen::initialpen();
}

#line 1991 "runtime.in"
// void defaultpen(pen p);
void gen78(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 1992 "runtime.in"
  processData().defaultpen=pen(resolvepen,p);
}

#line 1996 "runtime.in"
// pen defaultpen();
void gen79(stack *Stack)
{
#line 1997 "runtime.in"
  {Stack->push<pen>(processData().defaultpen); return;}
}

#line 2001 "runtime.in"
// bool invisible(pen p);
void gen80(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2002 "runtime.in"
  {Stack->push<bool>(p.invisible()); return;}
}

#line 2006 "runtime.in"
// pen invisible();
void gen81(stack *Stack)
{
#line 2007 "runtime.in"
  {Stack->push<pen>(pen(invisiblepen)); return;}
}

#line 2011 "runtime.in"
// pen gray(pen p);
void gen82(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2012 "runtime.in"
  p.togrey();
  {Stack->push<pen>(p); return;}
}

#line 2017 "runtime.in"
// pen rgb(pen p);
void gen83(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2018 "runtime.in"
  p.torgb();
  {Stack->push<pen>(p); return;}
}

#line 2023 "runtime.in"
// pen cmyk(pen p);
void gen84(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2024 "runtime.in"
  p.tocmyk();
  {Stack->push<pen>(p); return;}
}

#line 2029 "runtime.in"
// pen interp(pen a, pen b, real t);
void gen85(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  pen b=vm::pop<pen>(Stack);
  pen a=vm::pop<pen>(Stack);
#line 2030 "runtime.in"
  {Stack->push<pen>(interpolate(a,b,t)); return;}
}

#line 2034 "runtime.in"
// pen rgb(real r, real g, real b);
void gen86(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real g=vm::pop<real>(Stack);
  real r=vm::pop<real>(Stack);
#line 2035 "runtime.in"
  {Stack->push<pen>(pen(r,g,b)); return;}
}

#line 2039 "runtime.in"
// pen cmyk(real c, real m, real y, real k);
void gen87(stack *Stack)
{
  real k=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real m=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
#line 2040 "runtime.in"
  {Stack->push<pen>(pen(c,m,y,k)); return;}  
}

#line 2044 "runtime.in"
// pen gray(real gray);
void gen88(stack *Stack)
{
  real gray=vm::pop<real>(Stack);
#line 2045 "runtime.in"
  {Stack->push<pen>(pen(gray)); return;}
}

#line 2049 "runtime.in"
// realarray* colors(pen p);
void gen89(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2050 "runtime.in"  
  size_t n=ColorComponents[p.colorspace()];
  array *a=new array(n);
  
  switch(n) {
    case 0:
      break;
    case 1: 
      (*a)[0]=p.gray(); 
      break;
    case 3:
      (*a)[0]=p.red(); 
      (*a)[1]=p.green(); 
      (*a)[2]=p.blue(); 
      break;
    case 4:
      (*a)[0]=p.cyan();
      (*a)[1]=p.magenta(); 
      (*a)[2]=p.yellow(); 
      (*a)[3]=p.black();
      break;
    default:
      break;
  }
  {Stack->push<realarray*>(a); return;}
}

#line 2077 "runtime.in"
// string colorspace(pen p);
void gen90(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2078 "runtime.in"
  string s=ColorDeviceSuffix[p.colorspace()];
  std::transform(s.begin(),s.end(),s.begin(),tolower);
  {Stack->push<string>(s); return;}
}

#line 2084 "runtime.in"
// pen pattern(string *s);
void gen91(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 2085 "runtime.in"
  {Stack->push<pen>(pen(setpattern,*s)); return;}
}

#line 2089 "runtime.in"
// string pattern(pen p);
void gen92(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2090 "runtime.in"
  {Stack->push<string>(p.fillpattern()); return;}  
}

#line 2094 "runtime.in"
// pen fillrule(Int n);
void gen93(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 2095 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nFill ? (FillRule) n : DEFFILL)); return;}
}

#line 2099 "runtime.in"
// Int fillrule(pen p);
void gen94(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2100 "runtime.in"
  {Stack->push<Int>(p.Fillrule()); return;}  
}

#line 2104 "runtime.in"
// pen opacity(real opacity=1.0, string blend=defaulttransparency);
void gen95(stack *Stack)
{
  string blend=vm::pop<string>(Stack,defaulttransparency);
  real opacity=vm::pop<real>(Stack,1.0);
#line 2105 "runtime.in"
  for(Int i=0; i < nBlendMode; ++i)
    if(blend == BlendMode[i]) {Stack->push<pen>(pen(Transparency(blend,opacity))); return;}

  ostringstream buf;
  buf << "Unknown blend mode: " << "'" << blend << "'";
  error(buf);
}

#line 2114 "runtime.in"
// real opacity(pen p);
void gen96(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2115 "runtime.in"
  {Stack->push<real>(p.opacity()); return;}
}

#line 2119 "runtime.in"
// string blend(pen p);
void gen97(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2120 "runtime.in"
  {Stack->push<string>(p.blend()); return;}
}

#line 2124 "runtime.in"
// pen linetype(string *s, real offset=0, bool scale=true, bool adjust=true);
void gen98(stack *Stack)
{
  bool adjust=vm::pop<bool>(Stack,true);
  bool scale=vm::pop<bool>(Stack,true);
  real offset=vm::pop<real>(Stack,0);
  string * s=vm::pop<string *>(Stack);
#line 2125 "runtime.in"
  {Stack->push<pen>(pen(LineType(*s,offset,scale,adjust))); return;} 
}

#line 2129 "runtime.in"
// string linetype(pen p=CURRENTPEN);
void gen99(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2130 "runtime.in"
  {Stack->push<string>(p.stroke()); return;}  
}

#line 2134 "runtime.in"
// real offset(pen p);
void gen100(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2135 "runtime.in"
  {Stack->push<real>(p.linetype().offset); return;}
}

#line 2139 "runtime.in"
// bool scale(pen p);
void gen101(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2140 "runtime.in"
  {Stack->push<bool>(p.linetype().scale); return;}
}

#line 2144 "runtime.in"
// bool adjust(pen p);
void gen102(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2145 "runtime.in"
  {Stack->push<bool>(p.linetype().adjust); return;}
}

#line 2149 "runtime.in"
// pen adjust(pen p, real arclength, bool cyclic);
void gen103(stack *Stack)
{
  bool cyclic=vm::pop<bool>(Stack);
  real arclength=vm::pop<real>(Stack);
  pen p=vm::pop<pen>(Stack);
#line 2150 "runtime.in"
  {Stack->push<pen>(adjustdash(p,arclength,cyclic)); return;}
}

#line 2154 "runtime.in"
// pen linecap(Int n);
void gen104(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 2155 "runtime.in"
  {Stack->push<pen>(pen(setlinecap,n >= 0 && n < nCap ? n : DEFCAP)); return;}
}

#line 2159 "runtime.in"
// Int linecap(pen p=CURRENTPEN);
void gen105(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2160 "runtime.in"
  {Stack->push<Int>(p.cap()); return;}  
}

#line 2164 "runtime.in"
// pen linejoin(Int n);
void gen106(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 2165 "runtime.in"
  {Stack->push<pen>(pen(setlinejoin,n >= 0 && n < nJoin ? n : DEFJOIN)); return;}
}

#line 2169 "runtime.in"
// Int linejoin(pen p=CURRENTPEN);
void gen107(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2170 "runtime.in"
  {Stack->push<Int>(p.join()); return;}  
}

#line 2174 "runtime.in"
// pen miterlimit(real x);
void gen108(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2175 "runtime.in"
  {Stack->push<pen>(pen(setmiterlimit,x >= 1.0 ? x : DEFJOIN)); return;}
}

#line 2179 "runtime.in"
// real miterlimit(pen p=CURRENTPEN);
void gen109(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2180 "runtime.in"
  {Stack->push<real>(p.miter()); return;}  
}

#line 2184 "runtime.in"
// pen linewidth(real x);
void gen110(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 2185 "runtime.in"
  {Stack->push<pen>(pen(setlinewidth,x >= 0.0 ? x : DEFWIDTH)); return;}
}

#line 2189 "runtime.in"
// real linewidth(pen p=CURRENTPEN);
void gen111(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2190 "runtime.in"
  {Stack->push<real>(p.width()); return;}  
}

#line 2194 "runtime.in"
// pen fontcommand(string *s);
void gen112(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 2195 "runtime.in"
  {Stack->push<pen>(pen(setfont,*s)); return;}
}

#line 2199 "runtime.in"
// string font(pen p=CURRENTPEN);
void gen113(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2200 "runtime.in"
  {Stack->push<string>(p.Font()); return;}
}

#line 2204 "runtime.in"
// pen fontsize(real size, real lineskip);
void gen114(stack *Stack)
{
  real lineskip=vm::pop<real>(Stack);
  real size=vm::pop<real>(Stack);
#line 2205 "runtime.in"
  {Stack->push<pen>(pen(setfontsize,size > 0.0 ? size : 0.0,
             lineskip > 0.0 ? lineskip : 0.0)); return;}
}

#line 2210 "runtime.in"
// real fontsize(pen p=CURRENTPEN);
void gen115(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2211 "runtime.in"
  {Stack->push<real>(p.size()); return;}
}

#line 2215 "runtime.in"
// real lineskip(pen p=CURRENTPEN);
void gen116(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2216 "runtime.in"
  {Stack->push<real>(p.Lineskip()); return;}  
}

#line 2220 "runtime.in"
// pen overwrite(Int n);
void gen117(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 2221 "runtime.in"
  {Stack->push<pen>(pen(setoverwrite,n >= 0 && n < nOverwrite ? (overwrite_t) n :
             DEFWRITE)); return;}
}

#line 2226 "runtime.in"
// Int overwrite(pen p=CURRENTPEN);
void gen118(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2227 "runtime.in"
  {Stack->push<Int>(p.Overwrite()); return;}  
}

#line 2231 "runtime.in"
// pen basealign(Int n);
void gen119(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 2232 "runtime.in"
  {Stack->push<pen>(pen(n >= 0 && n < nBaseLine ? (BaseLine) n : DEFBASE)); return;}
}

#line 2236 "runtime.in"
// Int basealign(pen p=CURRENTPEN);
void gen120(stack *Stack)
{
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
#line 2237 "runtime.in"
  {Stack->push<Int>(p.Baseline()); return;}
}

#line 2241 "runtime.in"
// transform transform(pen p);
void gen121(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2242 "runtime.in"
  {Stack->push<transform>(p.getTransform()); return;}
}

#line 2246 "runtime.in"
// path nib(pen p);
void gen122(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2247 "runtime.in"
  {Stack->push<path>(p.Path()); return;}
}

#line 2251 "runtime.in"
// pen makepen(path p);
void gen123(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2252 "runtime.in"
  {Stack->push<pen>(pen(p)); return;}
}

#line 2256 "runtime.in"
// pen colorless(pen p);
void gen124(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
#line 2257 "runtime.in"
  p.colorless();
  {Stack->push<pen>(p); return;}
}

// Interactive mode
#line 2263 "runtime.in"
// bool interactive();
void gen125(stack *Stack)
{
#line 2264 "runtime.in"
  {Stack->push<bool>(interact::interactive); return;}
}

#line 2269 "runtime.in"
// bool uptodate();
void gen126(stack *Stack)
{
#line 2270 "runtime.in"
  {Stack->push<bool>(interact::uptodate); return;}
}


// System commands
#line 2276 "runtime.in"
// Int system(string s);
void gen127(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 2277 "runtime.in"
  if(safe) error("system() call disabled; override with option -nosafe");
  if(s.empty()) {Stack->push<Int>(0); return;}
  else {Stack->push<Int>(System(s.c_str())); return;}
}

#line 2284 "runtime.in"
// bool view();
void gen128(stack *Stack)
{
#line 2285 "runtime.in"
  {Stack->push<bool>(view()); return;}
}

#line 2289 "runtime.in"
// string asydir();
void gen129(stack *Stack)
{
#line 2290 "runtime.in"
  {Stack->push<string>(systemDir); return;}
}

#line 2294 "runtime.in"
// string locale(string s=emptystring);
void gen130(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 2295 "runtime.in"
  char *L=setlocale(LC_ALL,s.empty() ? NULL : s.c_str());
  {Stack->push<string>(L != NULL ? string(L) : ""); return;}
}

#line 2300 "runtime.in"
// void abort(string s=emptystring);
void gen131(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 2301 "runtime.in"
  if(s.empty()) throw handled_error();
  error(s.c_str());
}

#line 2306 "runtime.in"
// void exit();
void gen132(stack *)
{
#line 2307 "runtime.in"
  throw quit();
}

#line 2311 "runtime.in"
// void assert(bool b, string s=emptystring);
void gen133(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
  bool b=vm::pop<bool>(Stack);
#line 2312 "runtime.in"
  flush(cout);
  if(!b) {
    ostringstream buf;
    buf << "assert FAILED";
    if(s != "") buf << ": " << s << endl;
    error(buf);
  }
}

#line 2322 "runtime.in"
// void sleep(Int seconds);
void gen134(stack *Stack)
{
  Int seconds=vm::pop<Int>(Stack);
#line 2323 "runtime.in"
  if(seconds <= 0) return;      
  sleep(seconds);
}

#line 2328 "runtime.in"
// void usleep(Int microseconds);
void gen135(stack *Stack)
{
  Int microseconds=vm::pop<Int>(Stack);
#line 2329 "runtime.in"
  if(microseconds <= 0) return; 
  usleep((unsigned long) microseconds); 
}

#line 2334 "runtime.in"
// void _eval(string *s, bool embedded, bool interactiveWrite=false);
void gen136(stack *Stack)
{
  bool interactiveWrite=vm::pop<bool>(Stack,false);
  bool embedded=vm::pop<bool>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 2335 "runtime.in"
  if (embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if (e && is) {
      runStringEmbedded(*s, *e, *is);
    } else {
      cerr << "no runtime environment for embedded eval" << endl;
    }
  } else {
    runString(*s,interactiveWrite);
  }
}

#line 2349 "runtime.in"
// void _eval(runnable *s, bool embedded);
void gen137(stack *Stack)
{
  bool embedded=vm::pop<bool>(Stack);
  runnable * s=vm::pop<runnable *>(Stack);
#line 2350 "runtime.in"
  absyntax::block *ast=new absyntax::block(s->getPos(), false);
  ast->add(s);

  if (embedded) {
    trans::coenv *e=Stack->getEnvironment();
    vm::interactiveStack *is=dynamic_cast<vm::interactiveStack *>(Stack);
    if (e && is) {
      runCodeEmbedded(ast, *e, *is);
    } else {
      cerr << "no runtime environment for embedded eval" << endl;
    }
  } else {
    runCode(ast);
  }
}

#line 2367 "runtime.in"
// string location();
void gen138(stack *Stack)
{
#line 2368 "runtime.in"
  ostringstream buf;
  buf << getPos();
  {Stack->push<string>(buf.str()); return;}
}

// Wrapper for the stack::load() method.
#line 2374 "runtime.in"
void loadModule(stack *Stack)
{
  string * index=vm::pop<string *>(Stack);
#line 2375 "runtime.in"
  Stack->load(*index);
}

#line 2379 "runtime.in"
// string cd(string s=emptystring);
void gen140(stack *Stack)
{
  string s=vm::pop<string>(Stack,emptystring);
#line 2380 "runtime.in"
  if(!s.empty() && !globalwrite()) writeDisabled();
  {Stack->push<string>(setPath(s.c_str())); return;}
}

#line 2385 "runtime.in"
// void list(string *s, bool imports=false);
void gen141(stack *Stack)
{
  bool imports=vm::pop<bool>(Stack,false);
  string * s=vm::pop<string *>(Stack);
#line 2386 "runtime.in"
  if(*s == "-") return;
  trans::genv ge;
  symbol *name=symbol::trans(*s);
  record *r=ge.getModule(name,*s);
  r->e.list(imports ? 0 : r);
}


// Path operations
#line 2396 "runtime.in"
void nullPath(stack *Stack)
{
#line 2397 "runtime.in"
  {Stack->push<path>(nullpath); return;}
}

#line 2402 "runtime.in"
// bool ==(path a, path b);
void gen143(stack *Stack)
{
  path b=vm::pop<path>(Stack);
  path a=vm::pop<path>(Stack);
#line 2403 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 2407 "runtime.in"
// bool !=(path a, path b);
void gen144(stack *Stack)
{
  path b=vm::pop<path>(Stack);
  path a=vm::pop<path>(Stack);
#line 2408 "runtime.in"
  {Stack->push<bool>(!(a == b)); return;}
}

#line 2412 "runtime.in"
// pair point(path p, Int t);
void gen145(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2413 "runtime.in"
  {Stack->push<pair>(p.point((Int) t)); return;}
}

#line 2417 "runtime.in"
// pair point(path p, real t);
void gen146(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2418 "runtime.in"
  {Stack->push<pair>(p.point(t)); return;}
}

#line 2422 "runtime.in"
// pair precontrol(path p, Int t);
void gen147(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2423 "runtime.in"
  {Stack->push<pair>(p.precontrol((Int) t)); return;}
}

#line 2427 "runtime.in"
// pair precontrol(path p, real t);
void gen148(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2428 "runtime.in"
  {Stack->push<pair>(p.precontrol(t)); return;}
}

#line 2432 "runtime.in"
// pair postcontrol(path p, Int t);
void gen149(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2433 "runtime.in"
  {Stack->push<pair>(p.postcontrol((Int) t)); return;}
}

#line 2437 "runtime.in"
// pair postcontrol(path p, real t);
void gen150(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2438 "runtime.in"
  {Stack->push<pair>(p.postcontrol(t)); return;}
}

#line 2442 "runtime.in"
// pair dir(path p, Int t, Int sign=0, bool normalize=true);
void gen151(stack *Stack)
{
  bool normalize=vm::pop<bool>(Stack,true);
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2443 "runtime.in"
  {Stack->push<pair>(p.dir(t,sign,normalize)); return;}
}

#line 2447 "runtime.in"
// pair dir(path p, real t, bool normalize=true);
void gen152(stack *Stack)
{
  bool normalize=vm::pop<bool>(Stack,true);
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2448 "runtime.in"
  {Stack->push<pair>(p.dir(t,normalize)); return;}
}

#line 2452 "runtime.in"
// pair accel(path p, Int t, Int sign=0);
void gen153(stack *Stack)
{
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2453 "runtime.in"
  {Stack->push<pair>(p.accel(t,sign)); return;}
}

#line 2457 "runtime.in"
// pair accel(path p, real t);
void gen154(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2458 "runtime.in"
  {Stack->push<pair>(p.accel(t)); return;}
}

#line 2462 "runtime.in"
// real radius(path p, real t);
void gen155(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2463 "runtime.in"
  pair v=p.dir(t,false);
  pair a=p.accel(t);
  real d=dot(a,v);
  real v2=v.abs2();
  real a2=a.abs2();
  real denom=v2*a2-d*d;
  real r=v2*sqrt(v2);
  {Stack->push<real>(denom > 0 ? r/sqrt(denom) : 0.0); return;}
}

#line 2474 "runtime.in"
// path reverse(path p);
void gen156(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2475 "runtime.in"
  {Stack->push<path>(p.reverse()); return;}
}

#line 2479 "runtime.in"
// path subpath(path p, Int a, Int b);
void gen157(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2480 "runtime.in"
  {Stack->push<path>(p.subpath((Int) a, (Int) b)); return;}
}

#line 2484 "runtime.in"
// path subpath(path p, real a, real b);
void gen158(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2485 "runtime.in"
  {Stack->push<path>(p.subpath(a,b)); return;}
}

#line 2489 "runtime.in"
// path nurb(pair z0, pair z1, pair z2, pair z3,          real w0, real w1, real w2, real w3, Int m);
void gen159(stack *Stack)
{
  Int m=vm::pop<Int>(Stack);
  real w3=vm::pop<real>(Stack);
  real w2=vm::pop<real>(Stack);
  real w1=vm::pop<real>(Stack);
  real w0=vm::pop<real>(Stack);
  pair z3=vm::pop<pair>(Stack);
  pair z2=vm::pop<pair>(Stack);
  pair z1=vm::pop<pair>(Stack);
  pair z0=vm::pop<pair>(Stack);
#line 2491 "runtime.in"
  {Stack->push<path>(nurb(z0,z1,z2,z3,w0,w1,w2,w3,m)); return;}
}

#line 2495 "runtime.in"
// Int length(path p);
void gen160(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2496 "runtime.in"
  {Stack->push<Int>(p.length()); return;}
}

#line 2500 "runtime.in"
// bool cyclic(path p);
void gen161(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2501 "runtime.in"
  {Stack->push<bool>(p.cyclic()); return;}
}

#line 2505 "runtime.in"
// bool straight(path p, Int t);
void gen162(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path p=vm::pop<path>(Stack);
#line 2506 "runtime.in"
  {Stack->push<bool>(p.straight(t)); return;}
}

#line 2510 "runtime.in"
// path unstraighten(path p);
void gen163(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2511 "runtime.in"
  {Stack->push<path>(p.unstraighten()); return;}
}

#line 2515 "runtime.in"
// bool piecewisestraight(path p);
void gen164(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2516 "runtime.in"
  {Stack->push<bool>(p.piecewisestraight()); return;}
}

#line 2520 "runtime.in"
// real arclength(path p);
void gen165(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2521 "runtime.in"
  {Stack->push<real>(p.arclength()); return;}
}

#line 2525 "runtime.in"
// real arctime(path p, real dval);
void gen166(stack *Stack)
{
  real dval=vm::pop<real>(Stack);
  path p=vm::pop<path>(Stack);
#line 2526 "runtime.in"
  {Stack->push<real>(p.arctime(dval)); return;}
}

#line 2530 "runtime.in"
// real dirtime(path p, pair z);
void gen167(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  path p=vm::pop<path>(Stack);
#line 2531 "runtime.in"
  {Stack->push<real>(p.directiontime(z)); return;}
}

#line 2535 "runtime.in"
// realarray* intersect(path p, path q, real fuzz=-1);
void gen168(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 2536 "runtime.in"
  bool exact=fuzz <= 0.0;
  if(fuzz < 0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(q.max()),length(q.min())));
  std::vector<real> S,T;
  real s,t;
  if(intersections(s,t,S,T,p,q,fuzz,true,exact)) {
    array *V=new array(2);
    (*V)[0]=s;
    (*V)[1]=t;
    {Stack->push<realarray*>(V); return;}
  }
  {Stack->push<realarray*>(new array(0)); return;}
}

#line 2552 "runtime.in"
// realarray2* intersections(path p, path q, real fuzz=-1);
void gen169(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 2553 "runtime.in"
  bool exact=fuzz <= 0.0;
  if(fuzz < 0.0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(q.max()),length(q.min())));
  real s,t;
  std::vector<real> S,T;
  intersections(s,t,S,T,p,q,fuzz,false,true);
  size_t n=S.size();
  if(n == 0 && !exact) {
    if(intersections(s,t,S,T,p,q,fuzz,true,false)) {
      array *V=new array(1);
      array *Vi=new array(2);
      (*V)[0]=Vi;
      (*Vi)[0]=s;
      (*Vi)[1]=t;
      {Stack->push<realarray2*>(V); return;}
    }
  }
  array *V=new array(n);
  for(size_t i=0; i < n; ++i) {
    array *Vi=new array(2);
    (*V)[i]=Vi;
    (*Vi)[0]=S[i];
    (*Vi)[1]=T[i];
  }
  stable_sort(V->begin(),V->end(),run::compare2<real>());
  {Stack->push<realarray2*>(V); return;}
}

#line 2583 "runtime.in"
// realarray* intersections(path p, explicit pair a, explicit pair b, real fuzz=-1);
void gen170(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
  path p=vm::pop<path>(Stack);
#line 2584 "runtime.in"
  if(fuzz < 0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(a),length(b)));
  std::vector<real> S;
  intersections(S,p,a,b,fuzz);
  sort(S.begin(),S.end());
  size_t n=S.size();
  array *V=new array(n);
  for(size_t i=0; i < n; ++i)
    (*V)[i]=S[i];
  {Stack->push<realarray*>(V); return;}
}

// Return the intersection point of the extensions of the line segments 
// PQ and pq.
#line 2600 "runtime.in"
// pair extension(pair P, pair Q, pair p, pair q);
void gen171(stack *Stack)
{
  pair q=vm::pop<pair>(Stack);
  pair p=vm::pop<pair>(Stack);
  pair Q=vm::pop<pair>(Stack);
  pair P=vm::pop<pair>(Stack);
#line 2601 "runtime.in"
  pair ac=P-Q;
  pair bd=q-p;
  real det=ac.getx()*bd.gety()-ac.gety()*bd.getx();
  if(det == 0) {Stack->push<pair>(pair(infinity,infinity)); return;}
  {Stack->push<pair>(P+((p.getx()-P.getx())*bd.gety()-(p.gety()-P.gety())*bd.getx())*ac/det); return;}
}

#line 2609 "runtime.in"
// Int size(path p);
void gen172(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2610 "runtime.in"
  {Stack->push<Int>(p.size()); return;}
}

#line 2614 "runtime.in"
// path &(path p, path q);
void gen173(stack *Stack)
{
  path q=vm::pop<path>(Stack);
  path p=vm::pop<path>(Stack);
#line 2615 "runtime.in"
  {Stack->push<path>(camp::concat(p,q)); return;}
}

#line 2619 "runtime.in"
// pair min(path p);
void gen174(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2620 "runtime.in"
  {Stack->push<pair>(p.min()); return;}
}

#line 2624 "runtime.in"
// pair max(path p);
void gen175(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2625 "runtime.in"
  {Stack->push<pair>(p.max()); return;}
}

#line 2629 "runtime.in"
// realarray* mintimes(path p);
void gen176(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2630 "runtime.in"
  array *V=new array(2);
  pair z=p.mintimes();
  (*V)[0]=z.getx();
  (*V)[1]=z.gety();
  {Stack->push<realarray*>(V); return;}
}

#line 2638 "runtime.in"
// realarray* maxtimes(path p);
void gen177(stack *Stack)
{
  path p=vm::pop<path>(Stack);
#line 2639 "runtime.in"
  array *V=new array(2);
  pair z=p.maxtimes();
  (*V)[0]=z.getx();
  (*V)[1]=z.gety();
  {Stack->push<realarray*>(V); return;}
}

#line 2647 "runtime.in"
// real relativedistance(real theta, real phi, real t, bool atleast);
void gen178(stack *Stack)
{
  bool atleast=vm::pop<bool>(Stack);
  real t=vm::pop<real>(Stack);
  real phi=vm::pop<real>(Stack);
  real theta=vm::pop<real>(Stack);
#line 2648 "runtime.in"
  {Stack->push<real>(camp::velocity(theta,phi,tension(t,atleast))); return;}
}

#line 2652 "runtime.in"
// Int windingnumber(patharray *p, pair z);
void gen179(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  patharray * p=vm::pop<patharray *>(Stack);
#line 2653 "runtime.in"
  {Stack->push<Int>(windingnumber(p,z)); return;}
}

#line 2657 "runtime.in"
// bool inside(explicit patharray *g, pair z, pen fillrule=CURRENTPEN);
void gen180(stack *Stack)
{
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  pair z=vm::pop<pair>(Stack);
  patharray * g=vm::pop<patharray *>(Stack);
#line 2658 "runtime.in"
  {Stack->push<bool>(fillrule.inside(windingnumber(g,z))); return;}
}

#line 2662 "runtime.in"
// bool inside(path g, pair z, pen fillrule=CURRENTPEN);
void gen181(stack *Stack)
{
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  pair z=vm::pop<pair>(Stack);
  path g=vm::pop<path>(Stack);
#line 2663 "runtime.in"
  {Stack->push<bool>(fillrule.inside(g.windingnumber(z))); return;}
}

// Determine the side of a--b that c lies on
// (negative=left, zero=on line, positive=right).
#line 2669 "runtime.in"
// real side(pair a, pair b, pair c);
void gen182(stack *Stack)
{
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 2670 "runtime.in"
  {Stack->push<real>(orient2d(a,b,c)); return;}
}

// Determine the side of the counterclockwise circle through a,b,c that d
// lies on (negative=inside, 0=on circle, positive=right). 
#line 2676 "runtime.in"
// real incircle(pair a, pair b, pair c, pair d);
void gen183(stack *Stack)
{
  pair d=vm::pop<pair>(Stack);
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 2677 "runtime.in"
  {Stack->push<real>(incircle(a.getx(),a.gety(),b.getx(),b.gety(),c.getx(),c.gety(),
                  d.getx(),d.gety())); return;}
}


// Path3 operations
#line 2684 "runtime.in"
// path3 path3(triplearray *pre, triplearray *point, triplearray *post,            boolarray *straight, bool cyclic);
void gen184(stack *Stack)
{
  bool cyclic=vm::pop<bool>(Stack);
  boolarray * straight=vm::pop<boolarray *>(Stack);
  triplearray * post=vm::pop<triplearray *>(Stack);
  triplearray * point=vm::pop<triplearray *>(Stack);
  triplearray * pre=vm::pop<triplearray *>(Stack);
#line 2686 "runtime.in"
  size_t n=checkArrays(pre,point);
  checkEqual(n,checkArray(post));
  checkEqual(n,checkArray(straight));
  mem::vector<solvedKnot3> nodes(n);
  for(size_t i=0; i < n; ++i) {
    nodes[i].pre=read<triple>(pre,i);
    nodes[i].point=read<triple>(point,i);
    nodes[i].post=read<triple>(post,i);
    nodes[i].straight=read<bool>(straight,i);
  }

  {Stack->push<path3>(path3(nodes,(Int) n,cyclic)); return;}
}

#line 2702 "runtime.in"
void nullPath3(stack *Stack)
{
#line 2703 "runtime.in"
  {Stack->push<path3>(nullpath3); return;}
}

#line 2707 "runtime.in"
// bool ==(path3 a, path3 b);
void gen186(stack *Stack)
{
  path3 b=vm::pop<path3>(Stack);
  path3 a=vm::pop<path3>(Stack);
#line 2708 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 2712 "runtime.in"
// bool !=(path3 a, path3 b);
void gen187(stack *Stack)
{
  path3 b=vm::pop<path3>(Stack);
  path3 a=vm::pop<path3>(Stack);
#line 2713 "runtime.in"
  {Stack->push<bool>(!(a == b)); return;}
}

#line 2717 "runtime.in"
// triple point(path3 p, Int t);
void gen188(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2718 "runtime.in"
  {Stack->push<triple>(p.point((Int) t)); return;}
}

#line 2722 "runtime.in"
// triple point(path3 p, real t);
void gen189(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2723 "runtime.in"
  {Stack->push<triple>(p.point(t)); return;}
}

#line 2727 "runtime.in"
// triple precontrol(path3 p, Int t);
void gen190(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2728 "runtime.in"
  {Stack->push<triple>(p.precontrol((Int) t)); return;}
}

#line 2732 "runtime.in"
// triple precontrol(path3 p, real t);
void gen191(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2733 "runtime.in"
  {Stack->push<triple>(p.precontrol(t)); return;}
}

#line 2737 "runtime.in"
// triple postcontrol(path3 p, Int t);
void gen192(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2738 "runtime.in"
  {Stack->push<triple>(p.postcontrol((Int) t)); return;}
}

#line 2742 "runtime.in"
// triple postcontrol(path3 p, real t);
void gen193(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2743 "runtime.in"
  {Stack->push<triple>(p.postcontrol(t)); return;}
}

#line 2747 "runtime.in"
// triple dir(path3 p, Int t, Int sign=0, bool normalize=true);
void gen194(stack *Stack)
{
  bool normalize=vm::pop<bool>(Stack,true);
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2748 "runtime.in"
  {Stack->push<triple>(p.dir(t,sign,normalize)); return;}
}

#line 2752 "runtime.in"
// triple dir(path3 p, real t, bool normalize=true);
void gen195(stack *Stack)
{
  bool normalize=vm::pop<bool>(Stack,true);
  real t=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2753 "runtime.in"
  {Stack->push<triple>(p.dir(t,normalize)); return;}
}

#line 2757 "runtime.in"
// triple accel(path3 p, Int t, Int sign=0);
void gen196(stack *Stack)
{
  Int sign=vm::pop<Int>(Stack,0);
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2758 "runtime.in"
  {Stack->push<triple>(p.accel(t,sign)); return;}
}

#line 2762 "runtime.in"
// triple accel(path3 p, real t);
void gen197(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2763 "runtime.in"
  {Stack->push<triple>(p.accel(t)); return;}
}

#line 2767 "runtime.in"
// real radius(path3 p, real t);
void gen198(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2768 "runtime.in"
  triple v=p.dir(t,false);
  triple a=p.accel(t);
  real d=dot(a,v);
  real v2=v.abs2();
  real a2=a.abs2();
  real denom=v2*a2-d*d;
  real r=v2*sqrt(v2);
  {Stack->push<real>(denom > 0 ? r/sqrt(denom) : 0.0); return;}
}

#line 2779 "runtime.in"
// real radius(triple z0, triple c0, triple c1, triple z1, real t);
void gen199(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  triple z1=vm::pop<triple>(Stack);
  triple c1=vm::pop<triple>(Stack);
  triple c0=vm::pop<triple>(Stack);
  triple z0=vm::pop<triple>(Stack);
#line 2780 "runtime.in"
  triple v=(3.0*(z1-z0)+9.0*(c0-c1))*t*t+(6.0*(z0+c1)-12.0*c0)*t+3.0*(c0-z0);
  triple a=6.0*(z1-z0+3.0*(c0-c1))*t+6.0*(z0+c1)-12.0*c0;
  real d=dot(a,v);
  real v2=v.abs2();
  real a2=a.abs2();
  real denom=v2*a2-d*d;
  real r=v2*sqrt(v2);
  {Stack->push<real>(denom > 0 ? r/sqrt(denom) : 0.0); return;}
}

#line 2791 "runtime.in"
// path3 reverse(path3 p);
void gen200(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2792 "runtime.in"
  {Stack->push<path3>(p.reverse()); return;}
}

#line 2796 "runtime.in"
// path3 subpath(path3 p, Int a, Int b);
void gen201(stack *Stack)
{
  Int b=vm::pop<Int>(Stack);
  Int a=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2797 "runtime.in"
  {Stack->push<path3>(p.subpath((Int) a, (Int) b)); return;}
}

#line 2801 "runtime.in"
// path3 subpath(path3 p, real a, real b);
void gen202(stack *Stack)
{
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2802 "runtime.in"
  {Stack->push<path3>(p.subpath(a,b)); return;}
}

#line 2806 "runtime.in"
// Int length(path3 p);
void gen203(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2807 "runtime.in"
  {Stack->push<Int>(p.length()); return;}
}

#line 2811 "runtime.in"
// bool cyclic(path3 p);
void gen204(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2812 "runtime.in"
  {Stack->push<bool>(p.cyclic()); return;}
}

#line 2816 "runtime.in"
// bool straight(path3 p, Int t);
void gen205(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2817 "runtime.in"
  {Stack->push<bool>(p.straight(t)); return;}
}

// Return the component of vector v perpendicular to a unit vector u.
#line 2822 "runtime.in"
// triple perp(triple v, triple u);
void gen206(stack *Stack)
{
  triple u=vm::pop<triple>(Stack);
  triple v=vm::pop<triple>(Stack);
#line 2823 "runtime.in"
  {Stack->push<triple>(v-dot(v,u)*u); return;}
}

// Return the maximum perpendicular deviation of segment i of path3 g
// from a straight line.
#line 2829 "runtime.in"
// real straightness(path3 p, Int t);
void gen207(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2830 "runtime.in"
  if(p.straight(t)) {Stack->push<real>(0); return;}
  triple z0=p.point(t);
  triple u=unit(p.point(t+1)-z0);
  {Stack->push<real>(::max(length(perp(p.postcontrol(t)-z0,u)),
               length(perp(p.precontrol(t+1)-z0,u)))); return;}
}

// Return the maximum perpendicular deviation of z0..controls c0 and c1..z1
// from a straight line.
#line 2840 "runtime.in"
// real straightness(triple z0, triple c0, triple c1, triple z1);
void gen208(stack *Stack)
{
  triple z1=vm::pop<triple>(Stack);
  triple c1=vm::pop<triple>(Stack);
  triple c0=vm::pop<triple>(Stack);
  triple z0=vm::pop<triple>(Stack);
#line 2841 "runtime.in"
  triple u=unit(z1-z0);
  {Stack->push<real>(::max(length(perp(c0-z0,u)),length(perp(c1-z0,u)))); return;}
}

#line 2846 "runtime.in"
// bool piecewisestraight(path3 p);
void gen209(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2847 "runtime.in"
  {Stack->push<bool>(p.piecewisestraight()); return;}
}

#line 2851 "runtime.in"
// real arclength(path3 p);
void gen210(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2852 "runtime.in"
  {Stack->push<real>(p.arclength()); return;}
}

#line 2856 "runtime.in"
// real arctime(path3 p, real dval);
void gen211(stack *Stack)
{
  real dval=vm::pop<real>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2857 "runtime.in"
  {Stack->push<real>(p.arctime(dval)); return;}
}

#line 2861 "runtime.in"
// realarray* intersect(path3 p, path3 q, real fuzz=-1);
void gen212(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  path3 q=vm::pop<path3>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2862 "runtime.in"
  bool exact=fuzz <= 0.0;
  if(fuzz < 0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(q.max()),length(q.min())));
  
  std::vector<real> S,T;
  real s,t;
  if(intersections(s,t,S,T,p,q,fuzz,true,exact)) {
    array *V=new array(2);
    (*V)[0]=s;
    (*V)[1]=t;
    {Stack->push<realarray*>(V); return;}
  } else
    {Stack->push<realarray*>(new array(0)); return;}
}

#line 2879 "runtime.in"
// realarray2* intersections(path3 p, path3 q, real fuzz=-1);
void gen213(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  path3 q=vm::pop<path3>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2880 "runtime.in"
  bool exact=fuzz <= 0.0;
  if(fuzz < 0)
    fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                       ::max(length(q.max()),length(q.min())));
  bool single=!exact;
  
  real s,t;
  std::vector<real> S,T;
  bool found=intersections(s,t,S,T,p,q,fuzz,single,exact);
  if(!found) {Stack->push<realarray2*>(new array(0)); return;}
  array *V;
  if(single) {
    V=new array(1);
    array *Vi=new array(2);
    (*V)[0]=Vi;
    (*Vi)[0]=s;
    (*Vi)[1]=t;
  } else {
    size_t n=S.size();
    V=new array(n);
    for(size_t i=0; i < n; ++i) {
      array *Vi=new array(2);
      (*V)[i]=Vi;
      (*Vi)[0]=S[i];
      (*Vi)[1]=T[i];
    }
  }
  stable_sort(V->begin(),V->end(),run::compare2<real>());
  {Stack->push<realarray2*>(V); return;}
}

#line 2912 "runtime.in"
// realarray2* intersections(path3 p, triplearray2 *P, real fuzz=-1);
void gen214(stack *Stack)
{
  real fuzz=vm::pop<real>(Stack,-1);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2913 "runtime.in"
  triple *A=copyTripleArray2C(P,true,4);
  if(fuzz <= 0) fuzz=BigFuzz*::max(::max(length(p.max()),length(p.min())),
                                   norm(A,16));
  std::vector<real> T,U,V;
  intersections(T,U,V,p,A,fuzz);
  delete[] A;
  size_t n=T.size();
  array *W=new array(n);
  for(size_t i=0; i < n; ++i) {
    array *Wi=new array(3);
    (*W)[i]=Wi;
    (*Wi)[0]=T[i];
    (*Wi)[1]=U[i];
    (*Wi)[2]=V[i];
  }
  {Stack->push<realarray2*>(W); return;} // Sorting will done in asy.
}

#line 2932 "runtime.in"
// Int size(path3 p);
void gen215(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2933 "runtime.in"
  {Stack->push<Int>(p.size()); return;}
}

#line 2937 "runtime.in"
// path3 &(path3 p, path3 q);
void gen216(stack *Stack)
{
  path3 q=vm::pop<path3>(Stack);
  path3 p=vm::pop<path3>(Stack);
#line 2938 "runtime.in"
  {Stack->push<path3>(camp::concat(p,q)); return;}
}

#line 2942 "runtime.in"
// triple min(path3 p);
void gen217(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2943 "runtime.in"
  {Stack->push<triple>(p.min()); return;}
}

#line 2947 "runtime.in"
// triple max(path3 p);
void gen218(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2948 "runtime.in"
  {Stack->push<triple>(p.max()); return;}
}

#line 2952 "runtime.in"
// realarray* mintimes(path3 p);
void gen219(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2953 "runtime.in"
  array *V=new array(3);
  triple v=p.mintimes();
  (*V)[0]=v.getx();
  (*V)[1]=v.gety();
  (*V)[2]=v.getz();
  {Stack->push<realarray*>(V); return;}
}

#line 2962 "runtime.in"
// realarray* maxtimes(path3 p);
void gen220(stack *Stack)
{
  path3 p=vm::pop<path3>(Stack);
#line 2963 "runtime.in"
  array *V=new array(3);
  triple v=p.maxtimes();
  (*V)[0]=v.getx();
  (*V)[1]=v.gety();
  (*V)[2]=v.getz();
  {Stack->push<realarray*>(V); return;}
}

#line 2972 "runtime.in"
// path3 *(realarray2 *t, path3 g);
void gen221(stack *Stack)
{
  path3 g=vm::pop<path3>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
#line 2973 "runtime.in"
  {Stack->push<path3>(transformed(*t,g)); return;}
}


// Guide operations
#line 2979 "runtime.in"
void nullGuide(stack *Stack)
{
#line 2980 "runtime.in"
  {Stack->push<guide*>(new pathguide(path())); return;}
}

#line 2985 "runtime.in"
void dotsGuide(stack *Stack)
{
  guidearray * a=vm::pop<guidearray *>(Stack);
#line 2986 "runtime.in"
  guidevector v;
  size_t size=checkArray(a);
  for (size_t i=0; i < size; ++i)
    v.push_back(a->read<guide*>(i));

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 2995 "runtime.in"
void dashesGuide(stack *Stack)
{
  guidearray * a=vm::pop<guidearray *>(Stack);
#line 2996 "runtime.in"
  static camp::curlSpec curly;
  static specguide curlout(&curly, camp::OUT);
  static specguide curlin(&curly, camp::IN);

  size_t n=checkArray(a);

  // a--b is equivalent to a{curl 1}..{curl 1}b
  guidevector v;
  if (n > 0)
    v.push_back(a->read<guide*>(0));

  if (n==1) {
    v.push_back(&curlout);
    v.push_back(&curlin);
  }
  else
    for (size_t i=1; i<n; ++i) {
      v.push_back(&curlout);
      v.push_back(&curlin);
      v.push_back(a->read<guide*>(i));
    }

  {Stack->push<guide*>(new multiguide(v)); return;}
}

#line 3022 "runtime.in"
void newCycleToken(stack *Stack)
{
#line 3023 "runtime.in"
  {Stack->push<cycleToken>(cycleToken()); return;}
}

#line 3027 "runtime.in"
// guide* operator cast(cycleToken tok);
void gen226(stack *Stack)
{
  cycleToken tok=vm::pop<cycleToken>(Stack);
#line 3028 "runtime.in"
// Avoid unused variable warning messages.
  unused(&tok);
  {Stack->push<guide*>(new cycletokguide()); return;}
}

#line 3034 "runtime.in"
// guide* operator spec(pair z, Int p);
void gen227(stack *Stack)
{
  Int p=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 3035 "runtime.in"
  camp::side d=(camp::side) p;
  camp::dirSpec *sp=new camp::dirSpec(z);

  {Stack->push<guide*>(new specguide(sp,d)); return;}
}

#line 3042 "runtime.in"
// curlSpecifier operator curl(real gamma, Int p);
void gen228(stack *Stack)
{
  Int p=vm::pop<Int>(Stack);
  real gamma=vm::pop<real>(Stack);
#line 3043 "runtime.in"
  camp::side s=(camp::side) p;
  {Stack->push<curlSpecifier>(curlSpecifier(gamma,s)); return;}
}

#line 3048 "runtime.in"
void curlSpecifierValuePart(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 3049 "runtime.in"
  {Stack->push<real>(spec.getValue()); return;}
}

#line 3053 "runtime.in"
void curlSpecifierSidePart(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 3054 "runtime.in"
  {Stack->push<Int>(spec.getSide()); return;}
}

#line 3058 "runtime.in"
// guide* operator cast(curlSpecifier spec);
void gen231(stack *Stack)
{
  curlSpecifier spec=vm::pop<curlSpecifier>(Stack);
#line 3059 "runtime.in"
  {Stack->push<guide*>(new specguide(spec)); return;}
}

#line 3063 "runtime.in"
// tensionSpecifier operator tension(real tout, real tin, bool atleast);
void gen232(stack *Stack)
{
  bool atleast=vm::pop<bool>(Stack);
  real tin=vm::pop<real>(Stack);
  real tout=vm::pop<real>(Stack);
#line 3064 "runtime.in"
  {Stack->push<tensionSpecifier>(tensionSpecifier(tout, tin, atleast)); return;}
}

#line 3068 "runtime.in"
void tensionSpecifierOutPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 3069 "runtime.in"
  {Stack->push<real>(t.getOut()); return;}
}

#line 3073 "runtime.in"
void tensionSpecifierInPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 3074 "runtime.in"
  {Stack->push<real>(t.getIn()); return;}
}

#line 3078 "runtime.in"
void tensionSpecifierAtleastPart(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 3079 "runtime.in"
  {Stack->push<bool>(t.getAtleast()); return;}
}

#line 3083 "runtime.in"
// guide* operator cast(tensionSpecifier t);
void gen236(stack *Stack)
{
  tensionSpecifier t=vm::pop<tensionSpecifier>(Stack);
#line 3084 "runtime.in"
  {Stack->push<guide*>(new tensionguide(t)); return;}
}

#line 3088 "runtime.in"
// guide* operator controls(pair zout, pair zin);
void gen237(stack *Stack)
{
  pair zin=vm::pop<pair>(Stack);
  pair zout=vm::pop<pair>(Stack);
#line 3089 "runtime.in"
  {Stack->push<guide*>(new controlguide(zout, zin)); return;}
}

#line 3093 "runtime.in"
// Int size(guide *g);
void gen238(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 3094 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<Int>(f.size()); return;}
}

#line 3100 "runtime.in"
// Int length(guide *g);
void gen239(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 3101 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<Int>(g->cyclic() ? f.size() : f.size()-1); return;}
}

#line 3107 "runtime.in"
// bool cyclic(guide *g);
void gen240(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 3108 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<bool>(g->cyclic()); return;}
}

#line 3114 "runtime.in"
// pair point(guide *g, Int t);
void gen241(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 3115 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  {Stack->push<pair>(f.Nodes(adjustedIndex(t,f.size(),g->cyclic())).z); return;}
}

#line 3121 "runtime.in"
// pairarray* dirSpecifier(guide *g, Int t);
void gen242(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 3122 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<pairarray*>(new array(0)); return;}
  array *c=new array(2);
  (*c)[0]=f.Nodes(t).out->dir();
  (*c)[1]=f.Nodes(t+1).in->dir();
  {Stack->push<pairarray*>(c); return;}
}

#line 3133 "runtime.in"
// pairarray* controlSpecifier(guide *g, Int t);
void gen243(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 3134 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<pairarray*>(new array(0)); return;}
  knot curr=f.Nodes(t);
  knot next=f.Nodes(t+1);
  if(curr.out->controlled()) {
    assert(next.in->controlled());
    array *c=new array(2);
    (*c)[0]=curr.out->control();
    (*c)[1]=next.in->control();
    {Stack->push<pairarray*>(c); return;}
  } else {Stack->push<pairarray*>(new array(0)); return;}
}

#line 3150 "runtime.in"
// tensionSpecifier tensionSpecifier(guide *g, Int t);
void gen244(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 3151 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<tensionSpecifier>(tensionSpecifier(1.0,1.0,false)); return;}
  knot curr=f.Nodes(t);
  {Stack->push<tensionSpecifier>(tensionSpecifier(curr.tout.val,f.Nodes(t+1).tin.val,curr.tout.atleast)); return;}
}

#line 3160 "runtime.in"
// realarray* curlSpecifier(guide *g, Int t);
void gen245(stack *Stack)
{
  Int t=vm::pop<Int>(Stack);
  guide * g=vm::pop<guide *>(Stack);
#line 3161 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  Int n=f.size();
  if(!g->cyclic() && (t < 0 || t >= n-1)) {Stack->push<realarray*>(new array(0)); return;}
  array *c=new array(2);
  real c0=f.Nodes(t).out->curl();
  real c1=f.Nodes(t+1).in->curl();
  (*c)[0]=c0 >= 0.0 ? c0 : 1.0;
  (*c)[1]=c1 >= 0.0 ? c1 : 1.0;
  {Stack->push<realarray*>(c); return;}
}

#line 3174 "runtime.in"
// guide* reverse(guide *g);
void gen246(stack *Stack)
{
  guide * g=vm::pop<guide *>(Stack);
#line 3175 "runtime.in"
  flatguide f;
  g->flatten(f,false);
  if(f.precyclic())
    {Stack->push<guide*>(new pathguide(g->solve().reverse())); return;}

  size_t n=f.size();
  bool cyclic=g->cyclic();
  guidevector v;
  if(n >= 0) {
    size_t start=cyclic ? n : n-1;
    knot curr=f.Nodes(start);
    knot next;
    for(size_t i=start; i > 0; --i) {
      next=f.Nodes(i-1);
      v.push_back(new pairguide(curr.z));
      if(next.out->controlled()) {
        assert(curr.in->controlled());
        v.push_back(new controlguide(curr.in->control(),next.out->control()));
      } else {
        pair d=curr.in->dir();
        if(d != zero) 
          v.push_back(new specguide(new dirSpec(-d),camp::OUT));
        else {
          real C=curr.in->curl();
          if(C >= 0.0)
            v.push_back(new specguide(new curlSpec(C),camp::OUT));
        }
        real tout=curr.tin.val;
        real tin=next.tout.val;
        bool atleast=next.tout.atleast;
        if(tout != 1.0 || tin != 1.0 || next.tout.atleast)
          v.push_back(new tensionguide(tensionSpecifier(tout,tin,atleast)));
        d=next.out->dir();      
        if(d != zero) 
          v.push_back(new specguide(new dirSpec(-d),camp::IN));
        else {
          real C=next.out->curl();
          if(C >= 0.0)
            v.push_back(new specguide(new curlSpec(C),camp::IN));
        }
      }
      curr=next;
    }
    if(cyclic)
      v.push_back(new cycletokguide());
    else
      v.push_back(new pairguide(next.z));
      
  }
  {Stack->push<guide*>(new multiguide(v)); return;}
}


// Three-dimensional picture and surface operations
#line 3230 "runtime.in"
// void _draw(picture *f, path3 g, pen p);
void gen247(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  path3 g=vm::pop<path3>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 3231 "runtime.in"
  if(g.size() > 0)
    f->append(new drawPath3(g,p));
}

#line 3237 "runtime.in"
// void draw(picture *f, triplearray2 *g, bool straight, penarray *p, real opacity,          real shininess, real granularity, triple normal, bool lighton,          penarray *colors);
void gen248(stack *Stack)
{
  penarray * colors=vm::pop<penarray *>(Stack);
  bool lighton=vm::pop<bool>(Stack);
  triple normal=vm::pop<triple>(Stack);
  real granularity=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  bool straight=vm::pop<bool>(Stack);
  triplearray2 * g=vm::pop<triplearray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 3240 "runtime.in"
  f->append(new drawSurface(*g,straight,*p,opacity,shininess,granularity,
                            normal,lighton,*colors));
}

#line 3245 "runtime.in"
// triple min3(picture *f);
void gen249(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 3246 "runtime.in"
  {Stack->push<triple>(f->bounds3().Min()); return;}
}

#line 3250 "runtime.in"
// triple max3(picture *f);
void gen250(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 3251 "runtime.in"
  {Stack->push<triple>(f->bounds3().Max()); return;}
}

#line 3255 "runtime.in"
// pair min(picture *f, realarray2 *t);
void gen251(stack *Stack)
{
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 3256 "runtime.in"
  real *T=copyArray2C(t,4);
  pair m=f->bounds(::min,xproject,yproject,T);
  delete[] T;
  {Stack->push<pair>(m); return;}
}

#line 3263 "runtime.in"
// pair max(picture *f, realarray2 *t);
void gen252(stack *Stack)
{
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 3264 "runtime.in"
  real *T=copyArray2C(t,4);
  pair M=f->bounds(::max,xproject,yproject,T);
  delete[] T;
  {Stack->push<pair>(M); return;}
}

#line 3271 "runtime.in"
// pair minratio(picture *f);
void gen253(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 3272 "runtime.in"
  {Stack->push<pair>(f->bounds(::min,xratio,yratio)); return;}
}

#line 3276 "runtime.in"
// pair maxratio(picture *f);
void gen254(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 3277 "runtime.in"
  {Stack->push<pair>(f->bounds(::max,xratio,yratio)); return;}
}

#line 3281 "runtime.in"
// triple minbound(triplearray2 *P, triple b);
void gen255(stack *Stack)
{
  triple b=vm::pop<triple>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
#line 3282 "runtime.in"
  real *A=copyTripleArray2Components(P,true,4);
  b=triple(bound(A,::min,b.getx(),sqrtFuzz*norm(A,16)),
           bound(A+16,::min,b.gety(),sqrtFuzz*norm(A+16,16)),
           bound(A+32,::min,b.getz(),sqrtFuzz*norm(A+32,16)));
  delete[] A;
  {Stack->push<triple>(b); return;}
}

#line 3291 "runtime.in"
// triple maxbound(triplearray2 *P, triple b);
void gen256(stack *Stack)
{
  triple b=vm::pop<triple>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
#line 3292 "runtime.in"
  real *A=copyTripleArray2Components(P,true,4);
  b=triple(bound(A,::max,b.getx(),sqrtFuzz*norm(A,16)),
           bound(A+16,::max,b.gety(),sqrtFuzz*norm(A+16,16)),
           bound(A+32,::max,b.getz(),sqrtFuzz*norm(A+32,16)));
  delete[] A;
  {Stack->push<triple>(b); return;}
}

#line 3301 "runtime.in"
// pair minbound(triplearray2 *P, realarray2 *t, pair b);
void gen257(stack *Stack)
{
  pair b=vm::pop<pair>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
#line 3302 "runtime.in"
  triple *A=copyTripleArray2C(P,true,4);
  real *T=copyArray2C(t,4);
  real fuzz=sqrtFuzz*norm(A,16);
  b=pair(bound(A,::min,xproject,T,b.getx(),fuzz),
         bound(A,::min,yproject,T,b.gety(),fuzz));
  delete[] T;
  delete[] A;
  {Stack->push<pair>(b); return;}
}

#line 3313 "runtime.in"
// pair maxbound(triplearray2 *P, realarray2 *t, pair b);
void gen258(stack *Stack)
{
  pair b=vm::pop<pair>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
#line 3314 "runtime.in"
  triple *A=copyTripleArray2C(P,true,4);
  real *T=copyArray2C(t,4);
  real fuzz=sqrtFuzz*norm(A,16);
  b=pair(bound(A,::max,xproject,T,b.getx(),fuzz),
         bound(A,::max,yproject,T,b.gety(),fuzz));
  delete[] T;
  delete[] A;
  {Stack->push<pair>(b); return;}
}

#line 3325 "runtime.in"
// pair max(path3 g, realarray2 *t);
void gen259(stack *Stack)
{
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  path3 g=vm::pop<path3>(Stack);
#line 3326 "runtime.in"
  real *T=copyArray2C(t,4);
  pair b=g.bounds(::max,xproject,yproject,T);
  delete[] T;
  {Stack->push<pair>(b); return;}
}

#line 3333 "runtime.in"
// pair min(path3 g, realarray2 *t);
void gen260(stack *Stack)
{
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  path3 g=vm::pop<path3>(Stack);
#line 3334 "runtime.in"
  real *T=copyArray2C(t,4);
  pair b=g.bounds(::min,xproject,yproject,T);
  delete[] T;
  {Stack->push<pair>(b); return;}
}

#line 3341 "runtime.in"
// real change2(triplearray2 *a);
void gen261(stack *Stack)
{
  triplearray2 * a=vm::pop<triplearray2 *>(Stack);
#line 3342 "runtime.in"
  size_t n=checkArray(a);
  if(n == 0) {Stack->push<real>(0.0); return;}
  
  vm::array *a0=vm::read<vm::array*>(a,0);
  size_t m=checkArray(a0);
  if(m == 0) {Stack->push<real>(0.0); return;}
  triple a00=vm::read<triple>(a0,0);
  real M=0.0;
    
  for(size_t i=0; i < n; ++i) {
    vm::array *ai=vm::read<vm::array*>(a,i);
    size_t m=checkArray(ai);
    for(size_t j=0; j < m; ++j) {
      real a=(vm::read<triple>(ai,j)-a00).abs2();
      if(a > M) M=a;
    }
  }
  {Stack->push<real>(M); return;}
}

#line 3363 "runtime.in"
// bool is3D(picture *f);
void gen262(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 3364 "runtime.in"
  {Stack->push<bool>(f->have3D()); return;}
}

#line 3368 "runtime.in"
// pair bezier(pair a, pair b, pair c, pair d, real t);
void gen263(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  pair d=vm::pop<pair>(Stack);
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 3369 "runtime.in"
  real onemt=1-t;
  real onemt2=onemt*onemt;
  {Stack->push<pair>(onemt2*onemt*a+t*(3.0*(onemt2*b+t*onemt*c)+t*t*d)); return;}
}

#line 3375 "runtime.in"
// pair bezierP(pair a, pair b, pair c, pair d, real t);
void gen264(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  pair d=vm::pop<pair>(Stack);
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 3376 "runtime.in"
  {Stack->push<pair>(3.0*(t*t*(d-a+3.0*(b-c))+t*(2.0*(a+c)-4.0*b)+b-a)); return;}
}

#line 3380 "runtime.in"
// pair bezierPP(pair a, pair b, pair c, pair d, real t);
void gen265(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  pair d=vm::pop<pair>(Stack);
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 3381 "runtime.in"
  {Stack->push<pair>(6.0*(t*(d-a+3.0*(b-c))+a+c-2.0*b)); return;}
}

#line 3385 "runtime.in"
// pair bezierPPP(pair a, pair b, pair c, pair d);
void gen266(stack *Stack)
{
  pair d=vm::pop<pair>(Stack);
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 3386 "runtime.in"
  {Stack->push<pair>(6.0*(d-a+3.0*(b-c))); return;}
}

#line 3390 "runtime.in"
// triple bezier(triple a, triple b, triple c, triple d, real t);
void gen267(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  triple d=vm::pop<triple>(Stack);
  triple c=vm::pop<triple>(Stack);
  triple b=vm::pop<triple>(Stack);
  triple a=vm::pop<triple>(Stack);
#line 3391 "runtime.in"
  real onemt=1-t;
  real onemt2=onemt*onemt;
  {Stack->push<triple>(onemt2*onemt*a+t*(3.0*(onemt2*b+t*onemt*c)+t*t*d)); return;}
}

#line 3397 "runtime.in"
// triple bezierP(triple a, triple b, triple c, triple d, real t);
void gen268(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  triple d=vm::pop<triple>(Stack);
  triple c=vm::pop<triple>(Stack);
  triple b=vm::pop<triple>(Stack);
  triple a=vm::pop<triple>(Stack);
#line 3398 "runtime.in"
  {Stack->push<triple>(3.0*(t*t*(d-a+3.0*(b-c))+t*(2.0*(a+c)-4.0*b)+b-a)); return;}
}

#line 3402 "runtime.in"
// triple bezierPP(triple a, triple b, triple c, triple d, real t);
void gen269(stack *Stack)
{
  real t=vm::pop<real>(Stack);
  triple d=vm::pop<triple>(Stack);
  triple c=vm::pop<triple>(Stack);
  triple b=vm::pop<triple>(Stack);
  triple a=vm::pop<triple>(Stack);
#line 3403 "runtime.in"
  {Stack->push<triple>(6.0*(t*(d-a+3.0*(b-c))+a+c-2.0*b)); return;}
}

#line 3407 "runtime.in"
// triple bezierPPP(triple a, triple b, triple c, triple d);
void gen270(stack *Stack)
{
  triple d=vm::pop<triple>(Stack);
  triple c=vm::pop<triple>(Stack);
  triple b=vm::pop<triple>(Stack);
  triple a=vm::pop<triple>(Stack);
#line 3408 "runtime.in"
  {Stack->push<triple>(6.0*(d-a+3.0*(b-c))); return;}
}


// String operations
#line 3414 "runtime.in"
void emptyString(stack *Stack)
{
#line 3415 "runtime.in"
  {Stack->push<string>(emptystring); return;}
}

#line 3420 "runtime.in"
// Int length(string *s);
void gen272(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 3421 "runtime.in"
  {Stack->push<Int>((Int) s->length()); return;}
}

#line 3425 "runtime.in"
// Int find(string *s, string t, Int pos=0);
void gen273(stack *Stack)
{
  Int pos=vm::pop<Int>(Stack,0);
  string t=vm::pop<string>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 3426 "runtime.in"
  size_t n=s->find(t,pos);
  {Stack->push<Int>(n == string::npos ? (Int) -1 : (Int) n); return;}
}

#line 3431 "runtime.in"
// Int rfind(string *s, string t, Int pos=-1);
void gen274(stack *Stack)
{
  Int pos=vm::pop<Int>(Stack,-1);
  string t=vm::pop<string>(Stack);
  string * s=vm::pop<string *>(Stack);
#line 3432 "runtime.in"
  size_t n=s->rfind(t,pos);
  {Stack->push<Int>(n == string::npos ? (Int) -1 : (Int) n); return;}
}

#line 3437 "runtime.in"
// string reverse(string s);
void gen275(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 3438 "runtime.in"
  reverse(s.begin(),s.end());
  {Stack->push<string>(s); return;}
}

#line 3443 "runtime.in"
// string insert(string s, Int pos, string t);
void gen276(stack *Stack)
{
  string t=vm::pop<string>(Stack);
  Int pos=vm::pop<Int>(Stack);
  string s=vm::pop<string>(Stack);
#line 3444 "runtime.in"
  if ((size_t) pos < s.length())
    {Stack->push<string>(s.insert(pos,t)); return;}
  {Stack->push<string>(s); return;}
}

#line 3450 "runtime.in"
// string substr(string* s, Int pos, Int n=-1);
void gen277(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,-1);
  Int pos=vm::pop<Int>(Stack);
  string* s=vm::pop<string*>(Stack);
#line 3451 "runtime.in"
  if ((size_t) pos < s->length())
    {Stack->push<string>(s->substr(pos,n)); return;}
  {Stack->push<string>(emptystring); return;}
}

#line 3457 "runtime.in"
// string erase(string s, Int pos, Int n);
void gen278(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  Int pos=vm::pop<Int>(Stack);
  string s=vm::pop<string>(Stack);
#line 3458 "runtime.in"
  if ((size_t) pos < s.length())
    {Stack->push<string>(s.erase(pos,n)); return;}
  {Stack->push<string>(s); return;} 
}

#line 3464 "runtime.in"
// string downcase(string s);
void gen279(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 3465 "runtime.in"
  std::transform(s.begin(),s.end(),s.begin(),tolower);
  {Stack->push<string>(s); return;}
}

#line 3470 "runtime.in"
// string upcase(string s);
void gen280(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 3471 "runtime.in"
  std::transform(s.begin(),s.end(),s.begin(),toupper);
  {Stack->push<string>(s); return;}
}

// returns a string constructed by translating all occurrences of the string
// from in an array of string pairs {from,to} to the string to in string s.
#line 3478 "runtime.in"
// string replace(string *S, stringarray2 *translate);
void gen281(stack *Stack)
{
  stringarray2 * translate=vm::pop<stringarray2 *>(Stack);
  string * S=vm::pop<string *>(Stack);
#line 3479 "runtime.in"
  size_t size=checkArray(translate);
  for(size_t i=0; i < size; i++) {
    array *a=read<array*>(translate,i);
    checkArray(a);
  }
  const char *p=S->c_str();
  ostringstream buf;
  while(*p) {
    for(size_t i=0; i < size;) {
      array *a=read<array*>(translate,i);
      string* from=read<string*>(a,0);
      size_t len=from->length();
      if(strncmp(p,from->c_str(),len) != 0) {i++; continue;}
      buf << read<string>(a,1);
      p += len;
      if(*p == 0) {Stack->push<string>(buf.str()); return;}
      i=0;
    }
    buf << *(p++);
  }
  {Stack->push<string>(buf.str()); return;}
}

#line 3503 "runtime.in"
// string format(string *format, Int x);
void gen282(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
  string * format=vm::pop<string *>(Stack);
#line 3504 "runtime.in"
  const char *f=format->c_str();
  
  checkformat(f,true);
  
  Int size=snprintf(NULL,0,f,x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f,x);
  string s=string(buf);
  delete[] buf;
  {Stack->push<string>(s); return;}
}

#line 3518 "runtime.in"
// string format(string *format, real x, string locale=emptystring);
void gen283(stack *Stack)
{
  string locale=vm::pop<string>(Stack,emptystring);
  real x=vm::pop<real>(Stack);
  string * format=vm::pop<string *>(Stack);
#line 3519 "runtime.in"
  bool tex=getSetting<string>("tex") != "none";
  bool texify=false;
  ostringstream out;
  
  checkformat(format->c_str(),false);

  const char *phantom="\\phantom{+}";
  const char *p0=format->c_str();
  
  const char *p=p0;
  const char *start=NULL;
  char prev=0;
  while(*p != 0) {
    char curr=*p;
    if(tex && curr == '$' && prev != '\\') texify=true;
    prev=curr;
    if(curr == '%') {
      p++;
      if(*p != '%') {start=p-1; break;}
    }
    out << *(p++);
  }
  
  if(!start) {Stack->push<string>(out.str()); return;}
  
  // Allow at most 1 argument  
  while(*p != 0) {
    if(*p == '*' || *p == '$') {Stack->push<string>(out.str()); return;}
    if(isupper(*p) || islower(*p)) {p++; break;}
    p++;
  }
  
  const char *tail=p;
  string f=format->substr(start-p0,tail-start);

  const char *oldlocale=NULL;
  if(!locale.empty()) {
    oldlocale=setlocale(LC_ALL,NULL);
    if(oldlocale) oldlocale=StrdupNoGC(oldlocale);
    setlocale(LC_ALL,locale.c_str());
  }

  Int size=snprintf(NULL,0,f.c_str(),x)+1;
  if(size < 1) size=255; // Workaround for non-C99 compliant systems.
  char *buf=new char[size];
  snprintf(buf,size,f.c_str(),x);

  if(oldlocale) {
    setlocale(LC_ALL,oldlocale);
    delete[] oldlocale;
  }
  
  bool trailingzero=f.find("#") < string::npos;
  bool plus=f.find("+") < string::npos;
  bool space=f.find(" ") < string::npos;
  
  char *q=buf; // beginning of formatted number

  if(*q == ' ') {
    out << phantom;
    q++;
  }
  
  const char decimal=*(localeconv()->decimal_point);

  // Remove any spurious sign
  if(*q == '-' || *q == '+') {
    p=q+1;
    bool zero=true;
    while(*p != 0) {
      if(!isdigit(*p) && *p != decimal) break;
      if(isdigit(*p) && *p != '0') {zero=false; break;}
      p++;
    }
    if(zero) {
      q++;
      if(plus || space) out << phantom;
    }
  }
  
  const char *r=p=q;
  bool dp=false;
  while(*r != 0 && (isdigit(*r) || *r == decimal || *r == '+' || *r == '-')) {
    if(*r == decimal) dp=true;
    r++;
  }
  if(dp) { // Remove trailing zeros and/or decimal point
    r--;
    unsigned n=0;
    while(r > q && *r == '0') {r--; n++;}
    if(*r == decimal) {r--; n++;}
    while(q <= r) out << *(q++);
    if(!trailingzero) q += n;
  }
  
  bool zero=(r == p && *r == '0') && !trailingzero;
  
  // Translate "E+/E-/e+/e-" exponential notation to TeX
  while(*q != 0) {
    if(texify && (*q == 'E' || *q == 'e') && 
       (*(q+1) == '+' || *(q+1) == '-')) {
      if(!zero) out << "\\!\\times\\!10^{";
      bool plus=(*(q+1) == '+');
      q++;
      if(plus) q++;
      if(*q == '-') out << *(q++);
      while(*q == '0' && (zero || isdigit(*(q+1)))) q++;
      while(isdigit(*q)) out << *(q++);
      if(!zero)
        out << "}";
      break;
    }
    out << *(q++);
  }
  
  while(*tail != 0) 
    out << *(tail++);
  
  delete[] buf;

  {Stack->push<string>(out.str()); return;}
}

#line 3643 "runtime.in"
// Int hex(string s);
void gen284(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 3644 "runtime.in"
  istringstream is(s);
  is.setf(std::ios::hex,std::ios::basefield);
  Int value;
  if(is && is >> value && ((is >> std::ws).eof())) {Stack->push<Int>(value); return;}
  ostringstream buf;
  buf << "invalid hexidecimal cast from string \"" << s << "\"";
  error(buf);
}

#line 3654 "runtime.in"
// string string(Int x);
void gen285(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
#line 3655 "runtime.in"
  ostringstream buf;
  buf << x;
  {Stack->push<string>(buf.str()); return;}
}

#line 3661 "runtime.in"
// string string(real x, Int digits=DBL_DIG);
void gen286(stack *Stack)
{
  Int digits=vm::pop<Int>(Stack,DBL_DIG);
  real x=vm::pop<real>(Stack);
#line 3662 "runtime.in"
  ostringstream buf;
  buf.precision(digits);
  buf << x;
  {Stack->push<string>(buf.str()); return;}
}

#line 3669 "runtime.in"
// string time(string format=defaulttimeformat);
void gen287(stack *Stack)
{
  string format=vm::pop<string>(Stack,defaulttimeformat);
#line 3670 "runtime.in"
#ifdef HAVE_STRFTIME
  const time_t bintime=time(NULL);
  if(!strftime(Time,nTime,format.c_str(),localtime(&bintime))) {Stack->push<string>(""); return;}
  {Stack->push<string>(Time); return;}
#else
  {Stack->push<string>(format); return;}
#endif  
}

#line 3680 "runtime.in"
// string time(Int seconds, string format=defaulttimeformat);
void gen288(stack *Stack)
{
  string format=vm::pop<string>(Stack,defaulttimeformat);
  Int seconds=vm::pop<Int>(Stack);
#line 3681 "runtime.in"
#ifdef HAVE_STRFTIME
  const time_t bintime=seconds;
  if(!strftime(Time,nTime,format.c_str(),localtime(&bintime))) {Stack->push<string>(""); return;}
  {Stack->push<string>(Time); return;}
#else
// Avoid unused variable warning messages
  unused(&seconds);
  {Stack->push<string>(format); return;}
#endif
}

#line 3693 "runtime.in"
// Int seconds(string t=emptystring, string format=emptystring);
void gen289(stack *Stack)
{
  string format=vm::pop<string>(Stack,emptystring);
  string t=vm::pop<string>(Stack,emptystring);
#line 3694 "runtime.in"
#if defined(HAVE_STRPTIME)
  const time_t bintime=time(NULL);
  tm tm=*localtime(&bintime);
  if(t != "" && !strptime(t.c_str(),format.c_str(),&tm)) {Stack->push<Int>(-1); return;}
  {Stack->push<Int>((Int) mktime(&tm)); return;}
#else
  {Stack->push<Int>(-1); return;}
#endif  
}

#line 3705 "runtime.in"
// realarray* _cputime();
void gen290(stack *Stack)
{
#line 3706 "runtime.in"
  static const real ticktime=1.0/sysconf(_SC_CLK_TCK);
  struct tms buf;

  ::times(&buf);
  array *t=new array(4);
  (*t)[0] = ((real) buf.tms_utime)*ticktime;
  (*t)[1] = ((real) buf.tms_stime)*ticktime;
  (*t)[2] = ((real) buf.tms_cutime)*ticktime;
  (*t)[3] = ((real) buf.tms_cstime)*ticktime;
  {Stack->push<realarray*>(t); return;}
}


// Math
#line 3721 "runtime.in"
// real ^(real x, Int y);
void gen291(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  real x=vm::pop<real>(Stack);
#line 3722 "runtime.in"
  {Stack->push<real>(pow(x,y)); return;}
}

#line 3727 "runtime.in"
// pair ^(pair z, Int y);
void gen292(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 3728 "runtime.in"
  {Stack->push<pair>(pow(z,y)); return;}
}

#line 3732 "runtime.in"
// Int quotient(Int x, Int y);
void gen293(stack *Stack)
{
  Int y=vm::pop<Int>(Stack);
  Int x=vm::pop<Int>(Stack);
#line 3733 "runtime.in" 
  if(y == 0) dividebyzero();
  if(y == -1) {Stack->push<Int>(Negate(x)); return;}
// Implementation-independent definition of integer division: round down
  {Stack->push<Int>((x-portableMod(x,y))/y); return;}
}

#line 3740 "runtime.in"
// Int abs(Int x);
void gen294(stack *Stack)
{
  Int x=vm::pop<Int>(Stack);
#line 3741 "runtime.in" 
  {Stack->push<Int>(Abs(x)); return;}
}

#line 3745 "runtime.in"
// Int sgn(real x);
void gen295(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3746 "runtime.in" 
  {Stack->push<Int>(sgn(x)); return;}
}

#line 3750 "runtime.in"
// Int rand();
void gen296(stack *Stack)
{
#line 3751 "runtime.in" 
  {Stack->push<Int>(rand()); return;}
}

#line 3755 "runtime.in"
// void srand(Int seed);
void gen297(stack *Stack)
{
  Int seed=vm::pop<Int>(Stack);
#line 3756 "runtime.in" 
  srand(intcast(seed));
}

// a random number uniformly distributed in the interval [0,1]
#line 3761 "runtime.in"
// real unitrand();
void gen298(stack *Stack)
{
#line 3762 "runtime.in"                         
  {Stack->push<real>(((real) rand())/RAND_MAX); return;}
}

#line 3766 "runtime.in"
// Int ceil(real x);
void gen299(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3767 "runtime.in" 
  {Stack->push<Int>(Intcast(ceil(x))); return;}
}

#line 3771 "runtime.in"
// Int floor(real x);
void gen300(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3772 "runtime.in" 
  {Stack->push<Int>(Intcast(floor(x))); return;}
}

#line 3776 "runtime.in"
// Int round(real x);
void gen301(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3777 "runtime.in" 
  if(validInt(x)) {Stack->push<Int>(Round(x)); return;}
  integeroverflow(0);
}

#line 3782 "runtime.in"
// Int Ceil(real x);
void gen302(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3783 "runtime.in" 
  {Stack->push<Int>(Ceil(x)); return;}
}

#line 3787 "runtime.in"
// Int Floor(real x);
void gen303(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3788 "runtime.in" 
  {Stack->push<Int>(Floor(x)); return;}
}

#line 3792 "runtime.in"
// Int Round(real x);
void gen304(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3793 "runtime.in" 
  {Stack->push<Int>(Round(Intcap(x))); return;}
}

#line 3797 "runtime.in"
// real fmod(real x, real y);
void gen305(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 3798 "runtime.in"
  if (y == 0.0) dividebyzero();
  {Stack->push<real>(fmod(x,y)); return;}
}

#line 3803 "runtime.in"
// real atan2(real y, real x);
void gen306(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
#line 3804 "runtime.in" 
  {Stack->push<real>(atan2(y,x)); return;}
}

#line 3808 "runtime.in"
// real hypot(real x, real y);
void gen307(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 3809 "runtime.in" 
  {Stack->push<real>(hypot(x,y)); return;}
}

#line 3813 "runtime.in"
// real remainder(real x, real y);
void gen308(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 3814 "runtime.in" 
  {Stack->push<real>(remainder(x,y)); return;}
}

#line 3818 "runtime.in"
// real J(Int n, real x);
void gen309(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 3819 "runtime.in"
  {Stack->push<real>(jn(n,x)); return;}
}

#line 3823 "runtime.in"
// real Y(Int n, real x);
void gen310(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 3824 "runtime.in"
  {Stack->push<real>(yn(n,x)); return;}
}

#line 3828 "runtime.in"
// real erf(real x);
void gen311(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3829 "runtime.in"
  {Stack->push<real>(erf(x)); return;}
}

#line 3833 "runtime.in"
// real erfc(real x);
void gen312(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3834 "runtime.in"
  {Stack->push<real>(erfc(x)); return;}
}

#line 3838 "runtime.in"
// Int factorial(Int n);
void gen313(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 3839 "runtime.in"
  if(n < 0) error(invalidargument);
  {Stack->push<Int>(factorial(n)); return;}
}

#line 3843 "runtime.in"
// Int choose(Int n, Int k);
void gen314(stack *Stack)
{
  Int k=vm::pop<Int>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 3844 "runtime.in"
  if(n < 0 || k < 0 || k > n) error(invalidargument);
  Int f=1;
  Int r=n-k;
  for(Int i=n; i > r; --i) {
    if(f > Int_MAX/i) integeroverflow(0);
    f=(f*i)/(n-i+1);
  }
  {Stack->push<Int>(f); return;}
}

#line 3854 "runtime.in"
// real gamma(real x);
void gen315(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 3855 "runtime.in"
#ifdef HAVE_TGAMMA
  {Stack->push<real>(tgamma(x)); return;}
#else
  real lg = lgamma(x);
  {Stack->push<real>(signgam*exp(lg)); return;}
#endif
}

// Complex Gamma function
#line 3865 "runtime.in"
// pair gamma(explicit pair z);
void gen316(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 3866 "runtime.in"
  {Stack->push<pair>(gamma(z)); return;}
}

#line 3870 "runtime.in"
// realarray* quadraticroots(real a, real b, real c);
void gen317(stack *Stack)
{
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 3871 "runtime.in"
  quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots == 2) (*roots)[1]=q.t2;
  {Stack->push<realarray*>(roots); return;}
}

#line 3879 "runtime.in"
// pairarray* quadraticroots(explicit pair a, explicit pair b, explicit pair c);
void gen318(stack *Stack)
{
  pair c=vm::pop<pair>(Stack);
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 3880 "runtime.in"
  Quadraticroots q(a,b,c);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.z1;
  if(q.roots == 2) (*roots)[1]=q.z2;
  {Stack->push<pairarray*>(roots); return;}
}

#line 3888 "runtime.in"
// realarray* cubicroots(real a, real b, real c, real d);
void gen319(stack *Stack)
{
  real d=vm::pop<real>(Stack);
  real c=vm::pop<real>(Stack);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
#line 3889 "runtime.in"
  cubicroots q(a,b,c,d);
  array *roots=new array(q.roots);
  if(q.roots >= 1) (*roots)[0]=q.t1;
  if(q.roots >= 2) (*roots)[1]=q.t2;
  if(q.roots == 3) (*roots)[2]=q.t3;
  {Stack->push<realarray*>(roots); return;}
}

  
// Transforms
#line 3900 "runtime.in"
// bool ==(transform a, transform b);
void gen320(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 3901 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 3906 "runtime.in"
// bool !=(transform a, transform b);
void gen321(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 3907 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 3911 "runtime.in"
// transform +(transform a, transform b);
void gen322(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 3912 "runtime.in"
  {Stack->push<transform>(a+b); return;}
}

#line 3916 "runtime.in"
// transform *(transform a, transform b);
void gen323(stack *Stack)
{
  transform b=vm::pop<transform>(Stack);
  transform a=vm::pop<transform>(Stack);
#line 3917 "runtime.in"
  {Stack->push<transform>(a*b); return;}
}

#line 3921 "runtime.in"
// pair *(transform t, pair z);
void gen324(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 3922 "runtime.in"
  {Stack->push<pair>(t*z); return;}
}

#line 3926 "runtime.in"
// path *(transform t, path g);
void gen325(stack *Stack)
{
  path g=vm::pop<path>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 3927 "runtime.in"
  {Stack->push<path>(transformed(t,g)); return;}
}

#line 3931 "runtime.in"
// pen *(transform t, pen p);
void gen326(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 3932 "runtime.in"
  {Stack->push<pen>(transformed(t,p)); return;}
}

#line 3936 "runtime.in"
// picture* *(transform t, picture *f);
void gen327(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 3937 "runtime.in"
  {Stack->push<picture*>(transformed(t,f)); return;}
}

#line 3941 "runtime.in"
// picture* *(realarray2 *t, picture *f);
void gen328(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
#line 3942 "runtime.in"
  {Stack->push<picture*>(transformed(*t,f)); return;}
}

#line 3946 "runtime.in"
// transform ^(transform t, Int n);
void gen329(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  transform t=vm::pop<transform>(Stack);
#line 3947 "runtime.in"
  transform T;
  if(n < 0) {
    n=-n;
    t=inverse(t);
  }
  for(Int i=0; i < n; i++) T=T*t;
  {Stack->push<transform>(T); return;}
}

#line 3957 "runtime.in"
void transformXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3958 "runtime.in"
  {Stack->push<real>(t.getx()); return;}
}

#line 3962 "runtime.in"
void transformYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3963 "runtime.in"
  {Stack->push<real>(t.gety()); return;}
}

#line 3967 "runtime.in"
void transformXXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3968 "runtime.in"
  {Stack->push<real>(t.getxx()); return;}
}

#line 3972 "runtime.in"
void transformXYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3973 "runtime.in"
  {Stack->push<real>(t.getxy()); return;}
}

#line 3977 "runtime.in"
void transformYXPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3978 "runtime.in"
  {Stack->push<real>(t.getyx()); return;}
}

#line 3982 "runtime.in"
void transformYYPart(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3983 "runtime.in"
  {Stack->push<real>(t.getyy()); return;}
}

#line 3987 "runtime.in"
void real6ToTransform(stack *Stack)
{
  real yy=vm::pop<real>(Stack);
  real yx=vm::pop<real>(Stack);
  real xy=vm::pop<real>(Stack);
  real xx=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 3989 "runtime.in"
  {Stack->push<transform>(transform(x,y,xx,xy,yx,yy)); return;}
}

#line 3993 "runtime.in"
// transform shift(transform t);
void gen337(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3994 "runtime.in"
  {Stack->push<transform>(transform(t.getx(),t.gety(),0,0,0,0)); return;}
}

#line 3998 "runtime.in"
// transform shiftless(transform t);
void gen338(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 3999 "runtime.in"
  {Stack->push<transform>(transform(0,0,t.getxx(),t.getxy(),t.getyx(),t.getyy())); return;}
}

#line 4003 "runtime.in"
// transform identity();
void transformIdentity(stack *Stack)
{
#line 4004 "runtime.in"
  {Stack->push<transform>(identity); return;}
}

#line 4008 "runtime.in"
// transform inverse(transform t);
void gen340(stack *Stack)
{
  transform t=vm::pop<transform>(Stack);
#line 4009 "runtime.in"
  {Stack->push<transform>(inverse(t)); return;}
}

#line 4013 "runtime.in"
// transform shift(pair z);
void gen341(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4014 "runtime.in"
  {Stack->push<transform>(shift(z)); return;}
}

#line 4018 "runtime.in"
// transform shift(real x, real y);
void gen342(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 4019 "runtime.in"
  {Stack->push<transform>(shift(pair(x,y))); return;}
}

#line 4023 "runtime.in"
// transform xscale(real x);
void gen343(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 4024 "runtime.in"
  {Stack->push<transform>(xscale(x)); return;}
}

#line 4028 "runtime.in"
// transform yscale(real y);
void gen344(stack *Stack)
{
  real y=vm::pop<real>(Stack);
#line 4029 "runtime.in"
  {Stack->push<transform>(yscale(y)); return;}
}

#line 4033 "runtime.in"
// transform scale(real x);
void gen345(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 4034 "runtime.in"
  {Stack->push<transform>(scale(x)); return;}
}

#line 4038 "runtime.in"
// transform scale(real x, real y);
void gen346(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 4039 "runtime.in"
  {Stack->push<transform>(xscale(x)*yscale(y)); return;}
}

#line 4043 "runtime.in"
// transform slant(real s);
void gen347(stack *Stack)
{
  real s=vm::pop<real>(Stack);
#line 4044 "runtime.in"
  {Stack->push<transform>(slant(s)); return;}
}

#line 4048 "runtime.in"
// transform rotate(real angle, pair z=0);
void gen348(stack *Stack)
{
  pair z=vm::pop<pair>(Stack,0);
  real angle=vm::pop<real>(Stack);
#line 4049 "runtime.in"
  {Stack->push<transform>(rotatearound(z,radians(angle))); return;}
}

#line 4053 "runtime.in"
// transform reflect(pair a, pair b);
void gen349(stack *Stack)
{
  pair b=vm::pop<pair>(Stack);
  pair a=vm::pop<pair>(Stack);
#line 4054 "runtime.in"
  {Stack->push<transform>(reflectabout(a,b)); return;}
}


// Pair operations
#line 4060 "runtime.in"
void pairZero(stack *Stack)
{
#line 4061 "runtime.in"
  {Stack->push<pair>(zero); return;}
}

#line 4066 "runtime.in"
void realRealToPair(stack *Stack)
{
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 4067 "runtime.in"
  {Stack->push<pair>(pair(x,y)); return;}
}

#line 4071 "runtime.in"
void pairNegate(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4072 "runtime.in"
  {Stack->push<pair>(-z); return;}
}

#line 4076 "runtime.in"
// real xpart(pair z);
void pairXPart(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4077 "runtime.in"
  {Stack->push<real>(z.getx()); return;}
}

#line 4081 "runtime.in"
// real ypart(pair z);
void pairYPart(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4082 "runtime.in"
  {Stack->push<real>(z.gety()); return;}
}

#line 4086 "runtime.in"
// real length(pair z);
void gen355(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4087 "runtime.in"
  {Stack->push<real>(z.length()); return;}
}

#line 4091 "runtime.in"
// real abs(pair z);
void gen356(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4092 "runtime.in"
  {Stack->push<real>(z.length()); return;}
}

#line 4096 "runtime.in"
// pair sqrt(explicit pair z);
void gen357(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4097 "runtime.in"
  {Stack->push<pair>(Sqrt(z)); return;}
}

// Return the angle of z in radians.
#line 4102 "runtime.in"
// real angle(pair z, bool warn=true);
void gen358(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  pair z=vm::pop<pair>(Stack);
#line 4103 "runtime.in"
  if(!warn && z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(z.angle()); return;}
}

// Return the angle of z in degrees in the interval [0,360).
#line 4109 "runtime.in"
// real degrees(pair z, bool warn=true);
void gen359(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  pair z=vm::pop<pair>(Stack);
#line 4110 "runtime.in"
  if(!warn && z.getx() == 0.0 && z.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(principalBranch(degrees(z.angle()))); return;}
}

// Convert degrees to radians.
#line 4116 "runtime.in"
// real radians(real degrees);
void gen360(stack *Stack)
{
  real degrees=vm::pop<real>(Stack);
#line 4117 "runtime.in"
  {Stack->push<real>(radians(degrees)); return;}
}

// Convert radians to degrees.
#line 4122 "runtime.in"
// real degrees(real radians);
void gen361(stack *Stack)
{
  real radians=vm::pop<real>(Stack);
#line 4123 "runtime.in"
  {Stack->push<real>(degrees(radians)); return;}
}

// Convert radians to degrees in [0,360).
#line 4128 "runtime.in"
// real Degrees(real radians);
void gen362(stack *Stack)
{
  real radians=vm::pop<real>(Stack);
#line 4129 "runtime.in"
  {Stack->push<real>(principalBranch(degrees(radians))); return;}
}

#line 4133 "runtime.in"
// real Sin(real deg);
void gen363(stack *Stack)
{
  real deg=vm::pop<real>(Stack);
#line 4134 "runtime.in"
  {Stack->push<real>(sin(radians(deg))); return;}
}

#line 4138 "runtime.in"
// real Cos(real deg);
void gen364(stack *Stack)
{
  real deg=vm::pop<real>(Stack);
#line 4139 "runtime.in"
  {Stack->push<real>(cos(radians(deg))); return;}
}

#line 4143 "runtime.in"
// real Tan(real deg);
void gen365(stack *Stack)
{
  real deg=vm::pop<real>(Stack);
#line 4144 "runtime.in"
  {Stack->push<real>(tan(radians(deg))); return;}
}

#line 4148 "runtime.in"
// real aSin(real x);
void gen366(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 4149 "runtime.in"
  {Stack->push<real>(degrees(asin(x))); return;}
}

#line 4153 "runtime.in"
// real aCos(real x);
void gen367(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 4154 "runtime.in"
  {Stack->push<real>(degrees(acos(x))); return;}
}

#line 4158 "runtime.in"
// real aTan(real x);
void gen368(stack *Stack)
{
  real x=vm::pop<real>(Stack);
#line 4159 "runtime.in"
  {Stack->push<real>(degrees(atan(x))); return;}
}

#line 4163 "runtime.in"
// pair unit(pair z);
void gen369(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4164 "runtime.in"
  {Stack->push<pair>(unit(z)); return;}
}

#line 4168 "runtime.in"
// pair dir(real degrees);
void gen370(stack *Stack)
{
  real degrees=vm::pop<real>(Stack);
#line 4169 "runtime.in"
  {Stack->push<pair>(expi(radians(degrees))); return;}
}

#line 4173 "runtime.in"
// pair dir(explicit pair z);
void gen371(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4174 "runtime.in"
  {Stack->push<pair>(unit(z)); return;}
}

#line 4178 "runtime.in"
// pair expi(real angle);
void gen372(stack *Stack)
{
  real angle=vm::pop<real>(Stack);
#line 4179 "runtime.in"
  {Stack->push<pair>(expi(angle)); return;}
}

#line 4183 "runtime.in"
// pair exp(explicit pair z);
void gen373(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4184 "runtime.in" 
  {Stack->push<pair>(exp(z)); return;}
}

#line 4188 "runtime.in"
// pair log(explicit pair z);
void gen374(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4189 "runtime.in" 
  {Stack->push<pair>(pair(log(z.length()),z.angle())); return;}
}

#line 4193 "runtime.in"
// pair sin(explicit pair z);
void gen375(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4194 "runtime.in" 
  {Stack->push<pair>(sin(z)); return;}
}

#line 4198 "runtime.in"
// pair cos(explicit pair z);
void gen376(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4199 "runtime.in" 
  {Stack->push<pair>(pair(cos(z.getx())*cosh(z.gety()),-sin(z.getx())*sinh(z.gety()))); return;} 
}

#line 4203 "runtime.in"
// pair conj(pair z);
void gen377(stack *Stack)
{
  pair z=vm::pop<pair>(Stack);
#line 4204 "runtime.in"
  {Stack->push<pair>(conj(z)); return;}
}

#line 4208 "runtime.in"
// pair realmult(pair z, pair w);
void gen378(stack *Stack)
{
  pair w=vm::pop<pair>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 4209 "runtime.in"
  {Stack->push<pair>(pair (z.getx()*w.getx(),z.gety()*w.gety())); return;}
}

#line 4213 "runtime.in"
// triple realmult(triple u, triple v);
void gen379(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  triple u=vm::pop<triple>(Stack);
#line 4214 "runtime.in"
  {Stack->push<triple>(triple (u.getx()*v.getx(),u.gety()*v.gety(),u.getz()*v.getz())); return;}
}

// To avoid confusion, a dot product requires explicit pair arguments.
#line 4219 "runtime.in"
// real dot(explicit pair z, explicit pair w);
void gen380(stack *Stack)
{
  pair w=vm::pop<pair>(Stack);
  pair z=vm::pop<pair>(Stack);
#line 4220 "runtime.in"
  {Stack->push<real>(dot(z,w)); return;}
}


// Triple operations
#line 4226 "runtime.in"
void tripleZero(stack *Stack)
{
#line 4227 "runtime.in"
  static triple zero;
  {Stack->push<triple>(zero); return;}
}

#line 4233 "runtime.in"
void realRealRealToTriple(stack *Stack)
{
  real z=vm::pop<real>(Stack);
  real y=vm::pop<real>(Stack);
  real x=vm::pop<real>(Stack);
#line 4234 "runtime.in"
  {Stack->push<triple>(triple(x,y,z)); return;}
}

#line 4238 "runtime.in"
// real xpart(triple v);
void tripleXPart(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 4239 "runtime.in"
  {Stack->push<real>(v.getx()); return;}
}

#line 4243 "runtime.in"
// real ypart(triple v);
void tripleYPart(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 4244 "runtime.in"
  {Stack->push<real>(v.gety()); return;}
}

#line 4248 "runtime.in"
// real zpart(triple v);
void tripleZPart(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 4249 "runtime.in"
  {Stack->push<real>(v.getz()); return;}
}

#line 4253 "runtime.in"
// triple *(real x, triple v);
void gen386(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  real x=vm::pop<real>(Stack);
#line 4254 "runtime.in"
  {Stack->push<triple>(x*v); return;}
}

#line 4258 "runtime.in"
// triple *(triple v, real x);
void gen387(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  triple v=vm::pop<triple>(Stack);
#line 4259 "runtime.in"
  {Stack->push<triple>(v*x); return;}
}

#line 4263 "runtime.in"
// triple /(triple v, real x);
void gen388(stack *Stack)
{
  real x=vm::pop<real>(Stack);
  triple v=vm::pop<triple>(Stack);
#line 4264 "runtime.in"
  {Stack->push<triple>(v/x); return;}
}

#line 4268 "runtime.in"
// real length(triple v);
void gen389(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 4269 "runtime.in"
  {Stack->push<real>(v.length()); return;}
}

#line 4273 "runtime.in"
// real abs(triple v);
void gen390(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 4274 "runtime.in"
  {Stack->push<real>(v.length()); return;}
}

#line 4278 "runtime.in"
// real polar(triple v, bool warn=true);
void gen391(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  triple v=vm::pop<triple>(Stack);
#line 4279 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0 && v.getz() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(v.polar()); return;}
}

#line 4284 "runtime.in"
// real azimuth(triple v, bool warn=true);
void gen392(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  triple v=vm::pop<triple>(Stack);
#line 4285 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(v.azimuth()); return;}
}

#line 4290 "runtime.in"
// real colatitude(triple v, bool warn=true);
void gen393(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  triple v=vm::pop<triple>(Stack);
#line 4291 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0 && v.getz() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(degrees(v.polar())); return;}
}

#line 4296 "runtime.in"
// real latitude(triple v, bool warn=true);
void gen394(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  triple v=vm::pop<triple>(Stack);
#line 4297 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0 && v.getz() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(90.0-degrees(v.polar())); return;}
}

// Return the longitude of v in [0,360).
#line 4303 "runtime.in"
// real longitude(triple v, bool warn=true);
void gen395(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  triple v=vm::pop<triple>(Stack);
#line 4304 "runtime.in"
  if(!warn && v.getx() == 0.0 && v.gety() == 0.0) {Stack->push<real>(0.0); return;}
  {Stack->push<real>(principalBranch(degrees(v.azimuth()))); return;}
}

#line 4309 "runtime.in"
// triple unit(triple v);
void gen396(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
#line 4310 "runtime.in"
  {Stack->push<triple>(unit(v)); return;}
}

#line 4314 "runtime.in"
// real dot(triple u, triple v);
void gen397(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  triple u=vm::pop<triple>(Stack);
#line 4315 "runtime.in"
  {Stack->push<real>(dot(u,v)); return;}
}

#line 4319 "runtime.in"
// triple cross(triple u, triple v);
void gen398(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  triple u=vm::pop<triple>(Stack);
#line 4320 "runtime.in"
  {Stack->push<triple>(cross(u,v)); return;}
}

#line 4324 "runtime.in"
// triple expi(real polar, real azimuth);
void gen399(stack *Stack)
{
  real azimuth=vm::pop<real>(Stack);
  real polar=vm::pop<real>(Stack);
#line 4325 "runtime.in"
  {Stack->push<triple>(expi(polar,azimuth)); return;}
}

#line 4329 "runtime.in"
// triple dir(real colatitude, real longitude);
void gen400(stack *Stack)
{
  real longitude=vm::pop<real>(Stack);
  real colatitude=vm::pop<real>(Stack);
#line 4330 "runtime.in"
  {Stack->push<triple>(expi(radians(colatitude),radians(longitude))); return;}
}


// System routines
#line 4336 "runtime.in"
// void atupdate(callable *f);
void gen401(stack *Stack)
{
  callable * f=vm::pop<callable *>(Stack);
#line 4337 "runtime.in"
  processData().atUpdateFunction=f;
}

#line 4342 "runtime.in"
// callable* atupdate();
void gen402(stack *Stack)
{
#line 4343 "runtime.in"
  {Stack->push<callable*>(processData().atUpdateFunction); return;}
}

#line 4347 "runtime.in"
// void atexit(callable *f);
void gen403(stack *Stack)
{
  callable * f=vm::pop<callable *>(Stack);
#line 4348 "runtime.in"
  processData().atExitFunction=f;
}

#line 4352 "runtime.in"
// callable* atexit();
void gen404(stack *Stack)
{
#line 4353 "runtime.in"
  {Stack->push<callable*>(processData().atExitFunction); return;}
}

#line 4357 "runtime.in"
// void atbreakpoint(callableBp *f);
void gen405(stack *Stack)
{
  callableBp * f=vm::pop<callableBp *>(Stack);
#line 4358 "runtime.in"
  processData().atBreakpointFunction=f;
}

#line 4362 "runtime.in"
// void breakpoint(runnable *s=NULL);
void gen406(stack *Stack)
{
  runnable * s=vm::pop<runnable *>(Stack,NULL);
#line 4363 "runtime.in"
  breakpoint(Stack,s);
}

#line 4367 "runtime.in"
// string locatefile(string file);
void gen407(stack *Stack)
{
  string file=vm::pop<string>(Stack);
#line 4368 "runtime.in"
  {Stack->push<string>(locateFile(file)); return;}
}

#line 4372 "runtime.in"
// void stop(string file, Int line, runnable *s=NULL);
void gen408(stack *Stack)
{
  runnable * s=vm::pop<runnable *>(Stack,NULL);
  Int line=vm::pop<Int>(Stack);
  string file=vm::pop<string>(Stack);
#line 4373 "runtime.in"
  file=locateFile(file);
  clear(file,line);
  cout << "setting breakpoint at " << file << ": " << line << endl;
  bplist.push_back(bpinfo(file,line,s));
}

#line 4380 "runtime.in"
// void breakpoints();
void gen409(stack *)
{
#line 4381 "runtime.in"
  for(mem::list<bpinfo>::iterator p=bplist.begin(); p != bplist.end(); ++p)
    cout << p->f.name() << ": " << p->f.line() << endl;
}

#line 4386 "runtime.in"
// void clear(string file, Int line);
void gen410(stack *Stack)
{
  Int line=vm::pop<Int>(Stack);
  string file=vm::pop<string>(Stack);
#line 4387 "runtime.in"
  file=locateFile(file);
  clear(file,line,true);
}

#line 4392 "runtime.in"
// void clear();
void gen411(stack *)
{
#line 4393 "runtime.in"
  bplist.clear();
}

#line 4397 "runtime.in"
// void warn(string s);
void gen412(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 4398 "runtime.in"
  Warn(s);
}

#line 4402 "runtime.in"
// void nowarn(string s);
void gen413(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 4403 "runtime.in"
  noWarn(s);
}

// Strip directory from string
#line 4408 "runtime.in"
// string stripdirectory(string *s);
void gen414(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 4409 "runtime.in"
  {Stack->push<string>(stripDir(*s)); return;}
}

// Strip directory from string
#line 4414 "runtime.in"
// string stripfile(string *s);
void gen415(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 4415 "runtime.in"
  {Stack->push<string>(stripFile(*s)); return;}
}

// Strip file extension from string
#line 4420 "runtime.in"
// string stripextension(string *s);
void gen416(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 4421 "runtime.in"
  {Stack->push<string>(stripExt(*s)); return;}
}

// Call ImageMagick convert.
#line 4426 "runtime.in"
// Int convert(string args=emptystring, string file=emptystring,            string format=emptystring);
void gen417(stack *Stack)
{
  string format=vm::pop<string>(Stack,emptystring);
  string file=vm::pop<string>(Stack,emptystring);
  string args=vm::pop<string>(Stack,emptystring);
#line 4428 "runtime.in"
  ostringstream cmd;
  
  string name=convertname(file,format);
  cmd << "'" << getSetting<string>("convert") << "' " << args
      << " '" << name << "'";
  bool quiet=verbose <= 1;
  Int ret=System(cmd,quiet ? 1 : 0,true,"convert","your ImageMagick convert utility");
  
  if(ret == 0 && verbose > 0)
    cout << "Wrote " << ((file.empty()) ? name : file) << endl;
  
  {Stack->push<Int>(ret); return;}
}

// Call ImageMagick animate.
#line 4444 "runtime.in"
// Int animate(string args=emptystring, string file=emptystring,            string format=emptystring);
void gen418(stack *Stack)
{
  string format=vm::pop<string>(Stack,emptystring);
  string file=vm::pop<string>(Stack,emptystring);
  string args=vm::pop<string>(Stack,emptystring);
#line 4446 "runtime.in"
#ifndef __CYGWIN__
  string name=convertname(file,format,false);
  if(view()) {
    ostringstream cmd;
    cmd << "'" << getSetting<string>("animate") << "' " << args
        << " '" << name << "'";
    {Stack->push<Int>(System(cmd,0,false,"animate","your animated GIF viewer")); return;}
  }
#endif  
  {Stack->push<Int>(0); return;}
}

// Delete file named s.
#line 4460 "runtime.in"
// Int delete(string *s);
void gen419(stack *Stack)
{
  string * s=vm::pop<string *>(Stack);
#line 4461 "runtime.in"
  checkLocal(*s);
  Int rc=unlink(s->c_str());
  if(rc == 0 && verbose > 0) 
    cout << "Deleted " << *s << endl;
  {Stack->push<Int>(rc); return;}
}

// Rename file "from" to file "to".
#line 4470 "runtime.in"
// Int rename(string *from, string *to);
void gen420(stack *Stack)
{
  string * to=vm::pop<string *>(Stack);
  string * from=vm::pop<string *>(Stack);
#line 4471 "runtime.in"
  checkLocal(*from);
  checkLocal(*to);
  Int rc=rename(from->c_str(),to->c_str());
  if(rc == 0 && verbose > 0) 
    cout << "Renamed " << *from << " to " << *to << endl;
  {Stack->push<Int>(rc); return;}
}


// Array operations

// Create an empty array.
#line 4484 "runtime.in"
void emptyArray(stack *Stack)
{
#line 4485 "runtime.in"
  {Stack->push<array*>(new array(0)); return;}
}

// Create a new array (technically a vector).
// This array will be multidimensional.  First the number of dimensions
// is popped off the stack, followed by each dimension in reverse order.
// The array itself is technically a one dimensional array of one
// dimension arrays and so on.
#line 4494 "runtime.in"
void newDeepArray(stack *Stack)
{
  Int depth=vm::pop<Int>(Stack);
#line 4495 "runtime.in"
  assert(depth > 0);

  Int *dims = new Int[depth];

  for (Int index = depth-1; index >= 0; index--) {
    Int i=pop<Int>(Stack);
    if(i < 0) error("cannot create a negative length array");
    dims[index]=i;
  }

  array *a=deepArray(depth, dims);
  delete[] dims;
  {Stack->push<array*>(a); return;}
}

// Creates an array with elements already specified.  First, the number
// of elements is popped off the stack, followed by each element in
// reverse order.
#line 4514 "runtime.in"
void newInitializedArray(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 4515 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (Int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);

  {Stack->push<array*>(a); return;}
}

// Similar to newInitializedArray, but after the n elements, append another
// array to it.
#line 4528 "runtime.in"
void newAppendedArray(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array* tail=vm::pop<array*>(Stack);
#line 4529 "runtime.in"
  assert(n >= 0);

  array *a = new array(n);

  for (Int index = n-1; index >= 0; index--)
    (*a)[index] = pop(Stack);
  
  copy(tail->begin(), tail->end(), back_inserter(*a));

  {Stack->push<array*>(a); return;}
}

// The function T[] array(int n, T value, int depth=0) produces a array of n
// copies of x, where each copy is copied up to depth.
#line 4544 "runtime.in"
void newDuplicateArray(stack *Stack)
{
  Int depth=vm::pop<Int>(Stack,Int_MAX);
  item value=vm::pop(Stack);
  Int n=vm::pop<Int>(Stack);
#line 4545 "runtime.in"
  if(n < 0) error("cannot create a negative length array");
  if(depth < 0) error("cannot copy to a negative depth");

  {Stack->push<array*>(new array(n, value, depth)); return;}
}

// Read an element from an array. Checks for initialization & bounds.
#line 4553 "runtime.in"
void arrayRead(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4554 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) {
    ostringstream buf;
    buf << "read uninitialized value from array at index " << n;
    error(buf);
  }
  {Stack->push(i); return;}
}

// Slice a substring from an array.
#line 4565 "runtime.in"
void arraySliceRead(stack *Stack)
{
  Int right=vm::pop<Int>(Stack);
  Int left=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4566 "runtime.in"
  checkArray(a);
  {Stack->push(a->slice(left, right)); return;}
}

// Slice a substring from an array.  This implements the cases a[i:] and a[:]
// where the endpoint is not given, and assumed to be the length of the array.
#line 4573 "runtime.in"
void arraySliceReadToEnd(stack *Stack)
{
  Int left=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4574 "runtime.in"
  size_t len=checkArray(a);
  {Stack->push(a->slice(left, (Int)len)); return;}
}

// Read an element from an array of arrays. Check bounds and initialize
// as necessary.
#line 4581 "runtime.in"
void arrayArrayRead(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4582 "runtime.in"
  item& i=arrayRead(a,n);
  if (i.empty()) i=new array(0);
  {Stack->push(i); return;}
}

// Write an element to an array.  Increase size if necessary.
#line 4589 "runtime.in"
void arrayWrite(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  array * a=vm::pop<array *>(Stack);
  item value=vm::pop(Stack);
#line 4590 "runtime.in"
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else {
    if(cyclic) outOfBounds("writing cyclic",len,n);
    if(n < 0) outOfBounds("writing",len,n);
    if(len <= (size_t) n)
      a->resize(n+1);
  }
  (*a)[n] = value;
  {Stack->push(value); return;}
}

#line 4604 "runtime.in"
void arraySliceWrite(stack *Stack)
{
  Int right=vm::pop<Int>(Stack);
  Int left=vm::pop<Int>(Stack);
  array * dest=vm::pop<array *>(Stack);
  array * src=vm::pop<array *>(Stack);
#line 4605 "runtime.in"
  checkArray(src);
  checkArray(dest);
  dest->setSlice(left, right, src);
  {Stack->push<array*>(src); return;}
}

#line 4612 "runtime.in"
void arraySliceWriteToEnd(stack *Stack)
{
  Int left=vm::pop<Int>(Stack);
  array * dest=vm::pop<array *>(Stack);
  array * src=vm::pop<array *>(Stack);
#line 4613 "runtime.in"
  checkArray(src);
  size_t len=checkArray(dest);
  dest->setSlice(left, (Int) len, src);
  {Stack->push<array*>(src); return;}
}

// Returns the length of an array.
#line 4621 "runtime.in"
void arrayLength(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4622 "runtime.in"
  {Stack->push<Int>((Int) checkArray(a)); return;}
}

// Returns an array of integers representing the keys of the array.
#line 4627 "runtime.in"
void arrayKeys(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4628 "runtime.in"
  size_t size=checkArray(a);

  array *keys=new array();
  for (size_t i=0; i<size; ++i) {
    item& cell = (*a)[i];
    if (!cell.empty())
      keys->push((Int)i);
  }

  {Stack->push<array*>(keys); return;}
}

// Return the cyclic flag for an array.
#line 4642 "runtime.in"
void arrayCyclicFlag(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4643 "runtime.in"
  checkArray(a);
  {Stack->push<bool>(a->cyclic()); return;}
}

// Check to see if an array element is initialized.
#line 4649 "runtime.in"
void arrayInitializedHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  Int n=vm::pop<Int>(Stack);
#line 4650 "runtime.in"
  size_t len=checkArray(a);
  bool cyclic=a->cyclic();
  if(cyclic && len > 0) n=imod(n,len);
  else if(n < 0 || n >= (Int) len) {Stack->push<bool>(false); return;}
  item&i=(*a)[(unsigned) n];
  {Stack->push<bool>(!i.empty()); return;}
}

// Returns the initialize method for an array.
#line 4660 "runtime.in"
void arrayInitialized(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4661 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayInitializedHelper),a)); return;}
}

// The helper function for the cyclic method that sets the cyclic flag.
#line 4666 "runtime.in"
void arrayCyclicHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  bool b=vm::pop<bool>(Stack);
#line 4667 "runtime.in"
  checkArray(a);
  a->cyclic(b);
}

// Set the cyclic flag for an array.
#line 4673 "runtime.in"
void arrayCyclic(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4674 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayCyclicHelper),a)); return;}
}

// The helper function for the push method that does the actual operation.
#line 4679 "runtime.in"
void arrayPushHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  item x=vm::pop(Stack);
#line 4680 "runtime.in"
  checkArray(a);
  a->push(x);
  {Stack->push(x); return;}
}

// Returns the push method for an array.
#line 4687 "runtime.in"
void arrayPush(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4688 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayPushHelper),a)); return;}
}

// The helper function for the append method that appends b to a.
#line 4693 "runtime.in"
void arrayAppendHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  array * b=vm::pop<array *>(Stack);
#line 4694 "runtime.in"
  checkArray(a);
  size_t size=checkArray(b);
  for(size_t i=0; i < size; i++)
    a->push((*b)[i]);
}

// Returns the append method for an array.
#line 4702 "runtime.in"
void arrayAppend(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4703 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayAppendHelper),a)); return;}
}

// The helper function for the pop method.
#line 4708 "runtime.in"
void arrayPopHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4709 "runtime.in"
  size_t asize=checkArray(a);
  if(asize == 0) 
    error("cannot pop element from empty array");
  {Stack->push(a->pop()); return;}
}

// Returns the pop method for an array.
#line 4717 "runtime.in"
void arrayPop(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4718 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayPopHelper),a)); return;}
}

// The helper function for the insert method.
#line 4723 "runtime.in"
void arrayInsertHelper(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  array * x=vm::pop<array *>(Stack);
  Int i=vm::pop<Int>(Stack);
#line 4724 "runtime.in"
  size_t asize=checkArray(a);
  checkArray(x);
  if(a->cyclic() && asize > 0) i=imod(i,asize);
  if(i < 0 || i > (Int) asize) 
    outOfBounds("inserting",asize,i);
  (*a).insert((*a).begin()+i,(*x).begin(),(*x).end());
}

// Returns the insert method for an array.
#line 4734 "runtime.in"
void arrayInsert(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4735 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayInsertHelper),a)); return;}
}

// Returns the delete method for an array.
#line 4740 "runtime.in"
void arrayDelete(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4741 "runtime.in"
  {Stack->push<callable*>(new thunk(new bfunc(arrayDeleteHelper),a)); return;}
}

#line 4745 "runtime.in"
void arrayAlias(stack *Stack)
{
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4746 "runtime.in"
  {Stack->push<bool>(a==b); return;}
}

// Return array formed by indexing array a with elements of integer array b
#line 4751 "runtime.in"
void arrayIntArray(stack *Stack)
{
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4752 "runtime.in"
  size_t asize=checkArray(a);
  size_t bsize=checkArray(b);
  array *r=new array(bsize);
  bool cyclic=a->cyclic();
  for(size_t i=0; i < bsize; i++) {
    Int index=read<Int>(b,i);
    if(cyclic && asize > 0) index=imod(index,asize);
    else
      if(index < 0 || index >= (Int) asize)
        outOfBounds("reading",asize,index);
    (*r)[i]=(*a)[index];
  }
  {Stack->push<array*>(r); return;}
}

// returns the complement of the integer array a in {0,2,...,n-1},
// so that b[complement(a,b.length)] yields the complement of b[a].
#line 4770 "runtime.in"
// Intarray* complement(Intarray *a, Int n);
void gen451(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  Intarray * a=vm::pop<Intarray *>(Stack);
#line 4771 "runtime.in"
  size_t asize=checkArray(a);
  array *r=new array(0);
  bool *keep=new bool[n];
  for(Int i=0; i < n; ++i) keep[i]=true;
  for(size_t i=0; i < asize; ++i) {
    Int j=read<Int>(a,i);
    if(j >= 0 && j < n) keep[j]=false;
  }
  for(Int i=0; i < n; i++)
    if(keep[i]) r->push(i);
  
  delete[] keep;
  {Stack->push<Intarray*>(r); return;}
}

// Generate the sequence {f(i) : i=0,1,...n-1} given a function f and integer n
#line 4788 "runtime.in"
void arraySequence(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
  callable * f=vm::pop<callable *>(Stack);
#line 4789 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(Int i=0; i < n; ++i) {
    Stack->push(i);
    f->call(Stack);
    (*a)[i]=pop(Stack);
  }
  {Stack->push<Intarray*>(a); return;}
}

// Return the array {0,1,...n-1}
#line 4801 "runtime.in"
// Intarray* sequence(Int n);
void gen453(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 4802 "runtime.in"
  if(n < 0) n=0;
  array *a=new array(n);
  for(Int i=0; i < n; ++i) {
    (*a)[i]=i;
  }
  {Stack->push<Intarray*>(a); return;}
}

// Apply a function to each element of an array
#line 4812 "runtime.in"
void arrayFunction(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
  callable * f=vm::pop<callable *>(Stack);
#line 4813 "runtime.in"
  size_t size=checkArray(a);
  array *b=new array(size);
  for(size_t i=0; i < size; ++i) {
    Stack->push((*a)[i]);
    f->call(Stack);
    (*b)[i]=pop(Stack);
  }
  {Stack->push<array*>(b); return;}
}

#line 4824 "runtime.in"
void arraySort(stack *Stack)
{
  callable * f=vm::pop<callable *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4825 "runtime.in"
  array *c=copyArray(a);
  compareFunc=f;
  FuncStack=Stack;
  stable_sort(c->begin(),c->end(),compareFunction);
  {Stack->push<array*>(c); return;}
}

#line 4833 "runtime.in"
// bool all(boolarray *a);
void gen456(stack *Stack)
{
  boolarray * a=vm::pop<boolarray *>(Stack);
#line 4834 "runtime.in"
  size_t size=checkArray(a);
  bool c=true;
  for(size_t i=0; i < size; i++)
    if(!get<bool>((*a)[i])) {c=false; break;}
  {Stack->push<bool>(c); return;}
}

#line 4842 "runtime.in"
// boolarray* !(boolarray* a);
void gen457(stack *Stack)
{
  boolarray* a=vm::pop<boolarray*>(Stack);
#line 4843 "runtime.in"
  size_t size=checkArray(a);
  array *c=new array(size);
  for(size_t i=0; i < size; i++)
    (*c)[i]=!read<bool>(a,i);
  {Stack->push<boolarray*>(c); return;}
}

#line 4851 "runtime.in"
// Int sum(boolarray *a);
void gen458(stack *Stack)
{
  boolarray * a=vm::pop<boolarray *>(Stack);
#line 4852 "runtime.in"
  size_t size=checkArray(a);
  Int sum=0;
  for(size_t i=0; i < size; i++)
    sum += read<bool>(a,i) ? 1 : 0;
  {Stack->push<Int>(sum); return;}
}

#line 4860 "runtime.in"
void arrayCopy(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4861 "runtime.in"
  {Stack->push<array*>(copyArray(a)); return;}
}

#line 4865 "runtime.in"
void arrayConcat(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4866 "runtime.in"
  // a is an array of arrays to be concatenated together.
  // The signature is
  //   T[] concat(... T[][] a);

  size_t numArgs=checkArray(a);
  size_t resultSize=0;
  for (size_t i=0; i < numArgs; ++i) {
    resultSize += checkArray(a->read<array *>(i));
  }

  array *result=new array(resultSize);

  size_t ri=0;
  for (size_t i=0; i < numArgs; ++i) {
    array *arg=a->read<array *>(i);
    size_t size=checkArray(arg);

    for (size_t j=0; j < size; ++j) {
      (*result)[ri]=(*arg)[j];
      ++ri;
    }
  }

  {Stack->push<array*>(result); return;}
}

#line 4893 "runtime.in"
void array2Copy(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4894 "runtime.in"
  {Stack->push<array*>(copyArray2(a)); return;}
}

#line 4898 "runtime.in"
void array3Copy(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4899 "runtime.in"
  {Stack->push<array*>(copyArray3(a)); return;}
}

#line 4903 "runtime.in"
void array2Transpose(stack *Stack)
{
  array * a=vm::pop<array *>(Stack);
#line 4904 "runtime.in"
  size_t asize=checkArray(a);
  array *c=new array(0);
  for(size_t i=0; i < asize; i++) {
    size_t ip=i+1;
    array *ai=read<array*>(a,i);
    size_t aisize=checkArray(ai);
    size_t csize=checkArray(c);
    if(csize < aisize) {
      c->resize(aisize);
      for(size_t j=csize; j < aisize; j++) {
        (*c)[j]=new array(ip);
      }
    }
    for(size_t j=0; j < aisize; j++) {
      array *cj=read<array*>(c,j);
      if(checkArray(cj) < ip) cj->resize(ip);
      (*cj)[i]=(*ai)[j];
    }
  }
  {Stack->push<array*>(c); return;}
}

// a is a rectangular 3D array; perm is an Int array indicating the type of
// permutation  (021 or 120, etc; original is 012).
// Transpose by sending respective members to the permutated locations:
// return the array obtained by putting a[i][j][k] into position perm{ijk}. 
#line 4931 "runtime.in"
void array3Transpose(stack *Stack)
{
  array * perm=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 4932 "runtime.in"
  const size_t DIM=3;

  if(checkArray(perm) != DIM) {
    ostringstream buf;
    buf << "permutation array must have length " << DIM;
    error(buf);
  }
  
  size_t* size=new size_t[DIM];
  for(size_t i=0; i < DIM; ++i) size[i]=DIM;
  
  for(size_t i=0; i < DIM; ++i) {
    Int p=read<Int>(perm,i);
    size_t P=(size_t) p;
    if(p < 0 || P >= DIM) {
      ostringstream buf;
      buf << "permutation index out of range: " << p;
      error(buf);
    }
    size[P]=P;
  }
  
  for(size_t i=0; i < DIM; ++i)
    if(size[i] == DIM) error("permutation indices must be distinct");
  
  static const char *rectangular=
    "3D transpose implemented for rectangular matrices only";
  
  size_t isize=size[0]=checkArray(a);
  array *a0=read<array*>(a,0);
  size[1]=checkArray(a0);
  array *a00=read<array*>(a0,0);
  size[2]=checkArray(a00);
  for(size_t i=0; i < isize; i++) {
    array *ai=read<array*>(a,i);
    size_t jsize=checkArray(ai);
    if(jsize != size[1]) error(rectangular);
    for(size_t j=0; j < jsize; j++) {
      array *aij=read<array*>(ai,j);
      if(checkArray(aij) != size[2]) error(rectangular);
    }
  }
  
  size_t perm0=(size_t) read<Int>(perm,0);
  size_t perm1=(size_t) read<Int>(perm,1);
  size_t perm2=(size_t) read<Int>(perm,2);
  
  size_t sizep0=size[perm0];
  size_t sizep1=size[perm1];
  size_t sizep2=size[perm2];
  
  array *c=new array(sizep0);
  for(size_t i=0; i < sizep0; ++i) {
    array *ci=new array(sizep1);
    (*c)[i]=ci;
    for(size_t j=0; j < sizep1; ++j) {
      array *cij=new array(sizep2);
      (*ci)[j]=cij;
    }
  }
  
  size_t* i=new size_t[DIM];
  
  for(i[0]=0; i[0] < size[0]; ++i[0]) {
    array *a0=read<array*>(a,i[0]);
    for(i[1]=0; i[1] < size[1]; ++i[1]) {
      array *a1=read<array*>(a0,i[1]);
      for(i[2]=0; i[2] < size[2]; ++i[2]) {
        array *c0=read<array*>(c,i[perm0]);
        array *c1=read<array*>(c0,i[perm1]);
        (*c1)[i[perm2]]=read<real>(a1,i[2]);
      }
    }
  }
  
  delete [] i;  
  delete [] size;  

  {Stack->push<array*>(c); return;}
}

// In a boolean array, find the index of the nth true value or -1 if not found
// If n is negative, search backwards.
#line 5016 "runtime.in"
// Int find(boolarray *a, Int n=1);
void gen465(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,1);
  boolarray * a=vm::pop<boolarray *>(Stack);
#line 5017 "runtime.in"
  size_t size=checkArray(a);
  Int j=-1;
  if(n > 0)
    for(size_t i=0; i < size; i++)
      if(read<bool>(a,i)) {
        n--; if(n == 0) {j=(Int) i; break;}
      }
  if(n < 0)
    for(size_t i=size; i > 0;)
      if(read<bool>(a,--i)) {
        n++; if(n == 0) {j=(Int) i; break;}
      }
  {Stack->push<Int>(j); return;}
}

// construct vector obtained by replacing those elements of b for which the
// corresponding elements of a are false by the corresponding element of c.
#line 5035 "runtime.in"
void arrayConditional(stack *Stack)
{
  array * c=vm::pop<array *>(Stack);
  array * b=vm::pop<array *>(Stack);
  array * a=vm::pop<array *>(Stack);
#line 5036 "runtime.in"
  size_t size=checkArray(a);
  array *r=new array(size);
  if(b && c) {
    checkArrays(a,b);
    checkArrays(b,c);
    for(size_t i=0; i < size; i++)
      (*r)[i]=read<bool>(a,i) ? (*b)[i] : (*c)[i];
  } else {
    r->clear();
    if(b) {
      checkArrays(a,b);
      for(size_t i=0; i < size; i++)
        if(read<bool>(a,i)) r->push((*b)[i]);
    } else if(c) {
      checkArrays(a,c);
      for(size_t i=0; i < size; i++)
        if(!read<bool>(a,i)) r->push((*c)[i]);
    }
  }
  {Stack->push<array*>(r); return;}
}

// Return an n x n identity matrix.
#line 5060 "runtime.in"
// realarray2* identity(Int n);
void gen467(stack *Stack)
{
  Int n=vm::pop<Int>(Stack);
#line 5061 "runtime.in"
  {Stack->push<realarray2*>(Identity(n)); return;}
}

// Return the diagonal matrix with diagonal entries given by a.
#line 5066 "runtime.in"
void diagonal(stack *Stack)
{
  realarray * a=vm::pop<realarray *>(Stack);
#line 5067 "runtime.in"
  size_t n=checkArray(a);
  array *c=new array(n);
  for(size_t i=0; i < n; ++i) {
    array *ci=new array(n);
    (*c)[i]=ci;
    for(size_t j=0; j < i; ++j)
      (*ci)[j]=0.0;
    (*ci)[i]=read<real>(a,i);
    for(size_t j=i+1; j < n; ++j)
      (*ci)[j]=0.0;
  }
  {Stack->push<realarray2*>(c); return;}
}

// Return the inverse of an n x n matrix a using Gauss-Jordan elimination.
#line 5083 "runtime.in"
// realarray2* inverse(realarray2 *a);
void gen469(stack *Stack)
{
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 5084 "runtime.in"
  a=copyArray2(a);
  size_t n=checkArray(a);
  checkSquare(a);
  
  inverseAllocate(n);
  
  for(size_t i=0; i < n; i++)
    pivot[i]=0;
 
  size_t col=0, row=0;
  // This is the main loop over the columns to be reduced.
  for(size_t i=0; i < n; i++) {
    real big=0.0;
    // This is the outer loop of the search for a pivot element.
    for(size_t j=0; j < n; j++) {
      array *aj=read<array*>(a,j);
      if(pivot[j] != 1) {
        for(size_t k=0; k < n; k++) {
          if(pivot[k] == 0) {
            real temp=fabs(read<real>(aj,k));
            if(temp >= big) {
              big=temp;
              row=j;
              col=k;
            }
          } else if(pivot[k] > 1) {
            inverseDeallocate();
            error(singular);
          }
        }
      }
    }
    ++(pivot[col]);
    
    // Interchange rows, if needed, to put the pivot element on the diagonal.
    array *acol=read<array*>(a,col);
    if(row != col) {
      array *arow=read<array*>(a,row);
      for(size_t l=0; l < n; l++) {
        real temp=read<real>(arow,l);
        (*arow)[l]=read<real>(acol,l);
        (*acol)[l]=temp;
      }
    }
    
    Row[i]=row; 
    Col[i]=col;

    // Divide the pivot row by the pivot element.
    real denom=read<real>(acol,col);
    if(denom == 0.0) {
      inverseDeallocate();
      error(singular);
    }
    real pivinv=1.0/denom;
    (*acol)[col]=1.0;
    for(size_t l=0; l < n; l++) 
      (*acol)[l]=read<real>(acol,l)*pivinv;
    
    // Reduce all rows except for the pivoted one.
    for(size_t k=0; k < n; k++) {
      if(k != col) { 
        array *ak=read<array*>(a,k);
        real akcol=read<real>(ak,col);
        (*ak)[col]=0.0;
        for(size_t l=0; l < n; l++)
          (*ak)[l]=read<real>(ak,l)-read<real>(acol,l)*akcol;
      }
    }
  }
  
  // Unscramble the inverse matrix in view of the column interchanges.
  for(size_t l=n; l > 0;) {
    l--;
    size_t r=Row[l];
    size_t c=Col[l];
    if(r != c) {
      for(size_t k=0; k < n; k++) {
        array *ak=read<array*>(a,k);
        real temp=read<real>(ak,r);
        (*ak)[r]=read<real>(ak,c);
        (*ak)[c]=temp;
      }
    }
  }
  inverseDeallocate();
  {Stack->push<realarray2*>(a); return;}
}

// Solve the linear equation ax=b by LU decomposition, returning the
// solution x, where a is an n x n matrix and b is an array of length n.
// If no solution exists, return an empty array.
#line 5177 "runtime.in"
// realarray* solve(realarray2 *a, realarray *b, bool warn=true);
void gen470(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  realarray * b=vm::pop<realarray *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 5178 "runtime.in"
  size_t n=checkArray(a);
  
  if(n == 0) {Stack->push<realarray*>(new array(0)); return;}
  
  size_t m=checkArray(b);
  if(m != n) error(incommensurate);
  
  real *A=copyArray2C(a);
  size_t *index=new size_t[n];
  
  if(LUdecompose(A,n,index,warn) == 0)
    {Stack->push<realarray*>(new array(0)); return;}

  array *x=new array(n);
  
  real *B=copyArrayC(b);
  
  for(size_t i=0; i < n; ++i) {
    size_t ip=index[i];
    real sum=B[ip];
    B[ip]=B[i];
    real *Ai=A+i*n;
    for(size_t j=0; j < i; ++j)
      sum -= Ai[j]*B[j];
    B[i]=sum;
  }
  
  for(size_t i=n; i > 0;) {
    --i;
    real sum=B[i];
    real *Ai=A+i*n;
    for(size_t j=i+1; j < n; ++j)
      sum -= Ai[j]*B[j];
    B[i]=sum/Ai[i];
  }
  
  for(size_t i=0; i < n; ++i)
    (*x)[i]=B[i];

  delete[] index;
  delete[] B;
  delete[] A;
  
  {Stack->push<realarray*>(x); return;}
}

// Solve the linear equation ax=b by LU decomposition, returning the
// solution x, where a is an n x n matrix and b is an n x m matrix.
// If no solution exists, return an empty array.
#line 5228 "runtime.in"
// realarray2* solve(realarray2 *a, realarray2 *b, bool warn=true);
void gen471(stack *Stack)
{
  bool warn=vm::pop<bool>(Stack,true);
  realarray2 * b=vm::pop<realarray2 *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 5229 "runtime.in"
  size_t n=checkArray(a);
  
  if(n == 0) {Stack->push<realarray2*>(new array(0)); return;}
  
  if(checkArray(b) != n) error(incommensurate);
  size_t m=checkArray(read<array*>(b,0));
  
  real *A=copyArray2C(a);
  real *B=copyArray2C(b,false);
  
  size_t *index=new size_t[n];
  
  if(LUdecompose(A,n,index,warn) == 0)
    {Stack->push<realarray2*>(new array(0)); return;}

  array *x=new array(n);
  
  for(size_t i=0; i < n; ++i) {
    real *Ai=A+i*n;
    real *Bi=B+i*m;
    real *Bip=B+index[i]*m;
    for(size_t k=0; k < m; ++k) {
      real sum=Bip[k];
      Bip[k]=Bi[k];
      size_t jk=k;
      for(size_t j=0; j < i; ++j, jk += m)
        sum -= Ai[j]*B[jk];
      Bi[k]=sum;
    }
  }
  
  for(size_t i=n; i > 0;) {
    --i;
    real *Ai=A+i*n;
    real *Bi=B+i*m;
    for(size_t k=0; k < m; ++k) {
      real sum=Bi[k];
      size_t jk=(i+1)*m+k;
      for(size_t j=i+1; j < n; ++j, jk += m)
        sum -= Ai[j]*B[jk];
      Bi[k]=sum/Ai[i];
    }
  }
  
  for(size_t i=0; i < n; ++i) {
    real *Bi=B+i*m;
    array *xi=new array(m);
    (*x)[i]=xi;
    for(size_t j=0; j < m; ++j)
      (*xi)[j]=Bi[j];
  }
    
  delete[] index;
  delete[] B;
  delete[] A;
  
  {Stack->push<realarray2*>(x); return;}
}

// Compute the determinant of an n x n matrix.
#line 5290 "runtime.in"
// real determinant(realarray2 *a);
void gen472(stack *Stack)
{
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 5291 "runtime.in"
  real *A=copyArray2C(a);
  size_t n=checkArray(a);
  
  real det=LUdecompose(A,n,NULL,false);
  size_t n1=n+1;
  for(size_t i=0; i < n; ++i)
    det *= A[i*n1];
  
  delete[] A;
  
  {Stack->push<real>(det); return;}
}

#line 5305 "runtime.in"
// realarray* *(realarray2 *a, realarray *b);
void gen473(stack *Stack)
{
  realarray * b=vm::pop<realarray *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 5306 "runtime.in"
  size_t n=checkArray(a);
  size_t m=checkArray(b);
  array *c=new array(n);
  real *B=copyArrayC(b);
  for(size_t i=0; i < n; ++i) {
    array *ai=read<array*>(a,i);
    if(checkArray(ai) != m) error(incommensurate);
    real sum=0.0;
    for(size_t j=0; j < m; ++j)
      sum += read<real>(ai,j)*B[j];
    (*c)[i]=sum;
  }
  delete[] B;
  {Stack->push<realarray*>(c); return;}
}

#line 5323 "runtime.in"
// realarray* *(realarray *a, realarray2 *b);
void gen474(stack *Stack)
{
  realarray2 * b=vm::pop<realarray2 *>(Stack);
  realarray * a=vm::pop<realarray *>(Stack);
#line 5324 "runtime.in"
  size_t n=checkArray(a);
  if(n != checkArray(b)) error(incommensurate);
  real *A=copyArrayC(a);

  array **B=new array*[n];
  array *bk=read<array *>(b,0);
  B[0]=bk;
  size_t m=bk->size();
  for(size_t k=1; k < n; k++) {
    array *bk=read<array *>(b,k);
    if(bk->size() != m) error(incommensurate);
    B[k]=bk;
  }
  array *c=new array(m);

  for(size_t i=0; i < m; ++i) {
    real sum=0.0;
    for(size_t k=0; k < n; ++k)
      sum += A[k]*read<real>(B[k],i);
    (*c)[i]=sum;
  }
  delete[] B;
  delete[] A;
  {Stack->push<realarray*>(c); return;}
}

#line 5351 "runtime.in"
// realarray2* *(realarray2 *a, realarray2 *b);
void gen475(stack *Stack)
{
  realarray2 * b=vm::pop<realarray2 *>(Stack);
  realarray2 * a=vm::pop<realarray2 *>(Stack);
#line 5352 "runtime.in"
  size_t n=checkArray(a);
  
  size_t nb=checkArray(b);
  size_t na0=n == 0 ? 0 : checkArray(read<array*>(a,0));
  if(na0 != nb) 
    error(incommensurate);
  
  size_t nb0=nb == 0 ? 0 : checkArray(read<array*>(b,0));
    
  array *c=new array(n);

  real *A=copyArray2C(a,false);
  real *B=copyArray2C(b,false);

  for(size_t i=0; i < n; ++i) {
    real *Ai=A+i*nb;
    array *ci=new array(nb0);
    (*c)[i]=ci;
    for(size_t j=0; j < nb0; ++j) {
      real sum=0.0;
      size_t kj=j;
      for(size_t k=0; k < nb; ++k, kj += nb0)
        sum += Ai[k]*B[kj];
      (*ci)[j]=sum;
    }
  }
  
  delete[] B;
  delete[] A;
  
  {Stack->push<realarray2*>(c); return;}
}

#line 5386 "runtime.in"
// triple *(realarray2 *t, triple v);
void gen476(stack *Stack)
{
  triple v=vm::pop<triple>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
#line 5387 "runtime.in"
  {Stack->push<triple>(*t*v); return;}
}

#line 5391 "runtime.in"
// pair project(triple v, realarray2 *t);
void gen477(stack *Stack)
{
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  triple v=vm::pop<triple>(Stack);
#line 5392 "runtime.in"
  size_t n=checkArray(t);
  if(n != 4) error(incommensurate);
  array *t0=read<array*>(t,0);
  array *t1=read<array*>(t,1);
  array *t3=read<array*>(t,3);
  if(checkArray(t0) != 4 || checkArray(t1) != 4 || checkArray(t3) != 4)
    error(incommensurate);
  
  real x=v.getx();
  real y=v.gety();
  real z=v.getz();
  
  real f=read<real>(t3,0)*x+read<real>(t3,1)*y+read<real>(t3,2)*z+
    read<real>(t3,3);
  if(f == 0.0) dividebyzero();
  f=1.0/f;
  
  {Stack->push<pair>(pair((read<real>(t0,0)*x+read<real>(t0,1)*y+read<real>(t0,2)*z+
               read<real>(t0,3))*f,
              (read<real>(t1,0)*x+read<real>(t1,1)*y+read<real>(t1,2)*z+
               read<real>(t1,3))*f)); return;}
}

// Compute the dot product of vectors a and b.
#line 5417 "runtime.in"
// real dot(realarray *a, realarray *b);
void gen478(stack *Stack)
{
  realarray * b=vm::pop<realarray *>(Stack);
  realarray * a=vm::pop<realarray *>(Stack);
#line 5418 "runtime.in"
  size_t n=checkArrays(a,b);
  real sum=0.0;
  for(size_t i=0; i < n; ++i)
    sum += read<real>(a,i)*read<real>(b,i);
  {Stack->push<real>(sum); return;}
}

// Solve the problem L\inv f, where f is an n vector and L is the n x n matrix
//
// [ b[0] c[0]           a[0]   ]
// [ a[1] b[1] c[1]             ]
// [      a[2] b[2] c[2]        ]
// [                ...         ]
// [ c[n-1]       a[n-1] b[n-1] ]
#line 5433 "runtime.in"
// realarray* tridiagonal(realarray *a, realarray *b, realarray *c, realarray *f);
void gen479(stack *Stack)
{
  realarray * f=vm::pop<realarray *>(Stack);
  realarray * c=vm::pop<realarray *>(Stack);
  realarray * b=vm::pop<realarray *>(Stack);
  realarray * a=vm::pop<realarray *>(Stack);
#line 5434 "runtime.in"
  size_t n=checkArrays(a,b);
  checkEqual(n,checkArray(c));
  checkEqual(n,checkArray(f));
  
  array *up=new array(n);
  array& u=*up;

  if(n == 0) {Stack->push<realarray*>(up); return;}
  
  // Special case: zero Dirichlet boundary conditions
  if(read<real>(a,0) == 0.0 && read<real>(c,n-1) == 0.0) {
    real temp=read<real>(b,0);
    if(temp == 0.0) dividebyzero();
    temp=1.0/temp;
    
    real *work=new real[n];
    u[0]=read<real>(f,0)*temp;
    work[0]=-read<real>(c,0)*temp;
        
    for(size_t i=1; i < n; i++) {
      real temp=(read<real>(b,i)+read<real>(a,i)*work[i-1]);
      if(temp == 0.0) {delete[] work; dividebyzero();}
      temp=1.0/temp;
      u[i]=(read<real>(f,i)-read<real>(a,i)*read<real>(u,i-1))*temp;
      work[i]=-read<real>(c,i)*temp;
    }

    for(size_t i=n-1; i >= 1; i--)
      u[i-1]=read<real>(u,i-1)+work[i-1]*read<real>(u,i);
    
    delete[] work;
    {Stack->push<realarray*>(up); return;}
  }
  
  real binv=read<real>(b,0);
  if(binv == 0.0) dividebyzero();
  binv=1.0/binv;
  
  if(n == 1) {u[0]=read<real>(f,0)*binv; {Stack->push<realarray*>(up); return;}}
  if(n == 2) {
    real factor=(read<real>(b,0)*read<real>(b,1)-
                 read<real>(a,0)*read<real>(c,1));
    if(factor== 0.0) dividebyzero();
    factor=1.0/factor;
    real temp=(read<real>(b,0)*read<real>(f,1)-
               read<real>(c,1)*read<real>(f,0))*factor;
    u[0]=(read<real>(b,1)*read<real>(f,0)-
          read<real>(a,0)*read<real>(f,1))*factor;
    u[1]=temp;
    {Stack->push<realarray*>(up); return;}
  }
        
  real *gamma=new real[n-2];
  real *delta=new real[n-2];
  
  gamma[0]=read<real>(c,0)*binv;
  delta[0]=read<real>(a,0)*binv;
  u[0]=read<real>(f,0)*binv;
  real beta=read<real>(c,n-1);
  real fn=read<real>(f,n-1)-beta*read<real>(u,0);
  real alpha=read<real>(b,n-1)-beta*delta[0];

  for(size_t i=1; i <= n-3; i++) {
    real alphainv=read<real>(b,i)-read<real>(a,i)*gamma[i-1];
    if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
    alphainv=1.0/alphainv;
    beta *= -gamma[i-1];
    gamma[i]=read<real>(c,i)*alphainv;
    u[i]=(read<real>(f,i)-read<real>(a,i)*read<real>(u,i-1))*alphainv;
    fn -= beta*read<real>(u,i);
    delta[i]=-read<real>(a,i)*delta[i-1]*alphainv;
    alpha -= beta*delta[i];
  }
        
  real alphainv=read<real>(b,n-2)-read<real>(a,n-2)*gamma[n-3];
  if(alphainv == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  alphainv=1.0/alphainv;
  u[n-2]=(read<real>(f,n-2)-read<real>(a,n-2)*read<real>(u,n-3))
    *alphainv;
  beta=read<real>(a,n-1)-beta*gamma[n-3];
  real dnm1=(read<real>(c,n-2)-read<real>(a,n-2)*delta[n-3])*alphainv;
  real temp=alpha-beta*dnm1;
  if(temp == 0.0) {delete[] gamma; delete[] delta; dividebyzero();}
  u[n-1]=temp=(fn-beta*read<real>(u,n-2))/temp;
  u[n-2]=read<real>(u,n-2)-dnm1*temp;
        
  for(size_t i=n-2; i >= 1; i--)
    u[i-1]=read<real>(u,i-1)-gamma[i-1]*read<real>(u,i)-delta[i-1]*temp;
  
  delete[] delta;
  delete[] gamma;
  
  {Stack->push<realarray*>(up); return;}
}

// Root solve by Newton-Raphson
#line 5531 "runtime.in"
// real newton(Int iterations=100, callableReal *f, callableReal *fprime, real x,            bool verbose=false);
void gen480(stack *Stack)
{
  bool verbose=vm::pop<bool>(Stack,false);
  real x=vm::pop<real>(Stack);
  callableReal * fprime=vm::pop<callableReal *>(Stack);
  callableReal * f=vm::pop<callableReal *>(Stack);
  Int iterations=vm::pop<Int>(Stack,100);
#line 5533 "runtime.in"
  static const real fuzz=1000.0*DBL_EPSILON;
  Int i=0;
  size_t oldPrec=0;
  if(verbose) 
    oldPrec=cout.precision(DBL_DIG);

  real diff=DBL_MAX;
  real lastdiff;
  do {
    real x0=x;
    
    Stack->push(x);
    fprime->call(Stack);
    real dfdx=pop<real>(Stack);
    
    if(dfdx == 0.0) {
      x=DBL_MAX;
      break;
    }

    Stack->push(x);
    f->call(Stack);
    real fx=pop<real>(Stack);
    
    x -= fx/dfdx;

    lastdiff=diff;
    
    if(verbose)
      cout << "Newton-Raphson: " << x << endl;
    
    diff=fabs(x-x0);
    if(++i == iterations) {
      x=DBL_MAX;
      break;
    }
  } while (diff != 0.0 && (diff < lastdiff || diff > fuzz*fabs(x)));

  if(verbose)
    cout.precision(oldPrec);
  {Stack->push<real>(x); return;}
}

// Root solve by Newton-Raphson bisection
// cf. routine rtsafe (Press et al.,  Numerical Recipes, 1991).
#line 5579 "runtime.in"
// real newton(Int iterations=100, callableReal *f, callableReal *fprime, real x1,            real x2, bool verbose=false);
void gen481(stack *Stack)
{
  bool verbose=vm::pop<bool>(Stack,false);
  real x2=vm::pop<real>(Stack);
  real x1=vm::pop<real>(Stack);
  callableReal * fprime=vm::pop<callableReal *>(Stack);
  callableReal * f=vm::pop<callableReal *>(Stack);
  Int iterations=vm::pop<Int>(Stack,100);
#line 5581 "runtime.in"
  static const real fuzz=1000.0*DBL_EPSILON;
  size_t oldPrec=0;
  if(verbose) 
    oldPrec=cout.precision(DBL_DIG);

  Stack->push(x1);
  f->call(Stack);
  real f1=pop<real>(Stack);
  if(f1 == 0.0) {Stack->push<real>(x1); return;}
  
  Stack->push(x2);
  f->call(Stack);
  real f2=pop<real>(Stack);
  if(f2 == 0.0) {Stack->push<real>(x2); return;}
        
  if((f1 > 0.0 && f2 > 0.0) || (f1 < 0.0 && f2 < 0.0)) {
    ostringstream buf;
    buf << "root not bracketed, f(x1)=" << f1 << ", f(x2)=" << f2 << endl;
    error(buf);
  }

  real x=0.5*(x1+x2);
  real dxold=fabs(x2-x1);
  if(f1 > 0.0) {
    real temp=x1;
    x1=x2;
    x2=temp;
  }
        
  if(verbose)
    cout << "midpoint: " << x << endl;

  real dx=dxold;
  Stack->push(x);
  f->call(Stack);
  real y=pop<real>(Stack);
  
  Stack->push(x);
  fprime->call(Stack);
  real dy=pop<real>(Stack);

  Int j;
  for(j=0; j < iterations; j++) {
    if(((x-x2)*dy-y)*((x-x1)*dy-y) >= 0.0 || fabs(2.0*y) > fabs(dxold*dy)) {
      dxold=dx;
      dx=0.5*(x2-x1);
      x=x1+dx;
      if(verbose)
        cout << "bisection: " << x << endl;
      if(x1 == x) {Stack->push<real>(x); return;}
    } else {
      dxold=dx;
      dx=y/dy;
      real temp=x;
      x -= dx;
      if(verbose)
        cout << "Newton-Raphson: " << x << endl;
      if(temp == x) {Stack->push<real>(x); return;}
    }
    if(fabs(dx) < fuzz*fabs(x)) {Stack->push<real>(x); return;}
    
    Stack->push(x);
    f->call(Stack);
    y=pop<real>(Stack);
    
    Stack->push(x);
    fprime->call(Stack);
    dy=pop<real>(Stack);

    if(y < 0.0) x1=x;
    else x2=x;
  }
  if(verbose)
    cout.precision(oldPrec);
  {Stack->push<real>((j == iterations) ? DBL_MAX : x); return;}
}

#line 5659 "runtime.in"
// real simpson(callableReal *f, real a, real b, real acc=DBL_EPSILON,             real dxmax=0);
void gen482(stack *Stack)
{
  real dxmax=vm::pop<real>(Stack,0);
  real acc=vm::pop<real>(Stack,DBL_EPSILON);
  real b=vm::pop<real>(Stack);
  real a=vm::pop<real>(Stack);
  callableReal * f=vm::pop<callableReal *>(Stack);
#line 5661 "runtime.in"
  real integral;
  if(dxmax == 0) dxmax=b-a;
  Func=f;
  FuncStack=Stack;
  if(!simpson(integral,wrapFunction,a,b,acc,dxmax))
    error("nesting capacity exceeded in simpson");
  {Stack->push<real>(integral); return;}
}

// Compute the fast Fourier transform of a pair array
#line 5672 "runtime.in"
void pairArrayFFT(stack *Stack)
{
  Int sign=vm::pop<Int>(Stack,1);
  pairarray * a=vm::pop<pairarray *>(Stack);
#line 5673 "runtime.in"
  unsigned n=(unsigned) checkArray(a);
#ifdef HAVE_LIBFFTW3
  array *c=new array(n);
  if(n) {
    Complex *f=FFTWComplex(n);
    fft1d Forward(n,intcast(sign),f);
  
    for(size_t i=0; i < n; i++) {
      pair z=read<pair>(a,i);
      f[i]=Complex(z.getx(),z.gety());
    }
    Forward.fft(f);
  
    for(size_t i=0; i < n; i++) {
      Complex z=f[i];
      (*c)[i]=pair(z.real(),z.imag());
    }
    FFTWdelete(f);
  }
#else
  unused(&n);
  unused(&sign);
  array *c=new array(0);
#endif //  HAVE_LIBFFTW3
  {Stack->push<pairarray*>(c); return;}
}

#line 5701 "runtime.in"
// Intarray2* triangulate(pairarray *z);
void gen484(stack *Stack)
{
  pairarray * z=vm::pop<pairarray *>(Stack);
#line 5702 "runtime.in"
  size_t nv=checkArray(z);
// Call robust version of Gilles Dumoulin's port of Paul Bourke's
// triangulation code.

  XYZ *pxyz=new XYZ[nv+3];
  ITRIANGLE *V=new ITRIANGLE[4*nv];
  
  for(size_t i=0; i < nv; ++i) {
    pair w=read<pair>(z,i);
    pxyz[i].p[0]=w.getx();
    pxyz[i].p[1]=w.gety();
    pxyz[i].i=(Int) i;
  }
  
  Int ntri;
  Triangulate((Int) nv,pxyz,V,ntri,true,false);

  size_t nt=(size_t) ntri;
  array *t=new array(nt);
  for(size_t i=0; i < nt; ++i) {
    array *ti=new array(3);
    (*t)[i]=ti;
    ITRIANGLE *Vi=V+i;
    (*ti)[0]=pxyz[Vi->p1].i;
    (*ti)[1]=pxyz[Vi->p2].i;
    (*ti)[2]=pxyz[Vi->p3].i;
  }
   
  delete[] V;
  delete[] pxyz;
  {Stack->push<Intarray2*>(t); return;}
}


// File operations
#line 5738 "runtime.in"
// bool ==(file *a, file *b);
void gen485(stack *Stack)
{
  file * b=vm::pop<file *>(Stack);
  file * a=vm::pop<file *>(Stack);
#line 5739 "runtime.in"
  {Stack->push<bool>(a == b); return;}
}

#line 5744 "runtime.in"
// bool !=(file *a, file *b);
void gen486(stack *Stack)
{
  file * b=vm::pop<file *>(Stack);
  file * a=vm::pop<file *>(Stack);
#line 5745 "runtime.in"
  {Stack->push<bool>(a != b); return;}
}

#line 5749 "runtime.in"
void nullFile(stack *Stack)
{
#line 5750 "runtime.in"
  {Stack->push<file*>(&camp::nullfile); return;}
}

#line 5754 "runtime.in"
// file* input(string name, bool check=true, string comment=commentchar);
void gen488(stack *Stack)
{
  string comment=vm::pop<string>(Stack,commentchar);
  bool check=vm::pop<bool>(Stack,true);
  string name=vm::pop<string>(Stack);
#line 5755 "runtime.in"
  char c=comment.empty() ? (char) 0 : comment[0];
  file *f=new ifile(name,c,check);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 5762 "runtime.in"
// file* output(string name, bool update=false, string comment=commentchar);
void gen489(stack *Stack)
{
  string comment=vm::pop<string>(Stack,commentchar);
  bool update=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack);
#line 5763 "runtime.in"
  file *f;
  if(update) {
    char c=comment.empty() ? (char) 0 : comment[0];
    f=new iofile(name,c);
  } else f=new ofile(name);
  f->open();
  if(update) f->seek(0,false);
  {Stack->push<file*>(f); return;}
}

#line 5774 "runtime.in"
// file* xinput(string name, bool check=true);
void gen490(stack *Stack)
{
  bool check=vm::pop<bool>(Stack,true);
  string name=vm::pop<string>(Stack);
#line 5775 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f=new ixfile(name,check);
  f->open();
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR read support not enabled";
  error(buf);
  unused(&check); // Suppress unused variable warning
#endif
}

#line 5788 "runtime.in"
// file* xoutput(string name, bool update=false);
void gen491(stack *Stack)
{
  bool update=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack);
#line 5789 "runtime.in"
#ifdef HAVE_RPC_RPC_H
  file *f;
  if(update)
    f=new ioxfile(name);
  else f=new oxfile(name);
  f->open();
  if(update) f->seek(0,false);
  {Stack->push<file*>(f); return;}
#else  
  ostringstream buf;
  buf << name << ": XDR write support not enabled";
  error(buf);
  unused(&update); // Suppress unused variable warning
#endif
}

#line 5806 "runtime.in"
// file* binput(string name, bool check=true);
void gen492(stack *Stack)
{
  bool check=vm::pop<bool>(Stack,true);
  string name=vm::pop<string>(Stack);
#line 5807 "runtime.in"
  file *f=new ibfile(name,check);
  f->open();
  {Stack->push<file*>(f); return;}
}

#line 5813 "runtime.in"
// file* boutput(string name, bool update=false);
void gen493(stack *Stack)
{
  bool update=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack);
#line 5814 "runtime.in"
  file *f;
  if(update) f=new iobfile(name);
  else f=new obfile(name);
  f->open();
  if(update) f->seek(0,false);
  {Stack->push<file*>(f); return;}
}

#line 5823 "runtime.in"
// bool eof(file *f);
void gen494(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5824 "runtime.in"
  {Stack->push<bool>(f->eof()); return;}
}

#line 5828 "runtime.in"
// bool eol(file *f);
void gen495(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5829 "runtime.in"
  {Stack->push<bool>(f->eol()); return;}
}

#line 5833 "runtime.in"
// bool error(file *f);
void gen496(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5834 "runtime.in"
  {Stack->push<bool>(f->error()); return;}
}

#line 5838 "runtime.in"
// void clear(file *f);
void gen497(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5839 "runtime.in"
  f->clear();
}

#line 5843 "runtime.in"
// void close(file *f);
void gen498(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5844 "runtime.in"
  f->close();
}

#line 5848 "runtime.in"
// Int precision(file *f=NULL, Int digits=0);
void gen499(stack *Stack)
{
  Int digits=vm::pop<Int>(Stack,0);
  file * f=vm::pop<file *>(Stack,NULL);
#line 5849 "runtime.in"
  if(f == 0) f=&camp::Stdout;
  {Stack->push<Int>(f->precision(digits)); return;}
}

#line 5854 "runtime.in"
// void flush(file *f);
void gen500(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5855 "runtime.in"
  f->flush();
}

#line 5859 "runtime.in"
// string getc(file *f);
void gen501(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5860 "runtime.in"
  char c=0;
  if(f->isOpen()) f->read(c);
  static char str[1];
  str[0]=c;
  {Stack->push<string>(string(str)); return;}
}

#line 5868 "runtime.in"
// Int tell(file *f);
void gen502(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5869 "runtime.in"
  {Stack->push<Int>(f->tell()); return;}
}

#line 5873 "runtime.in"
// void seek(file *f, Int pos);
void gen503(stack *Stack)
{
  Int pos=vm::pop<Int>(Stack);
  file * f=vm::pop<file *>(Stack);
#line 5874 "runtime.in"
  f->seek(pos,pos >= 0);
}

#line 5878 "runtime.in"
// void seekeof(file *f);
void gen504(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5879 "runtime.in"
  f->seek(0,false);
}

// Set file dimensions
#line 5884 "runtime.in"
// file* dimension(file *f, Int nx);
void gen505(stack *Stack)
{
  Int nx=vm::pop<Int>(Stack);
  file * f=vm::pop<file *>(Stack);
#line 5885 "runtime.in"
  f->dimension(nx);
  {Stack->push<file*>(f); return;}
}

#line 5890 "runtime.in"
// file* dimension(file *f, Int nx, Int ny);
void gen506(stack *Stack)
{
  Int ny=vm::pop<Int>(Stack);
  Int nx=vm::pop<Int>(Stack);
  file * f=vm::pop<file *>(Stack);
#line 5891 "runtime.in"
  f->dimension(nx,ny);
  {Stack->push<file*>(f); return;}
}

#line 5896 "runtime.in"
// file* dimension(file *f, Int nx, Int ny, Int nz);
void gen507(stack *Stack)
{
  Int nz=vm::pop<Int>(Stack);
  Int ny=vm::pop<Int>(Stack);
  Int nx=vm::pop<Int>(Stack);
  file * f=vm::pop<file *>(Stack);
#line 5897 "runtime.in"
  f->dimension(nx,ny,nz);
  {Stack->push<file*>(f); return;}
}

// Set file to read comma-separated values
#line 5903 "runtime.in"
// file* csv(file *f, bool b=true);
void gen508(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * f=vm::pop<file *>(Stack);
#line 5904 "runtime.in"
  f->CSVMode(b);
  {Stack->push<file*>(f); return;}
}

// Set file to read whitespace-separated values
#line 5910 "runtime.in"
// file* word(file *f, bool b=true);
void gen509(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * f=vm::pop<file *>(Stack);
#line 5911 "runtime.in"
  f->WordMode(b);
  {Stack->push<file*>(f); return;}
}

// Set file to read arrays in line-at-a-time mode
#line 5917 "runtime.in"
// file* line(file *f, bool b=true);
void gen510(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * f=vm::pop<file *>(Stack);
#line 5918 "runtime.in"
  f->LineMode(b);
  {Stack->push<file*>(f); return;}
}

// Set file to read/write signed int XDR values.
#line 5924 "runtime.in"
// file* signed(file *f, bool b=true);
void gen511(stack *Stack)
{
  bool b=vm::pop<bool>(Stack,true);
  file * f=vm::pop<file *>(Stack);
#line 5925 "runtime.in"
  f->SignedInt(b);
  {Stack->push<file*>(f); return;}
}

#line 5930 "runtime.in"
void namePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5931 "runtime.in"
  {Stack->push<string>(f.filename()); return;}
}

#line 5935 "runtime.in"
void modePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5936 "runtime.in"
  {Stack->push<string>(f.FileMode()); return;}
}

#line 5940 "runtime.in"
void dimensionPart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5941 "runtime.in"
  array *a=new array(3);
  (*a)[0]=f.Nx();
  (*a)[1]=f.Ny();
  (*a)[2]=f.Nz();
  {Stack->push<array*>(a); return;}
}

#line 5949 "runtime.in"
void lineModePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5950 "runtime.in"
  {Stack->push<bool>(f.LineMode()); return;}
}

#line 5954 "runtime.in"
void csvModePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5955 "runtime.in"
  {Stack->push<bool>(f.CSVMode()); return;}
}

#line 5959 "runtime.in"
void wordModePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5960 "runtime.in"
  {Stack->push<bool>(f.WordMode()); return;}
}

#line 5964 "runtime.in"
void singleRealModePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5965 "runtime.in"
  {Stack->push<bool>(f.SingleReal()); return;}
}

#line 5969 "runtime.in"
void singleIntModePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5970 "runtime.in"
  {Stack->push<bool>(f.SingleInt()); return;}
}

#line 5974 "runtime.in"
void signedIntModePart(stack *Stack)
{
  file f=vm::pop<file>(Stack);
#line 5975 "runtime.in"
  {Stack->push<bool>(f.SignedInt()); return;}
}

// Set file to read an array1 (1 int size followed by a 1d array)
#line 5980 "runtime.in"
// file* read1(file *f);
void gen521(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5981 "runtime.in"
  f->dimension(-2);
  {Stack->push<file*>(f); return;}
}

// Set file to read an array2 (2 int sizes followed by a 2d array)
#line 5987 "runtime.in"
// file* read2(file *f);
void gen522(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5988 "runtime.in"
  f->dimension(-2,-2);
  {Stack->push<file*>(f); return;}
}

// Set file to read an array3 (3 int sizes followed by a 3d array)
#line 5994 "runtime.in"
// file* read3(file *f);
void gen523(stack *Stack)
{
  file * f=vm::pop<file *>(Stack);
#line 5995 "runtime.in"
  f->dimension(-2,-2,-2);
  {Stack->push<file*>(f); return;}
}

// Return the last n lines of the history named name.
#line 6001 "runtime.in"
// stringarray* history(string name, Int n=1);
void gen524(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,1);
  string name=vm::pop<string>(Stack);
#line 6002 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  bool newhistory=historyMap.find(name) == historyMap.end();
  
  string filename;
  
  if(newhistory) {
    filename=historyfilename(name);
    std::ifstream exists(filename.c_str());
    if(!exists) {Stack->push<stringarray*>(new array(0)); return;}
  }

  store_history(&history_save);
  HISTORY_STATE& history=historyMap[name].state;
  history_set_history_state(&history);
  
  if(newhistory)
    read_history(filename.c_str());

  array *a=get_history(n);
  
  store_history(&history);
  history_set_history_state(&history_save);
  
  {Stack->push<stringarray*>(a); return;}
#else
  unused(&n);
  {Stack->push<stringarray*>(new array(0)); return;}
#endif
}

// Return the last n lines of the interactive history.
#line 6034 "runtime.in"
// stringarray* history(Int n=0);
void gen525(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,0);
#line 6035 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  {Stack->push<stringarray*>(get_history(n)); return;}
#else
  unused(&n);
  {Stack->push<stringarray*>(new array(0)); return;}
#endif
}

// Prompt for a string using prompt, the GNU readline library, and a
// local history named name.
#line 6046 "runtime.in"
// string readline(string prompt=emptystring, string name=emptystring,                bool tabcompletion=false);
void gen526(stack *Stack)
{
  bool tabcompletion=vm::pop<bool>(Stack,false);
  string name=vm::pop<string>(Stack,emptystring);
  string prompt=vm::pop<string>(Stack,emptystring);
#line 6048 "runtime.in"
  if(!isatty(STDIN_FILENO)) 
    {Stack->push<string>(emptystring); return;}
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  init_readline(tabcompletion);
  
  store_history(&history_save);
  bool newhistory=historyMap.find(name) == historyMap.end();
  historyState& h=historyMap[name];
  HISTORY_STATE& history=h.state;
  history_set_history_state(&history);

  if(newhistory)
    read_history(historyfilename(name).c_str());
  
  static char *line=NULL;
  /* Return the memory to the free pool
     if the buffer has already been allocated. */
  if(line) {
    free(line);
    line=NULL;
  }
     
  /* Get a line from the user. */
  line=readline(prompt.c_str());
     
  if(!line) cout << endl;
  
  history_set_history_state(&history_save);

  {Stack->push<string>(line ? string(line) : emptystring); return;}
#else
  cout << prompt;
  string s;
  getline(cin,s);
  unused(&tabcompletion); // Avoid unused variable warning message.
  {Stack->push<string>(s); return;}
#endif
}

// Save a string in a local history named name.
// If store=true, store the local history in the file historyfilename(name).
#line 6090 "runtime.in"
// void saveline(string name, string value, bool store=true);
void gen527(stack *Stack)
{
  bool store=vm::pop<bool>(Stack,true);
  string value=vm::pop<string>(Stack);
  string name=vm::pop<string>(Stack);
#line 6091 "runtime.in"
#if defined(HAVE_LIBREADLINE) && defined(HAVE_LIBCURSES)
  store_history(&history_save);
  bool newhistory=historyMap.find(name) == historyMap.end();
  historyState& h=historyMap[name];
  h.store=store;
  HISTORY_STATE& history=h.state;
  history_set_history_state(&history);

  if(newhistory)
    read_history(historyfilename(name).c_str());
  
  if(value != "") {
    add_history(value.c_str());
    if(store) {
      std::ofstream hout(historyfilename(name).c_str(),std::ios::app);
      hout << value << endl;
    }
  }
  
  store_history(&history);
  history_set_history_state(&history_save);
#else
  unused(&store);
#endif   
}

#line 6118 "runtime.in"
// void generate_random_backtrace();
void gen528(stack *)
{
#line 6119 "runtime.in"
#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
  GC_generate_random_backtrace();
#else
  error("generate_random_backtrace() requires ./configure --enable-gc-debug");
#endif
}

#line 6127 "runtime.in"
// void print_random_addresses(Int n=1);
void gen529(stack *Stack)
{
  Int n=vm::pop<Int>(Stack,1);
#line 6128 "runtime.in"
#if defined(USEGC) && defined(GC_DEBUG) && defined(GC_BACKTRACE)
  GC_gcollect();
  for (Int i=0; i < n; ++i)
    GC_debug_print_heap_obj_proc(GC_base(GC_generate_random_valid_address()));
#else
  error("print_random_addresses() requires ./configure --enable-gc-debug");
  unused(&n); // Avoid unused variable warning message.
#endif
}

} // namespace run

namespace trans {

void gen_base_venv(venv &ve)
{
#line 1177 "runtime.in"
  addFunc(ve, run::gen8, primBoolean(), "!", formal(primBoolean(), "b", false, false));
#line 1205 "runtime.in"
  addFunc(ve, run::gen13, primInt(), "AND", formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 1213 "runtime.in"
  addFunc(ve, run::gen14, primInt(), "OR", formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 1218 "runtime.in"
  addFunc(ve, run::gen15, primInt(), "XOR", formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 1223 "runtime.in"
  addFunc(ve, run::gen16, primInt(), "NOT", formal(primInt(), "a", false, false));
#line 1254 "runtime.in"
  addFunc(ve, run::gen21, primBoolean(), "empty", formal(primPicture(), "f", false, false));
#line 1259 "runtime.in"
  addFunc(ve, run::gen22, primVoid(), "erase", formal(primPicture(), "f", false, false));
#line 1264 "runtime.in"
  addFunc(ve, run::gen23, primPair(), "min", formal(primPicture(), "f", false, false));
#line 1269 "runtime.in"
  addFunc(ve, run::gen24, primPair(), "max", formal(primPicture(), "f", false, false));
#line 1274 "runtime.in"
  addFunc(ve, run::gen25, primVoid(), "label", formal(primPicture(), "f", false, false), formal(primString(), "s", false, false), formal(primString(), "size", false, false), formal(primTransform(), "t", false, false), formal(primPair(), "position", false, false), formal(primPair(), "align", false, false), formal(primPen(), "p", false, false));
#line 1280 "runtime.in"
  addFunc(ve, run::gen26, primBoolean(), "labels", formal(primPicture(), "f", false, false));
#line 1285 "runtime.in"
  addFunc(ve, run::gen27, realArray(), "texsize", formal(primString(), "s", false, false), formal(primPen(), "p", true, false));
#line 1305 "runtime.in"
  addFunc(ve, run::gen28, pathArray()  , "_texpath", formal(primString(), "s", false, false), formal(primPen(), "p", true, false));
#line 1413 "runtime.in"
  addFunc(ve, run::gen29, pathArray()  , "textpath", formal(primString(), "s", false, false), formal(primPen(), "p", true, false));
#line 1477 "runtime.in"
  addFunc(ve, run::gen30, pathArray()  , "_strokepath", formal(primPath(), "g", false, false), formal(primPen(), "p", true, false));
#line 1502 "runtime.in"
  addFunc(ve, run::gen31, primVoid(), "_draw", formal(primPicture(), "f", false, false), formal(primPath(), "g", false, false), formal(primPen(), "p", false, false));
#line 1507 "runtime.in"
  addFunc(ve, run::gen32, primVoid(), "fill", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primPen(), "p", true, false), formal(primBoolean(), "copy", true, false));
#line 1513 "runtime.in"
  addFunc(ve, run::gen33, primVoid(), "latticeshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(penArray2()  , "p", false, false), formal(primBoolean(), "copy", true, false));
#line 1520 "runtime.in"
  addFunc(ve, run::gen34, primVoid(), "axialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false), formal(primBoolean(), "copy", true, false));
#line 1527 "runtime.in"
  addFunc(ve, run::gen35, primVoid(), "radialshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "pena", false, false), formal(primPair(), "a", false, false), formal(primReal(), "ra", false, false), formal(primPen(), "penb", false, false), formal(primPair(), "b", false, false), formal(primReal(), "rb", false, false), formal(primBoolean(), "copy", true, false));
#line 1534 "runtime.in"
  addFunc(ve, run::gen36, primVoid(), "gouraudshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(penArray()  , "p", false, false), formal(pairArray(), "z", false, false), formal(IntArray(), "edges", false, false), formal(primBoolean(), "copy", true, false));
#line 1545 "runtime.in"
  addFunc(ve, run::gen37, primVoid(), "gouraudshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(penArray()  , "p", false, false), formal(IntArray(), "edges", false, false), formal(primBoolean(), "copy", true, false));
#line 1569 "runtime.in"
  addFunc(ve, run::gen38, primVoid(), "tensorshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(penArray2()  , "p", false, false), formal(pathArray()  , "b", true, false), formal(pairArray2(), "z", true, false), formal(primBoolean(), "copy", true, false));
#line 1584 "runtime.in"
  addFunc(ve, run::gen39, primVoid(), "functionshade", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(primString() , "shader", true, false), formal(primBoolean(), "copy", true, false));
#line 1592 "runtime.in"
  addFunc(ve, run::gen40, primVoid(), "clip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(primBoolean(), "copy", true, false));
#line 1602 "runtime.in"
  addFunc(ve, run::gen41, primVoid(), "beginclip", formal(primPicture(), "f", false, false), formal(pathArray()  , "g", false, false), formal(primBoolean(), "stroke", true, false), formal(primPen(), "fillrule", true, false), formal(primBoolean(), "copy", true, false));
#line 1609 "runtime.in"
  addFunc(ve, run::gen42, primVoid(), "endclip", formal(primPicture(), "f", false, false));
#line 1614 "runtime.in"
  addFunc(ve, run::gen43, primVoid(), "gsave", formal(primPicture(), "f", false, false));
#line 1619 "runtime.in"
  addFunc(ve, run::gen44, primVoid(), "grestore", formal(primPicture(), "f", false, false));
#line 1624 "runtime.in"
  addFunc(ve, run::gen45, primVoid(), "begingroup", formal(primPicture(), "f", false, false));
#line 1629 "runtime.in"
  addFunc(ve, run::gen46, primVoid(), "endgroup", formal(primPicture(), "f", false, false));
#line 1634 "runtime.in"
  addFunc(ve, run::gen47, primVoid(), "add", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 1639 "runtime.in"
  addFunc(ve, run::gen48, primVoid(), "prepend", formal(primPicture(), "dest", false, false), formal(primPicture(), "src", false, false));
#line 1644 "runtime.in"
  addFunc(ve, run::gen49, primVoid(), "postscript", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 1649 "runtime.in"
  addFunc(ve, run::gen50, primVoid(), "tex", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false));
#line 1654 "runtime.in"
  addFunc(ve, run::gen51, primVoid(), "postscript", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false), formal(primPair(), "min", false, false), formal(primPair(), "max", false, false));
#line 1659 "runtime.in"
  addFunc(ve, run::gen52, primVoid(), "tex", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false), formal(primPair(), "min", false, false), formal(primPair(), "max", false, false));
#line 1664 "runtime.in"
  addFunc(ve, run::gen53, primVoid(), "texpreamble", formal(primString() , "s", false, false));
#line 1672 "runtime.in"
  addFunc(ve, run::gen54, primVoid(), "deletepreamble");
#line 1679 "runtime.in"
  addFunc(ve, run::gen55, primVoid(), "_labelpath", formal(primPicture(), "f", false, false), formal(primString() , "s", false, false), formal(primString() , "size", false, false), formal(primPath(), "g", false, false), formal(primString() , "justify", false, false), formal(primPair(), "offset", false, false), formal(primPen(), "p", false, false));
#line 1685 "runtime.in"
  addFunc(ve, run::gen56, primVoid(), "texreset");
#line 1693 "runtime.in"
  addFunc(ve, run::gen57, primVoid(), "layer", formal(primPicture(), "f", false, false));
#line 1698 "runtime.in"
  addFunc(ve, run::gen58, primVoid(), "newpage", formal(primPicture(), "f", false, false));
#line 1703 "runtime.in"
  addFunc(ve, run::gen59, primVoid(), "_image", formal(primPicture(), "f", false, false), formal(realArray2(), "data", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(penArray()  , "palette", true, false), formal(primTransform(), "t", true, false), formal(primBoolean(), "copy", true, false), formal(primBoolean(), "antialias", true, false));
#line 1713 "runtime.in"
  addFunc(ve, run::gen60, primVoid(), "_image", formal(primPicture(), "f", false, false), formal(penArray2()  , "data", false, false), formal(primPair(), "initial", false, false), formal(primPair(), "final", false, false), formal(primTransform(), "t", true, false), formal(primBoolean(), "copy", true, false), formal(primBoolean(), "antialias", true, false));
#line 1720 "runtime.in"
  addFunc(ve, run::gen61, primString() , "nativeformat");
#line 1725 "runtime.in"
  addFunc(ve, run::gen62, primBoolean(), "latex");
#line 1730 "runtime.in"
  addFunc(ve, run::gen63, primBoolean(), "pdf");
#line 1735 "runtime.in"
  addFunc(ve, run::gen64, primVoid(), "shipout", formal(primString() , "prefix", true, false), formal(primPicture(), "f", false, false), formal(primPicture(), "preamble", true, false), formal(primString() , "format", true, false), formal(primBoolean(), "wait", true, false), formal(primBoolean(), "view", true, false), formal(transformFunction(), "xform", false, false));
#line 1781 "runtime.in"
  addFunc(ve, run::gen65, primVoid(), "shipout3", formal(primString() , "prefix", false, false), formal(primPicture(), "f", false, false), formal(primString() , "format", true, false), formal(primReal(), "width", false, false), formal(primReal(), "height", false, false), formal(primReal(), "angle", false, false), formal(primReal(), "zoom", false, false), formal(primTriple(), "m", false, false), formal(primTriple(), "m", false, false), formal(primPair(), "shift", false, false), formal(realArray2(), "t", false, false), formal(realArray(), "background", false, false), formal(tripleArray(), "lights", false, false), formal(realArray2(), "diffuse", false, false), formal(realArray2(), "ambient", false, false), formal(realArray2(), "specular", false, false), formal(primBoolean(), "viewportlighting", false, false), formal(primBoolean(), "view", true, false));
#line 1799 "runtime.in"
  addFunc(ve, run::gen66, primVoid(), "shipout3", formal(primString() , "prefix", false, false), formal(primPicture(), "f", false, false));
#line 1804 "runtime.in"
  addFunc(ve, run::gen67, primVoid(), "deconstruct", formal(primPicture(), "f", false, false), formal(primPicture(), "preamble", true, false), formal(primReal(), "magnification", true, false), formal(transformFunction(), "xform", false, false));
#line 1937 "runtime.in"
  addFunc(ve, run::gen68, primVoid(), "purge", formal(primInt(), "divisor", true, false));
#line 1950 "runtime.in"
  addFunc(ve, run::gen70, primBoolean(), "==", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1955 "runtime.in"
  addFunc(ve, run::gen71, primBoolean(), "!=", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1960 "runtime.in"
  addFunc(ve, run::gen72, primPen(), "+", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false));
#line 1965 "runtime.in"
  addFunc(ve, run::gen73, primPen(), "*", formal(primReal(), "a", false, false), formal(primPen(), "b", false, false));
#line 1970 "runtime.in"
  addFunc(ve, run::gen74, primPen(), "*", formal(primPen(), "a", false, false), formal(primReal(), "b", false, false));
#line 1975 "runtime.in"
  addFunc(ve, run::gen75, primPair(), "max", formal(primPen(), "p", false, false));
#line 1980 "runtime.in"
  addFunc(ve, run::gen76, primPair(), "min", formal(primPen(), "p", false, false));
#line 1985 "runtime.in"
  addFunc(ve, run::gen77, primVoid(), "resetdefaultpen");
#line 1991 "runtime.in"
  addFunc(ve, run::gen78, primVoid(), "defaultpen", formal(primPen(), "p", false, false));
#line 1996 "runtime.in"
  addFunc(ve, run::gen79, primPen(), "defaultpen");
#line 2001 "runtime.in"
  addFunc(ve, run::gen80, primBoolean(), "invisible", formal(primPen(), "p", false, false));
#line 2006 "runtime.in"
  addFunc(ve, run::gen81, primPen(), "invisible");
#line 2011 "runtime.in"
  addFunc(ve, run::gen82, primPen(), "gray", formal(primPen(), "p", false, false));
#line 2017 "runtime.in"
  addFunc(ve, run::gen83, primPen(), "rgb", formal(primPen(), "p", false, false));
#line 2023 "runtime.in"
  addFunc(ve, run::gen84, primPen(), "cmyk", formal(primPen(), "p", false, false));
#line 2029 "runtime.in"
  addFunc(ve, run::gen85, primPen(), "interp", formal(primPen(), "a", false, false), formal(primPen(), "b", false, false), formal(primReal(), "t", false, false));
#line 2034 "runtime.in"
  addFunc(ve, run::gen86, primPen(), "rgb", formal(primReal(), "r", false, false), formal(primReal(), "g", false, false), formal(primReal(), "b", false, false));
#line 2039 "runtime.in"
  addFunc(ve, run::gen87, primPen(), "cmyk", formal(primReal(), "c", false, false), formal(primReal(), "m", false, false), formal(primReal(), "y", false, false), formal(primReal(), "k", false, false));
#line 2044 "runtime.in"
  addFunc(ve, run::gen88, primPen(), "gray", formal(primReal(), "gray", false, false));
#line 2049 "runtime.in"
  addFunc(ve, run::gen89, realArray(), "colors", formal(primPen(), "p", false, false));
#line 2077 "runtime.in"
  addFunc(ve, run::gen90, primString() , "colorspace", formal(primPen(), "p", false, false));
#line 2084 "runtime.in"
  addFunc(ve, run::gen91, primPen(), "pattern", formal(primString(), "s", false, false));
#line 2089 "runtime.in"
  addFunc(ve, run::gen92, primString() , "pattern", formal(primPen(), "p", false, false));
#line 2094 "runtime.in"
  addFunc(ve, run::gen93, primPen(), "fillrule", formal(primInt(), "n", false, false));
#line 2099 "runtime.in"
  addFunc(ve, run::gen94, primInt(), "fillrule", formal(primPen(), "p", false, false));
#line 2104 "runtime.in"
  addFunc(ve, run::gen95, primPen(), "opacity", formal(primReal(), "opacity", true, false), formal(primString() , "blend", true, false));
#line 2114 "runtime.in"
  addFunc(ve, run::gen96, primReal(), "opacity", formal(primPen(), "p", false, false));
#line 2119 "runtime.in"
  addFunc(ve, run::gen97, primString() , "blend", formal(primPen(), "p", false, false));
#line 2124 "runtime.in"
  addFunc(ve, run::gen98, primPen(), "linetype", formal(primString(), "s", false, false), formal(primReal(), "offset", true, false), formal(primBoolean(), "scale", true, false), formal(primBoolean(), "adjust", true, false));
#line 2129 "runtime.in"
  addFunc(ve, run::gen99, primString() , "linetype", formal(primPen(), "p", true, false));
#line 2134 "runtime.in"
  addFunc(ve, run::gen100, primReal(), "offset", formal(primPen(), "p", false, false));
#line 2139 "runtime.in"
  addFunc(ve, run::gen101, primBoolean(), "scale", formal(primPen(), "p", false, false));
#line 2144 "runtime.in"
  addFunc(ve, run::gen102, primBoolean(), "adjust", formal(primPen(), "p", false, false));
#line 2149 "runtime.in"
  addFunc(ve, run::gen103, primPen(), "adjust", formal(primPen(), "p", false, false), formal(primReal(), "arclength", false, false), formal(primBoolean(), "cyclic", false, false));
#line 2154 "runtime.in"
  addFunc(ve, run::gen104, primPen(), "linecap", formal(primInt(), "n", false, false));
#line 2159 "runtime.in"
  addFunc(ve, run::gen105, primInt(), "linecap", formal(primPen(), "p", true, false));
#line 2164 "runtime.in"
  addFunc(ve, run::gen106, primPen(), "linejoin", formal(primInt(), "n", false, false));
#line 2169 "runtime.in"
  addFunc(ve, run::gen107, primInt(), "linejoin", formal(primPen(), "p", true, false));
#line 2174 "runtime.in"
  addFunc(ve, run::gen108, primPen(), "miterlimit", formal(primReal(), "x", false, false));
#line 2179 "runtime.in"
  addFunc(ve, run::gen109, primReal(), "miterlimit", formal(primPen(), "p", true, false));
#line 2184 "runtime.in"
  addFunc(ve, run::gen110, primPen(), "linewidth", formal(primReal(), "x", false, false));
#line 2189 "runtime.in"
  addFunc(ve, run::gen111, primReal(), "linewidth", formal(primPen(), "p", true, false));
#line 2194 "runtime.in"
  addFunc(ve, run::gen112, primPen(), "fontcommand", formal(primString(), "s", false, false));
#line 2199 "runtime.in"
  addFunc(ve, run::gen113, primString() , "font", formal(primPen(), "p", true, false));
#line 2204 "runtime.in"
  addFunc(ve, run::gen114, primPen(), "fontsize", formal(primReal(), "size", false, false), formal(primReal(), "lineskip", false, false));
#line 2210 "runtime.in"
  addFunc(ve, run::gen115, primReal(), "fontsize", formal(primPen(), "p", true, false));
#line 2215 "runtime.in"
  addFunc(ve, run::gen116, primReal(), "lineskip", formal(primPen(), "p", true, false));
#line 2220 "runtime.in"
  addFunc(ve, run::gen117, primPen(), "overwrite", formal(primInt(), "n", false, false));
#line 2226 "runtime.in"
  addFunc(ve, run::gen118, primInt(), "overwrite", formal(primPen(), "p", true, false));
#line 2231 "runtime.in"
  addFunc(ve, run::gen119, primPen(), "basealign", formal(primInt(), "n", false, false));
#line 2236 "runtime.in"
  addFunc(ve, run::gen120, primInt(), "basealign", formal(primPen(), "p", true, false));
#line 2241 "runtime.in"
  addFunc(ve, run::gen121, primTransform(), "transform", formal(primPen(), "p", false, false));
#line 2246 "runtime.in"
  addFunc(ve, run::gen122, primPath(), "nib", formal(primPen(), "p", false, false));
#line 2251 "runtime.in"
  addFunc(ve, run::gen123, primPen(), "makepen", formal(primPath(), "p", false, false));
#line 2256 "runtime.in"
  addFunc(ve, run::gen124, primPen(), "colorless", formal(primPen(), "p", false, false));
#line 2262 "runtime.in"
  addFunc(ve, run::gen125, primBoolean(), "interactive");
#line 2269 "runtime.in"
  addFunc(ve, run::gen126, primBoolean(), "uptodate");
#line 2274 "runtime.in"
  addFunc(ve, run::gen127, primInt(), "system", formal(primString() , "s", false, false));
#line 2284 "runtime.in"
  addFunc(ve, run::gen128, primBoolean(), "view");
#line 2289 "runtime.in"
  addFunc(ve, run::gen129, primString() , "asydir");
#line 2294 "runtime.in"
  addFunc(ve, run::gen130, primString() , "locale", formal(primString() , "s", true, false));
#line 2300 "runtime.in"
  addFunc(ve, run::gen131, primVoid(), "abort", formal(primString() , "s", true, false));
#line 2306 "runtime.in"
  addFunc(ve, run::gen132, primVoid(), "exit");
#line 2311 "runtime.in"
  addFunc(ve, run::gen133, primVoid(), "assert", formal(primBoolean(), "b", false, false), formal(primString() , "s", true, false));
#line 2322 "runtime.in"
  addFunc(ve, run::gen134, primVoid(), "sleep", formal(primInt(), "seconds", false, false));
#line 2328 "runtime.in"
  addFunc(ve, run::gen135, primVoid(), "usleep", formal(primInt(), "microseconds", false, false));
#line 2334 "runtime.in"
  addFunc(ve, run::gen136, primVoid(), "_eval", formal(primString(), "s", false, false), formal(primBoolean(), "embedded", false, false), formal(primBoolean(), "interactivewrite", true, false));
#line 2349 "runtime.in"
  addFunc(ve, run::gen137, primVoid(), "_eval", formal(primCode(), "s", false, false), formal(primBoolean(), "embedded", false, false));
#line 2367 "runtime.in"
  addFunc(ve, run::gen138, primString() , "location");
#line 2379 "runtime.in"
  addFunc(ve, run::gen140, primString() , "cd", formal(primString() , "s", true, false));
#line 2385 "runtime.in"
  addFunc(ve, run::gen141, primVoid(), "list", formal(primString(), "s", false, false), formal(primBoolean(), "imports", true, false));
#line 2402 "runtime.in"
  addFunc(ve, run::gen143, primBoolean(), "==", formal(primPath(), "a", false, false), formal(primPath(), "b", false, false));
#line 2407 "runtime.in"
  addFunc(ve, run::gen144, primBoolean(), "!=", formal(primPath(), "a", false, false), formal(primPath(), "b", false, false));
#line 2412 "runtime.in"
  addFunc(ve, run::gen145, primPair(), "point", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 2417 "runtime.in"
  addFunc(ve, run::gen146, primPair(), "point", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 2422 "runtime.in"
  addFunc(ve, run::gen147, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 2427 "runtime.in"
  addFunc(ve, run::gen148, primPair(), "precontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 2432 "runtime.in"
  addFunc(ve, run::gen149, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 2437 "runtime.in"
  addFunc(ve, run::gen150, primPair(), "postcontrol", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 2442 "runtime.in"
  addFunc(ve, run::gen151, primPair(), "dir", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false), formal(primInt(), "sign", true, false), formal(primBoolean(), "normalize", true, false));
#line 2447 "runtime.in"
  addFunc(ve, run::gen152, primPair(), "dir", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false), formal(primBoolean(), "normalize", true, false));
#line 2452 "runtime.in"
  addFunc(ve, run::gen153, primPair(), "accel", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false), formal(primInt(), "sign", true, false));
#line 2457 "runtime.in"
  addFunc(ve, run::gen154, primPair(), "accel", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 2462 "runtime.in"
  addFunc(ve, run::gen155, primReal(), "radius", formal(primPath(), "p", false, false), formal(primReal(), "t", false, false));
#line 2474 "runtime.in"
  addFunc(ve, run::gen156, primPath(), "reverse", formal(primPath(), "p", false, false));
#line 2479 "runtime.in"
  addFunc(ve, run::gen157, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 2484 "runtime.in"
  addFunc(ve, run::gen158, primPath(), "subpath", formal(primPath(), "p", false, false), formal(primReal(), "a", false, false), formal(primReal(), "b", false, false));
#line 2489 "runtime.in"
  addFunc(ve, run::gen159, primPath(), "nurb", formal(primPair(), "z0", false, false), formal(primPair(), "z1", false, false), formal(primPair(), "z2", false, false), formal(primPair(), "z3", false, false), formal(primReal(), "w0", false, false), formal(primReal(), "w1", false, false), formal(primReal(), "w2", false, false), formal(primReal(), "w3", false, false), formal(primInt(), "m", false, false));
#line 2495 "runtime.in"
  addFunc(ve, run::gen160, primInt(), "length", formal(primPath(), "p", false, false));
#line 2500 "runtime.in"
  addFunc(ve, run::gen161, primBoolean(), "cyclic", formal(primPath(), "p", false, false));
#line 2505 "runtime.in"
  addFunc(ve, run::gen162, primBoolean(), "straight", formal(primPath(), "p", false, false), formal(primInt(), "t", false, false));
#line 2510 "runtime.in"
  addFunc(ve, run::gen163, primPath(), "unstraighten", formal(primPath(), "p", false, false));
#line 2515 "runtime.in"
  addFunc(ve, run::gen164, primBoolean(), "piecewisestraight", formal(primPath(), "p", false, false));
#line 2520 "runtime.in"
  addFunc(ve, run::gen165, primReal(), "arclength", formal(primPath(), "p", false, false));
#line 2525 "runtime.in"
  addFunc(ve, run::gen166, primReal(), "arctime", formal(primPath(), "p", false, false), formal(primReal(), "dval", false, false));
#line 2530 "runtime.in"
  addFunc(ve, run::gen167, primReal(), "dirtime", formal(primPath(), "p", false, false), formal(primPair(), "z", false, false));
#line 2535 "runtime.in"
  addFunc(ve, run::gen168, realArray(), "intersect", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false), formal(primReal(), "fuzz", true, false));
#line 2552 "runtime.in"
  addFunc(ve, run::gen169, realArray2(), "intersections", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false), formal(primReal(), "fuzz", true, false));
#line 2583 "runtime.in"
  addFunc(ve, run::gen170, realArray(), "intersections", formal(primPath(), "p", false, false), formal(primPair(), "a", false, true), formal(primPair(), "b", false, true), formal(primReal(), "fuzz", true, false));
#line 2598 "runtime.in"
  addFunc(ve, run::gen171, primPair(), "extension", formal(primPair(), "p", false, false), formal(primPair(), "q", false, false), formal(primPair(), "p", false, false), formal(primPair(), "q", false, false));
#line 2609 "runtime.in"
  addFunc(ve, run::gen172, primInt(), "size", formal(primPath(), "p", false, false));
#line 2614 "runtime.in"
  addFunc(ve, run::gen173, primPath(), "&", formal(primPath(), "p", false, false), formal(primPath(), "q", false, false));
#line 2619 "runtime.in"
  addFunc(ve, run::gen174, primPair(), "min", formal(primPath(), "p", false, false));
#line 2624 "runtime.in"
  addFunc(ve, run::gen175, primPair(), "max", formal(primPath(), "p", false, false));
#line 2629 "runtime.in"
  addFunc(ve, run::gen176, realArray(), "mintimes", formal(primPath(), "p", false, false));
#line 2638 "runtime.in"
  addFunc(ve, run::gen177, realArray(), "maxtimes", formal(primPath(), "p", false, false));
#line 2647 "runtime.in"
  addFunc(ve, run::gen178, primReal(), "relativedistance", formal(primReal(), "theta", false, false), formal(primReal(), "phi", false, false), formal(primReal(), "t", false, false), formal(primBoolean(), "atleast", false, false));
#line 2652 "runtime.in"
  addFunc(ve, run::gen179, primInt(), "windingnumber", formal(pathArray()  , "p", false, false), formal(primPair(), "z", false, false));
#line 2657 "runtime.in"
  addFunc(ve, run::gen180, primBoolean(), "inside", formal(pathArray()  , "g", false, true), formal(primPair(), "z", false, false), formal(primPen(), "fillrule", true, false));
#line 2662 "runtime.in"
  addFunc(ve, run::gen181, primBoolean(), "inside", formal(primPath(), "g", false, false), formal(primPair(), "z", false, false), formal(primPen(), "fillrule", true, false));
#line 2667 "runtime.in"
  addFunc(ve, run::gen182, primReal(), "side", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false), formal(primPair(), "c", false, false));
#line 2674 "runtime.in"
  addFunc(ve, run::gen183, primReal(), "incircle", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false), formal(primPair(), "c", false, false), formal(primPair(), "d", false, false));
#line 2682 "runtime.in"
  addFunc(ve, run::gen184, primPath3(), "path3", formal(tripleArray(), "pre", false, false), formal(tripleArray(), "point", false, false), formal(tripleArray(), "post", false, false), formal(boolArray(), "straight", false, false), formal(primBoolean(), "cyclic", false, false));
#line 2707 "runtime.in"
  addFunc(ve, run::gen186, primBoolean(), "==", formal(primPath3(), "a", false, false), formal(primPath3(), "b", false, false));
#line 2712 "runtime.in"
  addFunc(ve, run::gen187, primBoolean(), "!=", formal(primPath3(), "a", false, false), formal(primPath3(), "b", false, false));
#line 2717 "runtime.in"
  addFunc(ve, run::gen188, primTriple(), "point", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false));
#line 2722 "runtime.in"
  addFunc(ve, run::gen189, primTriple(), "point", formal(primPath3(), "p", false, false), formal(primReal(), "t", false, false));
#line 2727 "runtime.in"
  addFunc(ve, run::gen190, primTriple(), "precontrol", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false));
#line 2732 "runtime.in"
  addFunc(ve, run::gen191, primTriple(), "precontrol", formal(primPath3(), "p", false, false), formal(primReal(), "t", false, false));
#line 2737 "runtime.in"
  addFunc(ve, run::gen192, primTriple(), "postcontrol", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false));
#line 2742 "runtime.in"
  addFunc(ve, run::gen193, primTriple(), "postcontrol", formal(primPath3(), "p", false, false), formal(primReal(), "t", false, false));
#line 2747 "runtime.in"
  addFunc(ve, run::gen194, primTriple(), "dir", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false), formal(primInt(), "sign", true, false), formal(primBoolean(), "normalize", true, false));
#line 2752 "runtime.in"
  addFunc(ve, run::gen195, primTriple(), "dir", formal(primPath3(), "p", false, false), formal(primReal(), "t", false, false), formal(primBoolean(), "normalize", true, false));
#line 2757 "runtime.in"
  addFunc(ve, run::gen196, primTriple(), "accel", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false), formal(primInt(), "sign", true, false));
#line 2762 "runtime.in"
  addFunc(ve, run::gen197, primTriple(), "accel", formal(primPath3(), "p", false, false), formal(primReal(), "t", false, false));
#line 2767 "runtime.in"
  addFunc(ve, run::gen198, primReal(), "radius", formal(primPath3(), "p", false, false), formal(primReal(), "t", false, false));
#line 2779 "runtime.in"
  addFunc(ve, run::gen199, primReal(), "radius", formal(primTriple(), "z0", false, false), formal(primTriple(), "c0", false, false), formal(primTriple(), "c1", false, false), formal(primTriple(), "z1", false, false), formal(primReal(), "t", false, false));
#line 2791 "runtime.in"
  addFunc(ve, run::gen200, primPath3(), "reverse", formal(primPath3(), "p", false, false));
#line 2796 "runtime.in"
  addFunc(ve, run::gen201, primPath3(), "subpath", formal(primPath3(), "p", false, false), formal(primInt(), "a", false, false), formal(primInt(), "b", false, false));
#line 2801 "runtime.in"
  addFunc(ve, run::gen202, primPath3(), "subpath", formal(primPath3(), "p", false, false), formal(primReal(), "a", false, false), formal(primReal(), "b", false, false));
#line 2806 "runtime.in"
  addFunc(ve, run::gen203, primInt(), "length", formal(primPath3(), "p", false, false));
#line 2811 "runtime.in"
  addFunc(ve, run::gen204, primBoolean(), "cyclic", formal(primPath3(), "p", false, false));
#line 2816 "runtime.in"
  addFunc(ve, run::gen205, primBoolean(), "straight", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false));
#line 2821 "runtime.in"
  addFunc(ve, run::gen206, primTriple(), "perp", formal(primTriple(), "v", false, false), formal(primTriple(), "u", false, false));
#line 2827 "runtime.in"
  addFunc(ve, run::gen207, primReal(), "straightness", formal(primPath3(), "p", false, false), formal(primInt(), "t", false, false));
#line 2838 "runtime.in"
  addFunc(ve, run::gen208, primReal(), "straightness", formal(primTriple(), "z0", false, false), formal(primTriple(), "c0", false, false), formal(primTriple(), "c1", false, false), formal(primTriple(), "z1", false, false));
#line 2846 "runtime.in"
  addFunc(ve, run::gen209, primBoolean(), "piecewisestraight", formal(primPath3(), "p", false, false));
#line 2851 "runtime.in"
  addFunc(ve, run::gen210, primReal(), "arclength", formal(primPath3(), "p", false, false));
#line 2856 "runtime.in"
  addFunc(ve, run::gen211, primReal(), "arctime", formal(primPath3(), "p", false, false), formal(primReal(), "dval", false, false));
#line 2861 "runtime.in"
  addFunc(ve, run::gen212, realArray(), "intersect", formal(primPath3(), "p", false, false), formal(primPath3(), "q", false, false), formal(primReal(), "fuzz", true, false));
#line 2879 "runtime.in"
  addFunc(ve, run::gen213, realArray2(), "intersections", formal(primPath3(), "p", false, false), formal(primPath3(), "q", false, false), formal(primReal(), "fuzz", true, false));
#line 2912 "runtime.in"
  addFunc(ve, run::gen214, realArray2(), "intersections", formal(primPath3(), "p", false, false), formal(tripleArray2(), "p", false, false), formal(primReal(), "fuzz", true, false));
#line 2932 "runtime.in"
  addFunc(ve, run::gen215, primInt(), "size", formal(primPath3(), "p", false, false));
#line 2937 "runtime.in"
  addFunc(ve, run::gen216, primPath3(), "&", formal(primPath3(), "p", false, false), formal(primPath3(), "q", false, false));
#line 2942 "runtime.in"
  addFunc(ve, run::gen217, primTriple(), "min", formal(primPath3(), "p", false, false));
#line 2947 "runtime.in"
  addFunc(ve, run::gen218, primTriple(), "max", formal(primPath3(), "p", false, false));
#line 2952 "runtime.in"
  addFunc(ve, run::gen219, realArray(), "mintimes", formal(primPath3(), "p", false, false));
#line 2962 "runtime.in"
  addFunc(ve, run::gen220, realArray(), "maxtimes", formal(primPath3(), "p", false, false));
#line 2972 "runtime.in"
  addFunc(ve, run::gen221, primPath3(), "*", formal(realArray2(), "t", false, false), formal(primPath3(), "g", false, false));
#line 3027 "runtime.in"
  addFunc(ve, run::gen226, primGuide(), "operator cast", formal(primCycleToken(), "tok", false, false));
#line 3034 "runtime.in"
  addFunc(ve, run::gen227, primGuide(), "operator spec", formal(primPair(), "z", false, false), formal(primInt(), "p", false, false));
#line 3042 "runtime.in"
  addFunc(ve, run::gen228, primCurlSpecifier(), "operator curl", formal(primReal(), "gamma", false, false), formal(primInt(), "p", false, false));
#line 3058 "runtime.in"
  addFunc(ve, run::gen231, primGuide(), "operator cast", formal(primCurlSpecifier(), "spec", false, false));
#line 3063 "runtime.in"
  addFunc(ve, run::gen232, primTensionSpecifier(), "operator tension", formal(primReal(), "tout", false, false), formal(primReal(), "tin", false, false), formal(primBoolean(), "atleast", false, false));
#line 3083 "runtime.in"
  addFunc(ve, run::gen236, primGuide(), "operator cast", formal(primTensionSpecifier(), "t", false, false));
#line 3088 "runtime.in"
  addFunc(ve, run::gen237, primGuide(), "operator controls", formal(primPair(), "zout", false, false), formal(primPair(), "zin", false, false));
#line 3093 "runtime.in"
  addFunc(ve, run::gen238, primInt(), "size", formal(primGuide(), "g", false, false));
#line 3100 "runtime.in"
  addFunc(ve, run::gen239, primInt(), "length", formal(primGuide(), "g", false, false));
#line 3107 "runtime.in"
  addFunc(ve, run::gen240, primBoolean(), "cyclic", formal(primGuide(), "g", false, false));
#line 3114 "runtime.in"
  addFunc(ve, run::gen241, primPair(), "point", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 3121 "runtime.in"
  addFunc(ve, run::gen242, pairArray(), "dirSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 3133 "runtime.in"
  addFunc(ve, run::gen243, pairArray(), "controlSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 3150 "runtime.in"
  addFunc(ve, run::gen244, primTensionSpecifier(), "tensionSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 3160 "runtime.in"
  addFunc(ve, run::gen245, realArray(), "curlSpecifier", formal(primGuide(), "g", false, false), formal(primInt(), "t", false, false));
#line 3174 "runtime.in"
  addFunc(ve, run::gen246, primGuide(), "reverse", formal(primGuide(), "g", false, false));
#line 3228 "runtime.in"
  addFunc(ve, run::gen247, primVoid(), "_draw", formal(primPicture(), "f", false, false), formal(primPath3(), "g", false, false), formal(primPen(), "p", false, false));
#line 3237 "runtime.in"
  addFunc(ve, run::gen248, primVoid(), "draw", formal(primPicture(), "f", false, false), formal(tripleArray2(), "g", false, false), formal(primBoolean(), "straight", false, false), formal(penArray()  , "p", false, false), formal(primReal(), "opacity", false, false), formal(primReal(), "shininess", false, false), formal(primReal(), "granularity", false, false), formal(primTriple(), "normal", false, false), formal(primBoolean(), "lighton", false, false), formal(penArray()  , "colors", false, false));
#line 3245 "runtime.in"
  addFunc(ve, run::gen249, primTriple(), "min3", formal(primPicture(), "f", false, false));
#line 3250 "runtime.in"
  addFunc(ve, run::gen250, primTriple(), "max3", formal(primPicture(), "f", false, false));
#line 3255 "runtime.in"
  addFunc(ve, run::gen251, primPair(), "min", formal(primPicture(), "f", false, false), formal(realArray2(), "t", false, false));
#line 3263 "runtime.in"
  addFunc(ve, run::gen252, primPair(), "max", formal(primPicture(), "f", false, false), formal(realArray2(), "t", false, false));
#line 3271 "runtime.in"
  addFunc(ve, run::gen253, primPair(), "minratio", formal(primPicture(), "f", false, false));
#line 3276 "runtime.in"
  addFunc(ve, run::gen254, primPair(), "maxratio", formal(primPicture(), "f", false, false));
#line 3281 "runtime.in"
  addFunc(ve, run::gen255, primTriple(), "minbound", formal(tripleArray2(), "p", false, false), formal(primTriple(), "b", false, false));
#line 3291 "runtime.in"
  addFunc(ve, run::gen256, primTriple(), "maxbound", formal(tripleArray2(), "p", false, false), formal(primTriple(), "b", false, false));
#line 3301 "runtime.in"
  addFunc(ve, run::gen257, primPair(), "minbound", formal(tripleArray2(), "p", false, false), formal(realArray2(), "t", false, false), formal(primPair(), "b", false, false));
#line 3313 "runtime.in"
  addFunc(ve, run::gen258, primPair(), "maxbound", formal(tripleArray2(), "p", false, false), formal(realArray2(), "t", false, false), formal(primPair(), "b", false, false));
#line 3325 "runtime.in"
  addFunc(ve, run::gen259, primPair(), "max", formal(primPath3(), "g", false, false), formal(realArray2(), "t", false, false));
#line 3333 "runtime.in"
  addFunc(ve, run::gen260, primPair(), "min", formal(primPath3(), "g", false, false), formal(realArray2(), "t", false, false));
#line 3341 "runtime.in"
  addFunc(ve, run::gen261, primReal(), "change2", formal(tripleArray2(), "a", false, false));
#line 3363 "runtime.in"
  addFunc(ve, run::gen262, primBoolean(), "is3D", formal(primPicture(), "f", false, false));
#line 3368 "runtime.in"
  addFunc(ve, run::gen263, primPair(), "bezier", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false), formal(primPair(), "c", false, false), formal(primPair(), "d", false, false), formal(primReal(), "t", false, false));
#line 3375 "runtime.in"
  addFunc(ve, run::gen264, primPair(), "bezierP", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false), formal(primPair(), "c", false, false), formal(primPair(), "d", false, false), formal(primReal(), "t", false, false));
#line 3380 "runtime.in"
  addFunc(ve, run::gen265, primPair(), "bezierPP", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false), formal(primPair(), "c", false, false), formal(primPair(), "d", false, false), formal(primReal(), "t", false, false));
#line 3385 "runtime.in"
  addFunc(ve, run::gen266, primPair(), "bezierPPP", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false), formal(primPair(), "c", false, false), formal(primPair(), "d", false, false));
#line 3390 "runtime.in"
  addFunc(ve, run::gen267, primTriple(), "bezier", formal(primTriple(), "a", false, false), formal(primTriple(), "b", false, false), formal(primTriple(), "c", false, false), formal(primTriple(), "d", false, false), formal(primReal(), "t", false, false));
#line 3397 "runtime.in"
  addFunc(ve, run::gen268, primTriple(), "bezierP", formal(primTriple(), "a", false, false), formal(primTriple(), "b", false, false), formal(primTriple(), "c", false, false), formal(primTriple(), "d", false, false), formal(primReal(), "t", false, false));
#line 3402 "runtime.in"
  addFunc(ve, run::gen269, primTriple(), "bezierPP", formal(primTriple(), "a", false, false), formal(primTriple(), "b", false, false), formal(primTriple(), "c", false, false), formal(primTriple(), "d", false, false), formal(primReal(), "t", false, false));
#line 3407 "runtime.in"
  addFunc(ve, run::gen270, primTriple(), "bezierPPP", formal(primTriple(), "a", false, false), formal(primTriple(), "b", false, false), formal(primTriple(), "c", false, false), formal(primTriple(), "d", false, false));
#line 3420 "runtime.in"
  addFunc(ve, run::gen272, primInt(), "length", formal(primString(), "s", false, false));
#line 3425 "runtime.in"
  addFunc(ve, run::gen273, primInt(), "find", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 3431 "runtime.in"
  addFunc(ve, run::gen274, primInt(), "rfind", formal(primString(), "s", false, false), formal(primString() , "t", false, false), formal(primInt(), "pos", true, false));
#line 3437 "runtime.in"
  addFunc(ve, run::gen275, primString() , "reverse", formal(primString() , "s", false, false));
#line 3443 "runtime.in"
  addFunc(ve, run::gen276, primString() , "insert", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primString() , "t", false, false));
#line 3450 "runtime.in"
  addFunc(ve, run::gen277, primString() , "substr", formal(primString(), "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", true, false));
#line 3457 "runtime.in"
  addFunc(ve, run::gen278, primString() , "erase", formal(primString() , "s", false, false), formal(primInt(), "pos", false, false), formal(primInt(), "n", false, false));
#line 3464 "runtime.in"
  addFunc(ve, run::gen279, primString() , "downcase", formal(primString() , "s", false, false));
#line 3470 "runtime.in"
  addFunc(ve, run::gen280, primString() , "upcase", formal(primString() , "s", false, false));
#line 3476 "runtime.in"
  addFunc(ve, run::gen281, primString() , "replace", formal(primString(), "s", false, false), formal(stringArray2(), "translate", false, false));
#line 3503 "runtime.in"
  addFunc(ve, run::gen282, primString() , "format", formal(primString(), "format", false, false), formal(primInt(), "x", false, false));
#line 3518 "runtime.in"
  addFunc(ve, run::gen283, primString() , "format", formal(primString(), "format", false, false), formal(primReal(), "x", false, false), formal(primString() , "locale", true, false));
#line 3643 "runtime.in"
  addFunc(ve, run::gen284, primInt(), "hex", formal(primString() , "s", false, false));
#line 3654 "runtime.in"
  addFunc(ve, run::gen285, primString() , "string", formal(primInt(), "x", false, false));
#line 3661 "runtime.in"
  addFunc(ve, run::gen286, primString() , "string", formal(primReal(), "x", false, false), formal(primInt(), "digits", true, false));
#line 3669 "runtime.in"
  addFunc(ve, run::gen287, primString() , "time", formal(primString() , "format", true, false));
#line 3680 "runtime.in"
  addFunc(ve, run::gen288, primString() , "time", formal(primInt(), "seconds", false, false), formal(primString() , "format", true, false));
#line 3693 "runtime.in"
  addFunc(ve, run::gen289, primInt(), "seconds", formal(primString() , "t", true, false), formal(primString() , "format", true, false));
#line 3705 "runtime.in"
  addFunc(ve, run::gen290, realArray(), "_cputime");
#line 3719 "runtime.in"
  addFunc(ve, run::gen291, primReal(), "^", formal(primReal(), "x", false, false), formal(primInt(), "y", false, false));
#line 3727 "runtime.in"
  addFunc(ve, run::gen292, primPair(), "^", formal(primPair(), "z", false, false), formal(primInt(), "y", false, false));
#line 3732 "runtime.in"
  addFunc(ve, run::gen293, primInt(), "quotient", formal(primInt(), "x", false, false), formal(primInt(), "y", false, false));
#line 3740 "runtime.in"
  addFunc(ve, run::gen294, primInt(), "abs", formal(primInt(), "x", false, false));
#line 3745 "runtime.in"
  addFunc(ve, run::gen295, primInt(), "sgn", formal(primReal(), "x", false, false));
#line 3750 "runtime.in"
  addFunc(ve, run::gen296, primInt(), "rand");
#line 3755 "runtime.in"
  addFunc(ve, run::gen297, primVoid(), "srand", formal(primInt(), "seed", false, false));
#line 3760 "runtime.in"
  addFunc(ve, run::gen298, primReal(), "unitrand");
#line 3766 "runtime.in"
  addFunc(ve, run::gen299, primInt(), "ceil", formal(primReal(), "x", false, false));
#line 3771 "runtime.in"
  addFunc(ve, run::gen300, primInt(), "floor", formal(primReal(), "x", false, false));
#line 3776 "runtime.in"
  addFunc(ve, run::gen301, primInt(), "round", formal(primReal(), "x", false, false));
#line 3782 "runtime.in"
  addFunc(ve, run::gen302, primInt(), "Ceil", formal(primReal(), "x", false, false));
#line 3787 "runtime.in"
  addFunc(ve, run::gen303, primInt(), "Floor", formal(primReal(), "x", false, false));
#line 3792 "runtime.in"
  addFunc(ve, run::gen304, primInt(), "Round", formal(primReal(), "x", false, false));
#line 3797 "runtime.in"
  addFunc(ve, run::gen305, primReal(), "fmod", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 3803 "runtime.in"
  addFunc(ve, run::gen306, primReal(), "atan2", formal(primReal(), "y", false, false), formal(primReal(), "x", false, false));
#line 3808 "runtime.in"
  addFunc(ve, run::gen307, primReal(), "hypot", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 3813 "runtime.in"
  addFunc(ve, run::gen308, primReal(), "remainder", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 3818 "runtime.in"
  addFunc(ve, run::gen309, primReal(), "J", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 3823 "runtime.in"
  addFunc(ve, run::gen310, primReal(), "Y", formal(primInt(), "n", false, false), formal(primReal(), "x", false, false));
#line 3828 "runtime.in"
  addFunc(ve, run::gen311, primReal(), "erf", formal(primReal(), "x", false, false));
#line 3833 "runtime.in"
  addFunc(ve, run::gen312, primReal(), "erfc", formal(primReal(), "x", false, false));
#line 3838 "runtime.in"
  addFunc(ve, run::gen313, primInt(), "factorial", formal(primInt(), "n", false, false));
#line 3843 "runtime.in"
  addFunc(ve, run::gen314, primInt(), "choose", formal(primInt(), "n", false, false), formal(primInt(), "k", false, false));
#line 3854 "runtime.in"
  addFunc(ve, run::gen315, primReal(), "gamma", formal(primReal(), "x", false, false));
#line 3864 "runtime.in"
  addFunc(ve, run::gen316, primPair(), "gamma", formal(primPair(), "z", false, true));
#line 3870 "runtime.in"
  addFunc(ve, run::gen317, realArray(), "quadraticroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false));
#line 3879 "runtime.in"
  addFunc(ve, run::gen318, pairArray(), "quadraticroots", formal(primPair(), "a", false, true), formal(primPair(), "b", false, true), formal(primPair(), "c", false, true));
#line 3888 "runtime.in"
  addFunc(ve, run::gen319, realArray(), "cubicroots", formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "c", false, false), formal(primReal(), "d", false, false));
#line 3898 "runtime.in"
  addFunc(ve, run::gen320, primBoolean(), "==", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 3906 "runtime.in"
  addFunc(ve, run::gen321, primBoolean(), "!=", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 3911 "runtime.in"
  addFunc(ve, run::gen322, primTransform(), "+", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 3916 "runtime.in"
  addFunc(ve, run::gen323, primTransform(), "*", formal(primTransform(), "a", false, false), formal(primTransform(), "b", false, false));
#line 3921 "runtime.in"
  addFunc(ve, run::gen324, primPair(), "*", formal(primTransform(), "t", false, false), formal(primPair(), "z", false, false));
#line 3926 "runtime.in"
  addFunc(ve, run::gen325, primPath(), "*", formal(primTransform(), "t", false, false), formal(primPath(), "g", false, false));
#line 3931 "runtime.in"
  addFunc(ve, run::gen326, primPen(), "*", formal(primTransform(), "t", false, false), formal(primPen(), "p", false, false));
#line 3936 "runtime.in"
  addFunc(ve, run::gen327, primPicture(), "*", formal(primTransform(), "t", false, false), formal(primPicture(), "f", false, false));
#line 3941 "runtime.in"
  addFunc(ve, run::gen328, primPicture(), "*", formal(realArray2(), "t", false, false), formal(primPicture(), "f", false, false));
#line 3946 "runtime.in"
  addFunc(ve, run::gen329, primTransform(), "^", formal(primTransform(), "t", false, false), formal(primInt(), "n", false, false));
#line 3993 "runtime.in"
  addFunc(ve, run::gen337, primTransform(), "shift", formal(primTransform(), "t", false, false));
#line 3998 "runtime.in"
  addFunc(ve, run::gen338, primTransform(), "shiftless", formal(primTransform(), "t", false, false));
#line 4003 "runtime.in"
  addFunc(ve, run::transformIdentity, primTransform(), "identity");
#line 4008 "runtime.in"
  addFunc(ve, run::gen340, primTransform(), "inverse", formal(primTransform(), "t", false, false));
#line 4013 "runtime.in"
  addFunc(ve, run::gen341, primTransform(), "shift", formal(primPair(), "z", false, false));
#line 4018 "runtime.in"
  addFunc(ve, run::gen342, primTransform(), "shift", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 4023 "runtime.in"
  addFunc(ve, run::gen343, primTransform(), "xscale", formal(primReal(), "x", false, false));
#line 4028 "runtime.in"
  addFunc(ve, run::gen344, primTransform(), "yscale", formal(primReal(), "y", false, false));
#line 4033 "runtime.in"
  addFunc(ve, run::gen345, primTransform(), "scale", formal(primReal(), "x", false, false));
#line 4038 "runtime.in"
  addFunc(ve, run::gen346, primTransform(), "scale", formal(primReal(), "x", false, false), formal(primReal(), "y", false, false));
#line 4043 "runtime.in"
  addFunc(ve, run::gen347, primTransform(), "slant", formal(primReal(), "s", false, false));
#line 4048 "runtime.in"
  addFunc(ve, run::gen348, primTransform(), "rotate", formal(primReal(), "angle", false, false), formal(primPair(), "z", true, false));
#line 4053 "runtime.in"
  addFunc(ve, run::gen349, primTransform(), "reflect", formal(primPair(), "a", false, false), formal(primPair(), "b", false, false));
#line 4076 "runtime.in"
  addFunc(ve, run::pairXPart, primReal(), "xpart", formal(primPair(), "z", false, false));
#line 4081 "runtime.in"
  addFunc(ve, run::pairYPart, primReal(), "ypart", formal(primPair(), "z", false, false));
#line 4086 "runtime.in"
  addFunc(ve, run::gen355, primReal(), "length", formal(primPair(), "z", false, false));
#line 4091 "runtime.in"
  addFunc(ve, run::gen356, primReal(), "abs", formal(primPair(), "z", false, false));
#line 4096 "runtime.in"
  addFunc(ve, run::gen357, primPair(), "sqrt", formal(primPair(), "z", false, true));
#line 4101 "runtime.in"
  addFunc(ve, run::gen358, primReal(), "angle", formal(primPair(), "z", false, false), formal(primBoolean(), "warn", true, false));
#line 4108 "runtime.in"
  addFunc(ve, run::gen359, primReal(), "degrees", formal(primPair(), "z", false, false), formal(primBoolean(), "warn", true, false));
#line 4115 "runtime.in"
  addFunc(ve, run::gen360, primReal(), "radians", formal(primReal(), "degrees", false, false));
#line 4121 "runtime.in"
  addFunc(ve, run::gen361, primReal(), "degrees", formal(primReal(), "radians", false, false));
#line 4127 "runtime.in"
  addFunc(ve, run::gen362, primReal(), "Degrees", formal(primReal(), "radians", false, false));
#line 4133 "runtime.in"
  addFunc(ve, run::gen363, primReal(), "Sin", formal(primReal(), "deg", false, false));
#line 4138 "runtime.in"
  addFunc(ve, run::gen364, primReal(), "Cos", formal(primReal(), "deg", false, false));
#line 4143 "runtime.in"
  addFunc(ve, run::gen365, primReal(), "Tan", formal(primReal(), "deg", false, false));
#line 4148 "runtime.in"
  addFunc(ve, run::gen366, primReal(), "aSin", formal(primReal(), "x", false, false));
#line 4153 "runtime.in"
  addFunc(ve, run::gen367, primReal(), "aCos", formal(primReal(), "x", false, false));
#line 4158 "runtime.in"
  addFunc(ve, run::gen368, primReal(), "aTan", formal(primReal(), "x", false, false));
#line 4163 "runtime.in"
  addFunc(ve, run::gen369, primPair(), "unit", formal(primPair(), "z", false, false));
#line 4168 "runtime.in"
  addFunc(ve, run::gen370, primPair(), "dir", formal(primReal(), "degrees", false, false));
#line 4173 "runtime.in"
  addFunc(ve, run::gen371, primPair(), "dir", formal(primPair(), "z", false, true));
#line 4178 "runtime.in"
  addFunc(ve, run::gen372, primPair(), "expi", formal(primReal(), "angle", false, false));
#line 4183 "runtime.in"
  addFunc(ve, run::gen373, primPair(), "exp", formal(primPair(), "z", false, true));
#line 4188 "runtime.in"
  addFunc(ve, run::gen374, primPair(), "log", formal(primPair(), "z", false, true));
#line 4193 "runtime.in"
  addFunc(ve, run::gen375, primPair(), "sin", formal(primPair(), "z", false, true));
#line 4198 "runtime.in"
  addFunc(ve, run::gen376, primPair(), "cos", formal(primPair(), "z", false, true));
#line 4203 "runtime.in"
  addFunc(ve, run::gen377, primPair(), "conj", formal(primPair(), "z", false, false));
#line 4208 "runtime.in"
  addFunc(ve, run::gen378, primPair(), "realmult", formal(primPair(), "z", false, false), formal(primPair(), "w", false, false));
#line 4213 "runtime.in"
  addFunc(ve, run::gen379, primTriple(), "realmult", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 4218 "runtime.in"
  addFunc(ve, run::gen380, primReal(), "dot", formal(primPair(), "z", false, true), formal(primPair(), "w", false, true));
#line 4238 "runtime.in"
  addFunc(ve, run::tripleXPart, primReal(), "xpart", formal(primTriple(), "v", false, false));
#line 4243 "runtime.in"
  addFunc(ve, run::tripleYPart, primReal(), "ypart", formal(primTriple(), "v", false, false));
#line 4248 "runtime.in"
  addFunc(ve, run::tripleZPart, primReal(), "zpart", formal(primTriple(), "v", false, false));
#line 4253 "runtime.in"
  addFunc(ve, run::gen386, primTriple(), "*", formal(primReal(), "x", false, false), formal(primTriple(), "v", false, false));
#line 4258 "runtime.in"
  addFunc(ve, run::gen387, primTriple(), "*", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 4263 "runtime.in"
  addFunc(ve, run::gen388, primTriple(), "/", formal(primTriple(), "v", false, false), formal(primReal(), "x", false, false));
#line 4268 "runtime.in"
  addFunc(ve, run::gen389, primReal(), "length", formal(primTriple(), "v", false, false));
#line 4273 "runtime.in"
  addFunc(ve, run::gen390, primReal(), "abs", formal(primTriple(), "v", false, false));
#line 4278 "runtime.in"
  addFunc(ve, run::gen391, primReal(), "polar", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 4284 "runtime.in"
  addFunc(ve, run::gen392, primReal(), "azimuth", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 4290 "runtime.in"
  addFunc(ve, run::gen393, primReal(), "colatitude", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 4296 "runtime.in"
  addFunc(ve, run::gen394, primReal(), "latitude", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 4302 "runtime.in"
  addFunc(ve, run::gen395, primReal(), "longitude", formal(primTriple(), "v", false, false), formal(primBoolean(), "warn", true, false));
#line 4309 "runtime.in"
  addFunc(ve, run::gen396, primTriple(), "unit", formal(primTriple(), "v", false, false));
#line 4314 "runtime.in"
  addFunc(ve, run::gen397, primReal(), "dot", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 4319 "runtime.in"
  addFunc(ve, run::gen398, primTriple(), "cross", formal(primTriple(), "u", false, false), formal(primTriple(), "v", false, false));
#line 4324 "runtime.in"
  addFunc(ve, run::gen399, primTriple(), "expi", formal(primReal(), "polar", false, false), formal(primReal(), "azimuth", false, false));
#line 4329 "runtime.in"
  addFunc(ve, run::gen400, primTriple(), "dir", formal(primReal(), "colatitude", false, false), formal(primReal(), "longitude", false, false));
#line 4334 "runtime.in"
  addFunc(ve, run::gen401, primVoid(), "atupdate", formal(voidFunction(), "f", false, false));
#line 4342 "runtime.in"
  addFunc(ve, run::gen402, voidFunction(), "atupdate");
#line 4347 "runtime.in"
  addFunc(ve, run::gen403, primVoid(), "atexit", formal(voidFunction(), "f", false, false));
#line 4352 "runtime.in"
  addFunc(ve, run::gen404, voidFunction(), "atexit");
#line 4357 "runtime.in"
  addFunc(ve, run::gen405, primVoid(), "atbreakpoint", formal(breakpointFunction(), "f", false, false));
#line 4362 "runtime.in"
  addFunc(ve, run::gen406, primVoid(), "breakpoint", formal(primCode(), "s", true, false));
#line 4367 "runtime.in"
  addFunc(ve, run::gen407, primString() , "locatefile", formal(primString() , "file", false, false));
#line 4372 "runtime.in"
  addFunc(ve, run::gen408, primVoid(), "stop", formal(primString() , "file", false, false), formal(primInt(), "line", false, false), formal(primCode(), "s", true, false));
#line 4380 "runtime.in"
  addFunc(ve, run::gen409, primVoid(), "breakpoints");
#line 4386 "runtime.in"
  addFunc(ve, run::gen410, primVoid(), "clear", formal(primString() , "file", false, false), formal(primInt(), "line", false, false));
#line 4392 "runtime.in"
  addFunc(ve, run::gen411, primVoid(), "clear");
#line 4397 "runtime.in"
  addFunc(ve, run::gen412, primVoid(), "warn", formal(primString() , "s", false, false));
#line 4402 "runtime.in"
  addFunc(ve, run::gen413, primVoid(), "nowarn", formal(primString() , "s", false, false));
#line 4407 "runtime.in"
  addFunc(ve, run::gen414, primString() , "stripdirectory", formal(primString(), "s", false, false));
#line 4413 "runtime.in"
  addFunc(ve, run::gen415, primString() , "stripfile", formal(primString(), "s", false, false));
#line 4419 "runtime.in"
  addFunc(ve, run::gen416, primString() , "stripextension", formal(primString(), "s", false, false));
#line 4425 "runtime.in"
  addFunc(ve, run::gen417, primInt(), "convert", formal(primString() , "args", true, false), formal(primString() , "file", true, false), formal(primString() , "format", true, false));
#line 4443 "runtime.in"
  addFunc(ve, run::gen418, primInt(), "animate", formal(primString() , "args", true, false), formal(primString() , "file", true, false), formal(primString() , "format", true, false));
#line 4459 "runtime.in"
  addFunc(ve, run::gen419, primInt(), "delete", formal(primString(), "s", false, false));
#line 4469 "runtime.in"
  addFunc(ve, run::gen420, primInt(), "rename", formal(primString(), "from", false, false), formal(primString(), "to", false, false));
#line 4768 "runtime.in"
  addFunc(ve, run::gen451, IntArray(), "complement", formal(IntArray(), "a", false, false), formal(primInt(), "n", false, false));
#line 4800 "runtime.in"
  addFunc(ve, run::gen453, IntArray(), "sequence", formal(primInt(), "n", false, false));
#line 4833 "runtime.in"
  addFunc(ve, run::gen456, primBoolean(), "all", formal(boolArray(), "a", false, false));
#line 4842 "runtime.in"
  addFunc(ve, run::gen457, boolArray(), "!", formal(boolArray(), "a", false, false));
#line 4851 "runtime.in"
  addFunc(ve, run::gen458, primInt(), "sum", formal(boolArray(), "a", false, false));
#line 5014 "runtime.in"
  addFunc(ve, run::gen465, primInt(), "find", formal(boolArray(), "a", false, false), formal(primInt(), "n", true, false));
#line 5059 "runtime.in"
  addFunc(ve, run::gen467, realArray2(), "identity", formal(primInt(), "n", false, false));
#line 5082 "runtime.in"
  addFunc(ve, run::gen469, realArray2(), "inverse", formal(realArray2(), "a", false, false));
#line 5174 "runtime.in"
  addFunc(ve, run::gen470, realArray(), "solve", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false), formal(primBoolean(), "warn", true, false));
#line 5225 "runtime.in"
  addFunc(ve, run::gen471, realArray2(), "solve", formal(realArray2(), "a", false, false), formal(realArray2(), "b", false, false), formal(primBoolean(), "warn", true, false));
#line 5289 "runtime.in"
  addFunc(ve, run::gen472, primReal(), "determinant", formal(realArray2(), "a", false, false));
#line 5305 "runtime.in"
  addFunc(ve, run::gen473, realArray(), "*", formal(realArray2(), "a", false, false), formal(realArray(), "b", false, false));
#line 5323 "runtime.in"
  addFunc(ve, run::gen474, realArray(), "*", formal(realArray(), "a", false, false), formal(realArray2(), "b", false, false));
#line 5351 "runtime.in"
  addFunc(ve, run::gen475, realArray2(), "*", formal(realArray2(), "a", false, false), formal(realArray2(), "b", false, false));
#line 5386 "runtime.in"
  addFunc(ve, run::gen476, primTriple(), "*", formal(realArray2(), "t", false, false), formal(primTriple(), "v", false, false));
#line 5391 "runtime.in"
  addFunc(ve, run::gen477, primPair(), "project", formal(primTriple(), "v", false, false), formal(realArray2(), "t", false, false));
#line 5416 "runtime.in"
  addFunc(ve, run::gen478, primReal(), "dot", formal(realArray(), "a", false, false), formal(realArray(), "b", false, false));
#line 5426 "runtime.in"
  addFunc(ve, run::gen479, realArray(), "tridiagonal", formal(realArray(), "a", false, false), formal(realArray(), "b", false, false), formal(realArray(), "c", false, false), formal(realArray(), "f", false, false));
#line 5530 "runtime.in"
  addFunc(ve, run::gen480, primReal(), "newton", formal(primInt(), "iterations", true, false), formal(realRealFunction(), "f", false, false), formal(realRealFunction(), "fprime", false, false), formal(primReal(), "x", false, false), formal(primBoolean(), "verbose", true, false));
#line 5577 "runtime.in"
  addFunc(ve, run::gen481, primReal(), "newton", formal(primInt(), "iterations", true, false), formal(realRealFunction(), "f", false, false), formal(realRealFunction(), "fprime", false, false), formal(primReal(), "x1", false, false), formal(primReal(), "x2", false, false), formal(primBoolean(), "verbose", true, false));
#line 5659 "runtime.in"
  addFunc(ve, run::gen482, primReal(), "simpson", formal(realRealFunction(), "f", false, false), formal(primReal(), "a", false, false), formal(primReal(), "b", false, false), formal(primReal(), "acc", true, false), formal(primReal(), "dxmax", true, false));
#line 5701 "runtime.in"
  addFunc(ve, run::gen484, IntArray2(), "triangulate", formal(pairArray(), "z", false, false));
#line 5736 "runtime.in"
  addFunc(ve, run::gen485, primBoolean(), "==", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 5744 "runtime.in"
  addFunc(ve, run::gen486, primBoolean(), "!=", formal(primFile(), "a", false, false), formal(primFile(), "b", false, false));
#line 5754 "runtime.in"
  addFunc(ve, run::gen488, primFile(), "input", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false), formal(primString() , "comment", true, false));
#line 5762 "runtime.in"
  addFunc(ve, run::gen489, primFile(), "output", formal(primString() , "name", false, false), formal(primBoolean(), "update", true, false), formal(primString() , "comment", true, false));
#line 5774 "runtime.in"
  addFunc(ve, run::gen490, primFile(), "xinput", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false));
#line 5788 "runtime.in"
  addFunc(ve, run::gen491, primFile(), "xoutput", formal(primString() , "name", false, false), formal(primBoolean(), "update", true, false));
#line 5806 "runtime.in"
  addFunc(ve, run::gen492, primFile(), "binput", formal(primString() , "name", false, false), formal(primBoolean(), "check", true, false));
#line 5813 "runtime.in"
  addFunc(ve, run::gen493, primFile(), "boutput", formal(primString() , "name", false, false), formal(primBoolean(), "update", true, false));
#line 5823 "runtime.in"
  addFunc(ve, run::gen494, primBoolean(), "eof", formal(primFile(), "f", false, false));
#line 5828 "runtime.in"
  addFunc(ve, run::gen495, primBoolean(), "eol", formal(primFile(), "f", false, false));
#line 5833 "runtime.in"
  addFunc(ve, run::gen496, primBoolean(), "error", formal(primFile(), "f", false, false));
#line 5838 "runtime.in"
  addFunc(ve, run::gen497, primVoid(), "clear", formal(primFile(), "f", false, false));
#line 5843 "runtime.in"
  addFunc(ve, run::gen498, primVoid(), "close", formal(primFile(), "f", false, false));
#line 5848 "runtime.in"
  addFunc(ve, run::gen499, primInt(), "precision", formal(primFile(), "f", true, false), formal(primInt(), "digits", true, false));
#line 5854 "runtime.in"
  addFunc(ve, run::gen500, primVoid(), "flush", formal(primFile(), "f", false, false));
#line 5859 "runtime.in"
  addFunc(ve, run::gen501, primString() , "getc", formal(primFile(), "f", false, false));
#line 5868 "runtime.in"
  addFunc(ve, run::gen502, primInt(), "tell", formal(primFile(), "f", false, false));
#line 5873 "runtime.in"
  addFunc(ve, run::gen503, primVoid(), "seek", formal(primFile(), "f", false, false), formal(primInt(), "pos", false, false));
#line 5878 "runtime.in"
  addFunc(ve, run::gen504, primVoid(), "seekeof", formal(primFile(), "f", false, false));
#line 5883 "runtime.in"
  addFunc(ve, run::gen505, primFile(), "dimension", formal(primFile(), "f", false, false), formal(primInt(), "nx", false, false));
#line 5890 "runtime.in"
  addFunc(ve, run::gen506, primFile(), "dimension", formal(primFile(), "f", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false));
#line 5896 "runtime.in"
  addFunc(ve, run::gen507, primFile(), "dimension", formal(primFile(), "f", false, false), formal(primInt(), "nx", false, false), formal(primInt(), "ny", false, false), formal(primInt(), "nz", false, false));
#line 5902 "runtime.in"
  addFunc(ve, run::gen508, primFile(), "csv", formal(primFile(), "f", false, false), formal(primBoolean(), "b", true, false));
#line 5909 "runtime.in"
  addFunc(ve, run::gen509, primFile(), "word", formal(primFile(), "f", false, false), formal(primBoolean(), "b", true, false));
#line 5916 "runtime.in"
  addFunc(ve, run::gen510, primFile(), "line", formal(primFile(), "f", false, false), formal(primBoolean(), "b", true, false));
#line 5923 "runtime.in"
  addFunc(ve, run::gen511, primFile(), "signed", formal(primFile(), "f", false, false), formal(primBoolean(), "b", true, false));
#line 5979 "runtime.in"
  addFunc(ve, run::gen521, primFile(), "read1", formal(primFile(), "f", false, false));
#line 5986 "runtime.in"
  addFunc(ve, run::gen522, primFile(), "read2", formal(primFile(), "f", false, false));
#line 5993 "runtime.in"
  addFunc(ve, run::gen523, primFile(), "read3", formal(primFile(), "f", false, false));
#line 6000 "runtime.in"
  addFunc(ve, run::gen524, stringArray(), "history", formal(primString() , "name", false, false), formal(primInt(), "n", true, false));
#line 6033 "runtime.in"
  addFunc(ve, run::gen525, stringArray(), "history", formal(primInt(), "n", true, false));
#line 6044 "runtime.in"
  addFunc(ve, run::gen526, primString() , "readline", formal(primString() , "prompt", true, false), formal(primString() , "name", true, false), formal(primBoolean(), "tabcompletion", true, false));
#line 6088 "runtime.in"
  addFunc(ve, run::gen527, primVoid(), "saveline", formal(primString() , "name", false, false), formal(primString() , "value", false, false), formal(primBoolean(), "store", true, false));
#line 6118 "runtime.in"
  addFunc(ve, run::gen528, primVoid(), "generate_random_backtrace");
#line 6127 "runtime.in"
  addFunc(ve, run::gen529, primVoid(), "print_random_addresses", formal(primInt(), "n", true, false));
}

} // namespace trans
