/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2002,2003  Thomas Hudson,Juraj Michalek
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "globals.h"
#include "lineseq.h"


enum cmdTokens {
	ARGV_NOTHING_EXPECTED,
	ARGV_GFX_DEPTH,
	ARGV_SCREEN_WIDTH,
	ARGV_SCREEN_HEIGHT,
	ARGV_DATA_DIR
};
#define SWITCH_HELP		"-h"
#define SWITCH_FULL_SCREEN	"-fs"
#define SWITCH_WINDOWED		"--windowed"
#define SWITCH_NOSOUND          "--nosound"
#define SWITCH_DATADIR          "--datadir"


int screen_mode = GFX_AUTODETECT_WINDOWED;

BITMAP *create_gradient_strip (const gradient *gradient, int length);
int draw_circlesBG (GLOBALDATA *global, BITMAP *dest, int x, int y, int width, int height);

using namespace std;

void fpsadd()
{
	fps = frames;
	frames = 0;
}

void clockadd()
{
	cclock++;
}
END_OF_FUNCTION(clockadd);



/*****************************************************************************
colorDistance

Treat two color values as 3D vectors of the form <r,g,b>.
Compute the scalar size of the difference between the two vectors.
*****************************************************************************/
double colorDistance (int col1, int col2)
{
	double distance;
	int col1r, col1g, col1b;
	int col2r, col2g, col2b;

	col1r = getr (col1);
	col1g = getg (col1);
	col1b = getb (col1);
	col2r = getr (col2);
	col2g = getg (col2);
	col2b = getb (col2);

	// Treat the colour-cube as a space
	distance = vector_length_f ((float)(col1r - col2r), (float)(col1g - col2g), (float)(col1b - col2b));

	return (distance);
}



/*****************************************************************************
drawMenuBackground

Draws a 600x400 centered box, fills it with some random lines or circles.
Someday, we should make this more generic; have it take the box dimensions
as an input parameter.
*****************************************************************************/
void drawMenuBackground (GLOBALDATA *global, ENVIRONMENT *env, int itemType, int tOffset, int numItems)
{
	rectfill (env->db, global->halfWidth - 300, 100,
		global->halfWidth + 300, global->screenHeight - 100,
		makecol (0,79,0));
	rect     (env->db, global->halfWidth - 300, 100,
		global->halfWidth + 300, global->screenHeight - 100,
		makecol (128,255,128));
	
	drawing_mode (DRAW_MODE_TRANS, NULL, 0, 0);
	set_trans_blender (0, 0, 0, 15);
	for (int tCount = 0; tCount < numItems; tCount++) {
		int radius, xpos, ypos;
		switch (itemType) {
			case 0: // circles
				radius = (int)((perlin1DPoint (1.0, 5, (tOffset * 0.02) + tCount + 423346, 0.5, 8) + 1) / 2 * 40);
				xpos = global->halfWidth + (int)(perlin1DPoint (1.0, 3, (tOffset * 0.02) + tCount + 232662, 0.3, 6) * 250);
				ypos = global->halfHeight + (int)(perlin1DPoint (1.0, 2, (tOffset * 0.02) + tCount + 42397, 0.3, 6) * (global->halfHeight - 100));
				circlefill (env->db, xpos, ypos, radius,
						makecol (200,255,200));
				break;
			case 1: // Horz lines
				radius = (int)((perlin1DPoint (1.0, 5, (tOffset * 0.02) + tCount + 423346, 0.5, 8) + 1) / 2 * 40);
				xpos = global->halfWidth + (int)(perlin1DPoint (1.0, 3, (tOffset * 0.02) + tCount + 232662, 0.3, 6) * 250);
				rectfill (env->db, xpos - radius / 2, 101,
					xpos + radius / 2, global->screenHeight - 101,
					makecol (200,255,200));
				break;
			default:
				break;
		}

	}
	solid_mode ();

}


void initialisePlayers (GLOBALDATA *global, ENVIRONMENT *env)
{
	int z;

	for (z = 0; z < global->numPlayers; z++) {
		global->players[z]->money = (unsigned long int)global->startmoney;
		global->players[z]->score = 0;
		global->players[z]->initialise ();
 	    if (((int)global->players[z]->type != HUMAN_PLAYER) &&
 	        (global->players[z]->preftype == PERPLAY_PREF))
        {
          global->players[z]->generatePreferences();
        }
	}
}



void flush_inputs()	/* Flush key buffer and waits for but's releases */
{
	do { } while(mouse_b);
	clear_keybuf();
}

void wait_for_input()
{
	do{
      LINUX_SLEEP;
	} while((!keypressed()) && (!mouse_b));

	flush_inputs();

}

int pickColor (int left, int top, int width, int height, int x, int y)
{
	int r, g, b;
	double value, saturation;
	double hue = ((double)(x - left) / width) * 360;

	double hPos = (double)(y - top) / height;
	if (hPos > 0.5) {
		value = 1.0 - ((hPos - 0.5) * 2);
		saturation = 1.0;
	} else {
		value = 1.0;
		saturation = hPos * 2;
	}

	hsv_to_rgb (hue, saturation, value, &r, &g, &b);

	return (makecol (r, g, b));
}

void colorBar (GLOBALDATA *global, ENVIRONMENT *env, int left, int top, int width, int height)
{
	int right = left + width;
	int bottom = top + height;

	for (int x = left; x < right; x++) {
		for (int y = top; y < bottom; y++) {
			putpixel (env->db, x, y, pickColor (left, top, width, height, x, y));
		}
	}
}

int textEntryBox (GLOBALDATA *global, ENVIRONMENT *env, int modify, int x, int y, char *text, unsigned int textLength)
{
	int ke = 0;
	int fontWidth = text_length (font, "Z");
	int fontHeight = text_height (font);
	int leftX = x - (fontWidth * textLength / 2);
	int rightX = x + (fontWidth * textLength / 2);
	int boxWidth = fontWidth * textLength;
	char tempText[textLength + 1];
	int flashCount = 0;
	int lx = mouse_x, ly = mouse_y;

	rectfill (env->db, leftX, y - 2, rightX, y + fontHeight + 2, WHITE);
	rect (env->db, leftX, y - 2, rightX, y + fontHeight + 2, BLACK);
	if (!modify) {
		textout_centre_ex (env->db, font, text, x, y, BLACK, -1);
	}
	env->make_update (leftX - 2, y - 4, fontWidth * textLength + 4, fontHeight + 6);
	env->do_updates ();

	if (!modify) {
		return (boxWidth);
	}
	strncpy (tempText, text, textLength + 1);

	while (((ke >> 8) != KEY_ENTER && (ke >> 8) != KEY_ESC) || strlen (tempText) < 1) {
		int tWidth = text_length (font, tempText);

        LINUX_SLEEP;

		rectfill (env->db, leftX, y - 2, rightX, y + fontHeight + 2, WHITE);
		rect (env->db, leftX, y - 2, rightX, y + fontHeight + 2, BLACK);
		//rectfill (screen, x - (tWidth / 2), y, x + (tWidth / 2) + 10, y + text_height (font), (flashCount < 5)?WHITE:BLACK);
		textout_centre_ex (env->db, font, tempText, x, y, BLACK, -1);
		rectfill (env->db, x + (tWidth / 2) + 2, y, x + (tWidth / 2) + 10, y + text_height (font), (flashCount < 25)?WHITE:BLACK);
		env->make_update (leftX - 2, y - 4, fontWidth * textLength + 4, fontHeight + 6);
		env->make_update (mouse_x, mouse_y, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		env->make_update (lx, ly, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		lx = mouse_x;
		ly = mouse_y;
		show_mouse (NULL);

		if (keypressed ()) {
			ke = readkey ();
		} else {
			ke = 0;
		}

		if ((ke >> 8) == KEY_BACKSPACE) {
			tempText[strlen (tempText) - 1] = 0;
			rectfill (screen, x - (tWidth / 2), y, x + (tWidth / 2) + 10, y + text_height (font), WHITE);
			env->make_update (x - (tWidth / 2) - 2, y - 2, tWidth + 14, text_height (font) + 4);
		} else if ((ke & 0xff) >= 32 && strlen (tempText) < textLength) {
			tempText[strlen (tempText)] = ke & 0xff;
			tempText[strlen (tempText) + 1] = 0;
			//textprintf (screen, font, x + text_length (font, tempText), y, WHITE, "%c", ke & 0xff);
		} else 
		env->do_updates ();
		show_mouse (screen);
		rest (1);
		flashCount++;
		flashCount = flashCount % 50;
	}
	if ((ke >> 8) != KEY_ESC)
		strncpy (text, tempText, textLength);

//	env->make_update (leftX - 2, y - 4, fontWidth * textLength + 4, fontHeight + 6);
//	env->do_updates ();
	flush_inputs ();

	return (boxWidth);
}



void renderTextLines (GLOBALDATA *global, ENVIRONMENT *env,
		const LINESEQ& lines, int scrollOffset,
		const FONT* fnt, const int spacing )
{
	const int textheight = text_height (fnt) ;
	const int textheight_s = textheight * spacing ;
	int yOffset = scrollOffset;

	for (int count = 0;
		(count != lines.size()) && (yOffset < global->screenHeight);
		count++)
	{
		const char *text = lines[count] + 1;
		const char header = lines[count][0];
		int tLen = text_length (fnt, text);

		switch (header) {
		case 'T':
		case 't':
			textout_centre_ex (env->db, fnt, text,
				global->halfWidth + 2, global->halfHeight + yOffset + 2, BLACK, -1);
			textout_centre_ex (env->db, fnt, text,
				global->halfWidth, global->halfHeight + yOffset, WHITE, -1);
			if(header == 'T') {
				yOffset += textheight + 1;
				hline (env->db, global->halfWidth - tLen / 2,
					global->halfHeight + yOffset, global->halfWidth + tLen / 2,
					WHITE);
				hline (env->db, global->halfWidth - tLen / 2 + 2,
					global->halfHeight + yOffset + 2,
					global->halfWidth + tLen / 2 + 2, BLACK);
				yOffset -= textheight / 2;
			}
			break;
		case 'L':
			textout_centre_ex (env->db, fnt, text, global->halfWidth,
				global->halfHeight + yOffset, BLACK, -1);
			break;
		}
		yOffset += textheight_s;
	}
}

void scrollTextList (GLOBALDATA *global, ENVIRONMENT *env,
	const LINESEQ& lines)
{
	/* Justin says: this function, along with renderTextLines, aren't
	exactly efficient.  I think they could use rewrite. */
	static const int numItemsSrc[] = { 100, 30 } ;

	DATAFILE *dffont ;
	const FONT* fnt = font;
	int spacing = 2;
	int tOffset = rand ();
	int itemType = rand () / (RAND_MAX/2 + 1) ;
	int numItems = numItemsSrc[itemType];

	/* Attempt to load the "big" font */
	if(( dffont = load_datafile_object("bigfont.dat", "bigfont") )) {
		fnt = (FONT*)dffont->dat ;
		spacing = 1 ;
	}

	draw_circlesBG (global, env->db, 0, 0, global->screenWidth, global->screenHeight);
	drawMenuBackground (global, env, itemType, abs (tOffset), numItems);
	quickChange (global, env->db);
	set_clip_rect (env->db, global->halfWidth - 300 + 1, 100 + 1,
		global->halfWidth + 300 - 1, global->screenHeight - 100 - 1);
	int scrollOffset = 0;
	flush_inputs ();
	show_mouse (NULL);

	do {
        LINUX_SLEEP;
		drawMenuBackground (global, env, itemType, abs (tOffset), numItems);
		renderTextLines (global, env, lines, scrollOffset,
			fnt, spacing );
		blit (env->db, screen, global->halfWidth - 300, 100, global->halfWidth - 300, 100,
			601, global->screenHeight - 199);
		rest (1);
		tOffset++;
		scrollOffset--;
		if (scrollOffset < -(global->halfHeight - 100 + lines.size() * 20))
			scrollOffset = global->halfHeight - 100;
	} while (!keypressed () && !mouse_b);

	show_mouse (screen);
	set_clip_rect (env->db, 0, 0, (global->screenWidth-1), (global->screenHeight-1));
	flush_inputs ();
	if( dffont )
		unload_datafile_object( dffont );
}


void instructions (GLOBALDATA *global, ENVIRONMENT *env)
{
	char dataDir[2048];

	sprintf (dataDir, "%s/instr.txt", global->dataDir);
	scrollTextList (global, env,
		LINESEQ(dataDir, LINESEQ::keep_blanks ) );
}

void credits (GLOBALDATA *global, ENVIRONMENT *env)
{
	char dataDir[2048];

	sprintf (dataDir, "%s/credits.txt", global->dataDir);
	scrollTextList (global, env,
		LINESEQ(dataDir, LINESEQ::keep_blanks ) );
}



int savePlayers (GLOBALDATA *global, ENVIRONMENT *env, FILE *file)
{
	fwrite (&global->numPermanentPlayers, sizeof (int), 1, file);

	if (global->numPermanentPlayers > 0) {
		for (int count = 0; count < global->numPermanentPlayers; count++) {
			global->allPlayers[count]->saveToFile (file);
		}
	}

	return (ferror (file));
}

int loadPlayers (GLOBALDATA *global, ENVIRONMENT *env, FILE *file)
{
	int numSavedPlayers;

	fread (&numSavedPlayers, sizeof (int), 1, file);

	global->numPermanentPlayers = numSavedPlayers;
	global->allPlayers = (PLAYER**)malloc (sizeof (PLAYER*) * numSavedPlayers);
	if (!global->allPlayers) {
		perror ("atanks.cc: Failed allocating memory for allPlayers in loadPlayers");
		exit (1);
	}
	for (int count = 0; count < numSavedPlayers; count++) {
		global->allPlayers[count] = new PLAYER (global, env, file);
		if (!global->allPlayers[count]) {
			perror ("atanks.cc: Failed allocating memory for players in loadPlayers");
			exit (1);
		}
	}

	return (ferror (file));
}

void newgame (GLOBALDATA *global, ENVIRONMENT *env)
{
	int objCount;
	TANK *tank;

	env->initialise ();
	global->initialise ();
	initialisePlayers (global, env);

	for (objCount = 0; (tank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && tank; objCount++)
		tank->initialise ();
}

int draw_circlesBG (GLOBALDATA *global, BITMAP *dest, int x, int y, int width, int height)
{
	int largestCircle, circleCount;
	BITMAP *drawTo;

	if (global->cacheCirclesBG)
	{
		if (!global->gfxData.circlesBG)
		{
			global->gfxData.circlesBG = create_bitmap (width, height);
			drawTo = global->gfxData.circlesBG;
		} else {
			blit (global->gfxData.circlesBG, dest, 0, 0, 0, 0, width, height);
			return (0);
		}
	} else {
		drawTo = dest;
	}

	largestCircle = (int)(global->halfWidth * (4.0/3.0));
	global->gfxData.circle_gradient_strip = create_gradient_strip (circles_gradient, largestCircle);
	for (circleCount = largestCircle; circleCount > 0; circleCount -= 2)
	circlefill (drawTo, width/2, height/2, circleCount, getpixel (global->gfxData.circle_gradient_strip, 0, largestCircle - circleCount));

	if (global->cacheCirclesBG)
		draw_circlesBG (global, dest, x, y, width, height);

	return (0);
}

ENVIRONMENT *init_game_settings (GLOBALDATA *global)
{
	int count, x, y, z;
	ENVIRONMENT *env;
	double expSize, disperseSize;
	char dataDir[2048];

	allegro_init ();
	set_color_depth (global->colourDepth);
	if (set_gfx_mode (screen_mode, global->screenWidth, global->screenHeight, 0, 0) < 0) {
		cerr<<"set_gfx_mode: "<<allegro_error<<endl;
		exit (1);
	}

	if (install_keyboard () < 0) {
		perror ("install_keyboard");
		exit (1);
	}
	if (install_timer () < 0) {
		perror ("install_timer");
		exit (1);
	}
	if (install_mouse () < 0) {
		perror ("install_mouse");
		exit (1);
	}

        // check to see if we want sound
        if (global->sound)
        {
          // don't stop program if no sound since the game can be played without
	  if (install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL) < 0)
          {
	    fprintf (stderr, "install_sound: %s",allegro_error);
	  }
        }


//	if (detect_digi_driver(DIGI_AUTODETECT)) {
//		if (install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL) < 0) {
//			fprintf (stderr, "install_sound: failed initialising sound");
//			exit (1);
//		}
//	} else {
//		fprintf (stderr, "detect_digi_driver detected no sound device\n");
//	}
	LOCK_VARIABLE(cclock);
	LOCK_FUNCTION(clockadd);
	if (install_int_ex (clockadd, BPS_TO_TIMER (FRAMES_PER_SECOND)) < 0) {
		perror ("install_int_ex");
		exit (1);
	}
	if (install_int (fpsadd, 1000) < 0) {
		perror ("install_int");
		exit (1);
	}

       // obsolete -- the -1 is passed as the bg parameter in text functions
       // text_mode (-1);

	srand (time (0));

	WHITE = makecol (255, 255, 255);
	BLACK = makecol (0, 0, 0);
	PINK = makecol (255, 0, 255);
        RED = makecol (255, 0, 0);

	sprintf (dataDir, "%s/title.dat", global->dataDir);
	global->gfxData.TITLE = load_datafile (dataDir);
	if (!global->gfxData.TITLE) {
		perror ("title.dat");
		exit (1);
	}

	show_mouse(NULL);
	blit ((BITMAP *) global->gfxData.TITLE[0].dat, screen, 0, 0, global->halfWidth - 320, global->halfHeight - 240, 640, 480);
	show_mouse (screen);

	
	sprintf (dataDir, "%s/misc.dat", global->dataDir);
	global->gfxData.M = load_datafile (dataDir);
	if (!global->gfxData.M) {
		perror ("misc.dat");
		exit (1);
	}
	sprintf (dataDir, "%s/tank.dat", global->dataDir);
	global->gfxData.T = load_datafile (dataDir);
	if (!global->gfxData.T) {
		perror ("tank.dat");
		exit (1);
	}
	sprintf (dataDir, "%s/button.dat", global->dataDir);
	global->gfxData.B = load_datafile (dataDir);
	if (!global->gfxData.B) {
		perror ("button.dat");
		exit (1);
	}
	sprintf (dataDir, "%s/tankgun.dat", global->dataDir);
	global->gfxData.TG = load_datafile (dataDir);
	if (!global->gfxData.TG) {
		perror ("tankgun.dat");
		exit (1);
	}
	sprintf (dataDir, "%s/missile.dat", global->dataDir);
	global->gfxData.MI = load_datafile (dataDir);
	if (!global->gfxData.MI) {
		perror ("missile.dat");
		exit (1);
	}
	sprintf (dataDir, "%s/stock.dat", global->dataDir);
	global->gfxData.STOCK_IMAGE = load_datafile(dataDir);
	if (!global->gfxData.STOCK_IMAGE) {
		perror ("stock.dat");
		exit (1);
	}

	sprintf (dataDir, "%s/sound.dat", global->dataDir);
	global->SOUND = load_datafile (dataDir);
	if (!global->SOUND) {
		perror ("sound.dat");
		exit (1);
	}

        for (count = 0; count < LANDS; count++)
          global->gfxData.land_gradient_strips[count] = NULL;
        for (count = 0; count < SKIES; count++)
          global->gfxData.sky_gradient_strips[count] = NULL;

	global->gfxData.explosion_gradient_strip = create_gradient_strip (explosion_gradient, 200);

	expSize = 0;
	disperseSize = 0;
	for (count = 0; count < EXPLOSIONFRAMES; count++)
	{
		global->gfxData.explosions[count] = create_bitmap (214, 214);
		if (count == 0) {
			expSize = 25;
			disperseSize = 0;
		} else if (count < EXPLODEFRAMES - 4)
			expSize += (107 - expSize) / 3;
		else if (count < EXPLODEFRAMES)
			expSize--;
		else if (count == EXPLODEFRAMES)
			disperseSize = 25;
		else
			disperseSize += (107 - disperseSize) / 2;

		clear_to_color (global->gfxData.explosions[count], PINK);
		for (y = (int)expSize; y > disperseSize; y--) {
			double value;
			value = pow ((double)y / expSize, count / 4 + 1);
			circlefill (global->gfxData.explosions[count], 107, 107, y, getpixel (global->gfxData.explosion_gradient_strip, 0, (int)(value * 200)));
		}
		if (disperseSize)
			circlefill (global->gfxData.explosions[count], 107, 107, (int)disperseSize, PINK);
	}

	expSize = 0;
	disperseSize = 0;
	for (count = 0; count < EXPLOSIONFRAMES; count++)
	{
		global->gfxData.flameFront[count] = create_bitmap (600, 30);
		if (count == 0) {
			expSize = 10;
			disperseSize = 0;
		} else if (count < EXPLODEFRAMES - 4)
			expSize += (300 - expSize) / 3;
		else if (count < EXPLODEFRAMES)
			expSize--;
		else if (count == EXPLODEFRAMES)
			disperseSize = 10;
		else
			disperseSize += (300 - disperseSize) / 2;

		clear_to_color (global->gfxData.flameFront[count], PINK);
		for (y = (int)expSize; y > disperseSize; y--) {
			double value;
			value = pow ((double)y / expSize, count / 4 + 1);
			ellipsefill (global->gfxData.flameFront[count], 300, 15, y, y / 20, getpixel (global->gfxData.explosion_gradient_strip, 0, (int)(value * 200)));
		}
		if (disperseSize)
			ellipsefill (global->gfxData.flameFront[count], 300, 15, (int)disperseSize, (int)disperseSize / 16, PINK);
	}

	global->gfxData.topbar = create_bitmap (global->screenWidth, MENU);
	global->gfxData.topbar_gradient_strip = create_gradient_strip (topbar_gradient, 100);
	if (!global->ditherGradients) {
		for (count = 0; count < MENU; count++) {
			float adjCount = (100.0 / MENU) * count;
			line (global->gfxData.topbar, 0, count, global->screenWidth - 1, count, getpixel (global->gfxData.topbar_gradient_strip, 0, (int)adjCount));
		}
	} else {
		for (x = 0; x < global->screenWidth; x++) {
		        for (y = 0; y < MENU; y++) {
				float adjY = (100.0 / MENU) * y;
				int offset;
				if ((adjY < 2) || (adjY > 100 - 2))
					offset = 0;
				else
					offset = rand () % 4 - 2;
				putpixel (global->gfxData.topbar, x, y, getpixel (global->gfxData.topbar_gradient_strip, 0, (int)adjY + offset));
			}
		}
	}

	global->gfxData.stuff_bar[0] = create_bitmap (STUFF_BAR_WIDTH, STUFF_BAR_HEIGHT);
	global->gfxData.stuff_bar[1] = create_bitmap (STUFF_BAR_WIDTH, STUFF_BAR_HEIGHT);
	global->gfxData.stuff_icon_base = create_bitmap (STUFF_BAR_WIDTH/10, STUFF_BAR_HEIGHT);
	clear_to_color (global->gfxData.stuff_bar[0], PINK);
	clear_to_color (global->gfxData.stuff_bar[1], PINK);
	clear_to_color (global->gfxData.stuff_icon_base, PINK);
	global->gfxData.stuff_bar_gradient_strip = create_gradient_strip (stuff_bar_gradient, STUFF_BAR_WIDTH);
	for (x = 0; x < STUFF_BAR_WIDTH; x++)
	{
		for (y = 0; y < STUFF_BAR_HEIGHT; y++)
		{
			double sides_dist = 0.1, circle_dist;
			circle_dist = vector_length_f ((float)x-(STUFF_BAR_WIDTH - 75), (float)y - (STUFF_BAR_HEIGHT/2 - 2), 0);
			if (circle_dist < 75)
				circle_dist = 1 - (circle_dist / 75.0);
			else
				circle_dist = 0;

			if (x < (STUFF_BAR_HEIGHT/2 - 2))
				sides_dist -= 0.1 - ((float)x / 150.0);
			else if (x > STUFF_BAR_WIDTH - (STUFF_BAR_HEIGHT/2 - 2))
				sides_dist -= ((float)(x - (STUFF_BAR_WIDTH - (STUFF_BAR_HEIGHT/2 - 2))) / 150.0);

			if (y < STUFF_BAR_HEIGHT/2 - 2)
				sides_dist -= 0.1 - ((float)(y) / 150.0);
			else
				sides_dist -= ((float)(y - (STUFF_BAR_HEIGHT/2 - 2)) / 150.0);

			sides_dist -= circle_dist * circle_dist;
			if (sides_dist > ((double)x / 1000.0))
				sides_dist = ((double)x / 1000.0);
			if (sides_dist < 0)
				sides_dist = 0;
			if (circle_dist > 1)
				circle_dist = 1;

			if (x < STUFF_BAR_WIDTH/10)
				putpixel (global->gfxData.stuff_icon_base, x, y, getpixel (global->gfxData.stuff_bar_gradient_strip, 0, (int)((sides_dist + circle_dist) * (STUFF_BAR_WIDTH-1))));

			if (y < STUFF_BAR_HEIGHT - 5) {
				putpixel (global->gfxData.stuff_bar[0], x, y, getpixel (global->gfxData.stuff_bar_gradient_strip, 0, (int)((sides_dist + circle_dist) * (STUFF_BAR_WIDTH-1))));
				putpixel (global->gfxData.stuff_bar[1], x, y, getpixel (global->gfxData.stuff_bar_gradient_strip, 0, (int)((sides_dist + circle_dist + 0.05) * (STUFF_BAR_WIDTH-1))));
			}
		}
	}

	set_mouse_sprite ((BITMAP *) global->gfxData.M[0].dat);
	set_mouse_sprite_focus (0, 0);

	srand (time (0));
	global->window.x = 0;
	global->window.y = 0;
	global->window.w = 0;
	global->window.h = 0;
	for (z = 0; z < MAXUPDATES; z++) {
		global->updates[z].x = 0;
		global->updates[z].y = 0;
		global->updates[z].w = 0;
		global->updates[z].h = 0;
	}

	env = new ENVIRONMENT (global);
	if (!env) {
		perror ("atanks.cc: Allocating env in init_game_settings");
		exit (1);
	}

	clear_to_color (env->db, BLACK);

	return (env);
}

class BUTTON
{
	private:
		GLOBALDATA *_global;
		ENVIRONMENT *_env;

	public:
		BOX location;
		int xl, yl;
		char *text;
		BITMAP *bmp;
		BITMAP *hover;
		BITMAP *depressed;
		SAMPLE *click;

		BUTTON (GLOBALDATA *global, ENVIRONMENT *env, int x1, int y1, char *text1, BITMAP *bmp1, BITMAP *hover1, BITMAP *depressed1);
	int	isPressed (); //if button pressed returns 1
	int	isMouseOver (); //Cursor is over button
	void	draw (BITMAP *dest);
};

BUTTON::BUTTON(GLOBALDATA *global, ENVIRONMENT *env, int x1, int y1, char *text1, BITMAP *bmp1, BITMAP *hover1, BITMAP *depressed1)
{
	_global = global;
	_env = env;
	location.x = x1;
	location.y = y1;
	text = text1;
	click = (SAMPLE *)_global->SOUND[8].dat;
	bmp = bmp1;
	hover = hover1;
	depressed = depressed1;
	location.w = bmp->w;
	location.h = bmp->h;
	xl = location.x + bmp->w;
	yl = location.y + bmp->h;
}

void BUTTON::draw (BITMAP *dest)
{
	draw_sprite (dest, (BITMAP *)(isMouseOver())?((isPressed())?depressed:hover):bmp, location.x, location.y);
	if (text)
		textout_centre_ex (dest, font, text, location.x+75, location.y + 6, WHITE, -1);
	_env->make_update (location.x, location.y, xl, yl);
}

int BUTTON::isMouseOver ()
{
	if ((mouse_x >= location.x) &&
		(mouse_y >= location.y) &&
		(mouse_x <= xl) &&
		(mouse_y <= yl)) {
		return (1);
	} else {
		return (0);
	}
}
int BUTTON::isPressed()
{
	if ((mouse_b == 1) && isMouseOver ()) {
		play_sample (click, 128, 128, 1000, 0);
		return 1;
	} else {
		return 0;
	}
}

#include "menu.h"
int options (GLOBALDATA *global, ENVIRONMENT *env, MENUDESC *menu);
int createNewPlayer (GLOBALDATA *global, ENVIRONMENT *env, void *data)
{
	PLAYER *newPlayer = global->createNewPlayer (env);
	if (!newPlayer) {
		perror ("atanks.cc: Failed allocating memory in createNewPlayer");
		exit (1);
	}
	options (global, env, (MENUDESC*)newPlayer->menudesc);
	return (-1);
}

int destroyPlayer (GLOBALDATA *global, ENVIRONMENT *env, void *data)
{
	int optionsRetVal;
	char sureMessage[200];
	PLAYER *tempPlayer = (PLAYER*)data;
	MENUDESC areYouSureMenu = {"Are You Sure?", 0, NULL, TRUE, TRUE};

	sprintf (sureMessage, "This player (%s) will be permanently deleted", tempPlayer->getName ());
	errorMessage = sureMessage;
	errorX = global->halfWidth - text_length (font, errorMessage) / 2;
	errorY = 170;
	optionsRetVal = options (global, env, &areYouSureMenu);
	if (optionsRetVal >> 8 != KEY_ESC) {
		global->destroyPlayer (tempPlayer);
		return (-2);
	}
	return (KEY_SPACE << 8);
}

int displayPlayerName (GLOBALDATA *global, ENVIRONMENT *env, int x, int y, void *data)
{
	PLAYER *player = (PLAYER*)data;
	char *name = player->getName ();
	int textHeight = text_height (font);
	int textLength = text_length (font, name);

	if ((int)player->type == HUMAN_PLAYER) {
		circlefill (env->db, x - textLength - textHeight / 2 - 2,
				y + textHeight / 2,
				textHeight / 2, makecol (200, 100, 255));
		circle (env->db, x - textLength - textHeight / 2 - 2,
				y + textHeight / 2,
				textHeight / 2, BLACK);
	} else {
		rectfill (env->db,
			x - textLength - 2 - ((int)player->type * 3),
			y + textHeight - 10,
			x - textLength - 2,
			y + textHeight - 2,
			makecol (100, 255, 100));
		rect (env->db,
			x - textLength - 2 - ((int)player->type * 3),
			y + textHeight - 10,
			x - textLength - 2,
			y + textHeight - 2,
			BLACK);
		for (int lineCount = 1; lineCount < player->type; lineCount++) {
			vline (env->db,
				x - textLength - 2 - (lineCount * 3),
				y + textHeight - 2,
				y + textHeight - 10,
				BLACK);
		}
	}
	textout_ex (env->db, font, name, x - textLength, y, player->color, -1);

	return (0);
}


int options (GLOBALDATA *global, ENVIRONMENT *env, MENUDESC *menu)
{
	MENUENTRY *opts;
	int numEntries;
	char *title;
	int ke, z;
	int mouseLeftPressed;
#include "menucontent.h"

	if (!menu)
		menu = &mainMenu;

	opts = menu->entries;
	numEntries = menu->numEntries;
	title = menu->title;

	char buff[20];
	int done, updateoption[numEntries], lb;

	int stop = 0;

	BUTTON *but_okay = NULL, *but_quit = NULL;
	if (menu->okayButton) {
		int xpos = global->halfWidth - 80;
		if (menu->quitButton)
			xpos -= 80;
		but_okay = new BUTTON (global, env, xpos, global->halfHeight + 160, "Okay", (BITMAP*)global->gfxData.M[7].dat, (BITMAP*)global->gfxData.M[7].dat, (BITMAP*)global->gfxData.M[8].dat);
		if (!but_okay) {
			perror ("atanks.cc: Failed allocating memory for but_okay in options");
			exit (1);
		}
	}
	if (menu->quitButton) {
		int xpos = global->halfWidth - 80;
		if (menu->okayButton)
			xpos += 80;
		but_quit = new BUTTON (global, env, xpos, global->halfHeight + 160, "Back", (BITMAP*)global->gfxData.M[7].dat, (BITMAP*)global->gfxData.M[7].dat, (BITMAP*)global->gfxData.M[8].dat);
		if (!but_quit) {
			perror ("atanks.cc: Failed allocating memory for but_quit in options");
			exit (1);
		}
	}

	mouseLeftPressed = done = lb = env->mouseclock = cclock = 0;
	fi = 1;
	
	for (z = 0; z < numEntries; z++) {
		updateoption[z] = 1;
	}
	
	flush_inputs ();

	do {
        LINUX_SLEEP;
		while (cclock > 0) {
			cclock--;
			if (!lb && mouse_b & 1) {
				env->mouseclock = 0;
				mouseLeftPressed = 1;
			} else {
				mouseLeftPressed = 0;
			}
			lb = (mouse_b & 1) ? 1 : 0;
			if ((mouse_b & 1 || mouse_b & 2) && !env->mouseclock) {
				for (z = 0; z < numEntries; z++) {
					int midX = opts[z].x;
					int midY = opts[z].y;
					if (opts[z].type == OPTION_MENUTYPE) {
						sprintf (buff, "-> %s", opts[z].name);
						if ((!opts[z].viewonly) && mouse_x > midX - text_length (font, buff) && mouse_x < midX && mouse_y >= midY && mouse_y < midY + 10) {
							int optsRetVal = options (global, env, (MENUDESC*)opts[z].value);
							if (optsRetVal < 0) {
								return (optsRetVal + 1);
							}
							fi = 1;
							for (z = 0; z < numEntries; z++) {
								updateoption[z] = 1;
							}
						}
					} else if (opts[z].type == OPTION_ACTIONTYPE) {
						sprintf (buff, "-> %s", opts[z].name);
						if ((!opts[z].viewonly) && mouse_x > midX - text_length (font, buff) && mouse_x < midX && mouse_y >= midY && mouse_y < midY + 10) {
							int (*action) (GLOBALDATA*, ENVIRONMENT*, void*) = (int (*)(GLOBALDATA*, ENVIRONMENT*, void*))opts[z].value;
							int actionRetVal = action (global, env, opts[z].data);
							if (actionRetVal)
								return (actionRetVal);
						}
					} else if (opts[z].type == OPTION_TEXTTYPE) {
						int boxWidth = textEntryBox (global, env, FALSE, midX + 50, midY, (char*)opts[z].value, 10);
						if ((!opts[z].viewonly) && mouse_x > midX - text_length (font, buff) && mouse_x < midX + 50 + boxWidth && mouse_y >= midY && mouse_y < midY + 10) {
							textEntryBox (global, env, TRUE, midX + 50, midY, (char*)opts[z].value, 10);
							updateoption[z] = 1;
						}
					} else if (opts[z].type == OPTION_COLORTYPE) {
						if ((!opts[z].viewonly) && mouse_x > midX && mouse_x < midX + 100 && mouse_y >= midY && mouse_y < midY + 15) {
							*(int*)opts[z].value = pickColor (midX, midY, 100, 15, mouse_x, mouse_y);
							updateoption[z] = 1;
						}
						colorBar (global, env, midX, midY, 100, 15);
						rectfill (env->db, midX + 110, midY, midX + 130, midY + 10, *(int*)opts[z].value);
						rect (env->db, midX + 110, midY, midX + 130, midY + 10, BLACK);
					} else if (opts[z].type == OPTION_TOGGLETYPE) {
						int tlen = text_length (font, buff);
						int thgt = text_height (font);
						if (mouseLeftPressed && (!opts[z].viewonly) && mouse_x > midX - tlen / 2 && mouse_x < midX + tlen / 2 && mouse_y >= midY && mouse_y < midY + thgt) {
							if (*opts[z].value == 0)
								*opts[z].value = 1;
							else
								*opts[z].value = 0;
							mouseLeftPressed = 1;
							updateoption[z] = 1;
						}
					} else {
						if (!opts[z].viewonly) {
							if (mouse_x >= midX + 100 && mouse_x < midX + 110 && mouse_y >= midY && mouse_y < midY + 10) {
								if (mouse_b & 1)
									*opts[z].value -= opts[z].increment;
								else if (mouse_b & 2)
									*opts[z].value -= opts[z].increment * 10;
								updateoption[z] = 1;
							}
							if (mouse_x >= midX + 112 && mouse_x < midX + 122 && mouse_y >= midY && mouse_y < midY + 10) {
								if (mouse_b & 1)
									*opts[z].value += opts[z].increment;
								else if (mouse_b & 2)
									*opts[z].value += opts[z].increment * 10;
								updateoption[z] = 1;
							}
							/*if (mouse_x >= midX + 134 && mouse_x < midY + 154 && mouse_y >= midY && mouse_y < midY + 10) {
								*opts[z].value = opts[z].defaultv;
								updateoption[z] = 1;
							}*/
							if (*opts[z].value > opts[z].max) {
								*opts[z].value = opts[z].max;
							}
							if (*opts[z].value < opts[z].min) {
								*opts[z].value = opts[z].min;
							}
						}
					}
				}
			}
			env->mouseclock++;
			if (env->mouseclock > 10) {
				env->mouseclock = 0;
			}
		}
		
		env->make_update (mouse_x, mouse_y, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		env->make_update (lx, ly, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		lx = mouse_x;
		ly = mouse_y;
		show_mouse (NULL);
		
		if (fi) {
			drawMenuBackground (global, env, 0, rand (), 400);
			textout_ex (env->db, font, title, global->halfWidth - 3 - text_length (font, title), 150, BLACK, -1);
			textout_ex (env->db, font, title, global->halfWidth - 5 - text_length (font, title), 148, WHITE, -1);
			for (z = 0; z < numEntries; z++) {
				int midX = opts[z].x;
				int midY = opts[z].y;
				if (opts[z].type == OPTION_TOGGLETYPE) {
					int color = (*opts[z].value)?WHITE:BLACK;
					ellipsefill (env->db, midX, midY + text_height (font) / 2, text_length (font, opts[z].name) / 2, text_height (font), color);
				}
				if (opts[z].displayFunc) {
					if (opts[z].type == OPTION_TOGGLETYPE) {
						opts[z].displayFunc (global, env,
								midX + text_length (font, opts[z].name) / 2, midY,
								opts[z].data);
					} else {
						opts[z].displayFunc (global, env,
								midX, midY,
								opts[z].data);
					}
				} else if (opts[z].type == OPTION_MENUTYPE) {
					sprintf (buff, "-> %s", opts[z].name);
					textout_ex (env->db, font, buff, midX - text_length (font, buff), midY, opts[z].color, -1);
				} else if (opts[z].type == OPTION_ACTIONTYPE) {
					sprintf (buff, "-> %s", opts[z].name);
					textout_ex (env->db, font, buff, midX - text_length (font, buff), midY, opts[z].color, -1);
				} else if (opts[z].type == OPTION_TEXTTYPE) {
					sprintf (buff, "%s:", opts[z].name);
					textout_ex (env->db, font, buff, midX - text_length (font, buff), midY, opts[z].color, -1);
				} else if (opts[z].type == OPTION_COLORTYPE) {
					sprintf (buff, "%s:", opts[z].name);
					textout_ex (env->db, font, buff, midX - text_length (font, buff), midY, opts[z].color, -1);
				} else if (opts[z].type == OPTION_TOGGLETYPE) {
					sprintf (buff, "%s", opts[z].name);
					textout_centre_ex (env->db, font, buff, midX, midY, opts[z].color, -1);
				} else {
					sprintf (buff, "%s:", opts[z].name);
					textout_ex (env->db, font, buff, midX - text_length (font, buff), midY, opts[z].color, -1);
					if (!opts[z].viewonly) {
						draw_sprite_v_flip (env->db, (BITMAP *) global->gfxData.M[6].dat, midX + 100, midY);
						draw_sprite (env->db, (BITMAP *) global->gfxData.M[6].dat, midX + 112, midY);
					}
				}
			}
			if (but_okay) but_okay->draw (env->db);
			if (but_quit) but_quit->draw (env->db);
		}
		
		for (z = 0; z < numEntries; z++) {
			int midX = opts[z].x;
			int midY = opts[z].y;
			if (updateoption[z]) {
				updateoption[z] = 0;
				if (opts[z].type == OPTION_TOGGLETYPE) {
					int color = (*opts[z].value)?WHITE:BLACK;
					ellipsefill (env->db, midX, midY + text_height (font) / 2, text_length (font, opts[z].name) / 2, text_height (font), color);
				}
				if (opts[z].displayFunc) {
					if (opts[z].type == OPTION_TOGGLETYPE) {
						opts[z].displayFunc (global, env,
								midX + text_length (font, opts[z].name) / 2, midY,
								opts[z].data);
					} else {
						opts[z].displayFunc (global, env,
								midX, midY,
								opts[z].data);
					}
					env->make_update (midX - 100, midY - text_height (font), 250, 20);
				} else if (opts[z].type != OPTION_MENUTYPE && opts[z].type != OPTION_ACTIONTYPE) {
					if (opts[z].type == OPTION_DOUBLETYPE) {
						char buff[10];
						sprintf (buff, opts[z].format, *opts[z].value);
						textEntryBox (global, env, FALSE, midX + 50, midY, buff, 10);
					} else if (opts[z].type == OPTION_TEXTTYPE) {
						textEntryBox (global, env, FALSE, midX + 50, midY, (char*)opts[z].value, 10);
					} else if (opts[z].type == OPTION_COLORTYPE) {
						colorBar (global, env, midX, midY, 100, 15);
						rectfill (env->db, midX + 110, midY, midX + 130, midY + 10, *(int*)opts[z].value);
						rect (env->db, midX + 110, midY, midX + 130, midY + 10, BLACK);
					} else if (opts[z].type == OPTION_TOGGLETYPE) {
						sprintf (buff, "%s", opts[z].name);
						textout_centre_ex (env->db, font, buff, midX, midY, opts[z].color, -1);
					} else if (opts[z].specialOpts) {
						textEntryBox (global, env, FALSE, midX + 50, midY, opts[z].specialOpts[(int) *opts[z].value], 10);
					}
					env->make_update (midX - 100, midY - 2, 250, 20);
				}
			}
		}

		if (fi) {
			fi = 0;
			quickChange (global, env->db);
		}

		if(but_quit && but_quit->isPressed()) {
			global->command = GLOBAL_COMMAND_MENU;
			stop = 1;
		}
		if(but_okay && but_okay->isPressed()) {
			stop = 2;
		}

		if (but_okay) but_okay->draw (env->db);
		if (but_quit) but_quit->draw (env->db);

		show_mouse(env->db);
		env->do_updates ();
	} while ((!keypressed ()) && (!stop) );
	if (!stop)
		ke = readkey ();
	else if (stop == 2)
		ke = KEY_SPACE << 8;
	else
		ke = KEY_ESC << 8;
	
	flush_inputs();

	if (but_quit)
		delete but_quit;
	if (but_okay)
		delete but_okay;

	return (ke);
}

int editPlayers (GLOBALDATA *global, ENVIRONMENT *env)
{
	int optionsRetVal;
	int rows = (global->screenHeight - 400) / 15;
	int columns = (global->numPermanentPlayers / rows) + 1;
	rows = (rows / columns) + 1;

	MENUENTRY *playersOpts;
	MENUDESC playersMenu;
	playersOpts = new MENUENTRY[1 + global->numPermanentPlayers];
	if (!playersOpts) {
		perror ("atanks.cc: Failed allocating memory for playersOpts in editPlayers");
		exit (1);
	}
	playersOpts[0].name = "Create New";
	playersOpts[0].displayFunc = NULL;
	playersOpts[0].color = WHITE;
	playersOpts[0].value = (double*)createNewPlayer;
	playersOpts[0].data = NULL;
	playersOpts[0].type = OPTION_ACTIONTYPE;
	playersOpts[0].viewonly = FALSE;
	playersOpts[0].x = global->halfWidth - 3;
	playersOpts[0].y = global->halfHeight - 68 - 15;

	playersMenu.title = "Players";
	playersMenu.numEntries = 1 + global->numPermanentPlayers;
	playersMenu.entries = playersOpts;
	playersMenu.quitButton = TRUE;
	playersMenu.okayButton = FALSE;

	for (int count = 0; count < global->numPermanentPlayers; count++) {
		MENUENTRY *opt = &playersOpts[1 + count];

		opt->name = global->allPlayers[count]->getName ();
		opt->displayFunc = displayPlayerName;
		opt->data = global->allPlayers[count];
		opt->color = global->allPlayers[count]->color;
		opt->value = (double*)global->allPlayers[count]->menudesc;
		opt->type = OPTION_MENUTYPE;
		opt->viewonly = FALSE;
		opt->x = global->halfWidth - (((count % columns) - (columns / 2)) * 90) - (((columns + 1) % 2) * 45);
		opt->y = global->halfHeight - 68 + ((count / columns) * 15);
	}
	optionsRetVal = options (global, env, &playersMenu);

	delete playersOpts;

	return (optionsRetVal);
}

int selectPlayers (GLOBALDATA *global, ENVIRONMENT *env)
{
	MENUENTRY roundOpt = {"Rounds", NULL, WHITE, (double*)&global->rounds, NULL, "%2.0f", 1, MAX_ROUNDS, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, 200};
	int optionsRetVal, z;
	int rows = (global->screenHeight - 400) / 15;
	int columns = (global->numPermanentPlayers / rows) + 1;
	rows = (rows / columns) + 1;

	MENUENTRY *playersOpts;
	MENUDESC playersMenu;
	playersOpts = new MENUENTRY[global->numPermanentPlayers + 1];
	if (!playersOpts) {
		perror ("atanks.cc: Failed allocating memory for playersOpts in selectPlayers");
		exit (1);
	}

	playersMenu.title = "Select Players";
	playersMenu.numEntries = global->numPermanentPlayers + 1;
	playersMenu.entries = playersOpts;
	playersMenu.quitButton = TRUE;
	playersMenu.okayButton = TRUE;

	for (int count = 0; count < global->numPermanentPlayers; count++) {
		MENUENTRY *opt = &playersOpts[count];

		opt->name = global->allPlayers[count]->getName ();
		opt->displayFunc = displayPlayerName;
		opt->data = global->allPlayers[count];
		opt->color = global->allPlayers[count]->color;
		opt->value = (double*)&global->allPlayers[count]->selected;
		opt->type = OPTION_TOGGLETYPE;
		opt->viewonly = FALSE;
		opt->x = global->halfWidth - (((count % columns) - (columns / 2)) * 90) - (((columns + 1) % 2) * 45);
		opt->y = global->halfHeight - 68 + ((count / columns) * 15);
	}
	memcpy (&playersOpts[global->numPermanentPlayers], &roundOpt, sizeof (MENUENTRY));

	do {
		optionsRetVal = options (global, env, &playersMenu);
		if (optionsRetVal >> 8 != KEY_ESC) {
			int playerCount = 0;
			global->numPlayers = 0;
			for (z = 0; z < global->numPermanentPlayers; z++) {
				if (global->allPlayers[z]->selected) {
					global->addPlayer (global->allPlayers[z]);
					playerCount++;
				}
			}
			if ((playerCount < 2) || (playerCount > MAXPLAYERS)) {
				optionsRetVal = -1;
				if (playerCount < 2)
					errorMessage = "You must select at least 2 players";
				else if (playerCount > 10)
					errorMessage = "You can only have up to 10 players";
				errorX = global->halfWidth - text_length (font, errorMessage) / 2;
				errorY = 170;
			} else {
				optionsRetVal = 0;
			}
		}
	} while ((optionsRetVal != 0) && (optionsRetVal >> 8 != KEY_ESC));

	delete playersOpts;

	return (optionsRetVal);
}

void title (GLOBALDATA *global)
{
	show_mouse(NULL);
	blit ((BITMAP *) global->gfxData.TITLE[0].dat, screen, 0, 0, global->halfWidth - 320, global->halfHeight - 240, 640, 480);
	//show_mouse (screen);
	clear_keybuf ();

	//wait_for_input();
	
	//show_mouse (NULL);
}

int gradientColorPoint (const gradient *grad, double length, double line)
{
	int pointCount = 0;
	double point = line / length;
	int color;

	for (pointCount = 0; (point >= grad[pointCount].point) && (grad[pointCount].point != -1); pointCount++);
	pointCount--;

	if (pointCount == -1) {
		color = makecol (grad[0].color.r, grad[0].color.g, grad[0].color.b);
	} else if (grad[pointCount + 1].point == -1) {
		color = makecol (grad[pointCount].color.r, grad[pointCount].color.g, grad[pointCount].color.b);
	} else {
		double i = (point - grad[pointCount].point) / (grad[pointCount + 1].point - grad[pointCount].point);
		int r = (int)(interpolate (grad[pointCount].color.r, grad[pointCount + 1].color.r, i));
		int g = (int)(interpolate (grad[pointCount].color.g, grad[pointCount + 1].color.g, i));
		int b = (int)(interpolate (grad[pointCount].color.b, grad[pointCount + 1].color.b, i));

		color = makecol (r, g, b);
	}

	return (color);
}

int menu (GLOBALDATA *global, ENVIRONMENT *env)
{
	int bf = 0, bfdd = 1, ban, anclock, lb, updateplayers, done, updaterounds, z, zz;
	BUTTON but_play(global, env, global->halfWidth - 75, global->halfHeight - 235, NULL, (BITMAP*)global->gfxData.B[0].dat, (BITMAP*)global->gfxData.B[0].dat, (BITMAP*)global->gfxData.B[1].dat);
	BUTTON but_help(global, env, global->halfWidth - 75, global->halfHeight - 185, NULL, (BITMAP*)global->gfxData.B[2].dat, (BITMAP*)global->gfxData.B[2].dat, (BITMAP*)global->gfxData.B[3].dat);
	BUTTON but_options(global, env, global->halfWidth - 75, global->halfHeight - 135, NULL, (BITMAP*)global->gfxData.B[4].dat, (BITMAP*)global->gfxData.B[4].dat, (BITMAP*)global->gfxData.B[5].dat);
	BUTTON but_players(global, env, global->halfWidth - 75, global->halfHeight - 85, NULL, (BITMAP*)global->gfxData.B[6].dat, (BITMAP*)global->gfxData.B[6].dat, (BITMAP*)global->gfxData.B[7].dat);
	BUTTON but_credits(global, env, global->halfWidth - 75, global->halfHeight - 35, NULL, (BITMAP*)global->gfxData.B[8].dat, (BITMAP*)global->gfxData.B[8].dat, (BITMAP*)global->gfxData.B[9].dat);
	BUTTON but_quit(global, env, global->halfWidth - 75, global->halfHeight + 15, NULL, (BITMAP*)global->gfxData.B[10].dat, (BITMAP*)global->gfxData.B[10].dat, (BITMAP*)global->gfxData.B[11].dat);

	BUTTON *button[MENUBUTTONS] = {&but_play, &but_help, &but_options,
					&but_players, &but_credits, &but_quit};

	ban = -1;
	cclock = global->updateCount = lx = ly = anclock = env->mouseclock = 0;
	lb = updateplayers = done = updaterounds = 0;
	fi = global->stopwindow = 1;
	while (!done) {

        LINUX_SLEEP;
		while (cclock > 0) {
			cclock--;
			zz = 0;
			for (z = 0; z < MENUBUTTONS; z++) {
				if (button[z]->isMouseOver ()) {
					if (ban > -1 && ban != z) {
						button[z]->draw (env->db);
						//env->make_update (button[ban]->location.x, button[ban]->location.y, button[ban]->location.w, button[ban]->location.h);
					}
					ban = z;
					zz = 1;
					/*anclock++;
					if (anclock > 6) {
						anclock = 0;
						bf += bfdd;
						if (bf > BUTTONFRAMES - 2)
							bfdd = -1;
						if (bf < 2)
							bfdd = 1;
					}*/
					break;
				}
			}
			if (!zz) {
				bf = 0;
				bfdd = 1;
			}
			if (!lb && mouse_b & 1)
				env->mouseclock = 0;
			lb = (mouse_b & 1) ? 1 : 0;
			if (mouse_b & 1) {
				for (z = 0; z < MENUBUTTONS; z++) {
					if (button[z]->isPressed ()) {
						if (z == 0)
							global->command = GLOBAL_COMMAND_PLAY, done = 1;
						if (z == 1)
							global->command = GLOBAL_COMMAND_HELP, done = 1;
						if (z == 2)
							global->command = GLOBAL_COMMAND_OPTIONS, done = 1;
						if (z == 3)
							global->command = GLOBAL_COMMAND_PLAYERS, done = 1;
						if (z == 4)
							global->command = GLOBAL_COMMAND_CREDITS, done = 1;
						if (z == 5)
							global->command = GLOBAL_COMMAND_QUIT, done = 1;
					}
				}
				//if (global->rounds > 1 && !env->mouseclock
				//    && mouse_x >= global->halfWidth - 60 && mouse_x < global->halfWidth - 50 && mouse_y >= global->halfHeight + 199 && mouse_y < global->halfHeight + 209) {
				//	updaterounds = 1;
				//	global->rounds--;
				//}
				//if (global->rounds < 100 && !env->mouseclock
				//    && mouse_x >= global->halfWidth + 64 && mouse_x < global->halfWidth + 74 && mouse_y >= global->halfHeight + 199 && mouse_y < global->halfHeight + 209) {
				//	updaterounds = 1;
				//	global->rounds++;
				//}
			}
			env->mouseclock++;
			if (env->mouseclock > 10)
				env->mouseclock = 0;
		}
		if (updaterounds) {
			updaterounds = 0;
			env->make_update (global->halfWidth + 27, global->halfHeight + 198, 32, 32);
		}
		show_mouse (NULL);
		if (fi) {
			draw_circlesBG (global, env->db, 0, 0, global->screenWidth, global->screenHeight);
			//textout (env->db, font, "Rounds: ", global->halfWidth - 45, global->halfHeight + 200, BLACK);
			//draw_sprite_v_flip (env->db, (BITMAP *) global->gfxData.M[6].dat, global->halfWidth - 60, global->halfHeight + 199);
			//draw_sprite (env->db, (BITMAP *) global->gfxData.M[6].dat, global->halfWidth + 64, global->halfHeight + 199);
			for (z = 0; z < MENUBUTTONS; z++) {
				button[z]->draw (env->db);
			}
		}
		if (ban > -1) {
			button[ban]->draw (env->db);
			//env->make_update (button[ban]->location.x, button[ban]->location.y, button[ban]->location.w, button[ban]->location.h);
		}
		//rectfill (env->db, global->halfWidth + 27, global->halfHeight + 198, global->halfWidth + 59, global->halfHeight + 210, WHITE);
		//rect (env->db, global->halfWidth + 27, global->halfHeight + 198, global->halfWidth + 59, global->halfHeight + 210, BLACK);
		//textprintf_centre (env->db, font, global->halfWidth + 43, global->halfHeight + 200, BLACK, "%d", global->rounds);
		show_mouse (env->db);
		env->make_update (mouse_x, mouse_y, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		env->make_update (lx, ly, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		lx = mouse_x;
		ly = mouse_y;
		if ((key[KEY_Q]) || (key[KEY_F10])) {
			return SIG_QUIT_GAME;
		}
		if (fi) {
			fi = 0;
			change (global, env->db);
		}
		env->do_updates ();
	}
	clear_keybuf ();
	return SIG_OK;
}

void draw_text_in_box (ENVIRONMENT *env, BOX *region, char *text)
{
	char buffer[1024];
	unsigned int lineBegin;
	int lastSpace = 0;
	int lineCount;
	int charCount;
	int buffCount ;

	rectfill (env->db, region->x, region->y, region->w, region->h,
			makecol (0,0,128));
	rect     (env->db, region->x, region->y, region->w, region->h,
			makecol (128,128,255));

	lineBegin = 0;
	lineCount = 0;
	while (lineBegin < strlen (text)) {
		charCount = 0;
		buffCount = 0;
		do {
			buffer[buffCount] = text[lineBegin + charCount];
			buffer[buffCount+1] = 0;
			if (buffer[buffCount] == ' ') {
				lastSpace = 0;
			} else if (buffer[buffCount] == '\n') {
				lineCount++;
				charCount++;
				break;
			}
			lastSpace++;
			buffCount++;
			charCount++;
		} while (text[lineBegin + charCount] && (text_length (font, buffer) < region->w - 20));
		if ((lastSpace > 0) && (text_length (font, buffer) >= region->w - 20)) {
			charCount -= lastSpace - 1;
			buffer[buffCount - lastSpace] = 0;
		} else {
			buffer[buffCount] = 0;
		}
		textout_ex (env->db, font, buffer, region->x + 5,
			region->y + (lineCount * text_height (font)) + 5, WHITE, -1);
		lineBegin = lineBegin + charCount;
		charCount = 0;
		lineCount++;
	}
	env->make_update (region->x, region->y, region->w, region->h);
}

void draw_buystuff(GLOBALDATA *global, ENVIRONMENT *env, PLAYER *pl)
{
	int z;
	env->make_update (0, 0, global->screenWidth, global->screenHeight);
	show_mouse (NULL);
	
	draw_circlesBG (global, env->db, 0, 0, global->screenWidth, global->screenHeight);
	draw_sprite (env->db, (BITMAP *) global->gfxData.M[DONE_IMAGE].dat, global->halfWidth - 100, global->screenHeight - 50);
	draw_sprite (env->db, (BITMAP *) global->gfxData.M[FAST_UP_ARROW_IMAGE].dat, global->screenWidth - STUFF_BAR_WIDTH - 30, global->halfHeight - 50);
	draw_sprite (env->db, (BITMAP *) global->gfxData.M[UP_ARROW_IMAGE].dat, global->screenWidth - STUFF_BAR_WIDTH - 30, global->halfHeight - 25);
	draw_sprite (env->db, (BITMAP *) global->gfxData.M[DOWN_ARROW_IMAGE].dat, global->screenWidth - STUFF_BAR_WIDTH - 30, global->halfHeight);
	draw_sprite (env->db, (BITMAP *) global->gfxData.M[FAST_DOWN_ARROW_IMAGE].dat, global->screenWidth - STUFF_BAR_WIDTH - 30, global->halfHeight + 25);
	drawing_mode (DRAW_MODE_TRANS, NULL, 0, 0);

	for (z = 0; z < global->halfWidth - 200; z++) {
		set_trans_blender (0, 0, 0, (int)((double)((double)z / (global->halfWidth - 200)) * 240) + 15);
		vline (env->db, z, 0, 29, pl->color);
	}

	for (z = 0; z < global->halfWidth - 200; z++) {
		set_trans_blender (0, 0, 0, (int)((double)((double)z / (global->halfWidth - 200)) * 240) + 15);
		vline (env->db, (global->screenWidth-1) - z, 0, 29, pl->color);
	}

	solid_mode ();

}

int btps;
void draw_weapon_list(GLOBALDATA *global, ENVIRONMENT *env, PLAYER *pl, int *trolley, int scroll, int pressed)
{
	int slot, zzz;
	double tempbtps = (global->screenHeight - 55) / STUFF_BAR_HEIGHT;
	// To be sure it rounds down
	btps = (int)tempbtps;
	if (tempbtps < btps)
		btps--;

	for (slot = 1, zzz = scroll; (slot < btps) && (zzz < env->numAvailable); zzz++) {
		int itemNum = env->availableItems[zzz];
		draw_sprite (env->db, (BITMAP *)global->gfxData.stuff_bar[(pressed == itemNum)?1:0], global->screenWidth - STUFF_BAR_WIDTH, slot * STUFF_BAR_HEIGHT);
		
		draw_sprite(env->db, (BITMAP *) global->gfxData.stuff_icon_base, global->screenWidth - STUFF_BAR_WIDTH, (slot * STUFF_BAR_HEIGHT));
		draw_sprite(env->db, (BITMAP *) global->gfxData.STOCK_IMAGE[itemNum].dat, global->screenWidth - STUFF_BAR_WIDTH, (slot * STUFF_BAR_HEIGHT) - 5);
		env->make_update (global->screenWidth - STUFF_BAR_WIDTH, slot * STUFF_BAR_HEIGHT, STUFF_BAR_WIDTH, STUFF_BAR_HEIGHT + 5);

		if (itemNum > WEAPONS - 1) {	/* Items part */

			textout_ex (env->db, font,
				 item[itemNum - WEAPONS].name, global->screenWidth - STUFF_BAR_WIDTH + 45, (slot * STUFF_BAR_HEIGHT) + 5, BLACK, -1);
			// Amount in inventory
			textprintf_ex (env->db, font, global->screenWidth - STUFF_BAR_WIDTH + 45, (slot * STUFF_BAR_HEIGHT) + (STUFF_BAR_HEIGHT/2), BLACK, -1, "Qty. in inventory: %d", pl->ni[itemNum - WEAPONS]);
			// Anything in the trolley
			if (trolley[itemNum] != 0) {
				int textCol;
				if (trolley[itemNum] > 0)
					textCol = makecol (255,255,0);
				else
					textCol = makecol (176,0,0);
				textprintf_ex (env->db, font, global->screenWidth - STUFF_BAR_WIDTH + 45 + text_length (font, "Qty. in inventory: ddd"), (slot * STUFF_BAR_HEIGHT) + (STUFF_BAR_HEIGHT/2), textCol, -1, "%+d", trolley[itemNum]);
			}
			sprintf (buf, "$%d", item[itemNum - WEAPONS].cost);
			textout_ex (env->db, font, buf,
				 global->screenWidth - 45 - text_length (font, buf), (slot * STUFF_BAR_HEIGHT) + 5, BLACK, -1);
			sprintf (buf, "for %d", item[itemNum - WEAPONS].amt);
			textout_ex (env->db, font, buf,
				 global->screenWidth - 45 - text_length (font, buf), (slot * STUFF_BAR_HEIGHT) + (STUFF_BAR_HEIGHT/2), BLACK, -1);
		} else {			/* Weapons part */

			textout_ex (env->db, font, weapon[itemNum].name, global->screenWidth - STUFF_BAR_WIDTH + 45, (slot * STUFF_BAR_HEIGHT) + 5, BLACK, -1);
			textprintf_ex (env->db, font, global->screenWidth - STUFF_BAR_WIDTH + 45, (slot * STUFF_BAR_HEIGHT) + (STUFF_BAR_HEIGHT/2), BLACK, -1, "Qty. in inventory: %d", pl->nm[itemNum]);
			// Anything in the trolley
			if (trolley[itemNum] != 0) {
				int textCol;
				if (trolley[itemNum] > 0)
					textCol = makecol (255,255,0);
				else
					textCol = makecol (176,0,0);
				textprintf_ex (env->db, font, global->screenWidth - STUFF_BAR_WIDTH + 45 + text_length (font, "Qty. in inventory: ddd"), (slot * STUFF_BAR_HEIGHT) + (STUFF_BAR_HEIGHT/2), textCol, -1, "%+d", trolley[itemNum]);
			}
			sprintf (buf, "$%d", weapon[itemNum].cost);
			textout_ex (env->db, font, buf,
				 global->screenWidth - 45 - text_length (font, buf), (slot * STUFF_BAR_HEIGHT) + 5, BLACK, -1);
			sprintf (buf, "for %d", weapon[itemNum].amt);
			textout_ex (env->db, font, buf, global->screenWidth - 45 - text_length (font, buf), (slot * STUFF_BAR_HEIGHT) + (STUFF_BAR_HEIGHT/2), BLACK, -1);
		}
		slot++;
	}

}

void buystuff (GLOBALDATA *global, ENVIRONMENT *env)
{
	int pl, done, updatew[THINGS], updatename, pressed, scroll, lb, lastMouse_b;
	int hoverOver = 0, z, zz, zzz;
	char buf[50];

	global->updateCount = cclock = lb = env->mouseclock = 0;
	fi = global->stopwindow = updatename = scroll = 1;
	if (global->currentround != global->rounds) {
		for (z = 0; z < global->numPlayers; z++) {
			global->players[z]->money = (unsigned long int) (global->players[z]->money * global->interest);
		}
	}

	env->generateAvailableItemsList ();

	for (pl = 0; pl < global->numPlayers; pl++) {
		int money = global->players[pl]->money;
		int trolley[THINGS];
		memset (trolley, 0, sizeof (int) * THINGS);

        	//have computer players buy stuff
		if ((int)global->players[pl]->type != HUMAN_PLAYER) {
			int pressed = 0;
			//continue until still have money or done buying
			while (global->players[pl]->money > 0 && pressed != -1)
				pressed = global->players[pl]->chooseItemToBuy ();
			continue;  //go to next player
		}

		done = 0;
		updatename = scroll = 1;
		pressed = -1;

		draw_buystuff (global, env, global->players[pl]);
		
		for (z = 0; z < THINGS; z++)
			updatew[z] = 1;
		while (!done) {

            LINUX_SLEEP;
			while (cclock > 0) {
				cclock--;
				if (!lb && mouse_b & 1 && mouse_x >= global->halfWidth - 100 && mouse_x < global->halfWidth + 100 && mouse_y >= global->screenHeight - 50 && mouse_y < global->screenHeight - 25)
					done = 1;
				if (!lb && mouse_b & 1)
					env->mouseclock = 0;
				lb = (mouse_b & 1) ? 1 : 0;

				//Keyboard control
				if ((key[KEY_UP]) && (scroll > 1)
				    && (!env->mouseclock)) {
					scroll--;
					for (z = 0; z < THINGS; z++)
						updatew[z] = 1;
				}
				if ((key[KEY_PGUP]) && (scroll > 1)
				    && (!env->mouseclock)) {
					scroll -= btps / 2;
					if (scroll < 1)
						scroll = 1;
					for (z = 0; z < THINGS; z++)
						updatew[z] = 1;
				}
				if ((key[KEY_DOWN])
				    && (scroll <= env->numAvailable - btps)
				    && (!env->mouseclock)) {
					scroll++;
					for (z = 0; z < THINGS; z++)
						updatew[z] = 1;
				}
				if ((key[KEY_PGDN])
					&& (scroll <= env->numAvailable - btps + 1)
					&& (!env->mouseclock)) {
					scroll += btps / 2;
					if (scroll > env->numAvailable - btps + 1)
						scroll = env->numAvailable - btps + 1;
					for (z = 0; z < THINGS; z++)
						updatew[z] = 1;
				}

				//Mouse control
				if (mouse_x >= global->screenWidth - STUFF_BAR_WIDTH && mouse_x < global->screenWidth) {
					int newlyOver;
					zz = 0;
					for (z = 1, zzz = scroll; z < btps; z++, zzz++) {
						if (mouse_y >= z * STUFF_BAR_HEIGHT && mouse_y < (z * STUFF_BAR_HEIGHT) + 30) {
							zz = 1;
							break;
						}
					}
					if (zz)
						newlyOver = env->availableItems[zzz];
					else
						newlyOver = -1;
					if (hoverOver != newlyOver) {
						char description[1024];
						BOX area = {20, 60, 300, 400};

						if (newlyOver > -1) {
							if (newlyOver < WEAPONS) {
								WEAPON *weap = &weapon[newlyOver];
								sprintf (description, "Radius: %d\nYield: %ld\n\n%s",
									weap->radius, calcTotalPotentialDamage (newlyOver) * weap->spread, weap->description);
							} else {
								int itemNum = newlyOver - WEAPONS;
								ITEM *it = &item[itemNum];
								if (itemNum >= ITEM_VENGEANCE && itemNum <= ITEM_FATAL_FURY) {
									sprintf (description, "Potential Damage: %ld\n\n%s",
										calcTotalPotentialDamage ((int)it->vals[0]) * (int)it->vals[1],
										it->description);
								} else {
									sprintf (description, "%s", it->description);
								}
							}
						} else {
							description[0] = 0;
						}
						hoverOver = newlyOver;

						draw_text_in_box (env, &area, description);
					}
				}
				if (mouse_b & 1 && !env->mouseclock) {
					int scrollArrowPos = global->screenWidth - STUFF_BAR_WIDTH - 30;
					if (mouse_x >= scrollArrowPos && mouse_x < scrollArrowPos + 24) {
						if ((mouse_y >= global->halfHeight - 50 && mouse_y < global->halfHeight - 25) && (scroll > 1)) {
							scroll -= btps / 2;
							if (scroll < 1)
								scroll = 1;
							for (z = 0; z < THINGS; z++)
								updatew[z] = 1;
						}
						if ((mouse_y >= global->halfHeight - 24 && mouse_y < global->halfHeight) && (scroll > 1)) {
							scroll--;
							for (z = 0; z < THINGS; z++)
								updatew[z] = 1;
						}
						if ((mouse_y >= global->halfHeight + 1 && mouse_y < global->halfHeight + 25) && (scroll <= env->numAvailable - btps)) {
							scroll++;
							for (z = 0; z < THINGS; z++)
								updatew[z] = 1;
						}
						if ((mouse_y >= global->halfHeight + 25 && mouse_y < global->halfHeight + 50) && (scroll <= env->numAvailable - btps + 1)) {
							scroll += btps / 2;
							if (scroll > env->numAvailable - btps + 1)
								scroll = env->numAvailable - btps + 1;
							for (z = 0; z < THINGS; z++)
								updatew[z] = 1;
						}
					}
				}
				if (mouse_b & 1 || mouse_b & 2) {
					int itemButtonClicked = 0;
					for (int buttonCount = 1, currItem = scroll; buttonCount < btps; buttonCount++, currItem++) {
						if (mouse_x >= global->screenWidth - STUFF_BAR_WIDTH && mouse_x < global->screenWidth && mouse_y >= buttonCount * STUFF_BAR_HEIGHT && mouse_y < (buttonCount * STUFF_BAR_HEIGHT) + 30) {
							itemButtonClicked = 1;
							// Remember which button was pressed
							if (pressed > -1)
								updatew[pressed]
									= 1;
							pressed = env->availableItems[currItem];
							updatew[env->availableItems[currItem]] = 1;
						}
					}
					if (!itemButtonClicked) {
						if (pressed > -1)
							updatew[pressed] = 1;
						pressed = -1;
					}
				}
				if (pressed > -1 && !(mouse_b & 1 || mouse_b & 2)) {
					// Cost, amount and in-inventory amount
					// of pressed item
					int cost,amt,inInv;
					updatew[pressed] = 1;

					if (pressed > WEAPONS - 1) {
						cost = item[pressed - WEAPONS].cost;
						amt = item[pressed - WEAPONS].amt;
						inInv = global->players[pl]->ni[pressed - WEAPONS];
					} else {
						cost = weapon[pressed].cost;
						amt = weapon[pressed].amt;
						inInv = global->players[pl]->nm[pressed];
					}

					if (lastMouse_b & 2) {
						if (inInv + trolley[pressed] >= amt) {
							if (trolley[pressed] >= amt) {
								money += cost;
								trolley[pressed] -= amt;
								updatename = 1;
							} else {
								if (global->sellpercent > 0.01) {
									money += (unsigned long int)(cost * global->sellpercent);
									trolley[pressed] -= amt;
									updatename = 1;
								}
							}
						}
					} else {
						if ((money >= cost)
						    && (inInv + trolley[pressed] < 999)) {
							// Deal with buying back virtually sold inventory, without loss of cash
							if (trolley[pressed] <= -amt) {
								if (global->sellpercent > 0.01) {
									money -= (unsigned long int)(cost * global->sellpercent);
									trolley[pressed] += amt;
									updatename = 1;
								}
							} else {
								money -= cost;
								trolley[pressed] += amt;
								updatename = 1;
								if (inInv + trolley[pressed] > 999)
									trolley[pressed] = 999;
							}
						}
					}
					pressed = -1;
				}
				env->mouseclock++;
				if (env->mouseclock > 5)
					env->mouseclock = 0;
				lastMouse_b = mouse_b;
			}
			show_mouse (NULL);
			if (fi) {
				for (int thing = 0; thing < THINGS; thing++)
					updatew[thing] = 1;
			}
			if (updatename) {
				updatename = 0;
				env->make_update (global->halfWidth - 315, 0, 400, 30);
				draw_sprite (env->db, (BITMAP *) global->gfxData.stuff_bar[0], global->halfWidth - 200, 0);
				textprintf_ex (env->db, font, global->halfWidth - 155, 5, BLACK, -1, "Player %d: %s", pl + 1, global->players[pl]->getName ());
				textprintf_ex (env->db, font, global->halfWidth - 155, 17, BLACK, -1, "Money: $%d", money);
				sprintf (buf, "Round: %d/%d", (int)(global->rounds - global->currentround) + 1, (int)global->rounds);
				textout_ex (env->db, font, buf, global->halfWidth + 170 - text_length (font, buf), 5, BLACK, -1);
				sprintf (buf, "Score: %d", global->players[pl]->score);
				textout_ex (env->db, font, buf, global->halfWidth + 155 - text_length (font, buf), 17, BLACK, -1);
			}

			draw_weapon_list(global, env, global->players[pl], trolley, scroll, pressed);
			env->make_update (mouse_x, mouse_y, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
			env->make_update (lx, ly, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
			lx = mouse_x;
			ly = mouse_y;
			show_mouse (env->db);
			if (fi) {
				change (global, env->db);
				fi = 0;
			}

			else
				env->do_updates ();
		}
		for (int tItem = 0; tItem < WEAPONS; tItem++)
			global->players[pl]->nm[tItem] += trolley[tItem];
		for (int tItem = WEAPONS; tItem < THINGS; tItem++)
			global->players[pl]->ni[tItem - WEAPONS] += trolley[tItem];
		global->players[pl]->money = money;
	}
	clear_keybuf ();
}

//Juraj Michalek -> convert this code back to C++ :-)))
float crand ()			// Pavel Minayev
{
	return 2.0 * rand () / RAND_MAX - 1;
}


#ifdef GETV_IS_EVER_USED
double getv (int color)
{
	float h, s, v;
	int r, g, b;

	r = getr (color);
	g = getg (color);
	b = getb (color);
	rgb_to_hsv (r, g, b, &h, &s, &v);

	return (v);
}
#endif //GETV_IS_EVER_USED



void generate_land (GLOBALDATA *global, ENVIRONMENT *env, int xoffset, int yoffset, int width, int heightx)
{
	const int land_height = heightx * 5 / 6;
	double	smoothness = 100;
	int	octaves = 8;
	double	lambda = 0.25;
	double	depthStrip[2][global->screenHeight];

	int landType = (env->landType == LANDTYPE_RANDOM)? (rand () % LANDTYPE_PLAIN) + 1 : (int)env->landType;

	switch (landType) {
		case LANDTYPE_MOUNTAINS:
			smoothness = 200;
			octaves = 8;
			lambda = 0.65;
			break;
		case LANDTYPE_CANYONS:
			smoothness = 50;
			octaves = 8;
			lambda = 0.25;
			break;
		case LANDTYPE_VALLEYS:
			smoothness = 200;
			octaves = 8;
			lambda = 0.25;
			break;
		case LANDTYPE_HILLS:
			smoothness = 600;
			octaves = 6;
			lambda = 0.40;
			break;
		case LANDTYPE_FOOTHILLS:
			smoothness = 1200;
			octaves = 3;
			lambda = 0.25;
			break;
		case LANDTYPE_PLAIN:
			smoothness = 4000;
			octaves = 2;
			lambda = 0.2;
			break;
		default:
			break;
	}

	if (global->detailedLandscape)
		memset (depthStrip[1], 0, global->screenHeight * sizeof (double));

	for (int x = 0; x < global->screenWidth; x++) {
		int depth = 0;
		env->height[x] = ((perlin2DPoint (1.0, smoothness, xoffset + x, yoffset, lambda, octaves) + 1) / 2);

		if (global->detailedLandscape) {
			memcpy (depthStrip[0], depthStrip[1], global->screenHeight * sizeof(double));
			for (depth = 1; depth < global->screenHeight; depth++) {
				depthStrip[1][depth] = ((perlin2DPoint (1.0, smoothness, xoffset + x, yoffset + depth, lambda, octaves) + 1) / 2 * land_height - (global->screenHeight - depth));
				if (depthStrip[1][depth] > env->height[x] * land_height)
					depthStrip[1][depth] = env->height[x] * land_height;
			}
			depthStrip[1][0] = 0;
			depth = 1;
		}

		env->height[x] *= land_height;
		for (int y = 0; y <= env->height[x]; y++) {
			double offset = 0;
			int color = 0;
			double shade = 0;
			//int skyTint = 0;

			if (global->detailedLandscape) {
				double bot, top, minBot, maxTop, btdiff, i;
				double a1, a2, angle;
				while ((depthStrip[1][depth] <= y) && (depth < global->screenHeight))
					depth++;
				bot = (depthStrip[0][depth - 1] + depthStrip[1][depth - 1]) / 2;
				top = (depthStrip[0][depth] + depthStrip[1][depth]) / 2;
				minBot = MIN (depthStrip[0][depth - 1], depthStrip[1][depth - 1]);
				maxTop = MAX (depthStrip[0][depth], depthStrip[1][depth]);
				btdiff = maxTop - minBot;
				i = (y - bot) / btdiff;
				a1 = atan2 (depthStrip[0][depth - 1] - depthStrip[1][depth - 1], 1.0) * 180 / PI + 180;
				a2 = atan2 (depthStrip[0][depth] - depthStrip[1][depth], 1.0) * 180 / PI + 180;

				angle = interpolate (a1, a2, i);
				shade = global->slope[(int)angle][0];
				//skyTint = gradientColorPoint (sky_gradients[global->cursky], 1.0, global->slope[(int)angle][1]);
			}

			if (global->ditherGradients)
				offset += rand () % 10 - 5;

			if (global->detailedLandscape)
				offset += (global->screenHeight - depth) * 0.5;

			while (y + offset < 0)
				offset /= 2;
			while (y + offset > global->screenHeight)
				offset /= 2;

			//color = gradientColorPoint (land_gradients[global->curland], global->screenHeight, y + offset);
			color = gradientColorPoint (land_gradients[global->curland], env->height[x], y + offset);
			//color = landtable[y + offset];
			if (global->detailedLandscape) {
				float h, s, v;
				int r, g, b;

				r = getr (color);
				g = getg (color);
				b = getb (color);
				rgb_to_hsv (r, g, b, &h, &s, &v);
				shade += (double)(rand () % 1000 - 500) * (1.0/10000);
				//skyTint
				if (shade < 0)
					v += v * shade * 0.5;
				else
					v += (1 - v) * shade * 0.5;
				hsv_to_rgb (h, s, v, &r, &g, &b);
				color = makecol (r, g, b);
			}

			putpixel (env->terrain, x, global->screenHeight - y, color);
		}
	}
}


BITMAP *create_gradient_strip (const gradient *grad, int length)
{
	BITMAP *strip;
	int color;
	int currLine;

	strip = create_bitmap (1, length);
	clear_to_color (strip, BLACK);

	for (currLine = 0;currLine < length; currLine++) {
		color = gradientColorPoint (grad, length, currLine);
		putpixel (strip, 0, currLine, color);
	}

	return (strip);
}


void set_level_settings (GLOBALDATA *global, ENVIRONMENT *env)
{
	int taken[MAXPLAYERS];
	BITMAP *sky_gradient_strip, *land_gradient_strip;
	int z, zz, peak_height = 0;
	int chosen = 0, chosenCount = 0;
	int objCount;
	TANK *ltank;
	int xoffset;

	srand (time (NULL));

	show_mouse (NULL);
	draw_sprite (screen, (BITMAP *) global->gfxData.M[1].dat, global->halfWidth - 120, global->halfHeight + 115);
	textout_centre_ex (screen, font, "Choosing colors", global->halfWidth, global->halfHeight + 120, WHITE, -1);
	// Choose appropriate gradients for sky and land
	while ((chosenCount < 60) && !chosen) {
		global->curland = rand () % LANDS;
		if (!global->gfxData.land_gradient_strips[global->curland])
			global->gfxData.land_gradient_strips[global->curland] = create_gradient_strip (land_gradients[global->curland], (global->screenHeight - MENU));
		land_gradient_strip = global->gfxData.land_gradient_strips[global->curland];

		global->cursky = rand () % SKIES;
		if (!global->gfxData.sky_gradient_strips[global->cursky])
			global->gfxData.sky_gradient_strips[global->cursky] = create_gradient_strip (sky_gradients[global->cursky], (global->screenHeight - MENU));
		sky_gradient_strip = global->gfxData.sky_gradient_strips[global->cursky];

		chosen = 1;
		for (z = 0; z < global->screenWidth; z++)
			if (peak_height < env->height[z])
				peak_height = (int)env->height[z];
		for (z = 0; z <= peak_height; z++)
		{
			int skyi, landi;
			double distance;
			skyi = getpixel (sky_gradient_strip, 0, (global->screenHeight - MENU - z));
			landi = getpixel (land_gradient_strip, 0, z);

			distance = colorDistance (skyi, landi);
			if (distance < 30)
				chosen = 0;
		}
		chosenCount++;
	}

	show_mouse (NULL);
	draw_sprite (screen, (BITMAP *) global->gfxData.M[1].dat, global->halfWidth - 120, global->halfHeight + 155);
	textout_centre_ex (screen, font, "Rendering Sky", global->halfWidth, global->halfHeight + 160, WHITE, -1);
	xoffset = rand ();
	//generate_sky (global, env, xoffset, 0, global->screenWidth, global->screenHeight);
	generate_sky (global, env->sky, sky_gradients[global->cursky],
		(global->ditherGradients ? GENSKY_DITHERGRAD : 0 ) |
		(global->detailedSky ? GENSKY_DETAILED : 0 )
		);

	show_mouse (NULL);
	draw_sprite (screen, (BITMAP *) global->gfxData.M[1].dat, global->halfWidth - 120, global->halfHeight + 195);
	textout_centre_ex (screen, font, "Rendering Landscape", global->halfWidth, global->halfHeight + 200, WHITE, -1);
	clear_to_color (env->terrain, PINK);

	xoffset = rand ();
	generate_land (global, env, xoffset, 0, global->screenWidth, global->screenHeight);

	for (z = 0; z < global->numTanks; z++) {
		taken[z] = 0;
	}
	for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; objCount++) {
		for (zz = rand () % global->numTanks; taken[zz]; zz = rand () % global->numTanks);
		taken[zz] = 1;
		ltank->x = (zz + 1) * (global->screenWidth / (global->numTanks + 1));
		ltank->y = (global->screenHeight - (int)env->height[(int) ltank->x]) - (TANKHEIGHT - TANKSAG);
		ltank->newRound ();
	}
	for (z = 0; z < MAXPLAYERS * 3; z++)
		env->order[z] = NULL;
	global->maxNumTanks = global->numTanks;
	for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; objCount++) {
		for (z = rand () % global->numTanks; env->order[z]; z = rand () % global->numTanks);
		env->order[z] = ltank;
	}
	if (global->turntype != TURN_RANDOM) {
		for (int index = 0; index < global->maxNumTanks - 1; index++) {
			int swap = FALSE;
			if (global->turntype == TURN_HIGH) {
				if (env->order[index]->player->score <
					env->order[index + 1]->player->score) {
					swap = TRUE;
				}
			} else if (global->turntype == TURN_LOW) {
				if (env->order[index]->player->score >
					env->order[index + 1]->player->score) {
					swap = TRUE;
				}
			}
			if (swap) {
				TANK *tempTank = env->order[index];
				env->order[index] =
					env->order[index + 1];
				env->order[index + 1] = tempTank;
				index = -1;
			}
		}
	}
}


void do_winner (GLOBALDATA *global, ENVIRONMENT *env)
{
    int maxscore = -1;
    int winindex=-1;
    int i;
    bool multiwinner=false;
    int fonthgt = text_height(font)+10;
    
    //find the maxscore and print out winner
    for(i=0;i<global->numPlayers;i++)
    {
      if(global->players[i]->score == maxscore)
        multiwinner=true;
      else if(global->players[i]->score > maxscore)
      {
        maxscore = global->players[i]->score;
        winindex=i;
        multiwinner=false;
      }
    }
    
    //stop mouse during drawing
    show_mouse (NULL);
	
    //draw background and winner bitmap
	draw_circlesBG (global, env->db, 0, 0, global->screenWidth, global->screenHeight);
	draw_sprite (env->db, (BITMAP *) global->gfxData.M[9].dat, global->halfWidth - 150, global->halfHeight - 50);
	
    //draw winner names and info about all players
    int boxtop = global->halfHeight+60;
    int boxleft = global->halfWidth-100;
    int boxright = global->halfWidth+100;
    int boxbottom = boxtop +4+(fonthgt*2)+(fonthgt*global->numPlayers);
	rectfill (env->db, boxleft, boxtop, boxright, boxbottom, BLACK);
	rect (env->db, boxleft, boxtop, boxright, boxbottom, WHITE);
	if (multiwinner)
		textout_centre_ex (env->db, font, "Draw", global->halfWidth, boxtop+4, WHITE, -1);
	else
		textprintf_centre_ex (env->db, font, global->halfWidth, boxtop+4, global->players[winindex]->color, -1, "Winner: %s", global->players[winindex]->getName ());
	
	textout_centre_ex (env->db, font, "Player Scores", global->halfWidth, boxtop+4+fonthgt, WHITE, -1);
	for (i = 0; i < global->numPlayers; i++) {
		int textypos = (i * 10) + boxtop+4+(fonthgt*2);
		unsigned long int money;

		textprintf_ex (env->db, font, boxleft+10, textypos , global->players[i]->color, -1, "%s:", global->players[i]->getName ());

		money = 0;
		for (int weapNum = 0; weapNum < WEAPONS; weapNum++) {
			int individValue;
		       	if (weapon[weapNum].amt)
				individValue = weapon[weapNum].cost / weapon[weapNum].amt;
			else
				individValue = 0;
			money += (unsigned long int)(individValue * global->players[i]->nm[weapNum]);
			//money += (long int)(individValue * global->players[i]->nm[weapNum] * global->sellpercent);
		}
		for (int itemNum = 0; itemNum < ITEMS; itemNum++) {
			int individValue;
		       	if (item[itemNum].amt)
				individValue = item[itemNum].cost / item[itemNum].amt;
			else
				individValue = 0;
			money += (unsigned long int)(individValue * global->players[i]->ni[itemNum]);
		}
		textprintf_ex (env->db, font, boxleft+90, textypos, WHITE, -1, "%3d  $%ld", global->players[i]->score, money);
	}
	
	//do fade and wait for user keypress
	change (global, env->db);
	readkey ();
}


//draws indicaation bar
void graph_bar (ENVIRONMENT *env, int x, int y, long int col, int actual, int max)
{
	rect (env->db, x, y, x + max + 2, y + 8, BLACK);
	rectfill (env->db, x + 1, y + 1, x + 1 + actual, y + 7, col);
}


//draws indication bar - centred
void graph_bar_center (ENVIRONMENT *env, int x, int y, long int col, int actual, int max)
{
	rect (env->db, x, y, x + max + 2, y + 8, BLACK);
	rectfill (env->db, x + 1 + max / 2, y + 1, x + 1 + actual + max / 2, y + 7, col);
}


//Some global parametters
int ord;
void loadshields (GLOBALDATA *global, ENVIRONMENT *env)
{
	TANK *tank;
	int objCount;

	for (objCount = 0; (tank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && tank; objCount++)
		tank->reactivate_shield ();
}

void change_wind_strength (ENVIRONMENT *env)
{
	if (env->windvariation == 0.0 || (int)env->windstrength == 0) {
		return;
	} else {
		env->wind = env->lastwind + (double)(rand () % (int)(env->windvariation * 100)) / 100 - (env->windvariation / 2);
		if (env->wind > (env->windstrength / 2))
		{
			env->wind = env->windstrength / 2;
		} else if (env->wind < (-env->windstrength / 2)) {
			env->wind = -env->windstrength / 2;
		}

		env->lastwind = env->wind;
	}
}

TANK *nextturn (GLOBALDATA *global, ENVIRONMENT *env)
{
	TANK *tank;
	int ordCurrently = ord;

	do {
		ord++;
		if (ord >= global->maxNumTanks)
			ord = 0;
	} while ((!env->order[ord]) && (ord != ordCurrently));
	tank = env->order[ord];
	global->currTank = tank;

	//Wind is blowing :-)
	change_wind_strength (env);

	if (tank) {
		tank->reactivate_shield ();
	}

	return tank;
}

void showRoundEndScoresAt (GLOBALDATA *global, ENVIRONMENT *env, BITMAP *bitmap, int x, int y, int winner)
{
	int z;

	env->make_update (x - 100, y - 100, 201, 201);
	rectfill (bitmap, x - 100, y - 100, x + 100, y + 100, BLACK);
	rect (bitmap, x - 100, y - 100, x + 100, y + 100, WHITE);
	if (winner == -2) {
		textout_centre_ex (bitmap, font, "Draw", x, y - 90, WHITE, -1);
	} else {
		textprintf_centre_ex (bitmap, font, x, y - 90, global->players[winner]->color, -1, "Winner: %s", global->players[winner]->getName ());
	}
	textout_centre_ex (bitmap, font, "Player Scores", x, y - 70, WHITE, -1);
	for (z = 0; z < global->numPlayers; z++) {
		textprintf_ex (bitmap, font, x - 90, (z * 10) + y - 50, global->players[z]->color, -1, "%s:", global->players[z]->getName ());
		textprintf_ex (bitmap, font, x + 10, (z * 10) + y - 50, WHITE, -1, "%d", global->players[z]->score);
	}
}

int setSlideColumnDimensions (GLOBALDATA *global, ENVIRONMENT *env, int x, bool reset)
{
	int pixelHeight;
	char	*done	= env->done;
	int	*dropTo = env->dropTo;
	int	*h	= env->h;
	int	*fp	= env->fp;
	double	*velocity = env->velocity;
	double	*dropIncr = env->dropIncr;

	if (x < 0 || x > (global->screenWidth-1)) {
		return (0);
	}

	if (reset) {
		h[x] = 0;
		fp[x] = 0;
		dropTo[x] = global->screenHeight - 1;
	}
	done[x] = 0;

	// Calc the top and bottom of the column to slide

	// Find top-most non-PINK pixel
	for (pixelHeight = h[x]; pixelHeight < dropTo[x]; pixelHeight++)
		if (getpixel (env->terrain, x, pixelHeight) != PINK)
			break;
	h[x] = pixelHeight;
	env->surface[x] = pixelHeight;

	// Find bottom-most PINK pixel
	for (pixelHeight = dropTo[x]; pixelHeight > h[x]; pixelHeight--)
		if (getpixel (env->terrain, x, pixelHeight) == PINK)
			break;
	dropTo[x] = pixelHeight;

	// Find bottom-most unsupported pixel
	for (; pixelHeight >= h[x]; pixelHeight--)
		if (getpixel (env->terrain, x, pixelHeight) != PINK)
			break;

	// If there's some processing to do
	if ((pixelHeight >= h[x]) && (h[x] < dropTo[x]))
	{
		fp[x] = pixelHeight - (int)h[x] + 1;
		return (0);
	} else {
		if (velocity[x])
			play_sample ((SAMPLE *) global->SOUND[10].dat, (int)((velocity[x] / 10) * 255), (int)((double)(x - global->halfWidth) / global->halfWidth * 128 + 128), 1000 - (int)((double)fp[x] / global->screenHeight) * 1000, 0);
		h[x] = 0;
		fp[x] = 0;
		done[x] = 1;
		velocity[x] = 0;
		dropIncr[x] = 0;
		dropTo[x] = global->screenHeight - 1;
		return (1);
	}
	return (0);
}


int drawFracture (GLOBALDATA *global, ENVIRONMENT *env, BITMAP *dest, BOX *updateArea, int x, int y, int angle, int width, int segmentLength, int maxRecurse, int recurseDepth)
{
	int branchCount;
	int x1, x2, x3;
	int y1, y2, y3;

	x1 = (int)(x + global->slope[angle][0] * width);
	y1 = (int)(y + global->slope[angle][1] * width);
	x2 = (int)(x - global->slope[angle][0] * width);
	y2 = (int)(y - global->slope[angle][1] * width);
	x3 = (int)(x + global->slope[angle][1] * segmentLength);
	y3 = (int)(y + global->slope[angle][0] * segmentLength);
	triangle (dest, x1, y1, x2, y2, x3, y3, PINK);

	if (recurseDepth == 0) {
		updateArea->x = x1;
		updateArea->y = y1;
		updateArea->w = x1;
		updateArea->h = y1;
	}
	updateArea->x = MIN (MIN (MIN (x1, x2), x3), updateArea->x);
	updateArea->y = MIN (MIN (MIN (y1, y2), y3), updateArea->y);
	updateArea->w = MAX (MAX (MAX (x1, x2), x3), updateArea->w);
	updateArea->h = MAX (MAX (MAX (y1, y2), y3), updateArea->h);

	if (recurseDepth < maxRecurse)
	{
		for (branchCount = 0; branchCount < 3; branchCount++)
		{
			if ((branchCount == 0) || (Noise (x + y + branchCount) < 0))
			{
				int newAngle, reduction;
				newAngle = (angle + (int)(Noise (x + y + 4) * 30));
				while (newAngle < 0)
					newAngle += 360;
				newAngle %= 360;

				reduction = 2;
				if (branchCount == 1) {
					newAngle = (int)(angle + 90 +
						(Noise (x + y + 25 + branchCount) * 22.5)) % 360;
					reduction = abs ((int)Noise (x + y + 1 + branchCount) * 4 + 3);
				} else if (branchCount == 2) {
					newAngle = (int)(angle + 270 +
						(Noise (x + y + 32 + branchCount) * 22.5)) % 360;
					reduction = abs ((int)Noise (x + y + 2 + branchCount) * 4 + 3);
				}
				drawFracture (global, env, dest, updateArea, x3, y3, newAngle, width / reduction, segmentLength / reduction, maxRecurse, recurseDepth + 1);
			}
		}
	}

	// Calculate width and height, previously right and bottom
	if (recurseDepth == 0) {
		updateArea->w -= updateArea->x;
		updateArea->h -= updateArea->y;
	}

	return (0);
}

void initSurface (GLOBALDATA *global, ENVIRONMENT *env)
{
	int pixelHeight;
	for (int x = 0; x < global->screenWidth; x++) {
		for (pixelHeight = 0; pixelHeight < global->screenHeight; pixelHeight++)
			if (getpixel (env->terrain, x, pixelHeight) != PINK)
				break;
		env->surface[x] = pixelHeight;
	}
}

int slideLand (GLOBALDATA *global, ENVIRONMENT *env)
{
	char	*done	= env->done;
	int	*dropTo = env->dropTo;
	int	*h	= env->h;
	int	*fp	= env->fp;
	double	*velocity = env->velocity;
	double	*dropIncr = env->dropIncr;
	int zz;

	// land-slide, make it fall etc.
	int allDone = 1;
	if (env->landSlideType == LANDSLIDE_NONE)
		return (allDone);

	for (zz = 0; zz < global->screenWidth; zz++) {
		if (!done[zz]) {
			allDone = 0;
			if (env->landSlideType == LANDSLIDE_GRAVITY) {
				if (fp[zz] > 0) {
					velocity[zz] += env->gravity;
					dropIncr[zz] += velocity[zz];
					if (dropIncr[zz] >= 1) {
						if (dropIncr[zz] > dropTo[zz] - (h[zz] + fp[zz])) {
							dropIncr[zz] = dropTo[zz] - (h[zz] + fp[zz]) + 1;
						}
						blit (env->terrain, env->terrain, zz, h[zz] - (int)dropIncr[zz], zz, h[zz], 1, fp[zz] + (int)dropIncr[zz]);
						env->make_bgupdate (zz, h[zz] - (int)dropIncr[zz], 1, fp[zz] + ((int)dropIncr[zz] * 2) + 1);
						env->make_update (zz, h[zz] - (int)dropIncr[zz], 1, fp[zz] + ((int)dropIncr[zz] * 2) + 1);
						h[zz] += (int)dropIncr[zz];
						dropIncr[zz] -= (int)dropIncr[zz];
					}
					setSlideColumnDimensions (global, env, zz, FALSE);
				} else {
					setSlideColumnDimensions (global, env, zz, FALSE);
				}
			} else if (env->landSlideType == LANDSLIDE_INSTANT) {
				if (fp[zz] > 0) {
					env->make_bgupdate (zz, h[zz], 1, dropTo[zz] - h[zz] + 1);
					env->make_update (zz, h[zz], 1, dropTo[zz] - h[zz] + 1);
					done[zz] = 1;
					blit (env->terrain, env->terrain, zz, h[zz], zz, dropTo[zz] - fp[zz] + 1, 1, fp[zz]);
					vline (env->terrain, zz, h[zz], dropTo[zz] - fp[zz], PINK);
				}
				setSlideColumnDimensions (global, env, zz, FALSE);
			}
		}
	}

	return (allDone);
}

void drawTopBar (GLOBALDATA *global, ENVIRONMENT *env, BITMAP *dest)
{
	TANK *tank = global->currTank;
	char *name = "";
	int color = 0;
	int wind_col1 = 0, wind_col2 = 0;
        static int change_weapon_colour = RED;

	if (tank) {
		name = global->currTank->player->getName ();
		color = global->currTank->player->color;
	}

	global->updateMenu = 0;
	blit (global->gfxData.topbar, dest, 0, 0, 0, 0, global->screenWidth, MENU);

	if (tank) {
		textout_ex (dest, font, name, 2, 2, BLACK, -1);
		textout_ex (dest, font, name, 1, 1, color, -1);
		textprintf_ex (dest, font, 1, 11, BLACK, -1, "Angle:");
		graph_bar_center (env, 50, 11, color, -(tank->a - 180) / 2, 180 / 2);
		// 0 is directly left, 180 points directly right
		textprintf_ex (dest, font, 150, 11, BLACK, -1, "%d", 180 - (tank->a - 90));

		textprintf_ex (dest, font, 1, 21, BLACK, -1, "Power:");
		graph_bar (env, 50, 20, color, (tank->p) / (MAX_POWER/90), 90);
		textprintf_ex (dest, font, 150, 21, BLACK, -1, "%d", tank->p);
		if (tank->cw < WEAPONS) {
                     if (tank->player->changed_weapon)
                     {
                        textprintf_ex (dest, font, 100, 1, change_weapon_colour, -1, "%s: %d",
                                   weapon[tank->cw].name, tank->player->nm[tank->cw]);
                        if (change_weapon_colour == RED)
                            change_weapon_colour = WHITE;
                        else
                            change_weapon_colour = RED;
                     }
                    
                     else
			textprintf_ex (dest, font, 100, 1, BLACK, -1, "%s: %d",
				    weapon[tank->cw].name, tank->player->nm[tank->cw]);

//			textprintf (dest, font, 150, 11, BLACK, "Radius: %d", weapon[tank->cw].radius);
//			textprintf (dest, font, 150, 21, BLACK, "Damage: %d", weapon[tank->cw].damage);
		} else {
			textprintf_ex (dest, font, 100, 1, BLACK, -1, "%s: %d",
				    item[tank->cw - WEAPONS].name, tank->player->ni[tank->cw - WEAPONS]);
		}
		textprintf_ex (dest, font, 350, 1, BLACK, -1, "$%ld", tank->player->money);
/*		if (tank->sh > 0 || tank->fs) {
			sprintf (buf, item[tank->sht].name);
			strcat (buf, ": %d");
			textprintf (dest, font, 350, 11, BLACK, buf, tank->player->ni[tank->sht]);
			textprintf (dest, font, 350, 11, BLACK, "Shield: %d", tank->sh);
		} else {
			textout (dest, font, "No Shield", 350, 11, BLACK);
		}*/
	}

	textprintf_ex (dest, font, 500, 1, BLACK, -1, "Round %d/%d", (int)(global->rounds - global->currentround) + 1, (int)global->rounds);
	if (env->windstrength > 0) {
		textprintf_ex (dest, font, 500, 11, BLACK, -1, "Wind: ");
		if (env->wind > 0) {
			wind_col1 = 1;
			wind_col2 = 0;
		}
		if (env->wind < 0) {
			wind_col1 = 0;
			wind_col2 = 1;
		}
		rect (dest, 540, 12, (int)(540 + env->windstrength * 4 + 2), 18, BLACK);
		rectfill (dest, (int)(541 + env->windstrength * 2), 13,
		  (int) (541 + env->wind * 4 + env->windstrength * 2), 17,
		  makecol (200 * wind_col1, 200 * wind_col2, 0));
	}
	global->stopwindow = 1;
	env->make_update (0, 0, global->screenWidth, MENU);
	global->stopwindow = 0;
}

/*
 *  Calculate the effective damage for a given weapon.
 *  Recursively add the damage of sub-munitions, factor in chaos
 *    and munition density.
 */
long int calcTotalEffectiveDamage (int weapNum)
{
	WEAPON *weap = &weapon[weapNum];
	long int total = 0;

	if (weap->submunition >= 0) {
		WEAPON *subm = &weapon[weap->submunition];

		// How chaotic is this weapon?
		double chaosVal=(weap->spreadVariation +
				 weap->speedVariation +
				 subm->countVariation) / 3;
		double coverage = (weap->numSubmunitions *
					subm->radius) /
					(double)weap->radius;

		total += calcTotalEffectiveDamage (weap->submunition) *
						weap->numSubmunitions;
		total = (long int)(total * coverage / weap->numSubmunitions);
		total -= (long int)((total / 2) * (1.0 - chaosVal));
	} else {
		total += weap->damage;
	}

	return (total);
}

/*
 *  Calculate the potential damage for a given weapon.
 *  Recursively add the damage of sub-munitions.
 */
long int calcTotalPotentialDamage (int weapNum)
{
	WEAPON *weap = &weapon[weapNum];
	long int total = 0;

	if (weap->submunition >= 0)
		total += calcTotalPotentialDamage (weap->submunition) *
						weap->numSubmunitions;
	else
		total += weap->damage;

	return (total);
}

void doNaturals (GLOBALDATA *global, ENVIRONMENT *env)
{
	if (env->meteors) {
		int chance = (int)(600 / env->meteors) + 100;
		if (!(rand () % chance)) {
			MISSILE *newmis;
			int ca = ((rand () % 160) + (360 - 80)) % 360;
			double mxv = global->slope[ca][0] * 5;
			double myv = global->slope[ca][1] * 5;

			newmis = new MISSILE(global, env,
				rand () % global->screenWidth, 0,
				mxv, myv, SML_METEOR + (rand () % (int)env->meteors));
			if (!newmis) {
				perror ("atanks.cc: Failed allocating memory for newmis in doNaturals");
				exit (1);
			}
			newmis->player = NULL;
		}
	}
	if (env->lightning) {
		int chance = (int)(600 / env->lightning) + 100;
		if (!(rand () % chance)) {
			BEAM *newbeam;
			int ca = ((rand () % 160) + (360 - 80)) % 360;
			//double mxv = global->slope[ca][0] * 400;
			//double myv = global->slope[ca][1] * 400;

			newbeam = new BEAM (global, env,
				rand () % global->screenWidth, 0,
				ca, SML_LIGHTNING + (rand () % (int)env->lightning));
			if (!newbeam) {
				perror ("atanks.cc: Failed allocating memory for newbeam in doNaturals");
				exit (1);
			}
			newbeam->player = NULL;
		}
	}
}

void game (GLOBALDATA *global, ENVIRONMENT *env)
{
	int tanksfall;
	int tanklife, tlt, dclock;
	int lb, ca;
	int allDone, anyExploding;
	int roundEndCount = 0;
	int nextTankSelected = FALSE;
	int humanPlayers = 0;
	int skippingComputerPlay = FALSE;

	TANK **tank, *ltank;
	MISSILE *missile;
	TELEPORT *teleport;
	DECOR *decor;
	BEAM *beam;
	EXPLOSION *explosion;
	FLOATTEXT *floattext;

	int bCount;
	int z, zz, z4;

	int objCount, count;

	global->computerPlayersOnly = FALSE;

	tank = &global->currTank;
		
	for (int doneCount = 0; doneCount < global->screenWidth; doneCount++)
		env->done[doneCount] = 0;
	initSurface (global, env); // init surface[]

	env->newRound ();

	for (count  = 0; count < global->numPlayers; count++)
		global->players[count]->newRound ();

	buystuff (global, env);

	for (count  = 0; count < global->numPlayers; count++)
		global->players[count]->exitShop ();

	set_level_settings (global, env);
	for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; objCount++) {
		ltank->newRound ();
		if ((int)ltank->player->type == HUMAN_PLAYER) {
			humanPlayers++;
		}
	}
	if (!humanPlayers) {
		global->computerPlayersOnly = TRUE;
		//if ((int)global->skipComputerPlay >= SKIP_AUTOPLAY)
		//	skippingComputerPlay = TRUE;
	}
	cclock = lx = ly = env->stage = tanksfall = 0;
	tlt = global->updateCount = dclock = global->stopwindow = 0;
	env->realm = env->am = 0;
	ca = 0;
	lb = env->mouseclock = env->pclock = 0;
	ord = 0;

	*tank = env->order[0];
	for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; objCount++) {
		ltank->flashdamage = 0;
		ltank->boost_up_shield ();
	}
	winner = tanklife = -1;
	fi = global->updateMenu = 1;
	global->window.x = 0;
	global->window.y = 0;
	global->window.w = (global->screenWidth-1);
	global->window.h = (global->screenHeight-1);
	bCount = 0;
	if ((int)env->windstrength != 0)
		env->wind = (float)(rand () % (int)env->windstrength) - (env->windstrength / 2);
	else
		env->wind = 0;
	env->lastwind = env->wind;
	while (1) {
        LINUX_SLEEP;
		while (cclock > 0 || skippingComputerPlay) {
			cclock--;
			if (!lb && mouse_b & 1)
				env->mouseclock = 0;
			lb = (mouse_b & 1) ? 1 : 0;
			bCount += 360/32;
			z4 = 0;
			nextTankSelected = FALSE;
			anyExploding = 0;
			for (objCount = 0; (explosion = (EXPLOSION*)env->getNextOfClass (EXPLOSION_CLASS, &objCount)) && explosion; objCount++) {
				anyExploding++;
				explosion->explode ();
				explosion->applyPhysics ();
				if (explosion->destroy) {
					explosion->requireUpdate ();
					explosion->update ();
					delete explosion;
				}
			}
			for (objCount = 0; (teleport = (TELEPORT*)env->getNextOfClass (TELEPORT_CLASS, &objCount)) && teleport; objCount++) {
				teleport->applyPhysics ();
				if (teleport->destroy) {
					teleport->requireUpdate ();
					teleport->update ();
					delete teleport;
				}
			}
			for (objCount = 0; (decor = (DECOR*)env->getNextOfClass (DECOR_CLASS, &objCount)) && decor; objCount++) {
				decor->applyPhysics ();
				if (decor->destroy) {
					decor->requireUpdate ();
					decor->update ();
					delete decor;
				}
			}
			env->am = 0;
			for (objCount = 0; (missile = (MISSILE*)env->getNextOfClass (MISSILE_CLASS, &objCount)) && missile; objCount++) {
				env->am++;
				missile->hitSomething = 0;
				missile->applyPhysics ();
				missile->triggerTest ();
				if (missile->destroy) {
					missile->requireUpdate ();
					missile->update ();
					delete missile;
					tanksfall = 1;
				}
			}
			for (objCount = 0; (beam = (BEAM*)env->getNextOfClass (BEAM_CLASS, &objCount)) && beam; objCount++) {
				beam->applyPhysics ();
				if (beam->destroy) {
					beam->requireUpdate ();
					beam->update ();
					delete beam;
					tanksfall = 1;
				}
			}
			for (objCount = 0; (floattext = (FLOATTEXT*)env->getNextOfClass (FLOATTEXT_CLASS, &objCount)) && floattext; objCount++) {
				floattext->applyPhysics ();
				if (floattext->destroy) {
					floattext->requireUpdate ();
					floattext->update ();
					delete floattext;
				}
			}
			if (!anyExploding)
				doNaturals (global, env);
			allDone = slideLand (global, env);
			if (tanksfall && env->stage != 3) {
				for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; count--, objCount++) {
					ltank->pen = 0;
					ltank->applyPhysics (global);
					if (ltank->l <= 0 && !anyExploding) {
						ltank->explode ();
						if (ltank->creditTo) {
							if (ltank->player != ltank->creditTo) {	//enemy destroyed
								ltank->creditTo->money += (unsigned long int)global->scoreUnitDestroyBonus;
							} else {	//self destroy - ugh foolish one :))
								ltank->creditTo->money -= (unsigned long int)global->scoreUnitSelfDestroy;
							}
							ltank->creditTo = NULL;
						}
						if (ltank->destroy) {
							if ((int)ltank->player->type == HUMAN_PLAYER) {
								humanPlayers--;
								if (((int)global->skipComputerPlay > SKIP_NONE) && (!humanPlayers) && (!global->computerPlayersOnly)) {
									skippingComputerPlay = TRUE;
									draw_sprite (env->db, (BITMAP *) global->gfxData.M[1].dat, global->halfWidth - 120, global->halfHeight + 155);
									textout_centre_ex (env->db, font, "Accelerated AI", global->halfWidth, global->halfHeight + 160, WHITE, -1);
									draw_sprite (screen, (BITMAP *) global->gfxData.M[1].dat, global->halfWidth - 120, global->halfHeight + 155);
									textout_centre_ex (screen, font, "Accelerated AI", global->halfWidth, global->halfHeight + 160, WHITE, -1);
								}
							}
							delete ltank;
							if (!*tank) {
								*tank = nextturn (global, env);
								if (*tank)
									(*tank)->fs = 0;
								nextTankSelected = TRUE;
							}
							if (global->numTanks <= 1) {
								skippingComputerPlay = FALSE;
								cclock = 0;
								env->stage = 3;
								global->currTank = NULL;
								fi = 1;
								global->window.x = 0;
								global->window.y = 0;
								global->window.w = (global->screenWidth-1);
								global->window.h = (global->screenHeight-1);
								winner = -2;
								if (global->numTanks > 0) {
									for (z = 0; z < global->numPlayers; z++) {
										if (global->players[z]->tank)
											winner = z;
									}
								}
								if (winner >= 0) {
									global->players[winner]->score++;
									global->players[winner]->won++;
									global->players[winner]->money += (unsigned long int)global->scoreRoundWinBonus;
								}
								bCount = 0;
								global->updateMenu = 1;
								for (z = 0; z < global->numPlayers; z++)
									global->players[z]->played++;
							}
						}
					}
				}
			}
			if (env->stage == 1) {
				if ((env->am == 0) && allDone && !anyExploding) {
					tanksfall = 0;
					env->stage = 2;
				}
			}
			if (env->stage == 2) {
				zz = 0;

				for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; count--, objCount++) {
					zz += ltank->applyPhysics (global);
				}
				if (zz ==  global->numTanks) {
					tanksfall = 1;
				}
				zz = 0;
				if (tanksfall) {
					for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; objCount++) {
						ltank->pen = 0;
						if (ltank->l > 0)
							zz++;
					}
				}
				if (zz == global->numTanks) {
					env->stage = 0;
					winner = -2;
					for (z = 0; z < global->numPlayers; z++) {
						if (global->players[z]->tank && winner >= 0)
							winner = -1;
						if (global->players[z]->tank && winner == -2)
							winner = z;
					}
					if (winner >= 0) {
						global->players[winner]->score++;
					}
					if (winner == -1) {
						if (!nextTankSelected) {
							*tank = nextturn (global, env);
							(*tank)->fs = 0;
						}
					}
					if (winner >= 0 || winner == -2) {
						env->stage = 3;
						global->currTank = NULL;
						fi = 1;
						global->window.x = 0;
						global->window.y = 0;
						global->window.w = (global->screenWidth-1);
						global->window.h = (global->screenHeight-1);
					}
					bCount = 0;
					global->updateMenu = 1;
				}
			}
			dclock++;
			if (dclock > 2) {
				dclock = 0;
				for (objCount = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; objCount++) {
					if (ltank->flashdamage) {
						if (ltank->flashdamage > 25 || ltank->l < 1) {
							ltank->damage = 0;
							ltank->flashdamage = 0;
							ltank->requireUpdate ();
						}
					}
				}
			}
			env->pclock++;
			if (env->pclock > 10)
				env->pclock = 0;
			if (*tank) {
				if ((*tank)->player->controlTank (*tank) == -1)
					return;
			} else if (global->computerPlayersOnly &&
				((int)global->skipComputerPlay >= SKIP_AUTOPLAY)) {
				if (env->stage == 3)
					return;
			} else if ((keypressed () || mouse_b) && !fi) {
				if (keypressed ())
					k = readkey ();
				else
					k = 0;
				if ((env->stage == 3) && (mouse_b || k >> 8 == KEY_ENTER || k >> 8 == KEY_ESC || k >> 8 == KEY_SPACE))
					return;
			}
			env->mouseclock++;
			if (env->mouseclock > 10)
				env->mouseclock = 0;
		}
		frames++;
		global->stopwindow = 1;
		env->make_update (mouse_x, mouse_y, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		env->make_update (lx, ly, ((BITMAP *) (global->gfxData.M[0].dat))->w, ((BITMAP *) (global->gfxData.M[0].dat))->h);
		global->stopwindow = 0;
		lx = mouse_x;
		ly = mouse_y;
		set_clip_rect (env->db, 0, 0, (global->screenWidth-1), (global->screenHeight-1));
		show_mouse (NULL);
		if (global->updateMenu) {
			drawTopBar (global, env, env->db);
		}
		set_clip_rect (env->db, 0, MENU, (global->screenWidth-1), (global->screenHeight-1));
		if (fi) {
			blit (env->sky, env->db, global->window.x, global->window.y - MENU, global->window.x, global->window.y, (global->window.w - global->window.x) + 1, (global->window.h - global->window.y) + 1);
			masked_blit (env->terrain, env->db, global->window.x, global->window.y, global->window.x, global->window.y, (global->window.w - global->window.x) + 1, (global->window.h - global->window.y) + 2);
		} else {
			env->replaceCanvas ();
		}

		for (objCount = 0, count = 0; (ltank = (TANK*)env->getNextOfClass (TANK_CLASS, &objCount)) && ltank; count++, objCount++) {
			if (env->stage < 3) {
				if (*tank == ltank) {
					ltank->draw (env->db, (int)(global->slope[bCount % 360][0] * 4));
					ltank->requireUpdate ();
				} else {
					ltank->draw (env->db, 0);
				}
				ltank->update ();
			}
			ltank->framelyAccounting ();
		}
		for (objCount = 0; (missile = (MISSILE*)env->getNextOfClass (MISSILE_CLASS, &objCount)) && missile; objCount++) {
			missile->draw (env->db);
			missile->update ();
		}
		for (objCount = 0; (beam = (BEAM*)env->getNextOfClass (BEAM_CLASS, &objCount)) && beam; objCount++) {
			beam->draw (env->db);
			beam->update ();
		}
		for (objCount = 0; (explosion = (EXPLOSION*)env->getNextOfClass (EXPLOSION_CLASS, &objCount)) && explosion; objCount++) {
			explosion->draw (env->db);
			explosion->update ();
		}
		for (objCount = 0; (teleport = (TELEPORT*)env->getNextOfClass (TELEPORT_CLASS, &objCount)) && teleport; objCount++) {
			if (teleport->object)
				teleport->draw (env->db);
			teleport->update ();
		}
		for (objCount = 0; (decor = (DECOR*)env->getNextOfClass (DECOR_CLASS, &objCount)) && decor; objCount++) {
			decor->draw (env->db);
			decor->update ();
		}
		for (objCount = 0; (floattext = (FLOATTEXT*)env->getNextOfClass (FLOATTEXT_CLASS, &objCount)) && floattext; objCount++) {
			floattext->draw (env->db);
			floattext->requireUpdate ();
			floattext->update ();
		}
		if (env->stage == 3) {
			roundEndCount++;
			if (roundEndCount > 60)
				showRoundEndScoresAt (global, env, env->db, global->screenWidth/2, global->screenHeight/2, winner);
		}
		set_clip_rect (env->db, 0, 0, (global->screenWidth-1), (global->screenHeight-1));
		show_mouse (env->db);
		if (fi) {
			while (keypressed ()) {
				readkey ();
			}
			fi = 0;
			if (env->fog) {
				clear_to_color (screen, makecol (128,128,128));
			} else {
				quickChange (global, env->db);
			}
		} else {
			env->do_updates ();
			global->window.x = global->screenWidth;
			global->window.y = global->screenHeight;
			global->window.w = -1;
			global->window.h = -1;
		}
	}
}

void print_text_help()
{
	cout	<< "-h\tThis screen\n"
		<< "-fs\tFull screen\n"
		<< "--windowed\tRun in a window\n"
		<< "-w <width> or --width <width>\tSpecify the screen width in pixels\n"
		<< "-t <height> --tall <height>\tSpecify the screen height in pixels\n"
		<< "\tAdjust the screen size at your own risk (default is 800x600)\n"
		<< "-d <depth> or --depth <depth>\tCurrently either 16 or 32\n"
                << "--datadir <data directory>\t Path to the data directory\n"
		<< "--nosound\t Disable sound\n";
}

void print_text_initmsg()
{
	printf ("Atomic Tanks Version %s (-h for help)\n", VERSION);
	printf ("Authors: \tTom Hudson (rewrite, additions, improvements)\n");
	printf ("\t\tStevante Software (original design)\n");
	printf ("\t\tKota543 Software (fixes and updates)\n");
        printf ("\t\tJesse (fixes and updates)\n");
	putchar ('\n');
}

void endgame_cleanup (GLOBALDATA *global, ENVIRONMENT *env)
{
	while (global->numPlayers > 0) {
		if (global->players[0]->tank)
			delete global->players[0]->tank;
		global->players[0]->tank = NULL;
		global->removePlayer (global->players[0]);
	}
	for (int objCount = 0; objCount < MAX_OBJECTS; objCount++) {
		if (env->objects[objCount]) {
			delete env->objects[objCount];
			env->objects[objCount] = NULL;
		}
	}
}

int main (int argc, char **argv)
{
	int signal;
	//int stop = 0;
	string tmp;
	ENVIRONMENT *env;
	GLOBALDATA *global;
	FILE *configFile;
	char *homeDir;
	char fullPath[2048];
	cmdTokens nextToken = ARGV_NOTHING_EXPECTED;

	global = new GLOBALDATA ();
	if (!global) {
		perror ("Allocating global");
		exit (1);
	}

	print_text_initmsg();
	
	if(argc >= 2) {		/* Parse command-line switches */
		for (int argument = 1; argument < argc; argument++) {
			tmp = argv[argument];
		
			if (nextToken == ARGV_GFX_DEPTH) {
				global->colourDepth = strtol (tmp.c_str(), NULL, 10);
				if (global->colourDepth != 16 &&
				    global->colourDepth != 32) {
					cout << "Invalid graphics depth, only 16 or 32 are valid\n";
					print_text_help();
					return 0;
				}
				nextToken = ARGV_NOTHING_EXPECTED;
			} else if (nextToken == ARGV_SCREEN_WIDTH) {
				global->screenWidth = strtol (tmp.c_str(), NULL, 10);
				if (global->screenWidth < 512) {
					cout << "Width too small (minimum 512)\n";
					return 0;
				}
				global->halfWidth = global->screenWidth / 2;
				nextToken = ARGV_NOTHING_EXPECTED;
			} else if (nextToken == ARGV_SCREEN_HEIGHT) {
				global->screenHeight = strtol (tmp.c_str(), NULL, 10);
				if (global->screenHeight < 320) {
					cout << "Height too small (minimum 320)\n";
					return 0;
				}
				global->halfHeight = global->screenHeight / 2;
				nextToken = ARGV_NOTHING_EXPECTED;
			} else if (nextToken == ARGV_DATA_DIR) {
				// Would use strndup, but the win compiler
				//   doesn't know of it.
				if (strlen (tmp.c_str()) > 2048) {
					cout << "Datadir path too long:\n"
						<< "\"" << tmp
						<< "\"\n\n"
						<< "Maximum length 2048 characters\n";
					return 0;
				}
				global->dataDir = strdup (tmp.c_str());
				nextToken = ARGV_NOTHING_EXPECTED;
			} else if (tmp == SWITCH_HELP) {
				print_text_help();
				return 0;
			} if (tmp == SWITCH_FULL_SCREEN) {
				screen_mode = GFX_AUTODETECT_FULLSCREEN;
			} else if (tmp == SWITCH_WINDOWED) {
				screen_mode = GFX_AUTODETECT_WINDOWED;
			} else if (tmp == "-d" || tmp == "--depth") {
				nextToken = ARGV_GFX_DEPTH;
			} else if (tmp == "-w" || tmp == "--width") {
				nextToken = ARGV_SCREEN_WIDTH;
			} else if (tmp == "-t" || tmp == "--tall") {
				nextToken = ARGV_SCREEN_HEIGHT;
			} else if (tmp == "--datadir") {
				nextToken = ARGV_DATA_DIR;
			} else if (tmp == "--nosound") {
                                nextToken = ARGV_NOTHING_EXPECTED;
                                global->sound = FALSE;
                        }
                      
		}
		if (nextToken != ARGV_NOTHING_EXPECTED) {
			cout << "Expecting an argument to follow " << tmp << endl;
			return 0;
		}
	}
	
	env = init_game_settings (global);

	homeDir = getenv ("HOME");
	if (homeDir) {
		memset (fullPath, '\0', sizeof (fullPath));
		snprintf (fullPath, sizeof (fullPath) - 1, "%s/%s",
				homeDir, ".atanks-config");
	} else {
		sprintf (fullPath, "%s", ".atanks-config");
	}
	
	configFile = fopen (fullPath, "rb");
	if (configFile) {
		int key;
		fread (&key, sizeof (int), 1, configFile);
		if (key == GFILE_KEY) {
			global->loadFromFile (configFile);
			env->loadFromFile (configFile);
			if (loadPlayers (global, env, configFile)) {
				fclose (configFile);
				perror ("loadPlayers");
				exit (1);
			}
			fclose (configFile);
		} else {
			fprintf (stderr, "Invalid or corrupt config file \"%s\"\n", fullPath);
			fclose (configFile);
			exit (1);
		}
	} else {
		char *defaultNames[] = {
			"Bri",
			"Sar",
			"Bill",
			"Rog",
			"TY",
			"Wembly",
			"Kat",
			"Snork",
			"Kel",
			"MRK"
		};
		PLAYER *tempPlayer;

		tempPlayer = global->createNewPlayer (env);
		tempPlayer->setName ("Your Name");
		options (global, env, (MENUDESC*)tempPlayer->menudesc);
		for (int count = 0; count < 10; count++) {
			tempPlayer = global->createNewPlayer (env);
			tempPlayer->type = rand () % (LAST_PLAYER_TYPE - 1) + 1;
			tempPlayer->setName (defaultNames[count]);
		}
	}

	title (global);

    do
    {
        //show the main menu
		global->command = GLOBAL_COMMAND_MENU;
		signal = menu (global, env);

        // did the user signal to quit the game		
		if(signal == SIG_QUIT_GAME) global->command = GLOBAL_COMMAND_QUIT;
		
        //determine which menu item is selected
		switch(global->command)
		{
		  case GLOBAL_COMMAND_HELP:
		    instructions(global, env);
		    break;
          case GLOBAL_COMMAND_OPTIONS:
            options(global, env, NULL);
            break;
          case GLOBAL_COMMAND_PLAYERS:
            //loop until done editing players where return value is not ESC
            while( (editPlayers(global, env))>>8 != KEY_ESC);
            break;
          case GLOBAL_COMMAND_CREDITS:
            credits(global, env);
            break;
          case GLOBAL_COMMAND_QUIT:
            break;
          default: //must have commanded to play game
			if (selectPlayers (global, env) >> 8 == KEY_ESC)
              break;
            else //selected players
            {
			newgame (global, env); 

              //play the game for the selected number of rounds
			  for (global->currentround = (int)global->rounds; global->currentround > 0; global->currentround--)
			  {
				game (global, env);
				
				//if user selected to quit or return to main menu during game play
				if((global->command == GLOBAL_COMMAND_QUIT) || (global->command == GLOBAL_COMMAND_MENU))
                  break;
			}

              //only show winner if finished all rounds
			  if (global->currentround == 0)
				do_winner (global, env);

			endgame_cleanup (global, env);
		}
            break;
		}
	} while (global->command != GLOBAL_COMMAND_QUIT);

	configFile = fopen (fullPath, "wb");
	if (configFile) {
		int key = GFILE_KEY;

		fwrite (&key, sizeof (int), 1, configFile);
		global->saveToFile (configFile);
		env->saveToFile (configFile);
		if (savePlayers (global, env, configFile)) {
			fclose (configFile);
			perror ("savePlayers");
			exit (1);
		}
		fclose (configFile);
	} else {
		perror ("Saving Config");
		exit (1);
	}
	
	allegro_exit ();

	cout<<"See http://atanks.sourceforge.net for the latest news and downloads"<<endl;
	
	return 0;
}


END_OF_MAIN ();
