/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "player.h"
#include "globaldata.h"

GLOBALDATA::GLOBALDATA ()
{
	initialise ();
        sound = TRUE;
	colourDepth = 16;
	screenWidth = 800;
	screenHeight = 600;
	halfWidth = screenWidth / 2;
	halfHeight = screenHeight / 2;
	cacheCirclesBG = 1;
	ditherGradients = 1;
	detailedLandscape = 0;
	detailedSky = 0;
	startmoney = 15000;
	turntype = TURN_RANDOM;
	skipComputerPlay = SKIP_HUMANS_DEAD;
	dataDir = DATA_DIR;

	interest = 1.25;
	scoreHitUnit = 75;
	scoreSelfHit = 0;
	scoreUnitDestroyBonus = 5000;
	scoreUnitSelfDestroy = 0;
	scoreRoundWinBonus = 10000;
	sellpercent = 0.80;

	updates = new BOX[MAXUPDATES];
	if (!updates) {
		perror ("globaldata.cc: Failed allocating memory for updates in GLOBALDATA::GLOBALDATA");
		exit (1);
	}
	lastUpdates = new BOX[MAXUPDATES];
	if (!lastUpdates) {
		perror ("globaldata.cc: Failed allocating memory for lastUpdates in GLOBALDATA::GLOBALDATA");
		exit (1);
	}
	updateCount = 0;
	lastUpdatesCount = 0;

	players = new PLAYER*[MAXPLAYERS];
	if (!players) {
		perror ("globaldata.cc: Failed allocating memory for players in GLOBALDATA::GLOBALDATA");
		exit (1);
	}
	numPlayers = 0;
	rounds = 5;

	allPlayers = (PLAYER**)malloc (sizeof (PLAYER*));
	if (!allPlayers) {
		fprintf (stderr, "Failed allocating memory for players in globaldata.cc\n");
		exit (1);
	}

	for (int count = 0; count < 360; count++) {
		slope[count][0] = sin (count / (180 / PI));
		slope[count][1] = cos (count / (180 / PI));
	}
	slope[270][1] = 0;
}

// Following are config file definitions
#define	GFILE_LATEST_VERSION	4

#define GFILE_NUMPLAYERS	&numPlayers, sizeof (int), 1, file
#define	GFILE_OLDROUNDS		&rounds, sizeof (int), 1, file
#define	GFILE_ROUNDS		&rounds, sizeof (double), 1, file
#define	GFILE_DITHER		&ditherGradients, sizeof (double), 1, file
#define	GFILE_DETAILEDSKY	&detailedSky, sizeof (double), 1, file
#define	GFILE_DETAILEDLAND	&detailedLandscape, sizeof (double), 1, file
#define	GFILE_STARTMONEY	&startmoney, sizeof (double), 1, file
#define	GFILE_TURNTYPE		&turntype, sizeof (double), 1, file
#define	GFILE_INTEREST		&interest, sizeof (double), 1, file
#define	GFILE_SCOREROUNDWINBONUS	&scoreRoundWinBonus, sizeof (double), 1, file
#define	GFILE_SCOREHITUNIT		&scoreHitUnit, sizeof (double), 1, file
#define	GFILE_SCORESELFHIT		&scoreSelfHit, sizeof (double), 1, file
#define	GFILE_SCOREUNITDESTROYBONUS	&scoreUnitDestroyBonus, sizeof (double), 1, file
#define	GFILE_SCOREUNITSELFDESTROY	&scoreUnitSelfDestroy, sizeof (double), 1, file
#define	GFILE_ACCELERATEDAI	&skipComputerPlay, sizeof (double), 1, file
#define GFILE_SELLPERCENT	&sellpercent, sizeof(double), 1, file

#define	GFILE_VERSION_1(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_OLDROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);

#define	GFILE_VERSION_2(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_ROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);\
				a (GFILE_SCOREROUNDWINBONUS);\
				a (GFILE_SCOREHITUNIT);\
				a (GFILE_SCORESELFHIT);\
				a (GFILE_SCOREUNITDESTROYBONUS);\
				a (GFILE_SCOREUNITSELFDESTROY);

#define	GFILE_VERSION_3(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_ROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);\
				a (GFILE_SCOREROUNDWINBONUS);\
				a (GFILE_SCOREHITUNIT);\
				a (GFILE_SCORESELFHIT);\
				a (GFILE_SCOREUNITDESTROYBONUS);\
				a (GFILE_SCOREUNITSELFDESTROY);\
				a (GFILE_ACCELERATEDAI);

#define	GFILE_VERSION_4(a)	a (GFILE_NUMPLAYERS);\
				a (GFILE_ROUNDS);\
				a (GFILE_DITHER);\
				a (GFILE_DETAILEDSKY);\
				a (GFILE_DETAILEDLAND);\
				a (GFILE_STARTMONEY);\
				a (GFILE_TURNTYPE);\
				a (GFILE_INTEREST);\
				a (GFILE_SCOREROUNDWINBONUS);\
				a (GFILE_SCOREHITUNIT);\
				a (GFILE_SCORESELFHIT);\
				a (GFILE_SCOREUNITDESTROYBONUS);\
				a (GFILE_SCOREUNITSELFDESTROY);\
				a (GFILE_ACCELERATEDAI);\
				a (GFILE_SELLPERCENT);

#define	GFILE_WRITE_LATEST	GFILE_VERSION_4(fwrite)
#define	GFILE_READ_VERSION_1	GFILE_VERSION_1(fread)
#define	GFILE_READ_VERSION_2	GFILE_VERSION_2(fread)
#define	GFILE_READ_VERSION_3	GFILE_VERSION_3(fread)
#define	GFILE_READ_VERSION_4	GFILE_VERSION_4(fread)

int GLOBALDATA::saveToFile (FILE *file)
{
	int version = GFILE_LATEST_VERSION;
	if (!file)
		return (-1);

	fwrite (&version, sizeof (int), 1, file);

	GFILE_WRITE_LATEST

	return (ferror (file));
}

int GLOBALDATA::loadFromFile (FILE *file)
{
	int version;
	if (!file)
		return (-1);

	fread (&version, sizeof (int), 1, file);

	switch (version) {
		case 1:
			GFILE_READ_VERSION_1;
			break;
		case 2:
			GFILE_READ_VERSION_2;
			break;
		case 3:
			GFILE_READ_VERSION_3;
			break;
		case 4:
			GFILE_READ_VERSION_4;
			break;
		default:
			break;
	}

	return (ferror (file));
}

void GLOBALDATA::initialise ()
{
	numTanks = 0;
}

void GLOBALDATA::addPlayer (PLAYER *player)
{
	if (numPlayers < MAXPLAYERS) {
		players[numPlayers] = player;
		numPlayers++;
		if ((int)player->type == HUMAN_PLAYER) {
			numHumanPlayers++;
			computerPlayersOnly = FALSE;
		}
	}
}

void GLOBALDATA::removePlayer (PLAYER *player)
{
	int fromCount = 0;
	int toCount = 0;

	for (; fromCount < numPlayers; fromCount++) {
		if (player != players[fromCount]) {
			if ((int)player->type == HUMAN_PLAYER) {
				numHumanPlayers--;
				if (numHumanPlayers == 0) {
					computerPlayersOnly = TRUE;
				}
			}
			toCount++;
		}
		players[toCount] = players[fromCount];
	}
	numPlayers -= fromCount - toCount;
}

PLAYER *GLOBALDATA::getNextPlayer (int *playerCount)
{
	(*playerCount)++;
	if (*playerCount >= numPlayers)
		*playerCount = 0;
	return (players[*playerCount]);
}

PLAYER *GLOBALDATA::createNewPlayer (ENVIRONMENT *env)
{
	PLAYER **reallocatedPlayers;
	PLAYER *player;

	reallocatedPlayers = (PLAYER**)realloc (allPlayers, sizeof (PLAYER*) * (numPermanentPlayers + 1));
	if (reallocatedPlayers != NULL) {
		allPlayers = reallocatedPlayers;
	} else {
		perror ("atanks.cc: Failed allocating memory for reallocatedPlayers in GLOBALDATA::createNewPlayer");
		exit (1);
	}
	player = new PLAYER (this, env);
	if (!player) {
		perror ("globaldata.cc: Failed allocating memory for player in GLOBALDATA::createNewPlayer");
		exit (1);
	}
	allPlayers[numPermanentPlayers] = player;
	numPermanentPlayers++;

	return (player);
}

void GLOBALDATA::destroyPlayer (PLAYER *player)
{
	int fromCount = 0;
	int toCount = 0;

	for (; fromCount < numPermanentPlayers; fromCount++) {
		if (allPlayers[fromCount] != player) {
			allPlayers[toCount] = allPlayers[fromCount];
			toCount++;
		}
	}
	numPermanentPlayers--;
}
