/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "environment.h"
#include "globaldata.h"
#include "floattext.h"
#include "explosion.h"
#include "teleport.h"
#include "missile.h"
#include "player.h"
#include "beam.h"
#include "tank.h"

TANK::TANK ()
{
	_align = LEFT;
	_current.x = 0;
	_current.y = 0;
	_current.w = 0;
	_current.h = 0;
}

TANK::~TANK ()
{
	if (player->ni[ITEM_FATAL_FURY] > 0) {
		int numLaunch = (int)item[ITEM_FATAL_FURY].vals[SELFD_NUMBER];
		cw = (int)item[ITEM_FATAL_FURY].vals[SELFD_TYPE];
		player->ni[ITEM_FATAL_FURY]--;
		player->nm[cw] += numLaunch;
		for (int count = numLaunch; count > 0; count--) {
			a = rand () % 180 + 90;
			p = rand () % (MAX_POWER / 2);
			activateCurrentSelection ();
		}
	} else if (player->ni[ITEM_DYING_WRATH] > 0) {
		int numLaunch = (int)item[ITEM_DYING_WRATH].vals[SELFD_NUMBER];
		cw = (int)item[ITEM_DYING_WRATH].vals[SELFD_TYPE];
		player->ni[ITEM_DYING_WRATH]--;
		player->nm[cw] += numLaunch;
		for (int count = numLaunch; count > 0; count--) {
			a = rand () % 180 + 90;
			p = rand () % (MAX_POWER / 2);
			activateCurrentSelection ();
		}
	} else if (player->ni[ITEM_VENGEANCE] > 0) {
		int numLaunch = (int)item[ITEM_VENGEANCE].vals[SELFD_NUMBER];
		cw = (int)item[ITEM_VENGEANCE].vals[SELFD_TYPE];
		player->ni[ITEM_VENGEANCE]--;
		player->nm[cw] += numLaunch;
		for (int count = numLaunch; count > 0; count--) {
			a = rand () % 180 + 90;
			p = rand () % (MAX_POWER / 2);
			activateCurrentSelection ();
		}
	}
	player->tank = NULL;
	_global->numTanks--;
	if (_global->currTank == this)
		_global->currTank = NULL;
	_env->removeObject (this);
	delete shieldText;
	delete healthText;
}

TANK::TANK (GLOBALDATA *global, ENVIRONMENT *env)
{
	setEnvironment (env);
	player = NULL;
	healthText = new FLOATTEXT (global, env, "", 0, 0, WHITE, CENTRE);
	if (!healthText) {
		perror ("tank.cc: Failed allocating memory for healthText in TANK::TANK");
		exit (1);
	}
	shieldText = new FLOATTEXT (global, env, "", 0, 0,
			makecol (200, 200, 255), CENTRE);
	if (!shieldText) {
		perror ("tank.cc: Failed allocating memory for shieldText in TANK::TANK");
		exit (1);
	}
	initialise ();

	_align = LEFT;
	_global = global;
	_global->numTanks++;
}

void TANK::initialise ()
{

	PHYSICAL_OBJECT::initialise ();
	drag = 0.5;
	mass = 3000;
	repulsion = 0;
	shieldColor = 0;
	shieldThickness = 0;
	t = 0;
	sh = 0;
	_targetX = -1;
	_targetY = -1;
	newRound ();
}

void TANK::newRound ()
{
	char buf[10];

	cw = 0;
	damage = 0;
	pen = 0;
	para = 0;
	creditTo = NULL;
	p = MAX_POWER / 2;
	a = (rand () % 180) + 90;
	if (sh > 0 && sht > 0)
		if (player)
			player->ni[sht]++;
	sh = 0;
	repulsion = 0;
	shPhase = rand () % 360;
	sht = 0;
	l = 100;
	if (player) {
		double tmpL = 0;
		tmpL += (int)(player->ni[ITEM_ARMOUR] * item[ITEM_ARMOUR].vals[0]);
		tmpL += (int)(player->ni[ITEM_PLASTEEL] * item[ITEM_PLASTEEL].vals[0]);
		if (tmpL > 0)
			l += (int)pow (tmpL, 0.6);
	}
	maxLife = l;
	ds = 0;
	fs = 0;
	sprintf (buf, "%d", l);
	healthText->set_text (buf);
}

void TANK::update ()
{
	VIRTUAL_OBJECT::update ();
}

void TANK::requireUpdate ()
{
	VIRTUAL_OBJECT::requireUpdate ();
}

void TANK::applyDamage ()
{
	char buf[10];
	FLOATTEXT *damageText;
	FLOATTEXT *revengeText;

	if (damage > sh + l)
		damage = sh + l;
	sh -= (int)damage;
	if (creditTo) {
		if (player != creditTo) {	//enemy hit ++
			creditTo->money += (unsigned long int)(damage * _global->scoreHitUnit);
			if ((int)player->type != HUMAN_PLAYER) {
				if (player->revenge == creditTo) {
					player->annoyanceFactor += damage;
				} else {
					player->annoyanceFactor = damage;
				}
				if (player->annoyanceFactor > player->vengeanceThreshold * maxLife) {
					player->revenge = creditTo;
					revengeText = new FLOATTEXT (_global, _env,
						player->selectRevengePhrase ((double)damage / maxLife),
						(int)x, (int)y - 30,
						player->color, CENTRE);
					if (!revengeText) {
						perror ("tank.cc: Failed allocating memory for revengeText in TANK::TANK");
						exit (1);
					}
					revengeText->xv = 0;
					revengeText->yv = -0.4;
					revengeText->maxAge = 300;
				}
			}
		} else {	//self hit --
                        if ( (creditTo->money - (damage * _global->scoreSelfHit)) < 0)
                           creditTo->money = 0;
                        else
			   creditTo->money -= (unsigned long int)(damage * _global->scoreSelfHit);
			// if (creditTo->money < 0)
			//	creditTo->money = 0;
		}
	}

	if (sh < 0)
		l += sh;
	if (l < 0)
		l = 0;
	if (sh <= 0) {
		repulsion = 0;
		shieldColor = 0;
		shieldThickness = 0;
		sh = 0;
	}

	if ((int)damage > 0) {
		flashdamage = 1;
		sprintf (buf, "%d", (int)damage);
		damageText = new FLOATTEXT (_global, _env,
				buf, (int)x, (int)y,
				makecol (255, 0, 0), CENTRE);
		if (!damageText) {
			perror ("tank.cc: Failed allocating memory for damageText in TANK::TANK");
			exit (1);
		}
		damageText->xv = 0;
		damageText->yv = -0.2;
		damageText->maxAge = 300;
	}
	if (sh > 0) {
		sprintf (buf, "%d", sh);
		shieldText->set_text (buf);
	} else {
		shieldText->set_text ("");
	}
	sprintf (buf, "%d", l);
	healthText->set_text (buf);
}

void TANK::framelyAccounting ()
{
	if (shPhase < 0)
		shPhase = rand () % 360;
	shPhase += (int)(item[sht].vals[SHIELD_ENERGY] / sh) + 10;
	while (shPhase >= 360)
		shPhase -= 360;
}

int TANK::applyPhysics (GLOBALDATA *global)
{
	int stable = 0;
        int landed_on_tank;

	if (!flashdamage) {
		if (x + xv < 1 || x + xv > (_global->screenWidth-1))
			xv = -xv;	//bounce on the border
		int pixelCol = getpixel (_env->terrain, (int)x, (int)y + (TANKHEIGHT - TANKSAG));

                // check to see if we have landed on another tank -- Jesse
                landed_on_tank = tank_on_tank ( global );

                // we are falling and have hit the bottom of the screen or fallen onto dirt or on a tank
		if ((l > 0) && (yv > 0) && ((y >= _global->screenHeight - TANKHEIGHT) || 
                    (pixelCol != PINK) ||
                    (landed_on_tank) )) 
                {
			//count damage and add money
                        damage = (int) (yv * 10);
			if (damage >= 5)
				damage -= 5;
			creditTo = NULL;
			yv = 0;
			xv = 0;
                        // if we passed the bottom, then stop on bottom
			if (y > _global->screenHeight - TANKHEIGHT)
				y = _global->screenHeight - TANKHEIGHT;

		} 
                else if ((y < _global->screenHeight - TANKHEIGHT) && (pixelCol == PINK) && (l > 0) && (! landed_on_tank))
                {
			if (para && para < 3 && !_env->pclock)
				para++;
			if (!para) {
				yv += _env->gravity * (100.0 / FRAMES_PER_SECOND);
				y += yv;
			} else {
				double accel = (_env->wind - xv) / mass * (drag + 0.35) * _env->viscosity;
				xv += accel;
				yv += _env->gravity * (100.0 / FRAMES_PER_SECOND);
				if (yv > 0.5 )
					yv = 0.5;
				x += xv;
				y += yv;
			}
                        // falling, deploy parachute
			if (!para) {
				if (player->ni[ITEM_PARACHUTE]) {
					_env->pclock = 1;
					para = 1;
					player->ni[ITEM_PARACHUTE]--;
				}

			}
			requireUpdate ();
		} else {
			stable = 1;
			if (damage && !pen) {
				applyDamage ();

				pen = 1;
			}
			para = 0;
		}
	} else {
		flashdamage++;
	}
	return (stable);
}

void TANK::explode ()
{
	FLOATTEXT *revengeText;
	EXPLOSION *explosion;

	if ((int)player->type != HUMAN_PLAYER) {
		player->revenge = creditTo;
		revengeText = new FLOATTEXT (_global, _env,
			player->selectRevengePhrase ((double)damage / maxLife),
			(int)x, (int)y - 30,
			player->color, CENTRE);
		if (!revengeText) {
			perror ("tank.cc: Failed allocating memory for revengeText in TANK::explode");
			exit (1);
		}
		revengeText->xv = 0;
		revengeText->yv = -0.4;
		revengeText->maxAge = 300;
	}
	explosion = new EXPLOSION (_global, _env, x, y, 1);
	if (!explosion) {
		perror ("tank.cc: Failed allocating memory for explosion in TANK::explode");
		exit (1);
	}
	explosion->player = player;
	destroy = TRUE;

	play_sample ((SAMPLE *)_global->SOUND[WEAPONSOUNDS].dat, 255, 128, 1000, 0);
}

void TANK::repulse (double xpos, double ypos, double *xaccel, double *yaccel)
{
	if (repulsion != 0) {
		double xdist = xpos - x;
		double ydist = ypos - y;
		double distance2 = (xdist * xdist) + (ydist * ydist);
		double distance = sqrt (distance2);

		if (distance < 60 + sqrt ((double)repulsion)) {
			*xaccel = repulsion * (xdist / distance) / distance2;
			*yaccel = repulsion * (ydist / distance) / distance2;
		}
	}
}

void TANK::printHealth (BITMAP *dest, int offset)
{
	int textpos = -5;

	shieldText->set_pos ((int)x, (int)y - TANKHEIGHT + textpos + offset);
	if (sh > 0)
		textpos -= 10;
	healthText->set_pos ((int)x, (int)y - TANKHEIGHT + textpos + offset);
}

void TANK::draw (BITMAP *dest, int healthOffset)
{
	int turretAngle;

	rectfill (dest, (int) x - (TANKWIDTH - 1),
		(int) (y + TANKHEIGHT) - 2,
		(int) (x + TANKWIDTH) - 2,
		(int) (y + TANKHEIGHT),
		this->player->color);
	draw_sprite (dest, (BITMAP *) _global->gfxData.T[0].dat, (int) x - TANKWIDTH, (int) y);
	if (sh > 0) {
		int phaseValue = 1;

		drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
		set_trans_blender (0, 0, 0, (int)50);
		if (sht >= ITEM_LGT_SHIELD && sht <= ITEM_HVY_SHIELD) {
			phaseValue = (int)(_global->slope[(int)shPhase][0] * 3);
		} else if (sht >= ITEM_LGT_REPULSOR_SHIELD && sht <= ITEM_HVY_REPULSOR_SHIELD) {
			phaseValue = (int)(shPhase / 360 * 6);
		}

		ellipsefill (dest, (int) x, (int) y, TANKWIDTH + 6 + phaseValue, TANKHEIGHT - 1, shieldColor);
		set_trans_blender (0, 0, 0, (int)
				   (50 + (((float) sh / (float) (item[sht]).vals[SHIELD_ENERGY]) * (float) 150)));
		for (int thicknessCount = 0; thicknessCount < shieldThickness; thicknessCount++) {
			ellipse (dest, (int) x - (shieldThickness / 2) + thicknessCount, (int) y, TANKWIDTH + 6 + phaseValue, TANKHEIGHT - 1, shieldColor);
		}
		drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
	}
	turretAngle = (int) ((float) (90 - a) * ((float) 256 / (float) 360));
	rotate_sprite (dest, (BITMAP *) _global->gfxData.TG[0].dat,
		       (int) x - GUNLENGTH, (int) y - (GUNLENGTH - 2), itofix (turretAngle));

	if (sh > 0)
		setUpdateArea ((int)x - TANKWIDTH - 15, (int)y - TANKHEIGHT,
			((TANKWIDTH + 15) * 2) + 1, (TANKHEIGHT * 2) + 1);
	else
		setUpdateArea ((int)x - GUNLENGTH - 1, (int)y - GUNLENGTH - 1,
			(GUNLENGTH * 2) + 2, TANKHEIGHT + GUNLENGTH + 1);
	
	if (para) {
		draw_sprite (dest, (BITMAP *) _global->gfxData.T[para].dat,
			(int) (x - TANKWIDTH) - 3, (int) y - 25);
		addUpdateArea ((int)(x - TANKWIDTH) - 3, (int)y - 25,
			35, 46);
	}

	printHealth (dest, healthOffset);
	requireUpdate ();
}

int TANK::get_heaviest_shield ()
{
	if (player->ni[ITEM_HVY_REPULSOR_SHIELD]) {
		return ITEM_HVY_REPULSOR_SHIELD;
	}
	if (player->ni[ITEM_HVY_SHIELD]) {
		return ITEM_HVY_SHIELD;
	}
	if (player->ni[ITEM_MED_REPULSOR_SHIELD]) {
		return ITEM_MED_REPULSOR_SHIELD;
	}
	if (player->ni[ITEM_MED_SHIELD]) {
		return ITEM_MED_SHIELD;
	}
	if (player->ni[ITEM_LGT_REPULSOR_SHIELD]) {
		return ITEM_LGT_REPULSOR_SHIELD;
	}
	if (player->ni[ITEM_LGT_SHIELD]) {
		return ITEM_LGT_SHIELD;
	}
	return ITEM_NO_SHIELD;
}

void TANK::activateCurrentSelection ()
{
	int z;

	if (cw < WEAPONS) {
                player->changed_weapon = false;
		if (cw)
		    player->nm[cw]--;

		_env->stage = 1;
		_env->am = weapon[cw].spread;
		_env->realm = _env->am;
		if (cw < BALLISTICS) {
			play_sample ((SAMPLE *) _global->SOUND[weapon[cw].sound].dat, 255, 128, 1000, 0);
			for (z = 0; z < _env->am; z++) {
				MISSILE *newmis;
				double mxv,myv;
				int ca;

				ca = a + ((SPREAD * z) - (SPREAD * (_env->am - 1) / 2));
				mxv = _global->slope[ca][0] * p * (100.0 / FRAMES_PER_SECOND) / 100;
				myv = _global->slope[ca][1] * p * (100.0 / FRAMES_PER_SECOND) / 100;

				newmis = new MISSILE(_global, _env,
					x + (_global->slope[ca][0] * GUNLENGTH) /*- mxv*/,
					y + (_global->slope[ca][1] * GUNLENGTH) /*- myv*/,
					mxv, myv, cw);
				if (!newmis) {
					perror ("tank.cc: Failed allocating memory for newmis in TANK::activateCurrentSelection");
					exit (1);
				}
				newmis->physics = 0;
				newmis->age = 0;
				newmis->player = player;
				if (player->ni[ITEM_DIMPLEP]) {
					player->ni[ITEM_DIMPLEP]--;
					newmis->drag *= item[ITEM_DIMPLEP].vals[0];
				} else if (player->ni[ITEM_SLICKP]) {
					player->ni[ITEM_SLICKP]--;
					newmis->drag *= item[ITEM_SLICKP].vals[0];
				}
			}
		} else { // BEAM weapon
			play_sample ((SAMPLE *) _global->SOUND[weapon[cw].sound].dat, 255, 128, 1000, 0);
			for (z = 0; z < _env->am; z++) {
				BEAM *newbeam;
				int ca;

				ca = a + ((SPREAD * z) - (SPREAD * (_env->am - 1) / 2));

				newbeam = new BEAM (_global, _env,
					x + (_global->slope[ca][0] * GUNLENGTH),
					y + (_global->slope[ca][1] * GUNLENGTH),
					ca, cw);
				if (!newbeam) {
					perror ("tank.cc: Failed allocating memory for newbeam in TANK::activateCurrentSelection");
					exit (1);
				}
				newbeam->physics = 0;
				newbeam->age = 0;
				newbeam->player = player;
			}

		}
	} else {
		int itemNum = cw - WEAPONS;
		if (itemNum < ITEM_VENGEANCE || itemNum > ITEM_FATAL_FURY)
			player->ni[itemNum]--;
		_env->stage = 1;
		if (itemNum == ITEM_TELEPORT) {
			int teleXDest = (rand () % (_global->screenWidth - TANKWIDTH * 2)) + TANKWIDTH;
			int teleYDest = (rand () % (_global->screenHeight - TANKHEIGHT * 2)) + TANKHEIGHT;
			TELEPORT *teleport;
			creditTo = player;
			teleport = new TELEPORT (_global, _env, this, teleXDest, teleYDest, TANKHEIGHT * 4 + GUNLENGTH, 120);
			if (!teleport) {
				perror ("tank.cc: Failed allocating memory for teleport in TANK::activateCurrentSelection");
				exit (1);
			}
		} else if ((itemNum >= ITEM_VENGEANCE) &&
			(itemNum <= ITEM_FATAL_FURY)) {
			creditTo = player;
			damage = l + sh;
		}
	}

       // if we are out of this type of weapon
       // then switch to another
       if (! player->nm[cw] )
       {
          while ( (cw > 0) && (! player->nm[cw] ) )
             cw--;
          player->changed_weapon = true;
       }

}


void TANK::boost_up_shield ()
{
	char buf[10];
	int s = get_heaviest_shield ();

	if ((s != ITEM_NO_SHIELD) && (player->ni[s] > 0)) {
		player->ni[s]--;
		sh = (int)item[s].vals[SHIELD_ENERGY];
		repulsion = (int)item[s].vals[SHIELD_REPULSION];
		shieldColor = makecol ((int)item[s].vals[SHIELD_RED],
					(int)item[s].vals[SHIELD_GREEN],
					(int)item[s].vals[SHIELD_BLUE]);
		shieldThickness = (int)item[s].vals[SHIELD_THICKNESS];
		sht = s;
		ds = sht;
	}
	if (sh) {
		sprintf (buf, "%d", sh);
		shieldText->set_text (buf);
	} else {
		shieldText->set_text ("");
	}
}
void TANK::reactivate_shield ()
{
	if (!sh) {		//if no shield remains, try to reload
		boost_up_shield ();
	}
}

int TANK::howBuried ()
{
	int turrAngle;
	int buryCount = 0;

	for (turrAngle = 90; turrAngle < 270; turrAngle++) {
		if (getpixel (_env->terrain, (int)(x + (_global->slope[turrAngle][0] * GUNLENGTH)), (int)(y + (_global->slope[turrAngle][1] * GUNLENGTH))) != PINK)
			buryCount++;
	}

	return (buryCount);
}

int TANK::shootClearance (int targetAngle, int minimumClearance)
{
	int clearance = 0;

	while ((clearance < minimumClearance) &&
		(getpixel (_env->terrain, (int)(x + (_global->slope[targetAngle][0] * (GUNLENGTH + clearance))), (int)(y + (_global->slope[targetAngle][1] * (GUNLENGTH + clearance)))) == PINK)) {
			clearance++;
	}

	return (clearance >= minimumClearance);
}

int TANK::isSubClass (int classNum)
{
	if (classNum == TANK_CLASS)
		return (TRUE);
	else
		return (FALSE);
		//return (PHYSICAL_OBJECT::isSubClass (classNum));
}



/*
This function checks to see if there is a tank directly below this
one. This is to determine if we landed on someone.
The function returns TRUE if we landed on another tank and
FALSE if we did not.
-- Jesse
*/
int TANK::tank_on_tank( GLOBALDATA *global )
{
   int found_tank = FALSE;
   int player_count = 0;
   int delta_x, delta_y;

   while ( ( player_count < global->numPlayers ) && (! found_tank) )
   {
       // check to make sure this player is alive
       if ( global->players[player_count]->tank )
       {
       // make sure this isn't our own tank
       if ( ( global->players[player_count]->tank->x != x ) || (global->players[player_count]->tank->y != y ) )
       {
          // check to see if tanks are within TANK_WIDTH of each other's x
          delta_x = (int) (x - global->players[player_count]->tank->x);
          delta_y = (int) (y - global->players[player_count]->tank->y);

          if ( ( abs(delta_x) <= TANKWIDTH ) && ( (delta_y < 0) && (delta_y >= -TANKHEIGHT) ) )
             found_tank = TRUE;

       }    // end of this is our own tank
       }
       player_count++;
   }

   return found_tank;  
}

