/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


char *onOffText[2] = {"Off", "On"};
char *landSlideText[3] = {"None", "Instant", "Gravity"};
char *wallTypeText[3] = {"Rubber", "Steel", "Spring"};
char *mouseText[2] = {"Custom", "Default"};

MENUENTRY physicsOpts[4] = {
	{"Gravity", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Viscosity", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Land Slide", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 2, 1, 2, landSlideText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
        {"Wall Type", NULL, WHITE, &env->wallType, NULL, "%s", 0, 2, 1, 1, wallTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8}
};
MENUDESC physicsMenu = {"Physics", 4, physicsOpts, TRUE, FALSE};

char *meteorText[4] = {"Off", "Light", "Heavy", "Lethal"};
char *lightningText[4] = {"Off", "Weak", "Energetic", "Violent"};
MENUENTRY weatherOpts[5] = {
	{"Meteor Showers", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Lightning", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Fog (incomplete)", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
	{"Max Wind Strength", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
	{"Wind Variation", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
};
MENUDESC weatherMenu = {"Weather", 5, weatherOpts, TRUE, FALSE};

MENUENTRY graphicsOpts[6] = {
	{"Dithering", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Detailed Land", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Detailed Sky", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
        {"Screen Width", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
        {"Screen Height", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
        {"Mouse Pointer", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 32}
};
MENUDESC graphicsMenu = {"Graphics", 6, graphicsOpts, TRUE, FALSE};

MENUENTRY financeOpts[8] = {
	{"Starting Money", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Interest Rate", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Round Win Bonus", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
	{"Damage Bounty", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
	{"Self-Damage Penalty", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
	{"Tank Destruction Bonus", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
	{"Tank Self-Destruction Penalty", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
	{"Item Sell Multiplier", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
};
MENUDESC financeMenu = {"Money", 8, financeOpts, TRUE, FALSE};


char *landTypeText[7] = { "Random", "Canyons", "Mountains", "Valleys", "Hills", "Foothills", "Plains" };
char *turnTypeText[4] = { "High+", "Low+", "Random", "Simul" };
char *skipTypeText[3] = { "Off", "Humans Dead", "Autoplay" };
MENUENTRY mainOpts[9] = {
	{"Physics", NULL, WHITE, (double*)&physicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
	{"Weather", NULL, WHITE, (double*)&weatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
	{"Graphics", NULL, WHITE, (double*)&graphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
	{"Money", NULL, WHITE, (double*)&financeMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
	{"Tech Level", NULL, WHITE, (double*)&env->techLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight +12},
	{"Landscape", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 6, 1, LANDTYPE_HILLS, landTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
	{"Turn Order", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
	{"Skip AI-only play", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 2, 1, 1, skipTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight +72},
        {"Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92}
};
MENUDESC mainMenu = {"Main Menu", 9, mainOpts, TRUE, FALSE};
