#ifndef MENUCONTENT_HEADER_
#define MENUCONTENT_HEADER_

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

char *onOffText[2] = { (char *)"Off", (char *)"On"};
char *onOffRandomText[3] = { (char *)"Off", (char *)"On", (char *)"Random"};
char *landSlideText[5] = { (char *)"None", (char *)"Tank Only", (char *)"Instant", (char *)"Gravity", (char *)"Cartoon"};
char *wallTypeText[5] = { (char *)"Rubber", (char *)"Steel", (char *)"Spring", (char *)"Wrap", (char *)"Random"};
char *mouseText[2] = { (char *)"Custom", (char *)"Default"};
char *meteorText[4] = { (char *)"Off", (char *)"Light", (char *)"Heavy", (char *)"Lethal"};
char *lightningText[4] = { (char *)"Off", (char *)"Weak", (char *)"Energetic", (char *)"Violent"};
char *laserSatelliteText[4] = { (char *)"Off", (char *)"Weak", (char *)"Strong", (char *)"Super"};
char *languageText[5] = { (char *)"English", (char *)"Português", (char *)"Français", (char *)"Deutsch", (char *)"Slovak"};
char *colourText[2] = { (char *)"Regular", (char *)"Crispy"};
char *landTypeText[8] = { (char *)"Random", (char *)"Canyons", (char *)"Mountains", (char *)"Valleys", (char *)"Hills", (char *)"Foothills", (char *)"Plains", (char *)"None" };
char *turnTypeText[4] = { (char *)"High+", (char *)"Low+", (char *)"Random", (char *)"Simul" };
char *skipTypeText[2] = { (char *)"Off", (char *)"Humans Dead"};

// portuege version
char *onOffText_ptbr[2] = { (char *)"Desligado", (char *)"Ligado"};
/*translate*/
char *onOffRandomText_ptbr[3] = { (char *)"Desligado", (char *)"Ligado", (char *)"Random"};
char *landSlideText_ptbr[5] = { (char *)"Nenhum", (char *)"Tanque Somente", (char *)"InstantÃ¢neo", (char *)"Gravidade", (char *)"Cartoon"};
char *wallTypeText_ptbr[5] = { (char *)"ElÃ¡stico", (char *)"AÃ§o", (char *)"Mola", (char *)"Envoltório", (char *)"AleatÃ³rio"};
char *mouseText_ptbr[2] = { (char *)"Personalizado", (char *)"PadrÃ£o"};
char *meteorText_ptbr[4] = { (char *)"Desligado", (char *)"Fraco", (char *)"Forte", (char *)"Letal"};
char *lightningText_ptbr[4] = { (char *)"Desligado", (char *)"Fraco", (char *)"EnergÃ©tico", (char *)"Violento"};
char *laserSatelliteText_ptbr[4] = { (char *)"Desligado", (char *)"Fraco", (char *)"Forte", (char *)"Super"};
char *languageText_ptbr[5] = { (char *)"English", (char *)"Português", (char *)"Français", (char *)"Deutsch", (char *)"Slovak"};
char *colourText_ptbr[2] = { (char *)"Regular", (char *)"Crispy"};
char *landTypeText_ptbr[8] = { (char *)"aleatÃ³rio", (char *)"Canyons", (char *)"Montanhas", (char *)"Vales", (char *)"Colinas", (char *)"Morros", (char *)"Planos", (char *)"Nenhum" };
char *turnTypeText_ptbr[4] = { (char *)"Melhores+", (char *)"Piores+", (char *)"AleatÃ³rio", (char *)"Simul" };
char *skipTypeText_ptbr[2] = { (char *)"Desligado", (char *)"Humanos Mortos" };


// french version
char *onOffText_fr[2] = { (char *)"loin", (char *)"sur"};
/*translate*/
char *onOffRandomText_fr[3] = { (char *)"loin", (char *)"sur", (char *)"Random"};
char *landSlideText_fr[5] = { (char *)"Aucun", (char *)"Réservoir Seulement", (char *)"Instantané", (char *)"Gravité", (char *)"Dessin animé"};
char *wallTypeText_fr[5] = { (char *)"Elastique", (char *)"Acier", (char *)"Mou", (char *)"Znveloppe", (char *)"Aléatoire"};
char *mouseText_fr[2] = { (char *)"Pesonnel", (char *)"Défaut"};
char *meteorText_fr[4] = { (char *)"Off", (char *)"Light", (char *)"Heavy", (char *)"Lethal"};
char *lightningText_fr[4] = { (char *)"Aucun", (char *)"Faible", (char *)"Energique", (char *)"Violent"};
char *laserSatelliteText_fr[4] = { (char *)"Aucun", (char *)"Faible", (char *)"Fort", (char *)"Super"};
char *languageText_fr[5] = { (char *)"English", (char *)"Português", (char *)"Français", (char *)"Deutsch", (char *)"Slovak"};
char *colourText_fr[2] = { (char *)"Régulier", (char *)"Croustillant"};
char *landTypeText_fr[8] = { (char *)"Aléatoire", (char *)"Canyons", (char *)"Mountagnes", (char *)"Vallées", (char *)"Collines", (char *)"Contreforts", (char *)"Plaines", (char *)"Aucun" };
char *turnTypeText_fr[4] = { (char *)"Haut", (char *)"Bas", (char *)"Aléatoire", (char *)"Simulé" };
char *skipTypeText_fr[2] = { (char *)"Aucun", (char *)"Mort des humains"};


// german version
char *onOffText_de[2] = { (char *)"Aus", (char *)"An"};
char *onOffRandomText_de[3] = { (char *)"Aus", (char *)"An", (char *)"Zufällig"};
char *landSlideText_de[5] = { (char *)"Keine", (char *)"Nur Panzer", (char *)"Sofort", (char *)"Schwerkraft", (char *)"Cartoon"};
char *wallTypeText_de[5] = { (char *)"Gummi", (char *)"Stahl", (char *)"Federnd", (char *)"Verbunden", (char *)"Zufällig"};
char *mouseText_de[2] = { (char *)"Angepasst", (char *)"Standard"};
char *meteorText_de[4] = { (char *)"Aus", (char *)"Leicht", (char *)"Schwer", (char *)"Tödlich"};
char *lightningText_de[4] = { (char *)"Aus", (char *)"Schwach", (char *)"Stark", (char *)"Brutal"};
char *laserSatelliteText_de[4] = { (char *)"Aus", (char *)"Schwach", (char *)"Stark", (char *)"Super"};
char *languageText_de[5] = { (char *)"English", (char *)"Português", (char *)"Français", (char *)"Deutsch", (char *)"Slovak"};
char *colourText_de[2] = { (char *)"Normal", (char *)"Kontrastreich"};
char *landTypeText_de[8] = { (char *)"Zufällig", (char *)"Canyons", (char *)"Berge", (char *)"Täler", (char *)"Hügel", (char *)"Flache Hügel", (char *)"Ebene", (char *)"Nichts" };
char *turnTypeText_de[4] = { (char *)"Hoch+", (char *)"Niedrig+", (char *)"Zufällig", (char *)"Simul" };
char *skipTypeText_de[2] = { (char *)"Aus", (char *)"An"};

// slovak version
char *onOffText_sk[2] = { (char *)"Vypnuté", (char *)"Zapnuté"};
char *onOffRandomText_sk[3] = { (char *)"Vypnutý", (char *)"Zapnutý", (char *)"Náhodný"};
char *landSlideText_sk[5] = { (char *)"Žiaden", (char *)"Iba tank", (char *)"Okamžitý", (char *)"Gravitácia", (char *)"Kresl. film"};
char *wallTypeText_sk[5] = { (char *)"Guma", (char *)"Oceľ", (char *)"Pružina", (char *)"Prikrývka", (char *)"Náhodne"};
char *mouseText_sk[2] = { (char *)"Vlastné", (char *)"Východzie"};
char *meteorText_sk[4] = { (char *)"Vypnuté", (char *)"Ľahké", (char *)"Ťažké", (char *)"Smrteľné"};
char *lightningText_sk[4] = { (char *)"Vypnuté", (char *)"Slabé", (char *)"Energetické", (char *)"Kruté"};
char *laserSatelliteText_sk[4] = { (char *)"Vypnutý", (char *)"Slabý", (char *)"Silný", (char *)"Super"};
char *languageText_sk[5] = { (char *)"Anglicky", (char *)"Portugalsky", (char *)"Francúzsky", (char *)"Nemecky", (char *)"Slovensky"};
char *colourText_sk[2] = { (char *)"Normálna", (char *)"Svieža"};
char *landTypeText_sk[8] = { (char *)"Náhodná", (char *)"Kaňony", (char *)"Hory", (char *)"Údolia", (char *)"Kopce", (char *)"Úpätia", (char *)"Nížiny", (char *)"Žiadna" };
char *turnTypeText_sk[4] = { (char *)"Vysoký+", (char *)"Nízky+", (char *)"Náhodný", (char *)"Simul" };
char *skipTypeText_sk[2] = { (char *)"Vypnuté", (char *)"Smrť ľudských hráčov"};

// declare variables
MENUDESC mainMenu;

if (global->language == LANGUAGE_ENGLISH)
  {
    MENUENTRY physicsOpts[8] =
    {
      { (char *)"Gravity", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { (char *)"Viscosity", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { (char *)"Land Slide", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { (char *)"Land Slide Delay", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { (char *)"Wall Type", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { (char *)"Boxed Mode", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { (char *)"Violent Death", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { (char *)"Timed Shots", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { (char *)"Physics", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { (char *)"Meteor Showers", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Lightning", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Falling Dirt", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Laser Satellite", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Fog", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Max Wind Strength", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Wind Variation", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { (char *)"Weather", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY graphicsOpts[10] =
    {
      { (char *)"Dithering", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { (char *)"Detailed Land", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Detailed Sky", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Fading Text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Shadowed Text", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Colour Theme", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Screen Width", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Screen Height", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Mouse Pointer", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { (char *)"Game Speed", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92}
    };
    MENUDESC graphicsMenu = { (char *)"Graphics", 10, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[8] =
    {
      { (char *)"Starting Money", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Interest Rate", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Round Win Bonus", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Damage Bounty", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Self-Damage Penalty", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Tank Destruction Bonus", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Tank Self-Destruction Penalty", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Item Sell Multiplier", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
    };
    MENUDESC financeMenu = { (char *)"Money", 8, financeOpts, TRUE, FALSE};

    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;


    MENUENTRY mainOpts[11] =
    {
      { (char *)"Physics", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Weather", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Graphics", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Money", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Weapon Tech Level", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Item Tech Level", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Landscape", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Turn Order", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Skip AI-only play", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { (char *)"Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { (char *)"Language", NULL, WHITE, &global->language, NULL, "%s", 0, 4, 1, 0, languageText, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { (char *)"Main Menu", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = (char *)"Main Menu";
    mainMenu.numEntries = 11;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }  // end of English

if (global->language == LANGUAGE_PORTUGUESE)  // Portuguese
  {
    MENUENTRY physicsOpts[8] =
    {
      { (char *)"Gravidade", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { (char *)"Viscosidade", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { (char *)"Deslizamento de Terra", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { (char *)"corrediça da terra atrasa", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { (char *)"Tipo de Parede", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      /*translate*/{ (char *)"Boxed Mode", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { (char *)"morte violenta", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { (char *)"tiro programado", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}

    };
    MENUDESC physicsMenu = { (char *)"FÃ", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { (char *)"Chuvas de Meteoro", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1,
        0, meteorText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 68},
      { (char *)"RelÃ¢mpagos", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0,
        lightningText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 48},
      { (char *)"Sujeira de queda", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Satélite do Laser", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0,
        laserSatelliteText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 8},
      { (char *)"Neblina", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1,
        0, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight + 12},
      { (char *)"Velocidade Max do Vento", NULL, WHITE, (double*)&env->windstrength,
        NULL, (char *)"%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 32 },
      { (char *)"VariaÃ§Ã£o do Vento", NULL, WHITE, (double*)&env->windvariation,
        NULL, (char *)"%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { (char *)"CondiÃ§Ãµes MeteorolÃ³gicas", 7, weatherOpts,
                             TRUE, FALSE
                           };

    MENUENTRY graphicsOpts[10] =
    {
      { (char *)"Pontilhamento", NULL, WHITE, &global->ditherGradients, NULL, "%s",
        0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 88},
      { (char *)"Detalhes do Terreno", NULL, WHITE, &global->detailedLandscape, NULL,
        (char *)"%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Detalhes do CÃ©u", NULL, WHITE, &global->detailedSky, NULL, "%s", 0,
        1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 48},
      /* translate! */
      { (char *)"Fading Text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Shadowed Text", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"tema da cor", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},

      { (char *)"Largura da Tela", NULL, WHITE, &global->temp_screenWidth,
        NULL, (char *)"%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 32 },
      { (char *)"Altura da Tela", NULL, WHITE, &global->temp_screenHeight,
        NULL, (char *)"%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Ponteiro do Mouse", NULL, WHITE, &global->os_mouse, NULL,
        (char *)"%s", 0, 1, 1, 1, mouseText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth
        - 1, global->halfHeight + 72},
      { (char *)"velocidade do jogo", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92}

    };
    MENUDESC graphicsMenu = { (char *)"GrÃ¡ficos", 10, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[8] =
    {
      { (char *)"Dinheiro inicial", NULL, WHITE, (double*)&global->startmoney, NULL,
        (char *)"%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Taxa de Juros", NULL, WHITE, (double*)&global->interest, NULL,
        (char *)"%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"BÃ´nus por VitÃ³ria", NULL, WHITE,
        (double*)&global->scoreRoundWinBonus, NULL, (char *)"%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE,
        FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"BÃ´nus por Estrago", NULL, WHITE, (double*)&global->scoreHitUnit,
        NULL, (char *)"%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Penalidade por Auto-Estrago", NULL, WHITE,
        (double*)&global->scoreSelfHit, NULL, (char *)"%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE,
        FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"BÃ´nus por Tanque DestruÃ", NULL, WHITE,
        (double*)&global->scoreUnitDestroyBonus, NULL, (char *)"%2.0f", 0, 20000, 2500, 5000, NULL,
        OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Penalidade por Auto-DestruiÃ§Ã£o", NULL, WHITE,
        (double*)&global->scoreUnitSelfDestroy, NULL, (char *)"%2.0f", 0, 20000, 2500, 0, NULL,
        OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Multiplicador de Item Vendido", NULL, WHITE,
        (double*)&global->sellpercent, NULL, (char *)"%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE,
        FALSE, global->halfWidth -3, global->halfHeight + 92},
    };
    MENUDESC financeMenu = { (char *)"Dinheiro", 8, financeOpts, TRUE, FALSE};


    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;


    MENUENTRY mainOpts[11] =
    {
      { (char *)"FÃ", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0,
        0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 68},
      { (char *)"CondiÃ§Ãµes MeteorolÃ³gicas", NULL, WHITE, (double*)pWeatherMenu,
        NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth -
        3, global->halfHeight - 48},
      { (char *)"GrÃ¡ficos", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0,
        0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 28},
      { (char *)"Dinheiro", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0,
        0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight - 8},
      { (char *)"Arma NÃ TecnolÃ³gico", NULL, WHITE, (double*)&env->weapontechLevel, NULL,
        (char *)"%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -
        3, global->halfHeight + 12},
      { (char *)"Artigo NÃ TecnolÃ³gico", NULL, WHITE, (double*) &env->itemtechLevel, NULL,
        (char *)"%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"CenÃ¡rio", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7,
        1, LANDTYPE_HILLS, landTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Ordem de Jogadas", NULL, WHITE, (double*)&global->turntype, NULL,
        (char *)"%s", 0, 3, 1, TURN_RANDOM, turnTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Pular Jogo SÃ³ com RobÃ´s", NULL, WHITE, &global->skipComputerPlay,
        NULL, (char *)"%s", 0, 2, 1, 1, skipTypeText_ptbr, OPTION_SPECIALTYPE, FALSE,
        global->halfWidth - 3, global->halfHeight + 92},
      { (char *)"Som", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1,
        onOffText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3,
        global->halfHeight + 112},
      { (char *)"língua", NULL, WHITE, &global->language, NULL, "%s", 0, 4, 1, 0, languageText_ptbr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}

    };
// mainMenu = { (char *)"Menu Principal", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = (char *)"Menu Principal";
    mainMenu.numEntries = 11;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }   // end of Portuguese


// french
if (global->language == LANGUAGE_FRENCH)
  {
    MENUENTRY physicsOpts[8] =
    {
      { (char *)"Gravité", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { (char *)"Viscosité", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { (char *)"Glissements de terrain", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { (char *)"Délai glissements de terrain", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { (char *)"Murs", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      /*translate*/{ (char *)"Boxed Mode", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { (char *)"mort violente", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { (char *)"projectile synchronisé", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}

    };
    MENUDESC physicsMenu = { (char *)"Physique", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { (char *)"Orages de météorites", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Éclairs", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Saleté en chute", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Satellites Laser", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Brouillard", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Force maxi du vent", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Variation du vent", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { (char *)"Météo", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY graphicsOpts[10] =
    {
      { (char *)"Tramage", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { (char *)"Détails du terrain", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Ciel détaillé", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      /* translate! */
      { (char *)"Fading Text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Shadowed Text", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Thème de couleurs", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Largeur d'écran", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Hauteur d'écran", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Curseur de souris", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { (char *)"Vitesse du jeu", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92}
    };
    MENUDESC graphicsMenu = { (char *)"Graphismes", 10, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[8] =
    {
      { (char *)"Somme de départ", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Taux d'intérêt", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Gains par victoire", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Bonus dommages", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Pénalité auto-dommages", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Bonus destruction tank", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Pénalité autodestruction tank", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Coeff. vente item", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
    };
    MENUDESC financeMenu = { (char *)"Money", 8, financeOpts, TRUE, FALSE};


    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;


    MENUENTRY mainOpts[11] =
    {
      { (char *)"Physique", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Métao", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Graphismes", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Finances", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Niveau technique armes", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Niveau technique équipement", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Paysage", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Ordre de passage", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Jeu IA seule", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { (char *)"Son", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { (char *)"Langue", NULL, WHITE, &global->language, NULL, "%s", 0, 4, 1, 0, languageText_fr, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { (char *)"Menu principal", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = (char *)"Menu principal";
    mainMenu.numEntries = 11;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;


  }       // end of french

if (global->language == LANGUAGE_GERMAN)
  {
    MENUENTRY physicsOpts[8] =
    {
      { (char *)"Gravitation", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { (char *)"Reibung", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { (char *)"Erdrutsch", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { (char *)"Erdrutsch Verzögerung", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1,3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { (char *)"Wand Art", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { (char *)"Höhlenmodus", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { (char *)"Gewalttätiger Tod", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { (char *)"Zeitlimit", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { (char *)"Physik", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { (char *)"Meteoritenregen", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Gewitter", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_de,OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Schmutzregen", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Lasersatelit", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Nebel", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Max Windstärke", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Windvariation", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { (char *)"Wetter", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY graphicsOpts[10] =
    {
      { (char *)"Dithering", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { (char *)"Landdetails", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Himmeldetails", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Ausblendender Text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Schattierter Text", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Farbschema", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Bildschirmbreite", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Bildschirmhöhe", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Mauszeiger", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_de,OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { (char *)"Spielgeschwindigket", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92}
    };
    MENUDESC graphicsMenu = { (char *)"Grafik", 10, graphicsOpts, TRUE, FALSE};


    MENUENTRY financeOpts[8] =
    {
      { (char *)"Startgeld", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Zinssatz", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05,1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Rundenbonus", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0,50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Schadensbonus", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Strafe für Selbstschaden", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Zerstörungsbonus", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Selbstzerstörungsstrafe", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Verkaufsmultiplikator", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f",0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
    };
    MENUDESC financeMenu = { (char *)"Geld", 8, financeOpts, TRUE, FALSE};


    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;

    MENUENTRY mainOpts[11] =
    {
      { (char *)"Physik", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Wetter", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Grafik", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Geld", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Technologiestufe Waffen", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight +12},
      { (char *)"Technologiestufe Gegenstände", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Landschaft", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight+ 52},
      { (char *)"Reihenfolge", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Überspringe Nur-KI", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { (char *)"Sound", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText_de, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { (char *)"Sprache", NULL, WHITE, &global->language, NULL, "%s", 0, 4, 1, 0, languageText_de,OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
// mainMenu = { (char *)"Main Menu", 10, mainOpts, TRUE, FALSE};
    mainMenu.title = (char *)"Hauptmenü";
    mainMenu.numEntries = 11;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }  // end of German

if (global->language == LANGUAGE_SLOVAK)
  {
    /* TRANSLATION NEEDED! */
    MENUENTRY physicsOpts[8] =
    {
      { (char *)"Gravitácia", NULL, WHITE, &env->gravity, NULL, "%2.3f", .025, .325, 0.025, .075, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 80},
      { (char *)"Viskozita", NULL, WHITE, &env->viscosity, NULL, "%2.2f", .25, 2.0, 0.25, 1.0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 60},
      { (char *)"Zosuv zeme", NULL, WHITE, &env->landSlideType, NULL, "%s", 0, 4, 1, 3, landSlideText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 40},
      { (char *)"Zdržanie zosunu zeme", NULL, WHITE, &env->landSlideDelay, NULL, "%4.0f", 1, 5, 1, 3, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 20},
      { (char *)"Typ steny", NULL, WHITE, &env->wallType, NULL, "%s", 0, 4, 1, 1, wallTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight},
      { (char *)"Režim krabíc", NULL, WHITE, &env->dBoxedMode, NULL, "%s", 0, 2, 1, 0, onOffRandomText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 20},
      { (char *)"Krutá smrť", NULL, WHITE, &global->violent_death, NULL, "%s", 0, 3, 1, 0, lightningText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 40},
      { (char *)"Časované strely", NULL, WHITE, &global->max_fire_time, NULL, "%3.0f", 0, 180, 5, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 60}
    };
    MENUDESC physicsMenu = { (char *)"Fyzika", 7, physicsOpts, TRUE, FALSE};

    MENUENTRY weatherOpts[7] =
    {
      { (char *)"Dážď meteorov", NULL, WHITE, &env->meteors, NULL, "%s", 0, 3, 1, 0, meteorText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Blesky", NULL, WHITE, &env->lightning, NULL, "%s", 0, 3, 1, 0, lightningText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Padajúca zem", NULL, WHITE, &env->falling_dirt_balls, NULL, "%s", 0, 3, 1, 0, meteorText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Laserový satelit", NULL, WHITE, &env->satellite, NULL, "%s", 0, 3, 1, 0, laserSatelliteText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Hmla", NULL, WHITE, &env->fog, NULL, "%s", 0, 1, 1, 0, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Maximálna sila vetra", NULL, WHITE, (double*)&env->windstrength, NULL, "%2.0f", 0, 100, 5, 40, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Zmena vetra", NULL, WHITE, (double*)&env->windvariation, NULL, "%2.1f", 0, 100, 3, 10, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
    };
    MENUDESC weatherMenu = { (char *)"Weather", 7, weatherOpts, TRUE, FALSE};

    MENUENTRY graphicsOpts[10] =
    {
      { (char *)"Rozptyl", NULL, WHITE, &global->ditherGradients, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 88},
      { (char *)"Detaily krajiny", NULL, WHITE, &global->detailedLandscape, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Detaily oblohy", NULL, WHITE, &global->detailedSky, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Slabnúci text", NULL, WHITE, &env->dFadingText, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Text s tieňom", NULL, WHITE, &env->dShadowedText, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Farebná téma", NULL, WHITE, &global->colour_theme, NULL, "%s", 0, 1, 1, 1, colourText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Šírka obrazovky", NULL, WHITE, &global->temp_screenWidth, NULL, "%4.0f", 800, 1600, 200, 800, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Výška obrazovky", NULL, WHITE, &global->temp_screenHeight, NULL, "%4.0f", 600, 1200, 200, 600, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Ukazovateľ myši", NULL, WHITE, &global->os_mouse, NULL, "%s", 0, 1, 1, 1, mouseText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 1, global->halfHeight + 72},
      { (char *)"Rýchlosť hry", NULL, WHITE, &global->frames_per_second, NULL, "%3.0f", 30, 120, 10, 60, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92}
    };
    MENUDESC graphicsMenu = { (char *)"Grafika", 10, graphicsOpts, TRUE, FALSE};

    MENUENTRY financeOpts[8] =
    {
      { (char *)"Peniaze na začiatku", NULL, WHITE, (double*)&global->startmoney, NULL, "%2.0f", 0, 200000, 5000, 20000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Úroková miera", NULL, WHITE, (double*)&global->interest, NULL, "%2.2f", 1.0, 1.5, 0.05, 1.25, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Bonus pri skončení kola", NULL, WHITE, (double*)&global->scoreRoundWinBonus, NULL, "%2.0f", 0, 50000, 5000, 10000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Odmena za poškodenie", NULL, WHITE, (double*)&global->scoreHitUnit, NULL, "%2.0f", 0, 500, 25, 75, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Pokuta za vlastné poškodenie", NULL, WHITE, (double*)&global->scoreSelfHit, NULL, "%2.0f", 0, 10000, 1000, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Bonus za zničenie tanku", NULL, WHITE, (double*)&global->scoreUnitDestroyBonus, NULL, "%2.0f", 0, 20000, 2500, 5000, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Pokuta za vlastné zničenie tanku", NULL, WHITE, (double*)&global->scoreUnitSelfDestroy, NULL, "%2.0f", 0, 20000, 2500, 0, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Násobiteľ pri predaji položiek", NULL, WHITE, (double*)&global->sellpercent, NULL, "%1.2f", 0.0, 1.0, 0.10, 0.80, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth -3, global->halfHeight + 92},
    };
    MENUDESC financeMenu = { (char *)"Peniaze", 8, financeOpts, TRUE, FALSE};

    void *pPhysicsMenu  =       &physicsMenu;
    void *pWeatherMenu  =       &weatherMenu;
    void *pGraphicsMenu =       &graphicsMenu;
    void *pFinanceMenu  =       &financeMenu;


    MENUENTRY mainOpts[11] =
    {
      { (char *)"Fyzika", NULL, WHITE, (double*)pPhysicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 68},
      { (char *)"Počasie", NULL, WHITE, (double*)pWeatherMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 48},
      { (char *)"Grafika", NULL, WHITE, (double*)pGraphicsMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 28},
      { (char *)"Peniaze", NULL, WHITE, (double*)pFinanceMenu, NULL, NULL, 0, 0, 0, 0, NULL, OPTION_MENUTYPE, FALSE, global->halfWidth - 3, global->halfHeight - 8},
      { (char *)"Tech úroveň zbraní", NULL, WHITE, (double*)&env->weapontechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 12},
      { (char *)"Tech úroveň vecí", NULL, WHITE, (double *) &env->itemtechLevel, NULL, "%2.0f", 0, 5, 1, 5, NULL, OPTION_DOUBLETYPE, FALSE, global->halfWidth - 3, global->halfHeight + 32},
      { (char *)"Krajina", NULL, WHITE, (double*)&env->landType, NULL, "%s", 0, 7, 1, LANDTYPE_HILLS, landTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 52},
      { (char *)"Poradie", NULL, WHITE, (double*)&global->turntype, NULL, "%s", 0, 3, 1, TURN_RANDOM, turnTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 72},
      { (char *)"Preskočiť iba hru PC", NULL, WHITE, &global->skipComputerPlay, NULL, "%s", 0, 1, 1, 1, skipTypeText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 92},
      { (char *)"Zvuk", NULL, WHITE, &global->sound, NULL, "%s", 0, 1, 1, 1, onOffText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 112},
      { (char *)"Jazyk", NULL, WHITE, &global->language, NULL, "%s", 0, 4, 1, 0, languageText_sk, OPTION_SPECIALTYPE, FALSE, global->halfWidth - 3, global->halfHeight + 132}
    };
    mainMenu.title = (char *)"Hlavné menu";
    mainMenu.numEntries = 11;
    mainMenu.entries = mainOpts;
    mainMenu.quitButton = TRUE;
    mainMenu.okayButton = FALSE;

  }  // end of Slovak

#endif
