#ifndef SATELLITE_HEADER_FILE__
#define SATELLITE_HEADER_FILE__


#include "environment.h"
#include "globaldata.h"
#include "virtobj.h"

#define SATELLITE_IMAGE 16
#define CHANCE_TO_SHOOT 100


class SATELLITE
  {
  private:
    // empty ctor, copy-ctor and assign operator are private, so the compiler won't create implicit ones!
    inline SATELLITE () { }
    inline SATELLITE (SATELLITE &sourceSat _UNUSED) { }
    inline const SATELLITE& operator= (const SATELLITE &sourceSat) { return(sourceSat); }

  public:
    int x, y;
    int xv;
    GLOBALDATA *_global;
    ENVIRONMENT *_env;

    SATELLITE(GLOBALDATA *global, ENVIRONMENT *env);
    ~SATELLITE();
    void Init();
    void Move();
    void Draw(BITMAP *dest);
    void Shoot();

  };

#endif

