import logging

logging.basicConfig(level=100) # avoid logging messages from other loggers

import atheist.gvar as gvar

DATEFORMAT = '%d/%m/%y %H:%M:%S'

class XXLoggingFormatter(logging.Formatter):
    def format(self, record):
        record.levelinitial = record.levelname[0]*2
        return logging.Formatter.format(self, record)

def create_basic_handler():
    formatter = XXLoggingFormatter('[%(levelinitial)s] %(message)s', DATEFORMAT)
    console = logging.StreamHandler()
    console.setFormatter(formatter)
    return console

def create_logger(name):
    retval = logging.getLogger(name)
    if not retval.handlers:
        retval.addHandler(create_basic_handler())
        retval.propagate = 0
        retval.setLevel(logging.WARNING)
    return retval

if gvar.Log is None:
    gvar.Log = create_logger('atheist')
