# -*- mode:python; coding:utf-8 -*-
from pyarco.Logging import SMTPHandler
from pyarco.UI import cout_config

import atheist
from atheist.gvar import Log

class SMTP_Reporter(atheist.FailReporter, atheist.Plugin):
    def __init__(self, mng, account):
        handler = SMTPHandler(\
            (mng.cfg['smtp.host'], mng.cfg.get('smtp.port', 25)),
            mng.cfg['smtp.user'], account,
            'Atheist report',
            (mng.cfg['smtp.user'], mng.cfg['smtp.pass']))

        atheist.FailReporter.__init__(self, mng, 'smtp://'+account, handler)

    @classmethod
    def add_options(cls, parser):
        parser.add_option('--notify-smtp', dest='mail', action='append', default=[],
                          help='notify failed taks to the given email address')

    @classmethod
    def config(cls, mng):
        for account in mng.cfg.mail:
            mng.reporters.append(SMTP_Reporter(mng, account))
