! (C) Copyright 2013 ECMWF.
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation nor
! does it submit to any jurisdiction.

#include "fckit/fctest.h"

! -----------------------------------------------------------------------------

TESTSUITE(fctest_stretchedrotatedgaussiangrid)

! -----------------------------------------------------------------------------

TESTSUITE_INIT
  use atlas_module
  call atlas_library%initialise()
END_TESTSUITE_INIT

! -----------------------------------------------------------------------------

TESTSUITE_FINALIZE
  use atlas_module
  call atlas_library%finalise()
END_TESTSUITE_FINALIZE

! ----------------------------------------------------------------------------

TEST( arpege_t31c24 )
  ! Grid provided by Philippe Marguinaud, Meteo France
  use atlas_module
  implicit none
  type(atlas_ReducedGaussianGrid) :: grid
  type(atlas_LonLatRectangularDomain) :: bounding_box

  real(dp) :: lonlat(3376)

  integer, parameter :: nx(32) = &
  [ 20, 27, 32, 40, 45, 48, 60, 60, 64, 64, 64, 64, 64, 64, 64, 64, &
    64, 64, 64, 64, 64, 64, 64, 64, 60, 60, 48, 45, 40, 32, 27, 20 ]
  real(dp), parameter :: stretch = 2.4_dp
  real(dp), parameter :: centre(2) = [2.0_dp, 46.7_dp]
  real(dp), parameter :: angle = 180.0_dp
  integer :: i, j, jglo

  lonlat(    1:  120) = [ &
  &     2.00000000000000000_dp,    48.46708828700425187_dp,     1.17799068975270704_dp,    48.37772379915030996_dp, &
  &     0.44418972240584109_dp,    48.11926090196744354_dp,    -0.12512266986032569_dp,    47.71926346185548340_dp, &
  &    -0.47479391972813606_dp,    47.21956618120344018_dp,    -0.57569351104372468_dp,    46.67109320702403608_dp, &
  &    -0.42528132740345748_dp,    46.12813070368466839_dp,    -0.04494770792091035_dp,    45.64287023699112211_dp, &
  &     0.52444137510688571_dp,    45.26073815098433784_dp,     1.22762737065264282_dp,    45.01674523281888440_dp, &
  &     2.00000000000000000_dp,    44.93291171299576092_dp,     2.77237262934735629_dp,    45.01674523281888440_dp, &
  &     3.47555862489311407_dp,    45.26073815098433784_dp,     4.04494770792090996_dp,    45.64287023699112211_dp, &
  &     4.42528132740345725_dp,    46.12813070368466839_dp,     4.57569351104372490_dp,    46.67109320702403608_dp, &
  &     4.47479391972813634_dp,    47.21956618120344018_dp,     4.12512266986032561_dp,    47.71926346185548340_dp, &
  &     3.55581027759415846_dp,    48.11926090196744354_dp,     2.82200931024729318_dp,    48.37772379915030996_dp, &
  &     2.00000000000000000_dp,    50.76274729016172671_dp,     0.52357145823104279_dp,    50.64425941434981837_dp, &
  &    -0.85309402263029532_dp,    50.29690558565773273_dp,    -2.04123891610972796_dp,    49.74407157963349846_dp, &
  &    -2.97152383528954323_dp,    49.02183412771946536_dp,    -3.59837298636155323_dp,    48.17535393470686955_dp, &
  &    -3.90029306374494222_dp,    47.25496955383284359_dp,    -3.87730059701688790_dp,    46.31256836954069911_dp, &
  &    -3.54692456688646551_dp,    45.39855083314470363_dp,    -2.93998927128814502_dp,    44.55946699558614910_dp, &
  &    -2.09688983996385936_dp,    43.83625800397906147_dp,    -1.06462721424400342_dp,    43.26298044031561574_dp, &
  &     0.10541754825032876_dp,    42.86589673132546352_dp,     1.35912400589531490_dp,    42.66284629701862485_dp, &
  &     2.64087599410468910_dp,    42.66284629701862485_dp,     3.89458245174967033_dp,    42.86589673132546352_dp, &
  &     5.06462721424400453_dp,    43.26298044031561574_dp,     6.09688983996385936_dp,    43.83625800397906147_dp, &
  &     6.93998927128814458_dp,    44.55946699558614910_dp,     7.54692456688646551_dp,    45.39855083314470363_dp, &
  &     7.87730059701688656_dp,    46.31256836954069911_dp,     7.90029306374494134_dp,    47.25496955383284359_dp, &
  &     7.59837298636155190_dp,    48.17535393470686955_dp,     6.97152383528954367_dp,    49.02183412771946536_dp, &
  &     6.04123891610972930_dp,    49.74407157963349846_dp,     4.85309402263029188_dp,    50.29690558565773273_dp, &
  &     3.47642854176895577_dp,    50.64425941434981837_dp,     2.00000000000000089_dp,    53.08763788054714894_dp, &
  &    -0.06435502534210064_dp,    52.94800110445672203_dp,    -2.01378910799337474_dp,    52.53707313311167582_dp, &
  &    -3.74622775989939782_dp,    51.87782553848720113_dp,    -5.18197003975669812_dp,    51.00557820511744467_dp, &
  &    -6.26810804950859701_dp,    49.96440199105025926_dp,    -6.97806564551988018_dp,    48.80336562297891589_dp, &
  &    -7.30784824781774223_dp,    47.57322688923063225_dp,    -7.27090590027329053_dp,    46.32385288536406875_dp, &
  &    -6.89307303713296715_dp,    45.10238649522262477_dp,    -6.20837670733706215_dp,    43.95202523375940729_dp, &
  &    -5.25594876339865014_dp,    42.91123363953519743_dp,    -4.07794770476515911_dp,    42.01322983391511201_dp  ]
  lonlat(  121:  240) = [ &
  &    -2.71826031811739588_dp,    41.28563184510834105_dp,    -1.22173788476928480_dp,    40.75019560382368411_dp, &
  &     0.36623707967922525_dp,    40.42261301497919845_dp,     1.99999999999999933_dp,    40.31236211945285675_dp, &
  &     3.63376292032077286_dp,    40.42261301497919845_dp,     5.22173788476928369_dp,    40.75019560382368411_dp, &
  &     6.71826031811739455_dp,    41.28563184510834105_dp,     8.07794770476515822_dp,    42.01322983391511201_dp, &
  &     9.25594876339864925_dp,    42.91123363953519743_dp,    10.20837670733705949_dp,    43.95202523375940729_dp, &
  &    10.89307303713296804_dp,    45.10238649522262477_dp,    11.27090590027328965_dp,    46.32385288536406875_dp, &
  &    11.30784824781774311_dp,    47.57322688923063225_dp,    10.97806564551988195_dp,    48.80336562297891589_dp, &
  &    10.26810804950859790_dp,    49.96440199105025926_dp,     9.18197003975669901_dp,    51.00557820511744467_dp, &
  &     7.74622775989939960_dp,    51.87782553848720113_dp,     6.01378910799337607_dp,    52.53707313311167582_dp, &
  &     4.06435502534210169_dp,    52.94800110445672203_dp,     2.00000000000000089_dp,    55.44054043583248159_dp, &
  &    -0.39391037845720578_dp,    55.31115535850048559_dp,    -2.68766853851381882_dp,    54.92865613654313961_dp, &
  &    -4.79116029542177202_dp,    54.30937174533021050_dp,    -6.63193584333677855_dp,    53.47856301011842106_dp, &
  &    -8.15903975007321769_dp,    52.46802323745790630_dp,    -9.34306219743110411_dp,    51.31353838046217675_dp, &
  &   -10.17346129570704782_dp,    50.05261748260089405_dp,   -10.65454278958191026_dp,    48.72271255422421632_dp, &
  &   -10.80126342211737800_dp,    47.35996933207513848_dp,   -10.63557388477568999_dp,    45.99843704779454612_dp, &
  &   -10.18359521918176824_dp,    44.66961909752426152_dp,    -9.47363915243209931_dp,    43.40224634648851065_dp, &
  &    -8.53494002107633598_dp,    42.22217718966415845_dp,    -7.39692139773956647_dp,    41.15235690381517486_dp, &
  &    -6.08882962579569487_dp,    40.21279467492543347_dp,    -4.63959771096107954_dp,    39.42053684981195261_dp, &
  &    -3.07783882564465205_dp,    38.78962916423042628_dp,    -1.43190111561111988_dp,    38.33106975566338548_dp, &
  &     0.27005804914242593_dp,    38.05275970261258323_dp,     1.99999999999999956_dp,    37.95945956416753120_dp, &
  &     3.72994195085757241_dp,    38.05275970261258323_dp,     5.43190111561111788_dp,    38.33106975566338548_dp, &
  &     7.07783882564465028_dp,    38.78962916423042628_dp,     8.63959771096107865_dp,    39.42053684981195261_dp, &
  &    10.08882962579569309_dp,    40.21279467492543347_dp,    11.39692139773956647_dp,    41.15235690381517486_dp, &
  &    12.53494002107633243_dp,    42.22217718966415845_dp,    13.47363915243209576_dp,    43.40224634648851065_dp, &
  &    14.18359521918176824_dp,    44.66961909752426152_dp,    14.63557388477568999_dp,    45.99843704779454612_dp, &
  &    14.80126342211737445_dp,    47.35996933207513848_dp,    14.65454278958191381_dp,    48.72271255422421632_dp, &
  &    14.17346129570704782_dp,    50.05261748260089405_dp,    13.34306219743110766_dp,    51.31353838046217675_dp, &
  &    12.15903975007321769_dp,    52.46802323745790630_dp,    10.63193584333677855_dp,    53.47856301011842106_dp, &
  &     8.79116029542177380_dp,    54.30937174533021050_dp,     6.68766853851382059_dp,    54.92865613654313961_dp, &
  &     4.39391037845720867_dp,    55.31115535850048559_dp,     2.00000000000000222_dp,    57.82915094012270174_dp  ]
  lonlat(  241:  360) = [ &
  &    -0.88089731877775757_dp,    57.69078537163564846_dp,    -3.64890062321652664_dp,    57.28147795233979167_dp, &
  &    -6.20331014929099656_dp,    56.61787273415653488_dp,    -8.46463908845755597_dp,    55.72551502002679058_dp, &
  &   -10.37873026754043693_dp,    54.63620962052475960_dp,   -11.91616209561276740_dp,    53.38530347804498888_dp, &
  &   -13.06845153476416321_dp,    52.00935252683229493_dp,   -13.84288249522568925_dp,    50.54439040009851425_dp, &
  &   -14.25738892575702366_dp,    49.02480894996942595_dp,   -14.33628744864260440_dp,    47.48274104170999976_dp, &
  &   -14.10711920596712332_dp,    45.94779768044404733_dp,   -13.59853603019004176_dp,    44.44702279967973624_dp, &
  &   -12.83902541924944174_dp,    43.00496062724707258_dp,   -11.85624296375186937_dp,    41.64376435793402464_dp, &
  &   -10.67674963753560036_dp,    40.38330297070848474_dp,    -9.32599718132065902_dp,    39.24124360712294646_dp, &
  &    -7.82844927012504055_dp,    38.23310085983992224_dp,    -6.20776260081896769_dp,    37.37225322309888043_dp, &
  &    -4.48697963071903061_dp,    36.66993230518373537_dp,    -2.68870484500073204_dp,    36.13519327177002793_dp, &
  &    -0.83525097543211291_dp,    35.77487607444932394_dp,     1.05124791602986001_dp,    35.59356675116022473_dp, &
  &     2.94875208397013866_dp,    35.59356675116022473_dp,     4.83525097543211047_dp,    35.77487607444932394_dp, &
  &     6.68870484500073026_dp,    36.13519327177002793_dp,     8.48697963071903061_dp,    36.66993230518373537_dp, &
  &    10.20776260081896680_dp,    37.37225322309888043_dp,    11.82844927012503966_dp,    38.23310085983992224_dp, &
  &    13.32599718132065725_dp,    39.24124360712293225_dp,    14.67674963753560391_dp,    40.38330297070848474_dp, &
  &    15.85624296375187114_dp,    41.64376435793402464_dp,    16.83902541924944174_dp,    43.00496062724707258_dp, &
  &    17.59853603019003998_dp,    44.44702279967973624_dp,    18.10711920596712687_dp,    45.94779768044404733_dp, &
  &    18.33628744864260796_dp,    47.48274104170998555_dp,    18.25738892575703076_dp,    49.02480894996942595_dp, &
  &    17.84288249522569458_dp,    50.54439040009851425_dp,    17.06845153476416499_dp,    52.00935252683229493_dp, &
  &    15.91616209561277273_dp,    53.38530347804498888_dp,    14.37873026754043870_dp,    54.63620962052475960_dp, &
  &    12.46463908845756130_dp,    55.72551502002679058_dp,    10.20331014929099922_dp,    56.61787273415653488_dp, &
  &     7.64890062321653019_dp,    57.28147795233979167_dp,     4.88089731877776067_dp,    57.69078537163564846_dp, &
  &     2.00000000000000222_dp,    60.26295411645657651_dp,    -1.52099396835736300_dp,    60.10440004572244277_dp, &
  &    -4.89637618755807136_dp,    59.63591573610307250_dp,    -7.99912115224313958_dp,    58.87795079119066344_dp, &
  &   -10.73370655373201643_dp,    57.86135900031617751_dp,   -13.04067793585433499_dp,    56.62367212326139310_dp, &
  &   -14.89384545876526111_dp,    55.20548791890712437_dp,   -16.29319722451073105_dp,    53.64760968250063655_dp, &
  &   -17.25667322722224029_dp,    51.98914605534769606_dp,   -17.81285996059914467_dp,    50.26647329190694080_dp, &
  &   -17.99546453290829007_dp,    48.51282952087984768_dp,   -17.83961562141898938_dp,    46.75830290430587155_dp, &
  &   -17.37966075266355759_dp,    45.03002540480565585_dp,   -16.64804001511417297_dp,    43.35244484209054860_dp, &
  &   -15.67486490585672243_dp,    41.74759899443786537_dp,   -14.48792157318536411_dp,    40.23535159216241652_dp  ]
  lonlat(  361:  480) = [ &
  &   -13.11290455740948957_dp,    38.83357308646102979_dp,   -11.57375501535206475_dp,    37.55826279697890158_dp, &
  &    -9.89302536639832653_dp,    36.42361680044041350_dp,    -8.09222434325374884_dp,    35.44205010622848562_dp, &
  &    -6.19211732580419838_dp,    34.62418375193039566_dp,    -4.21297051898843300_dp,    33.97880825794451454_dp, &
  &    -2.17473678976558649_dp,    33.51283479810019372_dp,    -0.09718755711549092_dp,    33.23124463343540214_dp, &
  &     1.99999999999999889_dp,    33.13704588354342917_dp,     4.09718755711548877_dp,    33.23124463343540214_dp, &
  &     6.17473678976558382_dp,    33.51283479810019372_dp,     8.21297051898843122_dp,    33.97880825794451454_dp, &
  &    10.19211732580419572_dp,    34.62418375193039566_dp,    12.09222434325374707_dp,    35.44205010622848562_dp, &
  &    13.89302536639832830_dp,    36.42361680044041350_dp,    15.57375501535206297_dp,    37.55826279697889447_dp, &
  &    17.11290455740948602_dp,    38.83357308646102268_dp,    18.48792157318536766_dp,    40.23535159216240942_dp, &
  &    19.67486490585671888_dp,    41.74759899443786537_dp,    20.64804001511417653_dp,    43.35244484209054860_dp, &
  &    21.37966075266355404_dp,    45.03002540480565585_dp,    21.83961562141898582_dp,    46.75830290430587155_dp, &
  &    21.99546453290829007_dp,    48.51282952087984768_dp,    21.81285996059914822_dp,    50.26647329190694080_dp, &
  &    21.25667322722224739_dp,    51.98914605534769606_dp,    20.29319722451073105_dp,    53.64760968250062234_dp, &
  &    18.89384545876525934_dp,    55.20548791890712437_dp,    17.04067793585434032_dp,    56.62367212326139310_dp, &
  &    14.73370655373202354_dp,    57.86135900031617751_dp,    11.99912115224314491_dp,    58.87795079119066344_dp, &
  &     8.89637618755807580_dp,    59.63591573610307250_dp,     5.52099396835736744_dp,    60.10440004572244277_dp, &
  &     2.00000000000000222_dp,    62.75242980718265784_dp,    -1.60371952785031557_dp,    62.62270582496653049_dp, &
  &    -5.08984714396560278_dp,    62.23829052070698253_dp,    -8.35401191716921510_dp,    61.61281120273996237_dp, &
  &   -11.31471471060360656_dp,    60.76704034614787986_dp,   -13.91751559979281083_dp,    59.72658657388572578_dp, &
  &   -16.13405311103923978_dp,    58.51955862209560166_dp,   -17.95764487214750815_dp,    57.17460858105235388_dp, &
  &   -19.39751805719553701_dp,    55.71953428872550518_dp,   -20.47321926655622448_dp,    54.18043392376822709_dp, &
  &   -21.21002592824931199_dp,    52.58130404832083116_dp,   -21.63559425749199150_dp,    50.94394459368972150_dp, &
  &   -21.77773936992417703_dp,    49.28804930270956675_dp,   -21.66310777053267600_dp,    47.63139077670034283_dp, &
  &   -21.31648826424519072_dp,    45.99003977573201496_dp,   -20.76054697060167342_dp,    44.37858250245571412_dp, &
  &   -20.01582559662803007_dp,    42.81031632956308641_dp,   -19.10089088783405842_dp,    41.29741507659190347_dp, &
  &   -18.03256121225549791_dp,    39.85106125278488065_dp,   -16.82616341777592339_dp,    38.48154618161254348_dp, &
  &   -15.49579145727241247_dp,    37.19834072287546434_dp,   -14.05455017155123087_dp,    36.01014014726423795_dp, &
  &   -12.51477509868480809_dp,    34.92488704934376642_dp,   -10.88822378743807739_dp,    33.94977626735131793_dp, &
  &    -9.18623692372254119_dp,    33.09124574576954103_dp,    -7.41986936545087783_dp,    32.35495718584156322_dp, &
  &    -5.59999239238874669_dp,    31.74577019145995394_dp,    -3.73736939611796615_dp,    31.26771342119434749_dp  ]
  lonlat(  481:  600) = [ &
  &    -1.84270801296844233_dp,    30.92395598105918353_dp,     0.07330759755401026_dp,    30.71678191817960268_dp, &
  &     1.99999999999999889_dp,    30.64757019281734074_dp,     3.92669240244598639_dp,    30.71678191817960268_dp, &
  &     5.84270801296843878_dp,    30.92395598105918353_dp,     7.73736939611796526_dp,    31.26771342119434749_dp, &
  &     9.59999239238874225_dp,    31.74577019145995394_dp,    11.41986936545087516_dp,    32.35495718584156322_dp, &
  &    13.18623692372254119_dp,    33.09124574576954103_dp,    14.88822378743807207_dp,    33.94977626735131793_dp, &
  &    16.51477509868480809_dp,    34.92488704934376642_dp,    18.05455017155123087_dp,    36.01014014726423795_dp, &
  &    19.49579145727241070_dp,    37.19834072287546434_dp,    20.82616341777592339_dp,    38.48154618161253637_dp, &
  &    22.03256121225549791_dp,    39.85106125278488065_dp,    23.10089088783405842_dp,    41.29741507659190347_dp, &
  &    24.01582559662803007_dp,    42.81031632956308641_dp,    24.76054697060167342_dp,    44.37858250245571412_dp, &
  &    25.31648826424519072_dp,    45.99003977573201496_dp,    25.66310777053267600_dp,    47.63139077670033572_dp, &
  &    25.77773936992417703_dp,    49.28804930270955964_dp,    25.63559425749199505_dp,    50.94394459368972150_dp, &
  &    25.21002592824931199_dp,    52.58130404832083116_dp,    24.47321926655622448_dp,    54.18043392376822709_dp, &
  &    23.39751805719553701_dp,    55.71953428872550518_dp,    21.95764487214750460_dp,    57.17460858105235388_dp, &
  &    20.13405311103924333_dp,    58.51955862209560166_dp,    17.91751559979281438_dp,    59.72658657388572578_dp, &
  &    15.31471471060361011_dp,    60.76704034614787986_dp,    12.35401191716921865_dp,    61.61281120273996237_dp, &
  &     9.08984714396560634_dp,    62.23829052070698253_dp,     5.60371952785031979_dp,    62.62270582496653049_dp, &
  &     2.00000000000000311_dp,    65.30899890463146562_dp,    -2.55165837938126616_dp,    65.14506774788591770_dp, &
  &    -6.91821393310037980_dp,    64.66099291349783584_dp,   -10.94248311853021427_dp,    63.87850997409253040_dp, &
  &   -14.51323316925390294_dp,    62.82970044453450953_dp,   -17.56939664790982292_dp,    61.55243525845713748_dp, &
  &   -20.09325961331439458_dp,    60.08625295311978931_dp,   -22.09844461997003506_dp,    58.46939890910893922_dp, &
  &   -23.61769060836897438_dp,    56.73712764036461920_dp,   -24.69307609487012556_dp,    54.92100894435518654_dp, &
  &   -25.36933297612858951_dp,    53.04888396821036167_dp,   -25.68983696232584535_dp,    51.14517010976478417_dp, &
  &   -25.69453569648834801_dp,    49.23130925676766623_dp,   -25.41912613625677153_dp,    47.32623888788154431_dp, &
  &   -24.89496528133907205_dp,    45.44682484300304282_dp,   -24.14937074714975296_dp,    43.60823042135866956_dp, &
  &   -23.20610004359021517_dp,    41.82421587722975431_dp,   -22.08588698105332782_dp,    40.10737174655498194_dp, &
  &   -20.80696969977402944_dp,    38.46929323359992736_dp,   -19.38557795842460507_dp,    36.92070387379718710_dp, &
  &   -17.83636590786354148_dp,    35.47153642700349963_dp,   -16.17278641740254130_dp,    34.13097826525054046_dp, &
  &   -14.40740784814351017_dp,    32.90748779465315721_dp,   -12.55217628249286932_dp,    31.80878785141789677_dp, &
  &   -10.61862699669389443_dp,    30.84184157026976436_dp,    -8.61804920168179045_dp,    30.01281590885307438_dp, &
  &    -6.56160821625925728_dp,    29.32703776203888069_dp,    -4.46042949045145676_dp,    28.78894734383437992_dp  ]
  lonlat(  601:  720) = [ &
  &    -2.32564933647368921_dp,    28.40205318377053345_dp,    -0.16843782661930862_dp,    28.16889262543881500_dp, &
  &     1.99999999999999889_dp,    28.09100109536852585_dp,     4.16843782661930629_dp,    28.16889262543881500_dp, &
  &     6.32564933647368743_dp,    28.40205318377053345_dp,     8.46042949045145498_dp,    28.78894734383437992_dp, &
  &    10.56160821625925372_dp,    29.32703776203888069_dp,    12.61804920168178867_dp,    30.01281590885307438_dp, &
  &    14.61862699669389265_dp,    30.84184157026976436_dp,    16.55217628249286577_dp,    31.80878785141789677_dp, &
  &    18.40740784814351017_dp,    32.90748779465315721_dp,    20.17278641740253775_dp,    34.13097826525054046_dp, &
  &    21.83636590786353793_dp,    35.47153642700349963_dp,    23.38557795842460152_dp,    36.92070387379718710_dp, &
  &    24.80696969977402588_dp,    38.46929323359992026_dp,    26.08588698105332426_dp,    40.10737174655498194_dp, &
  &    27.20610004359021161_dp,    41.82421587722975431_dp,    28.14937074714974941_dp,    43.60823042135866956_dp, &
  &    28.89496528133906494_dp,    45.44682484300304282_dp,    29.41912613625676798_dp,    47.32623888788153721_dp, &
  &    29.69453569648834446_dp,    49.23130925676766623_dp,    29.68983696232584180_dp,    51.14517010976478417_dp, &
  &    29.36933297612858951_dp,    53.04888396821034746_dp,    28.69307609487012911_dp,    54.92100894435518654_dp, &
  &    27.61769060836897438_dp,    56.73712764036461920_dp,    26.09844461997003506_dp,    58.46939890910893922_dp, &
  &    24.09325961331439814_dp,    60.08625295311978931_dp,    21.56939664790982292_dp,    61.55243525845713748_dp, &
  &    18.51323316925390827_dp,    62.82970044453450953_dp,    14.94248311853021960_dp,    63.87850997409253040_dp, &
  &    10.91821393310038779_dp,    64.66099291349783584_dp,     6.55165837938127193_dp,    65.14506774788591770_dp, &
  &     2.00000000000000400_dp,    67.94514236453578349_dp,    -3.38533547682125890_dp,    67.76325974975715383_dp, &
  &    -8.52326664933801226_dp,    67.22759281764989225_dp,   -13.21138564172178143_dp,    66.36584339331807314_dp, &
  &   -17.31841683118042496_dp,    65.21781824976642383_dp,   -20.78586461017365750_dp,    63.82887077001763032_dp, &
  &   -23.61278608277912383_dp,    62.24449065808524040_dp,   -25.83517004248913196_dp,    60.50690475312734407_dp, &
  &   -27.50782877801382043_dp,    58.65352526302899605_dp,   -28.69170289014789077_dp,    56.71665696607985296_dp, &
  &   -29.44632120220701665_dp,    54.72388646563504011_dp,   -29.82602201650912477_dp,    52.69875031809839783_dp, &
  &   -29.87852862440772839_dp,    50.66145188613276673_dp,   -29.64483525740958925_dp,    48.62951713112133945_dp, &
  &   -29.15973753507462618_dp,    46.61834908938176625_dp,   -28.45262246278107554_dp,    44.64167567492752653_dp, &
  &   -27.54831327014242959_dp,    42.71190039889389567_dp,   -26.46787020033523774_dp,    40.84037031204417190_dp, &
  &   -25.22930648122764552_dp,    39.03757551632936185_dp,   -23.84820859564655038_dp,    37.31329283883029291_dp, &
  &   -22.33826403031283903_dp,    35.67668409468497970_dp,   -20.71170528699355629_dp,    34.13635737784334623_dp, &
  &   -18.97968026705781242_dp,    32.70039821822412307_dp,   -17.15255849246134900_dp,    31.37637626233231813_dp, &
  &   -15.24018123567453742_dp,    30.17133232687284305_dp,   -13.25206214192900944_dp,    29.09175016726920759_dp, &
  &   -11.19754366142445079_dp,    28.14351701208745027_dp,    -9.08591371200913400_dp,    27.33187675649334381_dp  ]
  lonlat(  721:  840) = [ &
  &    -6.92648650789847675_dp,    26.66137960320710931_dp,    -4.72865139696445702_dp,    26.13583181560235502_dp, &
  &    -2.50189378344492486_dp,    25.75824904385734371_dp,    -0.25579267831605296_dp,    25.53081635683327733_dp, &
  &     1.99999999999999889_dp,    25.45485763546421154_dp,     4.25579267831605002_dp,    25.53081635683327733_dp, &
  &     6.50189378344492308_dp,    25.75824904385734371_dp,     8.72865139696445347_dp,    26.13583181560235502_dp, &
  &    10.92648650789847764_dp,    26.66137960320710931_dp,    13.08591371200913400_dp,    27.33187675649334381_dp, &
  &    15.19754366142444724_dp,    28.14351701208745027_dp,    17.25206214192900589_dp,    29.09175016726920759_dp, &
  &    19.24018123567453742_dp,    30.17133232687284305_dp,    21.15255849246134545_dp,    31.37637626233231813_dp, &
  &    22.97968026705781242_dp,    32.70039821822412307_dp,    24.71170528699354918_dp,    34.13635737784334623_dp, &
  &    26.33826403031282837_dp,    35.67668409468497259_dp,    27.84820859564654683_dp,    37.31329283883029291_dp, &
  &    29.22930648122764197_dp,    39.03757551632935474_dp,    30.46787020033523419_dp,    40.84037031204417190_dp, &
  &    31.54831327014242248_dp,    42.71190039889389567_dp,    32.45262246278107199_dp,    44.64167567492752653_dp, &
  &    33.15973753507462618_dp,    46.61834908938176625_dp,    33.64483525740958214_dp,    48.62951713112133945_dp, &
  &    33.87852862440772839_dp,    50.66145188613276673_dp,    33.82602201650912122_dp,    52.69875031809839783_dp, &
  &    33.44632120220701665_dp,    54.72388646563502590_dp,    32.69170289014788011_dp,    56.71665696607985296_dp, &
  &    31.50782877801381687_dp,    58.65352526302899605_dp,    29.83517004248913906_dp,    60.50690475312734407_dp, &
  &    27.61278608277913094_dp,    62.24449065808524040_dp,    24.78586461017366460_dp,    63.82887077001763032_dp, &
  &    21.31841683118043562_dp,    65.21781824976642383_dp,    17.21138564172179031_dp,    66.36584339331807314_dp, &
  &    12.52326664933801936_dp,    67.22759281764989225_dp,     7.38533547682126645_dp,    67.76325974975715383_dp, &
  &     2.00000000000000488_dp,    70.67459026401789401_dp,    -4.83336207267744200_dp,    70.44359392189112157_dp, &
  &   -11.25145387811900299_dp,    69.76794994271870110_dp,   -16.94303945184942606_dp,    68.69426490502790728_dp, &
  &   -21.74696599568290978_dp,    67.28571148577093197_dp,   -25.63456841105837825_dp,    65.60910965714572285_dp, &
  &   -28.66225471925319823_dp,    63.72633555655123416_dp,   -30.92626834358740595_dp,    61.69055635034530383_dp, &
  &   -32.53242307522426557_dp,    59.54571651024583190_dp,   -33.58017141013023377_dp,    57.32758829402004608_dp, &
  &   -34.15616674923442986_dp,    55.06530104282313687_dp,   -34.33296113360040636_dp,    52.78282385843581892_dp, &
  &   -34.17004600591189956_dp,    50.50021197832979425_dp,   -33.71572773969587900_dp,    48.23458650173874673_dp, &
  &   -33.00911969333094476_dp,    46.00087796034757304_dp,   -32.08195470333168231_dp,    43.81237943576640248_dp, &
  &   -30.96012666362175025_dp,    41.68115224019865650_dp,   -29.66495985223924237_dp,    39.61831917500947498_dp, &
  &   -28.21423852322426740_dp,    37.63427208010365632_dp,   -26.62303747247054986_dp,    35.73881343521247089_dp, &
  &   -24.90439178940930276_dp,    33.94124647006630369_dp,   -23.06983782140640216_dp,    32.25042441190934994_dp, &
  &   -21.12985059268007149_dp,    30.67476685924403057_dp,   -19.09419678103115459_dp,    29.22224954465700009_dp  ]
  lonlat(  841:  960) = [ &
  &   -16.97221728412494457_dp,    27.90037270541385794_dp,   -14.77304947679039238_dp,    26.71611272875198750_dp, &
  &   -12.50579641562138100_dp,    25.67586152120415832_dp,   -10.17964838758363832_dp,    24.78535803035031648_dp, &
  &    -7.80396120930039583_dp,    24.04961640006232315_dp,    -5.38829543151647705_dp,    23.47285525677743223_dp, &
  &    -2.94242093509331726_dp,    23.05843251151437201_dp,    -0.47629214130109782_dp,    22.80878975038074685_dp, &
  &     1.99999999999999800_dp,    22.72540973598210812_dp,     4.47629214130109521_dp,    22.80878975038074685_dp, &
  &     6.94242093509331326_dp,    23.05843251151437201_dp,     9.38829543151647350_dp,    23.47285525677743223_dp, &
  &    11.80396120930039316_dp,    24.04961640006232315_dp,    14.17964838758363655_dp,    24.78535803035031648_dp, &
  &    16.50579641562137567_dp,    25.67586152120415832_dp,    18.77304947679039060_dp,    26.71611272875198750_dp, &
  &    20.97221728412493746_dp,    27.90037270541385439_dp,    23.09419678103115103_dp,    29.22224954465700009_dp, &
  &    25.12985059268006793_dp,    30.67476685924402702_dp,    27.06983782140639860_dp,    32.25042441190934994_dp, &
  &    28.90439178940930631_dp,    33.94124647006630369_dp,    30.62303747247054275_dp,    35.73881343521246379_dp, &
  &    32.21423852322426029_dp,    37.63427208010365632_dp,    33.66495985223924237_dp,    39.61831917500946787_dp, &
  &    34.96012666362174315_dp,    41.68115224019865650_dp,    36.08195470333167520_dp,    43.81237943576640248_dp, &
  &    37.00911969333093765_dp,    46.00087796034757304_dp,    37.71572773969587189_dp,    48.23458650173873252_dp, &
  &    38.17004600591188535_dp,    50.50021197832979425_dp,    38.33296113360039925_dp,    52.78282385843581892_dp, &
  &    38.15616674923441565_dp,    55.06530104282313687_dp,    37.58017141013023377_dp,    57.32758829402004608_dp, &
  &    36.53242307522427268_dp,    59.54571651024581769_dp,    34.92626834358741661_dp,    61.69055635034530383_dp, &
  &    32.66225471925319823_dp,    63.72633555655123416_dp,    29.63456841105838535_dp,    65.60910965714572285_dp, &
  &    25.74696599568291333_dp,    67.28571148577093197_dp,    20.94303945184943316_dp,    68.69426490502790728_dp, &
  &    15.25145387811901188_dp,    69.76794994271870110_dp,     8.83336207267745088_dp,    70.44359392189112157_dp, &
  &     2.00000000000000622_dp,    73.51255823132638056_dp,    -6.80643587234800940_dp,    73.21444539538327945_dp, &
  &   -14.87413258170036379_dp,    72.35214877025040892_dp,   -21.72462936947633594_dp,    71.00751554077180572_dp, &
  &   -27.20553396293055215_dp,    69.28213523998356038_dp,   -31.39257932570032139_dp,    67.27265449907143591_dp, &
  &   -34.46283411458643542_dp,    65.05952649321666570_dp,   -36.61111913565843423_dp,    62.70556553816149403_dp, &
  &   -38.01204327449661236_dp,    60.25870541573158334_dp,   -38.80901819915838047_dp,    57.75559962131574565_dp, &
  &   -39.11518954384546731_dp,    55.22475594928482678_dp,   -39.01828312042780311_dp,    52.68892136253921876_dp, &
  &   -38.58594887503603132_dp,    50.16679739569313057_dp,   -37.87042151784342536_dp,    47.67424596736638875_dp, &
  &   -36.91224672041000332_dp,    45.22513042719018728_dp,   -35.74315247327934486_dp,    42.83190113242096686_dp, &
  &   -34.38823113470312620_dp,    40.50600232791481403_dp,   -32.86759479425492714_dp,    38.25815259440047811_dp, &
  &   -31.19763777135731431_dp,    36.09853399317181299_dp,   -29.39200856069424006_dp,    34.03691345955112979_dp  ]
  lonlat(  961: 1080) = [ &
  &   -27.46236656888655148_dp,    32.08271233019573287_dp,   -25.41897786066869003_dp,    30.24503490367625247_dp, &
  &   -23.27118821325056430_dp,    28.53266378578365448_dp,   -21.02780000980340347_dp,    26.95402789495273055_dp, &
  &   -18.69737092792362887_dp,    25.51714801636046559_dp,   -16.28844626261447814_dp,    24.22956442487017625_dp, &
  &   -13.80973254683687124_dp,    23.09825113914620331_dp,   -11.27021753707410845_dp,    22.12952164603582617_dp, &
  &    -8.67924035399200910_dp,    21.32893128539883065_dp,    -6.04651538477557082_dp,    20.70118176192879744_dp, &
  &    -3.38211423303386649_dp,    20.25003331964319386_dp,    -0.69641128035122979_dp,    19.97822987242789239_dp, &
  &     1.99999999999999756_dp,    19.88744176867360025_dp,     4.69641128035122613_dp,    19.97822987242789239_dp, &
  &     7.38211423303386205_dp,    20.25003331964319386_dp,    10.04651538477556727_dp,    20.70118176192879744_dp, &
  &    12.67924035399200378_dp,    21.32893128539883065_dp,    15.27021753707410667_dp,    22.12952164603582617_dp, &
  &    17.80973254683686946_dp,    23.09825113914620331_dp,    20.28844626261447814_dp,    24.22956442487017270_dp, &
  &    22.69737092792362532_dp,    25.51714801636046559_dp,    25.02780000980339992_dp,    26.95402789495272700_dp, &
  &    27.27118821325056786_dp,    28.53266378578365448_dp,    29.41897786066868292_dp,    30.24503490367624536_dp, &
  &    31.46236656888655503_dp,    32.08271233019573287_dp,    33.39200856069423651_dp,    34.03691345955112979_dp, &
  &    35.19763777135730720_dp,    36.09853399317180589_dp,    36.86759479425493424_dp,    38.25815259440047811_dp, &
  &    38.38823113470313331_dp,    40.50600232791481403_dp,    39.74315247327934486_dp,    42.83190113242095975_dp, &
  &    40.91224672041000332_dp,    45.22513042719018728_dp,    41.87042151784342536_dp,    47.67424596736638165_dp, &
  &    42.58594887503603132_dp,    50.16679739569313057_dp,    43.01828312042781022_dp,    52.68892136253921876_dp, &
  &    43.11518954384546731_dp,    55.22475594928482678_dp,    42.80901819915838757_dp,    57.75559962131573144_dp, &
  &    42.01204327449661946_dp,    60.25870541573157624_dp,    40.61111913565844134_dp,    62.70556553816149403_dp, &
  &    38.46283411458643542_dp,    65.05952649321666570_dp,    35.39257932570031784_dp,    67.27265449907143591_dp, &
  &    31.20553396293055926_dp,    69.28213523998356038_dp,    25.72462936947633949_dp,    71.00751554077180572_dp, &
  &    18.87413258170037267_dp,    72.35214877025040892_dp,    10.80643587234802361_dp,    73.21444539538327945_dp, &
  &     2.00000000000000844_dp,    76.47602837656471308_dp,    -9.67376613190775814_dp,    76.07990221077976400_dp, &
  &   -19.91726594386999949_dp,    74.95625177955801632_dp,   -28.02735732207738550_dp,    73.25702648451857613_dp, &
  &   -34.02194152863378918_dp,    71.14627956201684356_dp,   -38.25028545833758642_dp,    68.75766348420627594_dp, &
  &   -41.10709162054251209_dp,    66.18773615332521842_dp,   -42.92334661203305757_dp,    63.50367340927638793_dp, &
  &   -43.94927569193657035_dp,    60.75248226909388904_dp,   -44.36709840828364548_dp,    57.96800639328736793_dp, &
  &   -44.30826862884845241_dp,    55.17560336970880286_dp,   -43.86791757533286074_dp,    52.39514197266055362_dp, &
  &   -43.11549450115907689_dp,    49.64291142290011294_dp,   -42.10226597817306526_dp,    46.93284831506371546_dp, &
  &   -40.86653894639825779_dp,    44.27733603455973110_dp,   -39.43731045663169965_dp,    41.68773239540036002_dp  ]
  lonlat( 1081: 1200) = [ &
  &   -37.83684688715485578_dp,    39.17472027603687934_dp,   -36.08253581911941410_dp,    36.74853923728758076_dp, &
  &   -34.18824090805679816_dp,    34.41913389699746517_dp,   -32.16531367916817885_dp,    32.19624133969532664_dp, &
  &   -30.02336509370288198_dp,    30.08943159705432890_dp,   -27.77086550998262382_dp,    28.10811023218007776_dp, &
  &   -25.41561850057673411_dp,    26.26148912292403992_dp,   -22.96513811238918379_dp,    24.55852997196868515_dp, &
  &   -20.42694818201796281_dp,    23.00786444863284785_dp,   -17.80881477377849720_dp,    21.61769490666709714_dp, &
  &   -15.11891780975726896_dp,    20.39568010883170501_dp,   -12.36596498789072740_dp,    19.34881113120014717_dp, &
  &    -9.55924980839402672_dp,    18.48328342761256593_dp,    -6.70865569654629645_dp,    17.80437171431731613_dp, &
  &    -3.82460955068694286_dp,    17.31631470128239414_dp,    -0.91799021933643277_dp,    17.02221659443388191_dp, &
  &     1.99999999999999756_dp,    16.92397162343524286_dp,     4.91799021933642866_dp,    17.02221659443388191_dp, &
  &     7.82460955068693664_dp,    17.31631470128239414_dp,    10.70865569654629290_dp,    17.80437171431731613_dp, &
  &    13.55924980839402139_dp,    18.48328342761256593_dp,    16.36596498789072740_dp,    19.34881113120014717_dp, &
  &    19.11891780975726363_dp,    20.39568010883170501_dp,    21.80881477377850075_dp,    21.61769490666709714_dp, &
  &    24.42694818201795925_dp,    23.00786444863284430_dp,    26.96513811238918024_dp,    24.55852997196867804_dp, &
  &    29.41561850057672345_dp,    26.26148912292403637_dp,    31.77086550998261671_dp,    28.10811023218007065_dp, &
  &    34.02336509370287132_dp,    30.08943159705432180_dp,    36.16531367916817885_dp,    32.19624133969532664_dp, &
  &    38.18824090805679106_dp,    34.41913389699745807_dp,    40.08253581911941410_dp,    36.74853923728758076_dp, &
  &    41.83684688715484867_dp,    39.17472027603687934_dp,    43.43731045663169255_dp,    41.68773239540036002_dp, &
  &    44.86653894639826490_dp,    44.27733603455973110_dp,    46.10226597817306526_dp,    46.93284831506371546_dp, &
  &    47.11549450115907689_dp,    49.64291142290011294_dp,    47.86791757533286784_dp,    52.39514197266055362_dp, &
  &    48.30826862884845951_dp,    55.17560336970880286_dp,    48.36709840828365259_dp,    57.96800639328736793_dp, &
  &    47.94927569193657746_dp,    60.75248226909387483_dp,    46.92334661203305757_dp,    63.50367340927638793_dp, &
  &    45.10709162054252630_dp,    66.18773615332521842_dp,    42.25028545833760063_dp,    68.75766348420627594_dp, &
  &    38.02194152863379628_dp,    71.14627956201684356_dp,    32.02735732207738550_dp,    73.25702648451857613_dp, &
  &    23.91726594387000659_dp,    74.95625177955801632_dp,    13.67376613190777590_dp,    76.07990221077976400_dp, &
  &     2.00000000000001155_dp,    79.58407807962322522_dp,   -14.24038894313819092_dp,    79.03039199474196153_dp, &
  &   -27.34759503822197502_dp,    77.51867325981696411_dp,   -36.54693285975560713_dp,    75.34972495190746145_dp, &
  &   -42.57629367046713753_dp,    72.78039612779681988_dp,   -46.37308749001456221_dp,    69.97672254379963874_dp, &
  &   -48.64383991815974895_dp,    67.03853932314146391_dp,   -49.85773173662808233_dp,    64.02688869849654907_dp, &
  &   -50.31863539857851464_dp,    60.98111330635318694_dp,   -50.22511448054331140_dp,    57.92830381592441569_dp, &
  &   -49.70950811496560107_dp,    54.88845672164920586_dp,   -48.86197695521289575_dp,    51.87735585154322138_dp  ]
  lonlat( 1201: 1320) = [ &
  &   -47.74524369263553325_dp,    48.90823812634897649_dp,   -46.40377244059971673_dp,    45.99279145534946167_dp, &
  &   -44.86961926381133026_dp,    43.14177213432515856_dp,   -43.16626004327478228_dp,    40.36539642075791789_dp, &
  &   -41.31116510791174079_dp,    37.67359181604234664_dp,   -39.31758136998610098_dp,    35.07615645611910082_dp, &
  &   -37.19580324741198041_dp,    32.58285444844916867_dp,   -34.95410730493897233_dp,    30.20346328869343466_dp, &
  &   -32.59946098845734497_dp,    27.94778271439298933_dp,   -30.13807554901531915_dp,    25.82561045671564770_dp, &
  &   -27.57584735879238025_dp,    23.84668824688734645_dp,   -24.91871466466540852_dp,    22.02062053097340311_dp, &
  &   -22.17294518233925871_dp,    20.35676830949395466_dp,   -19.34536199373425802_dp,    18.86412113035556004_dp, &
  &   -16.44350999615492270_dp,    17.55115134744557182_dp,   -13.47576217013061850_dp,    16.42565612762181360_dp, &
  &   -10.45136393475438830_dp,    15.49459412897927280_dp,    -7.38041466390653600_dp,    14.76392503362292707_dp, &
  &    -4.27378779825515664_dp,    14.23846093632396936_dp,    -1.14299451095196525_dp,    13.92173872937387458_dp, &
  &     1.99999999999999756_dp,    13.81592192037676980_dp,     5.14299451095195970_dp,    13.92173872937387458_dp, &
  &     8.27378779825515132_dp,    14.23846093632396936_dp,    11.38041466390652978_dp,    14.76392503362292707_dp, &
  &    14.45136393475438119_dp,    15.49459412897927280_dp,    17.47576217013061495_dp,    16.42565612762181360_dp, &
  &    20.44350999615491560_dp,    17.55115134744557182_dp,    23.34536199373425447_dp,    18.86412113035556004_dp, &
  &    26.17294518233925515_dp,    20.35676830949395466_dp,    28.91871466466540852_dp,    22.02062053097340311_dp, &
  &    31.57584735879237314_dp,    23.84668824688734645_dp,    34.13807554901531205_dp,    25.82561045671564415_dp, &
  &    36.59946098845733786_dp,    27.94778271439298933_dp,    38.95410730493897233_dp,    30.20346328869342756_dp, &
  &    41.19580324741196620_dp,    32.58285444844916867_dp,    43.31758136998610098_dp,    35.07615645611910082_dp, &
  &    45.31116510791174079_dp,    37.67359181604234664_dp,    47.16626004327477517_dp,    40.36539642075791789_dp, &
  &    48.86961926381131605_dp,    43.14177213432515856_dp,    50.40377244059970963_dp,    45.99279145534945457_dp, &
  &    51.74524369263552614_dp,    48.90823812634896228_dp,    52.86197695521290285_dp,    51.87735585154322138_dp, &
  &    53.70950811496559396_dp,    54.88845672164920586_dp,    54.22511448054331140_dp,    57.92830381592441569_dp, &
  &    54.31863539857851464_dp,    60.98111330635318694_dp,    53.85773173662808233_dp,    64.02688869849654907_dp, &
  &    52.64383991815974895_dp,    67.03853932314146391_dp,    50.37308749001457642_dp,    69.97672254379963874_dp, &
  &    46.57629367046714464_dp,    72.78039612779681988_dp,    40.54693285975561423_dp,    75.34972495190746145_dp, &
  &    31.34759503822198212_dp,    77.51867325981696411_dp,    18.24038894313820691_dp,    79.03039199474196153_dp, &
  &     2.00000000000001998_dp,    82.85826214470431239_dp,   -22.58690897303193523_dp,    82.01033616765489853_dp, &
  &   -38.96575654499159924_dp,    79.88802174923017674_dp,   -48.17735288037921038_dp,    77.11452529323827321_dp, &
  &   -53.18593275925196195_dp,    74.03707888623914357_dp,   -55.81801935702030448_dp,    70.81486693953937106_dp, &
  &   -57.03453256694833584_dp,    67.52503657439315532_dp,   -57.35114187047393841_dp,    64.20957103321012482_dp  ]
  lonlat( 1321: 1440) = [ &
  &   -57.05957379451162126_dp,    60.89430451319173443_dp,   -56.33378767939932885_dp,    57.59709162031844443_dp, &
  &   -55.28230228211860009_dp,    54.33161333463023368_dp,   -53.97533567047437231_dp,    51.10929358481432416_dp, &
  &   -52.45964870701570248_dp,    47.94033352757975308_dp,   -50.76707508825830928_dp,    44.83430401955754974_dp, &
  &   -48.91964996438991875_dp,    41.80050199367043007_dp,   -46.93282539675249154_dp,    38.84817223653459450_dp, &
  &   -44.81756887288366897_dp,    35.98664677769215103_dp,   -42.58178882927894193_dp,    33.22542941501406233_dp, &
  &   -40.23134383513492196_dp,    30.57423988556289629_dp,   -37.77078829775713587_dp,    28.04302503644353806_dp, &
  &   -35.20394762734520100_dp,    25.64194033091114022_dp,   -32.53437968696509586_dp,    23.38130282889364508_dp, &
  &   -29.76575655354334771_dp,    21.27151577227776258_dp,   -26.90218550361062810_dp,    19.32296477964254322_dp, &
  &   -23.94847769357362566_dp,    17.54588626406437513_dp,   -20.91036566952359976_dp,    15.95020993686824795_dp, &
  &   -17.79466590782826074_dp,    14.54537904344352306_dp,   -14.60937983520193661_dp,    13.34015413091371371_dp, &
  &   -11.36372621835939434_dp,    12.34240842556757833_dp,    -8.06809948196382720_dp,    11.55892497220584580_dp, &
  &    -4.73395228112668587_dp,    10.99520717814031734_dp,    -1.37360609917944543_dp,    10.65531494200142504_dp, &
  &     1.99999999999999756_dp,    10.54173785529561336_dp,     5.37360609917944032_dp,    10.65531494200142504_dp, &
  &     8.73395228112667965_dp,    10.99520717814031734_dp,    12.06809948196382187_dp,    11.55892497220584580_dp, &
  &    15.36372621835939078_dp,    12.34240842556757833_dp,    18.60937983520193484_dp,    13.34015413091371371_dp, &
  &    21.79466590782825364_dp,    14.54537904344352306_dp,    24.91036566952359621_dp,    15.95020993686824795_dp, &
  &    27.94847769357362210_dp,    17.54588626406437513_dp,    30.90218550361061745_dp,    19.32296477964254322_dp, &
  &    33.76575655354334060_dp,    21.27151577227776258_dp,    36.53437968696508875_dp,    23.38130282889363798_dp, &
  &    39.20394762734519389_dp,    25.64194033091114022_dp,    41.77078829775712165_dp,    28.04302503644353095_dp, &
  &    44.23134383513491485_dp,    30.57423988556289629_dp,    46.58178882927893483_dp,    33.22542941501406233_dp, &
  &    48.81756887288366187_dp,    35.98664677769215103_dp,    50.93282539675248444_dp,    38.84817223653458029_dp, &
  &    52.91964996438991164_dp,    41.80050199367041586_dp,    54.76707508825830928_dp,    44.83430401955754263_dp, &
  &    56.45964870701569538_dp,    47.94033352757973887_dp,    57.97533567047437231_dp,    51.10929358481431706_dp, &
  &    59.28230228211859298_dp,    54.33161333463023368_dp,    60.33378767939932885_dp,    57.59709162031844443_dp, &
  &    61.05957379451161415_dp,    60.89430451319173443_dp,    61.35114187047394552_dp,    64.20957103321012482_dp, &
  &    61.03453256694833584_dp,    67.52503657439315532_dp,    59.81801935702030448_dp,    70.81486693953937106_dp, &
  &    57.18593275925196906_dp,    74.03707888623914357_dp,    52.17735288037921038_dp,    77.11452529323827321_dp, &
  &    42.96575654499162056_dp,    79.88802174923017674_dp,    26.58690897303196721_dp,    82.01033616765489853_dp, &
  &     2.00000000000004352_dp,    86.32305404620944955_dp,   -41.28583165458979920_dp,    84.76914638163376026_dp, &
  &   -57.58131858106001744_dp,    81.70467639663135628_dp,   -63.56415050352948981_dp,    78.26774990878784877_dp  ]
  lonlat( 1441: 1560) = [ &
  &   -65.82714145548160900_dp,    74.71983727667711150_dp,   -66.41516373728856593_dp,    71.13755089586129543_dp, &
  &   -66.11115128919476547_dp,    67.55274433031233627_dp,   -65.27043361461275595_dp,    63.98289851135272244_dp, &
  &   -64.07470870335011170_dp,    60.43992354246546483_dp,   -62.62500642980751309_dp,    56.93332642202356197_dp, &
  &   -60.98089250042357889_dp,    53.47155025248752480_dp,   -59.17889520468775544_dp,    50.06261728049957327_dp, &
  &   -57.24193904387428233_dp,    46.71447239476329827_dp,   -55.18452370168171939_dp,    43.43518400478754415_dp, &
  &   -53.01574257648425004_dp,    40.23307020728445593_dp,   -50.74114071516557800_dp,    37.11678138456306897_dp, &
  &   -48.36392121341754802_dp,    34.09535373993877982_dp,   -45.88577372237665486_dp,    31.17824007995576707_dp, &
  &   -43.30747895739605013_dp,    28.37531978094453677_dp,   -40.62937881000767959_dp,    25.69688738457191945_dp, &
  &   -37.85176517580522670_dp,    23.15361781597290758_dp,   -34.97521854780547557_dp,    20.75650546647104377_dp, &
  &   -32.00091302933286386_dp,    18.51677422677156670_dp,   -28.93089420696503922_dp,    16.44575600838861718_dp, &
  &   -25.76832854644280602_dp,    14.55473640862136619_dp,   -22.51771689758312078_dp,    12.85476800444173051_dp, &
  &   -19.18506021909563941_dp,    11.35645428598744111_dp,   -15.77796305903055440_dp,    10.06971032975658353_dp, &
  &   -12.30566013367807265_dp,     9.00350968307662569_dp,    -8.77895396829167218_dp,     8.16563014493928918_dp, &
  &    -5.21005712455211789_dp,     7.56241362477411272_dp,    -1.61234064761579554_dp,     7.19855645524003407_dp, &
  &     1.99999999999999734_dp,     7.07694595379053126_dp,     5.61234064761579088_dp,     7.19855645524003407_dp, &
  &     9.21005712455211167_dp,     7.56241362477411272_dp,    12.77895396829166685_dp,     8.16563014493928918_dp, &
  &    16.30566013367807088_dp,     9.00350968307662569_dp,    19.77796305903055085_dp,    10.06971032975658353_dp, &
  &    23.18506021909563231_dp,    11.35645428598744111_dp,    26.51771689758312078_dp,    12.85476800444173051_dp, &
  &    29.76832854644280246_dp,    14.55473640862136619_dp,    32.93089420696504277_dp,    16.44575600838861718_dp, &
  &    36.00091302933286386_dp,    18.51677422677156670_dp,    38.97521854780546846_dp,    20.75650546647104022_dp, &
  &    41.85176517580521960_dp,    23.15361781597290403_dp,    44.62937881000767248_dp,    25.69688738457191590_dp, &
  &    47.30747895739604303_dp,    28.37531978094453322_dp,    49.88577372237665486_dp,    31.17824007995575997_dp, &
  &    52.36392121341754091_dp,    34.09535373993877982_dp,    54.74114071516557800_dp,    37.11678138456306897_dp, &
  &    57.01574257648425004_dp,    40.23307020728444883_dp,    59.18452370168172649_dp,    43.43518400478754415_dp, &
  &    61.24193904387428944_dp,    46.71447239476329827_dp,    63.17889520468774833_dp,    50.06261728049956616_dp, &
  &    64.98089250042356468_dp,    53.47155025248752480_dp,    66.62500642980749888_dp,    56.93332642202356197_dp, &
  &    68.07470870335012592_dp,    60.43992354246546483_dp,    69.27043361461275595_dp,    63.98289851135272244_dp, &
  &    70.11115128919477968_dp,    67.55274433031233627_dp,    70.41516373728855172_dp,    71.13755089586129543_dp, &
  &    69.82714145548160900_dp,    74.71983727667711150_dp,    67.56415050352947560_dp,    78.26774990878784877_dp, &
  &    61.58131858106001744_dp,    81.70467639663135628_dp,    45.28583165458984183_dp,    84.76914638163376026_dp  ]
  lonlat( 1561: 1680) = [ &
  &  -178.00000000002495426_dp,    89.99364961382421768_dp,   -86.04670840724655534_dp,    86.14286053253547948_dp, &
  &   -83.94730489861873934_dp,    82.29066165213360762_dp,   -81.87003129087820241_dp,    78.44836496333867615_dp, &
  &   -79.78661098119418682_dp,    74.62102007313750107_dp,   -77.68757690134611948_dp,    70.81379178736982283_dp, &
  &   -75.56653776770212971_dp,    67.03200075627314902_dp,   -73.41791965045068480_dp,    63.28116415502336878_dp, &
  &   -71.23639478559491067_dp,    59.56703711552955127_dp,   -69.01668877482984499_dp,    55.89565494125256606_dp, &
  &   -66.75350545455997064_dp,    52.27337593848611164_dp,   -64.44149951448400770_dp,    48.70692450151241104_dp, &
  &   -62.07527488350018530_dp,    45.20343384586799118_dp,   -59.64940188352277772_dp,    41.77048747717444854_dp, &
  &   -57.15845171105518574_dp,    38.41615810166682365_dp,   -54.59704918478396252_dp,    35.14904222145087687_dp, &
  &   -51.95994579953059400_dp,    31.97828811153562256_dp,   -49.24211556220075892_dp,    28.91361425616476666_dp, &
  &   -46.43887601207384819_dp,    25.96531465470105005_dp,   -43.54603622089217652_dp,    23.14424674184217068_dp, &
  &   -40.56007232189229228_dp,    20.46179708442632972_dp,   -37.47832910130670570_dp,    17.92981963683196156_dp, &
  &   -34.29924330014637945_dp,    15.56054131855884570_dp,   -31.02258051120933402_dp,    13.36643021383323848_dp, &
  &   -27.64967308093982012_dp,    11.36002298851478542_dp,   -24.18364165385173337_dp,     9.55371034930798224_dp, &
  &   -20.62957864939022201_dp,     7.95948261839810733_dp,   -16.99466904928961242_dp,     6.58864168091602309_dp, &
  &   -13.28822357553577405_dp,     5.45149036402020837_dp,    -9.52160273595813855_dp,     4.55701513369246669_dp, &
  &    -5.70801791517022217_dp,     3.91258202080964690_dp,    -1.86220744039441199_dp,     3.52366797872773274_dp, &
  &     1.99999999999999734_dp,     3.39364961385021413_dp,     5.86220744039440689_dp,     3.52366797872773274_dp, &
  &     9.70801791517021861_dp,     3.91258202080964690_dp,    13.52160273595813145_dp,     4.55701513369246669_dp, &
  &    17.28822357553576694_dp,     5.45149036402020837_dp,    20.99466904928960886_dp,     6.58864168091602309_dp, &
  &    24.62957864939021491_dp,     7.95948261839810733_dp,    28.18364165385172981_dp,     9.55371034930798224_dp, &
  &    31.64967308093981302_dp,    11.36002298851478542_dp,    35.02258051120933402_dp,    13.36643021383323848_dp, &
  &    38.29924330014637235_dp,    15.56054131855884570_dp,    41.47832910130669859_dp,    17.92981963683195801_dp, &
  &    44.56007232189227807_dp,    20.46179708442632261_dp,    47.54603622089216231_dp,    23.14424674184217068_dp, &
  &    50.43887601207384819_dp,    25.96531465470104649_dp,    53.24211556220075892_dp,    28.91361425616475955_dp, &
  &    55.95994579953058690_dp,    31.97828811153562256_dp,    58.59704918478396252_dp,    35.14904222145087687_dp, &
  &    61.15845171105517863_dp,    38.41615810166681655_dp,    63.64940188352278483_dp,    41.77048747717444854_dp, &
  &    66.07527488350018530_dp,    45.20343384586799118_dp,    68.44149951448399349_dp,    48.70692450151241104_dp, &
  &    70.75350545455997064_dp,    52.27337593848611164_dp,    73.01668877482984499_dp,    55.89565494125256606_dp, &
  &    75.23639478559491067_dp,    59.56703711552955127_dp,    77.41791965045068480_dp,    63.28116415502336878_dp, &
  &    79.56653776770211550_dp,    67.03200075627314902_dp,    81.68757690134611948_dp,    70.81379178736982283_dp  ]
  lonlat( 1681: 1800) = [ &
  &    83.78661098119418682_dp,    74.62102007313750107_dp,    85.87003129087820241_dp,    78.44836496333867615_dp, &
  &    87.94730489861875355_dp,    82.29066165213360762_dp,    90.04670840724658376_dp,    86.14286053253547948_dp, &
  &  -178.00000000000005684_dp,    86.05996156130565566_dp,  -130.58473801020662108_dp,    84.39088722277173815_dp, &
  &  -110.19717929614465390_dp,    81.10053146183230410_dp,  -100.10346048738929881_dp,    77.40995108179684792_dp, &
  &   -93.69886509454548218_dp,    73.59868574092435267_dp,   -88.93011750021230455_dp,    69.74815881341463353_dp, &
  &   -85.00534896567366161_dp,    65.89187266757556927_dp,   -81.55981529780905248_dp,    62.04795929474798299_dp, &
  &   -78.40205491898922219_dp,    58.22861013398448193_dp,   -75.42099130058548440_dp,    54.44347433172315220_dp, &
  &   -72.54676554128549526_dp,    50.70110112272598712_dp,   -69.73234087330638431_dp,    47.00963897352001908_dp, &
  &   -66.94410839385282941_dp,    43.37721635788606989_dp,   -64.15676435641834985_dp,    39.81217237539897269_dp, &
  &   -61.35037195723166548_dp,    36.32321005821970061_dp,   -58.50861449014277582_dp,    32.91950572923986584_dp, &
  &   -55.61773745881250619_dp,    29.61078975921034129_dp,   -52.66591251909912330_dp,    26.40740499964346810_dp, &
  &   -49.64287529119710030_dp,    23.32034407821754840_dp,   -46.53975201683548590_dp,    20.36126354510683711_dp, &
  &   -43.34902402209520034_dp,    17.54247066454981407_dp,   -40.06459700293881809_dp,    14.87687712846902599_dp, &
  &   -36.68195074563113423_dp,    12.37791309905906445_dp,   -33.19834740797973893_dp,    10.05939491571369260_dp, &
  &   -29.61307490596015057_dp,     7.93534078498541273_dp,   -25.92769777693465372_dp,     6.01973109672258389_dp, &
  &   -22.14628266758476371_dp,     4.32621388981253130_dp,   -18.27556116130716646_dp,     2.86776143955401652_dp, &
  &   -14.32499114491301384_dp,     1.65629062554436479_dp,   -10.30668142622437244_dp,     0.70226688878528098_dp, &
  &    -6.23515434659414680_dp,     0.01431798130227213_dp,    -2.12693783758673716_dp,    -0.40111214042971233_dp, &
  &     1.99999999999999689_dp,    -0.54003843869414525_dp,     6.12693783758673050_dp,    -0.40111214042971233_dp, &
  &    10.23515434659414147_dp,     0.01431798130227213_dp,    14.30668142622436712_dp,     0.70226688878528098_dp, &
  &    18.32499114491300318_dp,     1.65629062554436479_dp,    22.27556116130715580_dp,     2.86776143955401652_dp, &
  &    26.14628266758476016_dp,     4.32621388981253130_dp,    29.92769777693464306_dp,     6.01973109672258389_dp, &
  &    33.61307490596014702_dp,     7.93534078498541273_dp,    37.19834740797973183_dp,    10.05939491571369260_dp, &
  &    40.68195074563112001_dp,    12.37791309905905912_dp,    44.06459700293881809_dp,    14.87687712846902421_dp, &
  &    47.34902402209520034_dp,    17.54247066454981052_dp,    50.53975201683548590_dp,    20.36126354510683711_dp, &
  &    53.64287529119709319_dp,    23.32034407821754485_dp,    56.66591251909911620_dp,    26.40740499964346455_dp, &
  &    59.61773745881250619_dp,    29.61078975921033418_dp,    62.50861449014276872_dp,    32.91950572923986584_dp, &
  &    65.35037195723165837_dp,    36.32321005821969351_dp,    68.15676435641833564_dp,    39.81217237539895848_dp, &
  &    70.94410839385281520_dp,    43.37721635788606989_dp,    73.73234087330637010_dp,    47.00963897352000487_dp, &
  &    76.54676554128549526_dp,    50.70110112272598002_dp,    79.42099130058548440_dp,    54.44347433172315220_dp  ]
  lonlat( 1801: 1920) = [ &
  &    82.40205491898922219_dp,    58.22861013398448193_dp,    85.55981529780903827_dp,    62.04795929474798299_dp, &
  &    89.00534896567364740_dp,    65.89187266757556927_dp,    92.93011750021230455_dp,    69.74815881341463353_dp, &
  &    97.69886509454546797_dp,    73.59868574092435267_dp,   104.10346048738931302_dp,    77.40995108179684792_dp, &
  &   114.19717929614462548_dp,    81.10053146183230410_dp,   134.58473801020659266_dp,    84.39088722277173815_dp, &
  &  -178.00000000000002842_dp,    81.83938189765240168_dp,  -149.15668933029422760_dp,    80.85560324742941418_dp, &
  &  -128.64763601333984866_dp,    78.39753950634394641_dp,  -115.34882263320223217_dp,    75.18923730101467129_dp, &
  &  -106.23509874248557594_dp,    71.62987479878029262_dp,   -99.45761459629794388_dp,    67.90061168070624831_dp, &
  &   -94.04421718085441739_dp,    64.08831694761892095_dp,   -89.47013935832345055_dp,    60.23965935256792648_dp, &
  &   -85.43460651588344490_dp,    56.38292751246400769_dp,   -81.75424365182693975_dp,    52.53738247574246856_dp, &
  &   -78.31071017117777444_dp,    48.71761719224470966_dp,   -75.02360369831293951_dp,    44.93576201889581512_dp, &
  &   -71.83567948061782715_dp,    41.20268880474466755_dp,   -68.70439458886511375_dp,    37.52871692222674938_dp, &
  &   -65.59687011372152199_dp,    33.92405612452550656_dp,   -62.48679120890344052_dp,    30.39910192691253599_dp, &
  &   -59.35245736607464551_dp,    26.96464262473804041_dp,   -56.17554747078253996_dp,    23.63200834498021408_dp, &
  &   -52.94035098918124760_dp,    20.41317688045037926_dp,   -49.63331929525543984_dp,    17.32084182287969298_dp, &
  &   -46.24284889074778704_dp,    14.36844259642658983_dp,   -42.75924066894448572_dp,    11.57015196980180605_dp, &
  &   -39.17479644658766347_dp,     8.94081392759362537_dp,   -35.48402100288603123_dp,     6.49582334126627892_dp, &
  &   -31.68389780238809195_dp,     4.25093893994812166_dp,   -27.77420154083882053_dp,     2.22202305439570358_dp, &
  &   -23.75780275269854158_dp,     0.42470591907018640_dp,   -19.64091162595336826_dp,    -1.12602081331554005_dp, &
  &   -15.43320327160518524_dp,    -2.41626750988024330_dp,   -11.14776873556009384_dp,    -3.43374257581262743_dp, &
  &    -6.80084816537008940_dp,    -4.16824654595516098_dp,    -2.41132592404073165_dp,    -4.61212239418478553_dp, &
  &     1.99999999999999689_dp,    -4.76061810234754024_dp,     6.41132592404072632_dp,    -4.61212239418478553_dp, &
  &    10.80084816537008230_dp,    -4.16824654595516098_dp,    15.14776873556009029_dp,    -3.43374257581262743_dp, &
  &    19.43320327160517991_dp,    -2.41626750988024330_dp,    23.64091162595336115_dp,    -1.12602081331554005_dp, &
  &    27.75780275269853803_dp,     0.42470591907018640_dp,    31.77420154083881698_dp,     2.22202305439570358_dp, &
  &    35.68389780238808129_dp,     4.25093893994812166_dp,    39.48402100288601702_dp,     6.49582334126627270_dp, &
  &    43.17479644658765636_dp,     8.94081392759361826_dp,    46.75924066894447861_dp,    11.57015196980179894_dp, &
  &    50.24284889074777283_dp,    14.36844259642658628_dp,    53.63331929525543273_dp,    17.32084182287968943_dp, &
  &    56.94035098918124049_dp,    20.41317688045037571_dp,    60.17554747078253286_dp,    23.63200834498020697_dp, &
  &    63.35245736607463840_dp,    26.96464262473803331_dp,    66.48679120890342631_dp,    30.39910192691252178_dp, &
  &    69.59687011372152199_dp,    33.92405612452549946_dp,    72.70439458886511375_dp,    37.52871692222674227_dp  ]
  lonlat( 1921: 2040) = [ &
  &    75.83567948061782715_dp,    41.20268880474466755_dp,    79.02360369831293951_dp,    44.93576201889580091_dp, &
  &    82.31071017117776023_dp,    48.71761719224470255_dp,    85.75424365182693975_dp,    52.53738247574246145_dp, &
  &    89.43460651588344490_dp,    56.38292751246400769_dp,    93.47013935832345055_dp,    60.23965935256792648_dp, &
  &    98.04421718085441739_dp,    64.08831694761892095_dp,   103.45761459629794388_dp,    67.90061168070624831_dp, &
  &   110.23509874248557594_dp,    71.62987479878029262_dp,   119.34882263320223217_dp,    75.18923730101467129_dp, &
  &   132.64763601333982024_dp,    78.39753950634394641_dp,   153.15668933029419918_dp,    80.85560324742941418_dp, &
  &  -178.00000000000002842_dp,    77.29014606148251687_dp,  -157.47781378002883912_dp,    76.59572545663588983_dp, &
  &  -140.18467631053607647_dp,    74.70285264202438213_dp,  -126.87442892417496410_dp,    71.99165187875776439_dp, &
  &  -116.75095597801099245_dp,    68.78228497629521598_dp,  -108.83745587761724494_dp,    65.27873175231235336_dp, &
  &  -102.40541928769302160_dp,    61.60190913800556700_dp,   -96.97173315822051620_dp,    57.82466562901673512_dp, &
  &   -92.22157019495104180_dp,    53.99321139219064491_dp,   -87.94629406419838347_dp,    50.13884820321026581_dp, &
  &   -84.00357763838492531_dp,    46.28434439562811065_dp,   -80.29307189810650414_dp,    42.44749809608728697_dp, &
  &   -76.74158359961857911_dp,    38.64321178012773572_dp,   -73.29390254081907585_dp,    34.88475663106463287_dp, &
  &   -69.90700610430916129_dp,    31.18458087158649406_dp,   -66.54632400302145356_dp,    27.55485191826680591_dp, &
  &   -63.18329478816111333_dp,    24.00783659504740086_dp,   -59.79375952890369916_dp,    20.55617726580612015_dp, &
  &   -56.35691981311008192_dp,    17.21309536720795919_dp,   -52.85469423510679832_dp,    13.99253787292509621_dp, &
  &   -49.27137129744098587_dp,    10.90927185095380558_dp,   -45.59349430020986915_dp,     7.97892504367260802_dp, &
  &   -41.80993456941939712_dp,     5.21796518077428839_dp,   -37.91211819209929246_dp,     2.64360721178194558_dp, &
  &   -33.89437094593881739_dp,     0.27363605581641759_dp,   -29.75433817509684786_dp,    -1.87386656696368226_dp, &
  &   -25.49342310484703589_dp,    -3.78089833576525525_dp,   -21.11717183125961128_dp,    -5.43001433583734983_dp, &
  &   -16.63552097548324937_dp,    -6.80489321395614066_dp,   -12.06282113870962114_dp,    -7.89096231408011839_dp, &
  &    -7.41756212661334047_dp,    -8.67603648837036268_dp,    -2.72175805422022021_dp,    -9.15091230991673399_dp, &
  &     1.99999999999999645_dp,    -9.30985393851741172_dp,     6.72175805422021444_dp,    -9.15091230991673399_dp, &
  &    11.41756212661333691_dp,    -8.67603648837036268_dp,    16.06282113870961581_dp,    -7.89096231408011839_dp, &
  &    20.63552097548324582_dp,    -6.80489321395614066_dp,    25.11717183125960418_dp,    -5.43001433583734983_dp, &
  &    29.49342310484702523_dp,    -3.78089833576525525_dp,    33.75433817509684786_dp,    -1.87386656696368226_dp, &
  &    37.89437094593881028_dp,     0.27363605581641121_dp,    41.91211819209927114_dp,     2.64360721178193936_dp, &
  &    45.80993456941938291_dp,     5.21796518077428217_dp,    49.59349430020984784_dp,     7.97892504367260180_dp, &
  &    53.27137129744098587_dp,    10.90927185095380203_dp,    56.85469423510678411_dp,    13.99253787292509266_dp, &
  &    60.35691981311008192_dp,    17.21309536720795563_dp,    63.79375952890369206_dp,    20.55617726580611659_dp  ]
  lonlat( 2041: 2160) = [ &
  &    67.18329478816110623_dp,    24.00783659504739376_dp,    70.54632400302143935_dp,    27.55485191826679880_dp, &
  &    73.90700610430916129_dp,    31.18458087158649050_dp,    77.29390254081907585_dp,    34.88475663106463287_dp, &
  &    80.74158359961856490_dp,    38.64321178012773572_dp,    84.29307189810650414_dp,    42.44749809608728697_dp, &
  &    88.00357763838491110_dp,    46.28434439562810354_dp,    91.94629406419836926_dp,    50.13884820321025160_dp, &
  &    96.22157019495104180_dp,    53.99321139219064491_dp,   100.97173315822050199_dp,    57.82466562901673512_dp, &
  &   106.40541928769302160_dp,    61.60190913800556700_dp,   112.83745587761723073_dp,    65.27873175231235336_dp, &
  &   120.75095597801100666_dp,    68.78228497629521598_dp,   130.87442892417493567_dp,    71.99165187875776439_dp, &
  &   144.18467631053604805_dp,    74.70285264202438213_dp,   161.47781378002881070_dp,    76.59572545663588983_dp, &
  &  -178.00000000000002842_dp,    72.36459406509962378_dp,  -162.05644118521095720_dp,    71.82662636485281382_dp, &
  &  -147.60742176334812825_dp,    70.30250402254888797_dp,  -135.36255278451204731_dp,    68.00113945880528377_dp, &
  &  -125.26976638159491984_dp,    65.14478524125108549_dp,  -116.94158660124730886_dp,    61.91142197433249095_dp, &
  &  -109.95470750710923369_dp,    58.42738157410047961_dp,  -103.95825647893495614_dp,    54.77900423463843538_dp, &
  &   -98.68725830824647005_dp,    51.02562354013957702_dp,   -93.94726867835278483_dp,    47.20919167069192923_dp, &
  &   -89.59567144235911940_dp,    43.36062114047545890_dp,   -85.52649044264862255_dp,    39.50382677214758331_dp, &
  &   -81.65938939021744147_dp,    35.65830698143167155_dp,   -77.93201512996090230_dp,    31.84082402428231973_dp, &
  &   -74.29472888122153051_dp,    28.06652943785655552_dp,   -70.70698212428176532_dp,    24.34974403770184992_dp, &
  &   -67.13481958525987636_dp,    20.70451849248450316_dp,   -63.54916484650964748_dp,    17.14505004500528074_dp, &
  &   -59.92466443809041010_dp,    13.68599977255222377_dp,   -56.23894695811429756_dp,    10.34273467530951152_dp, &
  &   -52.47220691225792422_dp,     7.13150506907927006_dp,   -48.60705694133756083_dp,     4.06955754229704603_dp, &
  &   -44.62861191461713162_dp,     1.17517574056815666_dp,   -40.52477649322946007_dp,    -1.53236497867592147_dp, &
  &   -36.28670514160292981_dp,    -4.03294710811187507_dp,   -31.90939060170597941_dp,    -6.30588392466837533_dp, &
  &   -27.39231472226267528_dp,    -8.33033151194295662_dp,   -22.74006765897273397_dp,   -10.08584610023313921_dp, &
  &   -17.96281473836326725_dp,   -11.55307649365679090_dp,   -13.07647532339788654_dp,   -12.71455858250937254_dp, &
  &    -8.10248720394762678_dp,   -13.55555303790299426_dp,    -3.06707279862612969_dp,   -14.06484423228424063_dp, &
  &     1.99999999999999600_dp,   -14.23540593490034212_dp,     7.06707279862612125_dp,   -14.06484423228424063_dp, &
  &    12.10248720394761790_dp,   -13.55555303790299426_dp,    17.07647532339788299_dp,   -12.71455858250937254_dp, &
  &    21.96281473836326015_dp,   -11.55307649365679090_dp,    26.74006765897273041_dp,   -10.08584610023313921_dp, &
  &    31.39231472226266817_dp,    -8.33033151194295662_dp,    35.90939060170597230_dp,    -6.30588392466837533_dp, &
  &    40.28670514160292271_dp,    -4.03294710811188128_dp,    44.52477649322944586_dp,    -1.53236497867592791_dp, &
  &    48.62861191461712451_dp,     1.17517574056815022_dp,    52.60705694133754662_dp,     4.06955754229703981_dp  ]
  lonlat( 2161: 2280) = [ &
  &    56.47220691225791711_dp,     7.13150506907926740_dp,    60.23894695811429756_dp,    10.34273467530950796_dp, &
  &    63.92466443809040300_dp,    13.68599977255221667_dp,    67.54916484650964037_dp,    17.14505004500527363_dp, &
  &    71.13481958525987636_dp,    20.70451849248449605_dp,    74.70698212428177953_dp,    24.34974403770184992_dp, &
  &    78.29472888122153051_dp,    28.06652943785655197_dp,    81.93201512996088809_dp,    31.84082402428231262_dp, &
  &    85.65938939021744147_dp,    35.65830698143166444_dp,    89.52649044264860834_dp,    39.50382677214758331_dp, &
  &    93.59567144235911940_dp,    43.36062114047545180_dp,    97.94726867835277062_dp,    47.20919167069192213_dp, &
  &   102.68725830824645584_dp,    51.02562354013956281_dp,   107.95825647893494192_dp,    54.77900423463843538_dp, &
  &   113.95470750710921948_dp,    58.42738157410047961_dp,   120.94158660124729465_dp,    61.91142197433249095_dp, &
  &   129.26976638159487720_dp,    65.14478524125108549_dp,   139.36255278451201889_dp,    68.00113945880528377_dp, &
  &   151.60742176334809983_dp,    70.30250402254888797_dp,   166.05644118521092878_dp,    71.82662636485281382_dp, &
  &  -178.00000000000002842_dp,    67.00865712643569339_dp,  -164.95645291666266985_dp,    66.56908368553206401_dp, &
  &  -152.69437932769912436_dp,    65.29863962109095610_dp,  -141.70578215046154469_dp,    63.31961305621509695_dp, &
  &  -132.12712761110685733_dp,    60.78156430751474204_dp,  -123.85428534979440940_dp,    57.82417470821774685_dp, &
  &  -116.68240638414135901_dp,    54.56141374911145192_dp,  -110.39390839554111778_dp,    51.08045112569507751_dp, &
  &  -104.79614728017998004_dp,    47.44644408577498496_dp,   -99.73088255981890882_dp,    43.70821480745370025_dp, &
  &   -95.07197748871266185_dp,    39.90302877816822757_dp,   -90.71961138434764393_dp,    36.06017287638244539_dp, &
  &   -86.59435351833845118_dp,    32.20351875194761959_dp,   -82.63216392910496211_dp,    28.35333972343855535_dp, &
  &   -78.78048521884275601_dp,    24.52760876444716587_dp,   -74.99529352424694650_dp,    20.74294398926493699_dp, &
  &   -71.23891693218340038_dp,    17.01531594444593765_dp,   -67.47845003929684538_dp,    13.36059248585088355_dp, &
  &   -63.68463403089357655_dp,     9.79496963802121101_dp,   -59.83111160507219495_dp,     6.33531713186757539_dp, &
  &   -55.89399913408760057_dp,     2.99945241539763696_dp,   -51.85174332801064168_dp,    -0.19365520038940248_dp, &
  &   -47.68524592294902931_dp,    -3.22375917751486485_dp,   -43.37824652323212860_dp,    -6.06930752874206636_dp, &
  &   -38.91794868987490474_dp,    -8.70753794849322027_dp,   -34.29585521437643081_dp,   -11.11472732454917001_dp, &
  &   -29.50874372060167872_dp,   -13.26662598462659126_dp,   -24.55966518490711081_dp,   -15.13909773195326558_dp, &
  &   -19.45879403720245193_dp,   -16.70896594558295334_dp,   -14.22391622121717880_dp,   -17.95503295463868554_dp, &
  &    -8.88033504279663255_dp,   -18.85919797266866027_dp,    -3.46002704385166027_dp,   -19.40755726556069405_dp, &
  &     1.99999999999999645_dp,   -19.59134287356426540_dp,     7.46002704385165316_dp,   -19.40755726556069405_dp, &
  &    12.88033504279662367_dp,   -18.85919797266866027_dp,    18.22391622121717347_dp,   -17.95503295463868554_dp, &
  &    23.45879403720244127_dp,   -16.70896594558295334_dp,    28.55966518490710015_dp,   -15.13909773195326558_dp, &
  &    33.50874372060167161_dp,   -13.26662598462659126_dp,    38.29585521437642370_dp,   -11.11472732454917534_dp  ]
  lonlat( 2281: 2400) = [ &
  &    42.91794868987490474_dp,    -8.70753794849322738_dp,    47.37824652323212149_dp,    -6.06930752874207258_dp, &
  &    51.68524592294901510_dp,    -3.22375917751487107_dp,    55.85174332801063457_dp,    -0.19365520038940884_dp, &
  &    59.89399913408759346_dp,     2.99945241539763385_dp,    63.83111160507218784_dp,     6.33531713186756917_dp, &
  &    67.68463403089357655_dp,     9.79496963802120568_dp,    71.47845003929684538_dp,    13.36059248585087822_dp, &
  &    75.23891693218338617_dp,    17.01531594444593054_dp,    78.99529352424693229_dp,    20.74294398926492988_dp, &
  &    82.78048521884274180_dp,    24.52760876444715521_dp,    86.63216392910494790_dp,    28.35333972343854825_dp, &
  &    90.59435351833845118_dp,    32.20351875194761959_dp,    94.71961138434764393_dp,    36.06017287638243118_dp, &
  &    99.07197748871266185_dp,    39.90302877816822047_dp,   103.73088255981890882_dp,    43.70821480745368603_dp, &
  &   108.79614728017998004_dp,    47.44644408577497074_dp,   114.39390839554110357_dp,    51.08045112569504909_dp, &
  &   120.68240638414135901_dp,    54.56141374911145192_dp,   127.85428534979438098_dp,    57.82417470821774685_dp, &
  &   136.12712761110682891_dp,    60.78156430751474204_dp,   145.70578215046154469_dp,    63.31961305621509695_dp, &
  &   156.69437932769909594_dp,    65.29863962109095610_dp,   168.95645291666264143_dp,    66.56908368553206401_dp, &
  &  -178.00000000000002842_dp,    61.16162880179430772_dp,  -166.97884079028878546_dp,    60.79043532425956897_dp, &
  &  -156.40162010671977555_dp,    59.70518607311999659_dp,  -146.59283359977425221_dp,    57.98141283097307053_dp, &
  &  -137.70772458687926587_dp,    55.72003625021811501_dp,  -129.75638606304184464_dp,    53.02581189527144545_dp, &
  &  -122.65952710171549711_dp,    49.99368843662635697_dp,  -116.29889149413011751_dp,    46.70342202473146642_dp, &
  &  -110.54933935400606515_dp,    43.21943287866469774_dp,  -105.29473060869931089_dp,    39.59298941537671368_dp, &
  &  -100.43366587620559471_dp,    35.86497163386139420_dp,   -95.88003723653146437_dp,    32.06843215731343832_dp, &
  &   -91.56137924921046078_dp,    28.23071203179445376_dp,   -87.41655400532016529_dp,    24.37510563102819461_dp, &
  &   -83.39346098727328638_dp,    20.52214967325533124_dp,   -79.44703540885105042_dp,    16.69062430422997423_dp, &
  &   -75.53760403336077900_dp,    12.89834287286322301_dp,   -71.62959031828354739_dp,     9.16278970353470967_dp, &
  &   -67.69053915995506543_dp,     5.50164833296652400_dp,   -63.69043463465567356_dp,     1.93324784086672841_dp, &
  &   -59.60129716846515180_dp,    -1.52305829704237294_dp,   -55.39706222812606740_dp,    -4.84657887125734721_dp, &
  &   -51.05375641269629483_dp,    -8.01504773475606314_dp,   -46.54999441522540593_dp,   -11.00448645615599474_dp, &
  &   -41.86781613095839560_dp,   -13.78920372951384543_dp,   -36.99386004100858116_dp,   -16.34197985921976581_dp, &
  &   -31.92081946357624034_dp,   -18.63449057116782015_dp,   -26.64904852681421588_dp,   -20.63801909702448611_dp, &
  &   -21.18808138888132930_dp,   -22.32448212182582026_dp,   -15.55772615655294366_dp,   -23.66774871950555692_dp, &
  &    -9.78834011215971245_dp,   -24.64516330804185174_dp,    -3.91994134356475854_dp,   -25.23910692117754806_dp, &
  &     1.99999999999999556_dp,   -25.43837119820565107_dp,     7.91994134356474966_dp,   -25.23910692117754806_dp, &
  &    13.78834011215970534_dp,   -24.64516330804185174_dp,    19.55772615655293123_dp,   -23.66774871950555692_dp  ]
  lonlat( 2401: 2520) = [ &
  &    25.18808138888131865_dp,   -22.32448212182582026_dp,    30.64904852681421232_dp,   -20.63801909702448611_dp, &
  &    35.92081946357622968_dp,   -18.63449057116782015_dp,    40.99386004100855985_dp,   -16.34197985921976581_dp, &
  &    45.86781613095838850_dp,   -13.78920372951385076_dp,    50.54999441522539882_dp,   -11.00448645615600007_dp, &
  &    55.05375641269628773_dp,    -8.01504773475606846_dp,    59.39706222812605318_dp,    -4.84657887125735343_dp, &
  &    63.60129716846514469_dp,    -1.52305829704237916_dp,    67.69043463465565935_dp,     1.93324784086672197_dp, &
  &    71.69053915995505122_dp,     5.50164833296651778_dp,    75.62959031828353318_dp,     9.16278970353470434_dp, &
  &    79.53760403336076479_dp,    12.89834287286321590_dp,    83.44703540885105042_dp,    16.69062430422996712_dp, &
  &    87.39346098727328638_dp,    20.52214967325532413_dp,    91.41655400532015108_dp,    24.37510563102818750_dp, &
  &    95.56137924921046078_dp,    28.23071203179444666_dp,    99.88003723653145016_dp,    32.06843215731343832_dp, &
  &   104.43366587620558050_dp,    35.86497163386137288_dp,   109.29473060869932510_dp,    39.59298941537669947_dp, &
  &   114.54933935400606515_dp,    43.21943287866469774_dp,   120.29889149413010330_dp,    46.70342202473146642_dp, &
  &   126.65952710171551132_dp,    49.99368843662635697_dp,   133.75638606304187306_dp,    53.02581189527144545_dp, &
  &   141.70772458687926587_dp,    55.72003625021811501_dp,   150.59283359977422379_dp,    57.98141283097307053_dp, &
  &   160.40162010671977555_dp,    59.70518607311999659_dp,   170.97884079028878546_dp,    60.79043532425956897_dp, &
  &  -178.00000000000002842_dp,    54.75649468439711143_dp,  -168.49285933765114009_dp,    54.43639475342744305_dp, &
  &  -159.25249258416440057_dp,    53.49372597518600259_dp,  -150.49218436749950456_dp,    51.97706503648645082_dp, &
  &  -142.34201331309026273_dp,    49.95526128262039123_dp,  -134.84908760812987794_dp,    47.50530446205828383_dp, &
  &  -127.99715883033752561_dp,    44.70273256173389598_dp,  -121.73118977168118704_dp,    41.61600262291977259_dp, &
  &  -115.97779813807071037_dp,    38.30427835916992052_dp,  -110.65884380836621403_dp,    34.81740352705595143_dp, &
  &  -105.69899804029306267_dp,    31.19696754875727152_dp,  -101.02917319698202903_dp,    27.47775433026597725_dp, &
  &   -96.58749981932022877_dp,    23.68920100972959730_dp,   -92.31902021078286680_dp,    19.85670886149115688_dp, &
  &   -88.17480572169651509_dp,    16.00276430383187076_dp,   -84.11088800598805904_dp,    12.14788119395578825_dp, &
  &   -80.08720437104130951_dp,     8.31139512800513991_dp,   -76.06665407661381550_dp,     4.51214364124032752_dp, &
  &   -72.01431282527251199_dp,     0.76906207426875217_dp,   -67.89683474738467339_dp,    -2.89828246890512542_dp, &
  &   -63.68207179147747610_dp,    -6.46920580966549608_dp,   -59.33895182482493880_dp,    -9.92146778444055499_dp, &
  &   -54.83767345094592827_dp,   -13.23089104518994574_dp,   -50.15029168417838434_dp,   -16.37106576006626568_dp, &
  &   -45.25177543408179304_dp,   -19.31318879069117145_dp,   -40.12160159745184274_dp,   -22.02610835172851722_dp, &
  &   -34.74589265732009835_dp,   -24.47666503668304117_dp,   -29.11998552133064422_dp,   -26.63042818683534207_dp, &
  &   -23.25113130544623985_dp,   -28.45290874783366064_dp,   -17.16079514785620930_dp,   -29.91127029421519978_dp, &
  &   -10.88583393507997776_dp,   -30.97645080660139172_dp,    -4.47781225763253765_dp,   -31.62546289221583962_dp  ]
  lonlat( 2521: 2640) = [ &
  &     1.99999999999999534_dp,   -31.84350531560284736_dp,     8.47781225763252877_dp,   -31.62546289221583962_dp, &
  &    14.88583393507996711_dp,   -30.97645080660139172_dp,    21.16079514785619509_dp,   -29.91127029421519978_dp, &
  &    27.25113130544623274_dp,   -28.45290874783366064_dp,    33.11998552133064067_dp,   -26.63042818683534207_dp, &
  &    38.74589265732009835_dp,   -24.47666503668304117_dp,    44.12160159745183563_dp,   -22.02610835172851722_dp, &
  &    49.25177543408178593_dp,   -19.31318879069118211_dp,    54.15029168417837724_dp,   -16.37106576006627279_dp, &
  &    58.83767345094592827_dp,   -13.23089104518995285_dp,    63.33895182482493169_dp,    -9.92146778444056032_dp, &
  &    67.68207179147748320_dp,    -6.46920580966550229_dp,    71.89683474738467339_dp,    -2.89828246890513164_dp, &
  &    76.01431282527251199_dp,     0.76906207426874584_dp,    80.06665407661380129_dp,     4.51214364124032308_dp, &
  &    84.08720437104132372_dp,     8.31139512800513458_dp,    88.11088800598805904_dp,    12.14788119395578470_dp, &
  &    92.17480572169650088_dp,    16.00276430383186366_dp,    96.31902021078285259_dp,    19.85670886149114978_dp, &
  &   100.58749981932022877_dp,    23.68920100972959020_dp,   105.02917319698201482_dp,    27.47775433026597014_dp, &
  &   109.69899804029304846_dp,    31.19696754875725375_dp,   114.65884380836618561_dp,    34.81740352705593722_dp, &
  &   119.97779813807069615_dp,    38.30427835916992052_dp,   125.73118977168117283_dp,    41.61600262291977259_dp, &
  &   131.99715883033749719_dp,    44.70273256173389598_dp,   138.84908760812987794_dp,    47.50530446205828383_dp, &
  &   146.34201331309026273_dp,    49.95526128262039123_dp,   154.49218436749950456_dp,    51.97706503648645082_dp, &
  &   163.25249258416440057_dp,    53.49372597518600259_dp,   172.49285933765111167_dp,    54.43639475342744305_dp, &
  &  -178.00000000000002842_dp,    47.72124472298390430_dp,  -169.69217969866491558_dp,    47.44157216781381692_dp, &
  &  -161.55074086228117380_dp,    46.61395503653132266_dp,  -153.71667350566602295_dp,    45.27051130755705799_dp, &
  &  -146.28885177460344380_dp,    43.45866798082070659_dp,  -139.31958252044236701_dp,    41.23439386179803279_dp, &
  &  -132.82020109922686402_dp,    38.65601141858345358_dp,  -126.77168357131760956_dp,    35.77969749489390949_dp, &
  &  -121.13576891124588997_dp,    32.65687547770472321_dp,  -115.86406835852179142_dp,    29.33315055785289260_dp, &
  &  -110.90442707083994378_dp,    25.84827445710250160_dp,  -106.20481280215612685_dp,    22.23668760419472790_dp, &
  &  -101.71535755141638901_dp,    18.52832281285149207_dp,   -97.38917071735673403_dp,    14.74948212031801020_dp, &
  &   -93.18240447461121789_dp,    10.92369066480776674_dp,   -89.05390189983984328_dp,     7.07248905242842607_dp, &
  &   -84.96463936229969249_dp,     3.21615784383777559_dp,   -80.87709425893895343_dp,    -0.62561625366165152_dp, &
  &   -76.75462189677602964_dp,    -4.43311662588922051_dp,   -72.56090370117536281_dp,    -8.18599910867232161_dp, &
  &   -68.25952713288315010_dp,   -11.86270778471483389_dp,   -63.81377209114523907_dp,   -15.43989911427394368_dp, &
  &   -59.18670666190919150_dp,   -18.89188184637555068_dp,   -54.34173321358174746_dp,   -22.19009961204913850_dp, &
  &   -49.24376548995358149_dp,   -25.30271165018387691_dp,   -43.86123932751760890_dp,   -28.19436585459229860_dp, &
  &   -38.16912769952225659_dp,   -30.82630445836841915_dp,   -32.15298964123236658_dp,   -33.15698491696964112_dp  ]
  lonlat( 2641: 2760) = [ &
  &   -25.81377244810833815_dp,   -35.14341202945125531_dp,   -19.17259140539265516_dp,   -36.74332279213026453_dp, &
  &   -12.27414365511957151_dp,   -37.91820250638207312_dp,    -5.18708125479775184_dp,   -38.63683300066042392_dp, &
  &     1.99999999999999489_dp,   -38.87875527701606160_dp,     9.18708125479774296_dp,   -38.63683300066042392_dp, &
  &    16.27414365511955907_dp,   -37.91820250638207312_dp,    23.17259140539264095_dp,   -36.74332279213026453_dp, &
  &    29.81377244810832394_dp,   -35.14341202945125531_dp,    36.15298964123235947_dp,   -33.15698491696964112_dp, &
  &    42.16912769952225659_dp,   -30.82630445836841915_dp,    47.86123932751760179_dp,   -28.19436585459229860_dp, &
  &    53.24376548995357439_dp,   -25.30271165018388402_dp,    58.34173321358174746_dp,   -22.19009961204914205_dp, &
  &    63.18670666190918439_dp,   -18.89188184637555779_dp,    67.81377209114522486_dp,   -15.43989911427395079_dp, &
  &    72.25952713288313589_dp,   -11.86270778471484277_dp,    76.56090370117536281_dp,    -8.18599910867232872_dp, &
  &    80.75462189677602964_dp,    -4.43311662588922673_dp,    84.87709425893895343_dp,    -0.62561625366165630_dp, &
  &    88.96463936229967828_dp,     3.21615784383776981_dp,    93.05390189983984328_dp,     7.07248905242842163_dp, &
  &    97.18240447461121789_dp,    10.92369066480776141_dp,   101.38917071735671982_dp,    14.74948212031800310_dp, &
  &   105.71535755141637480_dp,    18.52832281285148497_dp,   110.20481280215611264_dp,    22.23668760419472079_dp, &
  &   114.90442707083992957_dp,    25.84827445710249449_dp,   119.86406835852177721_dp,    29.33315055785288550_dp, &
  &   125.13576891124587576_dp,    32.65687547770470900_dp,   130.77168357131759535_dp,    35.77969749489390949_dp, &
  &   136.82020109922683559_dp,    38.65601141858345358_dp,   143.31958252044236701_dp,    41.23439386179803279_dp, &
  &   150.28885177460347222_dp,    43.45866798082070659_dp,   157.71667350566602295_dp,    45.27051130755705799_dp, &
  &   165.55074086228114538_dp,    46.61395503653132266_dp,   173.69217969866488716_dp,    47.44157216781381692_dp, &
  &  -178.00000000000002842_dp,    39.98177927524727693_dp,  -170.20476659278793363_dp,    39.70189618399165710_dp, &
  &  -162.53782868216148927_dp,    38.87197455633481979_dp,  -155.11038900941949237_dp,    37.51968052984662449_dp, &
  &  -148.00450116657361832_dp,    35.68659928106227852_dp,  -141.26850797118672176_dp,    33.42299645292870736_dp, &
  &  -134.91921485966395267_dp,    30.78272820361293327_dp,  -128.94811747553873715_dp,    27.81921722445741452_dp, &
  &  -123.32885205682140395_dp,    24.58281725765701253_dp,  -118.02393786261990272_dp,    21.11944988981388605_dp, &
  &  -112.98994385952538266_dp,    17.47019805768939449_dp,  -108.18096363521175363_dp,    13.67152082594358653_dp, &
  &  -103.55065416712271542_dp,     9.75582109859903390_dp,   -99.05319914949195947_dp,     5.75218534812640492_dp, &
  &   -94.64352777118511995_dp,     1.68719008387413827_dp,   -90.27704477012913742_dp,    -2.41427530523583656_dp, &
  &   -85.90905356028720519_dp,    -6.52818370181667529_dp,   -81.49400025392820623_dp,   -10.63053585607600837_dp, &
  &   -76.98463901984250413_dp,   -14.69649678201448140_dp,   -72.33122188826867216_dp,   -18.69947873486281864_dp, &
  &   -67.48085419487966874_dp,   -22.61014977269736193_dp,   -62.37723925505212463_dp,   -26.39536140379772533_dp, &
  &   -56.96117255247644096_dp,   -30.01702215459737033_dp,   -51.17233704527057370_dp,   -33.43100825355479344_dp  ]
  lonlat( 2761: 2880) = [ &
  &   -44.95316063861177014_dp,   -36.58631299796492442_dp,   -38.25559890256131723_dp,   -39.42480136235259636_dp, &
  &   -31.05142021090808413_dp,   -41.88213387768102791_dp,   -23.34546416576216643_dp,   -43.89055765093644368_dp, &
  &   -15.18911080317680451_dp,   -45.38412606933154336_dp,    -6.68839576675081293_dp,   -46.30624543028365991_dp, &
  &     1.99999999999999445_dp,   -46.61822072475268186_dp,    10.68839576675079961_dp,   -46.30624543028365991_dp, &
  &    19.18911080317679918_dp,   -45.38412606933154336_dp,    27.34546416576215222_dp,   -43.89055765093644368_dp, &
  &    35.05142021090807702_dp,   -41.88213387768102791_dp,    42.25559890256131013_dp,   -39.42480136235259636_dp, &
  &    48.95316063861175593_dp,   -36.58631299796492442_dp,    55.17233704527057370_dp,   -33.43100825355479344_dp, &
  &    60.96117255247643385_dp,   -30.01702215459737744_dp,    66.37723925505210332_dp,   -26.39536140379773244_dp, &
  &    71.48085419487965453_dp,   -22.61014977269736548_dp,    76.33122188826865795_dp,   -18.69947873486282575_dp, &
  &    80.98463901984250413_dp,   -14.69649678201448850_dp,    85.49400025392819202_dp,   -10.63053585607601548_dp, &
  &    89.90905356028720519_dp,    -6.52818370181668062_dp,    94.27704477012913742_dp,    -2.41427530523584188_dp, &
  &    98.64352777118510573_dp,     1.68719008387413361_dp,   103.05319914949195947_dp,     5.75218534812639781_dp, &
  &   107.55065416712271542_dp,     9.75582109859902680_dp,   112.18096363521173942_dp,    13.67152082594358120_dp, &
  &   116.98994385952536845_dp,    17.47019805768938738_dp,   122.02393786261990272_dp,    21.11944988981387894_dp, &
  &   127.32885205682140395_dp,    24.58281725765700187_dp,   132.94811747553873715_dp,    27.81921722445741452_dp, &
  &   138.91921485966392424_dp,    30.78272820361293327_dp,   145.26850797118672176_dp,    33.42299645292870736_dp, &
  &   152.00450116657361832_dp,    35.68659928106227852_dp,   159.11038900941949237_dp,    37.51968052984662449_dp, &
  &   166.53782868216146085_dp,    38.87197455633481979_dp,   174.20476659278793363_dp,    39.70189618399165710_dp, &
  &  -178.00000000000002842_dp,    31.46720374958098887_dp,  -171.12910064316457692_dp,    31.22051723140710067_dp, &
  &  -164.34108626834762390_dp,    30.48695101230147841_dp,  -157.71017626763574526_dp,    29.28521267182222587_dp, &
  &  -151.29523174265207786_dp,    27.64411687523926986_dp,  -145.13620894054648147_dp,    25.59967735271197498_dp, &
  &  -139.25381666270027381_dp,    23.19203115841211726_dp,  -133.65157520973266969_dp,    20.46271167815037728_dp, &
  &  -128.31914580979304219_dp,    17.45256126555711873_dp,  -123.23592626204657563_dp,    14.20035582641498806_dp, &
  &  -118.37425008640165913_dp,    10.74206713847307348_dp,  -113.70187269530693186_dp,     7.11062322287716331_dp, &
  &  -109.18367588372132104_dp,     3.33602075627005945_dp,  -104.78265670493266271_dp,    -0.55433148808729127_dp, &
  &  -100.46031614728222792_dp,    -4.53512373056416163_dp,   -96.17656220612794016_dp,    -8.58256192749418290_dp, &
  &   -91.88921878897831164_dp,   -12.67371220268469223_dp,   -87.55320457280681978_dp,   -16.78577161643179849_dp, &
  &   -83.11942634360052296_dp,   -20.89524495725206421_dp,   -78.53343020155088539_dp,   -24.97699141478169338_dp, &
  &   -73.73388667252179118_dp,   -29.00309226896919412_dp,   -68.65107920217621995_dp,   -32.94148403257255353_dp, &
  &   -63.20576633421556068_dp,   -36.75430974219704439_dp,   -57.30916699148811233_dp,   -40.39598469592144880_dp  ]
  lonlat( 2881: 3000) = [ &
  &   -50.86545369174167774_dp,   -43.81109166541019562_dp,   -43.77902429867569367_dp,   -46.93247902115529513_dp, &
  &   -35.96960367385943158_dp,   -49.68040408706252720_dp,   -27.39769711559288723_dp,   -51.96422430511800172_dp, &
  &   -18.09872704828334378_dp,   -53.68864395349498864_dp,    -8.21451927262478065_dp,   -54.76594013073759015_dp, &
  &     1.99999999999999289_dp,   -55.13279625041898413_dp,    12.21451927262476822_dp,   -54.76594013073759015_dp, &
  &    22.09872704828332601_dp,   -53.68864395349498864_dp,    31.39769711559288012_dp,   -51.96422430511800172_dp, &
  &    39.96960367385942448_dp,   -49.68040408706252720_dp,    47.77902429867568657_dp,   -46.93247902115529513_dp, &
  &    54.86545369174167064_dp,   -43.81109166541019562_dp,    61.30916699148811233_dp,   -40.39598469592146301_dp, &
  &    67.20576633421555357_dp,   -36.75430974219705149_dp,    72.65107920217620574_dp,   -32.94148403257256064_dp, &
  &    77.73388667252179118_dp,   -29.00309226896920123_dp,    82.53343020155088539_dp,   -24.97699141478170048_dp, &
  &    87.11942634360052296_dp,   -20.89524495725207132_dp,    91.55320457280680557_dp,   -16.78577161643180560_dp, &
  &    95.88921878897831164_dp,   -12.67371220268469756_dp,   100.17656220612792595_dp,    -8.58256192749419000_dp, &
  &   104.46031614728221371_dp,    -4.53512373056416607_dp,   108.78265670493264849_dp,    -0.55433148808729760_dp, &
  &   113.18367588372132104_dp,     3.33602075627005323_dp,   117.70187269530691765_dp,     7.11062322287715620_dp, &
  &   122.37425008640165913_dp,    10.74206713847306816_dp,   127.23592626204656142_dp,    14.20035582641498095_dp, &
  &   132.31914580979304219_dp,    17.45256126555711162_dp,   137.65157520973264127_dp,    20.46271167815036662_dp, &
  &   143.25381666270027381_dp,    23.19203115841211726_dp,   149.13620894054645305_dp,    25.59967735271197498_dp, &
  &   155.29523174265207786_dp,    27.64411687523926986_dp,   161.71017626763577368_dp,    29.28521267182222587_dp, &
  &   168.34108626834759548_dp,    30.48695101230147841_dp,   175.12910064316457692_dp,    31.22051723140710067_dp, &
  &  -178.00000000000002842_dp,    22.11837781753018817_dp,  -170.46891148411387462_dp,    21.78042227826199095_dp, &
  &  -163.04151372648448159_dp,    20.77699151155475477_dp,  -155.80845268931921055_dp,    19.13794220572576776_dp, &
  &  -148.83768595785252842_dp,    16.90865838596958781_dp,  -142.17005258660481104_dp,    14.14485028302004999_dp, &
  &  -135.81978239976487544_dp,    10.90731557455581147_dp,  -129.77826339847271697_dp,     7.25759760165333567_dp, &
  &  -124.01906809075352101_dp,     3.25496397729521814_dp,  -118.50268451884778642_dp,    -1.04529436283411115_dp, &
  &  -113.18006743498142441_dp,    -5.59247248797413210_dp,  -107.99465974304708027_dp,   -10.34025377357217934_dp, &
  &  -102.88281945262124850_dp,   -15.24594064653213898_dp,   -97.77265218881962028_dp,   -20.26925377022462982_dp, &
  &   -92.58116190590757810_dp,   -25.37072818781790673_dp,   -87.20945067766288616_dp,   -30.50961194071436111_dp, &
  &   -81.53547443418635510_dp,   -35.64102404029979709_dp,   -75.40370496549049051_dp,   -40.71192873614232610_dp, &
  &   -68.61131289029849256_dp,   -45.65520975111465418_dp,   -60.89227178252910733_dp,   -50.38082342875217989_dp, &
  &   -51.90710322947828104_dp,   -54.76300160634039571_dp,   -41.26325159838054901_dp,   -58.62403790832019723_dp, &
  &   -28.62428016143747200_dp,   -61.72174914658255318_dp,   -13.98037118830461445_dp,   -63.76341508305664263_dp  ]
  lonlat( 3001: 3120) = [ &
  &     1.99999999999999090_dp,   -64.48162218246977773_dp,    17.98037118830459491_dp,   -63.76341508305664263_dp, &
  &    32.62428016143745424_dp,   -61.72174914658255318_dp,    45.26325159838053480_dp,   -58.62403790832019723_dp, &
  &    55.90710322947827393_dp,   -54.76300160634039571_dp,    64.89227178252910733_dp,   -50.38082342875217989_dp, &
  &    72.61131289029847835_dp,   -45.65520975111467550_dp,    79.40370496549049051_dp,   -40.71192873614232610_dp, &
  &    85.53547443418635510_dp,   -35.64102404029981841_dp,    91.20945067766287195_dp,   -30.50961194071436822_dp, &
  &    96.58116190590757810_dp,   -25.37072818781791383_dp,   101.77265218881962028_dp,   -20.26925377022463692_dp, &
  &   106.88281945262124850_dp,   -15.24594064653214609_dp,   111.99465974304708027_dp,   -10.34025377357218289_dp, &
  &   117.18006743498143862_dp,    -5.59247248797413921_dp,   122.50268451884780063_dp,    -1.04529436283411759_dp, &
  &   128.01906809075350679_dp,     3.25496397729521192_dp,   133.77826339847268855_dp,     7.25759760165332857_dp, &
  &   139.81978239976487544_dp,    10.90731557455580436_dp,   146.17005258660478262_dp,    14.14485028302004999_dp, &
  &   152.83768595785250000_dp,    16.90865838596958781_dp,   159.80845268931921055_dp,    19.13794220572576776_dp, &
  &   167.04151372648448159_dp,    20.77699151155475477_dp,   174.46891148411387462_dp,    21.78042227826199095_dp, &
  &  -178.00000000000002842_dp,    11.90033356154828503_dp,  -171.03550378237531504_dp,    11.56695807154089728_dp, &
  &  -164.15259832130166728_dp,    10.57562338306961180_dp,  -157.42382961455143686_dp,     8.95164656051215069_dp, &
  &  -150.90567761562240889_dp,     6.73398631258200187_dp,  -144.63474532961075170_dp,     3.97127289925851068_dp, &
  &  -138.62718020698264354_dp,     0.71762564121834338_dp,  -132.88045216690298389_dp,    -2.97103149043460757_dp, &
  &  -127.37626453526326031_dp,    -7.03975713563777195_dp,  -122.08348616854385682_dp,   -11.43638098615609344_dp, &
  &  -116.96030366998827787_dp,   -16.11238508810905401_dp,  -111.95506961066591600_dp,   -21.02304593053227677_dp, &
  &  -107.00543419047215821_dp,   -26.12699149209596428_dp,  -102.03522828445495918_dp,   -31.38525381109429446_dp, &
  &   -96.94814060146437384_dp,   -36.75977477892173084_dp,   -91.61632617812561818_dp,   -42.21112686087874266_dp, &
  &   -85.86029859026153588_dp,   -47.69485768882572785_dp,   -79.41299264536502278_dp,   -53.15514845029933610_dp, &
  &   -71.85455169648275842_dp,   -58.51289100414830102_dp,   -62.49613000707146426_dp,   -63.64173578517077345_dp, &
  &   -50.20367738593296281_dp,   -68.31866526945105988_dp,   -33.33636828365784055_dp,   -72.13161644510194037_dp, &
  &   -10.78607194201629582_dp,   -74.39304559691805707_dp,    14.78607194201627273_dp,   -74.39304559691805707_dp, &
  &    37.33636828365781213_dp,   -72.13161644510194037_dp,    54.20367738593294149_dp,   -68.31866526945105988_dp, &
  &    66.49613000707145716_dp,   -63.64173578517077345_dp,    75.85455169648274421_dp,   -58.51289100414830102_dp, &
  &    83.41299264536502278_dp,   -53.15514845029933610_dp,    89.86029859026150746_dp,   -47.69485768882574916_dp, &
  &    95.61632617812561818_dp,   -42.21112686087874266_dp,   100.94814060146437384_dp,   -36.75977477892173084_dp, &
  &   106.03522828445494497_dp,   -31.38525381109429446_dp,   111.00543419047215821_dp,   -26.12699149209597138_dp, &
  &   115.95506961066591600_dp,   -21.02304593053228388_dp,   120.96030366998827787_dp,   -16.11238508810905756_dp  ]
  lonlat( 3121: 3240) = [ &
  &   126.08348616854387103_dp,   -11.43638098615609699_dp,   131.37626453526326031_dp,    -7.03975713563777816_dp, &
  &   136.88045216690298389_dp,    -2.97103149043461379_dp,   142.62718020698264354_dp,     0.71762564121833694_dp, &
  &   148.63474532961075170_dp,     3.97127289925851068_dp,   154.90567761562243732_dp,     6.73398631258200187_dp, &
  &   161.42382961455140844_dp,     8.95164656051215069_dp,   168.15259832130169571_dp,    10.57562338306961180_dp, &
  &   175.03550378237531504_dp,    11.56695807154089728_dp,  -178.00000000000002842_dp,     0.81833312891115306_dp, &
  &  -171.37485237931247184_dp,     0.46152536384328174_dp,  -164.82591385569978115_dp,    -0.60006016949342578_dp, &
  &  -158.42170502724641779_dp,    -2.34091526057736310_dp,  -152.21700460768090579_dp,    -4.72161659803607048_dp, &
  &  -146.24942513902283281_dp,    -7.69266569608215889_dp,  -140.53869867413175143_dp,   -11.19861017149900739_dp, &
  &  -135.08801440266989857_dp,   -15.18177122287804615_dp,  -129.88641650799127092_dp,   -19.58517424494497305_dp, &
  &  -124.91129483912591525_dp,   -24.35455549606792047_dp,  -120.13018318901130499_dp,   -29.43951176908901957_dp, &
  &  -115.50120511177955507_dp,   -34.79395188944583595_dp,  -110.97138028465980142_dp,   -40.37601690822956613_dp, &
  &  -106.47134737780879732_dp,   -46.14758359783259323_dp,  -101.90317607822893820_dp,   -52.07335345715244301_dp, &
  &   -97.11263541171206271_dp,   -58.11928872485960085_dp,   -91.82057104813961246_dp,   -64.24948773689963843_dp, &
  &   -85.42499621356618889_dp,   -70.41813086842684299_dp,   -76.27768438369074033_dp,   -76.54083121758115738_dp, &
  &   -57.87324357773111672_dp,   -82.33459525449163152_dp,     1.99999999999996114_dp,   -85.78166687108868871_dp, &
  &    61.87324357773107408_dp,   -82.33459525449163152_dp,    80.27768438369074033_dp,   -76.54083121758115738_dp, &
  &    89.42499621356618889_dp,   -70.41813086842684299_dp,    95.82057104813959825_dp,   -64.24948773689963843_dp, &
  &   101.11263541171206271_dp,   -58.11928872485960085_dp,   105.90317607822892398_dp,   -52.07335345715245722_dp, &
  &   110.47134737780879732_dp,   -46.14758359783259323_dp,   114.97138028465980142_dp,   -40.37601690822956613_dp, &
  &   119.50120511177955507_dp,   -34.79395188944583595_dp,   124.13018318901127657_dp,   -29.43951176908902667_dp, &
  &   128.91129483912592946_dp,   -24.35455549606792403_dp,   133.88641650799127092_dp,   -19.58517424494497661_dp, &
  &   139.08801440266989857_dp,   -15.18177122287804970_dp,   144.53869867413172301_dp,   -11.19861017149901272_dp, &
  &   150.24942513902280439_dp,    -7.69266569608215889_dp,   156.21700460768090579_dp,    -4.72161659803607048_dp, &
  &   162.42170502724644621_dp,    -2.34091526057736310_dp,   168.82591385569978115_dp,    -0.60006016949342578_dp, &
  &   175.37485237931247184_dp,     0.46152536384328174_dp,  -178.00000000000000000_dp,   -11.06408152044379101_dp, &
  &  -171.33870321353637678_dp,   -11.51266748991093891_dp,  -164.78020742076523675_dp,   -12.84550987892848539_dp, &
  &  -158.41822389716838870_dp,   -15.02545489467462403_dp,  -152.33085313434585828_dp,   -17.99542592709287803_dp, &
  &  -146.57821873782722832_dp,   -21.68429473238734673_dp,  -141.20455296082769792_dp,   -26.01294410398721979_dp, &
  &  -136.24424010430539056_dp,   -30.89942669541638764_dp,  -131.73150447900647464_dp,   -36.26259289105208694_dp, &
  &  -127.71480673751507595_dp,   -42.02394287044848653_dp,  -124.28024682035200499_dp,   -48.10755262562803125_dp  ]
  lonlat( 3241: 3360) = [ &
  &  -121.59604777627559713_dp,   -54.43751136022502379_dp,  -120.01228809564838684_dp,   -60.93070105520797597_dp, &
  &  -120.32470998353322500_dp,   -67.47696540683870126_dp,  -124.60898756414846389_dp,   -73.87349687490876704_dp, &
  &  -139.22778135121401988_dp,   -79.54230031515007227_dp,  -178.00000000000000000_dp,   -82.33591847955618448_dp, &
  &   143.22778135121404830_dp,   -79.54230031515007227_dp,   128.60898756414846389_dp,   -73.87349687490876704_dp, &
  &   124.32470998353322500_dp,   -67.47696540683870126_dp,   124.01228809564837263_dp,   -60.93070105520797597_dp, &
  &   125.59604777627561134_dp,   -54.43751136022503090_dp,   128.28024682035200499_dp,   -48.10755262562803125_dp, &
  &   131.71480673751509016_dp,   -42.02394287044850074_dp,   135.73150447900647464_dp,   -36.26259289105208694_dp, &
  &   140.24424010430539056_dp,   -30.89942669541638764_dp,   145.20455296082769792_dp,   -26.01294410398722334_dp, &
  &   150.57821873782722832_dp,   -21.68429473238734673_dp,   156.33085313434585828_dp,   -17.99542592709287803_dp, &
  &   162.41822389716838870_dp,   -15.02545489467462403_dp,   168.78020742076520833_dp,   -12.84550987892848539_dp, &
  &   175.33870321353637678_dp,   -11.51266748991093891_dp,  -178.00000000000000000_dp,   -23.60656536858034116_dp, &
  &  -172.31484199740026497_dp,   -24.06074499849094650_dp,  -166.76206145225543764_dp,   -25.40835290264588053_dp, &
  &  -161.47033176340409000_dp,   -27.60594661847371611_dp,  -156.56387974300261590_dp,   -30.58514629912493277_dp, &
  &  -152.16715015384193066_dp,   -34.25717258827405942_dp,  -148.41689072479888978_dp,   -38.51667916926085411_dp, &
  &  -145.48413942807309240_dp,   -43.24305393544465659_dp,  -143.61056018478930696_dp,   -48.29703252527734492_dp, &
  &  -143.16669319413330186_dp,   -53.50931894776815057_dp,  -144.73891790293430404_dp,   -58.65522080377154168_dp, &
  &  -149.21912766680259210_dp,   -63.40582055258879279_dp,  -157.69810487935359333_dp,   -67.25441721659638006_dp, &
  &  -170.53118545218148938_dp,   -69.49384617858525814_dp,   174.53118545218146096_dp,   -69.49384617858525814_dp, &
  &   161.69810487935359333_dp,   -67.25441721659638006_dp,   153.21912766680256368_dp,   -63.40582055258877858_dp, &
  &   148.73891790293430404_dp,   -58.65522080377152747_dp,   147.16669319413330186_dp,   -53.50931894776815767_dp, &
  &   147.61056018478930696_dp,   -48.29703252527734492_dp,   149.48413942807309240_dp,   -43.24305393544464948_dp, &
  &   152.41689072479886136_dp,   -38.51667916926086122_dp,   156.16715015384193066_dp,   -34.25717258827403811_dp, &
  &   160.56387974300261590_dp,   -30.58514629912493277_dp,   165.47033176340409000_dp,   -27.60594661847371611_dp, &
  &   170.76206145225546607_dp,   -25.40835290264587698_dp,   176.31484199740026497_dp,   -24.06074499849094295_dp, &
  &  -178.00000000000000000_dp,   -36.54741287921620341_dp,  -174.09065200901946469_dp,   -36.97055608025468132_dp, &
  &  -170.42266827604018431_dp,   -38.21219158951615213_dp,  -167.24101930549508666_dp,   -40.18968456371464271_dp, &
  &  -164.79950790329061761_dp,   -42.76713193279059766_dp,  -163.36621335583259906_dp,   -45.75617589753742465_dp, &
  &  -163.22080918295719698_dp,   -48.91487419033276751_dp,  -164.62326642581021474_dp,   -51.94637057143930292_dp, &
  &  -167.72066876086483944_dp,   -54.50623527875517738_dp,  -172.37525674045562596_dp,   -56.23764348052387874_dp, &
  &  -178.00000000000000000_dp,   -56.85258712078380228_dp,   176.37525674045562596_dp,   -56.23764348052387874_dp  ]
  lonlat( 3361: 3376) = [ &
  &   171.72066876086483944_dp,   -54.50623527875517738_dp,   168.62326642581021474_dp,   -51.94637057143930292_dp, &
  &   167.22080918295719698_dp,   -48.91487419033276751_dp,   167.36621335583259906_dp,   -45.75617589753742465_dp, &
  &   168.79950790329058918_dp,   -42.76713193279060476_dp,   171.24101930549508666_dp,   -40.18968456371464271_dp, &
  &   174.42266827604018431_dp,   -38.21219158951615213_dp,   178.09065200901943626_dp,   -36.97055608025468132_dp  ]

  grid = atlas_ReducedGaussianGrid(nx, projection=atlas_RotatedSchmidtProjection(stretch,centre,angle) )

  jglo = 0
  do j = 1, grid%ny()
    do i = 1, grid%nx(j)
      FCTEST_CHECK_CLOSE( grid%lonlat(i,j), ([lonlat(2*jglo+1),lonlat(2*jglo+2)]), 1.e-10_dp );
      jglo = jglo + 1
    enddo
  enddo

  bounding_box = grid%lonlat_bounding_box()
  FCTEST_CHECK_CLOSE( bounding_box%west(),    0._dp, 1.e-10_dp )
  FCTEST_CHECK_CLOSE( bounding_box%east(),  360._dp, 1.e-10_dp )
  FCTEST_CHECK_CLOSE( bounding_box%south(), -90._dp, 1.e-10_dp )
  FCTEST_CHECK_CLOSE( bounding_box%north(),  90._dp, 1.e-10_dp )

  call bounding_box%final()
  call grid%final()
END_TEST

! -----------------------------------------------------------------------------

END_TESTSUITE
