#!/bin/sh -e

if ! test -f /etc/hotplug/firmware.agent; then
    echo "/etc/hotplug/firmware.agent does not exist:"
    echo "please install an up-to-date hotplug package and re-try."
    exit 1
fi

if ! test -d /usr/lib/hotplug/firmware; then
    mkdir -p /usr/lib/hotplug/firmware
fi 

# Remove files from old locations installed by previous versions.
if test -f /etc/hotplug.d/firmware/atmel.hotplug; then
    echo "Removing old script /etc/hotplug.d/firmware/atmel.hotplug"
    rm -f /etc/hotplug.d/firmware/atmel.hotplug
fi

if test -d /usr/share/firmware/atmel_at76c50x; then
    echo "Removing old directory /usr/share/firmware/atmel_at76c50x";
    rm -rf /usr/share/firmware/atmel_at76c50x
fi

echo "Installing new firmware files in /usr/lib/hotplug/firmware"
cp images/* /usr/lib/hotplug/firmware
cp images.usb/* /usr/lib/hotplug/firmware

echo "Installing firmware loader in /usr/sbin/atmel_fwl"
gcc -o /usr/sbin/atmel_fwl atmel_fwl.c
cp atmel_fwl.8 /usr/share/man/man8

if [ -f /etc/pcmcia/atmel.conf ] && \
    ! fgrep -q atmel_cs /etc/pcmcia/atmel.conf; then
    echo "Saving atmelwlandriver-derived atmel.conf as atmel.wlandriver"
    mv /etc/pcmcia/atmel.conf /etc/pcmcia/atmel.wlandriver
fi

echo "Installing PCMCIA config in /etc/pcmcia/atmel.conf"
cp atmel.conf /etc/pcmcia

if [ -f /var/run/cardmgr.pid ]; then
    echo "Re-reading PCMCIA configuration"
    kill -HUP `cat /var/run/cardmgr.pid`
fi
