#!/bin/bash

PID=0
VID=0
BoardType=0
BoardDefine=0
BoardTypeLib=0

function GetPIDVID()
{
	echo -n "Give the desired Product ID : 0x"
	read PID
	echo -n "Give the desired Vendor  ID : 0x"
	read VID
	echo "What type of board do you have?"
	echo -n "(1: RFMD, 2:Intersil 3861, 3:Intersil 3863)?"
	read BoardType
	F=newconfig.h
	if [ -f $F ]; then rm -f $F; fi
	grep -v 'ine VNetPID_CU' usb_src/config.h |grep -v 'ine VNetVID_CU' >usb_src/config.h
	while read A
	do
		FOUND=$(echo "$A"|grep -c 'define __con')
		TABN=$(echo "$A"|grep -c USB_DEVICE)
		EMBLOCK=$(echo "$A"|grep -c '{ }')
		if [ $FOUND -eq 1 ]; then
			echo "$A" >> $F
			echo >> $F
			echo "#define VNetVID_CUSTOM 0x$VID" >> $F
			echo "#define VNetPID_CUSTOM 0x$PID" >> $F
			echo "" >> $F
		else
			if [ $TABN -eq 1 ] || [ $EMBLOCK -eq 1 ]; then
				echo -e "\t$A" >> $F
			else
				echo "$A" >>  $F
			fi
		fi
	done < usb_src/config.h
	rm -f usb_src/config.h
	mv $F usb_src/config.h
	case $BoardType in
	1 )
		BoardTypeLib=vnetusbRFMD
		BoardDefine=-DRFMD
		;;
	2 )		
		BoardTypeLib=vnetusb
		;;
	3 )
		BoardTypeLib=vnetusbi3863
		BoardDefine=-Di3863
		;;
	* )	
		echo "Invalid input gived. Please retry"
		return
		;;
	esac
}
