/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>		/* gethostbyname, getnetbyname */
#include <getopt.h>
#include <linux/if_arp.h>	/* For ARPHRD_ETHER */
#include <linux/socket.h>	/* For AF_INET & struct sockaddr */
#include "vnetioctl.h"
#include <linux/wireless.h>
#include <termios.h>
#include <ncurses.h>

#define ifr_name	ifr_ifrn.ifrn_name	/* interface name 	*/
#define ifr_hwaddr	ifr_ifru.ifru_hwaddr	/* MAC address 		*/
#define	ifr_addr	ifr_ifru.ifru_addr	/* address		*/

#define MAX_SSID_LENGTH			32

#define SHORT_WEP_KEY_SIZE		5
#define LONG_WEP_KEY_SIZE		13

#define WEP_DISABLED			0
#define WEP_64bit			1

typedef unsigned char 	UCHAR;
typedef unsigned short 	USHORT;
typedef unsigned long 	ULONG;
typedef unsigned int 	UINT;

typedef unsigned char* 	PUCHAR;
typedef unsigned short*	PUSHORT;
typedef int	 	BOOLEAN;

typedef void		VOID;

typedef struct termios KB_SETTINGS;


static char name[BUFSIZ];
static char *cmdname[]= {"v","c","x","r","i"};	// v : view stats c: config x: exit r: reset i:ifdown ifup
static char *choice[]={"e","c","p","t","o","r","f","s","w","b"};
static struct termios Stored_Settings;
char ifname[10];

typedef struct iw_statistics	iwstats;
typedef struct iw_range		iwrange;
typedef struct iw_freq		iwfreq;
typedef struct iw_priv_args	iwprivargs;
typedef struct sockaddr		sockaddr;

typedef struct __WEP_INFO
{
	UCHAR						WepKeyToUse;
	UCHAR						WepMode;
	USHORT						AuthenticationType;
	UCHAR						EncryptionLevel;					//0:Disabled,1:64bit,2:128 bit
	UCHAR						WepKey1[LONG_WEP_KEY_SIZE];
	UCHAR						WepKey2[LONG_WEP_KEY_SIZE];
	UCHAR						WepKey3[LONG_WEP_KEY_SIZE];
	UCHAR						WepKey4[LONG_WEP_KEY_SIZE];
} WEP_INFO, *PWEP_INFO;

typedef struct __VERSION_INFO{
	UCHAR	DriverMajorVersion;
	UCHAR	DriverMinorVersion;
	UCHAR	DriverSubVersion;
	USHORT	DriverBuild;

	USHORT	FwMajorVersion;
	USHORT	FwMinorVersion;
	USHORT	FwSubVersion;
	USHORT	FwBuild;

}VERSION_INFO, *PVERSION_INFO;

typedef struct __STATISTICS{
	ULONG	TxDataPacketsOk;
	ULONG	TxDataPacketsError;
	ULONG	TxMgmtPacketsOk;
	ULONG	TxMgmtPacketsError;

	ULONG	RxDataPacketsOk;
	ULONG	RxDataPacketsError;
	ULONG	RxMgmtPacketsOk;
	ULONG	RxMgmtPacketsError;

	ULONG	RxLost;
	ULONG	TxPacketsRejectedNotReady;
	ULONG	TxPacketsRejectedResources;
	ULONG	MatchingBeacons;
}STATISTICS, *PSTATISTICS;

typedef struct __DEVICE_CONFIGURATION
{
	UCHAR			OperatingMode;					//AD_HOC_MODE or INFRASTRUCTURE_MODE
	UCHAR			Channel;						
	UCHAR			SSID[MAX_SSID_LENGTH];			
	UCHAR			SSIDlength;
	UCHAR			TxRate;							//0-4
	UCHAR			PowerMgmtMode;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			InternationalRoaming;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			RadioIsOn;					// PM_MODE_ACTIVE or PM_MODE_POWER_SAVE
	UCHAR			PreambleType;					// LONG_PREAMBLE or SHORT_PREAMBLE
	USHORT			FragmentationThreshold;			
	USHORT			RtsCtsThreshold;
	UCHAR			BSSID[6];
	UCHAR			StationState;
	UCHAR			Rssi;
	UCHAR			LinkQuality;
	UCHAR			RegDomain;
        UCHAR                   ChannelVector[14];
	ULONG			MgmtErrorCode;			
}DEVICE_CONFIGURATION, *PDEVICE_CONFIGURATION;

typedef struct __STR_LIST{
	struct __STR_LIST	*next;
	char				*string1;
	char				*value;
}STR_LIST, *PSTR_LIST;
#define STR_LIST_SIZE sizeof(STR_LIST)
#include "stdinclude.h"

#include "ncurses.h"
