/****************************************************************
**
** Attal : Lords of Doom
**
** aiLord.cpp
** manages an ai lord
**
** Version : $Id: aiLord.cpp,v 1.1 2006/06/02 19:41:17 lusum Exp $
**
** Author(s) : Sardi Carlo
**
** Date : 27/07/2005
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "aiLord.h"

// generic include files
// include files for QT
// application specific include files

#include "libCommon/genericMapCreature.h"
#include "libCommon/unit.h"

//extern DataTheme DataTheme;
extern QString DATA_PATH;

//
// ----- GenericLord -----
//

AiLord::AiLord():GenericLord()
{
	
	for(int i = PR_ENEMY;i<=PR_LAST;i++){ 
		_priorities[i]=(i*10);
	}	

}

AiLord::~AiLord()
{
}

void AiLord::reinit()
{
}

int AiLord::getPower()
{
	int power = 0;

	for( int i = 0; i < MAX_UNIT; i++ ) {
		GenericFightUnit * lordUnit = getUnit( i );
		if( lordUnit ) {
			power += lordUnit->getCreature()->getAttack() * lordUnit->getNumber();
		}
	}
	return power;
}



