/****************************************************************
**
** Attal : Lords of Doom
**
** askChest.cpp
** Dialog for asking the player about the chest content
**
** Version : $Id: askChest.cpp,v 1.3 2006/03/10 19:09:39 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/05/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "askChest.h"
 
// generic include files
// include files for QT
#include <QLabel>
#include <QLayout>
#include <QPushButton>
//Added by qt3to4:
#include <QVBoxLayout>
#include <QHBoxLayout>
// application specific include files
#include "libCommon/log.h"

#include "libClient/gui.h"


AskChest::AskChest()
: QDialog( 0, Qt::Dialog )
{
	_result = 0;

	QLabel * labQuestion = new QLabel( this );
	labQuestion->setText( tr( "Choose between earning 1000 Gold or 2500 Experience" ) );
	FIXEDSIZE( labQuestion );

	QPushButton * gold = new QPushButton( this );
	gold->setText( tr( "Gold" ) );
	FIXEDSIZE( gold );

	QPushButton * experience = new QPushButton( this );
	experience->setText( tr( "Experience" ) );
	FIXEDSIZE( experience );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->addStretch( 1 );
	layH1->addWidget( gold );
	layH1->addStretch( 1 );
	layH1->addWidget( experience );
	layH1->addStretch( 1 );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addWidget( labQuestion,0 ,Qt::AlignLeft );
	layout->addLayout( layH1 );
	layout->addStretch( 1 );
	layout->activate();

	connect( gold, SIGNAL( clicked() ), SLOT( slot_gold() ) );
	connect( experience, SIGNAL( clicked() ), SLOT( slot_experience() ) );
}

void AskChest::slot_gold()
{
	_result = 0;
	accept();
}

void AskChest::slot_experience()
{
	_result = 1;
	accept();
}


