/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalArtefact.h
** Display artefacts on the map
**
** Version : $Id: graphicalArtefact.h,v 1.3 2005/10/30 22:20:56 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 19/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef GRAPHICALARTEFACT_H
#define GRAPHICALARTEFACT_H
 
 
// generic include files
// include files for QT
#include <Q3Canvas>
// application specific include files
#include "libCommon/artefact.h"
 
class GenericCell;
class GenericLord;

/*              ------------------------------
 *                         Artefact
 *              ------------------------------ */



/** comment for the class */
class Artefact : public Q3CanvasSprite, public GenericArtefact
{
 
public:
	/** Constructor */
	Artefact( Q3Canvas * canvas );

	void setCell( GenericCell * cell );

	void setLord( GenericLord * lord );
	
	virtual void setType( uint type );

        static const int RTTI;
	/** Return RTTI */
	int rtti() const { return RTTI; };
};
 
#endif // GRAPHICALARTEFACT_H   
