/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalCell.h
** this class draws an animated cell
**
** Version : $Id: graphicalCell.h,v 1.5 2005/10/30 22:20:56 audoux Exp $
**
** Author(s) : Pascal Audoux - Cyrille Verrier - Sardi Carlo
**
** Date : 02/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef GRAPHICALCELL_H
#define GRAPHICALCELL_H
 
 
// generic include files

// include files for QT
#include <Q3Canvas>

// application specific include
#include "libCommon/genericCell.h"

class Lord;
class Cell;

/*              ------------------------------
 *                         GraphicalCell
 *              ------------------------------ */



/** create an animated cell from pixmaps at position row,col */
class GraphicalCell : public Q3CanvasSprite
{
public:
	/** Constructor */
	GraphicalCell( int row, int col , Q3Canvas * canvas);

	/** destructor */
	virtual ~GraphicalCell();

	/** Return true if the point is on the cell */
	bool hit( const QPoint & p ) const;

	/** Return RTTI */
	int rtti() const { return RTTI; };

	static const int RTTI;

	void setType( const int type );

	void setDiversification( uint divers );

	/** \return Returns parent cell */
	virtual Cell * getParent() { return ( (Cell*)this ); }

	virtual void activateGrid( bool activate );

private:
	Q3CanvasPixmapArray * _frames;

	static const int _size;

	uint _diversGr;
	
};

/** Manage a graphical transition on cell */
class Transition : public GraphicalCell
{
public:
	/** Constructor */
	Transition( Cell * parent, Q3Canvas * canvas);

	/** Sets transition type */
	void setTransition( int transition, int type );

	/** \return Returns parent cell */
	Cell * getParent() { return _parent; }
	
	void activateGrid( bool activate );

private:
	Cell * _parent;
	
	uint _tranGr;
};

/** Manages a decoration on the cell */
class Decoration : public GraphicalCell
{
public:
	/** Constructor */
	Decoration( Cell * parent, Q3Canvas * canvas);

	/** Set decoration type */
	void setDecoration( uint group, uint item );

	/** \return Returns parent cell */
	Cell * getParent() { return _parent; }

private:
	Cell * _parent;
};



#endif // GRAPHICALCELL_H
