/****************************************************************
**
** Attal : Lords of Doom
**
** graphicalLord.h
** draw a hero on the map
**
** Version : $Id: graphicalLord.h,v 1.5 2005/10/30 22:20:56 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 09/08/2000
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#ifndef GRAPHICALLORD_H
#define GRAPHICALLORD_H
 
// generic include files
// include files for QT
#include <Q3Canvas>
#include <QColor>
#include <QImage>
// application specific includes
#include "libClient/cell.h"
#include "libClient/flag.h"

class GenericPlayer;

/*              ------------------------------
 *                        GraphicalLord
 *              ------------------------------ */

/** build the graphical part of the Lord */
class GraphicalLord : public Q3CanvasSprite
{
public:
	/** Constructor */
	GraphicalLord( Q3Canvas * canvas );

	virtual ~GraphicalLord();

	/** Set the Lord on the cell */
	virtual void setPosition( Cell *cell );
	
	/** Move the lord at the given cell */
	virtual void goTo( GenericCell *cell );
	
	virtual void setVisible( bool state );
	
	/** Advance animation */
	void advance( int stage );

	virtual void highlight( bool state);
	
	virtual void setOwner( GenericPlayer * player );

	QRgb colorH( QRgb v );
	
	/** Return RTTI */
	int rtti() const { return RTTI; };
	
	static const int RTTI;
	
protected:
	Q3CanvasPixmap* imageAdvanced() const;
	Flag * _flag;
	QImage _imabk;
};

#endif // GRAPHICALLORD_H

