/****************************************************************
**
** Attal : Lords of Doom
**
** insideAction.cpp
** Dialogs for actions of inside buildings
**
** Version : $Id: insideAction.cpp,v 1.25 2006/03/11 14:59:36 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo 
**
** Date : 10/05/2002
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "insideAction.h"

// generic include files
// include files for QT
#include <QHBoxLayout>
#include <QLabel>
#include <QMessageBox>
#include <QPushButton>
#include <QScrollArea>
#include <QSignalMapper>
#include <QVBoxLayout>

// application specific include files
#include "libClient/attalButton.h"
#include "libClient/displayCreature.h"
#include "libClient/gui.h"

#include "libCommon/attalSocket.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericInsideBuilding.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/genericRessources.h"
#include "libCommon/genericInsideBuilding.h"

extern QString IMAGE_PATH;
extern DataTheme DataTheme;

//
// ----- InsideActionAllBuildings -----
//

InsideActionAllBuildings::InsideActionAllBuildings( GenericBase * base, QWidget * parent, const char * /* name */)
	:QDialog( parent, Qt::Dialog )
{
	_base = base;
	_socket = 0;
	_player = 0;
	_buildings = 0;

	_buildings = new BuildingsView( base, 0 );

	QScrollArea * scroll = new QScrollArea( this );
	scroll->setVerticalScrollBarPolicy( Qt::ScrollBarAlwaysOn );
	scroll->setWidget( _buildings );
	
	AttalButton * pbOk = new AttalButton( this, AttalButton::BT_OK );

	QHBoxLayout * layH = new QHBoxLayout();
	layH->addStretch( 1 );
	layH->addWidget( pbOk );
	layH->addStretch( 1 );
	
	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->addWidget( scroll, 1 );
	layout->addSpacing( 5 );
	layout->addLayout( layH );
	layout->activate();

	connect( pbOk, SIGNAL( clicked() ), SLOT( accept() ) );
	connect( _buildings, SIGNAL( sig_buy( int ) ), SLOT( slot_buy( int ) ) );
	connect( _buildings, SIGNAL( sig_sell( int ) ), SLOT( slot_sell( int ) ) );
	setFixedSize( 800, 600 );
}

void InsideActionAllBuildings::slot_buy( int building )
{
	// XXX: check if 'buy' is possible...
	if( _player && _socket ) {
		if( _player->canBuy( DataTheme.bases.at( _base->getRace() )->getBuildingModel( building ) ) ) {
			_socket->requestBuilding( _base, building, true );
		} else {
			QMessageBox::warning( this, "Can't buy", "Not enough ressources to buy this building" );
		}
	} else {
		logEE( "Player or socket not initialized for InsideActionAllBuildings" );
	}
}

void InsideActionAllBuildings::slot_sell( int building )
{	
	if( _player && _socket ) {	
		QMessageBox msb( tr( "Building" ), tr( "Are you sure to sell this building?" ), QMessageBox::Warning, QMessageBox::Yes | 			QMessageBox::Default, QMessageBox::No | QMessageBox::Escape, 0, this );
		if( msb.exec() == QMessageBox::Yes){
			_socket->requestBuilding( _base, building, false );
		}
	}
}

void InsideActionAllBuildings::updateView()
{
	_buildings->updateView();
}
	
void InsideActionAllBuildings::setPlayer( GenericPlayer * player ) 
{ 
	_player = player; 
	_buildings->setPlayer(_player);
	updateView();
}


//
// ----- BuildingsView -----
//

BuildingsView::BuildingsView( GenericBase * base, QWidget * parent, const char * name )
	:QWidget( parent, name )
{
	_base=base;
	_player = 0;
	QSignalMapper * sigmap = new QSignalMapper( this );
	QSignalMapper * sigmap2 = new QSignalMapper( this );
	GenericBaseModel * baseModel = DataTheme.bases.at( base->getRace() );
	QVBoxLayout * layout = new QVBoxLayout( this );

	_panels = new BuildingPanel * [baseModel->getBuildingCount()];
	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		_panels[i] = 0;
		InsideBuildingModel * building = baseModel->getBuildingModel( i );
		_panels[i] = new BuildingPanel( building, this );
		sigmap->setMapping( _panels[i], i );
		sigmap2->setMapping( _panels[i], i );
		connect( _panels[i], SIGNAL( sig_buy() ), sigmap, SLOT( map() ) );
		connect( _panels[i], SIGNAL( sig_sell() ), sigmap2, SLOT( map() ) );
		_panels[i]->disable( false );
		if( base->hasBuildingType( i ) ) {
			_panels[i]->setBuyable( false );
			_panels[i]->setSellable( true );
		} else {
			_panels[i]->setBuyable( true );
			_panels[i]->setSellable( false );
		}
	}

	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		InsideBuildingModel * building = baseModel->getBuildingModel( i );
		if( building->getAction() ) {
			if( building->getAction()->getType() != INSIDE_NONE ) {
				if( ! base->hasBuildingType( i ) ) {
					layout->addWidget( _panels[i] );
				}
			}
		}
	}

	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		InsideBuildingModel * building = baseModel->getBuildingModel( i );
		if( building->getAction() ) {
			if( building->getAction()->getType() != INSIDE_NONE ) {
				if( base->hasBuildingType( i ) ) {
					layout->addWidget( _panels[i] );
				}
			}
		}
	}

	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		InsideBuildingModel * building = baseModel->getBuildingModel( i );
		if( building->getAction() ) {
			if( building->getAction()->getType() == INSIDE_NONE ) {
				layout->addWidget( _panels[i] );
			}
		}
		if( ! building->getAction() ) {
			layout->addWidget( _panels[i] );
		}
	}
	updateView();

	layout->activate();
	connect( sigmap, SIGNAL( mapped( int ) ), SIGNAL( sig_buy( int ) ) );
	connect( sigmap2, SIGNAL( mapped(int) ), SIGNAL( sig_sell(int) ) );
}

void BuildingsView::buy( int building )
{
	if( _panels[building] ) {
		_panels[building]->setBuyable( false );
		_panels[building]->setSellable( true );
	}
}

void BuildingsView::updateView()
{
	GenericBaseModel * baseModel = DataTheme.bases.at( _base->getRace() );
	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		if( ! _base->isForbidden( i ) ) {
			_panels[ i ]->show();
			InsideBuildingModel * building = baseModel->getBuildingModel( i );

			if( _base->hasBuildingType( i ) ) {
				_panels[i]->setBuyable( false );
				_panels[i]->setSellable( true );
				_panels[i]->disable( false );
			} else {
				if( _base->canBuildBuilding( building ) ) {
					if( _player ) {
						if (!_player->canBuy( building ) ) {
							_panels[i]->disable( true );
						}
					} else {
						_panels[i]->disable( false );
					}
					_panels[i]->setBuyable( true );
					_panels[i]->setSellable( false );
				} else {
					_panels[ i ]->hide();
				}
			} 
		} else {
			_panels[ i ]->hide();
		}
	}
}

//
// ----- BuildingPanel -----
//

BuildingPanel::BuildingPanel( InsideBuildingModel * model, QWidget * parent, const char * name )
	:QFrame( parent, name )
{
	_model = model;
	_buyEnabled = true;
	
	setFrameStyle( QFrame::Box | QFrame::Raised );
	setLineWidth( 1 );
	setMidLineWidth( 1 );

	// XXX: add pic of building first...
	QLabel * smallPic = new QLabel( this );
	QString pixmapPath;
	pixmapPath.sprintf( "base/race_%d/buildingView_%d.png", _model->getRace(), _model->getLevel() );
	smallPic->setPixmap( IMAGE_PATH + pixmapPath );
	smallPic->setFixedSize( 100, 80 );

	QLabel * thename = new QLabel( this );
	thename->setText( "Name: " + model->getName() );
	FIXEDSIZE( thename );
	
	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->addSpacing( 5 );
	layH1->addWidget( thename );
	layH1->addStretch( 1 );
	
	QLabel * desc = new QLabel( this );
	desc->setText( "Description: \n" + model->getDescription()  +  "\n" + model->getBuildDescActions() );
	FIXEDSIZE( desc );
	
	QHBoxLayout * layH2 = new QHBoxLayout();
	layH2->addSpacing( 5 );
	layH2->addWidget( desc );
	layH2->addStretch( 1 );
		
	QVBoxLayout * layV1 = new QVBoxLayout();
	layV1->setMargin( 5 );
	layV1->setSpacing( 5 );
	layV1->addLayout( layH1 );
	layV1->addLayout( layH2 );
	layV1->addStretch( 1 );
	
	QPushButton * pbInfo = new QPushButton( this );
	pbInfo->setText( tr( "Info" ) );
	FIXEDSIZE( pbInfo );
	
	_pbBuySell = new QPushButton( this );
	updateBuySell();
	
	QVBoxLayout * layV2 = new QVBoxLayout();
	layV2->setMargin( 5 );
	layV2->setSpacing( 5 );
	layV2->addStretch( 1 );
	layV2->addWidget( pbInfo );
	layV2->addStretch( 1 );
	layV2->addWidget( _pbBuySell );
	layV2->addStretch( 1 );
	
	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addWidget( smallPic );
	layout->addLayout( layV1 );
	layout->addStretch( 1 );
	layout->addLayout( layV2 );
	layout->activate();
	
	connect( pbInfo, SIGNAL( clicked() ), SLOT( slot_info() ) );
	connect( _pbBuySell, SIGNAL( clicked() ), SLOT( slot_buysell() ) );
}

void BuildingPanel::slot_info()
{
	QString text = "";

	text = _model->getBuildDescActions();
	QMessageBox::information( this, tr( "Building informations" ), text, tr( "Ok" ) );
}

void BuildingPanel::slot_buysell()
{
	if( _buyEnabled ) {
		emit sig_buy();
	} else {
		emit sig_sell();
	}
}

void BuildingPanel::disable( bool state )
{
	_pbBuySell->setDisabled( state );
}

void BuildingPanel::setBuyable( bool state )
{
	_buyEnabled = state;
	updateBuySell();
}

void BuildingPanel::setSellable( bool state )
{
	_buyEnabled = ! state;
	updateBuySell();
}

void BuildingPanel::updateBuySell()
{
	if( _buyEnabled ) {
		_pbBuySell->setText( tr( "Buy" ) );
	} else {
		_pbBuySell->setText( tr( "Sell" ) );
	}
	FIXEDSIZE( _pbBuySell );
}

//
// ----- InsideActionSomeCreature -----
//
/*
InsideActionSomeCreature::InsideActionSomeCreature( int race, int level, QWidget * parent, const char * name )
	: QDialog( parent, Qt::Dialog )
{
	QGridLayout * layout = new QGridLayout( this );
	DisplayCreature * cre = new DisplayCreature( this );
	cre->setCreature( race, level );
	layout->addWidget( cre, 0, 0 );
	layout->setRowStretch( 0, 1 );
	layout->setColStretch( 0, 1 );
	layout->activate();
}*/

//
// ----- DisplayCreatureBase -----
//

DisplayCreatureBase::DisplayCreatureBase( GenericBase * base ,QWidget * parent, const char * /* name */ )
	: QDialog( parent, Qt::Dialog )
{
	_player = 0;
	_base = base;
	_socket = 0;

	QVBoxLayout * lay = new QVBoxLayout( this );

	uint nbLay = 0;

	QSignalMapper * sigmap = new QSignalMapper( this );
	for( int i = 0; i < DataTheme.creatures.getRace(_base->getRace())->count();i++ ) {
		_buy[i] = new DisplayCreature( this );
		_buy[i]->setCreature( _base->getRace(), i , base);
		
		if( (i % 2) == 0 ) {
			nbLay = (i/2) + 1;
			_layH[nbLay] = new QHBoxLayout();
		}
		_layH[nbLay]->addWidget( _buy[i], 1 );
		_layH[nbLay]->addSpacing( 5 );
		sigmap->setMapping( _buy[i], i );
		connect( _buy[i], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );
	}

	if((DataTheme.creatures.getRace(_base->getRace())->count() % 2) != 0){
		_layH[nbLay]->addStretch( 1 );
	}

	for( uint i = 1; i <= nbLay; i++) {
		lay->addLayout( _layH[i], 1 );
		lay->addSpacing( 5 );
	}

	lay->activate();

	connect( sigmap, SIGNAL( mapped( int ) ), SLOT( slot_buyUnit( int ) ) );
	connect( parent, SIGNAL( sig_castle() ), SLOT( slot_reinit() ) );
}
	
void DisplayCreatureBase::init( GenericPlayer * player)
{
	_player = player;
}

void DisplayCreatureBase::slot_buyUnit( int num )
{
	BuyCreature es( this );
	es.initSocket(_socket);
	es.init( _player, _base, _buy[num]->getCreature() );
	es.exec();
}


void DisplayCreatureBase::slot_reinit()
{
	for( int i = 0; i < DataTheme.creatures.getRace(_base->getRace())->count();i++ ) {
		_buy[i]->setCreature( _base->getRace(), i , _base);
	}

}
	
