/****************************************************************
**
** Attal : Lords of Doom
**
** insideBuilding.cpp
** display building on the inside view
**
** Version : $Id: insideBuilding.cpp,v 1.8 2005/12/31 17:25:47 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 04/11/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "insideBuilding.h"
 
// generic include files
#include <algorithm>
// include files for QT
#include <QPainter>
#include <QPixmap>
// application specific include files
#include "libClient/imageTheme.h"

#include "conf.h"

#include "libCommon/log.h"
#include "libCommon/genericInsideBuilding.h"

extern ImageTheme ImageTheme;

const int InsideBuilding::RTTI = 52;

InsideBuilding::InsideBuilding( int type, GenericInsideBuilding * build, Q3Canvas * canvas )
//	: QCanvasSprite( ImageTheme.insideBuildings[type], canvas )
	: Q3CanvasRectangle( canvas )
{
	_type = type;
	_building = build;
	_newpix = 0;
 	//collisions( true );
 	//setFrame( 2 * _building->getLevel() );
	_oldpix = ImageTheme.insideBuildings[ _type ]->image( _building->getLevel()  );
	_pixmap = _oldpix;
	_image = _pixmap->toImage();
	
	QImage image = 	highlight( _image );
	_newpix = new QPixmap();
	*_newpix = QPixmap::fromImage(image , Qt::AutoColor);

	setSize( _pixmap->width(), _pixmap->height() );
	
	setEnabled( true );
	show();
}

InsideBuilding::~InsideBuilding()
{
	if(_newpix) {
		delete _newpix;
		_newpix = 0;
	}
}
/*
ImageItem::ImageItem( QImage img, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(img)
{
    setSize( image.width(), image.height() );

#if !defined(Q_WS_QWS)
    pixmap = QPixmap::fromImage(image, OrderedAlphaDither);
#endif
}
*/

void InsideBuilding::drawShape( QPainter &p )
{
	p.drawPixmap( int( x() ), int( y() ), * _pixmap );
}

bool InsideBuilding::hit( const QPoint & p ) const
{
	bool ret = false;
	int ix = p.x()-int(x());
	int iy = p.y()-int(y());
	    
	if ( _image.valid( ix , iy ) ) {
		QRgb pixel = _image.pixel( ix, iy );
		ret = ( qAlpha( pixel ) != 0 );
		
	}
	return ret;
}


void InsideBuilding::move( int x, int y )
{
	Q3CanvasRectangle::move( x, y );
	setZ( int( y / 10 ) );
}

void InsideBuilding::select()
{
	//setFrame( (_building->getLevel() * 2) + 1 );
	_pixmap = _newpix;
	update();
}

void InsideBuilding::deselect()
{
	//setFrame( _building->getLevel() * 2 );
	_pixmap = _oldpix;
	update();
}

QImage InsideBuilding::highlight(QImage image)
{

		image.convertDepth( 32 );

		int w = image.width();
		int h = image.height();

		QImage img( w, h, 32 );
		img.setAlphaBuffer( TRUE );

		for ( int x = 0; x < w; x++ ) {
			for ( int y = 0; y < h; y++ ) {
				QRgb pixel = (x<w&y<h) ? image.pixel( x, y ) : 0;
				img.setPixel( x, y, colorH( pixel, 1.2 ) );
			}
		}
		return img;
}

QRgb InsideBuilding::colorH( QRgb v , double grade)
{
	int ach = qAlpha(v);

	int r = std::min ( (int) (qRed(v)* grade *255 /255),245);
	int g = std::min ( (int) (qGreen(v) * grade *255 /255),245);
	int b = std::min ( (int) (qBlue(v) * grade *255 /255),245);

	return qRgba(r,g,b,ach);
}

