/****************************************************************
**
** Attal : Lords of Doom
**
** action.cpp
** Manage actions of 'buildings'
**
** Version : $Id: action.cpp,v 1.6 2005/12/30 18:44:49 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 23/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "action.h"
 
// generic include files
// include files for QT
// application specific include files


// 
// ----- Action -----
// 

Action::Action()
{
	_type = Action::DATE;
}

Action::~Action()
{
	while( ! _list.isEmpty() ) {
		delete _list.takeFirst();
	}
}
	
QString Action::getActionTypeString( ActionType type )
{
	QString ret = "Unknown";


	switch( type ) {
		case DATE:
			ret = "date";
			break;
		case FIRSTTIME:
			ret = "first time";
			break;
		case FIRSTTIMELORD:
			ret = "first time lord";
			break;
		case NEXTTIME:
			ret = "next time";
			break;
	}

	return ret;
}


//
// ----- Elementary Action -----
//

ElementaryAction::ElementaryAction()
{
	_type = ElementaryAction::ATTACK;
	_arg = 0;
	_coeff = 0;
}

QString ElementaryAction::getElemTypeString( ElementaryType type )
{
	QString ret = "Unknown";


	switch( type ) {
		case ATTACK:
			ret = "attack";
			break;
		case DEFENSE:
			ret = "defense";
			break;
		case POWER:
			ret = "power";
			break;
		case KNOWLEDGE:
			ret = "knowledge";
			break;
		case MOVE:
			ret = "move";
			break;
		case MAXMOVE:
			ret = "maxmove";
			break;
		case TECHNICPOINT:
			ret = "techpoint";
			break;
		case MAXTECHNICPOINT:
			ret = "maxtechpoint";
			break;
		case MORALE:
			ret = "morale";
			break;
		case LUCK:
			ret = "luck";
			break;
		case VISION:
			ret = "vision";
			break;
		case EXPERIENCE:
			ret = "experience";
			break;
		case SKILL:
			ret = "skill";
			break;
		case ARTEFACT:
			ret = "artefact";
			break;
		case UNIT:
			ret = "unit";
			break;
		case RESSOURCE:
			ret = "resource";
			break;
		case RANDRESSOURCE:
			ret = "random resource";
			break;
		case CHARISMA:
			ret = "charisma";
			break;
		case POPULATION:
			ret = "population";
			break;
	}

	return ret;
}



//
// ----- InsideAction -----
//

InsideAction::InsideAction()
{
	_type = 0;
}

void InsideAction::addParam( int param )
{
	_params.append( param );
}

int InsideAction::getParam( uint num )
{
	int ret = 0;

	if( (int)num < _params.count() ) {
		ret = _params.at( num );
	}

	return ret;
}



