/****************************************************************
**
** Attal : Lords of Doom
**
** attalCommon.cpp
** Manage common data for everyone
**
** Version : $Id: attalCommon.cpp,v 1.11 2006/06/02 20:20:08 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 26/07/2005
**
** Licence :
**  This program is free software; you can redistribute it and/or modify
**      it under the terms of the GNU General Public License as published by
**      the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
****************************************************************/

#include "attalCommon.h"

// generic include files
// include files for QT
#include <QDir>
#include <QString>
// application specific include files
#include "conf.h"
#include "libCommon/log.h"

QString IMAGE_PATH( IMAGE_DEFAULT_PATH );

QString MUSIC_PATH( MUSIC_DEFAULT_PATH );

QString SOUND_PATH( SOUND_DEFAULT_PATH );

QString DATA_PATH( DATA_DEFAULT_PATH );

QString CAMPAIGN_PATH( CAMPAIGN_DEFAULT_PATH );

QString SCENARIO_PATH( SCENARIO_DEFAULT_PATH );

QString CONFIG_PATH( CONFIG_DEFAULT_PATH );

QString THEME( THEME_DEFAULT );

QString SAVE_PATH;

void useTheme()
{
    QDir folder;

    folder.setPath( "./themes/" + THEME );

#ifndef WIN32
		QString qConfigPath;
		qConfigPath = ATT_PREFIX;
    if( ! folder.exists() ) {
			folder.setPath( qConfigPath + "/share/games/attal/themes/" + THEME );
    }
#endif

    if( ! folder.exists() ) {
        logEE( "Theme %s not found", THEME.toLatin1().constData() );
    }
    THEME = THEME_DEFAULT;
    QString THEME_PATH = folder.absolutePath() + "/";

    IMAGE_PATH = THEME_PATH + IMAGE_DEFAULT_PATH;
    SOUND_PATH = THEME_PATH + SOUND_DEFAULT_PATH;
    MUSIC_PATH = THEME_PATH + MUSIC_DEFAULT_PATH;
    DATA_PATH = THEME_PATH + DATA_DEFAULT_PATH;
    CAMPAIGN_PATH = THEME_PATH + CAMPAIGN_DEFAULT_PATH;
    SCENARIO_PATH = THEME_PATH + SCENARIO_DEFAULT_PATH;

		CONFIG_PATH = QDir::homePath() + CONFIG_DEFAULT_PATH; 
		folder.setPath(CONFIG_PATH);
    if( ! folder.exists() ) {
			if(!folder.mkdir(CONFIG_PATH)) {
				logEE( "Cannot create config dir %s", CONFIG_PATH.toLatin1().constData() );
			}
		}
		SAVE_PATH =  CONFIG_PATH + "saves/";
		folder.setPath(SAVE_PATH);
    if( ! folder.exists() ) {
			if(!folder.mkdir(SAVE_PATH)) {
				logEE( "Cannot create save dir %s", SAVE_PATH.toLatin1().constData() );
			}
		}
    /// XXX: need more tests of existence
}

QDir translationsDir()
{

    QDir trfolder;
    trfolder.setPath( "."  );
#ifndef WIN32
		QString qConfigPath;
		qConfigPath = ATT_PREFIX;
		//logDD("attalCommon %s", qConfigPath.toLatin1().constData());
    if( ! trfolder.exists() ) {
			trfolder.setPath( qConfigPath + "/share/games/attal/themes/" + THEME );
    }
#endif
    return trfolder;

}






