/****************************************************************
**
** Attal : Lords of Doom
**
** previewBaseDialog.cpp
** dialog for preview of a base with buildings
**
** Version : $Id: previewBaseDialog.cpp,v 1.6 2006/02/28 16:12:06 lusum Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 28/06/2003
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "previewBaseDialog.h"
 
// generic include files
// include files for QT
#include <QLayout>
#include <Q3ListView>
//Added by qt3to4:
#include <QHBoxLayout>
// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericInsideBuilding.h"

#include "libClient/gui.h"
#include "libClient/insideBase.h"

extern DataTheme DataTheme;

PreviewBaseDialog::PreviewBaseDialog( QWidget * parent, const char * name )
: QDialog( parent, Qt::Dialog )
{
	_base = 0;

	_inside = new InsideBase( this );
	InsideBaseView * view = new InsideBaseView( _inside, this );

	_listBuilding = new Q3ListView( this );
	_listBuilding->addColumn( tr( "Buildings" ) );
	_listBuilding->setSorting( -1 );


	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->addWidget( view, 1 );
	layout->addWidget( _listBuilding );
	layout->activate();

	connect( _listBuilding, SIGNAL( clicked( Q3ListViewItem * ) ), SLOT( slot_clickBuilding( Q3ListViewItem * ) ) );
}

PreviewBaseDialog::~PreviewBaseDialog()
{
	delete _base;
}

void PreviewBaseDialog::init( GenericBaseModel * model )
{
	delete _base;

	_base = new GenericBase();
	_base->setRace( model->getRace() );
	_inside->setBase( _base );

	_listBuilding->clear();
	for( int i = DataTheme.bases.at( _base->getRace() )->getBuildingCount() - 1; i >= 0; i-- ) {
		InsideBuildingModel * building = DataTheme.bases.at( _base->getRace() )->getBuildingModel( i );
		new Q3CheckListItem( _listBuilding, building->getName(), Q3CheckListItem::CheckBox );
	}
	FIXEDSIZE( _listBuilding );
}

void PreviewBaseDialog::slot_clickBuilding( Q3ListViewItem * item )
{
	Q3CheckListItem * check = (Q3CheckListItem *)item;
	int i = 0;
	Q3ListViewItemIterator ite( _listBuilding );
	for( ite.current(); ite.current(); ++ite ) {
		if( ( (Q3CheckListItem*) ite.current() ) == check ) {
			break;
		}
		i++;
	}

	if( check->isOn() ) {
		_base->addBuilding( i );
		GenericInsideBuilding * build = _base->getBuildingByType( i );
		_inside->addBuilding( build );
	} else {
		GenericInsideBuilding * build = _base->getBuildingByType( i );
		_inside->delBuilding( build );
		_base->removeBuildingType( i );
	}
	_inside->update();
}



