/****************************************************************
**
** Attal : Lords of Doom
**
** analyst.cpp
** analyse the game and play
**
** Version : $Id: analyst.cpp,v 1.19 2004/04/06 22:02:18 lusum Exp $
**
** Author(s) : Pascal Audoux - Carlo
**
** Date : 06/02/2001
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "analyst.h"

// generic include files
#include <stdlib.h>
// include files for QT
// application specific include files
#include "libCommon/artefactManager.h"
#include "libCommon/attalSocket.h"
#include "libCommon/calendar.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericBuilding.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericMap.h"
#include "libCommon/genericEvent.h"
#include "libCommon/genericMapCreature.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/pathFinder.h"

#include "libServer/fightAnalyst.h"

#include "ai/aiInterface.h"


extern DataTheme DataTheme;

//
// ----- Analyst -----
//

Analyst::Analyst()
: GameData()
{
	_fight = 0;
	_socket = 0;
	_calendar = new Calendar();
	_calendar->reinit();

	_map = new GenericMap();
	_player = new GenericPlayer( _map );

	/*_lords = new GenericLord * [ DataTheme.lords.count() ];
	for( uint i = 0; i < DataTheme.lords.count(); i++ ) {
		_lords[i] = new GenericLord();
		_lords[i]->setId( i );
	}*/

}

Analyst::~Analyst()
{
	delete _player;
	delete _map;
	delete _calendar;
}

void Analyst::reinit()
{

	delete _player;
	delete _map;
	delete _calendar;
	
	_fight = 0;
	_calendar = new Calendar();
	_calendar->reinit();

	_map = new GenericMap();
	_player = new GenericPlayer( _map );

	/*_lords = new GenericLord * [ DataTheme.lords.count() ];
	for( uint i = 0; i < DataTheme.lords.count(); i++ ) {
		_lords[i] = new GenericLord();
		_lords[i]->setId( i );
	}*/

}


/*
GenericLord * Analyst::getLord( uint num )
{
	GenericLord * lord = 0;

	if( num < DataTheme.lords.count() ) {
		lord = _lords[num];
	}

	return lord;
}
*/
void Analyst::socketMsg()
{
	ialogV( "SO_MSG" );
}


/*!

*/

void Analyst::socketConnect()
{
	ialogV( "SO_CONNECT" );
	switch( _socket->getCla2() ) {
	case C_CONN_OK:
		ialogN( "Receive: Connect Ok" );
		_socket->sendConnectionName( "IA" );
		break;
	case C_CONN_ID:{
		_player->setNum(_socket->readChar());
		ialogN( "Receive: Connect Id = %d", _player->getNum() );
		}
		break;
	case C_CONN_NAME:
		ialogN( "Receive: Connect Name" );
		break;
	case C_CONN_PLAYER:
		ialogN( "Receive: Connect Player" );
		break;
	}
}

void Analyst::socketMvt()
{
	ialogV( "SO_MVT" );
	uchar lord = _socket->readChar();
	int row = _socket->readInt();
	int col = _socket->readInt();

	GenericLord * theLord = getLord( lord );

	int cost = theLord->computeCostMvt( _map->at( row, col ) );
	if( cost >= 0 ) {
		theLord->decreaseBaseCharac( MOVE, cost );
	}

	theLord->moveTo( _map->at( row, col ) );

	if( _map->computeMinimalNextCost( theLord ) > theLord->getCharac( MOVE ) ) {
		theLord->setBaseCharac( MOVE, 0 );
	}

	/// TODO: manage enter inside buildings and bases
	if( _map->at( row, col )->getBuilding() != 0 ) {
			if( _map->at(row, col)->getBuilding()->getOwner() != theLord->getOwner()) {
			 _map->at(row, col)->getBuilding()->setOwner(theLord->getOwner()); 
			}	
		if( theLord->getOwner() == _player ) {
			/// TODO: enter( _player->getSelectedLord(), _map->at( row, col )->getBuilding() );
		}
	} else if( _map->at( row, col )->getBase() != 0 ) {
		if( theLord->getOwner() == _player ) {
			/// TODO: enter( _player->getSelectedLord(), _map->at( row, col )->getBase() );
			enterBase(theLord, _map->at( row, col )->getBase());
		}
	}
}


void Analyst::socketTechnic()
{
	ialogV( "SO_TECHNIC" );
}

void Analyst::socketFight()
{
	ialogV( "SO_FIGHT" );

	switch( _socket->getCla2() ) {
	case C_FIGHT_INIT:
		ialogN( "INIT" );
		if( ! _fight ) {
			_fight = new FightAnalyst( this );
			_fight->setSocket( _socket );
		}
		_fight->handleFightSocket();
		break;
	case C_FIGHT_END:
		ialogN( "END" );
		delete _fight;
		_fight = 0;
		_socket->sendLordTurn( PL_SAME_LORD );
		break;
	default:
		if( _fight ) {
			_fight->handleFightSocket();
		} else {
			logEE( "Should not happen" );
		}
		break;
	}
}


/*!

*/

void Analyst::socketQR()
{
	ialogV( "SO_QR" );
}

void Analyst::socketExch()
{
	ialogV( "SO_EXCH" );

	switch( _socket->getCla2() ) {
	case C_EXCH_START:
		exchangeStart();
		break;
	case C_EXCH_UNIT:
	  	exchangeUnits();
		break;
	case C_EXCH_BASEUNITCL:
	  	exchangeBaseUnits();
		break;
	default:
		break;
	}
}

void Analyst::exchangeStart()
{
	/// XXX: not finished...
	//uchar idLord1 = _socket->readChar();
	//uchar idLord2 = _socket->readChar();
	//GenericLord * lord1 = _lords.at( idLord1 );
	//GenericLord * lord2 = _lords.at( idLord2 );
}
void Analyst::exchangeUnits()
{
	uchar idLord1 = _socket->readChar();
	uchar idUnit1 = _socket->readChar();
	uchar idLord2 = _socket->readChar();
	uchar idUnit2 = _socket->readChar();
	GenericLord * lord1 = 0;
	GenericLord * lord2 = 0;
	if( idLord1 ) {
		lord1 = _lords.at( idLord1 );
	}
	if( idLord2 ) {
		lord2 = _lords.at( idLord2 );
	}

	/// XXX: check player of lord ?
	if( lord1 && lord2 ) {
		GenericFightUnit * unit1 = lord1->getUnit( idUnit1 );
		GenericFightUnit * unit2 = lord2->getUnit( idUnit2 );

		if( unit1 ) {
			if( unit2 ) {
				if( ( unit1->getRace() == unit2->getRace() ) &&
					unit1->getLevel() == unit2->getLevel() ) {
					unit2->addNumber( unit1->getNumber() );
					lord1->setUnit( idUnit1, 0 );
					delete unit1;
				} else {
					lord1->setUnit( idUnit1, unit2 );
					lord2->setUnit( idUnit2, unit1 );
				}
			} else {
				lord2->setUnit( idUnit2, unit1 );
				lord1->setUnit( idUnit1, 0 );
			}
		}
	}
}

void Analyst::exchangeBaseUnits()
{
	int row = _socket->readInt();
	int col = _socket->readInt();
	uchar idUnit1 = _socket->readChar();
	uchar idLord = _socket->readChar();
	uchar idUnit2 = _socket->readChar();
	GenericBase * base = 0;
	GenericLord * lord = 0;
	GenericFightUnit * uni1 = 0;
	GenericFightUnit * uni2 = 0;

	base = _map->at( row, col )->getBase();
	if( idLord && ( idLord < 255 ) ) {
		lord = _lords.at( idLord );
	}

	if( base ) {
		if( idUnit1 <= MAX_UNIT ){
			uni1 = base->getUnit( idUnit1 );
		}
		if( lord ) {
			if( idUnit2 <= MAX_UNIT ){
				uni2 = lord->getUnit( idUnit2 );
			}
			if( uni1 && uni2 ) {
				if( uni1->getCreature() != uni2->getCreature() ) {
					lord->setUnit( idUnit2, uni1 );
					base->setUnit( idUnit1, uni2 );
				} else {
					uni1->addNumber( uni2->getNumber() );
					lord->setUnit( idUnit2, 0 );
					delete uni2;
				}
			} else if (!uni1) {
				lord->setUnit( idUnit2, 0 );
				base->setUnit( idUnit1, uni2 );
			} else if (!uni2) {
				lord->setUnit( idUnit2, uni1 );
				base->setUnit( idUnit1, 0 );
			}
		} else {
			if( idUnit2 <= MAX_UNIT ) {
				uni2 = base->getUnit( idUnit2 );
			}
			if( uni1 && uni2 ) {
				if( uni1->getCreature() != uni2->getCreature() ) {
					base->setUnit( idUnit2, uni1 );
					base->setUnit( idUnit1, uni2 );
				} else {
					uni1->addNumber( uni2->getNumber() );
					lord->setUnit( idUnit2, 0 );
					delete uni2;
				}
			} else {
				base->setUnit( idUnit2, uni1 );
				base->setUnit( idUnit1, 0 );
			}
		}
	}
}




/*!

*/

void Analyst::socketModif()
{
	ialogV( "SO_MODIF" );
	switch( _socket->getCla2() ) {
	case C_MOD_MAP:
		socketModifMap();
		break;
	case C_MOD_CELL:
		socketModifCell();
		break;
	case C_MOD_LORD:
		socketModifLord();
		break;
	case C_MOD_PLAYER:
		socketModifPlayer();
		break;
	case C_MOD_BASE:
		socketModifBase();
		break;
	case C_MOD_BUILD:
		socketModifBuilding();
		break;
	case C_MOD_ARTEFACT:
		socketModifArtefact();
		break;
	case C_MOD_CREATURE:
		socketModifCreature();
		break;
	case C_MOD_EVENT:
		socketModifEvent();
		break;
	}
}

void Analyst::socketModifMap()
{
	int h = _socket->readInt();
	int w = _socket->readInt();
	_map->newUnknownMap( h, w );
}

void Analyst::socketModifCell()
{
	int a1 = _socket->readInt();
	int a2 = _socket->readInt();
	int a3 = _socket->readInt();
	int a4 = _socket->readInt();
	int a5 = _socket->readInt();
	int a6 = _socket->readInt();
	_map->changeCell( a1, a2, a3, a4, a5, a6 );
}

void Analyst::socketModifLord()
{
	switch( _socket->getCla3() ) {
	case C_LORD_VISIT:
		socketModifLordVisit();
		break;
	case C_LORD_NEW:
		socketModifLordNew();
		break;
	case C_LORD_MOVE:
		{
			char lord = _socket->readChar();
			int nb = _socket->readInt();
			_lords.at( lord )->setBaseCharac( MOVE, nb );
			break;
		}
	case C_LORD_MAXMOVE:
		{
			char lord = _socket->readChar();
			int nb = _socket->readInt();
			_lords.at( lord )->setBaseCharac( MAXMOVE, nb );
			break;
		}
	case C_LORD_SP:
		{
			char lord = _socket->readChar();
			int nb = _socket->readInt();
			_lords.at( lord )->setBaseCharac( TECHNICPOINT, nb );
			break;
		}
	case C_LORD_MAXSP:
		{
			char lord = _socket->readChar();
			int nb = _socket->readInt();
			_lords.at( lord )->setBaseCharac( MAXTECHNICPOINT, nb );
			break;
		}
	case C_LORD_MORALE:
		{
			char lord = _socket->readChar();
			char nb = _socket->readChar();
			_lords.at( lord )->setBaseCharac( MORALE, nb );
			break;
		}
	case C_LORD_LUCK:
		{
			char lord = _socket->readChar();
			char nb = _socket->readChar();
			_lords.at( lord )->setBaseCharac( LUCK, nb );
			break;
		}
	case C_LORD_EXP:
		{
			char lord = _socket->readChar();
			int nb = _socket->readInt();
			_lords.at( lord )->setBaseCharac( EXPERIENCE, nb );
			break;
		}
	case C_LORD_ATT:
		{
			char lord = _socket->readChar();
			char nb = _socket->readChar();
			_lords.at( lord )->setBaseCharac( ATTACK, nb );
			break;
		}
	case C_LORD_DEF:
		{
			char lord = _socket->readChar();
			char nb = _socket->readChar();
			_lords.at( lord )->setBaseCharac( DEFENSE, nb );
			break;
		}
	case C_LORD_POW:
		{
			char lord = _socket->readChar();
			char nb = _socket->readChar();
			_lords.at( lord )->setBaseCharac( POWER, nb );
			break;
		}
	case C_LORD_KNOW:
		{
			char lord = _socket->readChar();
			char nb = _socket->readChar();
			_lords.at( lord )->setBaseCharac( KNOWLEDGE, nb );
		}
		break;
	case C_LORD_UNIT:
		socketModifLordUnit();
		break;
	case C_LORD_REMOVE:
		socketModifLordRemove();
		break;
	}
}

void Analyst::socketModifLordVisit()
{
	/*uchar num = */_socket->readChar();
	int row = _socket->readInt();
	int col = _socket->readInt();
	uchar id = _socket->readChar();

	/// XXX: memory leak no new -> use _lords (cf game.cpp too !!)
	GenericLord * lord = _lords.at( id );

	//new GenericLord();
	//lord->setActive( true );
	//lord->setId( id );
	/// XXX: change
	lord->setOwner( 0 );
	lord->moveTo( _map->at( row, col ) );
	//_lords.at( id ) = lord;

}

void Analyst::socketModifLordNew()
{
	int row = _socket->readInt();
	int col = _socket->readInt();
	uchar id = _socket->readChar();

	GenericLord * lord = _lords.at( id );
	lord->moveTo( _map->at( row, col ) );
	lord->setOwner( _player );

	_player->addLord( lord );
}

void Analyst::socketModifLordUnit()
{
	uchar id = _socket->readChar();
	uchar num = _socket->readChar();
	uchar race = _socket->readChar();
	uchar level = _socket->readChar();
	int nb = _socket->readInt();

	GenericFightUnit * unit = new GenericFightUnit();
	unit->setCreature( race, level );
	unit->setNumber( nb );
	unit->setMove( _socket->readChar() );
	unit->setHealth( _socket->readInt() );

	_lords.at( id )->setUnit( num, unit );
	/// XXX: remove/delete old unit ??
}

void Analyst::socketModifLordRemove()
{
	int idLord = _socket->readChar();
	GenericLord * lord = _lords.at( idLord );
	GenericPlayer * player = lord->getOwner();
	if( player ) {
		player->removeLord( lord );
		if( player == _player ) {
			_socket->sendLordTurn( PL_PASS_TURN );
		} else {
			_socket->sendLordTurn( PL_SAME_LORD );
		}
	}

	GenericCell * cell = lord->getCell();
	if( cell ) {
		cell->setLord( 0 );
	}
	lord->reinit();

	//XXX: Remove lord from map
	delete lord;
	//if( lord ) lord->getOwner()->removeLord( lord );
}

void Analyst::socketModifPlayer()
{
	switch( _socket->getCla3() ) {
	case C_PLAY_RESS: {
		uchar ress = _socket->readChar();
		_player->setResource( ress, _socket->readInt() );
		}
		break;
	}
}

void Analyst::socketModifBase()
{
	switch( _socket->getCla3() ) {
	case C_BASE_NEW:
		socketModifBaseNew();
		break;
	case C_BASE_OWNER:
		socketModifBaseOwner();
		break;
	case C_BASE_BUILDING:
		socketModifBaseBuilding();
		break;
	case C_BASE_UNIT:
		socketModifBaseUnit();
		break;
	}
}

void Analyst::socketModifBaseNew()
{
	uchar race = _socket->readChar();
	int row = _socket->readInt();
	int col = _socket->readInt();
	int population = _socket->readInt();
	uchar id = _socket->readChar();
	int nb = _socket->readChar();

	GenericBase * base = new GenericBase();
	base->setRace( race );
	base->setPosition( _map->at( row, col ) );
	base->setPopulation( population );
	_map->computeStoppable( base );
	base->setId( id );/// XXX: to inv ??
	base->isUnitBought( false );

	for( int i = 0; i < nb; i++ ) {
		base->addForbiddenBuilding( _socket->readChar() );
	}
}

void Analyst::socketModifBaseOwner()
{
	int row = _socket->readInt();
	int col = _socket->readInt();
	GenericBase * base = (GenericBase*)_map->at( row, col )->getBase();
	if( _socket->readChar() == _player->getNum() ) {
		_player->addBase( base );
		base->setOwner( _player );
	} else {
		/// XXX: improve management of base of other player
		if( base->getOwner() == _player ) {
			base->setOwner( 0 );
			_player->removeBase( (GenericBase*)base );
		}
	}
}

void Analyst::socketModifBaseBuilding()
{
	int row = _socket->readInt();
	int col = _socket->readInt();
	uchar level = _socket->readChar();
	bool create = (bool)_socket->readChar();

	if( _map->at( row, col )->getBase() ) {
		if( create ) {
			GenericInsideBuilding * building = new GenericInsideBuilding();
			building->setRace( _map->at( row, col )->getBase()->getRace() );
			building->setLevel( level );
			_map->at( row, col )->getBase()->addBuilding( building );
		} else {
			GenericInsideBuilding * building =  _map->at( row, col )->getBase()->getBuildingByType( level );
			_map->at( row, col )->getBase()->removeBuilding( building );
		}
	} else {
		logEE( "Base not found" );
	}
}

void Analyst::socketModifBaseUnit()
{
	int row = _socket->readInt();
	int col = _socket->readInt();
	if( _map->at( row, col )->getBase() ) {
		GenericBase * base = (GenericBase *)_map->at( row, col )->getBase();
		uchar race = _socket->readChar();
		uchar level = _socket->readChar();
		int number = _socket->readInt();
		Creature * creature = DataTheme.creatures.at( race, level );
		base->addGarrison( creature, number );
	}
}

void Analyst::socketModifBuilding()
{
	switch( _socket->getCla3() ) {
		case C_BUILD_NEW: {
			GenericBuilding * building = new GenericBuilding();
			int row = _socket->readInt();
			int col = _socket->readInt();
			building->setPosition( _map->at( row, col ) );
			uchar type = _socket->readChar();
			building->setType( type );
		}
		break;
		case C_BUILD_OWNER: {
			int row = _socket->readInt();
			int col = _socket->readInt();
			if( _socket->readChar() == _player->getNum() ) {
				_player->addBuilding( _map->at( row, col )->getBuilding() );
			}
		}
	}
}

void Analyst::socketModifArtefact()
{
	switch( _socket->getCla3() ) {
	case C_ART_DELLORD: {
		uint type = _socket->readInt();
		char lord = _socket->readChar();
		_lords.at( lord )->getArtefactManager()->removeArtefactByType( type );
	} break;
	case C_ART_ADDLORD: {
		uint type = _socket->readInt();
		char lord = _socket->readChar();
		if( ! _lords.at( lord )->getArtefactManager()->hasArtefactType( type ) ) {
			_lords.at( lord )->getArtefactManager()->addArtefact( type );
		}
	} break;
	}
}

GenericArtefact * Analyst::getArtefactById( int id )
{
	GenericArtefact * ret = 0;
	for( uint i = 0; i < _events.count(); i++ ) {
		if( ( _events.at( i )->getType() == GenericEvent::EventArtefact ) &&
		  _events.at( i )->getArtefact()->getId() == id ) {
			ret = _events.at( i )->getArtefact();
		}
	}
	return ret;
}

void Analyst::socketModifEvent()
{
	switch( _socket->getCla3() ) {
	case C_EVENT_NEW: {
		int row = _socket->readInt();
		int col = _socket->readInt();
		GenericEvent::EventType type = (GenericEvent::EventType) _socket->readChar();

		GenericEvent * event = new GenericEvent();
		event->setCell( _map->at( row, col ) );
		_map->at( row, col )->setEvent( (GenericEvent*)event );

		if( type == GenericEvent::EventArtefact ) {
			int id = _socket->readInt();
			uchar typeArtefact = _socket->readChar();

			GenericArtefact * artefact = new GenericArtefact();
			event->setArtefact( artefact );
			artefact->setId( id );
			artefact->setType( typeArtefact );
		} else if( type == GenericEvent::EventBonus ) {
			/// XXX: todo (bonus)
		} else if( type == GenericEvent::EventChest ) {
			/// XXX: todo (chest)
		}
		}
		break;
	case C_EVENT_DEL: {
		int row = _socket->readInt();
		int col = _socket->readInt();
		GenericEvent * event = _map->at( row, col )->getEvent();
		if( event ) {
			delete event;
			_map->at( row, col )->setEvent( 0 );
		}
		}
		break;
	}
}

void Analyst::socketModifCreature()
{
	switch( _socket->getCla3() ) {
	case C_CRE_NEW: {
		int row = _socket->readInt();
		int col = _socket->readInt();
		uchar race = _socket->readChar();
		uchar level = _socket->readChar();
		int nb = _socket->readInt();
		GenericMapCreature * creature = new GenericMapCreature();
		creature->setCreature( race, level );
		creature->setCategoryNumber( nb );
		creature->setCell( _map->at( row, col ) );
		_map->at( row, col )->setCreature( creature );
		}
		break;
	case C_CRE_DEL: {
		int row = _socket->readInt();
		int col = _socket->readInt();
		GenericMapCreature * crea = _map->at( row, col )->getCreature();
		if( crea ) {
			delete crea;
			_map->at( row, col )->setCreature( 0 );
		}
		}
		break;
	}
}

void Analyst::socketTurn()
{
	ialogV( "SO_TURN" );

	switch( _socket->getCla2() ) {
	case C_TURN_BEG:
		socketTurnBegin();
		break;
	case C_TURN_PLAY:
		ialogV( "Player: %d", _socket->readChar() );
		break;
	case C_TURN_END:
		ialogC( "Should not happen (SO_TURN/C_TURN_END)" );
		break;
	case C_TURN_LORD:
		ialogC( "Should not happen (SO_TURN/C_TURN_LORD)" );
		break;
	case C_TURN_PLORD:{
		int nlord = _socket->readInt();
		_numlords = _player->numLord();
		if( nlord >= _numlords || _numTurn==0){
			_socket->sendTurnEnd();
		} else {
			playLordTurn(nlord);
		}
		} break;
	}
}

void Analyst::socketTurnBegin()
{
	ialogN( "Start turn" );
	_calendar->newDay();
	if( _calendar->getDay() == 1 ) {
		_player->newWeek();
	}
	_player->newTurn();
//	_fightCpt = PL_PASS_TURN;
	_numTurn=2 * _player->numLord() + 4; /* workaround for weirds game bugs */

	if( _player->numBase() > 0 ){
		for( int i = 0; i < (int)_player->numBase(); i++ ) {
			GenericBase * base = _player->getBase( i );
			manageBase( base );
		}
	}
	_socket->sendLordTurn( PL_SAME_LORD );
}

void Analyst::playLordTurn( int nlord )
{
//	_fightCpt = PL_SAME_LORD;
	ialogN("init lord");
	analyzeLord( _player->getLord( nlord ) );
}

void Analyst::analyzeLord( GenericLord * lord )
{
	_movePoints = lord->getCharac( MOVE );
	GenericCell * cell = lord->getCell();
	_rowFlee = 1;
	_colFlee = 1;

	_startApprRow = 0;
	_startApprCol = 0;

	_prior = PR_LAST;
	_mincost = _movePoints+10;
	_map->getPath()->reinit( _map );
	_map->getPath()->computePath( cell );
	
	if(noPath(cell)){
		ialogV("no path");
		_movePoints=0;
	}
		

	if( _movePoints > 0 ) {
		analyzeLordMap( lord );
		
		if( _fightCpt == PL_SAME_LORD_NOFIGHT) {
			randomPath(cell);
		}

		if(_destinationCell  == cell){
			ialogN("no good");
			_fightCpt=PL_PASS_TURN;
		}

		ialogV("flee row %d, col %d, fightCpt %d",_rowFlee,_colFlee,_fightCpt);
		ialogV("startRow %d, startCol %d",cell->getRow(),cell->getCol());
		ialogV("destRow %d, destCol %d",_destinationCell->getRow(),_destinationCell->getCol());

		if(_fightCpt==PL_SAME_LORD_NOFIGHT){
		/* if no possibility to move, destination cell = starting cell and sanity check*/
			if(_map->getPath()->getDist(_destinationCell)>_movePoints || (_map->getPath()->isPath(_destinationCell)==false))  {
				_destinationCell  = cell;
				_fightCpt=PL_PASS_TURN;
			}
			if(_map->getPath()->isPath(_destinationCell)==true && _destinationCell  != cell){
				QStack<GenericCell> * path = _map->getPath()->giveCells( _destinationCell );
				while( ! path->isEmpty() ) {
					GenericCell * movCell = path->pop();
					_socket->sendMvt(lord->getId(), movCell->getRow(), movCell->getCol() );
				}
				delete path;
			}
		}else{
			if(_map->getPath()->isNearPath(_destinationCell)==true && _destinationCell  != cell){
				QStack<GenericCell> * path = _map->getPath()->giveNearCells( _destinationCell );
				while( ! path->isEmpty() ) {
					GenericCell * movCell = path->pop();
					_socket->sendMvt(lord->getId(), movCell->getRow(), movCell->getCol() );
				}
				_socket->sendMvt(lord->getId(), _destinationCell->getRow(), _destinationCell->getCol() );
				delete path;
			}
		}
	} else {
		ialogV("Turn pass");
	 	_fightCpt = PL_PASS_TURN;
	}
	if(_fightCpt==PL_SAME_LORD_NOFIGHT){
		ialogV("Turn cont no meet");
		_fightCpt=PL_SAME_LORD;
	}
		_numTurn--;
		ialogV("Turn finish");
	_socket->sendLordTurn(_fightCpt);
}

void Analyst::analyzeLordMap( GenericLord * lord )
{
	unsigned int i, j;
	GenericCell * cell;

	int opPower;
	int cost;

	_fightCpt = PL_SAME_LORD_NOFIGHT;
		
	for( i = 0; i < _map->getHeight(); i++ ) {
		for( j = 0; j < _map->getWidth(); j++ ) {
			cell = _map->at( i, j );
			if( cell->getLord() && ( PR_ENEMY <= _prior ) && cell->getCoeff() != -1 ) {
				if( cell->getLord()->getOwner() != _player ) {
					opPower = getRandPower( cell->getLord() );
					manageMeetings(lord,cell ,PR_ENEMY,opPower,1);
				}
			} else if( cell->getBase() && (PR_BASE	<= _prior ) && cell->getCoeff() != -1 )	{
				if( cell->getBase()->getOwner() != _player || cell->getBase()->isUnitBought() ) {
					ialogN( "Try Base");
					manageMeetings(lord,cell ,PR_BASE,0,0);
				}
			} else if( cell->getBuilding() && (PR_BUILD <= _prior) && cell->getCoeff() != -1 ) {
				if( cell->getBuilding()->getOwner() != _player ) {
					manageMeetings(lord,cell ,PR_BUILD,0,0);
					cost = _map->getPath()->getDist( cell );
					ialogN( "Try Build");
				}
			} else if( cell->getEvent()){
				if(cell->getEvent()->getType()==GenericEvent::EventArtefact && ( PR_ART < _prior ) && ( cell->getCoeff() != -1 ) )	{
					ialogN( "Try Event-Artefact");
					manageMeetings(lord,cell ,PR_ART,0,0);
				} else if( cell->getEvent()->getType()==GenericEvent::EventBonus && ( PR_BONUS < _prior ) && ( cell->getCoeff() != -1 ) )	{
					ialogN( "Try Event-Bonus");
					manageMeetings(lord,cell ,PR_BONUS,0,0);
				} else if( cell->getEvent()->getType()==GenericEvent::EventChest && ( PR_CHEST < _prior ) && ( cell->getCoeff() != -1 ) )	{
					ialogN( "Try Event-chest");
					manageMeetings(lord,cell ,PR_CHEST,0,0);
				}
			} else if( cell->getCreature() && (PR_CREAT < _prior) && ( cell->getCoeff() != -1 ) ){
				ialogN( "Try Creat");
				opPower = getCreaturePower( cell->getCreature() );
				manageMeetings(lord,cell ,PR_CREAT,opPower,0);
			}
		}//for i
	}//for j
}


void Analyst::socketGame()
{
	ialogN( "SO_GAME" );
	if( _socket->getCla2() == C_GAME_END ) {
		reinit();
		//_player->cleanData();
		//_map->cleanData();
		//_calendar->reinit();
	} else if( _socket->getCla2() == C_GAME_LOST ) {
		int nb = _socket->readChar();
		ialogN("player %d has lost",nb);
		//reinit();
		//_player->cleanData();
		//_map->cleanData();
	}
}

int Analyst::getRandPower( GenericLord * lord )
{
	int power = 0;

	for( int i = 0; i < MAX_UNIT; i++ ) {
		GenericFightUnit * lordUnit = lord->getUnit( i );
		if( lordUnit ) {
			uint number = DataTheme.getRandomInCategory( (uchar)DataTheme.computeCategory( lordUnit->getNumber() ) );
			power += lordUnit->getCreature()->getAttack() * number;
		}
	}
	return power;
}

int Analyst::getCreaturePower( GenericMapCreature * creature )
{
	int power = 0;

	ialogV("att %d, num %d",creature->getCreature()->getAttack() , creature->getCreatureNumber());
	if( creature->isEstimated() ) {
		uint estimatedNb = DataTheme.getRandomInCategory( creature->getCategoryNumber() );
		power = creature->getCreature()->getAttack() * estimatedNb;
	} else {
		power = creature->getCreature()->getAttack() * creature->getCreatureNumber();
	}

	return power;
}


int Analyst::getPower( GenericLord * lord )
{
	int power = 0;

	for( int i = 0; i < MAX_UNIT; i++ ) {
		GenericFightUnit * lordUnit = lord->getUnit( i );
		if( lordUnit ) {
			power += lordUnit->getCreature()->getAttack() * lordUnit->getNumber();
		}
	}
	return power;
}


void Analyst::manageBase(GenericBase * base)
{
	// scan all buildings looking for creatures
	uint count = base->getBuildingCount();
	uint i;
	ialogN("Try buy");
	for( i = 0; i < count; i++ ) {
		GenericInsideBuilding * building=base->getBuilding( i );
		InsideAction * action = DataTheme.bases.at( base->getRace() )->getBuildingModel( building->getLevel() )->getAction();
		if(action){		
			int race = action->getParam( 0 );
			int level = action->getParam( 1 );
			Creature * creature = DataTheme.creatures.at( race, level);
//  		int max =_player->computeBuyCreatureMax( creature );
			for(int  j = base->getCreatureProduction(creature);j>0; j-- ) {
				if(_player->canBuy( creature, j ) ){
					ialogN("BUY  num %d",j);
					_player->buy(creature,j);
					_socket->sendBaseUnit( base, creature, j );
					base->buyCreature( creature, j );
					base->isUnitBought(true); 
					break;
				}
			}
		}
	}

	GenericBaseModel * baseModel = DataTheme.bases.at( base->getRace() );
	int modelCount = baseModel->getBuildingCount();

	for( i = 0; i < (uint) modelCount; i++ ) {
		GenericInsideBuilding * building= base->getBuilding( i );
		if( _player && _socket &&  !building) {
			if( _player->canBuy( DataTheme.bases.at( base->getRace() )->getBuildingModel( i ) ) ) {
				_socket->requestBuilding( base, i, true );
				ialogN("Buy Building");
				break;
			} else {
				//logDD("Can't buy, Not enough ressources to buy this building" );
			}
		}
	}
}



void Analyst::enterBase(GenericLord * lord,GenericBase * base )
{

	base->enter( lord );
	if(lord->countUnits()<MAX_UNIT){
		for(int i=0;i<MAX_UNIT;i++){
			for(int j=0;j<MAX_UNIT;j++){
				if(!lord->getUnit(j) && base->getGarrisonUnit(i)){
					lord->setUnit(j,base->getGarrisonUnit(i));
					base->setGarrisonUnit(i,0);
					_socket->sendExchangeBaseUnit( base, i, lord, j );
					//ialogN("Exch ,pos i %d ,pos j %d",i,j);
				}
				if(lord->getUnit(j) && base->getGarrisonUnit(i)){
					if(lord->getUnit(j)->getCreature()==base->getGarrisonUnit(i)->getCreature()){
						lord->getUnit(j)->addNumber(base->getGarrisonUnit(i)->getNumber());
						base->setGarrisonUnit(i,0);
						_socket->sendExchangeBaseUnit( base, i, lord, j );
					}
				}
			}
		base->isUnitBought(false);
		}
	}
	base->out( lord );
}


int Analyst::manageMeetings(GenericLord * lord,GenericCell * cell ,int prior,int opPower, int isFlee )
{
	int cost;
	int startRow = lord->getCell()->getRow();
	int startCol = lord->getCell()->getCol();
	int myPower = getPower( lord );
	GenericCell * tcell;
	int i=cell->getRow();
	int j=cell->getCol();

	if(opPower>0)
		ialogN("opPower %d, myPower %d",opPower,myPower);	

	_fightCpt = PL_SAME_LORD_NOFIGHT;
	tcell=_map->getPath()->getNearCell(	cell );
	cost = _map->getPath()->getDist( tcell );
	if( _prior > prior ) {
		_mincost = _movePoints+10;
	}
	if( ( cost < _mincost ) && ( cost <= _movePoints )
			&& ( cost > 0 ) && ( myPower > opPower ) ) {
//		if(opPower>0){
			_fightCpt = PL_SAME_LORD;
//		}
		_destinationCell = cell;
		_mincost = cost;
		_prior = prior;
		ialogN("Meeting");
		return true;
	} else if( cost < (_movePoints + 5 ) && cost != -1 ) {
		if( ( startRow - i ) > 0 ) {
			_startApprRow = i;
			if( myPower < opPower && isFlee==1) {
				_startApprRow = startRow;
			}
		} else {
			_startApprRow = startRow;
			if( myPower < opPower && isFlee==1) {
				_rowFlee = -1;
			}
		}
		if( ( startCol - j ) > 0 ){
			_startApprCol = j;
			if( myPower < opPower && isFlee==1) {
				_startApprCol = startCol;
			}
		} else {
			_startApprCol = startCol;
			if( myPower < opPower && isFlee==1) {
				_colFlee = -1;
			}
		}
		if( myPower < opPower && isFlee==1) {
			_prior = prior;
		}
	}
	return false;
}

void Analyst::randomPath(GenericCell * cell )
{

		int startRow= cell->getRow();
		int startCol= cell->getCol();
		int sameTry=0;
		int moreTry=0;
		int i,j;
		long he = (long)_map->getHeight();
		long wi = (long)_map->getWidth();

		do {
			do {
				if( _startApprRow ) {
					i = _startApprRow + (_rowFlee)*(int)(_movePoints*(rand()/(RAND_MAX+1.0)));
					moreTry++;
					if(moreTry>19){
						i=_startApprRow;
					}	
				} else {
					i=(int) (he*(rand()/(RAND_MAX+1.0)));
				}
			}while(i>=(int) he || i<0);
			moreTry=0;
			do{
				if(_startApprCol){
					j=_startApprCol+(_colFlee)*(int)(_movePoints*(rand()/(RAND_MAX+1.0)));
					moreTry++;
					if(moreTry>19){
						j=_startApprCol;
					}	
				} else {
					j=(int) (wi*(rand()/(RAND_MAX+1.0)));
				}
			}while(j>=(int) wi || j<0 );
			
			if( i == startRow && j == startCol ){
				sameTry++;
			} else {
				if(_map->getPath()->getDist(_map->at(i, j))<=_movePoints && (_map->getPath()->isPath(_map->at(i, j))==true))  {
					sameTry=20;
				}
			}
		} while( (_map->getPath()->getDist(_map->at(i, j))>_movePoints || _map->getPath()->isPath(_map->at(i, j))==false) && sameTry<20 );
		_destinationCell = _map->at( i, j );
}

int Analyst::noPath(GenericCell * cell)
{

		uint row= cell->getRow();
		uint col= cell->getCol();
		uint i,j;
		uint initRow;
		uint initCol;
		uint finRow;
		uint finCol;

		initRow= row > 0 ? row-1 : 0;
		initCol= col > 0 ? col-1 : 0;
		finRow= row < _map->getWidth() ? row+1 : _map->getWidth();
		finCol= row < _map->getHeight() ? col+1 : _map->getHeight();

		for(i=initRow;i<=finRow;i++){
			for(j=initCol;j<=finCol;j++){
				if(_map->getPath()->isPath(_map->at(i,j)))
						return false;
			}
		}
		return true;
}

