/****************************************************************
**
** Attal : Lords of Doom
**
** gameData.cpp
** Manage data of a whole game
**
** Version : $Id: gameData.cpp,v 1.10 2004/02/08 00:08:35 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/01/2002
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "gameData.h"

// generic include files
// include files for QT
#include <qtextstream.h>
// application specific include files
#include "libCommon/artefact.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericBonus.h"
#include "libCommon/genericBuilding.h"
#include "libCommon/genericCell.h"
#include "libCommon/genericChest.h"
#include "libCommon/genericEvent.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericMap.h"
#include "libCommon/genericMapCreature.h"
#include "libCommon/genericPlayer.h"
#include "libServer/parser.h"
#include "libCommon/quest.h"
#include "libServer/questManager.h"

extern DataTheme DataTheme;

/** add comments here */
GameData::GameData()
	:_nbPlayer( 0 ), _map( 0 )
{
	_players.setAutoDelete( true );
	_bases.setAutoDelete( true );
	_buildings.setAutoDelete( true );
	_lords.setAutoDelete( true );
	_events.setAutoDelete( true );
	_creatures.setAutoDelete( true );
	_quests = new QuestManager();
	_nbArtefact = 0;
	_nbBonus = 0;
	_nbChest = 0;

	reinit();
}

GameData::~GameData()
{
/*	if( _quests ) {
		delete _quests;
	}*/
}

void GameData::save( QTextStream * ts )
{
	uint i;

	*ts << "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE scenario>" << endl;
	*ts << "<scenario nbPlayer=\"" << getNbPlayer() << "\">" << endl;
	*ts << "\t<name>" << getScenarioName() << "</name>" << endl;
	*ts << "\t<theme>" << getScenarioTheme() << "</theme>" << endl;
	*ts << "\t<description>" << endl;
	*ts << "\t\t" << getScenarioDescription() << endl;
	*ts << "\t</description>" << endl;

	_map->save( ts );

	for( i = 0; i < _events.count(); i++ ) {
		_events.at( i )->save( ts, 1 );
	}

	for( i = 0; i < _bases.count(); i++ ) {
		_bases.at( i )->save( ts, 1 );
	}

	for( i = 0; i < _buildings.count(); i++ ) {
		_buildings.at( i )->save( ts, 1 );
	}

	for( i = 0; i < _lords.count(); i++ ) {
		_lords.at( i )->save( ts, 1 );
	}

	for( i = 0; i < _creatures.count(); i++ ) {
		_creatures.at( i )->save( ts, 1 );
	}

	for( i = 0; i < getNbPlayer(); i++ ) {
		_players.at( i )->save( ts, 1 );
	}

	*ts << "</scenario>" << endl;
}

void GameData::reinit()
{
	if( _map ) {
		_map->clear();
	}
	_bases.clear();
	_buildings.clear();
	_lords.clear();
	_events.clear();
	_creatures.clear();
	_quests->clear();
	_nbPlayer = 0;
	_nbArtefact = 0;
	_nbBonus = 0;
	_nbChest = 0;
	for( uint i = 0; i < DataTheme.lords.count(); i++ ) {
		GenericLord * lord = new GenericLord();
		lord->setId( i );
		_lords.append( lord );
	}
}

GenericCell * GameData::getCell( uint row, uint col )
{
	if( ( row < _map->getHeight() ) && ( col < _map->getWidth() ) ) {
		return _map->at( row, col );
	} else {
		return 0;
	}
}

uint GameData::getBaseNumber()
{
	return _bases.count();
}

void GameData::loadMap( QTextStream * stream, int width, int height )
{
	if( _map ) {
		delete _map;
	}
	_map = new GenericMap();
	_map->load( stream, width, height );
}

GenericBase * GameData::getNewBase() 
{
	GenericBase * base = new GenericBase();
	_bases.append( base );
	return base;
}
	
void GameData::setBase2Player( int idBase, int player ) 
{
	if( ( _players.at( player ) ) && ( _bases.at( idBase ) ) ) {
		_bases.at( idBase )->setOwner( _players.at( player ) );
		_players.at( player )->addBase( _bases.at( idBase ) );
	}
}
	
void GameData::setBuilding2Player( int idBuild, int player )
{
	if( ( _players.at( player ) ) && ( _buildings.at( idBuild ) ) ) {
		_buildings.at( idBuild )->setOwner( _players.at( player ) );
		_players.at( player )->addBuilding( _buildings.at( idBuild ) );		
	}
}

GenericLord * GameData::getLord( int idLord )
{
	return _lords.at( idLord );
}

GenericPlayer * GameData::getPlayer( int num )
{
	return _players.at( num );
}

void GameData::setLord2Player( int idLord, int player )
{
	if( ( _players.at( player ) ) && ( _lords.at( idLord ) ) ) {
		_lords.at( idLord )->setOwner( _players.at( player ) );
		_players.at( player )->addLord( _lords.at( idLord ) );		
	}
}

GenericEvent * GameData::getNewArtefact()
{
	GenericEvent * ret = new GenericEvent();
	GenericArtefact * artefact = new GenericArtefact();
	ret->setArtefact( artefact );
	_events.append( ret );
	return ret;
}

GenericEvent * GameData::getNewBonus()
{
	GenericEvent * ret = new GenericEvent();
	GenericBonus * bonus = new GenericBonus();
	ret->setBonus( bonus );
	_events.append( ret );
	return ret;

}

GenericEvent * GameData::getNewChest()
{
	GenericEvent * ret = new GenericEvent();
	GenericChest * chest = new GenericChest();
	ret->setChest( chest );
	_events.append( ret );
	return ret;

}

GenericBuilding * GameData::getNewBuilding()
{
	GenericBuilding * ret = new GenericBuilding();
	ret->setId( _buildings.count() );
	_buildings.append( ret );
	return ret;
}

Quest * GameData::getNewQuest()
{
	Quest * ret = new Quest();
	_quests->append( ret );
	return ret;
}

GenericMapCreature * GameData::getNewMapCreature()
{
	GenericMapCreature * ret = new GenericMapCreature();
	_creatures.append( ret );
	return ret;
}

