/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesItem.cpp
** Defines properties box for bases on map
**
** Version : $Id: propertiesBase.cpp,v 1.5 2003/09/27 20:30:46 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 29/12/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "propertiesBase.h"

// generic include files
// include files for QT
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qlistview.h>
// application specific include files
#include "libCommon/genericInsideBuilding.h"
#include "libCommon/genericLord.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/dataTheme.h"
#include "libClient/gui.h"

extern DataTheme DataTheme;


//
// ----- PropertiesBase -----
//

PropertiesBase::PropertiesBase( QList<GenericPlayer> * players, QWidget * parent, const char * name )
	: QDialog( parent, name, true )
{
        setCaption( tr( "Base properties" ) );
	_base = 0;

	QLabel * ownerLabel = new QLabel( this );
	ownerLabel->setText( tr( "Owner:" ) );

	_ownerList = new QComboBox( this );
	refresh( players );

	_listBuilding = new QListView( this );
	_listBuilding->addColumn( tr( "Buildings" ) );
	_listBuilding->setSorting( -1 );

	QPushButton * pb = new QPushButton( this );
	pb->setText( tr( "Ok" ) );
	FIXEDSIZE( pb );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->setSpacing( 5 );
	layH1->addWidget( ownerLabel );
	layH1->addWidget( _ownerList, 1 );

	QHBoxLayout * layH2 = new QHBoxLayout();
	layH2->setSpacing( 5 );
	layH2->addWidget( _listBuilding, 1 );

	QHBoxLayout * layH = new QHBoxLayout();
	layH->setMargin( 5 );
	layH->addStretch( 1 );
	layH->addWidget( pb );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addLayout( layH1 );
	layout->addLayout( layH2, 1 );
	layout->addLayout( layH );
	layout->activate();

	connect( pb, SIGNAL( clicked() ), SLOT( slot_accept() ) );
	connect( _ownerList, SIGNAL( activated( int ) ), SLOT( slot_owner( int ) ) );
}

void PropertiesBase::refresh( QList<GenericPlayer> * players )
{
	_players = players;
	_ownerList->clear();
	_ownerList->insertItem( tr( "None" ) );
	
	for( uint i = 0; i < players->count(); i++ ) {
		GenericPlayer * player = players->at( i );
		if( player ) {
			_ownerList->insertItem( player->getName() );
		}
	}
}


void PropertiesBase::slot_accept()
{
	QListViewItemIterator ite( _listBuilding );
	int i =0;
	for( ite.current(); ite.current(); ++ite ) {
		if( ( (QCheckListItem*) ite.current() )->isOn() ) {
			if( ! _base->hasBuildingType( i ) ) {
				GenericInsideBuilding * building = new GenericInsideBuilding();
				building->setRace( _base->getRace() );
				building->setLevel( i );
				_base->addBuilding( building );
			}
		} else {
			if( _base->hasBuildingType( i ) ) {
				_base->removeBuildingType( i );
			}
		}
		i++;
	}
	accept();
}

void PropertiesBase::slot_owner( int num )
{
	if( _base->getOwner() ) {
		_base->getOwner()->removeBase( _base );
	}
	if( num == 0 ) {
		_base->setOwner( 0 );
	} else {
		_base->setOwner( _players->at( num-1 ) );
		_players->at( num-1 )->addBase( _base );
	}
}

void PropertiesBase::init( GenericBase * base )
{
	_base = base;
	_listBuilding->clear();

	for( int i = DataTheme.bases.at( _base->getRace() )->getBuildingCount() - 1; i >= 0; i-- ) {
		InsideBuildingModel * building = DataTheme.bases.at( _base->getRace() )->getBuildingModel( i );
		new QCheckListItem( _listBuilding, building->getName(), QCheckListItem::CheckBox );
	}

 	for( int j = 0; j < (int)_base->getBuildingCount(); j++ ) {
		GenericInsideBuilding * building = _base->getBuilding( j );
		QListViewItemIterator ite( _listBuilding );
		for( uint k = 0; k < building->getLevel(); k++ ) {
			ite++;
		}
		( (QCheckListItem*)ite.current() )->setOn( true );
	}

	if( _base->getOwner() ) {
		_ownerList->setCurrentItem( _base->getOwner()->getNum()+1 );
	} else {
		_ownerList->setCurrentItem( 0 );
	}
}




