/****************************************************************
**
** Attal : Lords of Doom
**
** propertiesBase.h
** Defines properties box for bases on map
**
** Version : $Id: propertiesBase.h,v 1.1 2003/06/22 17:33:13 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 29/12/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

 
#ifndef PROPERTIESBASE_H
#define PROPERTIESBASE_H
 
 
// generic include files
// include files for QT
#include <qdialog.h>
#include <qlist.h>
// application specific include files
#include "libCommon/genericPlayer.h"

class QComboBox;
class QListView;
class GenericLord;
class GenericBase;
class GenericPlayer;

/*              ------------------------------
 *                         PropertiesBase
 *              ------------------------------ */


/** Dialog for editing the properties of the base */
class PropertiesBase : public QDialog
{
	Q_OBJECT
public:
	/** Constructor */
	PropertiesBase( QList<GenericPlayer> * players, QWidget * parent = 0, const char * name = 0 );

	void init( GenericBase * base );

	void refresh( QPtrList<GenericPlayer> * players );

public slots:
	void slot_accept();

	void slot_owner( int );

private:
	QList<GenericPlayer> * _players;
	GenericBase * _base;
	QListView * _listBuilding;
	QComboBox * _ownerList;
};

#endif // PROPERTIESBASE_H
