/****************************************************************
**
** Attal : Lords of Doom
**
** template.cpp
** this is a template for all .cpp files
**
** Version : $Id: tilePresentation.cpp,v 1.2 2004/02/23 18:44:54 tribunal2 Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 05/01/2002
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "tilePresentation.h"
 
// generic include files
#include <stdlib.h>
// include files for QT
#include <qcombobox.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qstring.h>
// application specific include files
#include "libClient/cell.h"
#include "libClient/gui.h"
#include "libClient/imageTheme.h"
#include "libClient/map.h"

#include "libCommon/dataTheme.h"
#include "libCommon/genericCell.h"
#include "libCommon/log.h"

#include "libServer/gameData.h"

extern DataTheme DataTheme;
extern ImageTheme ImageTheme;

//
// ----- TilePresentation -----
//

TilePresentation::TilePresentation( QWidget * parent, const char * name )
: QWidget( parent, name )
{
	_button = new QPushButton( this );
	_button->setFixedSize( 40, 40 );

	_combo = new QComboBox( this );
	FIXEDSIZE( _combo );

	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->setSpacing( 5 );
	layout->addWidget( _button );
	layout->addSpacing( 10 );
	layout->addWidget( _combo );
	layout->addStretch( 1 );
	layout->activate();
	setFixedWidth( 220 );
	setFixedHeight( 40 );
}

void TilePresentation::setCell( CellModel * cell )
{
	uint nb = cell->getDiversificationNumber();
	uint index;

	QString text;

	_cell = cell;
	index = DataTheme.tiles.find( cell );
	_button->setPixmap( * ImageTheme.cells[index]->image( 0 ) );
	_combo->clear();
	_combo->insertItem( "Random" );
	for( uint i = 0; i < nb; i++ ) {
		text.sprintf( tr( "%d (weight=%d)" ), i+1, cell->getDiversification( i ) );
		_combo->insertItem( text );
	}
	FIXEDSIZE( _combo );
}


uint TilePresentation::getDiversification()
{
	uint i, ret = 0;

	ret = _combo->currentItem();

	if( ret == 0 ) {
		uint nb = _cell->getDiversificationNumber();
		uint total = 0, val = 0;

		for( i = 0; i < nb; i++ ) {
			total += _cell->getDiversification( i );
		}
		val = rand() % total;
		total = 0;
		for( i = 0; i < nb; i++ ) {
			total += _cell->getDiversification( i );
			if( val < total ) {
				ret = i;
				break;
			}
		}
	} else {
		ret--;
	}

	return ret;
}
