/****************************************************************
**
** Attal : Lords of Doom
**
** sectionGround.cpp
** sectin for specifying grounds
**
** Version : $Id: sectionGround.cpp,v 1.4 2004/01/14 21:06:36 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 02/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "sectionGround.h"
 
// generic include files
// include files for QT
#include <qlayout.h>
// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/genericCell.h"
#include "libCommon/log.h"

#include "libClient/imageTheme.h"

#include "themeEditor/askDiversification.h"

extern DataTheme DataTheme;
extern ImageTheme ImageTheme;
extern QString IMAGE_PATH;


SectionGround::SectionGround( QWidget * parent, const char * name )
	: GenericSection( parent, name )
{
	setTitle( tr( "Tiles" ) );

	_name = new AskString( tr( "Name: " ), _mainWidget );
	_coef = new AskInt( tr( "Coef: " ), _mainWidget );
	_color = new AskColor( tr( "Color: " ), _mainWidget );
	_diversification = new AskDiversificationList( _mainWidget );

	QVBoxLayout * layout = new QVBoxLayout( _mainWidget );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addWidget( _name );
	layout->addWidget( _coef );
	layout->addWidget( _color );
	layout->addWidget( _diversification );
	layout->addStretch( 1 );
	layout->activate();

	_num = 1;
	init();
}

void SectionGround::clear()
{
	_name->setValue( QString( tr( "Tile " ) ) + QString::number( _num + 1 ) );
	_coef->setValue( 0 );
	_color->setValue( Qt::black );
	_diversification->clear();
}

void SectionGround::init()
{
	if( DataTheme.decorations.count() > 0 ) {
		CellModel * cell = DataTheme.tiles.at( _num );
		_name->setValue( cell->getName() );
		_coef->setValue( cell->getCoeff() );
		_color->setValue( cell->getColor() );
		_diversification->setValue( cell );
	}
}

void SectionGround::save()
{
	if( DataTheme.tiles.count() > 0 ) {
		CellModel * cell = DataTheme.tiles.at( _num );
		cell->setName( _name->getValue() );
		cell->setCoeff( _coef->getValue() );
		cell->setColor( _color->getValue() );
		_diversification->save();
	}
}

void SectionGround::selectFirst()
{
	save();
	_num = 1;
	init();
}

void SectionGround::selectPrevious()
{
	save();
	_num = QMAX( 1, _num - 1 );
	init();
}

void SectionGround::selectNext()
{
	save();
	_num = QMIN( (int)DataTheme.tiles.count() - 1, _num + 1 );
	init();
}

void SectionGround::selectLast()
{
	save();
	_num = DataTheme.tiles.count() - 1;
	init();
}

void SectionGround::selectNew()
{
	save();
	CellModel * cell = new CellModel();
	_num = DataTheme.tiles.count();
	DataTheme.tiles.append( cell );
	clear();
}

void SectionGround::selectDel()
{
	if( DataTheme.tiles.count() > 1 ) {
		DataTheme.tiles.remove( _num );
		_num = QMIN( _num, (int)DataTheme.tiles.count() - 1 );
		init();
	}
}


