/****************************************************************
**
** Attal : Lords of Doom
**
** campaign.cpp
** manage campaign
**
** Version : $Id: campaign.cpp,v 1.2 2004/08/21 22:20:06 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 21/08/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "campaign.h"
 
// generic include files
// include files for QT
// application specific include files
#include "libCommon/log.h"

//
// ----- Campaign -----
//

Campaign::Campaign()
{
	_listScenarii.setAutoDelete( true );
}

Campaign::~Campaign()
{
	
}

uint Campaign::getScenarioNumber()
{
	return _listScenarii.count();
}
	
void Campaign::addScenario( const QString & scenarioName )
{
	_listScenarii.append( new QString( scenarioName ) );
}
	
QString Campaign::getScenario( uint num )
{
	QString ret = "";
	
	if( num < _listScenarii.count() ) {
		ret = * ( _listScenarii.at( num ) );
	}
	
	return ret;
}

void Campaign::save( QTextStream * ts )
{
	(*ts) << "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE campaign>" << endl;
	(*ts) << "<campaign>" << endl;
	(*ts) << "\t<name>" << _name << "</name>" << endl;
        (*ts) << "\t<theme>medieval</theme>" << endl;
        (*ts) << "\t<description>" << endl;
	(*ts) << "\t\t" << _description << endl;
	(*ts) << "\t</description>" << endl;
	for( uint i = 0; i < _listScenarii.count(); i++ ) {
		(*ts) << "\t<scenario>" << ( * ( _listScenarii.at( i ) ) ) << "</scenario>" << endl;
	}
	(*ts) << "</campaign>" << endl;
}


//
// ----- CampaignParser -----
//

CampaignParser::CampaignParser( Campaign * campaign )
{
	_campaign = campaign;
}

bool CampaignParser::startDocument()
{
	// at the beginning of parsing: do some initialization
	_errorProt = "";
	_state = StateInit;
	return true;
}

bool CampaignParser::startElement( const QString& namespaceURI, const QString& localName, const QString& qName, const QXmlAttributes& atts )
{
	bool ret = true;

	if( qName == "campaign" && _state == StateInit ) {
		_state = StateDocument;
	} else if( qName == "name" && _state == StateDocument ) {
		_state = StateName;
	} else if( qName == "description" && _state == StateDocument ) {
		_state = StateDescription;
	} else if( qName == "theme" && _state == StateDocument ) {
		_state = StateTheme;
	} else if( qName == "scenario" && _state == StateDocument ) {
		_state = StateScenario;
	} else {
		logEE( "Not found %s", qName.latin1() );
		return false;
	}
	return ret;
}

bool CampaignParser::endElement( const QString& namespaceURI, const QString& localName, const QString& qName )
{
	bool ret = true;

	switch ( _state ) {
	case StateName:
		_state = StateDocument;
		break;
	case StateDescription:
		_state = StateDocument;
		break;
	case StateTheme:
		_state = StateDocument;
		break;
	case StateScenario:
		_state = StateDocument;
		break;
	default:
		break;
    }
    return ret;
}

bool CampaignParser::characters( const QString & ch )
{
	bool ret = true;
	QString ch_simplified = ch.simplifyWhiteSpace();

	if ( ch_simplified.isEmpty() ) {
		return true;
	}

	switch( _state ) {
	case StateName:
		_campaign->setName( ch_simplified );
		break;
	case StateDescription:
		_campaign->setDescription( ch_simplified );
		break;
	case StateTheme:
		_campaign->setTheme( ch_simplified );
		break;
	case StateScenario:
		_campaign->addScenario( ch_simplified );
		break;
	default:
		ret = false;
	}
	return ret;
}


bool CampaignParser::fatalError( const QXmlParseException & exception )
{
     logEE( "state %d", _state );

    _errorProt += QString( "fatal parsing error: %1 in line %2, column %3\n" )
	.arg( exception.message() )
	.arg( exception.lineNumber() )
	.arg( exception.columnNumber() );

    return QXmlDefaultHandler::fatalError( exception );
}


