/****************************************************************
**
** Attal : Lords of Doom
**
** questConditionProperties.cpp
** Display/edit properties of quest conditions
**
** Version : $Id: questConditionProperties.cpp,v 1.7 2004/07/13 19:33:39 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 20/06/2004
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "questConditionProperties.h"

// generic include files
// include files for QT
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
// application specific include files
#include "libCommon/dataTheme.h"
#include "libCommon/genericLord.h"
#include "libCommon/log.h"
#include "libCommon/quest.h"

#include "libClient/gui.h"

extern DataTheme DataTheme;

//
// ----- QuestConditionProperties -----
//

QuestConditionProperties::QuestConditionProperties( QWidget * parent, const char * name )
: QDialog( parent, name, true )
{
}

QuestConditionProperties::~QuestConditionProperties()
{
}

//
// ----- QuestConditionDateProperties -----
//

QuestConditionDateProperties::QuestConditionDateProperties( QWidget * parent, const char * name )
: QuestConditionProperties( parent, name )
{
	_condition = 0;

	_radioDate = new QRadioButton( this );
	_radioDate->setText( tr( "Before date: " ) );
	FIXEDSIZE( _radioDate );

	_day = new QSpinBox( this );
	_day->setMinValue( 1 );
	_day->setMaxValue( 7 );
	FIXEDSIZE( _day );
	_labDay = new QLabel( tr( "Day" ), this );
	FIXEDSIZE( _labDay );

	_week = new QSpinBox( this );
	_week->setMinValue( 0 );
	_week->setMaxValue( 3 );
	FIXEDSIZE( _week );
	_labWeek = new QLabel( tr( "Week" ), this );
	FIXEDSIZE( _labWeek );

	_month = new QSpinBox( this );
	_month->setMinValue( 0 );
	_month->setMaxValue( 12 );
	FIXEDSIZE( _month );
	_labMonth = new QLabel( tr( "Month" ), this );
	FIXEDSIZE( _labMonth );

	QHBoxLayout * layHDate = new QHBoxLayout();
	layHDate->setSpacing( 5 );
	layHDate->setMargin( 5 );
	layHDate->addWidget( _radioDate );
	layHDate->addWidget( _labDay );
	layHDate->addWidget( _day );
	layHDate->addWidget( _labWeek );
	layHDate->addWidget( _week );
	layHDate->addWidget( _labMonth );
	layHDate->addWidget( _month );
	layHDate->addStretch( 1 );

	_radioDelay = new QRadioButton( this );
	_radioDelay->setText( tr( "Before " ) );
	FIXEDSIZE( _radioDelay );

	_delay = new QSpinBox( this );
	_delay->setMinValue( 1 );
	_delay->setMaxValue( 336 );
	FIXEDSIZE( _delay );
	_labDelay = new QLabel( tr( "day(s)" ), this );
	FIXEDSIZE( _labDelay );

	QHBoxLayout * layHDelay = new QHBoxLayout();
	layHDelay->setSpacing( 5 );
	layHDelay->setMargin( 5 );
	layHDelay->addWidget( _radioDelay );
	layHDelay->addWidget( _delay );
	layHDelay->addWidget( _labDelay );
	layHDelay->addStretch( 1 );

	QPushButton * pbOk = new QPushButton( this );
	pbOk->setText( tr( "Ok" ) );
	FIXEDSIZE( pbOk );

	QPushButton * pbCan = new QPushButton( this );
	pbCan->setText( tr( "Cancel" ) );
	FIXEDSIZE( pbCan );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->setMargin( 5 );
	layH1->setSpacing( 5 );
	layH1->addStretch( 1 );
	layH1->addWidget( pbOk );
	layH1->addStretch( 1 );
	layH1->addWidget( pbCan );
	layH1->addStretch( 1 );


	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addLayout( layHDate );
	layout->addLayout( layHDelay );
	layout->addStretch( 1 );
	layout->addLayout( layH1 );
	layout->activate();

	connect( _radioDate, SIGNAL( clicked() ), SLOT( slot_date() ) );
	connect( _radioDelay, SIGNAL( clicked() ), SLOT( slot_delay() ) );
	connect( pbOk, SIGNAL( clicked() ), SLOT( slot_accept() ) );
	connect( pbCan, SIGNAL( clicked() ), SLOT( reject() ) );

	slot_date();
}

void QuestConditionDateProperties::slot_accept()
{
	if( _condition ) {
		if( _radioDate->isChecked() ) {
			_condition->setConditionDate( _day->value(), _week->value(), _month->value() );
		} else {
			_condition->setConditionDelay( _delay->value() );
		}
	}
	accept();
}

void QuestConditionDateProperties::setCondition( QuestConditionDate * condition )
{
	_condition = condition;

	if( _condition->getCategory() == QuestConditionDate::DATE ) {
		slot_date();
		_day->setValue( _condition->getDay() );
		_week->setValue( _condition->getWeek() );
		_month->setValue( _condition->getMonth() );
	} else {
		slot_delay();
		_delay->setValue( _condition->getDelay() );
	}
}

void QuestConditionDateProperties::slot_date()
{
	_radioDate->setChecked( true );
	_radioDelay->setChecked( false );
	_labDelay->setEnabled( false );
	_delay->setEnabled( false );
	_labDay->setEnabled( true );
	_labWeek->setEnabled( true );
	_labMonth->setEnabled( true );
	_day->setEnabled( true );
	_week->setEnabled( true );
	_month->setEnabled( true );
}

void QuestConditionDateProperties::slot_delay()
{
	_radioDate->setChecked( false );
	_radioDelay->setChecked( true );
	_labDelay->setEnabled( true );
	_delay->setEnabled( true );
	_labDay->setEnabled( false );
	_labWeek->setEnabled( false );
	_labMonth->setEnabled( false );
	_day->setEnabled( false );
	_week->setEnabled( false );
	_month->setEnabled( false );
}


//
// ----- QuestConditionLordProperties -----
//

QuestConditionLordProperties::QuestConditionLordProperties( QWidget * parent, const char * name )
: QuestConditionProperties( parent, name )
{
	_radioPrimary = new QRadioButton( this );
	_radioPrimary->setText( tr( "Primary skill" ) );
	FIXEDSIZE( _radioPrimary );

	_primCharac = new AskLordCharac( this );
	FIXEDSIZE( _primCharac );

	_primCheck = new QComboBox( this );
	_primCheck->insertItem( "<" );
	_primCheck->insertItem( "<=" );
	_primCheck->insertItem( "=" );
	_primCheck->insertItem( ">=" );
	_primCheck->insertItem( ">" );
	FIXEDSIZE( _primCheck );

	_primValue = new AskInt( tr( "value: " ), this );
	FIXEDSIZE( _primValue );

	QHBoxLayout * layPrimary = new QHBoxLayout();
	layPrimary->setSpacing( 5 );
	layPrimary->setMargin( 5 );
	layPrimary->addWidget( _radioPrimary );
	layPrimary->addWidget( _primCharac );
	layPrimary->addWidget( _primCheck );
	layPrimary->addWidget( _primValue );
	layPrimary->addStretch( 1 );

	_radioSecondary  = new QRadioButton( this );
	_radioSecondary->setText( tr( "Secondary skill" ) );
	FIXEDSIZE( _radioSecondary );

	QHBoxLayout * laySecondary = new QHBoxLayout();
	laySecondary->setSpacing( 5 );
	laySecondary->setMargin( 5 );
	laySecondary->addWidget( _radioSecondary );
	laySecondary->addStretch( 1 );

	_radioArtefact = new QRadioButton( this );
	_radioArtefact->setText( tr( "Artefact" ) );
	FIXEDSIZE( _radioArtefact );

	_artefact = new AskCombo( "", this );
	uint nbArtefacts = DataTheme.artefacts.count();
	for( uint i = 0; i < nbArtefacts; i++ ) {
		_artefact->insertItem( DataTheme.artefacts.at( i )->getName() );
	}
	FIXEDSIZE( _artefact );

	QHBoxLayout * layArtefact = new QHBoxLayout();
	layArtefact->setSpacing( 5 );
	layArtefact->setMargin( 5 );
	layArtefact->addWidget( _radioArtefact );
	layArtefact->addWidget( _artefact );
	layArtefact->addStretch( 1 );

	_radioSpell = new QRadioButton( this );
	_radioSpell->setText( tr( "Spell" ) );
	FIXEDSIZE( _radioSpell );

	QHBoxLayout * laySpell = new QHBoxLayout();
	laySpell->setSpacing( 5 );
	laySpell->setMargin( 5 );
	laySpell->addWidget( _radioSpell );
	laySpell->addStretch( 1 );

	QPushButton * pbOk = new QPushButton( this );
	pbOk->setText( tr( "Ok" ) );
	FIXEDSIZE( pbOk );

	QPushButton * pbCan = new QPushButton( this );
	pbCan->setText( tr( "Cancel" ) );
	FIXEDSIZE( pbCan );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->setMargin( 5 );
	layH1->setSpacing( 5 );
	layH1->addStretch( 1 );
	layH1->addWidget( pbOk );
	layH1->addStretch( 1 );
	layH1->addWidget( pbCan );
	layH1->addStretch( 1 );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addLayout( layPrimary );
	layout->addLayout( laySecondary );
	layout->addLayout( layArtefact );
	layout->addLayout( laySpell );
	layout->addStretch( 1 );
	layout->addLayout( layH1 );
	layout->activate();

	connect( _radioPrimary, SIGNAL( clicked() ), SLOT( slot_primarySkill() ) );
	connect( _radioSecondary, SIGNAL( clicked() ), SLOT( slot_secondarySkill() ) );
	connect( _radioArtefact, SIGNAL( clicked() ), SLOT( slot_artefact() ) );
	connect( _radioSpell, SIGNAL( clicked() ), SLOT( slot_spell() ) );
	connect( pbOk, SIGNAL( clicked() ), SLOT( slot_accept() ) );
	connect( pbCan, SIGNAL( clicked() ), SLOT( reject() ) );
}

void QuestConditionLordProperties::setCondition( QuestConditionLord * condition )
{
	_condition = condition;
	switch( _condition->getConditionType() ) {
	case QuestConditionLord::PRIMARY_SKILL:
		slot_primarySkill();
		_primCharac->setCurrentItem( condition->getLordCharac() );
		_primCheck->setCurrentItem( condition->getCheckType() );
		_primValue->setValue( condition->getValue() );
		break;
	case QuestConditionLord::SECONDARY_SKILL:
		slot_secondarySkill();
		break;
	case QuestConditionLord::ARTEFACT:
		slot_artefact();
		_artefact->setCurrentItem( condition->getArtefact() );
		break;
	case QuestConditionLord::SPELL:
		slot_spell();
		break;
	}
}

void QuestConditionLordProperties::slot_accept()
{
	if( _condition ) {
		if( _radioPrimary->isChecked() ) {
			_condition->setPrimarySkillCondition( (LordCharac)_primCharac->currentItem(), (QuestCondition::CheckType)_primCheck->currentItem(), _primValue->getValue());
		} else if( _radioSecondary->isChecked() ) {
			//_condition->setSecondarySkillCondition();
		} else if( _radioArtefact->isChecked() ) {
			_condition->setArtefactCondition( _artefact->currentItem(), true );
		} else {
			//_condition->setSpellCondition();
		}
	}
	accept();
}

void QuestConditionLordProperties::slot_primarySkill()
{
	_radioPrimary->setChecked( true );
	_radioSecondary->setChecked( false );
	_radioArtefact->setChecked( false );
	_radioSpell->setChecked( false );
}

void QuestConditionLordProperties::slot_secondarySkill()
{
	_radioPrimary->setChecked( false );
	_radioSecondary->setChecked( true );
	_radioArtefact->setChecked( false );
	_radioSpell->setChecked( false );
}

void QuestConditionLordProperties::slot_artefact()
{
	_radioPrimary->setChecked( false );
	_radioSecondary->setChecked( false );
	_radioArtefact->setChecked( true );
	_radioSpell->setChecked( false );
}

void QuestConditionLordProperties::slot_spell()
{
	_radioPrimary->setChecked( false );
	_radioSecondary->setChecked( false );
	_radioArtefact->setChecked( false );
	_radioSpell->setChecked( true );
}

//
// ----- QuestConditionPlayerProperties -----
//

QuestConditionPlayerProperties ::QuestConditionPlayerProperties( QWidget * parent, const char * name )
: QuestConditionProperties( parent, name )
{

}

void QuestConditionPlayerProperties ::setCondition( QuestConditionPlayer * condition )
{

}

//
// ----- AskLordCharac -----
//

AskLordCharac::AskLordCharac( QWidget * parent, const char * name )
: AskCombo( tr( "Charac" ), parent, name )
{
	insertItem( getCharacName( ATTACK ) );
	insertItem( getCharacName( DEFENSE ) );
	insertItem( getCharacName( POWER ) );
	insertItem( getCharacName( KNOWLEDGE ) );
	insertItem( getCharacName( MOVE ) );
	insertItem( getCharacName( MAXMOVE ) );
	insertItem( getCharacName( TECHNICPOINT ) );
	insertItem( getCharacName( MAXTECHNICPOINT ) );
	insertItem( getCharacName( MORALE ) );
	insertItem( getCharacName( LUCK ) );
	insertItem( getCharacName( VISION ) );
	insertItem( getCharacName( EXPERIENCE ) );
	FIXEDSIZE( this );
}


