/****************************************************************
**
** Attal : Lords of Doom
**
** mapInterface.cpp
** Manages the editor
**
** Version : $Id: themeInterface.cpp,v 1.6 2004/05/09 11:01:20 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 02/06/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/


#include "themeInterface.h"
 
// include files for QT
#include <qaction.h>
#include <qapplication.h>
#include <qcanvas.h>
#include <qfiledialog.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qsignalmapper.h>
#include <qstatusbar.h>

// application specific include files
#include "conf.h"

#include "libCommon/dataTheme.h"

#include "libClient/gui.h"
#include "libClient/imageTheme.h"

#include "themeEditor/sectionSelector.h"

QCanvasPixmapArray * CellPixmapArray;
QCanvasPixmapArray * LordPixmapArray;
QCanvasPixmapArray * BuildingPixmapArray;

extern DataTheme DataTheme;
extern ImageTheme ImageTheme;
extern QString IMAGE_PATH;
extern QString DATA_PATH;
extern QString THEME;

/** add comments here */
ThemeInterface::ThemeInterface()
{
	setCaption( tr( "Theme editor for 'Attal - Lords of Doom'" ) );
	initActions();
	initMenuBar();
	initStatusBar();

	if( DataTheme.init() && ImageTheme.init() ) {
		_selector = new SectionSelector( this );
		setCentralWidget( _selector );
	} else {
		/// XXX: we could manage this better (later :) )
		QMessageBox::critical( this, tr( "Can't load theme" ), tr( "Theme " ) + THEME + tr( " has not been loaded successfully" ) );
	}

	resize( 600, 600 );
}


void ThemeInterface::initStatusBar()
{
	statusBar()->message( tr( "Status Bar" ), 0 );
}

void ThemeInterface::initActions()
{
	_actions.resize( NB_ACTIONS );

	QAction * action;
	QSignalMapper * sigmap = new QSignalMapper( this );


	action = new QAction( tr( "New theme" ), tr( "&New theme" ), QKeySequence( tr( "CTRL+N" ) ), this );
	_actions.insert( ACTION_NEW, action );
	sigmap->setMapping( action, ACTION_NEW );
	connect( action, SIGNAL( activated() ), sigmap, SLOT( map() ) );

	action = new QAction( tr( "Open theme" ), tr( "&Open theme" ), QKeySequence( tr( "CTRL+O" ) ), this );
	_actions.insert( ACTION_OPEN, action );
	sigmap->setMapping( action, ACTION_OPEN );
	connect( action, SIGNAL( activated() ), sigmap, SLOT( map() ) );

	action = new QAction( tr( "Save theme" ), tr( "&Save theme" ), QKeySequence( tr( "CTRL+S" ) ), this );
	_actions.insert( ACTION_SAVE, action );
	sigmap->setMapping( action, ACTION_SAVE );
	connect( action, SIGNAL( activated() ), sigmap, SLOT( map() ) );

	action = new QAction( tr( "Quit" ), tr( "&Quit" ), QKeySequence( tr( "CTRL+Q" ) ), this );
	_actions.insert( ACTION_QUIT, action );
	sigmap->setMapping( action, ACTION_QUIT );
	connect( action, SIGNAL( activated() ), sigmap, SLOT( map() ) );

	action = new QAction( tr( "Help" ), tr( "&Help" ), QKeySequence( tr( "F1" ) ), this );
	_actions.insert( ACTION_HELP, action );
	sigmap->setMapping( action, ACTION_HELP );
	connect( action, SIGNAL( activated() ), sigmap, SLOT( map() ) );

	connect( sigmap, SIGNAL( mapped( int ) ), SLOT( slot_actions( int ) ) );

	_actions[ ACTION_NEW ]->setEnabled( false );
	_actions[ ACTION_OPEN ]->setEnabled( false );
}

void ThemeInterface::initMenuBar()
{
	QPopupMenu * menuFile = new QPopupMenu();
	_actions[ ACTION_NEW ]->addTo( menuFile );
	_actions[ ACTION_OPEN ]->addTo( menuFile );
	_actions[ ACTION_SAVE ]->addTo( menuFile );
	menuFile->insertSeparator();
	_actions[ ACTION_QUIT ]->addTo( menuFile );

	QPopupMenu * menuHelp = new QPopupMenu();
	_actions[ ACTION_HELP ]->addTo( menuHelp );

	menuBar()->insertItem( tr( "&File" ), menuFile );
	menuBar()->insertItem( tr( "&Help" ), menuHelp );
}

void ThemeInterface::slot_actions( int num )
{
	switch( num ) {
	case ACTION_NEW:
		_actions[ ACTION_SAVE ]->setEnabled( true );
		break;
	case ACTION_OPEN: {
		QString filename;
		filename = QFileDialog::getOpenFileName( "", "*.scn", this );
		if (!filename.isNull()) {

		}
		_actions[ ACTION_SAVE ]->setEnabled( true );

		break;
	}
	case ACTION_SAVE: {
		_selector->save();
		DataTheme.save();
		break;
	}
	case ACTION_QUIT:
		qApp->quit();
		break;
	case ACTION_HELP:
		break;
	}
}

void ThemeInterface::slot_status( QString text )
{
	statusBar()->message( text, 0 );	
}
