TEMPLATE = app
include( ../config.pro )

INCLUDEPATH += ..
unix:LIBS += -L..
unix:LIBS += -lAttalServer
unix:LIBS += -lAttalClient
unix:LIBS += -lAttalCommon

win32:LIBS += ..\AttalServer.lib
win32:LIBS += ..\AttalClient.lib
win32:LIBS += ..\AttalCommon.lib

contains( DEFINES, WITH_SOUND ) {
	contains( CONFIG, staticlib ) {
		unix:LIBS += -lSDL
		unix:LIBS += -lSDL_mixer
	}
}

SOURCES += displayQuests.cpp
SOURCES += editorHandler.cpp
SOURCES += graphicalGameData.cpp
SOURCES += itemSelection.cpp
SOURCES += itemSelector.cpp
SOURCES += propertiesBase.cpp
SOURCES += propertiesBuilding.cpp
SOURCES += propertiesCreature.cpp
SOURCES += propertiesEvent.cpp
SOURCES += propertiesLord.cpp
SOURCES += propertiesPlayers.cpp
SOURCES += questConditionEditor.cpp
SOURCES += questConditionProperties.cpp
SOURCES += questEditor.cpp
SOURCES += scenarioEditor.cpp
SOURCES += scenarioInfo.cpp
SOURCES += scenarioInterface.cpp
SOURCES += screen.cpp
SOURCES += tilePresentation.cpp
SOURCES += tileSelection.cpp

HEADERS += displayQuests.h
HEADERS += editorHandler.h
HEADERS += graphicalGameData.h
HEADERS += itemSelection.h
HEADERS += itemSelector.h
HEADERS += propertiesBase.h
HEADERS += propertiesBuilding.h
HEADERS += propertiesCreature.h
HEADERS += propertiesEvent.h
HEADERS += propertiesLord.h
HEADERS += propertiesPlayers.h
HEADERS += questConditionEditor.h
HEADERS += questConditionProperties.h
HEADERS += questEditor.h
HEADERS += scenarioInfo.h
HEADERS += scenarioInterface.h
HEADERS += screen.h
HEADERS += tilePresentation.h
HEADERS += tileSelection.h


DESTDIR = ..

TARGET = attal-scenario-editor

TRANSLATIONS += ../i18n/de/scenario_editor_de.ts
TRANSLATIONS += ../i18n/fr/scenario_editor_fr.ts
TRANSLATIONS += ../i18n/ru/scenario_editor_ru.ts
TRANSLATIONS += ../i18n/it/scenario_editor_it.ts
