/**********************************************************************

  Audacity: A Digital Audio Editor

  ProgressDialog.cpp

  Copyright
     Leland Lucius
     Vaughan Johnson
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

*******************************************************************//**

\file ProgressDialog.cpp

  Implements ProgressDialog

*//*******************************************************************//**

\class ProgressDialog
\brief Custom progress dialog with Audacity specific semantics.

*//**********************************************************************/

#include "../Audacity.h"

#include <wx/defs.h>
#include <wx/app.h>
#include <wx/button.h>
#include <wx/dcclient.h>
#include <wx/datetime.h>
#include <wx/dialog.h>
#include <wx/event.h>
#include <wx/frame.h>
#include <wx/intl.h>
#if defined(__WXMAC__)
#include <wx/menu.h>
#endif
#include <wx/settings.h>
#include <wx/sizer.h>
#include <wx/stopwatch.h>
#include <wx/window.h>

#include "ProgressDialog.h"
#include "../Prefs.h"
#include "../ShuttleGui.h"

#include <wx/sound.h>

// Remove this when wxSound patch gets applied to wxWidgets
// http://trac.wxwidgets.org/ticket/10362
#if defined(__WXMAC__)
#include <Carbon/Carbon.h>
#endif

// This really should be a Preferences setting
static const unsigned char beep[] =
{
   0x52, 0x49, 0x46, 0x46, 0x36, 0x2B, 0x00, 0x00, 0x57, 0x41, 0x56, 0x45,
   0x66, 0x6D, 0x74, 0x20, 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00,
   0x44, 0xAC, 0x00, 0x00, 0x88, 0x58, 0x01, 0x00, 0x02, 0x00, 0x10, 0x00,
   0x64, 0x61, 0x74, 0x61, 0x12, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x13, 0x0B,
   0xF9, 0x15, 0xC5, 0x20, 0xF0, 0x2A, 0xC0, 0x34, 0xBD, 0x3D, 0x23, 0x46,
   0x89, 0x4D, 0x0A, 0x54, 0xB7, 0x59, 0x45, 0x5E, 0xE8, 0x61, 0x63, 0x64,
   0xF5, 0x65, 0x66, 0x66, 0xE1, 0x65, 0x8C, 0x64, 0x42, 0x62, 0x44, 0x5F,
   0x86, 0x5B, 0x38, 0x57, 0x61, 0x52, 0x23, 0x4D, 0xA0, 0x47, 0xE7, 0x41,
   0x1A, 0x3C, 0x4F, 0x36, 0x9D, 0x30, 0x1E, 0x2B, 0xDE, 0x25, 0xFD, 0x20,
   0x85, 0x1C, 0x67, 0x18, 0xD6, 0x14, 0xA8, 0x11, 0x17, 0x0F, 0xDD, 0x0C,
   0x42, 0x0B, 0x14, 0x0A, 0x26, 0x09, 0xBF, 0x08, 0x70, 0x08, 0x8E, 0x08,
   0xA5, 0x08, 0x01, 0x09, 0x5D, 0x09, 0x85, 0x09, 0xB3, 0x09, 0x83, 0x09,
   0x43, 0x09, 0x7B, 0x08, 0x92, 0x07, 0x36, 0x06, 0x4A, 0x04, 0x12, 0x02,
   0x3E, 0xFF, 0x22, 0xFC, 0x6E, 0xF8, 0x7C, 0xF4, 0x06, 0xF0, 0x60, 0xEB,
   0x7B, 0xE6, 0x3A, 0xE1, 0x01, 0xDC, 0x93, 0xD6, 0x50, 0xD1, 0x07, 0xCC,
   0x0E, 0xC7, 0x4F, 0xC2, 0xE0, 0xBD, 0xE6, 0xB9, 0x64, 0xB6, 0x73, 0xB3,
   0x1C, 0xB1, 0x6C, 0xAF, 0x67, 0xAE, 0x1E, 0xAE, 0x7F, 0xAE, 0xA9, 0xAF,
   0x75, 0xB1, 0x00, 0xB4, 0x21, 0xB7, 0xDA, 0xBA, 0x33, 0xBF, 0xFA, 0xC3,
   0x3C, 0xC9, 0xC5, 0xCE, 0xAF, 0xD4, 0xA6, 0xDA, 0xE1, 0xE0, 0xFA, 0xE6,
   0x06, 0xED, 0x18, 0xF3, 0xC9, 0xF8, 0x65, 0xFE, 0x7C, 0x03, 0x60, 0x08,
   0xAD, 0x0C, 0x82, 0x10, 0x0F, 0x14, 0xED, 0x16, 0x7D, 0x19, 0x67, 0x1B,
   0x02, 0x1D, 0x08, 0x1E, 0xA3, 0x1E, 0x0F, 0x1F, 0x04, 0x1F, 0xDD, 0x1E,
   0x62, 0x1E, 0xE7, 0x1D, 0x37, 0x1D, 0x89, 0x1C, 0x02, 0x1C, 0x7F, 0x1B,
   0x3B, 0x1B, 0x18, 0x1B, 0x46, 0x1B, 0xAD, 0x1B, 0x69, 0x1C, 0x71, 0x1D,
   0xC5, 0x1E, 0x78, 0x20, 0x70, 0x22, 0xAC, 0x24, 0x31, 0x27, 0xD9, 0x29,
   0xBA, 0x2C, 0xA9, 0x2F, 0xA0, 0x32, 0x96, 0x35, 0x63, 0x38, 0x19, 0x3B,
   0x72, 0x3D, 0x9D, 0x3F, 0x5E, 0x41, 0x98, 0x42, 0x69, 0x43, 0x8F, 0x43,
   0x38, 0x43, 0x20, 0x42, 0x7D, 0x40, 0x31, 0x3E, 0x0E, 0x3B, 0x65, 0x37,
   0xEB, 0x32, 0xF7, 0x2D, 0x42, 0x28, 0x29, 0x22, 0x6B, 0x1B, 0x67, 0x14,
   0x0D, 0x0D, 0x43, 0x05, 0x6F, 0xFD, 0x5F, 0xF5, 0x6E, 0xED, 0x71, 0xE5,
   0xC3, 0xDD, 0x57, 0xD6, 0x1E, 0xCF, 0x78, 0xC8, 0x28, 0xC2, 0x93, 0xBC,
   0x75, 0xB7, 0x23, 0xB3, 0x84, 0xAF, 0x86, 0xAC, 0x64, 0xAA, 0xEB, 0xA8,
   0x49, 0xA8, 0x54, 0xA8, 0x24, 0xA9, 0x99, 0xAA, 0xBB, 0xAC, 0x6F, 0xAF,
   0xB0, 0xB2, 0x67, 0xB6, 0x8A, 0xBA, 0x02, 0xBF, 0xC3, 0xC3, 0xB2, 0xC8,
   0xBB, 0xCD, 0xE7, 0xD2, 0xFD, 0xD7, 0x1C, 0xDD, 0xFD, 0xE1, 0xD5, 0xE6,
   0x51, 0xEB, 0x93, 0xEF, 0xA7, 0xF3, 0x4F, 0xF7, 0xCB, 0xFA, 0xCC, 0xFD,
   0xA7, 0x00, 0x07, 0x03, 0x22, 0x05, 0x17, 0x07, 0xAD, 0x08, 0x2D, 0x0A,
   0x5D, 0x0B, 0x8D, 0x0C, 0x7B, 0x0D, 0x7F, 0x0E, 0x56, 0x0F, 0x2E, 0x10,
   0x39, 0x11, 0x2C, 0x12, 0x64, 0x13, 0x92, 0x14, 0x09, 0x16, 0x86, 0x17,
   0x28, 0x19, 0x13, 0x1B, 0x07, 0x1D, 0x34, 0x1F, 0x6B, 0x21, 0xCB, 0x23,
   0x29, 0x26, 0x92, 0x28, 0x05, 0x2B, 0x62, 0x2D, 0xB2, 0x2F, 0xD9, 0x31,
   0xDA, 0x33, 0xA1, 0x35, 0x29, 0x37, 0x64, 0x38, 0x55, 0x39, 0xDC, 0x39,
   0x15, 0x3A, 0xD2, 0x39, 0x3A, 0x39, 0x22, 0x38, 0xAD, 0x36, 0xD4, 0x34,
   0x74, 0x32, 0xD2, 0x2F, 0xAC, 0x2C, 0x52, 0x29, 0x89, 0x25, 0x97, 0x21,
   0x71, 0x1D, 0xF4, 0x18, 0x7D, 0x14, 0xC5, 0x0F, 0x2C, 0x0B, 0x6E, 0x06,
   0xE3, 0x01, 0x74, 0xFD, 0x04, 0xF9, 0xE8, 0xF4, 0xE3, 0xF0, 0x3D, 0xED,
   0xC0, 0xE9, 0xB3, 0xE6, 0xF5, 0xE3, 0x6A, 0xE1, 0x50, 0xDF, 0x70, 0xDD,
   0xFC, 0xDB, 0xBB, 0xDA, 0xE3, 0xD9, 0x32, 0xD9, 0xDC, 0xD8, 0xBD, 0xD8,
   0xB4, 0xD8, 0xEE, 0xD8, 0x30, 0xD9, 0xA0, 0xD9, 0x0B, 0xDA, 0x92, 0xDA,
   0x11, 0xDB, 0x86, 0xDB, 0xF7, 0xDB, 0x4F, 0xDC, 0x9C, 0xDC, 0xCF, 0xDC,
   0xE6, 0xDC, 0xE7, 0xDC, 0xD8, 0xDC, 0xA9, 0xDC, 0x79, 0xDC, 0x2B, 0xDC,
   0xE8, 0xDB, 0x94, 0xDB, 0x42, 0xDB, 0x14, 0xDB, 0xE8, 0xDA, 0xEE, 0xDA,
   0x02, 0xDB, 0x5F, 0xDB, 0xD4, 0xDB, 0xA6, 0xDC, 0x97, 0xDD, 0xD2, 0xDE,
   0x78, 0xE0, 0x50, 0xE2, 0x9B, 0xE4, 0x12, 0xE7, 0x05, 0xEA, 0x20, 0xED,
   0x8B, 0xF0, 0x61, 0xF4, 0x57, 0xF8, 0xAB, 0xFC, 0x10, 0x01, 0xC0, 0x05,
   0x6D, 0x0A, 0x35, 0x0F, 0x1D, 0x14, 0xEC, 0x18, 0xC1, 0x1D, 0x65, 0x22,
   0xF6, 0x26, 0x41, 0x2B, 0x5B, 0x2F, 0x21, 0x33, 0x8A, 0x36, 0xB2, 0x39,
   0x5F, 0x3C, 0xB2, 0x3E, 0x89, 0x40, 0xF4, 0x41, 0xDF, 0x42, 0x59, 0x43,
   0x54, 0x43, 0xE3, 0x42, 0xF2, 0x41, 0x9B, 0x40, 0xD1, 0x3E, 0xAA, 0x3C,
   0x2B, 0x3A, 0x49, 0x37, 0x25, 0x34, 0xB6, 0x30, 0x14, 0x2D, 0x3A, 0x29,
   0x49, 0x25, 0x3E, 0x21, 0x0E, 0x1D, 0xE5, 0x18, 0xAC, 0x14, 0x8E, 0x10,
   0x69, 0x0C, 0x77, 0x08, 0x82, 0x04, 0xD4, 0x00, 0x48, 0xFD, 0xCB, 0xF9,
   0x98, 0xF6, 0x75, 0xF3, 0xA6, 0xF0, 0xE2, 0xED, 0x73, 0xEB, 0x33, 0xE9,
   0xFE, 0xE6, 0x1B, 0xE5, 0x3A, 0xE3, 0xA9, 0xE1, 0x17, 0xE0, 0xC9, 0xDE,
   0x98, 0xDD, 0x69, 0xDC, 0x6F, 0xDB, 0x75, 0xDA, 0xA9, 0xD9, 0xDF, 0xD8,
   0x39, 0xD8, 0xA6, 0xD7, 0x1B, 0xD7, 0xA7, 0xD6, 0x4C, 0xD6, 0xFC, 0xD5,
   0xCC, 0xD5, 0xAF, 0xD5, 0xAC, 0xD5, 0xC9, 0xD5, 0xF8, 0xD5, 0x56, 0xD6,
   0xC7, 0xD6, 0x6D, 0xD7, 0x27, 0xD8, 0x1B, 0xD9, 0x25, 0xDA, 0x5C, 0xDB,
   0xCB, 0xDC, 0x58, 0xDE, 0x1E, 0xE0, 0xFF, 0xE1, 0x17, 0xE4, 0x4A, 0xE6,
   0x93, 0xE8, 0x26, 0xEB, 0xB3, 0xED, 0x7F, 0xF0, 0x3E, 0xF3, 0x3A, 0xF6,
   0x14, 0xF9, 0x0D, 0xFC, 0x17, 0xFF, 0x10, 0x02, 0x1A, 0x05, 0x01, 0x08,
   0xF5, 0x0A, 0xB8, 0x0D, 0x81, 0x10, 0x12, 0x13, 0x81, 0x15, 0xEC, 0x17,
   0x13, 0x1A, 0x31, 0x1C, 0x05, 0x1E, 0xCB, 0x1F, 0x48, 0x21, 0x9A, 0x22,
   0xD6, 0x23, 0xCB, 0x24, 0xAB, 0x25, 0x4B, 0x26, 0xCF, 0x26, 0x21, 0x27,
   0x4A, 0x27, 0x58, 0x27, 0x3F, 0x27, 0x03, 0x27, 0xB0, 0x26, 0x35, 0x26,
   0xB0, 0x25, 0x07, 0x25, 0x4C, 0x24, 0x7F, 0x23, 0x98, 0x22, 0xAB, 0x21,
   0xA0, 0x20, 0x92, 0x1F, 0x6A, 0x1E, 0x3E, 0x1D, 0x0F, 0x1C, 0xB2, 0x1A,
   0x66, 0x19, 0xEC, 0x17, 0x81, 0x16, 0xEB, 0x14, 0x5C, 0x13, 0xC3, 0x11,
   0xF3, 0x0F, 0x3A, 0x0E, 0x45, 0x0C, 0x66, 0x0A, 0x4C, 0x08, 0x4A, 0x06,
   0x29, 0x04, 0xE7, 0x01, 0xA6, 0xFF, 0x43, 0xFD, 0xE9, 0xFA, 0x6C, 0xF8,
   0xFF, 0xF5, 0x74, 0xF3, 0xFD, 0xF0, 0x87, 0xEE, 0xF9, 0xEB, 0x8A, 0xE9,
   0x0F, 0xE7, 0xB5, 0xE4, 0x5C, 0xE2, 0x29, 0xE0, 0x0B, 0xDE, 0x03, 0xDC,
   0x1F, 0xDA, 0x62, 0xD8, 0xC8, 0xD6, 0x5E, 0xD5, 0x23, 0xD4, 0x19, 0xD3,
   0x42, 0xD2, 0xA2, 0xD1, 0x3A, 0xD1, 0x0E, 0xD1, 0x1A, 0xD1, 0x64, 0xD1,
   0xDF, 0xD1, 0xAB, 0xD2, 0x9D, 0xD3, 0xE0, 0xD4, 0x48, 0xD6, 0xFA, 0xD7,
   0xD4, 0xD9, 0xED, 0xDB, 0x2B, 0xDE, 0x8F, 0xE0, 0x39, 0xE3, 0xEC, 0xE5,
   0xE4, 0xE8, 0xD6, 0xEB, 0x08, 0xEF, 0x2D, 0xF2, 0x65, 0xF5, 0xC9, 0xF8,
   0x14, 0xFC, 0x82, 0xFF, 0xD1, 0x02, 0x37, 0x06, 0x73, 0x09, 0xA5, 0x0C,
   0xD5, 0x0F, 0xDF, 0x12, 0xD8, 0x15, 0xA3, 0x18, 0x58, 0x1B, 0xD7, 0x1D,
   0x20, 0x20, 0x5D, 0x22, 0x49, 0x24, 0x1F, 0x26, 0xA5, 0x27, 0x0D, 0x29,
   0x26, 0x2A, 0x1B, 0x2B, 0xC4, 0x2B, 0x3B, 0x2C, 0x7D, 0x2C, 0x83, 0x2C,
   0x56, 0x2C, 0xEC, 0x2B, 0x57, 0x2B, 0x85, 0x2A, 0x8F, 0x29, 0x60, 0x28,
   0x12, 0x27, 0x8F, 0x25, 0xF7, 0x23, 0x2E, 0x22, 0x57, 0x20, 0x65, 0x1E,
   0x50, 0x1C, 0x35, 0x1A, 0xFF, 0x17, 0xCA, 0x15, 0x7B, 0x13, 0x3E, 0x11,
   0xFA, 0x0E, 0xA6, 0x0C, 0x68, 0x0A, 0x1B, 0x08, 0xEE, 0x05, 0xAF, 0x03,
   0x98, 0x01, 0x73, 0xFF, 0x76, 0xFD, 0x8C, 0xFB, 0x90, 0xF9, 0xC6, 0xF7,
   0xEF, 0xF5, 0x41, 0xF4, 0x90, 0xF2, 0x00, 0xF1, 0x89, 0xEF, 0x04, 0xEE,
   0xA8, 0xEC, 0x44, 0xEB, 0x06, 0xEA, 0xBF, 0xE8, 0xA3, 0xE7, 0x87, 0xE6,
   0x78, 0xE5, 0x7B, 0xE4, 0x87, 0xE3, 0xAF, 0xE2, 0xD9, 0xE1, 0x21, 0xE1,
   0x80, 0xE0, 0xDE, 0xDF, 0x6A, 0xDF, 0xF4, 0xDE, 0xAC, 0xDE, 0x6E, 0xDE,
   0x54, 0xDE, 0x57, 0xDE, 0x6F, 0xDE, 0xB0, 0xDE, 0x0C, 0xDF, 0x8E, 0xDF,
   0x34, 0xE0, 0xF7, 0xE0, 0xEA, 0xE1, 0xF2, 0xE2, 0x1C, 0xE4, 0x7E, 0xE5,
   0xEB, 0xE6, 0x94, 0xE8, 0x42, 0xEA, 0x25, 0xEC, 0x14, 0xEE, 0x0D, 0xF0,
   0x49, 0xF2, 0x69, 0xF4, 0xC9, 0xF6, 0x09, 0xF9, 0x7B, 0xFB, 0xCF, 0xFD,
   0x44, 0x00, 0x9A, 0x02, 0xEE, 0x04, 0x4C, 0x07, 0x91, 0x09, 0xCB, 0x0B,
   0xF1, 0x0D, 0x01, 0x10, 0xF6, 0x11, 0xC2, 0x13, 0x90, 0x15, 0x25, 0x17,
   0xB0, 0x18, 0x09, 0x1A, 0x50, 0x1B, 0x67, 0x1C, 0x5B, 0x1D, 0x3E, 0x1E,
   0xF3, 0x1E, 0x92, 0x1F, 0x0A, 0x20, 0x6B, 0x20, 0xAB, 0x20, 0xD0, 0x20,
   0xDE, 0x20, 0xD4, 0x20, 0xAF, 0x20, 0x7B, 0x20, 0x26, 0x20, 0xD0, 0x1F,
   0x4E, 0x1F, 0xD6, 0x1E, 0x39, 0x1E, 0x8F, 0x1D, 0xD4, 0x1C, 0xFF, 0x1B,
   0x24, 0x1B, 0x25, 0x1A, 0x23, 0x19, 0x0F, 0x18, 0xCD, 0x16, 0x8E, 0x15,
   0x1D, 0x14, 0xAC, 0x12, 0x09, 0x11, 0x65, 0x0F, 0xA4, 0x0D, 0xB2, 0x0B,
   0xC0, 0x09, 0x96, 0x07, 0x72, 0x05, 0x1A, 0x03, 0xC5, 0x00, 0x5D, 0xFE,
   0xCC, 0xFB, 0x45, 0xF9, 0x9B, 0xF6, 0x03, 0xF4, 0x51, 0xF1, 0xB6, 0xEE,
   0x13, 0xEC, 0x85, 0xE9, 0x15, 0xE7, 0x9E, 0xE4, 0x5B, 0xE2, 0x29, 0xE0,
   0x26, 0xDE, 0x4E, 0xDC, 0xA2, 0xDA, 0x39, 0xD9, 0xF5, 0xD7, 0xF8, 0xD6,
   0x39, 0xD6, 0xB6, 0xD5, 0x7E, 0xD5, 0x82, 0xD5, 0xCF, 0xD5, 0x60, 0xD6,
   0x30, 0xD7, 0x47, 0xD8, 0x94, 0xD9, 0x27, 0xDB, 0xE7, 0xDC, 0xD7, 0xDE,
   0x08, 0xE1, 0x4C, 0xE3, 0xCA, 0xE5, 0x52, 0xE8, 0x03, 0xEB, 0xB4, 0xED,
   0x83, 0xF0, 0x40, 0xF3, 0x03, 0xF6, 0xC9, 0xF8, 0x75, 0xFB, 0x23, 0xFE,
   0xA2, 0x00, 0x21, 0x03, 0x68, 0x05, 0x8B, 0x07, 0xAB, 0x09, 0x83, 0x0B,
   0x54, 0x0D, 0xDF, 0x0E, 0x63, 0x10, 0x9F, 0x11, 0xBF, 0x12, 0xCA, 0x13,
   0xA2, 0x14, 0x6B, 0x15, 0x09, 0x16, 0x95, 0x16, 0x07, 0x17, 0x55, 0x17,
   0xB1, 0x17, 0xE4, 0x17, 0x21, 0x18, 0x45, 0x18, 0x6E, 0x18, 0x8A, 0x18,
   0xAB, 0x18, 0xC1, 0x18, 0xDA, 0x18, 0xF4, 0x18, 0x0C, 0x19, 0x21, 0x19,
   0x36, 0x19, 0x42, 0x19, 0x4E, 0x19, 0x51, 0x19, 0x41, 0x19, 0x33, 0x19,
   0xFF, 0x18, 0xD0, 0x18, 0x76, 0x18, 0x11, 0x18, 0x99, 0x17, 0xE9, 0x16,
   0x33, 0x16, 0x46, 0x15, 0x48, 0x14, 0x14, 0x13, 0xD0, 0x11, 0x52, 0x10,
   0xC8, 0x0E, 0x1A, 0x0D, 0x37, 0x0B, 0x4D, 0x09, 0x2E, 0x07, 0x13, 0x05,
   0xC9, 0x02, 0x88, 0x00, 0x3E, 0xFE, 0xD0, 0xFB, 0x7F, 0xF9, 0x16, 0xF7,
   0xCF, 0xF4, 0x7F, 0xF2, 0x58, 0xF0, 0x45, 0xEE, 0x41, 0xEC, 0x69, 0xEA,
   0xAA, 0xE8, 0x1E, 0xE7, 0xB5, 0xE5, 0x7B, 0xE4, 0x7D, 0xE3, 0x93, 0xE2,
   0xF4, 0xE1, 0x6E, 0xE1, 0x29, 0xE1, 0x05, 0xE1, 0x16, 0xE1, 0x50, 0xE1,
   0xAB, 0xE1, 0x37, 0xE2, 0xD5, 0xE2, 0x9C, 0xE3, 0x7A, 0xE4, 0x69, 0xE5,
   0x75, 0xE6, 0x85, 0xE7, 0x9E, 0xE8, 0xD1, 0xE9, 0xF0, 0xEA, 0x2F, 0xEC,
   0x4D, 0xED, 0x8A, 0xEE, 0xA5, 0xEF, 0xC8, 0xF0, 0xEA, 0xF1, 0x01, 0xF3,
   0x1A, 0xF4, 0x26, 0xF5, 0x39, 0xF6, 0x3F, 0xF7, 0x3C, 0xF8, 0x57, 0xF9,
   0x5B, 0xFA, 0x7C, 0xFB, 0x90, 0xFC, 0xC2, 0xFD, 0xEC, 0xFE, 0x38, 0x00,
   0x7E, 0x01, 0xD3, 0x02, 0x50, 0x04, 0xC7, 0x05, 0x66, 0x07, 0xFF, 0x08,
   0xBB, 0x0A, 0x70, 0x0C, 0x35, 0x0E, 0x0E, 0x10, 0xDC, 0x11, 0xBF, 0x13,
   0x89, 0x15, 0x5F, 0x17, 0x18, 0x19, 0xC5, 0x1A, 0x60, 0x1C, 0xDE, 0x1D,
   0x3A, 0x1F, 0x70, 0x20, 0x80, 0x21, 0x5B, 0x22, 0x0A, 0x23, 0x7E, 0x23,
   0xBC, 0x23, 0xBB, 0x23, 0x82, 0x23, 0x02, 0x23, 0x4E, 0x22, 0x51, 0x21,
   0x22, 0x20, 0xB9, 0x1E, 0x09, 0x1D, 0x39, 0x1B, 0x1D, 0x19, 0xF4, 0x16,
   0x86, 0x14, 0x0E, 0x12, 0x7E, 0x0F, 0xBD, 0x0C, 0x0C, 0x0A, 0x35, 0x07,
   0x78, 0x04, 0xA8, 0x01, 0xF8, 0xFE, 0x5B, 0xFC, 0xBF, 0xF9, 0x54, 0xF7,
   0xF9, 0xF4, 0xD1, 0xF2, 0xC6, 0xF0, 0xF2, 0xEE, 0x54, 0xED, 0xCC, 0xEB,
   0x8A, 0xEA, 0x65, 0xE9, 0x80, 0xE8, 0xBE, 0xE7, 0x31, 0xE7, 0xC9, 0xE6,
   0x8E, 0xE6, 0x7E, 0xE6, 0x80, 0xE6, 0xA9, 0xE6, 0xE9, 0xE6, 0x40, 0xE7,
   0xA7, 0xE7, 0x21, 0xE8, 0xA3, 0xE8, 0x2C, 0xE9, 0xBA, 0xE9, 0x48, 0xEA,
   0xD8, 0xEA, 0x63, 0xEB, 0xEB, 0xEB, 0x6B, 0xEC, 0xEB, 0xEC, 0x64, 0xED,
   0xDA, 0xED, 0x4A, 0xEE, 0xBD, 0xEE, 0x28, 0xEF, 0xA1, 0xEF, 0x11, 0xF0,
   0x86, 0xF0, 0x17, 0xF1, 0x9E, 0xF1, 0x4E, 0xF2, 0xF0, 0xF2, 0xC7, 0xF3,
   0x96, 0xF4, 0x80, 0xF5, 0x98, 0xF6, 0xAD, 0xF7, 0xFD, 0xF8, 0x47, 0xFA,
   0xC6, 0xFB, 0x44, 0xFD, 0xDD, 0xFE, 0x99, 0x00, 0x5A, 0x02, 0x35, 0x04,
   0x10, 0x06, 0xFE, 0x07, 0xE2, 0x09, 0xC2, 0x0B, 0xB0, 0x0D, 0x7F, 0x0F,
   0x54, 0x11, 0x00, 0x13, 0xA8, 0x14, 0x22, 0x16, 0x88, 0x17, 0xC2, 0x18,
   0xD1, 0x19, 0xC5, 0x1A, 0x7F, 0x1B, 0x14, 0x1C, 0x77, 0x1C, 0xAA, 0x1C,
   0xB0, 0x1C, 0x81, 0x1C, 0x2F, 0x1C, 0xA6, 0x1B, 0x00, 0x1B, 0x26, 0x1A,
   0x34, 0x19, 0x1A, 0x18, 0xF1, 0x16, 0x9C, 0x15, 0x46, 0x14, 0xCE, 0x12,
   0x5B, 0x11, 0xD0, 0x0F, 0x52, 0x0E, 0xCF, 0x0C, 0x46, 0x0B, 0xD2, 0x09,
   0x50, 0x08, 0xF7, 0x06, 0x8B, 0x05, 0x4B, 0x04, 0x03, 0x03, 0xDD, 0x01,
   0xCA, 0x00, 0xAF, 0xFF, 0xBC, 0xFE, 0xBD, 0xFD, 0xE1, 0xFC, 0xFC, 0xFB,
   0x30, 0xFB, 0x6B, 0xFA, 0x9A, 0xF9, 0xD8, 0xF8, 0x0C, 0xF8, 0x47, 0xF7,
   0x75, 0xF6, 0xA8, 0xF5, 0xD6, 0xF4, 0xF1, 0xF3, 0x0F, 0xF3, 0x1B, 0xF2,
   0x2A, 0xF1, 0x27, 0xF0, 0x2D, 0xEF, 0x28, 0xEE, 0x23, 0xED, 0x1D, 0xEC,
   0x1E, 0xEB, 0x24, 0xEA, 0x38, 0xE9, 0x58, 0xE8, 0x8E, 0xE7, 0xD5, 0xE6,
   0x39, 0xE6, 0xBA, 0xE5, 0x5B, 0xE5, 0x23, 0xE5, 0x0D, 0xE5, 0x29, 0xE5,
   0x69, 0xE5, 0xD2, 0xE5, 0x77, 0xE6, 0x41, 0xE7, 0x42, 0xE8, 0x6C, 0xE9,
   0xC7, 0xEA, 0x48, 0xEC, 0xED, 0xED, 0xCA, 0xEF, 0xB4, 0xF1, 0xD7, 0xF3,
   0xF5, 0xF5, 0x48, 0xF8, 0x8E, 0xFA, 0xE6, 0xFC, 0x51, 0xFF, 0xAB, 0x01,
   0x12, 0x04, 0x5D, 0x06, 0xA5, 0x08, 0xCD, 0x0A, 0xE4, 0x0C, 0xD4, 0x0E,
   0x9F, 0x10, 0x52, 0x12, 0xD3, 0x13, 0x32, 0x15, 0x5B, 0x16, 0x63, 0x17,
   0x2E, 0x18, 0xD2, 0x18, 0x4C, 0x19, 0x96, 0x19, 0xBB, 0x19, 0xB0, 0x19,
   0x8C, 0x19, 0x34, 0x19, 0xCD, 0x18, 0x39, 0x18, 0x9E, 0x17, 0xDD, 0x16,
   0x18, 0x16, 0x39, 0x15, 0x57, 0x14, 0x67, 0x13, 0x78, 0x12, 0x83, 0x11,
   0x8F, 0x10, 0x9C, 0x0F, 0xAC, 0x0E, 0xC5, 0x0D, 0xDA, 0x0C, 0x01, 0x0C,
   0x30, 0x0B, 0x55, 0x0A, 0x91, 0x09, 0xC0, 0x08, 0x02, 0x08, 0x36, 0x07,
   0x7B, 0x06, 0xBD, 0x05, 0xED, 0x04, 0x2D, 0x04, 0x4B, 0x03, 0x81, 0x02,
   0x8F, 0x01, 0xAD, 0x00, 0xBE, 0xFF, 0xAF, 0xFE, 0xAB, 0xFD, 0x85, 0xFC,
   0x6A, 0xFB, 0x2E, 0xFA, 0x01, 0xF9, 0xB4, 0xF7, 0x78, 0xF6, 0x33, 0xF5,
   0xE1, 0xF3, 0xA0, 0xF2, 0x54, 0xF1, 0x1E, 0xF0, 0xE8, 0xEE, 0xC8, 0xED,
   0xBC, 0xEC, 0xBA, 0xEB, 0xDA, 0xEA, 0x0A, 0xEA, 0x61, 0xE9, 0xD0, 0xE8,
   0x64, 0xE8, 0x1E, 0xE8, 0xF4, 0xE7, 0xF8, 0xE7, 0x1B, 0xE8, 0x67, 0xE8,
   0xD7, 0xE8, 0x6A, 0xE9, 0x1F, 0xEA, 0xF8, 0xEA, 0xED, 0xEB, 0x05, 0xED,
   0x2B, 0xEE, 0x7A, 0xEF, 0xC6, 0xF0, 0x38, 0xF2, 0xA7, 0xF3, 0x1B, 0xF5,
   0xAC, 0xF6, 0x24, 0xF8, 0xB8, 0xF9, 0x2D, 0xFB, 0xB5, 0xFC, 0x1C, 0xFE,
   0x7C, 0xFF, 0xDD, 0x00, 0x1D, 0x02, 0x61, 0x03, 0x7E, 0x04, 0x9C, 0x05,
   0x98, 0x06, 0x7E, 0x07, 0x68, 0x08, 0x2B, 0x09, 0xEF, 0x09, 0x96, 0x0A,
   0x3B, 0x0B, 0xC8, 0x0B, 0x49, 0x0C, 0xCD, 0x0C, 0x3D, 0x0D, 0xB1, 0x0D,
   0x18, 0x0E, 0x7E, 0x0E, 0xE0, 0x0E, 0x42, 0x0F, 0x9C, 0x0F, 0xFA, 0x0F,
   0x52, 0x10, 0xB1, 0x10, 0x05, 0x11, 0x5B, 0x11, 0xAB, 0x11, 0xF6, 0x11,
   0x3D, 0x12, 0x77, 0x12, 0xA9, 0x12, 0xCE, 0x12, 0xE3, 0x12, 0xEC, 0x12,
   0xD9, 0x12, 0xC5, 0x12, 0x7F, 0x12, 0x39, 0x12, 0xC6, 0x11, 0x45, 0x11,
   0x9F, 0x10, 0xE4, 0x0F, 0x0E, 0x0F, 0x10, 0x0E, 0xFE, 0x0C, 0xC6, 0x0B,
   0x81, 0x0A, 0x12, 0x09, 0x9F, 0x07, 0x03, 0x06, 0x67, 0x04, 0xBC, 0x02,
   0xF3, 0x00, 0x36, 0xFF, 0x5D, 0xFD, 0x9A, 0xFB, 0xC5, 0xF9, 0x08, 0xF8,
   0x53, 0xF6, 0x9F, 0xF4, 0x0A, 0xF3, 0x7E, 0xF1, 0x12, 0xF0, 0xBD, 0xEE,
   0x86, 0xED, 0x7A, 0xEC, 0x7B, 0xEB, 0xAF, 0xEA, 0xFD, 0xE9, 0x77, 0xE9,
   0x0F, 0xE9, 0xD4, 0xE8, 0xB9, 0xE8, 0xC2, 0xE8, 0xEC, 0xE8, 0x3A, 0xE9,
   0xA0, 0xE9, 0x30, 0xEA, 0xC9, 0xEA, 0x8D, 0xEB, 0x54, 0xEC, 0x3A, 0xED,
   0x2C, 0xEE, 0x2D, 0xEF, 0x39, 0xF0, 0x4B, 0xF1, 0x69, 0xF2, 0x83, 0xF3,
   0x9E, 0xF4, 0xC4, 0xF5, 0xD9, 0xF6, 0x00, 0xF8, 0x0A, 0xF9, 0x29, 0xFA,
   0x2B, 0xFB, 0x2B, 0xFC, 0x33, 0xFD, 0x23, 0xFE, 0x20, 0xFF, 0x03, 0x00,
   0xF4, 0x00, 0xCE, 0x01, 0xB2, 0x02, 0x8A, 0x03, 0x52, 0x04, 0x34, 0x05,
   0xF9, 0x05, 0xD4, 0x06, 0x99, 0x07, 0x6E, 0x08, 0x2F, 0x09, 0xF9, 0x09,
   0xBE, 0x0A, 0x87, 0x0B, 0x45, 0x0C, 0x05, 0x0D, 0xBE, 0x0D, 0x6B, 0x0E,
   0x17, 0x0F, 0xB7, 0x0F, 0x4F, 0x10, 0xDB, 0x10, 0x57, 0x11, 0xC6, 0x11,
   0x24, 0x12, 0x6A, 0x12, 0xA9, 0x12, 0xC5, 0x12, 0xD5, 0x12, 0xC9, 0x12,
   0xA3, 0x12, 0x6E, 0x12, 0x13, 0x12, 0xAD, 0x11, 0x27, 0x11, 0x8A, 0x10,
   0xD5, 0x0F, 0x09, 0x0F, 0x2B, 0x0E, 0x34, 0x0D, 0x2E, 0x0C, 0x22, 0x0B,
   0xF1, 0x09, 0xCA, 0x08, 0x87, 0x07, 0x46, 0x06, 0xFA, 0x04, 0xB1, 0x03,
   0x6C, 0x02, 0x1A, 0x01, 0xD6, 0xFF, 0x8E, 0xFE, 0x5B, 0xFD, 0x20, 0xFC,
   0x04, 0xFB, 0xEE, 0xF9, 0xDE, 0xF8, 0xE6, 0xF7, 0xF2, 0xF6, 0x1E, 0xF6,
   0x48, 0xF5, 0x97, 0xF4, 0xE3, 0xF3, 0x52, 0xF3, 0xCC, 0xF2, 0x50, 0xF2,
   0xE9, 0xF1, 0x8E, 0xF1, 0x40, 0xF1, 0x02, 0xF1, 0xD0, 0xF0, 0xAC, 0xF0,
   0x8D, 0xF0, 0x7D, 0xF0, 0x71, 0xF0, 0x77, 0xF0, 0x78, 0xF0, 0x92, 0xF0,
   0x9E, 0xF0, 0xCA, 0xF0, 0xE7, 0xF0, 0x1D, 0xF1, 0x50, 0xF1, 0x90, 0xF1,
   0xD6, 0xF1, 0x22, 0xF2, 0x80, 0xF2, 0xDE, 0xF2, 0x52, 0xF3, 0xC6, 0xF3,
   0x51, 0xF4, 0xDF, 0xF4, 0x7F, 0xF5, 0x2B, 0xF6, 0xDA, 0xF6, 0xA9, 0xF7,
   0x78, 0xF8, 0x5E, 0xF9, 0x4B, 0xFA, 0x4A, 0xFB, 0x4E, 0xFC, 0x59, 0xFD,
   0x7D, 0xFE, 0x9F, 0xFF, 0xCF, 0x00, 0x00, 0x02, 0x3C, 0x03, 0x6F, 0x04,
   0xA7, 0x05, 0xE1, 0x06, 0x16, 0x08, 0x45, 0x09, 0x6C, 0x0A, 0x89, 0x0B,
   0x9A, 0x0C, 0x95, 0x0D, 0x8D, 0x0E, 0x68, 0x0F, 0x39, 0x10, 0xEB, 0x10,
   0x90, 0x11, 0x16, 0x12, 0x85, 0x12, 0xDD, 0x12, 0x14, 0x13, 0x3A, 0x13,
   0x3F, 0x13, 0x2D, 0x13, 0xFF, 0x12, 0xBA, 0x12, 0x59, 0x12, 0xE9, 0x11,
   0x56, 0x11, 0xBA, 0x10, 0xFF, 0x0F, 0x3D, 0x0F, 0x60, 0x0E, 0x7C, 0x0D,
   0x8E, 0x0C, 0x87, 0x0B, 0x88, 0x0A, 0x6D, 0x09, 0x61, 0x08, 0x3A, 0x07,
   0x29, 0x06, 0xFC, 0x04, 0xEB, 0x03, 0xCC, 0x02, 0xB3, 0x01, 0x9C, 0x00,
   0x88, 0xFF, 0x81, 0xFE, 0x75, 0xFD, 0x80, 0xFC, 0x8F, 0xFB, 0x9A, 0xFA,
   0xC0, 0xF9, 0xDA, 0xF8, 0x15, 0xF8, 0x42, 0xF7, 0x8E, 0xF6, 0xDE, 0xF5,
   0x33, 0xF5, 0x96, 0xF4, 0x02, 0xF4, 0x78, 0xF3, 0xFE, 0xF2, 0x87, 0xF2,
   0x2A, 0xF2, 0xC4, 0xF1, 0x7C, 0xF1, 0x30, 0xF1, 0xFF, 0xF0, 0xCD, 0xF0,
   0xB2, 0xF0, 0x9D, 0xF0, 0x99, 0xF0, 0xA2, 0xF0, 0xB7, 0xF0, 0xDB, 0xF0,
   0x0E, 0xF1, 0x4B, 0xF1, 0x9F, 0xF1, 0xF4, 0xF1, 0x62, 0xF2, 0xD8, 0xF2,
   0x60, 0xF3, 0xF6, 0xF3, 0x92, 0xF4, 0x47, 0xF5, 0xF9, 0xF5, 0xBC, 0xF6,
   0x92, 0xF7, 0x62, 0xF8, 0x4F, 0xF9, 0x2D, 0xFA, 0x28, 0xFB, 0x18, 0xFC,
   0x0B, 0xFD, 0x11, 0xFE, 0x07, 0xFF, 0x11, 0x00, 0x06, 0x01, 0x0E, 0x02,
   0x00, 0x03, 0xFB, 0x03, 0xE9, 0x04, 0xC8, 0x05, 0xB4, 0x06, 0x87, 0x07,
   0x58, 0x08, 0x1E, 0x09, 0xD6, 0x09, 0x84, 0x0A, 0x1E, 0x0B, 0xB8, 0x0B,
   0x38, 0x0C, 0xB7, 0x0C, 0x1B, 0x0D, 0x7E, 0x0D, 0xC8, 0x0D, 0x04, 0x0E,
   0x3A, 0x0E, 0x59, 0x0E, 0x71, 0x0E, 0x7A, 0x0E, 0x70, 0x0E, 0x61, 0x0E,
   0x3E, 0x0E, 0x15, 0x0E, 0xD9, 0x0D, 0x97, 0x0D, 0x48, 0x0D, 0xE9, 0x0C,
   0x8B, 0x0C, 0x13, 0x0C, 0xA2, 0x0B, 0x21, 0x0B, 0x90, 0x0A, 0x05, 0x0A,
   0x5D, 0x09, 0xC7, 0x08, 0x0F, 0x08, 0x69, 0x07, 0xAE, 0x06, 0xF0, 0x05,
   0x2E, 0x05, 0x61, 0x04, 0x99, 0x03, 0xBE, 0x02, 0xF3, 0x01, 0x1C, 0x01,
   0x40, 0x00, 0x64, 0xFF, 0x87, 0xFE, 0xA9, 0xFD, 0xCE, 0xFC, 0xF1, 0xFB,
   0x21, 0xFB, 0x45, 0xFA, 0x76, 0xF9, 0xA5, 0xF8, 0xE1, 0xF7, 0x1B, 0xF7,
   0x65, 0xF6, 0xB1, 0xF5, 0x0A, 0xF5, 0x70, 0xF4, 0xD9, 0xF3, 0x52, 0xF3,
   0xD8, 0xF2, 0x67, 0xF2, 0x0A, 0xF2, 0xB4, 0xF1, 0x74, 0xF1, 0x40, 0xF1,
   0x1A, 0xF1, 0x0A, 0xF1, 0x01, 0xF1, 0x13, 0xF1, 0x2B, 0xF1, 0x5B, 0xF1,
   0x9A, 0xF1, 0xE5, 0xF1, 0x48, 0xF2, 0xB2, 0xF2, 0x32, 0xF3, 0xBD, 0xF3,
   0x58, 0xF4, 0xFC, 0xF4, 0xAF, 0xF5, 0x6E, 0xF6, 0x38, 0xF7, 0x0F, 0xF8,
   0xE9, 0xF8, 0xD3, 0xF9, 0xBA, 0xFA, 0xA7, 0xFB, 0xA4, 0xFC, 0x96, 0xFD,
   0x9C, 0xFE, 0x8F, 0xFF, 0x98, 0x00, 0x89, 0x01, 0x81, 0x02, 0x7B, 0x03,
   0x68, 0x04, 0x59, 0x05, 0x38, 0x06, 0x19, 0x07, 0xEB, 0x07, 0xAD, 0x08,
   0x74, 0x09, 0x21, 0x0A, 0xCE, 0x0A, 0x64, 0x0B, 0xF5, 0x0B, 0x6F, 0x0C,
   0xE3, 0x0C, 0x3F, 0x0D, 0x93, 0x0D, 0xD1, 0x0D, 0x07, 0x0E, 0x28, 0x0E,
   0x39, 0x0E, 0x40, 0x0E, 0x2E, 0x0E, 0x18, 0x0E, 0xE7, 0x0D, 0xB5, 0x0D,
   0x67, 0x0D, 0x17, 0x0D, 0xB2, 0x0C, 0x47, 0x0C, 0xCD, 0x0B, 0x49, 0x0B,
   0xBA, 0x0A, 0x22, 0x0A, 0x81, 0x09, 0xD8, 0x08, 0x27, 0x08, 0x7C, 0x07,
   0xB7, 0x06, 0xFF, 0x05, 0x36, 0x05, 0x75, 0x04, 0xA8, 0x03, 0xE4, 0x02,
   0x12, 0x02, 0x51, 0x01, 0x8B, 0x00, 0xBE, 0xFF, 0xFF, 0xFE, 0x34, 0xFE,
   0x7C, 0xFD, 0xBA, 0xFC, 0x07, 0xFC, 0x5A, 0xFB, 0xA6, 0xFA, 0x03, 0xFA,
   0x5C, 0xF9, 0xC4, 0xF8, 0x2D, 0xF8, 0xA0, 0xF7, 0x21, 0xF7, 0x9A, 0xF6,
   0x2D, 0xF6, 0xB7, 0xF5, 0x59, 0xF5, 0xF9, 0xF4, 0xA9, 0xF4, 0x64, 0xF4,
   0x22, 0xF4, 0xF3, 0xF3, 0xC6, 0xF3, 0xAC, 0xF3, 0x95, 0xF3, 0x92, 0xF3,
   0x92, 0xF3, 0xA8, 0xF3, 0xBD, 0xF3, 0xEA, 0xF3, 0x1B, 0xF4, 0x5B, 0xF4,
   0xA9, 0xF4, 0xFF, 0xF4, 0x61, 0xF5, 0xCE, 0xF5, 0x47, 0xF6, 0xCC, 0xF6,
   0x59, 0xF7, 0xF1, 0xF7, 0x93, 0xF8, 0x3B, 0xF9, 0xE4, 0xF9, 0xA3, 0xFA,
   0x5A, 0xFB, 0x24, 0xFC, 0xE5, 0xFC, 0xB5, 0xFD, 0x7E, 0xFE, 0x47, 0xFF,
   0x1C, 0x00, 0xE4, 0x00, 0xB8, 0x01, 0x7C, 0x02, 0x4B, 0x03, 0x04, 0x04,
   0xCD, 0x04, 0x77, 0x05, 0x2E, 0x06, 0xD3, 0x06, 0x73, 0x07, 0x10, 0x08,
   0x96, 0x08, 0x25, 0x09, 0x95, 0x09, 0x08, 0x0A, 0x68, 0x0A, 0xC7, 0x0A,
   0x10, 0x0B, 0x57, 0x0B, 0x8B, 0x0B, 0xB9, 0x0B, 0xD6, 0x0B, 0xED, 0x0B,
   0xF6, 0x0B, 0xF7, 0x0B, 0xEA, 0x0B, 0xD4, 0x0B, 0xB3, 0x0B, 0x87, 0x0B,
   0x56, 0x0B, 0x17, 0x0B, 0xCF, 0x0A, 0x80, 0x0A, 0x24, 0x0A, 0xC4, 0x09,
   0x59, 0x09, 0xE5, 0x08, 0x72, 0x08, 0xE9, 0x07, 0x64, 0x07, 0xD1, 0x06,
   0x3A, 0x06, 0x9B, 0x05, 0xF6, 0x04, 0x54, 0x04, 0x9C, 0x03, 0xEF, 0x02,
   0x2E, 0x02, 0x75, 0x01, 0xB0, 0x00, 0xF0, 0xFF, 0x2F, 0xFF, 0x60, 0xFE,
   0xA0, 0xFD, 0xD0, 0xFC, 0x10, 0xFC, 0x45, 0xFB, 0x86, 0xFA, 0xC7, 0xF9,
   0x0F, 0xF9, 0x60, 0xF8, 0xB2, 0xF7, 0x0E, 0xF7, 0x73, 0xF6, 0xE5, 0xF5,
   0x5A, 0xF5, 0xE8, 0xF4, 0x78, 0xF4, 0x1A, 0xF4, 0xCA, 0xF3, 0x87, 0xF3,
   0x54, 0xF3, 0x36, 0xF3, 0x1D, 0xF3, 0x21, 0xF3, 0x2B, 0xF3, 0x4C, 0xF3,
   0x7C, 0xF3, 0xB5, 0xF3, 0x0B, 0xF4, 0x5F, 0xF4, 0xCE, 0xF4, 0x46, 0xF5,
   0xC8, 0xF5, 0x5C, 0xF6, 0xF4, 0xF6, 0x9B, 0xF7, 0x47, 0xF8, 0xFD, 0xF8,
   0xB4, 0xF9, 0x70, 0xFA, 0x35, 0xFB, 0xFA, 0xFB, 0xBF, 0xFC, 0x88, 0xFD,
   0x4C, 0xFE, 0x10, 0xFF, 0xCB, 0xFF, 0x8B, 0x00, 0x44, 0x01, 0xF6, 0x01,
   0xA5, 0x02, 0x4D, 0x03, 0xEA, 0x03, 0x7F, 0x04, 0x16, 0x05, 0x99, 0x05,
   0x25, 0x06, 0x93, 0x06, 0x11, 0x07, 0x70, 0x07, 0xD6, 0x07, 0x30, 0x08,
   0x81, 0x08, 0xD0, 0x08, 0x0F, 0x09, 0x52, 0x09, 0x80, 0x09, 0xB6, 0x09,
   0xD6, 0x09, 0xFA, 0x09, 0x13, 0x0A, 0x23, 0x0A, 0x32, 0x0A, 0x33, 0x0A,
   0x32, 0x0A, 0x27, 0x0A, 0x16, 0x0A, 0xFB, 0x09, 0xDE, 0x09, 0xAD, 0x09,
   0x82, 0x09, 0x41, 0x09, 0x03, 0x09, 0xB8, 0x08, 0x60, 0x08, 0x05, 0x08,
   0x9A, 0x07, 0x2F, 0x07, 0xB1, 0x06, 0x34, 0x06, 0xAE, 0x05, 0x19, 0x05,
   0x83, 0x04, 0xE0, 0x03, 0x3D, 0x03, 0x8E, 0x02, 0xE1, 0x01, 0x2B, 0x01,
   0x73, 0x00, 0xC2, 0xFF, 0x02, 0xFF, 0x49, 0xFE, 0x90, 0xFD, 0xDA, 0xFC,
   0x22, 0xFC, 0x7A, 0xFB, 0xCD, 0xFA, 0x2D, 0xFA, 0x8D, 0xF9, 0xFC, 0xF8,
   0x6E, 0xF8, 0xF0, 0xF7, 0x76, 0xF7, 0x14, 0xF7, 0xAB, 0xF6, 0x5F, 0xF6,
   0x12, 0xF6, 0xDA, 0xF5, 0xAB, 0xF5, 0x88, 0xF5, 0x76, 0xF5, 0x69, 0xF5,
   0x70, 0xF5, 0x7C, 0xF5, 0x95, 0xF5, 0xBD, 0xF5, 0xE5, 0xF5, 0x23, 0xF6,
   0x60, 0xF6, 0xA6, 0xF6, 0xFD, 0xF6, 0x4C, 0xF7, 0xB3, 0xF7, 0x0D, 0xF8,
   0x82, 0xF8, 0xE1, 0xF8, 0x5D, 0xF9, 0xCA, 0xF9, 0x48, 0xFA, 0xC3, 0xFA,
   0x40, 0xFB, 0xC2, 0xFB, 0x45, 0xFC, 0xC3, 0xFC, 0x4F, 0xFD, 0xD3, 0xFD,
   0x60, 0xFE, 0xE8, 0xFE, 0x78, 0xFF, 0x00, 0x00, 0x94, 0x00, 0x1F, 0x01,
   0xA8, 0x01, 0x41, 0x02, 0xC8, 0x02, 0x60, 0x03, 0xEA, 0x03, 0x79, 0x04,
   0x09, 0x05, 0x8A, 0x05, 0x1A, 0x06, 0x99, 0x06, 0x1F, 0x07, 0x97, 0x07,
   0x11, 0x08, 0x7F, 0x08, 0xE6, 0x08, 0x4C, 0x09, 0xA0, 0x09, 0xF3, 0x09,
   0x36, 0x0A, 0x72, 0x0A, 0x9F, 0x0A, 0xC1, 0x0A, 0xD6, 0x0A, 0xDE, 0x0A,
   0xDA, 0x0A, 0xC3, 0x0A, 0xA3, 0x0A, 0x73, 0x0A, 0x33, 0x0A, 0xEA, 0x09,
   0x8F, 0x09, 0x2A, 0x09, 0xB7, 0x08, 0x35, 0x08, 0xB0, 0x07, 0x13, 0x07,
   0x80, 0x06, 0xD7, 0x05, 0x2A, 0x05, 0x7A, 0x04, 0xBD, 0x03, 0x08, 0x03,
   0x45, 0x02, 0x8D, 0x01, 0xD0, 0x00, 0x12, 0x00, 0x5A, 0xFF, 0xA1, 0xFE,
   0xF4, 0xFD, 0x43, 0xFD, 0xA2, 0xFC, 0x0A, 0xFC, 0x6C, 0xFB, 0xE7, 0xFA,
   0x5C, 0xFA, 0xE7, 0xF9, 0x72, 0xF9, 0x0D, 0xF9, 0xAF, 0xF8, 0x5C, 0xF8,
   0x19, 0xF8, 0xD5, 0xF7, 0xA0, 0xF7, 0x75, 0xF7, 0x4F, 0xF7, 0x35, 0xF7,
   0x22, 0xF7, 0x19, 0xF7, 0x11, 0xF7, 0x1A, 0xF7, 0x1D, 0xF7, 0x32, 0xF7,
   0x46, 0xF7, 0x61, 0xF7, 0x81, 0xF7, 0xAA, 0xF7, 0xD0, 0xF7, 0x07, 0xF8,
   0x35, 0xF8, 0x74, 0xF8, 0xAF, 0xF8, 0xF1, 0xF8, 0x3D, 0xF9, 0x85, 0xF9,
   0xDE, 0xF9, 0x2D, 0xFA, 0x93, 0xFA, 0xEE, 0xFA, 0x59, 0xFB, 0xC6, 0xFB,
   0x2D, 0xFC, 0xB1, 0xFC, 0x21, 0xFD, 0xAB, 0xFD, 0x2A, 0xFE, 0xB6, 0xFE,
   0x43, 0xFF, 0xCB, 0xFF, 0x66, 0x00, 0xF4, 0x00, 0x90, 0x01, 0x21, 0x02,
   0xBD, 0x02, 0x4F, 0x03, 0xDD, 0x03, 0x76, 0x04, 0xF9, 0x04, 0x8C, 0x05,
   0x06, 0x06, 0x88, 0x06, 0xFA, 0x06, 0x69, 0x07, 0xCB, 0x07, 0x24, 0x08,
   0x77, 0x08, 0xBA, 0x08, 0xF7, 0x08, 0x24, 0x09, 0x49, 0x09, 0x61, 0x09,
   0x6B, 0x09, 0x6B, 0x09, 0x5E, 0x09, 0x48, 0x09, 0x26, 0x09, 0xF4, 0x08,
   0xC3, 0x08, 0x7A, 0x08, 0x39, 0x08, 0xDB, 0x07, 0x8A, 0x07, 0x20, 0x07,
   0xBC, 0x06, 0x4E, 0x06, 0xDF, 0x05, 0x66, 0x05, 0xEF, 0x04, 0x6F, 0x04,
   0xF5, 0x03, 0x73, 0x03, 0xF7, 0x02, 0x72, 0x02, 0xF7, 0x01, 0x7A, 0x01,
   0xFB, 0x00, 0x80, 0x00, 0x03, 0x00, 0x8E, 0xFF, 0x13, 0xFF, 0xA2, 0xFE,
   0x33, 0xFE, 0xBF, 0xFD, 0x56, 0xFD, 0xE6, 0xFC, 0x81, 0xFC, 0x16, 0xFC,
   0xB8, 0xFB, 0x54, 0xFB, 0xF9, 0xFA, 0x9A, 0xFA, 0x42, 0xFA, 0xEE, 0xF9,
   0x97, 0xF9, 0x4D, 0xF9, 0x04, 0xF9, 0xBA, 0xF8, 0x7D, 0xF8, 0x3C, 0xF8,
   0x08, 0xF8, 0xD9, 0xF7, 0xAD, 0xF7, 0x8C, 0xF7, 0x72, 0xF7, 0x5C, 0xF7,
   0x57, 0xF7, 0x51, 0xF7, 0x5F, 0xF7, 0x6C, 0xF7, 0x8E, 0xF7, 0xAF, 0xF7,
   0xE3, 0xF7, 0x1E, 0xF8, 0x65, 0xF8, 0xB4, 0xF8, 0x11, 0xF9, 0x75, 0xF9,
   0xE2, 0xF9, 0x58, 0xFA, 0xD8, 0xFA, 0x60, 0xFB, 0xED, 0xFB, 0x83, 0xFC,
   0x1C, 0xFD, 0xBB, 0xFD, 0x56, 0xFE, 0xFF, 0xFE, 0xA0, 0xFF, 0x49, 0x00,
   0xEB, 0x00, 0x8F, 0x01, 0x2C, 0x02, 0xCC, 0x02, 0x5E, 0x03, 0xEE, 0x03,
   0x79, 0x04, 0xFB, 0x04, 0x77, 0x05, 0xEA, 0x05, 0x51, 0x06, 0xB1, 0x06,
   0x05, 0x07, 0x51, 0x07, 0x94, 0x07, 0xC7, 0x07, 0xF9, 0x07, 0x19, 0x08,
   0x33, 0x08, 0x41, 0x08, 0x47, 0x08, 0x45, 0x08, 0x39, 0x08, 0x26, 0x08,
   0x09, 0x08, 0xEA, 0x07, 0xBE, 0x07, 0x91, 0x07, 0x5A, 0x07, 0x22, 0x07,
   0xE1, 0x06, 0x9F, 0x06, 0x57, 0x06, 0x0B, 0x06, 0xBC, 0x05, 0x71, 0x05,
   0x13, 0x05, 0xC7, 0x04, 0x61, 0x04, 0x11, 0x04, 0xA6, 0x03, 0x51, 0x03,
   0xEA, 0x02, 0x88, 0x02, 0x20, 0x02, 0xB6, 0x01, 0x50, 0x01, 0xDE, 0x00,
   0x78, 0x00, 0x07, 0x00, 0x97, 0xFF, 0x2A, 0xFF, 0xB1, 0xFE, 0x49, 0xFE,
   0xCA, 0xFD, 0x67, 0xFD, 0xE8, 0xFC, 0x84, 0xFC, 0x13, 0xFC, 0xA8, 0xFB,
   0x40, 0xFB, 0xDA, 0xFA, 0x79, 0xFA, 0x1E, 0xFA, 0xC6, 0xF9, 0x77, 0xF9,
   0x2B, 0xF9, 0xE8, 0xF8, 0xAC, 0xF8, 0x78, 0xF8, 0x4D, 0xF8, 0x29, 0xF8,
   0x11, 0xF8, 0x01, 0xF8, 0xFB, 0xF7, 0xFF, 0xF7, 0x0B, 0xF8, 0x23, 0xF8,
   0x43, 0xF8, 0x6E, 0xF8, 0xA0, 0xF8, 0xDF, 0xF8, 0x20, 0xF9, 0x71, 0xF9,
   0xC3, 0xF9, 0x1E, 0xFA, 0x83, 0xFA, 0xE5, 0xFA, 0x53, 0xFB, 0xC3, 0xFB,
   0x35, 0xFC, 0xB0, 0xFC, 0x24, 0xFD, 0xA3, 0xFD, 0x1B, 0xFE, 0x93, 0xFE,
   0x11, 0xFF, 0x88, 0xFF, 0x02, 0x00, 0x77, 0x00, 0xEC, 0x00, 0x5A, 0x01,
   0xC4, 0x01, 0x32, 0x02, 0x94, 0x02, 0xF9, 0x02, 0x54, 0x03, 0xB1, 0x03,
   0x03, 0x04, 0x52, 0x04, 0x9E, 0x04, 0xE9, 0x04, 0x28, 0x05, 0x6B, 0x05,
   0xA2, 0x05, 0xDA, 0x05, 0x0A, 0x06, 0x39, 0x06, 0x5A, 0x06, 0x88, 0x06,
   0x9C, 0x06, 0xC1, 0x06, 0xCD, 0x06, 0xE5, 0x06, 0xEB, 0x06, 0xF6, 0x06,
   0xF2, 0x06, 0xF1, 0x06, 0xE3, 0x06, 0xD3, 0x06, 0xBF, 0x06, 0x9C, 0x06,
   0x81, 0x06, 0x50, 0x06, 0x20, 0x06, 0xEB, 0x05, 0xA9, 0x05, 0x65, 0x05,
   0x1A, 0x05, 0xC7, 0x04, 0x6F, 0x04, 0x0F, 0x04, 0xAA, 0x03, 0x3E, 0x03,
   0xCE, 0x02, 0x5C, 0x02, 0xDE, 0x01, 0x69, 0x01, 0xE6, 0x00, 0x68, 0x00,
   0xE3, 0xFF, 0x5F, 0xFF, 0xDD, 0xFE, 0x57, 0xFE, 0xD8, 0xFD, 0x5A, 0xFD,
   0xDC, 0xFC, 0x65, 0xFC, 0xEF, 0xFB, 0x83, 0xFB, 0x14, 0xFB, 0xB8, 0xFA,
   0x5A, 0xFA, 0x07, 0xFA, 0xBB, 0xF9, 0x74, 0xF9, 0x3D, 0xF9, 0x06, 0xF9,
   0xE2, 0xF8, 0xBD, 0xF8, 0xAA, 0xF8, 0x98, 0xF8, 0x95, 0xF8, 0x98, 0xF8,
   0xA6, 0xF8, 0xB6, 0xF8, 0xD9, 0xF8, 0xF7, 0xF8, 0x25, 0xF9, 0x58, 0xF9,
   0x8E, 0xF9, 0xD0, 0xF9, 0x11, 0xFA, 0x5C, 0xFA, 0xA7, 0xFA, 0xFA, 0xFA,
   0x4D, 0xFB, 0xA7, 0xFB, 0x00, 0xFC, 0x5F, 0xFC, 0xBB, 0xFC, 0x22, 0xFD,
   0x77, 0xFD, 0xE7, 0xFD, 0x3E, 0xFE, 0xAC, 0xFE, 0x08, 0xFF, 0x72, 0xFF,
   0xD1, 0xFF, 0x35, 0x00, 0x99, 0x00, 0xF2, 0x00, 0x5A, 0x01, 0xB1, 0x01,
   0x14, 0x02, 0x6B, 0x02, 0xCA, 0x02, 0x1B, 0x03, 0x72, 0x03, 0xC2, 0x03,
   0x14, 0x04, 0x60, 0x04, 0xA7, 0x04, 0xF1, 0x04, 0x2D, 0x05, 0x6C, 0x05,
   0xA4, 0x05, 0xD7, 0x05, 0x08, 0x06, 0x2D, 0x06, 0x55, 0x06, 0x6D, 0x06,
   0x88, 0x06, 0x95, 0x06, 0xA0, 0x06, 0xA3, 0x06, 0x9C, 0x06, 0x94, 0x06,
   0x7E, 0x06, 0x65, 0x06, 0x44, 0x06, 0x1B, 0x06, 0xEE, 0x05, 0xB5, 0x05,
   0x7A, 0x05, 0x34, 0x05, 0xEF, 0x04, 0x9A, 0x04, 0x52, 0x04, 0xEC, 0x03,
   0x9A, 0x03, 0x31, 0x03, 0xD0, 0x02, 0x68, 0x02, 0xFF, 0x01, 0x98, 0x01,
   0x27, 0x01, 0xBF, 0x00, 0x4C, 0x00, 0xE8, 0xFF, 0x74, 0xFF, 0x12, 0xFF,
   0xA8, 0xFE, 0x44, 0xFE, 0xE2, 0xFD, 0x82, 0xFD, 0x27, 0xFD, 0xD0, 0xFC,
   0x7D, 0xFC, 0x2C, 0xFC, 0xE7, 0xFB, 0x9F, 0xFB, 0x62, 0xFB, 0x26, 0xFB,
   0xEE, 0xFA, 0xC3, 0xFA, 0x92, 0xFA, 0x71, 0xFA, 0x51, 0xFA, 0x34, 0xFA,
   0x1F, 0xFA, 0x10, 0xFA, 0x02, 0xFA, 0x01, 0xFA, 0xFB, 0xF9, 0x01, 0xFA,
   0x0B, 0xFA, 0x18, 0xFA, 0x2B, 0xFA, 0x43, 0xFA, 0x61, 0xFA, 0x7E, 0xFA,
   0xA9, 0xFA, 0xCC, 0xFA, 0x03, 0xFB, 0x30, 0xFB, 0x6D, 0xFB, 0xA6, 0xFB,
   0xE7, 0xFB, 0x2C, 0xFC, 0x74, 0xFC, 0xBD, 0xFC, 0x10, 0xFD, 0x5F, 0xFD,
   0xBB, 0xFD, 0x0E, 0xFE, 0x71, 0xFE, 0xC8, 0xFE, 0x2A, 0xFF, 0x8D, 0xFF,
   0xEF, 0xFF, 0x55, 0x00, 0xB8, 0x00, 0x1E, 0x01, 0x83, 0x01, 0xE2, 0x01,
   0x49, 0x02, 0xA5, 0x02, 0x07, 0x03, 0x5F, 0x03, 0xBB, 0x03, 0x0B, 0x04,
   0x5D, 0x04, 0xA6, 0x04, 0xEF, 0x04, 0x2D, 0x05, 0x6A, 0x05, 0x9F, 0x05,
   0xCD, 0x05, 0xF5, 0x05, 0x16, 0x06, 0x2D, 0x06, 0x44, 0x06, 0x4A, 0x06,
   0x53, 0x06, 0x4D, 0x06, 0x43, 0x06, 0x32, 0x06, 0x18, 0x06, 0xFA, 0x05,
   0xD4, 0x05, 0xA7, 0x05, 0x74, 0x05, 0x3D, 0x05, 0xFE, 0x04, 0xC0, 0x04,
   0x73, 0x04, 0x2E, 0x04, 0xD7, 0x03, 0x8C, 0x03, 0x30, 0x03, 0xDA, 0x02,
   0x84, 0x02, 0x21, 0x02, 0xC9, 0x01, 0x67, 0x01, 0x08, 0x01, 0xAB, 0x00,
   0x47, 0x00, 0xEC, 0xFF, 0x8D, 0xFF, 0x33, 0xFF, 0xD9, 0xFE, 0x7C, 0xFE,
   0x29, 0xFE, 0xD1, 0xFD, 0x80, 0xFD, 0x33, 0xFD, 0xE6, 0xFC, 0x9F, 0xFC,
   0x5A, 0xFC, 0x14, 0xFC, 0xDF, 0xFB, 0x9B, 0xFB, 0x71, 0xFB, 0x39, 0xFB,
   0x13, 0xFB, 0xE5, 0xFA, 0xC9, 0xFA, 0xA6, 0xFA, 0x91, 0xFA, 0x7D, 0xFA,
   0x6D, 0xFA, 0x66, 0xFA, 0x61, 0xFA, 0x65, 0xFA, 0x6A, 0xFA, 0x79, 0xFA,
   0x87, 0xFA, 0xA3, 0xFA, 0xBD, 0xFA, 0xDE, 0xFA, 0x07, 0xFB, 0x30, 0xFB,
   0x64, 0xFB, 0x98, 0xFB, 0xD2, 0xFB, 0x10, 0xFC, 0x51, 0xFC, 0x97, 0xFC,
   0xE2, 0xFC, 0x2D, 0xFD, 0x7F, 0xFD, 0xCF, 0xFD, 0x25, 0xFE, 0x77, 0xFE,
   0xD3, 0xFE, 0x28, 0xFF, 0x86, 0xFF, 0xDC, 0xFF, 0x39, 0x00, 0x91, 0x00,
   0xEB, 0x00, 0x41, 0x01, 0x95, 0x01, 0xEA, 0x01, 0x3C, 0x02, 0x8B, 0x02,
   0xD6, 0x02, 0x21, 0x03, 0x64, 0x03, 0xA5, 0x03, 0xE4, 0x03, 0x1B, 0x04,
   0x54, 0x04, 0x7E, 0x04, 0xB0, 0x04, 0xD2, 0x04, 0xF4, 0x04, 0x13, 0x05,
   0x26, 0x05, 0x3C, 0x05, 0x46, 0x05, 0x50, 0x05, 0x50, 0x05, 0x4F, 0x05,
   0x46, 0x05, 0x39, 0x05, 0x29, 0x05, 0x0F, 0x05, 0xF6, 0x04, 0xD2, 0x04,
   0xB2, 0x04, 0x85, 0x04, 0x5C, 0x04, 0x28, 0x04, 0xF3, 0x03, 0xBC, 0x03,
   0x7D, 0x03, 0x41, 0x03, 0xFB, 0x02, 0xBC, 0x02, 0x70, 0x02, 0x29, 0x02,
   0xDB, 0x01, 0x8F, 0x01, 0x3D, 0x01, 0xF0, 0x00, 0xA1, 0x00, 0x4B, 0x00,
   0xFE, 0xFF, 0xA5, 0xFF, 0x59, 0xFF, 0x04, 0xFF, 0xB6, 0xFE, 0x66, 0xFE,
   0x1A, 0xFE, 0xCB, 0xFD, 0x84, 0xFD, 0x39, 0xFD, 0xF6, 0xFC, 0xB1, 0xFC,
   0x76, 0xFC, 0x37, 0xFC, 0x03, 0xFC, 0xCD, 0xFB, 0x9D, 0xFB, 0x74, 0xFB,
   0x49, 0xFB, 0x2D, 0xFB, 0x09, 0xFB, 0xF8, 0xFA, 0xDF, 0xFA, 0xD7, 0xFA,
   0xC9, 0xFA, 0xCD, 0xFA, 0xC7, 0xFA, 0xD7, 0xFA, 0xDD, 0xFA, 0xF7, 0xFA,
   0x07, 0xFB, 0x2C, 0xFB, 0x46, 0xFB, 0x75, 0xFB, 0x9B, 0xFB, 0xCE, 0xFB,
   0x00, 0xFC, 0x3D, 0xFC, 0x76, 0xFC, 0xBA, 0xFC, 0xFB, 0xFC, 0x45, 0xFD,
   0x8E, 0xFD, 0xDA, 0xFD, 0x27, 0xFE, 0x78, 0xFE, 0xCA, 0xFE, 0x1D, 0xFF,
   0x71, 0xFF, 0xC6, 0xFF, 0x19, 0x00, 0x6B, 0x00, 0xC0, 0x00, 0x13, 0x01,
   0x62, 0x01, 0xB3, 0x01, 0x01, 0x02, 0x49, 0x02, 0x95, 0x02, 0xD4, 0x02,
   0x1D, 0x03, 0x58, 0x03, 0x95, 0x03, 0xCB, 0x03, 0xFE, 0x03, 0x2E, 0x04,
   0x57, 0x04, 0x7B, 0x04, 0x9D, 0x04, 0xB6, 0x04, 0xD1, 0x04, 0xDF, 0x04,
   0xEB, 0x04, 0xF5, 0x04, 0xF5, 0x04, 0xF1, 0x04, 0xED, 0x04, 0xD8, 0x04,
   0xCF, 0x04, 0xB0, 0x04, 0x9B, 0x04, 0x76, 0x04, 0x55, 0x04, 0x2A, 0x04,
   0xFE, 0x03, 0xCD, 0x03, 0x9A, 0x03, 0x60, 0x03, 0x2B, 0x03, 0xE8, 0x02,
   0xAD, 0x02, 0x68, 0x02, 0x24, 0x02, 0xDE, 0x01, 0x96, 0x01, 0x4E, 0x01,
   0x04, 0x01, 0xBE, 0x00, 0x6D, 0x00, 0x2A, 0x00, 0xD8, 0xFF, 0x94, 0xFF,
   0x46, 0xFF, 0x01, 0xFF, 0xBB, 0xFE, 0x73, 0xFE, 0x33, 0xFE, 0xEC, 0xFD,
   0xB1, 0xFD, 0x71, 0xFD, 0x35, 0xFD, 0x03, 0xFD, 0xC8, 0xFC, 0x9C, 0xFC,
   0x6A, 0xFC, 0x3D, 0xFC, 0x1C, 0xFC, 0xF0, 0xFB, 0xDB, 0xFB, 0xB6, 0xFB,
   0xA5, 0xFB, 0x8E, 0xFB, 0x81, 0xFB, 0x74, 0xFB, 0x71, 0xFB, 0x6C, 0xFB,
   0x73, 0xFB, 0x75, 0xFB, 0x85, 0xFB, 0x92, 0xFB, 0xA9, 0xFB, 0xC0, 0xFB,
   0xDF, 0xFB, 0xFE, 0xFB, 0x25, 0xFC, 0x4B, 0xFC, 0x7D, 0xFC, 0xA8, 0xFC,
   0xE1, 0xFC, 0x15, 0xFD, 0x51, 0xFD, 0x8B, 0xFD, 0xCD, 0xFD, 0x0B, 0xFE,
   0x54, 0xFE, 0x93, 0xFE, 0xE0, 0xFE, 0x24, 0xFF, 0x6C, 0xFF, 0xB5, 0xFF,
   0xFF, 0xFF, 0x47, 0x00, 0x92, 0x00, 0xD9, 0x00, 0x1F, 0x01, 0x66, 0x01,
   0xA9, 0x01, 0xE8, 0x01, 0x2C, 0x02, 0x66, 0x02, 0xA2, 0x02, 0xDA, 0x02,
   0x0D, 0x03, 0x41, 0x03, 0x6B, 0x03, 0x98, 0x03, 0xBB, 0x03, 0xE3, 0x03,
   0xFB, 0x03, 0x1B, 0x04, 0x2E, 0x04, 0x3F, 0x04, 0x50, 0x04, 0x57, 0x04,
   0x5D, 0x04, 0x5E, 0x04, 0x5A, 0x04, 0x52, 0x04, 0x4A, 0x04, 0x35, 0x04,
   0x27, 0x04, 0x0B, 0x04, 0xF1, 0x03, 0xD2, 0x03, 0xB0, 0x03, 0x87, 0x03,
   0x63, 0x03, 0x31, 0x03, 0x07, 0x03, 0xCF, 0x02, 0xA0, 0x02, 0x62, 0x02,
   0x2C, 0x02, 0xEF, 0x01, 0xB1, 0x01, 0x74, 0x01, 0x2F, 0x01, 0xEF, 0x00,
   0xA9, 0x00, 0x67, 0x00, 0x1F, 0x00, 0xDF, 0xFF, 0x96, 0xFF, 0x51, 0xFF,
   0x0D, 0xFF, 0xC9, 0xFE, 0x84, 0xFE, 0x46, 0xFE, 0x01, 0xFE, 0xC6, 0xFD,
   0x8B, 0xFD, 0x4F, 0xFD, 0x1A, 0xFD, 0xE5, 0xFC, 0xB3, 0xFC, 0x87, 0xFC,
   0x5C, 0xFC, 0x38, 0xFC, 0x15, 0xFC, 0xF8, 0xFB, 0xDE, 0xFB, 0xC9, 0xFB,
   0xB9, 0xFB, 0xAE, 0xFB, 0xA8, 0xFB, 0xA6, 0xFB, 0xA7, 0xFB, 0xB2, 0xFB,
   0xBB, 0xFB, 0xD2, 0xFB, 0xE1, 0xFB, 0x01, 0xFC, 0x1A, 0xFC, 0x43, 0xFC,
   0x66, 0xFC, 0x92, 0xFC, 0xC2, 0xFC, 0xEF, 0xFC, 0x29, 0xFD, 0x5D, 0xFD,
   0x95, 0xFD, 0xD6, 0xFD, 0x0D, 0xFE, 0x53, 0xFE, 0x8E, 0xFE, 0xD5, 0xFE,
   0x14, 0xFF, 0x55, 0xFF, 0x9C, 0xFF, 0xD7, 0xFF, 0x23, 0x00, 0x5B, 0x00,
   0xA4, 0x00, 0xDC, 0x00, 0x1C, 0x01, 0x59, 0x01, 0x90, 0x01, 0xCC, 0x01,
   0x00, 0x02, 0x34, 0x02, 0x66, 0x02, 0x92, 0x02, 0xBF, 0x02, 0xE8, 0x02,
   0x0F, 0x03, 0x31, 0x03, 0x51, 0x03, 0x70, 0x03, 0x85, 0x03, 0xA3, 0x03,
   0xAE, 0x03, 0xC3, 0x03, 0xCC, 0x03, 0xD6, 0x03, 0xDD, 0x03, 0xDE, 0x03,
   0xDB, 0x03, 0xD9, 0x03, 0xCD, 0x03, 0xC5, 0x03, 0xB2, 0x03, 0xA1, 0x03,
   0x89, 0x03, 0x73, 0x03, 0x53, 0x03, 0x34, 0x03, 0x10, 0x03, 0xE8, 0x02,
   0xBE, 0x02, 0x92, 0x02, 0x5E, 0x02, 0x31, 0x02, 0xF6, 0x01, 0xC1, 0x01,
   0x87, 0x01, 0x4B, 0x01, 0x0E, 0x01, 0xD0, 0x00, 0x92, 0x00, 0x51, 0x00,
   0x16, 0x00, 0xCF, 0xFF, 0x99, 0xFF, 0x57, 0xFF, 0x1D, 0xFF, 0xE2, 0xFE,
   0xA7, 0xFE, 0x71, 0xFE, 0x38, 0xFE, 0x06, 0xFE, 0xD1, 0xFD, 0xA0, 0xFD,
   0x75, 0xFD, 0x44, 0xFD, 0x25, 0xFD, 0xF7, 0xFC, 0xD8, 0xFC, 0xBB, 0xFC,
   0x99, 0xFC, 0x88, 0xFC, 0x6E, 0xFC, 0x60, 0xFC, 0x50, 0xFC, 0x4A, 0xFC,
   0x3E, 0xFC, 0x44, 0xFC, 0x3E, 0xFC, 0x48, 0xFC, 0x50, 0xFC, 0x5A, 0xFC,
   0x70, 0xFC, 0x7D, 0xFC, 0x9C, 0xFC, 0xB0, 0xFC, 0xD3, 0xFC, 0xF1, 0xFC,
   0x19, 0xFD, 0x3A, 0xFD, 0x6A, 0xFD, 0x91, 0xFD, 0xC5, 0xFD, 0xF1, 0xFD,
   0x28, 0xFE, 0x5A, 0xFE, 0x8F, 0xFE, 0xC9, 0xFE, 0xFF, 0xFE, 0x3B, 0xFF,
   0x74, 0xFF, 0xAE, 0xFF, 0xEB, 0xFF, 0x23, 0x00, 0x61, 0x00, 0x95, 0x00,
   0xD4, 0x00, 0x08, 0x01, 0x42, 0x01, 0x76, 0x01, 0xAC, 0x01, 0xDE, 0x01,
   0x0D, 0x02, 0x3B, 0x02, 0x69, 0x02, 0x90, 0x02, 0xBA, 0x02, 0xDB, 0x02,
   0xFD, 0x02, 0x1C, 0x03, 0x33, 0x03, 0x51, 0x03, 0x5D, 0x03, 0x76, 0x03,
   0x7C, 0x03, 0x8B, 0x03, 0x8D, 0x03, 0x93, 0x03, 0x8F, 0x03, 0x8D, 0x03,
   0x81, 0x03, 0x79, 0x03, 0x68, 0x03, 0x55, 0x03, 0x40, 0x03, 0x26, 0x03,
   0x0B, 0x03, 0xEB, 0x02, 0xC8, 0x02, 0xA5, 0x02, 0x7B, 0x02, 0x53, 0x02,
   0x27, 0x02, 0xF9, 0x01, 0xC8, 0x01, 0x97, 0x01, 0x63, 0x01, 0x2D, 0x01,
   0xFB, 0x00, 0xC2, 0x00, 0x8D, 0x00, 0x52, 0x00, 0x1E, 0x00, 0xE2, 0xFF,
   0xAF, 0xFF, 0x72, 0xFF, 0x43, 0xFF, 0x06, 0xFF, 0xD8, 0xFE, 0xA0, 0xFE,
   0x71, 0xFE, 0x3E, 0xFE, 0x11, 0xFE, 0xE5, 0xFD, 0xBA, 0xFD, 0x95, 0xFD,
   0x6D, 0xFD, 0x4D, 0xFD, 0x2B, 0xFD, 0x10, 0xFD, 0xF3, 0xFC, 0xE0, 0xFC,
   0xCC, 0xFC, 0xBA, 0xFC, 0xAF, 0xFC, 0xA4, 0xFC, 0x9F, 0xFC, 0x9B, 0xFC,
   0x9C, 0xFC, 0xA1, 0xFC, 0xA8, 0xFC, 0xB2, 0xFC, 0xC2, 0xFC, 0xD0, 0xFC,
   0xE9, 0xFC, 0xFD, 0xFC, 0x18, 0xFD, 0x37, 0xFD, 0x55, 0xFD, 0x7A, 0xFD,
   0x9E, 0xFD, 0xC5, 0xFD, 0xF2, 0xFD, 0x19, 0xFE, 0x4D, 0xFE, 0x73, 0xFE,
   0xAC, 0xFE, 0xD8, 0xFE, 0x0E, 0xFF, 0x42, 0xFF, 0x75, 0xFF, 0xAC, 0xFF,
   0xDD, 0xFF, 0x15, 0x00, 0x49, 0x00, 0x7E, 0x00, 0xB1, 0x00, 0xE7, 0x00,
   0x15, 0x01, 0x49, 0x01, 0x75, 0x01, 0xA7, 0x01, 0xD0, 0x01, 0xFE, 0x01,
   0x22, 0x02, 0x4C, 0x02, 0x6B, 0x02, 0x90, 0x02, 0xAD, 0x02, 0xC8, 0x02,
   0xE3, 0x02, 0xF7, 0x02, 0x0B, 0x03, 0x1A, 0x03, 0x27, 0x03, 0x31, 0x03,
   0x36, 0x03, 0x3A, 0x03, 0x39, 0x03, 0x36, 0x03, 0x2F, 0x03, 0x25, 0x03,
   0x18, 0x03, 0x09, 0x03, 0xF3, 0x02, 0xE1, 0x02, 0xC4, 0x02, 0xAB, 0x02,
   0x8B, 0x02, 0x6C, 0x02, 0x48, 0x02, 0x23, 0x02, 0xFB, 0x01, 0xD2, 0x01,
   0xA6, 0x01, 0x7A, 0x01, 0x4B, 0x01, 0x1C, 0x01, 0xEE, 0x00, 0xBA, 0x00,
   0x8B, 0x00, 0x55, 0x00, 0x26, 0x00, 0xF1, 0xFF, 0xC0, 0xFF, 0x8F, 0xFF,
   0x5B, 0xFF, 0x2E, 0xFF, 0xFB, 0xFE, 0xCE, 0xFE, 0x9F, 0xFE, 0x74, 0xFE,
   0x4B, 0xFE, 0x21, 0xFE, 0xFC, 0xFD, 0xD7, 0xFD, 0xB4, 0xFD, 0x96, 0xFD,
   0x75, 0xFD, 0x5F, 0xFD, 0x45, 0xFD, 0x2F, 0xFD, 0x20, 0xFD, 0x0C, 0xFD,
   0x03, 0xFD, 0xF7, 0xFC, 0xF5, 0xFC, 0xEB, 0xFC, 0xF3, 0xFC, 0xEF, 0xFC,
   0xFA, 0xFC, 0x01, 0xFD, 0x0C, 0xFD, 0x1E, 0xFD, 0x2D, 0xFD, 0x43, 0xFD,
   0x5A, 0xFD, 0x74, 0xFD, 0x92, 0xFD, 0xAE, 0xFD, 0xD3, 0xFD, 0xF2, 0xFD,
   0x1B, 0xFE, 0x3F, 0xFE, 0x6B, 0xFE, 0x92, 0xFE, 0xC0, 0xFE, 0xED, 0xFE,
   0x19, 0xFF, 0x49, 0xFF, 0x77, 0xFF, 0xA8, 0xFF, 0xD7, 0xFF, 0x08, 0x00,
   0x37, 0x00, 0x68, 0x00, 0x96, 0x00, 0xC7, 0x00, 0xEE, 0x00, 0x23, 0x01,
   0x45, 0x01, 0x77, 0x01, 0x9B, 0x01, 0xC3, 0x01, 0xE9, 0x01, 0x08, 0x02,
   0x2C, 0x02, 0x49, 0x02, 0x65, 0x02, 0x80, 0x02, 0x96, 0x02, 0xAB, 0x02,
   0xBC, 0x02, 0xCB, 0x02, 0xD6, 0x02, 0xE3, 0x02, 0xE4, 0x02, 0xED, 0x02,
   0xE9, 0x02, 0xE7, 0x02, 0xE6, 0x02, 0xD7, 0x02, 0xD2, 0x02, 0xBF, 0x02,
   0xB1, 0x02, 0x9E, 0x02, 0x85, 0x02, 0x70, 0x02, 0x53, 0x02, 0x37, 0x02,
   0x19, 0x02, 0xF3, 0x01, 0xD5, 0x01, 0xAC, 0x01, 0x87, 0x01, 0x61, 0x01,
   0x34, 0x01, 0x0E, 0x01, 0xDD, 0x00, 0xB6, 0x00, 0x83, 0x00, 0x5B, 0x00,
   0x2D, 0x00, 0xFC, 0xFF, 0xD4, 0xFF, 0xA0, 0xFF, 0x78, 0xFF, 0x49, 0xFF,
   0x1E, 0xFF, 0xF8, 0xFE, 0xC7, 0xFE, 0xA7, 0xFE, 0x7A, 0xFE, 0x59, 0xFE,
   0x34, 0xFE, 0x12, 0xFE, 0xF4, 0xFD, 0xD6, 0xFD, 0xBC, 0xFD, 0xA3, 0xFD,
   0x8D, 0xFD, 0x78, 0xFD, 0x69, 0xFD, 0x58, 0xFD, 0x4F, 0xFD, 0x43, 0xFD,
   0x40, 0xFD, 0x39, 0xFD, 0x3C, 0xFD, 0x3A, 0xFD, 0x43, 0xFD, 0x47, 0xFD,
   0x54, 0xFD, 0x5E, 0xFD, 0x72, 0xFD, 0x7E, 0xFD, 0x9A, 0xFD, 0xAA, 0xFD,
   0xC8, 0xFD, 0xE3, 0xFD, 0xFE, 0xFD, 0x20, 0xFE, 0x3F, 0xFE, 0x64, 0xFE,
   0x88, 0xFE, 0xAD, 0xFE, 0xD7, 0xFE, 0xFC, 0xFE, 0x27, 0xFF, 0x51, 0xFF,
   0x7A, 0xFF, 0xA7, 0xFF, 0xD1, 0xFF, 0xFE, 0xFF, 0x29, 0x00, 0x53, 0x00,
   0x7C, 0x00, 0xAA, 0x00, 0xD0, 0x00, 0xFB, 0x00, 0x23, 0x01, 0x45, 0x01,
   0x6F, 0x01, 0x8C, 0x01, 0xB4, 0x01, 0xCF, 0x01, 0xF1, 0x01, 0x0B, 0x02,
   0x25, 0x02, 0x3E, 0x02, 0x52, 0x02, 0x64, 0x02, 0x78, 0x02, 0x82, 0x02,
   0x91, 0x02, 0x97, 0x02, 0xA0, 0x02, 0xA0, 0x02, 0xA7, 0x02, 0x9E, 0x02,
   0x9F, 0x02, 0x96, 0x02, 0x8C, 0x02, 0x82, 0x02, 0x71, 0x02, 0x62, 0x02,
   0x4D, 0x02, 0x3A, 0x02, 0x1F, 0x02, 0x07, 0x02, 0xEB, 0x01, 0xCB, 0x01,
   0xB2, 0x01, 0x88, 0x01, 0x6D, 0x01, 0x45, 0x01, 0x20, 0x01, 0xFC, 0x00,
   0xD1, 0x00, 0xAC, 0x00, 0x82, 0x00, 0x5B, 0x00, 0x31, 0x00, 0x08, 0x00,
   0xDD, 0xFF, 0xB6, 0xFF, 0x8B, 0xFF, 0x65, 0xFF, 0x40, 0xFF, 0x13, 0xFF,
   0xF4, 0xFE, 0xCA, 0xFE, 0xAC, 0xFE, 0x85, 0xFE, 0x69, 0xFE, 0x48, 0xFE,
   0x2E, 0xFE, 0x11, 0xFE, 0xF8, 0xFD, 0xE1, 0xFD, 0xCF, 0xFD, 0xB8, 0xFD,
   0xAF, 0xFD, 0x99, 0xFD, 0x95, 0xFD, 0x88, 0xFD, 0x83, 0xFD, 0x7F, 0xFD,
   0x7E, 0xFD, 0x80, 0xFD, 0x82, 0xFD, 0x8A, 0xFD, 0x92, 0xFD, 0x9C, 0xFD,
   0xAE, 0xFD, 0xB7, 0xFD, 0xD0, 0xFD, 0xE0, 0xFD, 0xF7, 0xFD, 0x11, 0xFE,
   0x29, 0xFE, 0x47, 0xFE, 0x65, 0xFE, 0x82, 0xFE, 0xA6, 0xFE, 0xC4, 0xFE,
   0xEB, 0xFE, 0x0D, 0xFF, 0x33, 0xFF, 0x58, 0xFF, 0x80, 0xFF, 0xA6, 0xFF,
   0xCC, 0xFF, 0xF5, 0xFF, 0x1B, 0x00, 0x41, 0x00, 0x6C, 0x00, 0x8D, 0x00,
   0xB7, 0x00, 0xDA, 0x00, 0xFD, 0x00, 0x20, 0x01, 0x43, 0x01, 0x61, 0x01,
   0x82, 0x01, 0x9D, 0x01, 0xBB, 0x01, 0xD4, 0x01, 0xEA, 0x01, 0x02, 0x02,
   0x13, 0x02, 0x2B, 0x02, 0x31, 0x02, 0x49, 0x02, 0x49, 0x02, 0x5C, 0x02,
   0x59, 0x02, 0x65, 0x02, 0x60, 0x02, 0x63, 0x02, 0x5D, 0x02, 0x59, 0x02,
   0x51, 0x02, 0x45, 0x02, 0x3B, 0x02, 0x28, 0x02, 0x1C, 0x02, 0x05, 0x02,
   0xF2, 0x01, 0xD9, 0x01, 0xC2, 0x01, 0xA8, 0x01, 0x89, 0x01, 0x71, 0x01,
   0x4B, 0x01, 0x30, 0x01, 0x0B, 0x01, 0xEB, 0x00, 0xC7, 0x00, 0xA5, 0x00,
   0x7D, 0x00, 0x5B, 0x00, 0x35, 0x00, 0x0E, 0x00, 0xEB, 0xFF, 0xC4, 0xFF,
   0xA2, 0xFF, 0x7A, 0xFF, 0x5A, 0xFF, 0x33, 0xFF, 0x14, 0xFF, 0xEF, 0xFE,
   0xD3, 0xFE, 0xB0, 0xFE, 0x98, 0xFE, 0x77, 0xFE, 0x60, 0xFE, 0x46, 0xFE,
   0x2E, 0xFE, 0x1B, 0xFE, 0x06, 0xFE, 0xF7, 0xFD, 0xE7, 0xFD, 0xDB, 0xFD,
   0xCE, 0xFD, 0xC9, 0xFD, 0xBF, 0xFD, 0xBF, 0xFD, 0xBB, 0xFD, 0xBC, 0xFD,
   0xBF, 0xFD, 0xC4, 0xFD, 0xCC, 0xFD, 0xD5, 0xFD, 0xE2, 0xFD, 0xEE, 0xFD,
   0xFE, 0xFD, 0x12, 0xFE, 0x23, 0xFE, 0x3D, 0xFE, 0x4F, 0xFE, 0x6D, 0xFE,
   0x84, 0xFE, 0xA3, 0xFE, 0xBE, 0xFE, 0xDC, 0xFE, 0xFE, 0xFE, 0x1D, 0xFF,
   0x40, 0xFF, 0x60, 0xFF, 0x85, 0xFF, 0xA4, 0xFF, 0xCC, 0xFF, 0xEC, 0xFF,
   0x12, 0x00, 0x33, 0x00, 0x59, 0x00, 0x79, 0x00, 0x9C, 0x00, 0xBE, 0x00,
   0xDC, 0x00, 0x00, 0x01, 0x1B, 0x01, 0x3B, 0x01, 0x55, 0x01, 0x72, 0x01,
   0x87, 0x01, 0xA5, 0x01, 0xB4, 0x01, 0xCF, 0x01, 0xDC, 0x01, 0xF0, 0x01,
   0xFD, 0x01, 0x08, 0x02, 0x17, 0x02, 0x17, 0x02, 0x28, 0x02, 0x22, 0x02,
   0x2A, 0x02, 0x27, 0x02, 0x24, 0x02, 0x22, 0x02, 0x19, 0x02, 0x10, 0x02,
   0x06, 0x02, 0xF9, 0x01, 0xE8, 0x01, 0xDB, 0x01, 0xC4, 0x01, 0xB4, 0x01,
   0x9A, 0x01, 0x85, 0x01, 0x6B, 0x01, 0x4F, 0x01, 0x38, 0x01, 0x14, 0x01,
   0xFE, 0x00, 0xD8, 0x00, 0xBE, 0x00, 0x99, 0x00, 0x7C, 0x00, 0x57, 0x00,
   0x37, 0x00, 0x16, 0x00, 0xF4, 0xFF, 0xD2, 0xFF, 0xB2, 0xFF, 0x8E, 0xFF,
   0x71, 0xFF, 0x4E, 0xFF, 0x30, 0xFF, 0x14, 0xFF, 0xF3, 0xFE, 0xDC, 0xFE,
   0xBA, 0xFE, 0xA8, 0xFE, 0x88, 0xFE, 0x78, 0xFE, 0x5F, 0xFE, 0x4E, 0xFE,
   0x3B, 0xFE, 0x2B, 0xFE, 0x1E, 0xFE, 0x10, 0xFE, 0x09, 0xFE, 0xFD, 0xFD,
   0xFC, 0xFD, 0xF3, 0xFD, 0xF3, 0xFD, 0xF6, 0xFD, 0xF2, 0xFD, 0xFE, 0xFD,
   0xFC, 0xFD, 0x0B, 0xFE, 0x11, 0xFE, 0x1F, 0xFE, 0x2E, 0xFE, 0x3A, 0xFE,
   0x51, 0xFE, 0x5E, 0xFE, 0x79, 0xFE, 0x8A, 0xFE, 0xA6, 0xFE, 0xBC, 0xFE,
   0xD7, 0xFE, 0xF3, 0xFE, 0x10, 0xFF, 0x2C, 0xFF, 0x4A, 0xFF, 0x69, 0xFF,
   0x87, 0xFF, 0xA9, 0xFF, 0xC8, 0xFF, 0xE8, 0xFF, 0x08, 0x00, 0x27, 0x00,
   0x4A, 0x00, 0x65, 0x00, 0x88, 0x00, 0xA3, 0x00, 0xC3, 0x00, 0xDF, 0x00,
   0xFB, 0x00, 0x17, 0x01, 0x2D, 0x01, 0x4B, 0x01, 0x5C, 0x01, 0x78, 0x01,
   0x87, 0x01, 0x9C, 0x01, 0xAE, 0x01, 0xBB, 0x01, 0xCA, 0x01, 0xD5, 0x01,
   0xDE, 0x01, 0xE8, 0x01, 0xED, 0x01, 0xF0, 0x01, 0xF4, 0x01, 0xF2, 0x01,
   0xF2, 0x01, 0xEC, 0x01, 0xEA, 0x01, 0xDE, 0x01, 0xD8, 0x01, 0xCA, 0x01,
   0xBE, 0x01, 0xAF, 0x01, 0xA0, 0x01, 0x8C, 0x01, 0x79, 0x01, 0x64, 0x01,
   0x4D, 0x01, 0x36, 0x01, 0x1C, 0x01, 0x06, 0x01, 0xE5, 0x00, 0xD0, 0x00,
   0xAD, 0x00, 0x94, 0x00, 0x74, 0x00, 0x59, 0x00, 0x39, 0x00, 0x19, 0x00,
   0xFF, 0xFF, 0xD9, 0xFF, 0xC4, 0xFF, 0x9C, 0xFF, 0x89, 0xFF, 0x64, 0xFF,
   0x4B, 0xFF, 0x31, 0xFF, 0x12, 0xFF, 0xFC, 0xFE, 0xE2, 0xFE, 0xC9, 0xFE,
   0xB5, 0xFE, 0xA1, 0xFE, 0x8B, 0xFE, 0x7C, 0xFE, 0x68, 0xFE, 0x5D, 0xFE,
   0x4C, 0xFE, 0x47, 0xFE, 0x35, 0xFE, 0x36, 0xFE, 0x29, 0xFE, 0x29, 0xFE,
   0x26, 0xFE, 0x25, 0xFE, 0x27, 0xFE, 0x2A, 0xFE, 0x31, 0xFE, 0x34, 0xFE,
   0x42, 0xFE, 0x49, 0xFE, 0x56, 0xFE, 0x66, 0xFE, 0x72, 0xFE, 0x85, 0xFE,
   0x97, 0xFE, 0xAC, 0xFE, 0xC0, 0xFE, 0xD7, 0xFE, 0xEE, 0xFE, 0x07, 0xFF,
   0x21, 0xFF, 0x3A, 0xFF, 0x56, 0xFF, 0x6F, 0xFF, 0x90, 0xFF, 0xA7, 0xFF,
   0xCB, 0xFF, 0xE0, 0xFF, 0x03, 0x00, 0x1B, 0x00, 0x3B, 0x00, 0x59, 0x00,
   0x70, 0x00, 0x92, 0x00, 0xA7, 0x00, 0xC4, 0x00, 0xDF, 0x00, 0xF3, 0x00,
   0x0F, 0x01, 0x23, 0x01, 0x38, 0x01, 0x4F, 0x01, 0x5D, 0x01, 0x73, 0x01,
   0x7E, 0x01, 0x90, 0x01, 0x9A, 0x01, 0xA5, 0x01, 0xB2, 0x01, 0xB4, 0x01,
   0xBF, 0x01, 0xC0, 0x01, 0xC2, 0x01, 0xC4, 0x01, 0xC1, 0x01, 0xC0, 0x01,
   0xBA, 0x01, 0xB4, 0x01, 0xAC, 0x01, 0xA0, 0x01, 0x99, 0x01, 0x86, 0x01,
   0x7D, 0x01, 0x69, 0x01, 0x58, 0x01, 0x4A, 0x01, 0x2E, 0x01, 0x21, 0x01,
   0x04, 0x01, 0xF2, 0x00, 0xD6, 0x00, 0xBE, 0x00, 0xA5, 0x00, 0x8B, 0x00,
   0x70, 0x00, 0x57, 0x00, 0x37, 0x00, 0x20, 0x00, 0x01, 0x00, 0xE8, 0xFF,
   0xCA, 0xFF, 0xB3, 0xFF, 0x94, 0xFF, 0x7D, 0xFF, 0x60, 0xFF, 0x4A, 0xFF,
   0x2F, 0xFF, 0x19, 0xFF, 0x04, 0xFF, 0xEB, 0xFE, 0xDC, 0xFE, 0xC3, 0xFE,
   0xB4, 0xFE, 0xA4, 0xFE, 0x93, 0xFE, 0x89, 0xFE, 0x78, 0xFE, 0x71, 0xFE,
   0x67, 0xFE, 0x5F, 0xFE, 0x5B, 0xFE, 0x55, 0xFE, 0x53, 0xFE, 0x54, 0xFE,
   0x52, 0xFE, 0x58, 0xFE, 0x5B, 0xFE, 0x60, 0xFE, 0x69, 0xFE, 0x72, 0xFE,
   0x7B, 0xFE, 0x8B, 0xFE, 0x94, 0xFE, 0xA8, 0xFE, 0xB4, 0xFE, 0xC9, 0xFE,
   0xD9, 0xFE, 0xF1, 0xFE, 0x01, 0xFF, 0x1C, 0xFF, 0x2D, 0xFF, 0x4B, 0xFF,
   0x5E, 0xFF, 0x7C, 0xFF, 0x90, 0xFF, 0xAC, 0xFF, 0xC8, 0xFF, 0xDD, 0xFF,
   0xFF, 0xFF, 0x10, 0x00, 0x32, 0x00, 0x48, 0x00, 0x63, 0x00, 0x7B, 0x00,
   0x94, 0x00, 0xAA, 0x00, 0xC6, 0x00, 0xD6, 0x00, 0xF1, 0x00, 0x02, 0x01,
   0x18, 0x01, 0x28, 0x01, 0x3A, 0x01, 0x4B, 0x01, 0x56, 0x01, 0x68, 0x01,
   0x6F, 0x01, 0x7D, 0x01, 0x84, 0x01, 0x8B, 0x01, 0x90, 0x01, 0x96, 0x01,
   0x96, 0x01, 0x9A, 0x01, 0x96, 0x01, 0x95, 0x01, 0x91, 0x01, 0x8B, 0x01,
   0x86, 0x01, 0x7B, 0x01, 0x71, 0x01, 0x67, 0x01, 0x59, 0x01, 0x4B, 0x01,
   0x3C, 0x01, 0x2A, 0x01, 0x1A, 0x01, 0x07, 0x01, 0xF2, 0x00, 0xDB, 0x00,
   0xCB, 0x00, 0xAF, 0x00, 0x9D, 0x00, 0x82, 0x00, 0x6A, 0x00, 0x55, 0x00,
   0x36, 0x00, 0x24, 0x00, 0x07, 0x00, 0xEF, 0xFF, 0xD7, 0xFF, 0xBE, 0xFF,
   0xA3, 0xFF, 0x90, 0xFF, 0x75, 0xFF, 0x5F, 0xFF, 0x4B, 0xFF, 0x32, 0xFF,
   0x20, 0xFF, 0x0D, 0xFF, 0xF7, 0xFE, 0xE9, 0xFE, 0xD5, 0xFE, 0xC9, 0xFE,
   0xBB, 0xFE, 0xAB, 0xFE, 0xA6, 0xFE, 0x93, 0xFE, 0x95, 0xFE, 0x85, 0xFE,
   0x85, 0xFE, 0x7F, 0xFE, 0x7D, 0xFE, 0x7B, 0xFE, 0x7E, 0xFE, 0x7D, 0xFE,
   0x83, 0xFE, 0x88, 0xFE, 0x8C, 0xFE, 0x97, 0xFE, 0x9F, 0xFE, 0xA9, 0xFE,
   0xB8, 0xFE, 0xC2, 0xFE, 0xD3, 0xFE, 0xE2, 0xFE, 0xF2, 0xFE, 0x06, 0xFF,
   0x15, 0xFF, 0x2E, 0xFF, 0x3C, 0xFF, 0x59, 0xFF, 0x66, 0xFF, 0x86, 0xFF,
   0x93, 0xFF, 0xB2, 0xFF, 0xC4, 0xFF, 0xE0, 0xFF, 0xF4, 0xFF, 0x10, 0x00,
   0x22, 0x00, 0x3F, 0x00, 0x52, 0x00, 0x6B, 0x00, 0x81, 0x00, 0x95, 0x00,
   0xAD, 0x00, 0xC0, 0x00, 0xD2, 0x00, 0xE8, 0x00, 0xF6, 0x00, 0x09, 0x01,
   0x1A, 0x01, 0x25, 0x01, 0x36, 0x01, 0x41, 0x01, 0x4B, 0x01, 0x55, 0x01,
   0x5D, 0x01, 0x64, 0x01, 0x6A, 0x01, 0x6E, 0x01, 0x6F, 0x01, 0x71, 0x01,
   0x71, 0x01, 0x6E, 0x01, 0x6C, 0x01, 0x68, 0x01, 0x5F, 0x01, 0x5A, 0x01,
   0x50, 0x01, 0x47, 0x01, 0x3B, 0x01, 0x2F, 0x01, 0x20, 0x01, 0x12, 0x01,
   0x02, 0x01, 0xF1, 0x00, 0xDF, 0x00, 0xCE, 0x00, 0xB9, 0x00, 0xA5, 0x00,
   0x91, 0x00, 0x7A, 0x00, 0x67, 0x00, 0x4F, 0x00, 0x39, 0x00, 0x23, 0x00,
   0x0D, 0x00, 0xF4, 0xFF, 0xE3, 0xFF, 0xC4, 0xFF, 0xB7, 0xFF, 0x9A, 0xFF,
   0x8A, 0xFF, 0x73, 0xFF, 0x5F, 0xFF, 0x4C, 0xFF, 0x38, 0xFF, 0x28, 0xFF,
   0x15, 0xFF, 0x06, 0xFF, 0xF8, 0xFE, 0xE7, 0xFE, 0xDE, 0xFE, 0xCF, 0xFE,
   0xC6, 0xFE, 0xBD, 0xFE, 0xB4, 0xFE, 0xAF, 0xFE, 0xA8, 0xFE, 0xA6, 0xFE,
   0xA1, 0xFE, 0xA3, 0xFE, 0x9F, 0xFE, 0xA6, 0xFE, 0xA2, 0xFE, 0xAE, 0xFE,
   0xAE, 0xFE, 0xB7, 0xFE, 0xC0, 0xFE, 0xC7, 0xFE, 0xD4, 0xFE, 0xE0, 0xFE,
   0xEA, 0xFE, 0xFB, 0xFE, 0x08, 0xFF, 0x1B, 0xFF, 0x28, 0xFF, 0x3C, 0xFF,
   0x4D, 0xFF, 0x61, 0xFF, 0x74, 0xFF, 0x89, 0xFF, 0x9C, 0xFF, 0xB2, 0xFF,
   0xC8, 0xFF, 0xDB, 0xFF, 0xF2, 0xFF, 0x08, 0x00, 0x1C, 0x00, 0x32, 0x00,
   0x46, 0x00, 0x5C, 0x00, 0x70, 0x00, 0x85, 0x00, 0x96, 0x00, 0xA9, 0x00,
   0xBC, 0x00, 0xCA, 0x00, 0xE1, 0x00, 0xE8, 0x00, 0xFE, 0x00, 0x06, 0x01,
   0x15, 0x01, 0x1F, 0x01, 0x2A, 0x01, 0x33, 0x01, 0x3A, 0x01, 0x41, 0x01,
   0x44, 0x01, 0x4D, 0x01, 0x49, 0x01, 0x51, 0x01, 0x4A, 0x01, 0x4E, 0x01,
   0x49, 0x01, 0x46, 0x01, 0x41, 0x01, 0x38, 0x01, 0x34, 0x01, 0x27, 0x01,
   0x22, 0x01, 0x12, 0x01, 0x0A, 0x01, 0xF8, 0x00, 0xEF, 0x00, 0xDC, 0x00,
   0xCE, 0x00, 0xBF, 0x00, 0xA8, 0x00, 0x9D, 0x00, 0x84, 0x00, 0x75, 0x00,
   0x61, 0x00, 0x4D, 0x00, 0x37, 0x00, 0x26, 0x00, 0x0E, 0x00, 0xFC, 0xFF,
   0xE7, 0xFF, 0xD3, 0xFF, 0xBF, 0xFF, 0xAC, 0xFF, 0x97, 0xFF, 0x85, 0xFF,
   0x73, 0xFF, 0x61, 0xFF, 0x4E, 0xFF, 0x43, 0xFF, 0x2B, 0xFF, 0x26, 0xFF,
   0x0F, 0xFF, 0x0A, 0xFF, 0xF8, 0xFE, 0xF1, 0xFE, 0xE5, 0xFE, 0xDD, 0xFE,
   0xD7, 0xFE, 0xCF, 0xFE, 0xCC, 0xFE, 0xC5, 0xFE, 0xC5, 0xFE, 0xC3, 0xFE,
   0xC2, 0xFE, 0xC5, 0xFE, 0xC6, 0xFE, 0xC9, 0xFE, 0xD1, 0xFE, 0xD3, 0xFE,
   0xDC, 0xFE, 0xE5, 0xFE, 0xEC, 0xFE, 0xFB, 0xFE, 0x01, 0xFF, 0x12, 0xFF,
   0x1B, 0xFF, 0x2E, 0xFF, 0x3A, 0xFF, 0x4C, 0xFF, 0x58, 0xFF, 0x6E, 0xFF,
   0x7C, 0xFF, 0x92, 0xFF, 0xA0, 0xFF, 0xB8, 0xFF, 0xC5, 0xFF, 0xDE, 0xFF,
   0xED, 0xFF, 0x02, 0x00, 0x17, 0x00, 0x28, 0x00, 0x3D, 0x00, 0x4E, 0x00,
   0x5F, 0x00, 0x76, 0x00, 0x80, 0x00, 0x9C, 0x00, 0x9E, 0x00, 0xBD, 0x00,
   0xBE, 0x00, 0xD6, 0x00, 0xDF, 0x00, 0xEB, 0x00, 0xF9, 0x00, 0x00, 0x01,
   0x0C, 0x01, 0x14, 0x01, 0x1A, 0x01, 0x22, 0x01, 0x25, 0x01, 0x29, 0x01,
   0x2D, 0x01, 0x2C, 0x01, 0x30, 0x01, 0x2A, 0x01, 0x2D, 0x01, 0x25, 0x01,
   0x25, 0x01, 0x1C, 0x01, 0x17, 0x01, 0x0F, 0x01, 0x04, 0x01, 0xFF, 0x00,
   0xEE, 0x00, 0xE9, 0x00, 0xD7, 0x00, 0xCD, 0x00, 0xBC, 0x00, 0xAE, 0x00,
   0xA0, 0x00, 0x8E, 0x00, 0x7F, 0x00, 0x6C, 0x00, 0x5B, 0x00, 0x4A, 0x00,
   0x37, 0x00, 0x25, 0x00, 0x12, 0x00, 0x00, 0x00, 0xED, 0xFF, 0xDD, 0xFF,
   0xC8, 0xFF, 0xB9, 0xFF, 0xA3, 0xFF, 0x97, 0xFF, 0x81, 0xFF, 0x77, 0xFF,
   0x62, 0xFF, 0x57, 0xFF, 0x45, 0xFF, 0x3B, 0xFF, 0x2B, 0xFF, 0x22, 0xFF,
   0x17, 0xFF, 0x0A, 0xFF, 0x05, 0xFF, 0xF8, 0xFE, 0xF8, 0xFE, 0xEB, 0xFE,
   0xEB, 0xFE, 0xE4, 0xFE, 0xE3, 0xFE, 0xE3, 0xFE, 0xDF, 0xFE, 0xE5, 0xFE,
   0xE0, 0xFE, 0xEA, 0xFE, 0xE8, 0xFE, 0xF3, 0xFE, 0xF4, 0xFE, 0x00, 0xFF,
   0x03, 0xFF, 0x11, 0xFF, 0x1A, 0xFF, 0x22, 0xFF, 0x34, 0xFF, 0x38, 0xFF,
   0x4F, 0xFF, 0x56, 0xFF, 0x68, 0xFF, 0x77, 0xFF, 0x85, 0xFF, 0x99, 0xFF,
   0xA5, 0xFF, 0xBA, 0xFF, 0xC9, 0xFF, 0xDA, 0xFF, 0xED, 0xFF, 0xFE, 0xFF,
   0x0F, 0x00, 0x22, 0x00, 0x33, 0x00, 0x40, 0x00, 0x58, 0x00, 0x60, 0x00,
   0x77, 0x00, 0x83, 0x00, 0x92, 0x00, 0xA2, 0x00, 0xAD, 0x00, 0xBD, 0x00,
   0xC6, 0x00, 0xD4, 0x00, 0xDD, 0x00, 0xE7, 0x00, 0xF0, 0x00, 0xF7, 0x00,
   0xFF, 0x00, 0x03, 0x01, 0x0A, 0x01, 0x0A, 0x01, 0x11, 0x01, 0x0F, 0x01,
   0x12, 0x01, 0x10, 0x01, 0x0D, 0x01, 0x0E, 0x01, 0x06, 0x01, 0x05, 0x01,
   0xFC, 0x00, 0xF7, 0x00, 0xEF, 0x00, 0xE5, 0x00, 0xDD, 0x00, 0xD3, 0x00,
   0xC5, 0x00, 0xBD, 0x00, 0xAC, 0x00, 0xA1, 0x00, 0x94, 0x00, 0x83, 0x00,
   0x77, 0x00, 0x65, 0x00, 0x56, 0x00, 0x46, 0x00, 0x35, 0x00, 0x27, 0x00,
   0x13, 0x00, 0x05, 0x00, 0xF2, 0xFF, 0xE3, 0xFF, 0xD3, 0xFF, 0xC0, 0xFF,
   0xB4, 0xFF, 0xA1, 0xFF, 0x94, 0xFF, 0x85, 0xFF, 0x75, 0xFF, 0x6A, 0xFF,
   0x5A, 0xFF, 0x50, 0xFF, 0x43, 0xFF, 0x39, 0xFF, 0x2E, 0xFF, 0x27, 0xFF,
   0x1B, 0xFF, 0x17, 0xFF, 0x0D, 0xFF, 0x0B, 0xFF, 0x04, 0xFF, 0x02, 0xFF,
   0xFE, 0xFE, 0xFD, 0xFE, 0xFD, 0xFE, 0xFD, 0xFE, 0xFD, 0xFE, 0x03, 0xFF,
   0x03, 0xFF, 0x0A, 0xFF, 0x0E, 0xFF, 0x14, 0xFF, 0x1D, 0xFF, 0x24, 0xFF,
   0x2D, 0xFF, 0x38, 0xFF, 0x40, 0xFF, 0x4F, 0xFF, 0x57, 0xFF, 0x67, 0xFF,
   0x73, 0xFF, 0x7F, 0xFF, 0x92, 0xFF, 0x99, 0xFF, 0xB1, 0xFF, 0xB8, 0xFF,
   0xCE, 0xFF, 0xD9, 0xFF, 0xEC, 0xFF, 0xFA, 0xFF, 0x0B, 0x00, 0x1A, 0x00,
   0x29, 0x00, 0x3B, 0x00, 0x46, 0x00, 0x5A, 0x00, 0x64, 0x00, 0x74, 0x00,
   0x83, 0x00, 0x8C, 0x00, 0x9D, 0x00, 0xA6, 0x00, 0xB2, 0x00, 0xBD, 0x00,
   0xC6, 0x00, 0xD0, 0x00, 0xD5, 0x00, 0xE1, 0x00, 0xE2, 0x00, 0xEB, 0x00,
   0xEF, 0x00, 0xF1, 0x00, 0xF4, 0x00, 0xF9, 0x00, 0xF2, 0x00, 0xFB, 0x00,
   0xF1, 0x00, 0xF6, 0x00, 0xEC, 0x00, 0xEF, 0x00, 0xE3, 0x00, 0xE3, 0x00,
   0xD8, 0x00, 0xD2, 0x00, 0xCB, 0x00, 0xBE, 0x00, 0xB7, 0x00, 0xAB, 0x00,
   0xA1, 0x00, 0x95, 0x00, 0x86, 0x00, 0x7B, 0x00, 0x6E, 0x00, 0x5E, 0x00,
   0x54, 0x00, 0x3D, 0x00, 0x39, 0x00, 0x21, 0x00, 0x1A, 0x00, 0x04, 0x00,
   0xF9, 0xFF, 0xE8, 0xFF, 0xD9, 0xFF, 0xCD, 0xFF, 0xBC, 0xFF, 0xAF, 0xFF,
   0xA0, 0xFF, 0x94, 0xFF, 0x85, 0xFF, 0x7B, 0xFF, 0x6E, 0xFF, 0x61, 0xFF,
   0x5A, 0xFF, 0x4D, 0xFF, 0x44, 0xFF, 0x3E, 0xFF, 0x32, 0xFF, 0x2F, 0xFF,
   0x27, 0xFF, 0x22, 0xFF, 0x1E, 0xFF, 0x1B, 0xFF, 0x16, 0xFF, 0x18, 0xFF,
   0x13, 0xFF, 0x18, 0xFF, 0x15, 0xFF, 0x1A, 0xFF, 0x1C, 0xFF, 0x1D, 0xFF,
   0x29, 0xFF, 0x25, 0xFF, 0x35, 0xFF, 0x35, 0xFF, 0x40, 0xFF, 0x49, 0xFF,
   0x50, 0xFF, 0x5E, 0xFF, 0x65, 0xFF, 0x73, 0xFF, 0x7D, 0xFF, 0x89, 0xFF,
   0x98, 0xFF, 0xA2, 0xFF, 0xB4, 0xFF, 0xBC, 0xFF, 0xD0, 0xFF, 0xD9, 0xFF,
   0xEA, 0xFF, 0xF8, 0xFF, 0x05, 0x00, 0x16, 0x00, 0x22, 0x00, 0x31, 0x00,
   0x3E, 0x00, 0x4D, 0x00, 0x57, 0x00, 0x69, 0x00, 0x6F, 0x00, 0x81, 0x00,
   0x89, 0x00, 0x93, 0x00, 0xA2, 0x00, 0xA5, 0x00, 0xB3, 0x00, 0xB9, 0x00,
   0xC1, 0x00, 0xC7, 0x00, 0xD0, 0x00, 0xCF, 0x00, 0xDA, 0x00, 0xD8, 0x00,
   0xDC, 0x00, 0xE1, 0x00, 0xDC, 0x00, 0xE2, 0x00, 0xDC, 0x00, 0xDC, 0x00,
   0xDA, 0x00, 0xD5, 0x00, 0xD3, 0x00, 0xCB, 0x00, 0xC6, 0x00, 0xC1, 0x00,
   0xB4, 0x00, 0xB5, 0x00, 0xA1, 0x00, 0xA3, 0x00, 0x8E, 0x00, 0x8D, 0x00,
   0x7A, 0x00, 0x73, 0x00, 0x66, 0x00, 0x57, 0x00, 0x4F, 0x00, 0x3E, 0x00,
   0x33, 0x00, 0x23, 0x00, 0x18, 0x00, 0x08, 0x00, 0xFD, 0xFF, 0xEF, 0xFF,
   0xDE, 0xFF, 0xD6, 0xFF, 0xC4, 0xFF, 0xBB, 0xFF, 0xAA, 0xFF, 0xA3, 0xFF,
   0x92, 0xFF, 0x8C, 0xFF, 0x7D, 0xFF, 0x74, 0xFF, 0x69, 0xFF, 0x63, 0xFF,
   0x56, 0xFF, 0x53, 0xFF, 0x48, 0xFF, 0x44, 0xFF, 0x3B, 0xFF, 0x3C, 0xFF,
   0x2F, 0xFF, 0x37, 0xFF, 0x2A, 0xFF, 0x2F, 0xFF, 0x2B, 0xFF, 0x2C, 0xFF,
   0x2E, 0xFF, 0x2C, 0xFF, 0x34, 0xFF, 0x32, 0xFF, 0x3A, 0xFF, 0x3D, 0xFF,
   0x41, 0xFF, 0x4C, 0xFF, 0x4D, 0xFF, 0x5C, 0xFF, 0x5D, 0xFF, 0x6C, 0xFF,
   0x72, 0xFF, 0x7D, 0xFF, 0x87, 0xFF, 0x94, 0xFF, 0x9D, 0xFF, 0xAA, 0xFF,
   0xB7, 0xFF, 0xC2, 0xFF, 0xCF, 0xFF, 0xDD, 0xFF, 0xE6, 0xFF, 0xF8, 0xFF,
   0x01, 0x00, 0x11, 0x00, 0x1C, 0x00, 0x29, 0x00, 0x36, 0x00, 0x41, 0x00,
   0x4F, 0x00, 0x58, 0x00, 0x67, 0x00, 0x6E, 0x00, 0x7C, 0x00, 0x82, 0x00,
   0x8F, 0x00, 0x96, 0x00, 0x9D, 0x00, 0xA9, 0x00, 0xAA, 0x00, 0xB5, 0x00,
   0xB8, 0x00, 0xBD, 0x00, 0xC3, 0x00, 0xC2, 0x00, 0xCA, 0x00, 0xC6, 0x00,
   0xCB, 0x00, 0xCA, 0x00, 0xC7, 0x00, 0xCB, 0x00, 0xC1, 0x00, 0xC5, 0x00,
   0xBD, 0x00, 0xBA, 0x00, 0xB5, 0x00, 0xAD, 0x00, 0xAA, 0x00, 0x9F, 0x00,
   0x9A, 0x00, 0x8F, 0x00, 0x88, 0x00, 0x7D, 0x00, 0x74, 0x00, 0x69, 0x00,
   0x5F, 0x00, 0x53, 0x00, 0x47, 0x00, 0x3D, 0x00, 0x2E, 0x00, 0x26, 0x00,
   0x15, 0x00, 0x0E, 0x00, 0xFC, 0xFF, 0xF6, 0xFF, 0xE3, 0xFF, 0xDD, 0xFF,
   0xCD, 0xFF, 0xC2, 0xFF, 0xB9, 0xFF, 0xA9, 0xFF, 0xA5, 0xFF, 0x95, 0xFF,
   0x8D, 0xFF, 0x84, 0xFF, 0x79, 0xFF, 0x73, 0xFF, 0x6B, 0xFF, 0x62, 0xFF,
   0x5C, 0xFF, 0x58, 0xFF, 0x4E, 0xFF, 0x4F, 0xFF, 0x47, 0xFF, 0x46, 0xFF,
   0x44, 0xFF, 0x3F, 0xFF, 0x43, 0xFF, 0x3D, 0xFF, 0x44, 0xFF, 0x40, 0xFF,
   0x46, 0xFF, 0x46, 0xFF, 0x4B, 0xFF, 0x4E, 0xFF, 0x55, 0xFF, 0x59, 0xFF,
   0x5F, 0xFF, 0x68, 0xFF, 0x6C, 0xFF, 0x78, 0xFF, 0x7C, 0xFF, 0x89, 0xFF,
   0x90, 0xFF, 0x9D, 0xFF, 0xA3, 0xFF, 0xB1, 0xFF, 0xB9, 0xFF, 0xC6, 0xFF,
   0xD3, 0xFF, 0xDA, 0xFF, 0xEB, 0xFF, 0xF2, 0xFF, 0x00, 0x00, 0x0D, 0x00,
   0x15, 0x00, 0x24, 0x00, 0x2D, 0x00, 0x3A, 0x00, 0x43, 0x00, 0x51, 0x00,
   0x56, 0x00, 0x65, 0x00, 0x6B, 0x00, 0x76, 0x00, 0x7E, 0x00, 0x86, 0x00,
   0x8E, 0x00, 0x95, 0x00, 0x9A, 0x00, 0xA1, 0x00, 0xA6, 0x00, 0xAA, 0x00,
   0xAF, 0x00, 0xB0, 0x00, 0xB4, 0x00, 0xB5, 0x00, 0xB7, 0x00, 0xB5, 0x00,
   0xB8, 0x00, 0xB2, 0x00, 0xB5, 0x00, 0xAF, 0x00, 0xAE, 0x00, 0xA8, 0x00,
   0xA6, 0x00, 0x9D, 0x00, 0x9A, 0x00, 0x94, 0x00, 0x89, 0x00, 0x88, 0x00,
   0x78, 0x00, 0x77, 0x00, 0x69, 0x00, 0x62, 0x00, 0x57, 0x00, 0x4D, 0x00,
   0x45, 0x00, 0x36, 0x00, 0x32, 0x00, 0x1E, 0x00, 0x1D, 0x00, 0x08, 0x00,
   0x05, 0x00, 0xF4, 0xFF, 0xED, 0xFF, 0xE0, 0xFF, 0xD6, 0xFF, 0xC9, 0xFF,
   0xC3, 0xFF, 0xB4, 0xFF, 0xB0, 0xFF, 0x9E, 0xFF, 0x9E, 0xFF, 0x8D, 0xFF,
   0x8E, 0xFF, 0x7D, 0xFF, 0x7E, 0xFF, 0x6F, 0xFF, 0x71, 0xFF, 0x65, 0xFF,
   0x65, 0xFF, 0x5D, 0xFF, 0x5C, 0xFF, 0x57, 0xFF, 0x56, 0xFF, 0x53, 0xFF,
   0x55, 0xFF, 0x50, 0xFF, 0x55, 0xFF, 0x52, 0xFF, 0x58, 0xFF, 0x57, 0xFF,
   0x5B, 0xFF, 0x60, 0xFF, 0x61, 0xFF, 0x6B, 0xFF, 0x6C, 0xFF, 0x74, 0xFF,
   0x7B, 0xFF, 0x80, 0xFF, 0x8A, 0xFF, 0x92, 0xFF, 0x98, 0xFF, 0xA4, 0xFF,
   0xAA, 0xFF, 0xB7, 0xFF, 0xBE, 0xFF, 0xCA, 0xFF, 0xD2, 0xFF, 0xDE, 0xFF,
   0xEA, 0xFF, 0xF1, 0xFF, 0xFE, 0xFF, 0x07, 0x00, 0x13, 0x00, 0x1D, 0x00,
   0x28, 0x00, 0x30, 0x00, 0x3C, 0x00, 0x45, 0x00, 0x4D, 0x00, 0x5A, 0x00,
   0x5C, 0x00, 0x6E, 0x00, 0x6B, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x85, 0x00,
   0x8C, 0x00, 0x8F, 0x00, 0x96, 0x00, 0x98, 0x00, 0x9F, 0x00, 0x9D, 0x00,
   0xA4, 0x00, 0xA2, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA5, 0x00, 0xA4, 0x00,
   0xA1, 0x00, 0xA1, 0x00, 0x9C, 0x00, 0x9A, 0x00, 0x96, 0x00, 0x90, 0x00,
   0x8C, 0x00, 0x87, 0x00, 0x7F, 0x00, 0x7A, 0x00, 0x70, 0x00, 0x6C, 0x00,
   0x61, 0x00, 0x5C, 0x00, 0x4F, 0x00, 0x4A, 0x00, 0x3C, 0x00, 0x39, 0x00,
   0x28, 0x00, 0x25, 0x00, 0x15, 0x00, 0x10, 0x00, 0x02, 0x00, 0xFB, 0xFF,
   0xEE, 0xFF, 0xE7, 0xFF, 0xDB, 0xFF, 0xD3, 0xFF, 0xC8, 0xFF, 0xC0, 0xFF,
   0xB5, 0xFF, 0xB0, 0xFF, 0xA4, 0xFF, 0x9F, 0xFF, 0x95, 0xFF, 0x8F, 0xFF,
   0x89, 0xFF, 0x82, 0xFF, 0x7D, 0xFF, 0x77, 0xFF, 0x72, 0xFF, 0x71, 0xFF,
   0x69, 0xFF, 0x6A, 0xFF, 0x66, 0xFF, 0x64, 0xFF, 0x65, 0xFF, 0x62, 0xFF,
   0x64, 0xFF, 0x63, 0xFF, 0x67, 0xFF, 0x67, 0xFF, 0x6B, 0xFF, 0x6D, 0xFF,
   0x71, 0xFF, 0x76, 0xFF, 0x7A, 0xFF, 0x81, 0xFF, 0x84, 0xFF, 0x8E, 0xFF,
   0x91, 0xFF, 0x9B, 0xFF, 0xA1, 0xFF, 0xAB, 0xFF, 0xB0, 0xFF, 0xBC, 0xFF,
   0xC2, 0xFF, 0xCD, 0xFF, 0xD5, 0xFF, 0xE0, 0xFF, 0xE5, 0xFF, 0xF6, 0xFF,
   0xF7, 0xFF, 0x0A, 0x00, 0x09, 0x00, 0x1D, 0x00, 0x1D, 0x00, 0x2E, 0x00,
   0x32, 0x00, 0x3C, 0x00, 0x46, 0x00, 0x4C, 0x00, 0x57, 0x00, 0x5B, 0x00,
   0x65, 0x00, 0x6A, 0x00, 0x72, 0x00, 0x76, 0x00, 0x7E, 0x00, 0x7F, 0x00,
   0x88, 0x00, 0x88, 0x00, 0x8E, 0x00, 0x90, 0x00, 0x91, 0x00, 0x94, 0x00,
   0x94, 0x00, 0x96, 0x00, 0x94, 0x00, 0x96, 0x00, 0x91, 0x00, 0x93, 0x00,
   0x8C, 0x00, 0x8E, 0x00, 0x87, 0x00, 0x84, 0x00, 0x81, 0x00, 0x78, 0x00,
   0x77, 0x00, 0x6E, 0x00, 0x69, 0x00, 0x61, 0x00, 0x5C, 0x00, 0x51, 0x00,
   0x4D, 0x00, 0x43, 0x00, 0x3A, 0x00, 0x33, 0x00, 0x2A, 0x00, 0x1F, 0x00,
   0x19, 0x00, 0x0D, 0x00, 0x07, 0x00, 0xFC, 0xFF, 0xF3, 0xFF, 0xEA, 0xFF,
   0xE1, 0xFF, 0xD8, 0xFF, 0xD2, 0xFF, 0xC5, 0xFF, 0xC1, 0xFF, 0xB7, 0xFF,
   0xAF, 0xFF, 0xAB, 0xFF, 0x9E, 0xFF, 0x9F, 0xFF, 0x92, 0xFF, 0x91, 0xFF,
   0x8A, 0xFF, 0x86, 0xFF, 0x80, 0xFF, 0x7F, 0xFF, 0x78, 0xFF, 0x7A, 0xFF,
   0x73, 0xFF, 0x76, 0xFF, 0x70, 0xFF, 0x76, 0xFF, 0x6E, 0xFF, 0x77, 0xFF,
   0x70, 0xFF, 0x7A, 0xFF, 0x74, 0xFF, 0x7E, 0xFF, 0x7C, 0xFF, 0x84, 0xFF,
   0x84, 0xFF, 0x8C, 0xFF, 0x90, 0xFF, 0x96, 0xFF, 0x9D, 0xFF, 0xA0, 0xFF,
   0xAB, 0xFF, 0xAE, 0xFF, 0xBB, 0xFF, 0xBC, 0xFF, 0xCA, 0xFF, 0xCE, 0xFF,
   0xD8, 0xFF, 0xDF, 0xFF, 0xE9, 0xFF, 0xF2, 0xFF, 0xF8, 0xFF, 0x07, 0x00,
   0x05, 0x00, 0x19, 0x00, 0x19, 0x00, 0x26, 0x00, 0x2D, 0x00, 0x34, 0x00,
   0x3D, 0x00, 0x44, 0x00, 0x4B, 0x00, 0x54, 0x00, 0x56, 0x00, 0x62, 0x00,
   0x62, 0x00, 0x6D, 0x00, 0x6D, 0x00, 0x77, 0x00, 0x75, 0x00, 0x7F, 0x00,
   0x7B, 0x00, 0x85, 0x00, 0x81, 0x00, 0x87, 0x00, 0x86, 0x00, 0x86, 0x00,
   0x88, 0x00, 0x85, 0x00, 0x86, 0x00, 0x84, 0x00, 0x81, 0x00, 0x7F, 0x00,
   0x7C, 0x00, 0x78, 0x00, 0x75, 0x00, 0x6F, 0x00, 0x6C, 0x00, 0x64, 0x00,
   0x61, 0x00, 0x5A, 0x00, 0x53, 0x00, 0x4D, 0x00, 0x45, 0x00, 0x3F, 0x00,
   0x37, 0x00, 0x2F, 0x00, 0x27, 0x00, 0x1F, 0x00, 0x18, 0x00, 0x0E, 0x00,
   0x08, 0x00, 0xFD, 0xFF, 0xF7, 0xFF, 0xEE, 0xFF, 0xE6, 0xFF, 0xDE, 0xFF,
   0xD6, 0xFF, 0xD0, 0xFF, 0xC4, 0xFF, 0xC5, 0xFF, 0xB4, 0xFF, 0xB5, 0xFF,
   0xAD, 0xFF, 0xA4, 0xFF, 0xA3, 0xFF, 0x9A, 0xFF, 0x96, 0xFF, 0x93, 0xFF,
   0x8F, 0xFF, 0x89, 0xFF, 0x8A, 0xFF, 0x83, 0xFF, 0x84, 0xFF, 0x82, 0xFF,
   0x7F, 0xFF, 0x81, 0xFF, 0x80, 0xFF, 0x80, 0xFF, 0x81, 0xFF, 0x83, 0xFF,
   0x83, 0xFF, 0x89, 0xFF, 0x89, 0xFF, 0x8E, 0xFF, 0x90, 0xFF, 0x96, 0xFF,
   0x99, 0xFF, 0x9F, 0xFF, 0xA4, 0xFF, 0xAB, 0xFF, 0xAF, 0xFF, 0xB8, 0xFF,
   0xBA, 0xFF, 0xC7, 0xFF, 0xC8, 0xFF, 0xD6, 0xFF, 0xD6, 0xFF, 0xE4, 0xFF,
   0xE7, 0xFF, 0xF3, 0xFF, 0xF7, 0xFF, 0x01, 0x00, 0x08, 0x00, 0x10, 0x00,
   0x18, 0x00, 0x20, 0x00, 0x26, 0x00, 0x2F, 0x00, 0x35, 0x00, 0x3B, 0x00,
   0x44, 0x00, 0x47, 0x00, 0x53, 0x00, 0x50, 0x00, 0x5F, 0x00, 0x5A, 0x00,
   0x69, 0x00, 0x64, 0x00, 0x6E, 0x00, 0x6E, 0x00, 0x73, 0x00, 0x74, 0x00,
   0x77, 0x00, 0x77, 0x00, 0x7B, 0x00, 0x78, 0x00, 0x7B, 0x00, 0x79, 0x00,
   0x78, 0x00, 0x79, 0x00, 0x74, 0x00, 0x75, 0x00, 0x6F, 0x00, 0x6E, 0x00,
   0x6B, 0x00, 0x65, 0x00, 0x63, 0x00, 0x5B, 0x00, 0x59, 0x00, 0x53, 0x00,
   0x4C, 0x00, 0x47, 0x00, 0x41, 0x00, 0x39, 0x00, 0x34, 0x00, 0x2C, 0x00,
   0x25, 0x00, 0x1F, 0x00, 0x15, 0x00, 0x11, 0x00, 0x06, 0x00, 0x03, 0x00,
   0xF6, 0xFF, 0xF4, 0xFF, 0xE9, 0xFF, 0xE2, 0xFF, 0xDF, 0xFF, 0xD2, 0xFF,
   0xCF, 0xFF, 0xC9, 0xFF, 0xBE, 0xFF, 0xBF, 0xFF, 0xB3, 0xFF, 0xB0, 0xFF,
   0xAD, 0xFF, 0xA3, 0xFF, 0xA4, 0xFF, 0x9C, 0xFF, 0x9B, 0xFF, 0x96, 0xFF,
   0x94, 0xFF, 0x92, 0xFF, 0x8E, 0xFF, 0x8F, 0xFF, 0x8C, 0xFF, 0x8D, 0xFF,
   0x8B, 0xFF, 0x8E, 0xFF, 0x8B, 0xFF, 0x90, 0xFF, 0x8F, 0xFF, 0x92, 0xFF,
   0x94, 0xFF, 0x9A, 0xFF, 0x98, 0xFF, 0xA1, 0xFF, 0xA0, 0xFF, 0xA9, 0xFF,
   0xAB, 0xFF, 0xB2, 0xFF, 0xB5, 0xFF, 0xBE, 0xFF, 0xBF, 0xFF, 0xCC, 0xFF,
   0xCB, 0xFF, 0xD7, 0xFF, 0xDB, 0xFF, 0xE3, 0xFF, 0xEB, 0xFF, 0xEF, 0xFF,
   0xF9, 0xFF, 0xFD, 0xFF, 0x07, 0x00, 0x0E, 0x00, 0x13, 0x00, 0x1B, 0x00,
   0x22, 0x00, 0x26, 0x00, 0x32, 0x00, 0x32, 0x00, 0x3D, 0x00, 0x40, 0x00,
   0x45, 0x00, 0x4E, 0x00, 0x4E, 0x00, 0x56, 0x00, 0x5A, 0x00, 0x5B, 0x00,
   0x64, 0x00, 0x61, 0x00, 0x68, 0x00, 0x69, 0x00, 0x6A, 0x00, 0x6D, 0x00,
   0x6D, 0x00, 0x6F, 0x00, 0x6D, 0x00, 0x70, 0x00, 0x6B, 0x00, 0x6E, 0x00,
   0x6A, 0x00, 0x69, 0x00, 0x67, 0x00, 0x63, 0x00, 0x61, 0x00, 0x5D, 0x00,
   0x59, 0x00, 0x56, 0x00, 0x4F, 0x00, 0x4D, 0x00, 0x46, 0x00, 0x41, 0x00,
   0x3C, 0x00, 0x36, 0x00, 0x2E, 0x00, 0x2D, 0x00, 0x1F, 0x00, 0x20, 0x00,
   0x13, 0x00, 0x11, 0x00, 0x09, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0xF1, 0xFF,
   0xF1, 0xFF, 0xE5, 0xFF, 0xE2, 0xFF, 0xDA, 0xFF, 0xD4, 0xFF, 0xCF, 0xFF,
   0xC8, 0xFF, 0xC3, 0xFF, 0xBE, 0xFF, 0xB9, 0xFF, 0xB3, 0xFF, 0xB1, 0xFF,
   0xAA, 0xFF, 0xA8, 0xFF, 0xA6, 0xFF, 0x9F, 0xFF, 0xA2, 0xFF, 0x99, 0xFF,
   0x9D, 0xFF, 0x97, 0xFF, 0x9A, 0xFF, 0x96, 0xFF, 0x99, 0xFF, 0x95, 0xFF,
   0x9A, 0xFF, 0x96, 0xFF, 0x9E, 0xFF, 0x99, 0xFF, 0xA1, 0xFF, 0x9F, 0xFF,
   0xA4, 0xFF, 0xA8, 0xFF, 0xAA, 0xFF, 0xB0, 0xFF, 0xB1, 0xFF, 0xB9, 0xFF,
   0xBB, 0xFF, 0xC3, 0xFF, 0xC5, 0xFF, 0xCD, 0xFF, 0xD2, 0xFF, 0xD8, 0xFF,
   0xDD, 0xFF, 0xE5, 0xFF, 0xEA, 0xFF, 0xF0, 0xFF, 0xF9, 0xFF, 0xFB, 0xFF,
   0x07, 0x00, 0x07, 0x00, 0x15, 0x00, 0x12, 0x00, 0x21, 0x00, 0x20, 0x00,
   0x2A, 0x00, 0x2F, 0x00, 0x34, 0x00, 0x39, 0x00, 0x3F, 0x00, 0x42, 0x00,
   0x49, 0x00, 0x4B, 0x00, 0x51, 0x00, 0x52, 0x00, 0x59, 0x00, 0x57, 0x00,
   0x5F, 0x00, 0x5C, 0x00, 0x62, 0x00, 0x60, 0x00, 0x65, 0x00, 0x61, 0x00,
   0x66, 0x00, 0x62, 0x00, 0x63, 0x00, 0x64, 0x00, 0x5E, 0x00, 0x63, 0x00,
   0x59, 0x00, 0x5E, 0x00, 0x56, 0x00, 0x57, 0x00, 0x4F, 0x00, 0x51, 0x00,
   0x46, 0x00, 0x4A, 0x00, 0x3C, 0x00, 0x40, 0x00, 0x34, 0x00, 0x34, 0x00,
   0x2C, 0x00, 0x26, 0x00, 0x21, 0x00, 0x1C, 0x00, 0x14, 0x00, 0x10, 0x00,
   0x0A, 0x00, 0x01, 0x00, 0xFF, 0xFF, 0xF5, 0xFF, 0xF2, 0xFF, 0xEA, 0xFF,
   0xE7, 0xFF, 0xDD, 0xFF, 0xDB, 0xFF, 0xD4, 0xFF, 0xCE, 0xFF, 0xCC, 0xFF,
   0xC3, 0xFF, 0xC2, 0xFF, 0xBB, 0xFF, 0xB9, 0xFF, 0xB5, 0xFF, 0xAF, 0xFF,
   0xB0, 0xFF, 0xA9, 0xFF, 0xAA, 0xFF, 0xA5, 0xFF, 0xA6, 0xFF, 0xA2, 0xFF,
   0xA3, 0xFF, 0xA2, 0xFF, 0xA0, 0xFF, 0xA2, 0xFF, 0xA2, 0xFF, 0xA1, 0xFF,
   0xA6, 0xFF, 0xA3, 0xFF, 0xAA, 0xFF, 0xA6, 0xFF, 0xAF, 0xFF, 0xAC, 0xFF,
   0xB4, 0xFF, 0xB5, 0xFF, 0xB9, 0xFF, 0xBE, 0xFF, 0xC2, 0xFF, 0xC5, 0xFF,
   0xCD, 0xFF, 0xCF, 0xFF, 0xD5, 0xFF, 0xDC, 0xFF, 0xDE, 0xFF, 0xE7, 0xFF,
   0xEB, 0xFF, 0xF0, 0xFF, 0xF8, 0xFF, 0xFB, 0xFF, 0x03, 0x00, 0x08, 0x00,
   0x0E, 0x00, 0x13, 0x00, 0x18, 0x00, 0x21, 0x00, 0x21, 0x00, 0x2C, 0x00,
   0x2B, 0x00, 0x35, 0x00, 0x35, 0x00, 0x3F, 0x00, 0x3D, 0x00, 0x46, 0x00,
   0x46, 0x00, 0x4B, 0x00, 0x4D, 0x00, 0x52, 0x00, 0x52, 0x00, 0x55, 0x00,
   0x57, 0x00, 0x56, 0x00, 0x5C, 0x00, 0x59, 0x00, 0x59, 0x00, 0x5C, 0x00,
   0x56, 0x00, 0x5D, 0x00, 0x55, 0x00, 0x59, 0x00, 0x52, 0x00, 0x55, 0x00,
   0x4F, 0x00, 0x4D, 0x00, 0x4C, 0x00, 0x46, 0x00, 0x43, 0x00, 0x43, 0x00,
   0x37, 0x00, 0x3B, 0x00, 0x31, 0x00, 0x2E, 0x00, 0x2A, 0x00, 0x24, 0x00,
   0x1E, 0x00, 0x1C, 0x00, 0x11, 0x00, 0x12, 0x00, 0x08, 0x00, 0x04, 0x00,
   0xFF, 0xFF, 0xF9, 0xFF, 0xF2, 0xFF, 0xF2, 0xFF, 0xE4, 0xFF, 0xE7, 0xFF,
   0xDD, 0xFF, 0xDA, 0xFF, 0xD5, 0xFF, 0xD1, 0xFF, 0xC9, 0xFF, 0xCC, 0xFF,
   0xBF, 0xFF, 0xC4, 0xFF, 0xB9, 0xFF, 0xBC, 0xFF, 0xB4, 0xFF, 0xB6, 0xFF,
   0xB0, 0xFF, 0xB0, 0xFF, 0xAE, 0xFF, 0xAB, 0xFF, 0xAD, 0xFF, 0xAA, 0xFF,
   0xAB, 0xFF, 0xAA, 0xFF, 0xAA, 0xFF, 0xAC, 0xFF, 0xAC, 0xFF, 0xAE, 0xFF,
   0xAF, 0xFF, 0xB1, 0xFF, 0xB4, 0xFF, 0xB5, 0xFF, 0xBA, 0xFF, 0xBB, 0xFF,
   0xC0, 0xFF, 0xC2, 0xFF, 0xC9, 0xFF, 0xC7, 0xFF, 0xD3, 0xFF, 0xD1, 0xFF,
   0xDA, 0xFF, 0xDC, 0xFF, 0xE2, 0xFF, 0xE7, 0xFF, 0xEC, 0xFF, 0xF2, 0xFF,
   0xF5, 0xFF, 0xFC, 0xFF, 0x02, 0x00, 0x04, 0x00, 0x0D, 0x00, 0x10, 0x00,
   0x15, 0x00, 0x1C, 0x00, 0x1D, 0x00, 0x25, 0x00, 0x2A, 0x00, 0x2B, 0x00,
   0x33, 0x00, 0x33, 0x00, 0x3C, 0x00, 0x3A, 0x00, 0x41, 0x00, 0x43, 0x00,
   0x46, 0x00, 0x48, 0x00, 0x4B, 0x00, 0x4B, 0x00, 0x50, 0x00, 0x4E, 0x00,
   0x51, 0x00, 0x50, 0x00, 0x53, 0x00, 0x51, 0x00, 0x50, 0x00, 0x52, 0x00,
   0x4F, 0x00, 0x4E, 0x00, 0x4F, 0x00, 0x48, 0x00, 0x4C, 0x00, 0x45, 0x00,
   0x44, 0x00, 0x42, 0x00, 0x3D, 0x00, 0x3B, 0x00, 0x36, 0x00, 0x34, 0x00,
   0x2D, 0x00, 0x2D, 0x00, 0x24, 0x00, 0x24, 0x00, 0x1B, 0x00, 0x1A, 0x00,
   0x13, 0x00, 0x0F, 0x00, 0x09, 0x00, 0x06, 0x00, 0xFE, 0xFF, 0xFD, 0xFF,
   0xF4, 0xFF, 0xF2, 0xFF, 0xEC, 0xFF, 0xE6, 0xFF, 0xE5, 0xFF, 0xDC, 0xFF,
   0xDC, 0xFF, 0xD4, 0xFF, 0xD3, 0xFF, 0xCD, 0xFF, 0xCB, 0xFF, 0xC6, 0xFF,
   0xC4, 0xFF, 0xC1, 0xFF, 0xBD, 0xFF, 0xBD, 0xFF, 0xB8, 0xFF, 0xB8, 0xFF,
   0xB7, 0xFF, 0xB2, 0xFF, 0xB6, 0xFF, 0xB2, 0xFF, 0xB3, 0xFF, 0xB2, 0xFF,
   0xB3, 0xFF, 0xB2, 0xFF, 0xB7, 0xFF, 0xB2, 0xFF, 0xB9, 0xFF, 0xB7, 0xFF,
   0xBA, 0xFF, 0xBE, 0xFF, 0xBD, 0xFF, 0xC4, 0xFF, 0xC4, 0xFF, 0xC8, 0xFF,
   0xCB, 0xFF, 0xD1, 0xFF, 0xD0, 0xFF, 0xDB, 0xFF, 0xD7, 0xFF, 0xE2, 0xFF,
   0xE2, 0xFF, 0xEB, 0xFF, 0xEA, 0xFF, 0xF3, 0xFF, 0xF5, 0xFF, 0xFC, 0xFF,
   0x00, 0x00, 0x03, 0x00, 0x0A, 0x00, 0x0C, 0x00, 0x15, 0x00, 0x16, 0x00,
   0x19, 0x00, 0x23, 0x00, 0x20, 0x00, 0x2B, 0x00, 0x2B, 0x00, 0x2D, 0x00,
   0x35, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3D, 0x00, 0x3E, 0x00, 0x40, 0x00,
   0x45, 0x00, 0x42, 0x00, 0x49, 0x00, 0x45, 0x00, 0x4B, 0x00, 0x47, 0x00,
   0x4C, 0x00, 0x47, 0x00, 0x4C, 0x00, 0x46, 0x00, 0x4C, 0x00, 0x45, 0x00,
   0x46, 0x00, 0x46, 0x00, 0x3F, 0x00, 0x45, 0x00, 0x3A, 0x00, 0x3F, 0x00,
   0x36, 0x00, 0x36, 0x00, 0x33, 0x00, 0x2E, 0x00, 0x2D, 0x00, 0x25, 0x00,
   0x26, 0x00, 0x1E, 0x00, 0x1C, 0x00, 0x16, 0x00, 0x14, 0x00, 0x0D, 0x00,
   0x0C, 0x00, 0x03, 0x00, 0x02, 0x00, 0xFC, 0xFF, 0xF7, 0xFF, 0xF5, 0xFF,
   0xED, 0xFF, 0xEE, 0xFF, 0xE2, 0xFF, 0xE6, 0xFF, 0xDC, 0xFF, 0xDC, 0xFF,
   0xD8, 0xFF, 0xD1, 0xFF, 0xD2, 0xFF, 0xCC, 0xFF, 0xCA, 0xFF, 0xC9, 0xFF,
   0xC2, 0xFF, 0xC6, 0xFF, 0xBC, 0xFF, 0xC4, 0xFF, 0xB8, 0xFF, 0xC2, 0xFF,
   0xB6, 0xFF, 0xBE, 0xFF, 0xB7, 0xFF, 0xBC, 0xFF, 0xB9, 0xFF, 0xBC, 0xFF,
   0xB9, 0xFF, 0xBE, 0xFF, 0xBC, 0xFF, 0xC0, 0xFF, 0xC0, 0xFF, 0xC2, 0xFF,
   0xC6, 0xFF, 0xC5, 0xFF, 0xCD, 0xFF, 0xC9, 0xFF, 0xD4, 0xFF, 0xCF, 0xFF,
   0xDA, 0xFF, 0xD6, 0xFF, 0xE2, 0xFF, 0xDE, 0xFF, 0xE8, 0xFF, 0xE8, 0xFF,
   0xEF, 0xFF, 0xF1, 0xFF, 0xF7, 0xFF, 0xF9, 0xFF, 0x00, 0x00, 0x02, 0x00,
   0x08, 0x00, 0x0B, 0x00, 0x10, 0x00, 0x13, 0x00, 0x19, 0x00, 0x1B, 0x00,
   0x1F, 0x00, 0x25, 0x00, 0x25, 0x00, 0x2B, 0x00, 0x2D, 0x00, 0x30, 0x00,
   0x34, 0x00, 0x34, 0x00, 0x3A, 0x00, 0x37, 0x00, 0x40, 0x00, 0x3B, 0x00,
   0x40, 0x00, 0x41, 0x00, 0x40, 0x00, 0x43, 0x00, 0x42, 0x00, 0x43, 0x00,
   0x42, 0x00, 0x44, 0x00, 0x3E, 0x00, 0x44, 0x00, 0x3D, 0x00, 0x41, 0x00,
   0x3A, 0x00, 0x3C, 0x00, 0x38, 0x00, 0x37, 0x00, 0x33, 0x00, 0x32, 0x00,
   0x2E, 0x00, 0x2B, 0x00, 0x28, 0x00, 0x24, 0x00, 0x22, 0x00, 0x1D, 0x00,
   0x19, 0x00, 0x16, 0x00, 0x12, 0x00, 0x0E, 0x00, 0x09, 0x00, 0x06, 0x00,
   0x02, 0x00, 0xFD, 0xFF, 0xFA, 0xFF, 0xF6, 0xFF, 0xF0, 0xFF, 0xF0, 0xFF,
   0xE7, 0xFF, 0xE9, 0xFF, 0xDF, 0xFF, 0xE3, 0xFF, 0xD8, 0xFF, 0xDB, 0xFF,
   0xD4, 0xFF, 0xD3, 0xFF, 0xD0, 0xFF, 0xCC, 0xFF, 0xCD, 0xFF, 0xC6, 0xFF,
   0xCB, 0xFF, 0xC2, 0xFF, 0xC6, 0xFF, 0xC2, 0xFF, 0xC1, 0xFF, 0xC3, 0xFF,
   0xBF, 0xFF, 0xC3, 0xFF, 0xBE, 0xFF, 0xC3, 0xFF, 0xC0, 0xFF, 0xC4, 0xFF,
   0xC2, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xC6, 0xFF, 0xCD, 0xFF, 0xC9, 0xFF,
   0xD2, 0xFF, 0xCE, 0xFF, 0xD5, 0xFF, 0xD9, 0xFF, 0xDD, 0xFF, 0xE2, 0xFF,
   0xE7, 0xFF, 0xE9, 0xFF, 0xF1, 0xFF, 0xF1, 0xFF, 0xF5, 0xFF, 0xFA, 0xFF,
   0xF9, 0xFF, 0x00, 0x00, 0xFD, 0xFF
};

////////////////////////////////////////////////////////////
/// Methods for ProgressDialog
////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(ProgressDialog, wxDialog)
   EVT_BUTTON(wxID_CANCEL, ProgressDialog::OnCancel)
   EVT_BUTTON(wxID_OK, ProgressDialog::OnStop)
   EVT_CLOSE(ProgressDialog::OnCloseWindow)
END_EVENT_TABLE()  

//
// Constructor
//
ProgressDialog::ProgressDialog(const wxString & title, const wxString & message, ProgressDialogFlags flags)
: wxDialog(wxTheApp->GetTopWindow(),
           wxID_ANY,
           title,
           wxDefaultPosition,
           wxDefaultSize,
           wxDEFAULT_DIALOG_STYLE |
           wxFRAME_FLOAT_ON_PARENT),
   mLastValue(0),
   mDisable(NULL)
{
   wxBoxSizer *v;
   wxWindow *w;
   wxSize ds;

   // There's a problem where the focus is not returned to the window that had
   // it before creating this object.  The reason is not entirely understood
   // but if the dialog window never gets shown then the focus does not get
   // returned to the original window.  It seems to have something to do with
   // wxWindowDisabler as the problem doesn't occur when it isn't created.
   //
   // This never used to be a problem for us because we didn't actually create
   // the wxProgressDialog until after the elapsed time reached .5 seconds.
   // This also meant that the app modal state was not established until .5
   // seconds had passed.  This left a small window where the user would be able
   // to interact with the main window and possibly do things like get two
   // effects running at the same time.

   mHadFocus = wxWindow::FindFocus();

#if defined(__WXGTK__)
   // Under GTK, when applying any effect that prompts the user, it's more than
   // like that FindFocus() will return NULL.  So, make sure something has focus.
   if (GetParent()) {
      GetParent()->SetFocus();
   }
#endif

   SetExtraStyle(GetExtraStyle() | wxWS_EX_TRANSIENT);

   v = new wxBoxSizer(wxVERTICAL);

   mMessage = new wxStaticText(this,
                               wxID_ANY,
                               message,
                               wxDefaultPosition,
                               wxDefaultSize,                                  
                               wxALIGN_LEFT);
   v->Add(mMessage, 0, wxEXPAND | wxALL, 10);
   ds.y += mMessage->GetSize().y + 20;

   //
   //
   //
   mGauge = new wxGauge(this,
                        wxID_ANY,
                        1000,
                        wxDefaultPosition,
                        wxDefaultSize,
                        wxGA_HORIZONTAL);
   v->Add(mGauge, 0, wxEXPAND | wxLEFT | wxRIGHT | wxBOTTOM, 10);
   ds.y += mGauge->GetSize().y + 10;

   //
   //
   //
   wxFlexGridSizer *g = new wxFlexGridSizer(2, 2, 10, 10);

   w = new wxStaticText(this,
                        wxID_ANY,
                        _("Elapsed Time:"),
                        wxDefaultPosition,
                        wxDefaultSize,                                  
                        wxALIGN_RIGHT);
   g->Add(w, 0, wxALIGN_RIGHT);

   mElapsed = new wxStaticText(this,
                               wxID_ANY,
                               wxT("00:00:00"),
                               wxDefaultPosition,
                               wxDefaultSize,                                  
                               wxALIGN_LEFT);
   g->Add(mElapsed, 0, wxALIGN_LEFT);
   ds.y += mElapsed->GetSize().y + 10;
   
   //
   //
   //
   w = new wxStaticText(this,
                        wxID_ANY,
                        _("Remaining Time:"),
                        wxDefaultPosition,
                        wxDefaultSize,                                  
                        wxALIGN_RIGHT);
   g->Add(w, 0, wxALIGN_RIGHT);

   mRemaining = new wxStaticText(this,
                                 wxID_ANY,
                                 wxT("00:00:00"),
                                 wxDefaultPosition,
                                 wxDefaultSize,                                  
                                 wxALIGN_LEFT);
   g->Add(mRemaining, 0, wxALIGN_LEFT);

   v->Add(g, 0, wxALIGN_CENTER | wxLEFT | wxRIGHT | wxBOTTOM, 10);
   ds.y += mRemaining->GetSize().y + 10;

   wxBoxSizer *h = new wxBoxSizer(wxHORIZONTAL);

   if (!(flags & pdlgHideStopButton))
   {
      w = new wxButton(this, wxID_OK, _("Stop"));
      h->Add(w, 0, wxALIGN_RIGHT | wxRIGHT | wxBOTTOM, 10);
      ds.x += w->GetSize().x + 10;
   }
 
   if (!(flags & pdlgHideCancelButton))
   {
      w = new wxButton(this, wxID_CANCEL, _("Cancel"));
      h->Add(w, 0, wxALIGN_RIGHT | wxRIGHT | wxBOTTOM, 10);
      ds.x += w->GetSize().x + 10;
   }

   v->Add(h, 0, wxALIGN_RIGHT | wxRIGHT | wxBOTTOM, 10);

   ds.y += w->GetSize().y + 10;

   SetSizerAndFit(v);

   wxClientDC dc(this);
   dc.SetFont(wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT));
   long widthText = 0;
   dc.GetTextExtent(message, &widthText, NULL, NULL, NULL, NULL);
   ds.x = (wxCoord) wxMax(wxMax(3 * widthText / 2, 4 * ds.y / 3), 300);
   SetClientSize(ds);

   Centre(wxCENTER_FRAME | wxBOTH);

   mStartTime = wxGetLocalTimeMillis().GetValue();
   mLastUpdate = mStartTime;
   mCancel = false;
   mStop = false;

   Show(false);

   // Even though we won't necessarily show the dialog due to the the 500ms
   // delay, we MUST disable other windows/menus anyway since we run the risk
   // of allowing other tasks to run before this one is complete.
   mDisable = new wxWindowDisabler(this);

#if defined(__WXMAC__)
   // LL:  On the Mac, the parent windows get disabled, but they still respond
   //      to the close button being clicked and the application quit menu item
   //      is still enabled.  We do not want the parent window to be destroyed
   //      while we're active, so we have to kludge around a bit to keep this
   //      from happening.
   WindowRef windowRef = (WindowRef) MacGetWindowRef();
   if (windowRef) {
      SetWindowModality(windowRef, kWindowModalityAppModal, NULL);
      BeginAppModalStateForWindow(windowRef);
   }

   w = wxTheApp->GetTopWindow();
   if (w) {
      w = wxGetTopLevelParent(w);
      if (w) {
         wxFrame *f = wxStaticCast(w, wxFrame);
         if (f) {
            wxMenuBar *bar = f->GetMenuBar();
            if (bar) {
               bar->Enable(wxID_PREFERENCES, false);
               bar->Enable(wxID_EXIT, false);
            }
         }
      }
   }
#endif
}

//
// Destructor
//
ProgressDialog::~ProgressDialog()
{
   if (IsShown())
   {
      Show(false);

      Beep();
   }

#if defined(__WXMAC__)
   wxWindow *w = wxTheApp->GetTopWindow();
   if (w) {
      w = wxGetTopLevelParent(w);
      if (w) {
         wxFrame *f = wxStaticCast(w, wxFrame);
         if (f) {
            wxMenuBar *bar = f->GetMenuBar();
            if (bar) {
               bar->Enable(wxID_PREFERENCES, true);
               bar->Enable(wxID_EXIT, true);
            }
         }
      }
   }

   WindowRef windowRef = (WindowRef) MacGetWindowRef();
   if (windowRef) {
      EndAppModalStateForWindow(windowRef);
   }
#endif

   if (mDisable)
   {
      delete mDisable;
   }

#if defined(__WXGTK__)
   // Under GTK, when applying any effect that prompts the user, it's more than
   // like that FindFocus() will return NULL.  So, make sure something has focus.
   if (GetParent()) {
      GetParent()->SetFocus();
   }
#endif

   if (mHadFocus) {
      mHadFocus->SetFocus();
   }
}

//
// Show/Hide the dialog
//
// At least on the Mac, deleting the WindowDisabler before continuing to the
// base class is VERY important since menu items can remain in the disabled
// state.  This has to do with the Mac not honoring the Enable() if the
// application is still in a modal state.
//
// An example is generating a tone in an empty project.  The Export menus
// will not get enabled.
//
bool
ProgressDialog::Show(bool show)
{
   if (!show)
   {
      if (mDisable)
      {
         delete mDisable;
         mDisable = NULL;
      }
   }
   else
   {
      if (!mDisable)
      {
         mDisable = new wxWindowDisabler(this);
      }
   }

    return wxDialog::Show(show);
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(int value, const wxString & message)
{
   if (mCancel)
   {
      // for compatibility with old Update, that returned false on cancel
      return eProgressCancelled; 
   }
   else if (mStop)
   {
      return eProgressStopped;
   }

   SetMessage(message);

   if (value <= 0)
   {
      value = 1;
   }

   if (value > 1000)
   {
      value = 1000;
   }

   wxLongLong_t now = wxGetLocalTimeMillis().GetValue();
   wxLongLong_t elapsed = now - mStartTime;
   wxLongLong_t estimate = elapsed * 1000ll / value;
   wxLongLong_t remains = (estimate + mStartTime) - now;

   if (!IsShown() && elapsed > 500)
   {
      Show(true);
   }

   if (value != mLastValue)
   {
      mGauge->SetValue(value);
      mLastValue = value;
   }

   // Only update if a full second has passed.
   if (now - mLastUpdate > 1000)
   {
      wxTimeSpan tsElapsed(0, 0, 0, elapsed);
      wxTimeSpan tsRemains(0, 0, 0, remains);

      mElapsed->SetLabel(tsElapsed.Format(wxT("%H:%M:%S")));
      mRemaining->SetLabel(tsRemains.Format(wxT("%H:%M:%S")));

      mLastUpdate = now;
   }

   wxYieldIfNeeded();

   return eProgressSuccess;
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(double current, const wxString & message)
{
   return Update((int)(current * 1000), message);
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(wxULongLong_t current, wxULongLong_t total, const wxString & message)
{
   return Update((int)(current * 1000 / total), message);
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(wxLongLong current, wxLongLong total, const wxString & message)
{
   return Update((int)(current.GetValue() * 1000ll / total.GetValue()), message);
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(wxLongLong_t current, wxLongLong_t total, const wxString & message)
{
   return Update((int)(current * 1000ll / total), message);
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(int current, int total, const wxString & message)
{
   return Update((int)(current *  ((double)(1000.0 / total))), message);
}

//
// Update the time and, optionally, the message
//
int
ProgressDialog::Update(double current, double total, const wxString & message)
{
   return Update((int)(current * 1000.0 / total), message);
}

//
// Update the message text
//
void
ProgressDialog::SetMessage(const wxString & message)
{
   if (!message.IsEmpty())
   {
      mMessage->SetLabel(message);
      wxYieldIfNeeded();
   }
}

void
ProgressDialog::OnCancel(wxCommandEvent & e)
{
   FindWindowById(wxID_CANCEL, this)->Disable();
   mCancel = true;
}

void
ProgressDialog::OnStop(wxCommandEvent & e)
{
   FindWindowById(wxID_OK, this)->Disable();
   mCancel = false;
   mStop = true;
}

void
ProgressDialog::OnCloseWindow(wxCloseEvent & WXUNUSED(event))
{
   mCancel = true;
}

void
ProgressDialog::Beep()
{
   int after;
   bool should;
   wxString name;

   gPrefs->Read(wxT("/GUI/BeepOnCompletion"), &should, false);
   gPrefs->Read(wxT("/GUI/BeepAfterDuration"), &after, 60);
   gPrefs->Read(wxT("/GUI/BeepFileName"), &name, wxEmptyString);

   if (should && wxGetLocalTimeMillis().GetValue() - mStartTime > after * 1000)
   {
      wxBusyCursor busy;
      wxSound s;

      if (name.IsEmpty()) {
         s.Create(sizeof(beep), beep);
      }
      else {
         s.Create(name);
      }

      if (s.IsOk())
      {
         s.Play(wxSOUND_SYNC);
      }
   }
}

TimerProgressDialog::TimerProgressDialog(const wxLongLong_t duration, 
                                          const wxString & title, 
                                          const wxString & message /*= wxEmptyString*/, 
                                          ProgressDialogFlags flags /*= pdlgEmptyFlags*/)
: ProgressDialog(title, message, flags)
{
   mDuration = duration;
}

int TimerProgressDialog::Update(const wxString & message /*= wxEmptyString*/)
{
   if (mCancel)
   {
      // for compatibility with old Update, that returned false on cancel
      return eProgressCancelled; 
   }
   else if (mStop)
   {
      return eProgressStopped;
   }

   SetMessage(message);

   wxLongLong_t now = wxGetLocalTimeMillis().GetValue();
   wxLongLong_t elapsed = now - mStartTime;
   wxLongLong_t remains = mStartTime + mDuration - now;

   if (!IsShown() && elapsed > 500)
   {
      Show(true);
   }

   int nGaugeValue = (1000 * elapsed) / mDuration; // range = [0,1000]
   wxASSERT((nGaugeValue >= 0) && (nGaugeValue <= 1000));
   if (nGaugeValue != mLastValue)
   {
      mGauge->SetValue(nGaugeValue);
      mLastValue = nGaugeValue;
   }

   // Only update if a full second has passed.
   if (now - mLastUpdate > 1000)
   {
      wxTimeSpan tsElapsed(0, 0, 0, elapsed);
      wxTimeSpan tsRemains(0, 0, 0, remains);

      mElapsed->SetLabel(tsElapsed.Format(wxT("%H:%M:%S")));
      mRemaining->SetLabel(tsRemains.Format(wxT("%H:%M:%S")));

      mLastUpdate = now;
   }

   wxYieldIfNeeded();

   return eProgressSuccess;
}


// Indentation settings for Vim and Emacs and unique identifier for Arch, a
// version control system. Please do not modify past this point.
//
// Local Variables:
// c-basic-offset: 3
// indent-tabs-mode: nil
// End:
//
// vim: et sts=3 sw=3
// arch-tag: 2f4ec75c-bdb7-4889-96d1-5d00abc41027
