#!/usr/bin/env python
# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## stash config stuff in /etc/authtool/authtools.conf
#
# The main settings class
#

from Version import VERSION, INSTALLED

import sys
#CONFIG = "/etc/authtool/authtools.conf"
#CONFIG = "/home/ajmitch/SoC/authtool/authtools.conf"
#CONFIG = "/home/ajmitch/branches/authtool/authtools.conf"
try:
    if INSTALLED:
        CONFIG = "/etc/authtool/authtools.conf"
        sys.path.append('/usr/share/authtool')
    else:
        CONFIG = "data/authtools.conf"
except:
    CONFIG = "data/authtools.conf"
    #sys.path.append('AuthTool')
    #print sys.path

methods={}

import ConfigParser

class AuthConfig(object):

    def __init__(self, conffile=CONFIG):
        self.conffile = conffile
        self.cf = ConfigParser.SafeConfigParser()
        #try:
        self.cf.readfp(open(self.conffile))
        #except:
            #create a new config
            # Here are some nice defaults
        #    print "Creating default configuration"
        #    self.cf.set('DEFAULT','method', 'Local')


    def dump(self, section=None):
        for section in self.cf.sections():
            print "Section: %s" % section
            for key,value in self.cf.items(section):
                print "%s :\t%s" % (key, value)

    def save(self):

        self.cf.write(open(self.conffile,"w"))
        
            


    def __get_current(self):
        """Returns the current configuration method"""
        return self.cf.get('DEFAULT','method')

    def __set_current(self, value):
        """Returns the current configuration method"""
        return self.cf.set('DEFAULT','method',value)

    current = property(fget = __get_current,
                       fset = __set_current
                       )
    

if __name__=='__main__':
    ac = AuthConfig()
    ac.dump()
        

        
