#!/usr/bin/env python
# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## Configure /etc/nsswitch.conf ##
# See nsswitch.conf(5) for file details
import sys, preserve
#singleton class
class NSSwitchConfig:
    databases={}

    def __init__(self):
        
        fh = open("/etc/nsswitch.conf")
        self.nsslines = fh.readlines()
        for line in self.nsslines:
            # test for comment
            #print line.strip()
            if not (line.strip() == "" or line.strip()[0] == "#"):
                database = line.split(" ",1)[0].split(":")[0].strip()
                lookup = line.split(" ",1)[1:]
                for x in lookup:
                    lookup[lookup.index(x)] = x.strip()
                self.databases[database] = lookup
            #print self.nsslines[self.nsslines.index(line)].strip()
            self.nsslines[self.nsslines.index(line)] = self.nsslines[self.nsslines.index(line)].strip()

        #print self.nsslines
        fh.close()

    def dump(self):
        for db in self.databases:
            print "%s : %s" % (db, self.databases[db])
        for line in self.nsslines:
            print line

    def disable(self, database, dbs=None):
        if database == "ldap":
            dbs = ['passwd','group','shadow']
            # switch on nss_ldap for passwd, group, shadow (for now)
        elif database == "nis":
            dbs = ['passwd', 'group', 'shadow']
        elif database == "winbind":
            dbs = ['passwd', 'group']

        for db in dbs:
            # check if enabled:
            #print "Matching %s" % db
            for line in self.nsslines:
                if line.startswith(db):
                    if line.find(database) == -1:
                        print "%s not in %s" %(db, line)
                        # Our job here is done
                    else:
                        # time to remove it
                        # easiest to just do a regex replace on the db line
                        pass

    def enable(self, database, dbs=None):

        if database == "ldap":
            dbs = ['passwd','group','shadow']
            # switch on nss_ldap for passwd, group, shadow (for now)
        elif database == "nis":
            dbs = ['passwd', 'group', 'shadow']
        elif database == "winbind":
            dbs = ['passwd', 'group']
            
        for db in dbs:
            #check if ldap is enabled
            #add ldap to db list
            self.databases[db].append(' ' + database)
            #print "Matching %s" % db
            for line in self.nsslines:
                if line.startswith(db):
                    if line.find(database) == -1:
                        #print "%s not in %s" %(db, line)
                        self.nsslines[self.nsslines.index(line)].strip()
                        self.nsslines[self.nsslines.index(line)] += ' ' + database



    def disable(self, database):
        pass

    def save(self):
        preserve.preserve('/etc/nsswitch.conf')
        try:
            fh = open("/etc/nsswitch.conf", "w")
            c = True
        except IOError:
            fh = sys.stderr
            c = False
        for line in self.nsslines:
            line += '\n'
            fh.write(line)
        if c:
            fh.close()
            print "Closed"
        
if __name__=="__main__":
    nss = NSSwitchConfig()
    nss.enable('ldap')
    #nss.dump()
    nss.save()    
    
