#!/usr/bin/env python
# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## Configure /etc/samba/smb.conf ##
# See smb.conf(5) for file details
# Only need to change things in the [global] section
CONFIG="/etc/samba/smb.conf"

import sys, preserve
import ConfigParser

class SambaConfig:


    def __init__(self):
        self.cf = ConfigParser.ConfigParser()
        try:
            self.cf.readfp(open(CONFIG))
        except:
            pass


    def dump(self, section=None):
        print "Sections are :", self.cf.sections()
        for section in self.cf.sections():
            print "Section: %s" % section
            for key,value in self.cf.items(section):
                print "  %s :\t%s" % (key, value)

    def enable(self):
        pass

    def disable(self):
        pass

    def save(self):
        ## Base backup 
        preserve.preserve(CONFIG)
        try:
            self.cf.write(open(CONFIG, "w"))
        except:
            print "Saving failed"


if __name__ == '__main__':
    smb = SambaConfig()
    smb.cf.set('global', "security","ads")
    smb.cf.set('global', "workgroup","localdomain")
    smb.dump()
    smb.save()
