#!/usr/bin/env python

# Copyright (C) Andrew Mitchell 2006

#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.

#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
############################################################################

## client side: enable nss_ldap
## note: http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=375077

# manage /etc/ldap/ldap.conf
from AuthTool import nsswitch, config, authtools, dnsconfig
import debconf

config.methods['LDAP'] = 'LDAP/Kerberos Authentication'

class LDAPConfig(authtools.IAuthConfig):
    name = "LDAP"
    nss_switch = {'passwd':'ldap','group':'ldap','shadow':'ldap'}
    packages = ['libnss-ldap','nscd']
    requires = ["Kerberos"]
    display = True
    persistent = ['ldap_server','base_dn']

    ldap_server = 'ldap-server.localdomain'
    ldap_base_dn = 'DC=localdomain'
    
    def __init__(self, authconfig):

        self.cfg = authconfig

        #can only have *one* debconf instance
        # don't need to init right now
        #self.db = authtools.Debconf()

        # Various debconf settings for libnss-ldap.postinst
        # shared/ldapns/ldap-server
        # shared/ldapns/base-dn
        # shared/ldapns/ldap_version
        # libnss-ldap/dblogin
        # libnss-ldap/bindpw
        self.dns = dnsconfig.DNSConfig()
        # discover 
        discovery_servers =  self.dns.SRV('ldap')
        # process the server to a base DN
        # this is only a best-guess 
        base_dn = ""
        if discovery_servers['host'] != '':
            # strip off hostname
            parts = discovery_servers['host'].split('.')[1:]
            for part in parts:
                if part != '':
                    base_dn += "DC=%s," %part
            # trim trailing ','
            if base_dn[-1] == ',':
                base_dn = base_dn[:-1]
            #print "Discovered LDAP base DN is %s" % base_dn
            #print "Discovered LDAP server is %s" % discovery_servers['host']
            self.ldap_server = discovery_servers['host']
            self.ldap_base_dn = base_dn

        authtools.IAuthConfig.__init__(self,authconfig)

        

    def enable(self):
        # setup /etc/ldap/ldap.conf
        # setup /etc/libnss-ldap.conf (debconf)
        # setup /etc/nsswitch.conf
        
        nss = nsswitch.NSSwitchConfig()
        nss.enable('ldap')
        nss.save()    

    def disable(self):
        # setup /etc/libnss-ldap.conf (debconf)
        # setup /etc/nsswitch.conf

        nss = nsswitch.NSSwitchConfig()
        nss.disable('ldap')
        nss.save()    



    def config(self):
        """
        Return a list of configuration options in a standardised format
        {'id':['type','label',default','options'],...}
        """

        # Needs a set of 'simple questions'
        # Pull defaults from existing config
        cfg = {
            'ldap_server':['string', 'LDAP Server',self.ldap_server,''],
            'base_dn':['string', 'Base DN',self.ldap_base_dn,''],
             }
        return cfg


    def gtk_config(self, container):
        """Draw own config UI into the supplied container"""
        import gtk

        kids = container.get_children()
        for widget in kids:
            container.remove(widget)

        
        bt = gtk.Button("LDAP/Kerberos")
        container.add(bt)

        container.show_all()
        print container
        
                  

    
