dnl @synopsis AG_CHECK_POSIX_SYSINFO
dnl
dnl Check that the POSIX compliant sysinfo(2) call works properly.
dnl Linux has its own weirdo alternative.
dnl
dnl @category C
dnl @author Bruce Korb <bkorb@gnu.org>
dnl @version 2001-12-01
dnl @license GPLWithACException

dnl DO NOT EDIT THIS FILE   (ag_check_posix_sysinfo.m4)
dnl
dnl It has been AutoGen-ed  Saturday December  1, 2001 at 09:21:28 PM PST
dnl From the definitions    bkorb.def
dnl and the template file   conftest.tpl
dnl See: http://autogen.sf.net for a description of the AutoGen project

AC_DEFUN([AG_CHECK_POSIX_SYSINFO],[
  AC_MSG_CHECKING([whether sysinfo(2) is POSIX])
  AC_CACHE_VAL([ag_cv_posix_sysinfo],[
  AC_TRY_RUN([#include <sys/systeminfo.h>
int main() { char z[ 256 ];
long sz = sysinfo( SI_SYSNAME, z, sizeof( z ));
return (sz > 0) ? 0 : 1; }],[ag_cv_posix_sysinfo=yes],[ag_cv_posix_sysinfo=no],[ag_cv_posix_sysinfo=no]
  ) # end of TRY_RUN]) # end of CACHE_VAL

  AC_MSG_RESULT([$ag_cv_posix_sysinfo])
  if test x$ag_cv_posix_sysinfo = xyes
  then
    AC_DEFINE(HAVE_POSIX_SYSINFO, 1,
       [Define this if sysinfo(2) is POSIX])
  fi
]) # end of AC_DEFUN of AG_CHECK_POSIX_SYSINFO
