# Autoinstaller boot setup code for setting up GRUB.

# Copyright (c) 2001 Progeny Linux Systems, Inc.
# Written by Jeff Licquia.

import string
import os

def runcmd(cmd):
    cmdresult = os.system(cmd)
    if cmdresult != 0:
        raise RuntimeError, "Error in executing %s, exit status %d" % (cmd, cmdresult)

def setup_boot_loader(stanzas):

    progeny = 0
    
    # For now, we only deal with one stanza, and we let update-grub deal
    # with the kernels.
    device_num_str = ""
    rootdrv = stanzas[0]["rootdev"]
    #bootdrv = rootdrv
    bootdrv = stanzas[0]["bootdev"]
    while bootdrv[-1] in string.digits:
        device_num_str = bootdrv[-1] + device_num_str
        bootdrv = bootdrv[:-1]
    device_num = int(device_num_str) - 1

    os.mkdir("/target/boot/grub")

    if os.path.isdir("/target/usr/share/grub"):
        grub_file_path = "/target/usr/share/grub"
    elif os.path.isdir("/target/usr/lib/grub"):
        grub_file_path = "/target/usr/lib/grub"
    elif os.path.isdir("/target/lib/grub"):
        grub_file_path = "/target/lib/grub"
    else:
        raise RuntimeError, "cannot find GRUB boot files"

    runcmd("cp %s/i386-pc/* /target/boot/grub" % grub_file_path)

    runcmd("chroot /target /bin/sh -c 'echo quit | grub --batch --device-map=/boot/grub/device.map > /dev/null'")

    devicemap = open("/target/boot/grub/device.map")
    for deviceline in devicemap.readlines():
        (bootgrubdevice, bootgrubdevfile) = string.split(deviceline)
        if bootgrubdevfile[:len(bootdrv)] == bootdrv:
            break
    devicemap.close()

    rootgrubdevice = "%s,%d)" % (bootgrubdevice[:-1], device_num)

    grubshell = os.popen("chroot /target /bin/sh -c 'grub --batch --device-map=/boot/grub/device.map > /dev/null'", "w")
    grubshell.write("""
root %s
makeactive
setup %s
quit
""" % (rootgrubdevice, bootgrubdevice))
    grubshell.close()

    # Gather information for menu.lst.

    for bootfile in os.listdir("/target/boot"):
        if bootfile[:6] != "initrd":
            continue

        initrdpath = "/%s" % bootfile
        kversion = bootfile[string.index(bootfile, "-") + 1:-3]
        kernelpath = "/vmlinuz-%s" % kversion
        break

    # Write menu.lst.  Use the particular syntax of update-grub on
    # Progeny and regular Debian as necessary.

    if progeny:
        menulst = open("/target/boot/grub/menu.lst", "w")
        menulst.write("""
default 0
timeout 10

# --> PROGENY START (1.0) <--

# --> PROGENY END <--
""")
        menulst.close()
        runcmd("chroot /target /usr/sbin/update-grub")
    else:
        runcmd("chroot /target /bin/sh -c 'yes | /sbin/update-grub > /dev/null'")
        menulst_in = open("/target/boot/grub/menu.lst", "r")
        menulst_out = open("/target/boot/grub/menu.lst.new", "w")

        for line in menulst_in.readlines():
            if line[:7] == "# kopt=":
                outstr = "# kopt=root=%s ro\n" % (stanzas[0]["rootdev"],)
            elif line[:8] == "# groot=":
                outstr = "# groot=%s\n" % (rootgrubdevice,)
            else:
                outstr = line

            menulst_out.write(outstr)

        menulst_in.close()
        menulst_out.close()

        os.rename("/target/boot/grub/menu.lst",
                  "/target/boot/grub/menu.lst.pre-autoinst")
        os.rename("/target/boot/grub/menu.lst.new",
                  "/target/boot/grub/menu.lst")

        runcmd("chroot /target /sbin/update-grub")

        if stanzas[0]["rootdev"] != stanzas[0]["bootdev"]:
           menulst_in = open("/target/boot/grub/menu.lst", "r")
           menulst_out = open("/target/boot/grub/menu.lst.new", "w")
           for line in menulst_in.readlines():
               if line[:6] == "kernel":
                   outstr = string.replace(line, "/boot", "")
               elif line[:6] == "initrd":
                   outstr = string.replace(line, "/boot", "")
               else:
                   outstr = line
   
               menulst_out.write(outstr)
   
           menulst_in.close()
           menulst_out.close()
           os.rename("/target/boot/grub/menu.lst.new",
                     "/target/boot/grub/menu.lst")
