/*--------------------------------------------------------------------------*
 * AUTOPROFILE                                                              *
 *                                                                          *
 * A Gaim away message and profile manager that supports dynamic text       *
 *                                                                          *
 * AutoProfile is the legal property of its developers.  Please refer to    *
 * the COPYRIGHT file distributed with this source distribution.            *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA *
 *--------------------------------------------------------------------------*/

#include "component.h"
#include "utility.h"

/*---------- FORTUNE: Random quote grabber ----------*/
static GtkWidget *file_entry;

/* Read fortune file, parse and spit out random quote */
static char *fortune_generate ()
{
  GList *quotes, *quotes_start;
  char *ret;
  int num_quotes;

  int i, rand_times, index;

  int max = gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/fortune_size");

  quotes = read_fortune_file (
    gaim_prefs_get_string ("/plugins/gtk/autoprofile/components/fortune"), 
    max);

  /* Check for invalid file */
  num_quotes = g_list_length (quotes);
  
  if (num_quotes == 0) {
    auto_debug ("fortune", "no valid quotes in file");
    return NULL; 
  }  

  /* Increase randomness */
  srand ((unsigned) time (NULL));
  rand_times = rand () % 100;
  for (i = 0; i < rand_times; i++)
    rand ();

  /* Choose and output the quote */
  quotes_start = quotes;
  
  index = rand () % num_quotes;
  while (index != 0) {
    quotes = quotes->next;
    index--;
  }

  ret = strdup((char *) quotes->data); 
  free_string_list (quotes_start);

  return ret;
}

static gboolean fortune_update (GtkWidget *widget, GdkEventFocus *evt, 
                                gpointer data)
{
	gaim_prefs_set_string (
    "/plugins/gtk/autoprofile/components/fortune",
    gtk_entry_get_text (GTK_ENTRY (file_entry)));
  return FALSE;
}

static gboolean fortune_update_size (GtkWidget *widget, GdkEventFocus *evt, 
                                      gpointer data)
{
  gaim_prefs_set_int ("/plugins/gtk/autoprofile/components/fortune_size",
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget)));
  return FALSE;
}

static void fortune_filename (GtkWidget *widget, gpointer user_data) {
  GtkWidget *file_selector = (GtkWidget *)user_data;
  const gchar *selected_filename;

  selected_filename = gtk_file_selection_get_filename (
    GTK_FILE_SELECTION (file_selector));

  gaim_prefs_set_string ("/plugins/gtk/autoprofile/components/fortune",
    selected_filename);
  gtk_entry_set_text (GTK_ENTRY (file_entry), gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/fortune"));
}

/* Creates and pops up file selection dialog for fortune file */
static void fortune_file_selection (GtkWidget *widget, gpointer user_data) {
  GtkWidget *file_selector;
  const char *cur_file;

  /* Create the selector */
  file_selector = gtk_file_selection_new (
    "Select a file with quotes in fortune format");

  cur_file = gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/fortune");
  if (strlen (cur_file) > 1) {
    gtk_file_selection_set_filename (
      GTK_FILE_SELECTION (file_selector), cur_file); 
  }
  
  g_signal_connect (GTK_OBJECT(
                      GTK_FILE_SELECTION(file_selector)->ok_button),
                    "clicked", G_CALLBACK (fortune_filename),
                    (gpointer) file_selector);
   			   
  /* Destroy dialog box when the user clicks button. */
  g_signal_connect_swapped (GTK_OBJECT(
      GTK_FILE_SELECTION(file_selector)->ok_button), 
    "clicked", G_CALLBACK (gtk_widget_destroy), (gpointer) file_selector); 

  g_signal_connect_swapped (GTK_OBJECT (
      GTK_FILE_SELECTION (file_selector)->cancel_button), 
    "clicked", G_CALLBACK (gtk_widget_destroy), (gpointer) file_selector); 
   
  /* Display dialog */
  gtk_widget_show (file_selector);
}

/* Creates fortune preferences menu */
static GtkWidget *fortune_menu ()
{
  GtkWidget *ret = gtk_vbox_new (FALSE, 5);
  GtkWidget *hbox, *label, *button, *spinner;

  label = gtk_label_new (_("Select fortune quote database"));
  gtk_box_pack_start (GTK_BOX (ret), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label), 0, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (ret), hbox, FALSE, FALSE, 0);
  /* Text entry to type in file name */
  file_entry = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), file_entry, FALSE, FALSE, 0);
  gtk_entry_set_text (GTK_ENTRY (file_entry), gaim_prefs_get_string (
    "/plugins/gtk/autoprofile/components/fortune"));
  g_signal_connect (G_OBJECT (file_entry), "focus-out-event",
                    G_CALLBACK (fortune_update), NULL);
  /* Button to bring up file select dialog */
  button = gtk_button_new_with_label ("Browse ...");
  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (fortune_file_selection), NULL);

  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (ret), hbox, FALSE, FALSE, 0);
  label = gtk_label_new (_("Max fortune length: "));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  spinner = gtk_spin_button_new_with_range (1, 1000, 1);
  gtk_box_pack_start (GTK_BOX (hbox), spinner, FALSE, FALSE, 0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spinner), gaim_prefs_get_int (
    "/plugins/gtk/autoprofile/components/fortune_size"));
  g_signal_connect (G_OBJECT (spinner), "value-changed",
                    G_CALLBACK (fortune_update_size), NULL);

  return ret;
}

static void fortune_init () {
  gaim_prefs_add_string ("/plugins/gtk/autoprofile/components/fortune","");
  gaim_prefs_add_int ("/plugins/gtk/autoprofile/components/fortune_size", 
    1000);
}

struct component fortune =
{
  N_("Fortune"),
  N_("Random fortune cookie text selected from text file, in fortune format"),
  'f',
  &fortune_generate,
  &fortune_init,
  NULL,
  NULL,
  &fortune_menu
};

